#
# TABLE STRUCTURE FOR: payment_gateway_transaction
#

DROP TABLE IF EXISTS `payment_gateway_transaction`;

CREATE TABLE `payment_gateway_transaction` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `vendor` text NOT NULL,
  `external_id` text NOT NULL,
  `method` text NOT NULL,
  `code_number` text NOT NULL,
  `customer_id` text NOT NULL,
  `no_services` text NOT NULL,
  `invoice` text NOT NULL,
  `reference` text NOT NULL,
  `payment_url` text NOT NULL,
  `transaction_time` text NOT NULL,
  `date_created` text NOT NULL,
  `expired` text NOT NULL,
  `instructions` text NOT NULL,
  `status_payment` text NOT NULL,
  `amount` text NOT NULL,
  `paid_at` text NOT NULL,
  `result` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2137 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1, 'Tripay', '117210-230301338', 'INDOMARET', '', '', '220823143133', '230301338', 'T150017782896PYW6T', 'https://tripay.co.id/checkout/T150017782896PYW6T', '1679361367', '', '1679404567', '', '', '187220', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (2, 'Tripay', '53598-230302267', 'ALFAMART', '', '', '221229141103', '230302267', 'T150017451896GA4UA', 'https://tripay.co.id/checkout/T150017451896GA4UA', '1677721825', '', '1677765025', '', '', '167067', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (3, 'Tripay', '325460-230401382', 'INDOMARET', '', '', '220824082614', '230401382', 'T150018127527SF3LX', 'https://tripay.co.id/checkout/T150018127527SF3LX', '1680930330', '', '1680973530', '', '', '227499', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (4, 'Tripay', '108739-230402044', 'ALFAMART', '', '', '220918153421', '230402044', 'T150018190275VGQUE', 'https://tripay.co.id/checkout/T150018190275VGQUE', '1681007452', '', '1681050652', '', '', '286895', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (5, 'Tripay', '135654-230502417', 'INDOMARET', '', '', '230413125633', '230502417', 'T150019243261KMEY8', 'https://tripay.co.id/checkout/T150019243261KMEY8', '1684666783', '', '1684709983', '', '', '167835', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (6, 'Tripay', '747262-230601402', 'ALFAMART', '', '', '220824100714', '230601402', 'T1500194016434BTVL', 'https://tripay.co.id/checkout/T1500194016434BTVL', '1685576225', '', '1685619425', '', '', '187448', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (7, 'Tripay', '62403-230821001', 'INDOMARET', '', '', '230630155736', '230821001', 'T1500110638077W5WA4', 'https://tripay.co.id/checkout/T1500110638077W5WA4', '1692606733', '', '1692649933', '', '', '122208', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (8, 'Tripay', '276588-240102834', 'ALFAMART', '', '', '231120154753', '240102834', 'T1500113077120D20EX', 'https://tripay.co.id/checkout/T1500113077120D20EX', '1704604731', '', '1704647931', '', '', '166877', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (9, 'Tripay', '721066-240203117', 'ALFAMART', '', '', '231219090396', '240203117', 'T150011361932119GWR', 'https://tripay.co.id/checkout/T150011361932119GWR', '1707266964', '', '1707310164', '', '', '167489', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (10, 'Tripay', '46081-240302360', 'INDOMARET', '', '', '230630155788', '240302360', 'T1500115342013HBF4V', 'https://tripay.co.id/checkout/T1500115342013HBF4V', '1714567444', '', '1714610644', '', '', '122294', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (11, 'Tripay', '132563-240402410', 'INDOMARET', '', '', '230630155788', '240402410', 'T15001153419008MAOU', 'https://tripay.co.id/checkout/T15001153419008MAOU', '1714567257', '', '1714610457', '', '', '121927', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (12, 'Tripay', '89335-240402955', 'DANA', '', '', '231219090270', '240402955', 'T1500115223341M0YAL', 'https://tripay.co.id/checkout/T1500115223341M0YAL', '1714022763', '', '1714065963', '', '', '167680', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (13, 'Tripay', '771970-240602598', 'QRIS2', '', '', '231020095525', '240602598', 'T1500116208089QB6AX', 'https://tripay.co.id/checkout/T1500116208089QB6AX', '1718014641', '', '1718057841', '', '', '227526', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (14, 'Tripay', '490304-240603363', 'ALFAMART', '', '', '240326122281', '240603363', 'T15001160942813GKM6', 'https://tripay.co.id/checkout/T15001160942813GKM6', '1717565427', '', '1717608627', '', '', '166856', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (15, 'Tripay', '545765-240702477', 'BCAVA', '', '', '230630155960', '240702477', 'T1500116581311KKKTF', 'https://tripay.co.id/checkout/T1500116581311KKKTF', '1719882495', '', '1719925695', '', '', '122890', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (16, 'Tripay', '989310-240703366', 'SHOPEEPAY', '', '', '240326122326', '240703366', 'T15001166998375DSAS', 'https://tripay.co.id/checkout/T15001166998375DSAS', '1720357047', '', '1720400247', '', '', '124098', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (17, 'Tripay', '746699-240703443', 'ALFAMART', '', '', '240326122406', '240703443', 'T1500116645379ODCB9', 'https://tripay.co.id/checkout/T1500116645379ODCB9', '1720149612', '', '1720192812', '', '', '166956', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (18, 'Tripay', '530084-240901466', 'SHOPEEPAY', '', '', '220825101518', '240901466', 'T1500118163561QDBSC', 'https://tripay.co.id/checkout/T1500118163561QDBSC', '1725941308', '', '1726027708', '', '', '191138', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (19, 'Tripay', '776542-241103196', 'ALFAMART', '', '', '240326122272', '241103196', 'T1500120251432GTCCB', 'https://tripay.co.id/checkout/T1500120251432GTCCB', '1733034086', '', '1733120486', '', '', '167358', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (20, 'Tripay', '396451-241103346', 'INDOMARET', '', '', '240517132216', '241103346', 'T1500120771983XKUYN', 'https://tripay.co.id/checkout/T1500120771983XKUYN', '1735617624', '', '1735704024', '', '', '121831', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (21, 'Tripay', '792901-241202031', 'BRIVA', '', '', '230131154468', '241202031', 'T1500120450733W2CTU', 'https://tripay.co.id/checkout/T1500120450733W2CTU', '1733828210', '', '1733914610', '', '', '228059', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (22, 'Tripay', '135392-241202195', 'MANDIRIVA', '', '', '230617125104', '241202195', 'T1500120503488E25ZO', 'https://tripay.co.id/checkout/T1500120503488E25ZO', '1734076428', '', '1734162828', '', '', '209608', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (23, 'Tripay', '655149-241204301', 'INDOMARET', '', '', '240915081505', '241204301', 'T15001202719267R0XN', 'https://tripay.co.id/checkout/T15001202719267R0XN', '1733110149', '', '1733196549', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (24, 'Tripay', '687659-250301615', 'BCAVA', '', '', '220825200235', '250301615', 'T1500122248827AKZQ5', 'https://tripay.co.id/checkout/T1500122248827AKZQ5', '1741827160', '', '1741913560', '', '', '123484', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (25, 'Tripay', '457729-250505554', 'BRIVA', '', '', '250122091149', '250505554', 'T15001234022646052L', 'https://tripay.co.id/checkout/T15001234022646052L', '1746455804', '', '1746542204', '', '', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (26, 'Tripay', '886312-250505838', 'DANA', '', '', '250226145842', '250505838', 'T1500123332231GGVOC', 'https://tripay.co.id/checkout/T1500123332231GGVOC', '1746275515', '', '1746361915', '', '', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (27, 'Tripay', '557382-250505919', 'INDOMARET', '', '', '240907151419', '250505919', 'T1500124263436UCP0F', 'https://tripay.co.id/checkout/T1500124263436UCP0F', '1748403384', '', '1748489784', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (28, 'Tripay', '202838-250603182', 'DANA', '', '', '240608143736', '250603182', 'T1500124452329OB0XY', 'https://tripay.co.id/checkout/T1500124452329OB0XY', '1749016682', '', '1749103082', '', '', '167806', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (29, 'Tripay', '935978-250619001', 'ALFAMART', '', '', '250612140720', '250619001', 'T1500124862087WILGU', 'https://tripay.co.id/checkout/T1500124862087WILGU', '1750403968', '', '1750490368', '', '', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (30, 'Tripay', '445145-250704675', 'BCAVA', '', '', '100104460', '250704675', 'T1500125686307AD8CU', 'https://tripay.co.id/checkout/T1500125686307AD8CU', '1753189596', '', '1753275996', '', '', '128340', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (31, 'Tripay', '488342-250704942', 'INDOMARET', '', '', '300016', '250704942', 'T1500125117484XJZGS', 'https://tripay.co.id/checkout/T1500125117484XJZGS', '1751420399', '', '1751506799', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (32, 'Tripay', '765874-250705030', 'INDOMARET', '', '', '100104720', '250705030', 'T1500125189178CSPVX', 'https://tripay.co.id/checkout/T1500125189178CSPVX', '1751610936', '', '1751697336', '', '', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (33, 'Tripay', '80959-250802340', 'INDOMARET', '', '', '231020102470', '250802340', 'T150012588767065EYU', 'https://tripay.co.id/checkout/T150012588767065EYU', '1754054105', '', '1754140505', '', '', '122163', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (34, 'Tripay', '184623-250803411', 'BCAVA', '', '', '100103291', '250803411', 'T1500125972317BG2CX', 'https://tripay.co.id/checkout/T1500125972317BG2CX', '1754306645', '', '1754393045', '', '', '252750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (35, 'Tripay', '123155-250803430', 'SHOPEEPAY', '', '', '100103325', '250803430', 'T1500125898855PDXCI', 'https://tripay.co.id/checkout/T1500125898855PDXCI', '1754097812', '', '1754184212', '', '', '169950', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (36, 'Tripay', '882557-250805151', 'DANA', '', '', '250520104437', '250805151', 'T1500126680189NHYXS', 'https://tripay.co.id/checkout/T1500126680189NHYXS', '1756967293', '', '1757053693', '', '', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (37, 'Tripay', '43018-250805532', 'DANA', '', '', '100105049', '250805532', 'T150012599069905QXS', 'https://tripay.co.id/checkout/T150012599069905QXS', '1754366877', '', '1754453277', '', '', '253750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (38, 'Tripay', '848843-250903672', 'ALFAMART', '', '', '100040', '250903672', 'T1500126772730NLEXJ', 'https://tripay.co.id/checkout/T1500126772730NLEXJ', '1757246915', '', '1757333315', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (39, 'Tripay', '321439-250904085', 'DANA', '', '', '100104068', '250904085', 'T1500126949907Z3KHD', 'https://tripay.co.id/checkout/T1500126949907Z3KHD', '1757899923', '', '1757986323', '', '', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (40, 'Tripay', '375298-250904134', 'MANDIRIVA', '', '', '100104078', '250904134', 'T1500126806200FVFVP', 'https://tripay.co.id/checkout/T1500126806200FVFVP', '1757378377', '', '1757464777', '', '', '129250', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (41, 'Tripay', '600667-250904279', 'INDOMARET', '', '', '100077', '250904279', 'T1500126759468FGXIF', 'https://tripay.co.id/checkout/T1500126759468FGXIF', '1757206272', '', '1757292672', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (42, 'Tripay', '703549-250904772', 'ALFAMART', '', '', '100118', '250904772', 'T15001267486173OYSI', 'https://tripay.co.id/checkout/T15001267486173OYSI', '1757156154', '', '1757242554', '', '', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (43, 'Tripay', '535476-250904835', 'BRIVA', '', '', '20250501044', '250904835', 'T1500126718811LNP9W', 'https://tripay.co.id/checkout/T1500126718811LNP9W', '1757067787', '', '1757154187', '', '', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (44, 'Tripay', '615022-250905654', 'DANA', '', '', '100105277', '250905654', 'T1500126941192JBFOD', 'https://tripay.co.id/checkout/T1500126941192JBFOD', '1757851807', '', '1757938207', '', '', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (45, 'Tripay', '888364-251101016', 'MANDIRIVA', '', '27', '200015', '251101016', 'T4646028010567RTDA7', 'https://tripay.co.id/checkout/T4646028010567RTDA7', '1761951724', '2025-11-01', '1762038123', '', 'PAID', '207125', '1761951812', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (46, 'Tripay', '604051-251101017', 'ALFAMART', '', '29', '100017', '251101017', 'T4646028011130UQGP7', 'https://tripay.co.id/checkout/T4646028011130UQGP7', '1761953189', '2025-11-01', '1762039469', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (47, 'Tripay', '677182-251101236', 'INDOMARET', '', '312', '20250501002', '251101236', 'T4646028051680P01M5', 'https://tripay.co.id/checkout/T4646028051680P01M5', '1762052022', '2025-11-02', '1762138421', '', 'PAID', '126750', '1762052078', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (48, 'Tripay', '590638-251101563', 'BRIVA', '', '664', '100246', '251101563', 'T4646028052644PN6K7', 'https://tripay.co.id/checkout/T4646028052644PN6K7', '1762053868', '2025-11-02', '1762140261', '', 'PAID', '167125', '1762054121', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (49, 'Tripay', '811397-251101247', 'QRIS2', '', '323', '20250501014', '251101247', 'T4646028062002EU5S9', 'https://tripay.co.id/checkout/T4646028062002EU5S9', '1762075481', '2025-11-02', '1762077281', '', 'PAID', '125000', '1762075554', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (50, 'Tripay', '822194-251101248', 'BRIVA', '', '324', '20250501015', '251101248', 'T4646028064064M9IAI', 'https://tripay.co.id/checkout/T4646028064064M9IAI', '1762080034', '2025-11-02', '1762166427', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (51, 'Tripay', '159374-251101601', 'INDOMARET', '', '703', '240909951554', '251101601', 'T4646028066562HWDL6', 'https://tripay.co.id/checkout/T4646028066562HWDL6', '1762084711', '2025-11-02', '1762171111', '', 'PAID', '166750', '1762084991', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (52, 'Tripay', '566359-251101691', 'INDOMARET', '', '793', '100291', '251101691', 'T46460280796740HNF3', 'https://tripay.co.id/checkout/T46460280796740HNF3', '1762136347', '2025-11-03', '1762222747', '', 'PAID', '93750', '1762136904', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (53, 'Tripay', '630994-251101349', 'INDOMARET', '', '437', '100104868', '251101349', 'T4646028082001FTWMD', 'https://tripay.co.id/checkout/T4646028082001FTWMD', '1762140337', '2025-11-03', '1762226737', '', 'PAID', '126750', '1762179894', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (54, 'Tripay', '433746-251101340', 'QRIS', '', '428', '100174', '251101340', 'T4646028084466MQHIG', 'https://tripay.co.id/checkout/T4646028084466MQHIG', '1762144933', '2025-11-03', '1762146733', '', 'PAID', '165952', '1762145060', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (55, 'Tripay', '338254-251101567', 'MANDIRIVA', '', '669', '250923092624', '251101567', 'T46460280877236JS4Z', 'https://tripay.co.id/checkout/T46460280877236JS4Z', '1762151654', '2025-11-03', '1762238046', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (56, 'Tripay', '377970-251101175', 'BSIVA', '', '241', '240907151424', '251101175', 'T4646028088034WU0QW', 'https://tripay.co.id/checkout/T4646028088034WU0QW', '1762152295', '2025-11-03', '1762162968', '', 'PAID', '127125', '1762152382', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (57, 'Tripay', '961221-251101043', 'ALFAMART', '', '66', '100028', '251101043', 'T4646028092650M5OPF', 'https://tripay.co.id/checkout/T4646028092650M5OPF', '1762161902', '2025-11-03', '1762248182', '', 'PAID', '126750', '1762222269', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (58, 'Tripay', '222469-251101308', 'ALFAMART', '', '390', '100155', '251101308', 'T4646028093657IR2YD', 'https://tripay.co.id/checkout/T4646028093657IR2YD', '1762164035', '2025-11-03', '1762250314', '', 'PAID', '126750', '1762164079', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (59, 'Tripay', '127347-251101660', 'INDOMARET', '', '762', '100281', '251101660', 'T4646028100226IWFEP', 'https://tripay.co.id/checkout/T4646028100226IWFEP', '1762175943', '2025-11-03', '1762262342', '', 'PAID', '68750', '1762176140', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (60, 'Tripay', '668779-251101659', 'INDOMARET', '', '761', '100280', '251101659', 'T4646028100322FEOSH', 'https://tripay.co.id/checkout/T4646028100322FEOSH', '1762176136', '2025-11-03', '1762262536', '', 'PAID', '68750', '1762176199', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (61, 'Tripay', '50181-251101102', 'QRIS2', '', '149', '100055', '251101102', 'T4646028103171QBLFE', 'https://tripay.co.id/checkout/T4646028103171QBLFE', '1762183220', '2025-11-03', '1762185019', '', 'PAID', '125000', '1762183258', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (62, 'Tripay', '517063-251101585', 'SHOPEEPAY', '', '687', '100255', '251101585', 'T4646028103874KTIGO', 'https://tripay.co.id/checkout/T4646028103874KTIGO', '1762186831', '2025-11-03', '1762190310', '', 'PAID', '126875', '1762187160', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (63, 'Tripay', '993012-251101651', 'SHOPEEPAY', '', '753', '251023142600', '251101651', 'T4646028103973ZLPHD', 'https://tripay.co.id/checkout/T4646028103973ZLPHD', '1762187389', '2025-11-03', '1762190869', '', 'PAID', '126875', '1762187498', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (64, 'Tripay', '600113-251101354', 'MANDIRIVA', '', '442', '100104922', '251101354', 'T4646028106854SORCC', 'https://tripay.co.id/checkout/T4646028106854SORCC', '1762212566', '2025-11-04', '1762298959', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (65, 'Tripay', '241203-251101354', 'MANDIRIVA', '', '442', '100104922', '251101354', 'T4646028106928M3HJ5', 'https://tripay.co.id/checkout/T4646028106928M3HJ5', '1762212820', '2025-11-04', '1762299220', '', 'PAID', '127125', '1762212943', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (66, 'Tripay', '855068-251101453', 'INDOMARET', '', '548', '100209', '251101453', 'T46460281108837NJSE', 'https://tripay.co.id/checkout/T46460281108837NJSE', '1762222200', '2025-11-04', '1762308600', '', 'PAID', '126750', '1762222353', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (67, 'Tripay', '890682-251101152', 'ALFAMART', '', '212', '100086', '251101152', 'T46460281139778WMJV', 'https://tripay.co.id/checkout/T46460281139778WMJV', '1762228441', '2025-11-04', '1762314721', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (68, 'Tripay', '673556-251101230', 'BCAVA', '', '306', '240907151451', '251101230', 'T4646028115379OHPV3', 'https://tripay.co.id/checkout/T4646028115379OHPV3', '1762231357', '2025-11-04', '1764521999', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (69, 'Tripay', '719139-251101248', 'BRIVA', '', '324', '20250501015', '251101248', 'T4646028119637USXFY', 'https://tripay.co.id/checkout/T4646028119637USXFY', '1762240421', '2025-11-04', '1762326814', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (70, 'Tripay', '632643-251101172', 'BCAVA', '', '237', '240907151421', '251101172', 'T4646028122190MSPNY', 'https://tripay.co.id/checkout/T4646028122190MSPNY', '1762246226', '2025-11-04', '1762332625', '', 'PAID', '127750', '1762246356', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (71, 'Tripay', '177897-251101533', 'DANA', '', '634', '240909951525', '251101533', 'T46460281224395G268', 'https://tripay.co.id/checkout/T46460281224395G268', '1762246829', '2025-11-04', '1762250308', '', 'PAID', '125000', '1762246853', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (72, 'Tripay', '230690-251101170', 'BCAVA', '', '234', '240907151418', '251101170', 'T46460281225430WWNR', 'https://tripay.co.id/checkout/T46460281225430WWNR', '1762247096', '2025-11-04', '1762333495', '', 'PAID', '127750', '1762247155', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (73, 'Tripay', '378620-251101059', 'BRIVA', '', '94', '240907151334', '251101059', 'T46460281265794FW0O', 'https://tripay.co.id/checkout/T46460281265794FW0O', '1762255575', '2025-11-04', '1762341969', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (74, 'Tripay', '969419-251101379', 'INDOMARET', '', '471', '240909951458', '251101379', 'T4646028126711U9VBD', 'https://tripay.co.id/checkout/T4646028126711U9VBD', '1762255797', '2025-11-04', '1762342197', '', 'PAID', '126750', '1762255904', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (75, 'Tripay', '497818-251101059', 'QRIS2', '', '94', '240907151334', '251101059', 'T4646028126715QDUT0', 'https://tripay.co.id/checkout/T4646028126715QDUT0', '1762255806', '2025-11-04', '1762257605', '', 'PAID', '125000', '1762255868', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (76, 'Tripay', '745612-251101320', 'SHOPEEPAY', '', '403', '240909951434', '251101320', 'T4646028127766DCMXL', 'https://tripay.co.id/checkout/T4646028127766DCMXL', '1762257530', '2025-11-04', '1762261010', '', 'PAID', '126875', '1762257663', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (77, 'Tripay', '461796-251101122', 'QRIS2', '', '171', '100066', '251101122', 'T4646028129551J3RRL', 'https://tripay.co.id/checkout/T4646028129551J3RRL', '1762260413', '2025-11-04', '1762262213', '', 'PAID', '205000', '1762260468', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (78, 'Tripay', '340626-251101469', 'INDOMARET', '', '567', '300052', '251101469', 'T46460281295659RZHV', 'https://tripay.co.id/checkout/T46460281295659RZHV', '1762260439', '2025-11-04', '1762346839', '', 'PAID', '126750', '1762340379', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (79, 'Tripay', '766430-251101229', 'INDOMARET', '', '305', '240907151450', '251101229', 'T46460281298397K5E1', 'https://tripay.co.id/checkout/T46460281298397K5E1', '1762260925', '2025-11-04', '1762347325', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (80, 'Tripay', '821914-251101260', 'BRIVA', '', '337', '20250501028', '251101260', 'T4646028129933Z03LC', 'https://tripay.co.id/checkout/T4646028129933Z03LC', '1762261084', '2025-11-04', '1762347477', '', 'PAID', '127125', '1762261200', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (81, 'Tripay', '706044-251101233', 'INDOMARET', '', '309', '240907151454', '251101233', 'T4646028130083YBUSB', 'https://tripay.co.id/checkout/T4646028130083YBUSB', '1762261351', '2025-11-04', '1762347751', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (82, 'Tripay', '122223-251101233', 'INDOMARET', '', '309', '240907151454', '251101233', 'T4646028130102EWWSW', 'https://tripay.co.id/checkout/T4646028130102EWWSW', '1762261391', '2025-11-04', '1762347791', '', 'PAID', '126750', '1762262362', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (83, 'Tripay', '934447-251101152', 'ALFAMART', '', '212', '100086', '251101152', 'T46460281318175ZSCZ', 'https://tripay.co.id/checkout/T46460281318175ZSCZ', '1762264679', '2025-11-04', '1762350959', '', 'PAID', '126750', '1762264991', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (84, 'Tripay', '274096-251101605', 'MANDIRIVA', '', '707', '100263', '251101605', 'T4646028131899CWDWG', 'https://tripay.co.id/checkout/T4646028131899CWDWG', '1762264833', '2025-11-04', '1762351225', '', 'PAID', '127125', '1762265093', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (85, 'Tripay', '959414-251101499', 'BRIVA', '', '598', '100105340', '251101499', 'T4646028132418SLVME', 'https://tripay.co.id/checkout/T4646028132418SLVME', '1762266005', '2025-11-04', '1762352405', '', 'PAID', '127125', '1762266123', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (86, 'Tripay', '522911-251101493', 'INDOMARET', '', '592', '300055', '251101493', 'T4646028132451IORS3', 'https://tripay.co.id/checkout/T4646028132451IORS3', '1762266067', '2025-11-04', '1762352466', '', 'PAID', '126750', '1762266173', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (87, 'Tripay', '176318-251101053', 'BRIVA', '', '85', '240907151326', '251101053', 'T4646028137107HRELP', 'https://tripay.co.id/checkout/T4646028137107HRELP', '1762296069', '2025-11-05', '1762382462', '', 'PAID', '127125', '1762296151', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (88, 'Tripay', '90462-251102001', 'INDOMARET', '', '743', '100105663', '251102001', 'T4646028138194WBYAG', 'https://tripay.co.id/checkout/T4646028138194WBYAG', '1762299913', '2025-11-05', '1762386313', '', 'PAID', '126750', '1762302822', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (89, 'Tripay', '720163-251101015', 'DANA', '', '23', '200013', '251101015', 'T4646028138366C8LAR', 'https://tripay.co.id/checkout/T4646028138366C8LAR', '1762300427', '2025-11-05', '1762303907', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (90, 'Tripay', '129990-251101015', 'DANA', '', '23', '200013', '251101015', 'T4646028138415WWOPA', 'https://tripay.co.id/checkout/T4646028138415WWOPA', '1762300589', '2025-11-05', '1762304068', '', 'PAID', '125000', '1762300606', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (91, 'Tripay', '432863-251101099', 'BNIVA', '', '146', '240907151372', '251101099', 'T4646028139784GRI4N', 'https://tripay.co.id/checkout/T4646028139784GRI4N', '1762304027', '2025-11-05', '1762390300', '', 'PAID', '167125', '1762331040', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (92, 'Tripay', '550982-251101566', 'INDOMARET', '', '668', '100250', '251101566', 'T4646028139915ZHBDP', 'https://tripay.co.id/checkout/T4646028139915ZHBDP', '1762304418', '2025-11-05', '1762390818', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (93, 'Tripay', '599854-251101171', 'BRIVA', '', '236', '240907151420', '251101171', 'T4646028140423JQLV1', 'https://tripay.co.id/checkout/T4646028140423JQLV1', '1762305533', '2025-11-05', '1762391933', '', 'PAID', '127125', '1762305599', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (94, 'Tripay', '418499-251101334', 'BRIVA', '', '421', '300022', '251101334', 'T4646028140449VUKUU', 'https://tripay.co.id/checkout/T4646028140449VUKUU', '1762305589', '2025-11-05', '1762391989', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (95, 'Tripay', '477969-251101334', 'BRIVA', '', '421', '300022', '251101334', 'T4646028140510CHYID', 'https://tripay.co.id/checkout/T4646028140510CHYID', '1762305690', '2025-11-05', '1762392090', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (96, 'Tripay', '862730-251101334', 'BRIVA', '', '421', '300022', '251101334', 'T46460281405332LKGE', 'https://tripay.co.id/checkout/T46460281405332LKGE', '1762305729', '2025-11-05', '1762392129', '', 'PAID', '167125', '1762305781', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (97, 'Tripay', '757796-251101566', 'INDOMARET', '', '668', '100250', '251101566', 'T4646028141652IVIAX', 'https://tripay.co.id/checkout/T4646028141652IVIAX', '1762307981', '2025-11-05', '1762394381', '', 'PAID', '126750', '1762308055', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (98, 'Tripay', '542389-251105001', 'MANDIRIVA', '', '657', '100241', '251105001', 'T46460281418730JOOD', 'https://tripay.co.id/checkout/T46460281418730JOOD', '1762308413', '2025-11-05', '1762394805', '', 'PAID', '127125', '1762308582', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (99, 'Tripay', '36936-251101206', 'INDOMARET', '', '277', '100109', '251101206', 'T4646028143001GXHLN', 'https://tripay.co.id/checkout/T4646028143001GXHLN', '1762310607', '2025-11-05', '1762397006', '', 'PAID', '126750', '1762341952', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (100, 'Tripay', '417396-251101206', 'INDOMARET', '', '277', '100109', '251101206', 'T4646028143023X34DH', 'https://tripay.co.id/checkout/T4646028143023X34DH', '1762310658', '2025-11-05', '1762397058', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (101, 'Tripay', '852791-251101594', 'ALFAMART', '', '696', '240909951552', '251101594', 'T4646028143309VUGN1', 'https://tripay.co.id/checkout/T4646028143309VUGN1', '1762311301', '2025-11-05', '1762397580', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (102, 'Tripay', '943124-251101594', 'ALFAMART', '', '696', '240909951552', '251101594', 'T4646028143353O22NI', 'https://tripay.co.id/checkout/T4646028143353O22NI', '1762311377', '2025-11-05', '1762397657', '', 'PAID', '126750', '1762312089', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (103, 'Tripay', '23151-251101246', 'INDOMARET', '', '322', '20250501013', '251101246', 'T46460281440188REQH', 'https://tripay.co.id/checkout/T46460281440188REQH', '1762312704', '2025-11-05', '1762399104', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (104, 'Tripay', '183133-251101436', 'DANA', '', '529', '300042', '251101436', 'T4646028144237KK5YZ', 'https://tripay.co.id/checkout/T4646028144237KK5YZ', '1762313113', '2025-11-05', '1762316592', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (105, 'Tripay', '919061-251101368', 'INDOMARET', '', '459', '240909951450', '251101368', 'T4646028147744R56DW', 'https://tripay.co.id/checkout/T4646028147744R56DW', '1762319568', '2025-11-05', '1762405967', '', 'PAID', '126750', '1762347256', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (106, 'Tripay', '987374-251105002', 'DANA', '', '709', '100265', '251105002', 'T4646028148691YNKLU', 'https://tripay.co.id/checkout/T4646028148691YNKLU', '1762321079', '2025-11-05', '1762324558', '', 'PAID', '165000', '1762321145', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (107, 'Tripay', '428497-251101243', 'BNIVA', '', '319', '20250501009', '251101243', 'T4646028149244NFOVG', 'https://tripay.co.id/checkout/T4646028149244NFOVG', '1762322151', '2025-11-05', '1762408424', '', 'PAID', '127125', '1762322239', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (108, 'Tripay', '589008-251101623', 'MANDIRIVA', '', '725', '100273', '251101623', 'T46460281498210ELOL', 'https://tripay.co.id/checkout/T46460281498210ELOL', '1762323136', '2025-11-05', '1762409528', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (109, 'Tripay', '880902-251101623', 'QRIS2', '', '725', '100273', '251101623', 'T4646028149962D4NVR', 'https://tripay.co.id/checkout/T4646028149962D4NVR', '1762323348', '2025-11-05', '1762325148', '', 'PAID', '165000', '1762323398', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (110, 'Tripay', '681446-251101436', 'DANA', '', '529', '300042', '251101436', 'T4646028150376VFJ3T', 'https://tripay.co.id/checkout/T4646028150376VFJ3T', '1762324029', '2025-11-05', '1762327508', '', 'PAID', '125000', '1762324054', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (111, 'Tripay', '550415-251101276', 'INDOMARET', '', '355', '20250501046', '251101276', 'T4646028151401AJMO0', 'https://tripay.co.id/checkout/T4646028151401AJMO0', '1762325725', '2025-11-05', '1764521999', '', 'PAID', '166750', '1762354872', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (112, 'Tripay', '131748-251102002', 'DANA', '', '180', '240907151393', '251102002', 'T4646028151912P8OWW', 'https://tripay.co.id/checkout/T4646028151912P8OWW', '1762326663', '2025-11-05', '1762330142', '', 'PAID', '125000', '1762326728', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (113, 'Tripay', '69508-251101389', 'SHOPEEPAY', '', '482', '300030', '251101389', 'T4646028152584MQOVS', 'https://tripay.co.id/checkout/T4646028152584MQOVS', '1762327920', '2025-11-05', '1762331400', '', 'PAID', '126875', '1762327979', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (114, 'Tripay', '909716-251101434', 'BRIVA', '', '527', '240909951483', '251101434', 'T4646028153839EQSOM', 'https://tripay.co.id/checkout/T4646028153839EQSOM', '1762330377', '2025-11-05', '1762416769', '', 'PAID', '167125', '1762330695', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (115, 'Tripay', '724017-251101347', 'ALFAMART', '', '435', '100104865', '251101347', 'T4646028155413WBW7E', 'https://tripay.co.id/checkout/T4646028155413WBW7E', '1762333417', '2025-11-05', '1762419697', '', 'PAID', '126750', '1762333491', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (116, 'Tripay', '334633-251101176', 'INDOMARET', '', '242', '100103', '251101176', 'T4646028155986FUBKC', 'https://tripay.co.id/checkout/T4646028155986FUBKC', '1762334459', '2025-11-05', '1762420859', '', 'PAID', '126750', '1762336387', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (117, 'Tripay', '436614-251101267', 'INDOMARET', '', '344', '20250501035', '251101267', 'T4646028156606QLYGY', 'https://tripay.co.id/checkout/T4646028156606QLYGY', '1762335500', '2025-11-05', '1762421900', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (118, 'Tripay', '944593-251101248', 'BRIVA', '', '324', '20250501015', '251101248', 'T46460281566074ZMUM', 'https://tripay.co.id/checkout/T46460281566074ZMUM', '1762335502', '2025-11-05', '1762421894', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (119, 'Tripay', '921755-251101574', 'BRIVA', '', '676', '250923101136', '251101574', 'T4646028157114AUMK8', 'https://tripay.co.id/checkout/T4646028157114AUMK8', '1762336461', '2025-11-05', '1762422861', '', 'PAID', '167125', '1762336526', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (120, 'Tripay', '920812-251101290', 'BSIVA', '', '369', '250515102446', '251101290', 'T4646028157174CFWER', 'https://tripay.co.id/checkout/T4646028157174CFWER', '1762336574', '2025-11-05', '1762347254', '', 'PAID', '127125', '1762336679', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (121, 'Tripay', '312798-251101267', 'INDOMARET', '', '344', '20250501035', '251101267', 'T4646028157315W7XVG', 'https://tripay.co.id/checkout/T4646028157315W7XVG', '1762336799', '2025-11-05', '1762423198', '', 'PAID', '126750', '1762336896', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (122, 'Tripay', '338482-251101595', 'INDOMARET', '', '697', '300069', '251101595', 'T464602815873284DDM', 'https://tripay.co.id/checkout/T464602815873284DDM', '1762339005', '2025-11-05', '1762425405', '', 'PAID', '126750', '1762340007', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (123, 'Tripay', '415642-251101331', 'MANDIRIVA', '', '417', '240909951437', '251101331', 'T4646028158954NHF0U', 'https://tripay.co.id/checkout/T4646028158954NHF0U', '1762339381', '2025-11-05', '1762425773', '', 'PAID', '127125', '1762339852', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (124, 'Tripay', '695768-251101221', 'DANA', '', '297', '100121', '251101221', 'T4646028158975R11OG', 'https://tripay.co.id/checkout/T4646028158975R11OG', '1762339414', '2025-11-05', '1762342893', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (125, 'Tripay', '452811-251101221', 'DANA', '', '297', '100121', '251101221', 'T4646028159070JFOVO', 'https://tripay.co.id/checkout/T4646028159070JFOVO', '1762339586', '2025-11-05', '1762343065', '', 'PAID', '125000', '1762339604', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (126, 'Tripay', '584060-251101049', 'INDOMARET', '', '79', '100035', '251101049', 'T4646028159511W7U5V', 'https://tripay.co.id/checkout/T4646028159511W7U5V', '1762340266', '2025-11-05', '1762426665', '', 'PAID', '166750', '1762340355', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (127, 'Tripay', '571000-251101346', 'BRIVA', '', '434', '100104864', '251101346', 'T4646028160212JL2DE', 'https://tripay.co.id/checkout/T4646028160212JL2DE', '1762341344', '2025-11-05', '1762427743', '', 'PAID', '127125', '1762342069', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (128, 'Tripay', '869439-251101115', 'INDOMARET', '', '164', '2409071513', '251101115', 'T4646028160647WIFPW', 'https://tripay.co.id/checkout/T4646028160647WIFPW', '1762342086', '2025-11-05', '1762428486', '', 'PAID', '166750', '1762355978', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (129, 'Tripay', '378183-251101150', 'MANDIRIVA', '', '209', '240907151407', '251101150', 'T4646028160901SRDR7', 'https://tripay.co.id/checkout/T4646028160901SRDR7', '1762342529', '2025-11-05', '1762428920', '', 'PAID', '127125', '1762343165', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (130, 'Tripay', '380705-251101411', 'BRIVA', '', '504', '300035', '251101411', 'T464602816115751O1Z', 'https://tripay.co.id/checkout/T464602816115751O1Z', '1762342798', '2025-11-05', '1762429197', '', 'PAID', '127125', '1762343404', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (131, 'Tripay', '955004-251101411', 'BRIVA', '', '504', '300035', '251101411', 'T4646028161421VD5LS', 'https://tripay.co.id/checkout/T4646028161421VD5LS', '1762343196', '2025-11-05', '1762429596', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (132, 'Tripay', '446022-251101229', 'INDOMARET', '', '305', '240907151450', '251101229', 'T4646028163386XMUOG', 'https://tripay.co.id/checkout/T4646028163386XMUOG', '1762346008', '2025-11-05', '1762432408', '', 'PAID', '126750', '1762348319', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (133, 'Tripay', '455099-251101020', 'INDOMARET', '', '36', '200020', '251101020', 'T4646028166537UASKU', 'https://tripay.co.id/checkout/T4646028166537UASKU', '1762351762', '2025-11-05', '1762438161', '', 'PAID', '126750', '1762351862', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (134, 'Tripay', '626423-251101105', 'BCAVA', '', '152', '240907151376', '251101105', 'T4646028166658U7LKU', 'https://tripay.co.id/checkout/T4646028166658U7LKU', '1762352046', '2025-11-05', '1762438446', '', 'PAID', '127750', '1762352103', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (135, 'Tripay', '695343-251101500', 'BRIVA', '', '599', '100105412', '251101500', 'T4646028166976M8BXU', 'https://tripay.co.id/checkout/T4646028166976M8BXU', '1762352759', '2025-11-05', '1762439159', '', 'PAID', '127125', '1762352854', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (136, 'Tripay', '289751-251101042', 'DANA', '', '65', '240907151314', '251101042', 'T4646028167869FJROL', 'https://tripay.co.id/checkout/T4646028167869FJROL', '1762355248', '2025-11-05', '1762358727', '', 'PAID', '125000', '1762355276', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (137, 'Tripay', '875266-251101398', 'BRIVA', '', '491', '100194', '251101398', 'T4646028168923JPW4U', 'https://tripay.co.id/checkout/T4646028168923JPW4U', '1762359077', '2025-11-05', '1762445470', '', 'PAID', '127125', '1762359178', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (138, 'Tripay', '822626-251101008', 'ALFAMART', '', '10', '100003', '251101008', 'T464602817180851CRX', 'https://tripay.co.id/checkout/T464602817180851CRX', '1762381195', '2025-11-06', '1762467475', '', 'PAID', '166750', '1762404461', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (139, 'Tripay', '552233-251101304', 'INDOMARET', '', '384', '200277', '251101304', 'T4646028171966ABHEQ', 'https://tripay.co.id/checkout/T4646028171966ABHEQ', '1762381830', '2025-11-06', '1762468230', '', 'PAID', '126750', '1762414330', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (140, 'Tripay', '827508-251101048', 'BSIVA', '', '76', '100032', '251101048', 'T4646028172510MMXGH', 'https://tripay.co.id/checkout/T4646028172510MMXGH', '1762383920', '2025-11-06', '1762394594', '', 'PAID', '127125', '1762384076', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (141, 'Tripay', '513743-251101246', 'INDOMARET', '', '322', '20250501013', '251101246', 'T4646028174642IJSIQ', 'https://tripay.co.id/checkout/T4646028174642IJSIQ', '1762389965', '2025-11-06', '1762476362', '', 'PAID', '126750', '1762399836', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (142, 'Tripay', '932813-251101250', 'INDOMARET', '', '326', '20250501017', '251101250', 'T4646028175898W3VMV', 'https://tripay.co.id/checkout/T4646028175898W3VMV', '1762392684', '2025-11-06', '1762479084', '', 'PAID', '126750', '1762431923', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (143, 'Tripay', '888616-251101392', 'MANDIRIVA', '', '485', '300032', '251101392', 'T4646028178187RKHZW', 'https://tripay.co.id/checkout/T4646028178187RKHZW', '1762397397', '2025-11-06', '1762483792', '', 'PAID', '167125', '1762397734', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (144, 'Tripay', '19178-251101328', 'ALFAMART', '', '412', '100166', '251101328', 'T4646028178423VFPGF', 'https://tripay.co.id/checkout/T4646028178423VFPGF', '1762397850', '2025-11-06', '1762484129', '', 'PAID', '166750', '1762398187', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (145, 'Tripay', '146412-251101583', 'BRIVA', '', '685', '100254', '251101583', 'T4646028178470ZPWDC', 'https://tripay.co.id/checkout/T4646028178470ZPWDC', '1762397945', '2025-11-06', '1762484345', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (146, 'Tripay', '602231-251101583', 'DANA', '', '685', '100254', '251101583', 'T46460281784948P0XK', 'https://tripay.co.id/checkout/T46460281784948P0XK', '1762397978', '2025-11-06', '1762401457', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (147, 'Tripay', '378425-251101583', 'SHOPEEPAY', '', '685', '100254', '251101583', 'T464602817852363ZSC', 'https://tripay.co.id/checkout/T464602817852363ZSC', '1762398039', '2025-11-06', '1762401519', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (148, 'Tripay', '960761-251101583', 'BRIVA', '', '685', '100254', '251101583', 'T4646028178600LCJPA', 'https://tripay.co.id/checkout/T4646028178600LCJPA', '1762398206', '2025-11-06', '1762484598', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (149, 'Tripay', '390427-251101583', 'DANA', '', '685', '100254', '251101583', 'T46460281786503O5V0', 'https://tripay.co.id/checkout/T46460281786503O5V0', '1762398282', '2025-11-06', '1762401761', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (150, 'Tripay', '207838-251101583', 'BRIVA', '', '685', '100254', '251101583', 'T46460281786938R2GJ', 'https://tripay.co.id/checkout/T46460281786938R2GJ', '1762398391', '2025-11-06', '1762484787', '', 'PAID', '127125', '1762398713', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (151, 'Tripay', '842407-251101109', 'INDOMARET', '', '157', '100062', '251101109', 'T4646028178806HDSW4', 'https://tripay.co.id/checkout/T4646028178806HDSW4', '1762398628', '2025-11-06', '1762485027', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (152, 'Tripay', '919226-251101109', 'INDOMARET', '', '157', '100062', '251101109', 'T4646028178828I2C3W', 'https://tripay.co.id/checkout/T4646028178828I2C3W', '1762398669', '2025-11-06', '1762485068', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (153, 'Tripay', '204955-251101114', 'QRIS2', '', '163', '100064', '251101114', 'T4646028179432KK3P7', 'https://tripay.co.id/checkout/T4646028179432KK3P7', '1762399783', '2025-11-06', '1762401583', '', 'PAID', '250000', '1762399857', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (154, 'Tripay', '995382-251101112', 'MANDIRIVA', '', '160', '240907151378', '251101112', 'T4646028179503LBTXY', 'https://tripay.co.id/checkout/T4646028179503LBTXY', '1762399968', '2025-11-06', '1762486368', '', 'PAID', '127125', '1762400039', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (155, 'Tripay', '364973-251101139', 'QRIS2', '', '193', '240907151399', '251101139', 'T4646028179633WUYHO', 'https://tripay.co.id/checkout/T4646028179633WUYHO', '1762400223', '2025-11-06', '1762402023', '', 'PAID', '125000', '1762400264', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (156, 'Tripay', '959634-251101136', 'MANDIRIVA', '', '190', '240907151397', '251101136', 'T4646028179722BCOPJ', 'https://tripay.co.id/checkout/T4646028179722BCOPJ', '1762400391', '2025-11-06', '1762486784', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (157, 'Tripay', '83357-251101113', 'BCAVA', '', '162', '240907151380', '251101113', 'T46460281797882HNMB', 'https://tripay.co.id/checkout/T46460281797882HNMB', '1762400510', '2025-11-06', '1762486909', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (158, 'Tripay', '520724-251101113', 'BCAVA', '', '162', '240907151380', '251101113', 'T4646028179882PK50E', 'https://tripay.co.id/checkout/T4646028179882PK50E', '1762400683', '2025-11-06', '1762487083', '', 'PAID', '127750', '1762400746', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (159, 'Tripay', '903310-251101569', 'BCAVA', '', '671', '240909951538', '251101569', 'T4646028179953AWQEB', 'https://tripay.co.id/checkout/T4646028179953AWQEB', '1762400845', '2025-11-06', '1762487245', '', 'PAID', '127750', '1762400890', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (160, 'Tripay', '338858-251101284', 'INDOMARET', '', '363', '20250501054', '251101284', 'T4646028180110VGBN3', 'https://tripay.co.id/checkout/T4646028180110VGBN3', '1762401224', '2025-11-06', '1762487624', '', 'PAID', '126750', '1762401916', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (161, 'Tripay', '514251-251101185', 'BCAVA', '', '251', '240907151428', '251101185', 'T4646028180403WYVX6', 'https://tripay.co.id/checkout/T4646028180403WYVX6', '1762401940', '2025-11-06', '1762488340', '', 'PAID', '127750', '1762402003', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (162, 'Tripay', '275203-251101635', 'INDOMARET', '', '737', '250927092601', '251101635', 'T46460281804092AVTC', 'https://tripay.co.id/checkout/T46460281804092AVTC', '1762401961', '2025-11-06', '1762488361', '', 'PAID', '126750', '1762402038', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (163, 'Tripay', '553728-251101690', 'INDOMARET', '', '792', '240909951589', '251101690', 'T4646028180474NH4B5', 'https://tripay.co.id/checkout/T4646028180474NH4B5', '1762402100', '2025-11-06', '1762488499', '', 'PAID', '97750', '1762402150', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (164, 'Tripay', '513323-251101164', 'ALFAMART', '', '225', '240907151414', '251101164', 'T46460281805138PYHH', 'https://tripay.co.id/checkout/T46460281805138PYHH', '1762402181', '2025-11-06', '1762488461', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (165, 'Tripay', '775421-251101138', 'BCAVA', '', '192', '100076', '251101138', 'T4646028181213OWYKB', 'https://tripay.co.id/checkout/T4646028181213OWYKB', '1762403827', '2025-11-06', '1762490226', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (166, 'Tripay', '580984-251101008', 'ALFAMART', '', '10', '100003', '251101008', 'T4646028181228Y1LKV', 'https://tripay.co.id/checkout/T4646028181228Y1LKV', '1762403879', '2025-11-06', '1762490159', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (167, 'Tripay', '85134-251101138', 'BRIVA', '', '192', '100076', '251101138', 'T46460281813480VI1B', 'https://tripay.co.id/checkout/T46460281813480VI1B', '1762404143', '2025-11-06', '1762490532', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (168, 'Tripay', '254475-251101138', 'BRIVA', '', '192', '100076', '251101138', 'T4646028181397RDGQC', 'https://tripay.co.id/checkout/T4646028181397RDGQC', '1762404222', '2025-11-06', '1762490621', '', 'PAID', '127125', '1762404356', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (169, 'Tripay', '392142-251101194', 'BCAVA', '', '261', '240907151432', '251101194', 'T4646028183062XDWDS', 'https://tripay.co.id/checkout/T4646028183062XDWDS', '1762407301', '2025-11-06', '1762493701', '', 'PAID', '127750', '1762407474', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (170, 'Tripay', '149202-251101465', 'DANA', '', '561', '240909951495', '251101465', 'T4646028183197JDJTV', 'https://tripay.co.id/checkout/T4646028183197JDJTV', '1762407569', '2025-11-06', '1762411049', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (171, 'Tripay', '458905-251101465', 'DANA', '', '561', '240909951495', '251101465', 'T4646028183248PDDUE', 'https://tripay.co.id/checkout/T4646028183248PDDUE', '1762407659', '2025-11-06', '1762411138', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (172, 'Tripay', '827909-251101458', 'BNIVA', '', '553', '100210', '251101458', 'T4646028183348KJFCS', 'https://tripay.co.id/checkout/T4646028183348KJFCS', '1762407841', '2025-11-06', '1762494121', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (173, 'Tripay', '313108-251101465', 'QRIS2', '', '561', '240909951495', '251101465', 'T46460281835635ZA8W', 'https://tripay.co.id/checkout/T46460281835635ZA8W', '1762408273', '2025-11-06', '1762410073', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (174, 'Tripay', '153592-251101161', 'BCAVA', '', '222', '240907151413', '251101161', 'T4646028183617LUBPL', 'https://tripay.co.id/checkout/T4646028183617LUBPL', '1762408379', '2025-11-06', '1762494778', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (175, 'Tripay', '569959-251101161', 'BCAVA', '', '222', '240907151413', '251101161', 'T4646028183632LF07I', 'https://tripay.co.id/checkout/T4646028183632LF07I', '1762408417', '2025-11-06', '1762494816', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (176, 'Tripay', '485615-251101465', 'DANA', '', '561', '240909951495', '251101465', 'T4646028183864ZWTHS', 'https://tripay.co.id/checkout/T4646028183864ZWTHS', '1762408940', '2025-11-06', '1762412419', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (177, 'Tripay', '618256-251101248', 'BRIVA', '', '324', '20250501015', '251101248', 'T4646028185372QXK7D', 'https://tripay.co.id/checkout/T4646028185372QXK7D', '1762412202', '2025-11-06', '1762498593', '', 'PAID', '127125', '1762422545', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (178, 'Tripay', '370005-251101177', 'INDOMARET', '', '243', '100104', '251101177', 'T4646028185622MD9KR', 'https://tripay.co.id/checkout/T4646028185622MD9KR', '1762412753', '2025-11-06', '1762499153', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (179, 'Tripay', '988233-251101177', 'INDOMARET', '', '243', '100104', '251101177', 'T4646028185659IWTZ8', 'https://tripay.co.id/checkout/T4646028185659IWTZ8', '1762412856', '2025-11-06', '1762499254', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (180, 'Tripay', '142652-251101144', 'INDOMARET', '', '201', '240907151403', '251101144', 'T4646028185684W0JZQ', 'https://tripay.co.id/checkout/T4646028185684W0JZQ', '1762412912', '2025-11-06', '1762499311', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (181, 'Tripay', '713100-251101144', 'INDOMARET', '', '201', '240907151403', '251101144', 'T4646028185727NU7TQ', 'https://tripay.co.id/checkout/T4646028185727NU7TQ', '1762412986', '2025-11-06', '1762499385', '', 'PAID', '126750', '1762413121', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (182, 'Tripay', '906164-251101198', 'MANDIRIVA', '', '268', '240907151438', '251101198', 'T4646028185797XRGQM', 'https://tripay.co.id/checkout/T4646028185797XRGQM', '1762413167', '2025-11-06', '1762499566', '', 'PAID', '167125', '1762413335', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (183, 'Tripay', '573790-251101465', 'DANA', '', '561', '240909951495', '251101465', 'T4646028185923DJGQK', 'https://tripay.co.id/checkout/T4646028185923DJGQK', '1762413426', '2025-11-06', '1762416905', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (184, 'Tripay', '972460-251101465', 'DANA', '', '561', '240909951495', '251101465', 'T46460281861930SOPR', 'https://tripay.co.id/checkout/T46460281861930SOPR', '1762414040', '2025-11-06', '1762417519', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (185, 'Tripay', '749342-251101465', 'DANA', '', '561', '240909951495', '251101465', 'T4646028186675NJ685', 'https://tripay.co.id/checkout/T4646028186675NJ685', '1762415290', '2025-11-06', '1762418769', '', 'PAID', '125000', '1762415396', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (186, 'Tripay', '906307-251101446', 'INDOMARET', '', '540', '240909951488', '251101446', 'T4646028186713LQGXU', 'https://tripay.co.id/checkout/T4646028186713LQGXU', '1762415370', '2025-11-06', '1762501770', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (187, 'Tripay', '55006-251101355', 'BRIVA', '', '444', '240909951444', '251101355', 'T4646028187324EO2DY', 'https://tripay.co.id/checkout/T4646028187324EO2DY', '1762416758', '2025-11-06', '1762503152', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (188, 'Tripay', '1520-251101355', 'INDOMARET', '', '444', '240909951444', '251101355', 'T4646028187359T76HR', 'https://tripay.co.id/checkout/T4646028187359T76HR', '1762416835', '2025-11-06', '1762503234', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (189, 'Tripay', '802708-251101355', 'INDOMARET', '', '444', '240909951444', '251101355', 'T46460281873669GO1B', 'https://tripay.co.id/checkout/T46460281873669GO1B', '1762416845', '2025-11-06', '1762503244', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (190, 'Tripay', '650261-251101597', 'DANA', '', '699', '300070', '251101597', 'T4646028187591BWDTJ', 'https://tripay.co.id/checkout/T4646028187591BWDTJ', '1762417443', '2025-11-06', '1762420922', '', 'PAID', '125000', '1762417468', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (191, 'Tripay', '693545-251101701', 'QRIS2', '', '803', '100294', '251101701', 'T4646028187743JUNR9', 'https://tripay.co.id/checkout/T4646028187743JUNR9', '1762417761', '2025-11-06', '1762419560', '', 'PAID', '34000', '1762417879', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (192, 'Tripay', '724926-251101371', 'DANA', '', '462', '240909951452', '251101371', 'T4646028188052ZW49M', 'https://tripay.co.id/checkout/T4646028188052ZW49M', '1762418484', '2025-11-06', '1762421963', '', 'PAID', '125000', '1762418501', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (193, 'Tripay', '636272-251101355', 'BRIVA', '', '444', '240909951444', '251101355', 'T4646028188820HYDLW', 'https://tripay.co.id/checkout/T4646028188820HYDLW', '1762420170', '2025-11-06', '1762506563', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (194, 'Tripay', '320660-251101355', 'ALFAMART', '', '444', '240909951444', '251101355', 'T4646028188856FQOLF', 'https://tripay.co.id/checkout/T4646028188856FQOLF', '1762420249', '2025-11-06', '1762506529', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (195, 'Tripay', '118332-251101355', 'BCAVA', '', '444', '240909951444', '251101355', 'T4646028188885FNXOQ', 'https://tripay.co.id/checkout/T4646028188885FNXOQ', '1762420322', '2025-11-06', '1762506721', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (196, 'Tripay', '119209-251101355', 'BRIVA', '', '444', '240909951444', '251101355', 'T4646028188910KREML', 'https://tripay.co.id/checkout/T4646028188910KREML', '1762420383', '2025-11-06', '1762506783', '', 'PAID', '127125', '1762420847', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (197, 'Tripay', '962014-251101458', 'INDOMARET', '', '553', '100210', '251101458', 'T4646028189160XLASD', 'https://tripay.co.id/checkout/T4646028189160XLASD', '1762420916', '2025-11-06', '1762507315', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (198, 'Tripay', '589612-251101458', 'INDOMARET', '', '553', '100210', '251101458', 'T4646028189184KAG5A', 'https://tripay.co.id/checkout/T4646028189184KAG5A', '1762420976', '2025-11-06', '1762507376', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (199, 'Tripay', '476771-251101458', 'INDOMARET', '', '553', '100210', '251101458', 'T4646028189216ORBMN', 'https://tripay.co.id/checkout/T4646028189216ORBMN', '1762421037', '2025-11-06', '1762507437', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (200, 'Tripay', '849235-251101458', 'INDOMARET', '', '553', '100210', '251101458', 'T4646028189317RFPMK', 'https://tripay.co.id/checkout/T4646028189317RFPMK', '1762421226', '2025-11-06', '1762507626', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (201, 'Tripay', '693863-251101458', 'INDOMARET', '', '553', '100210', '251101458', 'T4646028189350OHBH9', 'https://tripay.co.id/checkout/T4646028189350OHBH9', '1762421295', '2025-11-06', '1762507694', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (202, 'Tripay', '208711-251101458', 'INDOMARET', '', '553', '100210', '251101458', 'T4646028189379KSRGG', 'https://tripay.co.id/checkout/T4646028189379KSRGG', '1762421371', '2025-11-06', '1762507771', '', 'PAID', '126750', '1762421467', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (203, 'Tripay', '466361-251101210', 'QRIS2', '', '282', '300015', '251101210', 'T46460281894419W2YP', 'https://tripay.co.id/checkout/T46460281894419W2YP', '1762421519', '2025-11-06', '1762423318', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (204, 'Tripay', '951781-251101210', 'QRIS2', '', '282', '300015', '251101210', 'T4646028189476FYZT6', 'https://tripay.co.id/checkout/T4646028189476FYZT6', '1762421592', '2025-11-06', '1762423392', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (205, 'Tripay', '295896-251101210', 'QRIS2', '', '282', '300015', '251101210', 'T4646028189501XET8F', 'https://tripay.co.id/checkout/T4646028189501XET8F', '1762421646', '2025-11-06', '1762423445', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (206, 'Tripay', '642514-251101210', 'QRIS', '', '282', '300015', '251101210', 'T4646028189544EBHLL', 'https://tripay.co.id/checkout/T4646028189544EBHLL', '1762421729', '2025-11-06', '1762423527', '', 'PAID', '125812', '1762421781', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (207, 'Tripay', '916154-251101358', 'DANA', '', '447', '240909951446', '251101358', 'T46460281897459XQIG', 'https://tripay.co.id/checkout/T46460281897459XQIG', '1762422135', '2025-11-06', '1762425614', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (208, 'Tripay', '444561-251101358', 'DANA', '', '447', '240909951446', '251101358', 'T4646028190006VLOZD', 'https://tripay.co.id/checkout/T4646028190006VLOZD', '1762422685', '2025-11-06', '1762426164', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (209, 'Tripay', '266433-251101358', 'DANA', '', '447', '240909951446', '251101358', 'T4646028190076PJAZN', 'https://tripay.co.id/checkout/T4646028190076PJAZN', '1762422789', '2025-11-06', '1762426268', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (210, 'Tripay', '36800-251101358', 'DANA', '', '447', '240909951446', '251101358', 'T4646028190127WMZGY', 'https://tripay.co.id/checkout/T4646028190127WMZGY', '1762422867', '2025-11-06', '1762426346', '', 'PAID', '165000', '1762423028', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (211, 'Tripay', '133848-251101494', 'ALFAMART', '', '593', '100220', '251101494', 'T4646028190882IQQL7', 'https://tripay.co.id/checkout/T4646028190882IQQL7', '1762424598', '2025-11-06', '1762510877', '', 'PAID', '126750', '1762425384', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (212, 'Tripay', '422674-251101289', 'QRIS2', '', '368', '200269', '251101289', 'T46460281911107SFKL', 'https://tripay.co.id/checkout/T46460281911107SFKL', '1762425016', '2025-11-06', '1762426816', '', 'PAID', '165000', '1762425065', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (213, 'Tripay', '412317-251101009', 'BCAVA', '', '14', '100006', '251101009', 'T4646028191640KWJVX', 'https://tripay.co.id/checkout/T4646028191640KWJVX', '1762425991', '2025-11-06', '1762512390', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (214, 'Tripay', '630108-251101009', 'BCAVA', '', '14', '100006', '251101009', 'T4646028191688BZUYL', 'https://tripay.co.id/checkout/T4646028191688BZUYL', '1762426063', '2025-11-06', '1762512463', '', 'PAID', '127750', '1762426102', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (215, 'Tripay', '803149-251101177', 'INDOMARET', '', '243', '100104', '251101177', 'T4646028192298GSHHL', 'https://tripay.co.id/checkout/T4646028192298GSHHL', '1762427201', '2025-11-06', '1762513601', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (216, 'Tripay', '298918-251101497', 'ALFAMIDI', '', '596', '100105312', '251101497', 'T4646028192414OL8FE', 'https://tripay.co.id/checkout/T4646028192414OL8FE', '1762427411', '2025-11-06', '1762513690', '', 'PAID', '126750', '1762427524', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (217, 'Tripay', '138750-251101456', 'ALFAMART', '', '551', '100105206', '251101456', 'T4646028192784AKEBM', 'https://tripay.co.id/checkout/T4646028192784AKEBM', '1762428095', '2025-11-06', '1762514375', '', 'PAID', '126750', '1762428237', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (218, 'Tripay', '172253-251101173', 'BRIVA', '', '239', '240907151423', '251101173', 'T4646028192922R5EJN', 'https://tripay.co.id/checkout/T4646028192922R5EJN', '1762428336', '2025-11-06', '1762514736', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (219, 'Tripay', '561630-251101404', 'ALFAMART', '', '497', '100197', '251101404', 'T4646028193043HFB61', 'https://tripay.co.id/checkout/T4646028193043HFB61', '1762428615', '2025-11-06', '1762514895', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (220, 'Tripay', '915081-251101177', 'INDOMARET', '', '243', '100104', '251101177', 'T4646028193057OP5YS', 'https://tripay.co.id/checkout/T4646028193057OP5YS', '1762428637', '2025-11-06', '1762515037', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (221, 'Tripay', '725563-251101404', 'ALFAMART', '', '497', '100197', '251101404', 'T4646028193098S0WDF', 'https://tripay.co.id/checkout/T4646028193098S0WDF', '1762428715', '2025-11-06', '1762514995', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (222, 'Tripay', '545689-251101177', 'ALFAMIDI', '', '243', '100104', '251101177', 'T4646028193102HJS1V', 'https://tripay.co.id/checkout/T4646028193102HJS1V', '1762428725', '2025-11-06', '1762515005', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (223, 'Tripay', '39349-251101404', 'ALFAMART', '', '497', '100197', '251101404', 'T464602819312529UJY', 'https://tripay.co.id/checkout/T464602819312529UJY', '1762428776', '2025-11-06', '1762515056', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (224, 'Tripay', '656532-251101177', 'ALFAMIDI', '', '243', '100104', '251101177', 'T46460281931337XDVD', 'https://tripay.co.id/checkout/T46460281931337XDVD', '1762428786', '2025-11-06', '1762515066', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (225, 'Tripay', '713921-251101536', 'INDOMARET', '', '637', '240909951528', '251101536', 'T4646028193152CJH0P', 'https://tripay.co.id/checkout/T4646028193152CJH0P', '1762428816', '2025-11-06', '1762515216', '', 'PAID', '126750', '1762429823', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (226, 'Tripay', '758045-251101104', 'ALFAMART', '', '151', '100056', '251101104', 'T4646028193244HAJKK', 'https://tripay.co.id/checkout/T4646028193244HAJKK', '1762429026', '2025-11-06', '1762515306', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (227, 'Tripay', '936620-251101104', 'ALFAMART', '', '151', '100056', '251101104', 'T4646028193289ASROE', 'https://tripay.co.id/checkout/T4646028193289ASROE', '1762429122', '2025-11-06', '1762515402', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (228, 'Tripay', '538068-251101104', 'ALFAMART', '', '151', '100056', '251101104', 'T4646028193353OSOQB', 'https://tripay.co.id/checkout/T4646028193353OSOQB', '1762429278', '2025-11-06', '1762515558', '', 'PAID', '126750', '1762429882', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (229, 'Tripay', '300205-251101509', 'ALFAMIDI', '', '610', '240909951514', '251101509', 'T4646028193399K3T07', 'https://tripay.co.id/checkout/T4646028193399K3T07', '1762429367', '2025-11-06', '1762515647', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (230, 'Tripay', '27559-251101509', 'ALFAMIDI', '', '610', '240909951514', '251101509', 'T4646028193469QLWGS', 'https://tripay.co.id/checkout/T4646028193469QLWGS', '1762429473', '2025-11-06', '1762515752', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (231, 'Tripay', '260360-251101119', 'INDOMARET', '', '168', '240907151384', '251101119', 'T4646028193474INDYM', 'https://tripay.co.id/checkout/T4646028193474INDYM', '1762429479', '2025-11-06', '1762515878', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (232, 'Tripay', '988553-251101119', 'INDOMARET', '', '168', '240907151384', '251101119', 'T4646028193571YPBI3', 'https://tripay.co.id/checkout/T4646028193571YPBI3', '1762429647', '2025-11-06', '1762516047', '', 'PAID', '126750', '1762429691', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (233, 'Tripay', '967985-251101509', 'INDOMARET', '', '610', '240909951514', '251101509', 'T4646028193608B939V', 'https://tripay.co.id/checkout/T4646028193608B939V', '1762429699', '2025-11-06', '1762516099', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (234, 'Tripay', '641664-251101255', 'INDOMARET', '', '332', '20250501023', '251101255', 'T46460281936832JRS3', 'https://tripay.co.id/checkout/T46460281936832JRS3', '1762429847', '2025-11-06', '1762516246', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (235, 'Tripay', '986615-251101255', 'INDOMARET', '', '332', '20250501023', '251101255', 'T4646028193717KETNW', 'https://tripay.co.id/checkout/T4646028193717KETNW', '1762429911', '2025-11-06', '1762516310', '', 'PAID', '126750', '1762430309', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (236, 'Tripay', '319814-251101255', 'INDOMARET', '', '332', '20250501023', '251101255', 'T4646028193731VO8QP', 'https://tripay.co.id/checkout/T4646028193731VO8QP', '1762429937', '2025-11-06', '1762516337', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (237, 'Tripay', '326043-251101509', 'INDOMARET', '', '610', '240909951514', '251101509', 'T4646028194062SEYJB', 'https://tripay.co.id/checkout/T4646028194062SEYJB', '1762430593', '2025-11-06', '1762516992', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (238, 'Tripay', '573621-251101203', 'BRIVA', '', '274', '300012', '251101203', 'T4646028194393AUMBW', 'https://tripay.co.id/checkout/T4646028194393AUMBW', '1762431262', '2025-11-06', '1762517661', '', 'PAID', '127125', '1762431374', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (239, 'Tripay', '350097-251101404', 'ALFAMART', '', '497', '100197', '251101404', 'T4646028194688VIORH', 'https://tripay.co.id/checkout/T4646028194688VIORH', '1762431887', '2025-11-06', '1762518167', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (240, 'Tripay', '283390-251101404', 'ALFAMART', '', '497', '100197', '251101404', 'T4646028194733HC2NG', 'https://tripay.co.id/checkout/T4646028194733HC2NG', '1762431983', '2025-11-06', '1762518262', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (241, 'Tripay', '507443-251101404', 'ALFAMART', '', '497', '100197', '251101404', 'T4646028194769SSOFZ', 'https://tripay.co.id/checkout/T4646028194769SSOFZ', '1762432062', '2025-11-06', '1762518342', '', 'PAID', '126750', '1762432301', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (242, 'Tripay', '82373-251101404', 'ALFAMART', '', '497', '100197', '251101404', 'T46460281948768RRTL', 'https://tripay.co.id/checkout/T46460281948768RRTL', '1762432300', '2025-11-06', '1762518580', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (243, 'Tripay', '701686-251101177', 'INDOMARET', '', '243', '100104', '251101177', 'T4646028195220DIQ4J', 'https://tripay.co.id/checkout/T4646028195220DIQ4J', '1762432948', '2025-11-06', '1762519347', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (244, 'Tripay', '721703-251101208', 'INDOMARET', '', '280', '240907151440', '251101208', 'T4646028195625PQQPF', 'https://tripay.co.id/checkout/T4646028195625PQQPF', '1762433864', '2025-11-06', '1762520264', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (245, 'Tripay', '867018-251101208', 'INDOMARET', '', '280', '240907151440', '251101208', 'T4646028195659F9MZ9', 'https://tripay.co.id/checkout/T4646028195659F9MZ9', '1762433935', '2025-11-06', '1762520334', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (246, 'Tripay', '156269-251101208', 'INDOMARET', '', '280', '240907151440', '251101208', 'T4646028195690FLMZX', 'https://tripay.co.id/checkout/T4646028195690FLMZX', '1762434008', '2025-11-06', '1762520408', '', 'PAID', '126750', '1762434103', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (247, 'Tripay', '771065-251101590', 'QRIS2', '', '692', '240909951549', '251101590', 'T4646028196505UON0S', 'https://tripay.co.id/checkout/T4646028196505UON0S', '1762435448', '2025-11-06', '1762437248', '', 'PAID', '165000', '1762435493', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (248, 'Tripay', '557086-251101154', 'INDOMARET', '', '215', '100088', '251101154', 'T4646028197285L3VCW', 'https://tripay.co.id/checkout/T4646028197285L3VCW', '1762437016', '2025-11-06', '1762523415', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (249, 'Tripay', '182917-251101154', 'INDOMARET', '', '215', '100088', '251101154', 'T46460281973262IHBT', 'https://tripay.co.id/checkout/T46460281973262IHBT', '1762437085', '2025-11-06', '1762523485', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (250, 'Tripay', '446651-251101154', 'INDOMARET', '', '215', '100088', '251101154', 'T4646028197364OJOFC', 'https://tripay.co.id/checkout/T4646028197364OJOFC', '1762437157', '2025-11-06', '1762523557', '', 'PAID', '126750', '1762437573', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (251, 'Tripay', '384778-251101509', 'INDOMARET', '', '610', '240909951514', '251101509', 'T464602819864531K0P', 'https://tripay.co.id/checkout/T464602819864531K0P', '1762440076', '2025-11-06', '1762526475', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (252, 'Tripay', '130017-251101509', 'ALFAMIDI', '', '610', '240909951514', '251101509', 'T4646028198672KJBJG', 'https://tripay.co.id/checkout/T4646028198672KJBJG', '1762440165', '2025-11-06', '1762526444', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (253, 'Tripay', '141323-251101162', 'BCAVA', '', '223', '100094', '251101162', 'T4646028201766OOFZF', 'https://tripay.co.id/checkout/T4646028201766OOFZF', '1762465782', '2025-11-07', '1762552182', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (254, 'Tripay', '728659-251101286', 'BRIVA', '', '365', '250503085806', '251101286', 'T4646028202443EASFN', 'https://tripay.co.id/checkout/T4646028202443EASFN', '1762469926', '2025-11-07', '1762556319', '', 'PAID', '127125', '1762469983', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (255, 'Tripay', '564886-251101485', 'SHOPEEPAY', '', '584', '100218', '251101485', 'T46460282025273MWOD', 'https://tripay.co.id/checkout/T46460282025273MWOD', '1762470397', '2025-11-07', '1762473877', '', 'PAID', '126875', '1762470443', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (256, 'Tripay', '665400-251101205', 'BRIVA', '', '276', '300014', '251101205', 'T4646028204512QRPVD', 'https://tripay.co.id/checkout/T4646028204512QRPVD', '1762478106', '2025-11-07', '1762564499', '', 'PAID', '127125', '1762478254', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (257, 'Tripay', '545035-251101509', 'INDOMARET', '', '610', '240909951514', '251101509', 'T4646028207294QVP5Q', 'https://tripay.co.id/checkout/T4646028207294QVP5Q', '1762485284', '2025-11-07', '1762571683', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (258, 'Tripay', '750862-251101509', 'BRIVA', '', '610', '240909951514', '251101509', 'T46460282082350RAB4', 'https://tripay.co.id/checkout/T46460282082350RAB4', '1762487722', '2025-11-07', '1762574115', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (259, 'Tripay', '459182-251101509', 'DANA', '', '610', '240909951514', '251101509', 'T4646028208337CJRDA', 'https://tripay.co.id/checkout/T4646028208337CJRDA', '1762488021', '2025-11-07', '1762491500', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (260, 'Tripay', '990109-251101509', 'BRIVA', '', '610', '240909951514', '251101509', 'T4646028208387J3RJM', 'https://tripay.co.id/checkout/T4646028208387J3RJM', '1762488153', '2025-11-07', '1762574553', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (261, 'Tripay', '677276-251101509', 'BRIVA', '', '610', '240909951514', '251101509', 'T4646028208442HLU3O', 'https://tripay.co.id/checkout/T4646028208442HLU3O', '1762488263', '2025-11-07', '1762574662', '', 'PAID', '127125', '1762488454', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (262, 'Tripay', '478073-251101156', 'BNIVA', '', '217', '100089', '251101156', 'T46460282090971WS6E', 'https://tripay.co.id/checkout/T46460282090971WS6E', '1762489918', '2025-11-07', '1762576197', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (263, 'Tripay', '312360-251101156', 'BNIVA', '', '217', '100089', '251101156', 'T4646028209136FEZN0', 'https://tripay.co.id/checkout/T4646028209136FEZN0', '1762489988', '2025-11-07', '1762576267', '', 'PAID', '127125', '1762490018', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (264, 'Tripay', '188481-251101177', 'INDOMARET', '', '243', '100104', '251101177', 'T4646028210375EK6RD', 'https://tripay.co.id/checkout/T4646028210375EK6RD', '1762492748', '2025-11-07', '1762579147', '', 'PAID', '126750', '1762492840', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (265, 'Tripay', '732261-251101277', 'INDOMARET', '', '356', '20250501047', '251101277', 'T4646028213902P8XOC', 'https://tripay.co.id/checkout/T4646028213902P8XOC', '1762500198', '2025-11-07', '1762586598', '', 'PAID', '166750', '1762517640', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (266, 'Tripay', '497527-251101707', 'BCAVA', '', '809', '240909951597', '251101707', 'T4646028215504J2ZKR', 'https://tripay.co.id/checkout/T4646028215504J2ZKR', '1762503798', '2025-11-07', '1762590198', '', 'PAID', '23750', '1762503865', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (267, 'Tripay', '790593-251101709', 'BCAVA', '', '811', '100297', '251101709', 'T4646028215508UUQF0', 'https://tripay.co.id/checkout/T4646028215508UUQF0', '1762503802', '2025-11-07', '1762590202', '', 'PAID', '19750', '1762503875', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (268, 'Tripay', '774472-251101620', 'ALFAMART', '', '722', '240909951563', '251101620', 'T4646028215582JTOM7', 'https://tripay.co.id/checkout/T4646028215582JTOM7', '1762503970', '2025-11-07', '1762590250', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (269, 'Tripay', '130805-251101613', 'BCAVA', '', '715', '240909951559', '251101613', 'T46460282156382YVJI', 'https://tripay.co.id/checkout/T46460282156382YVJI', '1762504075', '2025-11-07', '1762590474', '', 'PAID', '127750', '1762504146', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (270, 'Tripay', '791964-251101652', 'BCAVA', '', '754', '251023143740', '251101652', 'T46460282159204KFJM', 'https://tripay.co.id/checkout/T46460282159204KFJM', '1762504680', '2025-11-07', '1762591080', '', 'UNPAID', '98750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (271, 'Tripay', '897210-251101652', 'BCAVA', '', '754', '251023143740', '251101652', 'T4646028215941MN44L', 'https://tripay.co.id/checkout/T4646028215941MN44L', '1762504725', '2025-11-07', '1762591125', '', 'UNPAID', '98750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (272, 'Tripay', '385534-251101672', 'BCAVA', '', '774', '240909951584', '251101672', 'T4646028216015KEEAT', 'https://tripay.co.id/checkout/T4646028216015KEEAT', '1762504866', '2025-11-07', '1762591266', '', 'PAID', '36750', '1762505010', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (273, 'Tripay', '161191-251101652', 'BCAVA', '', '754', '251023143740', '251101652', 'T4646028216101KS151', 'https://tripay.co.id/checkout/T4646028216101KS151', '1762505044', '2025-11-07', '1762591444', '', 'PAID', '98750', '1762505231', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (274, 'Tripay', '164878-251101535', 'BNIVA', '', '636', '240909951527', '251101535', 'T46460282161354I39J', 'https://tripay.co.id/checkout/T46460282161354I39J', '1762505100', '2025-11-07', '1762591373', '', 'PAID', '127125', '1762505139', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (275, 'Tripay', '283463-251101519', 'QRIS2', '', '620', '100232', '251101519', 'T4646028216137THBB7', 'https://tripay.co.id/checkout/T4646028216137THBB7', '1762505105', '2025-11-07', '1762506905', '', 'PAID', '125000', '1762505148', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (276, 'Tripay', '212229-251101520', 'QRIS2', '', '621', '300058', '251101520', 'T4646028216186PQXK7', 'https://tripay.co.id/checkout/T4646028216186PQXK7', '1762505203', '2025-11-07', '1762507003', '', 'PAID', '125000', '1762505261', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (277, 'Tripay', '322836-251101678', 'DANA', '', '780', '240909951587', '251101678', 'T46460282161927LOIU', 'https://tripay.co.id/checkout/T46460282161927LOIU', '1762505212', '2025-11-07', '1762508692', '', 'UNPAID', '25000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (278, 'Tripay', '779115-251101580', 'BRIVA', '', '682', '100252', '251101580', 'T4646028216249FCCUY', 'https://tripay.co.id/checkout/T4646028216249FCCUY', '1762505333', '2025-11-07', '1762591733', '', 'PAID', '127125', '1762505382', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (279, 'Tripay', '964233-251101599', 'BCAVA', '', '701', '240909951553', '251101599', 'T4646028216318RJPH2', 'https://tripay.co.id/checkout/T4646028216318RJPH2', '1762505495', '2025-11-07', '1762591895', '', 'UNPAID', '167750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (280, 'Tripay', '689598-251101615', 'BCAVA', '', '717', '100269', '251101615', 'T4646028216351JLX6F', 'https://tripay.co.id/checkout/T4646028216351JLX6F', '1762505551', '2025-11-07', '1762591951', '', 'PAID', '127750', '1762505702', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (281, 'Tripay', '437311-251101173', 'BRIVA', '', '239', '240907151423', '251101173', 'T4646028216383QZCFX', 'https://tripay.co.id/checkout/T4646028216383QZCFX', '1762505631', '2025-11-07', '1762592031', '', 'PAID', '127125', '1762505694', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (282, 'Tripay', '454725-251101599', 'BCAVA', '', '701', '240909951553', '251101599', 'T46460282165317Z8TQ', 'https://tripay.co.id/checkout/T46460282165317Z8TQ', '1762505972', '2025-11-07', '1762592372', '', 'PAID', '167750', '1762506144', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (283, 'Tripay', '475194-251101495', 'BCAVA', '', '594', '240909951510', '251101495', 'T4646028216543OWZTI', 'https://tripay.co.id/checkout/T4646028216543OWZTI', '1762506009', '2025-11-07', '1762592409', '', 'PAID', '127750', '1762506076', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (284, 'Tripay', '386274-251101508', 'BNIVA', '', '608', '100224', '251101508', 'T4646028216563L2DBF', 'https://tripay.co.id/checkout/T4646028216563L2DBF', '1762506063', '2025-11-07', '1762592343', '', 'PAID', '167125', '1762506100', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (285, 'Tripay', '55825-251101218', 'MANDIRIVA', '', '293', '100120', '251101218', 'T46460282166952KAJT', 'https://tripay.co.id/checkout/T46460282166952KAJT', '1762506330', '2025-11-07', '1762592730', '', 'PAID', '127125', '1762506403', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (286, 'Tripay', '887709-251101515', 'INDOMARET', '', '616', '100228', '251101515', 'T4646028216716TZP1S', 'https://tripay.co.id/checkout/T4646028216716TZP1S', '1762506365', '2025-11-07', '1762592765', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (287, 'Tripay', '514543-251101622', 'BNIVA', '', '724', '100272', '251101622', 'T4646028216739MOPUX', 'https://tripay.co.id/checkout/T4646028216739MOPUX', '1762506405', '2025-11-07', '1762592685', '', 'PAID', '127125', '1762506575', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (288, 'Tripay', '914956-251101374', 'SHOPEEPAY', '', '466', '240909951454', '251101374', 'T4646028216749FAYYR', 'https://tripay.co.id/checkout/T4646028216749FAYYR', '1762506421', '2025-11-07', '1762509901', '', 'PAID', '126875', '1762506488', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (289, 'Tripay', '987688-251101513', 'BCAVA', '', '614', '300057', '251101513', 'T4646028216853YVQEO', 'https://tripay.co.id/checkout/T4646028216853YVQEO', '1762506656', '2025-11-07', '1762593056', '', 'PAID', '127750', '1762506747', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (290, 'Tripay', '109843-251101680', 'BNIVA', '', '782', '100288', '251101680', 'T4646028216877SVUT4', 'https://tripay.co.id/checkout/T4646028216877SVUT4', '1762506711', '2025-11-07', '1762592991', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (291, 'Tripay', '567160-251101680', 'BNIVA', '', '782', '100288', '251101680', 'T4646028216892OQOND', 'https://tripay.co.id/checkout/T4646028216892OQOND', '1762506750', '2025-11-07', '1762593030', '', 'PAID', '127125', '1762506843', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (292, 'Tripay', '113979-251101480', 'ALFAMART', '', '578', '100215', '251101480', 'T4646028216956RUFMO', 'https://tripay.co.id/checkout/T4646028216956RUFMO', '1762506866', '2025-11-07', '1762593146', '', 'PAID', '126750', '1762510024', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (293, 'Tripay', '343865-251101668', 'INDOMARET', '', '770', '100284', '251101668', 'T4646028217046WX31H', 'https://tripay.co.id/checkout/T4646028217046WX31H', '1762507074', '2025-11-07', '1762593474', '', 'UNPAID', '47750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (294, 'Tripay', '910881-251101365', 'QRIS2', '', '455', '100180', '251101365', 'T4646028217134XRPVY', 'https://tripay.co.id/checkout/T4646028217134XRPVY', '1762507222', '2025-11-07', '1762509022', '', 'PAID', '125000', '1762507279', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (295, 'Tripay', '95048-251101665', 'BCAVA', '', '767', '240909951581', '251101665', 'T4646028217155BZKLN', 'https://tripay.co.id/checkout/T4646028217155BZKLN', '1762507264', '2025-11-07', '1762593664', '', 'PAID', '52750', '1762507502', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (296, 'Tripay', '555155-251101344', 'BRIVA', '', '432', '300025', '251101344', 'T4646028217159PWTVF', 'https://tripay.co.id/checkout/T4646028217159PWTVF', '1762507273', '2025-11-07', '1762593664', '', 'PAID', '167125', '1762507714', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (297, 'Tripay', '448067-251101558', 'MANDIRIVA', '', '659', '100243', '251101558', 'T4646028217258QJ2N9', 'https://tripay.co.id/checkout/T4646028217258QJ2N9', '1762507458', '2025-11-07', '1762593858', '', 'PAID', '127125', '1762507546', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (298, 'Tripay', '539711-251101399', 'BNIVA', '', '492', '100195', '251101399', 'T46460282173320T9BX', 'https://tripay.co.id/checkout/T46460282173320T9BX', '1762507626', '2025-11-07', '1762593905', '', 'PAID', '127125', '1762511718', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (299, 'Tripay', '190575-251101588', 'SHOPEEPAY', '', '690', '100257', '251101588', 'T4646028217348KQEO4', 'https://tripay.co.id/checkout/T4646028217348KQEO4', '1762507648', '2025-11-07', '1762511128', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (300, 'Tripay', '161063-251101588', 'INDOMARET', '', '690', '100257', '251101588', 'T4646028217397G6OK4', 'https://tripay.co.id/checkout/T4646028217397G6OK4', '1762507746', '2025-11-07', '1762594145', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (301, 'Tripay', '135777-251101588', 'INDOMARET', '', '690', '100257', '251101588', 'T4646028217409KTN5W', 'https://tripay.co.id/checkout/T4646028217409KTN5W', '1762507770', '2025-11-07', '1762594170', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (302, 'Tripay', '699306-251101543', 'BCAVA', '', '644', '240909951533', '251101543', 'T46460282174102APRK', 'https://tripay.co.id/checkout/T46460282174102APRK', '1762507770', '2025-11-07', '1762594170', '', 'PAID', '127750', '1762507840', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (303, 'Tripay', '400110-251101417', 'BCAVA', '', '510', '100201', '251101417', 'T464602821741971LFH', 'https://tripay.co.id/checkout/T464602821741971LFH', '1762507786', '2025-11-07', '1762594186', '', 'PAID', '127750', '1762508095', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (304, 'Tripay', '774331-251101588', 'SHOPEEPAY', '', '690', '100257', '251101588', 'T4646028217431ASEDV', 'https://tripay.co.id/checkout/T4646028217431ASEDV', '1762507811', '2025-11-07', '1762511291', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (305, 'Tripay', '520327-251101675', 'BRIVA', '', '777', '300074', '251101675', 'T4646028217437AT0BC', 'https://tripay.co.id/checkout/T4646028217437AT0BC', '1762507827', '2025-11-07', '1762594226', '', 'PAID', '32125', '1762507881', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (306, 'Tripay', '812737-251101430', 'DANA', '', '523', '240909951481', '251101430', 'T4646028217465EUWEL', 'https://tripay.co.id/checkout/T4646028217465EUWEL', '1762507880', '2025-11-07', '1762511359', '', 'PAID', '165000', '1762507900', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (307, 'Tripay', '292712-251101178', 'QRIS2', '', '244', '240907151425', '251101178', 'T4646028217603ABBAN', 'https://tripay.co.id/checkout/T4646028217603ABBAN', '1762508127', '2025-11-07', '1762509927', '', 'PAID', '125000', '1762508180', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (308, 'Tripay', '287182-251101518', 'BCAVA', '', '619', '100231', '251101518', 'T4646028217629W926W', 'https://tripay.co.id/checkout/T4646028217629W926W', '1762508182', '2025-11-07', '1762594581', '', 'PAID', '127750', '1762508426', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (309, 'Tripay', '742605-251101630', 'DANA', '', '732', '100275', '251101630', 'T4646028217657NXRLU', 'https://tripay.co.id/checkout/T4646028217657NXRLU', '1762508243', '2025-11-07', '1762511722', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (310, 'Tripay', '253083-251101258', 'BRIVA', '', '335', '20250501026', '251101258', 'T4646028217687FNCLY', 'https://tripay.co.id/checkout/T4646028217687FNCLY', '1762508334', '2025-11-07', '1762594734', '', 'PAID', '127125', '1762508503', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (311, 'Tripay', '92188-251101072', 'BCAVA', '', '111', '240907151346', '251101072', 'T4646028217720KOBKT', 'https://tripay.co.id/checkout/T4646028217720KOBKT', '1762508423', '2025-11-07', '1762594822', '', 'PAID', '137750', '1762508604', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (312, 'Tripay', '519783-251101074', 'BCAVA', '', '114', '100046', '251101074', 'T4646028217745MZROV', 'https://tripay.co.id/checkout/T4646028217745MZROV', '1762508480', '2025-11-07', '1762594880', '', 'PAID', '127750', '1762508639', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (313, 'Tripay', '808519-251101359', 'BRIVA', '', '448', '300027', '251101359', 'T4646028217787KKR5H', 'https://tripay.co.id/checkout/T4646028217787KKR5H', '1762508567', '2025-11-07', '1762594966', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (314, 'Tripay', '453586-251101564', 'ALFAMART', '', '665', '100247', '251101564', 'T4646028217793P2EYL', 'https://tripay.co.id/checkout/T4646028217793P2EYL', '1762508579', '2025-11-07', '1762594858', '', 'PAID', '126750', '1762510183', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (315, 'Tripay', '950728-251101359', 'BRIVA', '', '448', '300027', '251101359', 'T4646028217803NO8QC', 'https://tripay.co.id/checkout/T4646028217803NO8QC', '1762508602', '2025-11-07', '1762595002', '', 'PAID', '127125', '1762508754', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (316, 'Tripay', '887676-251101484', 'BCAVA', '', '583', '100217', '251101484', 'T4646028217812P4AQX', 'https://tripay.co.id/checkout/T4646028217812P4AQX', '1762508627', '2025-11-07', '1762595027', '', 'PAID', '127750', '1762508730', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (317, 'Tripay', '347279-251101001', 'BNIVA', '', '1', '240907153154', '251101001', 'T46460282178644QVNF', 'https://tripay.co.id/checkout/T46460282178644QVNF', '1762508754', '2025-11-07', '1762595025', '', 'PAID', '207125', '1762524219', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (318, 'Tripay', '276888-251101012', 'QRIS2', '', '19', '200008', '251101012', 'T4646028217880QPBRI', 'https://tripay.co.id/checkout/T4646028217880QPBRI', '1762508787', '2025-11-07', '1762510586', '', 'PAID', '205000', '1762509007', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (319, 'Tripay', '583032-251101687', 'SHOPEEPAY', '', '789', '400008', '251101687', 'T4646028217892NXIUW', 'https://tripay.co.id/checkout/T4646028217892NXIUW', '1762508824', '2025-11-07', '1762512304', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (320, 'Tripay', '428879-251101537', 'BRIVA', '', '638', '240909951529', '251101537', 'T4646028217945TOVGC', 'https://tripay.co.id/checkout/T4646028217945TOVGC', '1762508933', '2025-11-07', '1762595333', '', 'PAID', '127125', '1762508981', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (321, 'Tripay', '18298-251101409', 'BCAVA', '', '502', '100200', '251101409', 'T4646028218087EHJRI', 'https://tripay.co.id/checkout/T4646028218087EHJRI', '1762509224', '2025-11-07', '1762595623', '', 'PAID', '127750', '1762509282', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (322, 'Tripay', '243312-251101612', 'BNIVA', '', '714', '240909951558', '251101612', 'T4646028218094URFEB', 'https://tripay.co.id/checkout/T4646028218094URFEB', '1762509243', '2025-11-07', '1762595523', '', 'PAID', '127125', '1762509298', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (323, 'Tripay', '482987-251101588', 'BRIVA', '', '690', '100257', '251101588', 'T4646028218164ZFJM8', 'https://tripay.co.id/checkout/T4646028218164ZFJM8', '1762509371', '2025-11-07', '1762595763', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (324, 'Tripay', '510830-251101351', 'SHOPEEPAY', '', '439', '100104870', '251101351', 'T4646028218163JMHCP', 'https://tripay.co.id/checkout/T4646028218163JMHCP', '1762509371', '2025-11-07', '1762512851', '', 'PAID', '126875', '1762509644', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (325, 'Tripay', '123998-251107001', 'INDOMARET', '', '735', '100105599', '251107001', 'T4646028218195YD3BB', 'https://tripay.co.id/checkout/T4646028218195YD3BB', '1762509402', '2025-11-07', '1762595802', '', 'PAID', '126750', '1762513714', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (326, 'Tripay', '810695-251101251', 'BRIVA', '', '327', '20250501018', '251101251', 'T4646028218198FDSJG', 'https://tripay.co.id/checkout/T4646028218198FDSJG', '1762509408', '2025-11-07', '1762595808', '', 'PAID', '127125', '1762509503', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (327, 'Tripay', '584417-251101588', 'QRIS2', '', '690', '100257', '251101588', 'T4646028218202AMJJJ', 'https://tripay.co.id/checkout/T4646028218202AMJJJ', '1762509417', '2025-11-07', '1762511216', '', 'PAID', '125000', '1762509514', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (328, 'Tripay', '300176-251101057', 'BCAVA', '', '89', '240907151330', '251101057', 'T4646028218218PBOHV', 'https://tripay.co.id/checkout/T4646028218218PBOHV', '1762509428', '2025-11-07', '1762595827', '', 'PAID', '127750', '1762509478', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (329, 'Tripay', '985756-251101488', 'ALFAMART', '', '587', '100219', '251101488', 'T4646028218220RWIKH', 'https://tripay.co.id/checkout/T4646028218220RWIKH', '1762509432', '2025-11-07', '1762595711', '', 'PAID', '126750', '1762509864', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (330, 'Tripay', '928412-251101466', 'MANDIRIVA', '', '562', '240909951496', '251101466', 'T4646028218292WOWNX', 'https://tripay.co.id/checkout/T4646028218292WOWNX', '1762509565', '2025-11-07', '1762595965', '', 'PAID', '127125', '1762509835', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (331, 'Tripay', '235536-251101390', 'INDOMARET', '', '483', '300031', '251101390', 'T4646028218692YSB8V', 'https://tripay.co.id/checkout/T4646028218692YSB8V', '1762510435', '2025-11-07', '1762596835', '', 'PAID', '126750', '1762510474', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (332, 'Tripay', '345101-251101314', 'BCAVA', '', '396', '240909951431', '251101314', 'T4646028218702E8KSR', 'https://tripay.co.id/checkout/T4646028218702E8KSR', '1762510462', '2025-11-07', '1762596862', '', 'PAID', '167750', '1762510595', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (333, 'Tripay', '809150-251107008', 'BRIVA', '', '736', '100105600', '251107008', 'T46460282187320PW8N', 'https://tripay.co.id/checkout/T46460282187320PW8N', '1762510520', '2025-11-07', '1762596920', '', 'PAID', '127125', '1762510696', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (334, 'Tripay', '197297-251101091', 'BNIVA', '', '137', '240907151364', '251101091', 'T4646028218822JJHYC', 'https://tripay.co.id/checkout/T4646028218822JJHYC', '1762510691', '2025-11-07', '1762596971', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (335, 'Tripay', '868036-251101501', 'DANA', '', '600', '100105429', '251101501', 'T4646028218880ZMWUI', 'https://tripay.co.id/checkout/T4646028218880ZMWUI', '1762510830', '2025-11-07', '1762514309', '', 'PAID', '165000', '1762510870', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (336, 'Tripay', '685283-251101155', 'BCAVA', '', '216', '240907151412', '251101155', 'T46460282189036ZOIV', 'https://tripay.co.id/checkout/T46460282189036ZOIV', '1762510898', '2025-11-07', '1762597298', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (337, 'Tripay', '621060-251101061', 'BNIVA', '', '96', '100039', '251101061', 'T4646028218916XSFC0', 'https://tripay.co.id/checkout/T4646028218916XSFC0', '1762510915', '2025-11-07', '1762597195', '', 'PAID', '127125', '1762511038', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (338, 'Tripay', '727044-251101467', 'INDOMARET', '', '563', '240909951497', '251101467', 'T4646028218992E2BVY', 'https://tripay.co.id/checkout/T4646028218992E2BVY', '1762511079', '2025-11-07', '1762597479', '', 'PAID', '166750', '1762511718', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (339, 'Tripay', '12030-251101441', 'MANDIRIVA', '', '534', '240909951485', '251101441', 'T4646028218996UCVII', 'https://tripay.co.id/checkout/T4646028218996UCVII', '1762511086', '2025-11-07', '1762597479', '', 'PAID', '167125', '1762511963', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (340, 'Tripay', '304829-251101386', 'ALFAMART', '', '479', '100189', '251101386', 'T46460282190094WAUC', 'https://tripay.co.id/checkout/T46460282190094WAUC', '1762511109', '2025-11-07', '1762597389', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (341, 'Tripay', '241853-251101529', 'BCAVA', '', '630', '240909951522', '251101529', 'T4646028219405LOCSN', 'https://tripay.co.id/checkout/T4646028219405LOCSN', '1762511926', '2025-11-07', '1762598325', '', 'PAID', '127750', '1762512015', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (342, 'Tripay', '401441-251101674', 'MANDIRIVA', '', '776', '100286', '251101674', 'T4646028219503VVBJ2', 'https://tripay.co.id/checkout/T4646028219503VVBJ2', '1762512131', '2025-11-07', '1762598530', '', 'UNPAID', '32125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (343, 'Tripay', '21753-251101155', 'BCAVA', '', '216', '240907151412', '251101155', 'T4646028219810PDHJA', 'https://tripay.co.id/checkout/T4646028219810PDHJA', '1762512697', '2025-11-07', '1762599096', '', 'PAID', '127750', '1762512919', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (344, 'Tripay', '213787-251101705', 'QRIS2', '', '807', '300077', '251101705', 'T46460282199146G7SO', 'https://tripay.co.id/checkout/T46460282199146G7SO', '1762512873', '2025-11-07', '1762514673', '', 'PAID', '21000', '1762512901', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (345, 'Tripay', '582818-251101450', 'SHOPEEPAY', '', '545', '100207', '251101450', 'T4646028220149MUKLD', 'https://tripay.co.id/checkout/T4646028220149MUKLD', '1762513345', '2025-11-07', '1762516824', '', 'PAID', '126875', '1762513406', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (346, 'Tripay', '654768-251101686', 'INDOMARET', '', '788', '400007', '251101686', 'T4646028220293DAHHQ', 'https://tripay.co.id/checkout/T4646028220293DAHHQ', '1762513619', '2025-11-07', '1762600019', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (347, 'Tripay', '920775-251101552', 'BCAVA', '', '653', '100237', '251101552', 'T4646028220322HWTML', 'https://tripay.co.id/checkout/T4646028220322HWTML', '1762513677', '2025-11-07', '1762600076', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (348, 'Tripay', '35807-251101345', 'INDOMARET', '', '433', '240909951443', '251101345', 'T46460282203416CW5T', 'https://tripay.co.id/checkout/T46460282203416CW5T', '1762513709', '2025-11-07', '1762600109', '', 'PAID', '126750', '1762526191', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (349, 'Tripay', '366288-251101034', 'BSIVA', '', '53', '200033', '251101034', 'T4646028220499WID19', 'https://tripay.co.id/checkout/T4646028220499WID19', '1762513973', '2025-11-07', '1762524644', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (350, 'Tripay', '993649-251107005', 'INDOMARET', '', '713', '240909951557', '251107005', 'T4646028220527RFID6', 'https://tripay.co.id/checkout/T4646028220527RFID6', '1762514025', '2025-11-07', '1762600425', '', 'PAID', '126750', '1762514095', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (351, 'Tripay', '419404-251101565', 'INDOMARET', '', '666', '100248', '251101565', 'T4646028220587QAB7R', 'https://tripay.co.id/checkout/T4646028220587QAB7R', '1762514148', '2025-11-07', '1762600548', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (352, 'Tripay', '401475-251101666', 'QRIS2', '', '768', '100283', '251101666', 'T4646028220700LXADL', 'https://tripay.co.id/checkout/T4646028220700LXADL', '1762514421', '2025-11-07', '1762516220', '', 'UNPAID', '46000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (353, 'Tripay', '744585-251101478', 'DANA', '', '576', '240909951502', '251101478', 'T4646028220732HUUTJ', 'https://tripay.co.id/checkout/T4646028220732HUUTJ', '1762514499', '2025-11-07', '1762517978', '', 'PAID', '125000', '1762514526', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (354, 'Tripay', '764928-251101663', 'MANDIRIVA', '', '765', '240909951579', '251101663', 'T4646028220792CQKMQ', 'https://tripay.co.id/checkout/T4646028220792CQKMQ', '1762514609', '2025-11-07', '1762601001', '', 'UNPAID', '65125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (355, 'Tripay', '540213-251101663', 'MANDIRIVA', '', '765', '240909951579', '251101663', 'T4646028220996P9QYO', 'https://tripay.co.id/checkout/T4646028220996P9QYO', '1762514920', '2025-11-07', '1762601320', '', 'PAID', '65125', '1762515039', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (356, 'Tripay', '108289-251101684', 'BNIVA', '', '786', '400005', '251101684', 'T4646028221008SKEQA', 'https://tripay.co.id/checkout/T4646028221008SKEQA', '1762514964', '2025-11-07', '1762601243', '', 'PAID', '167125', '1762515046', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (357, 'Tripay', '954453-251101362', 'QRIS2', '', '451', '240909951447', '251101362', 'T4646028221020L4KTH', 'https://tripay.co.id/checkout/T4646028221020L4KTH', '1762514999', '2025-11-07', '1762516798', '', 'PAID', '165000', '1762515040', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (358, 'Tripay', '861827-251101128', 'INDOMARET', '', '177', '100069', '251101128', 'T4646028221052UHCQ8', 'https://tripay.co.id/checkout/T4646028221052UHCQ8', '1762515052', '2025-11-07', '1762601451', '', 'PAID', '126750', '1762515191', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (359, 'Tripay', '854996-251101630', 'DANA', '', '732', '100275', '251101630', 'T4646028221193VF9DU', 'https://tripay.co.id/checkout/T4646028221193VF9DU', '1762515282', '2025-11-07', '1762518761', '', 'PAID', '125000', '1762515327', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (360, 'Tripay', '631549-251101406', 'DANA', '', '499', '100198', '251101406', 'T4646028221412DATOG', 'https://tripay.co.id/checkout/T4646028221412DATOG', '1762515644', '2025-11-07', '1762519122', '', 'PAID', '42000', '1762515692', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (361, 'Tripay', '434176-251101668', 'INDOMARET', '', '770', '100284', '251101668', 'T46460282214141WXEJ', 'https://tripay.co.id/checkout/T46460282214141WXEJ', '1762515649', '2025-11-07', '1762602049', '', 'PAID', '47750', '1762515927', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (362, 'Tripay', '681439-251101654', 'DANA', '', '756', '240909951576', '251101654', 'T4646028221534XCONL', 'https://tripay.co.id/checkout/T4646028221534XCONL', '1762515853', '2025-11-07', '1762519332', '', 'UNPAID', '124000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (363, 'Tripay', '967932-251101024', 'ALFAMART', '', '40', '200024', '251101024', 'T4646028221644OWCH1', 'https://tripay.co.id/checkout/T4646028221644OWCH1', '1762516023', '2025-11-07', '1762602303', '', 'PAID', '126750', '1762516116', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (364, 'Tripay', '492206-251101302', 'INDOMARET', '', '382', '250515124114', '251101302', 'T4646028221666FSVTI', 'https://tripay.co.id/checkout/T4646028221666FSVTI', '1762516051', '2025-11-07', '1762602450', '', 'PAID', '126750', '1762517027', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (365, 'Tripay', '444527-251101446', 'MANDIRIVA', '', '540', '240909951488', '251101446', 'T4646028221677QLSMH', 'https://tripay.co.id/checkout/T4646028221677QLSMH', '1762516070', '2025-11-07', '1762602470', '', 'PAID', '127125', '1762516508', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (366, 'Tripay', '285040-251101373', 'INDOMARET', '', '464', '300029', '251101373', 'T4646028221685GIA85', 'https://tripay.co.id/checkout/T4646028221685GIA85', '1762516077', '2025-11-07', '1762602477', '', 'PAID', '126750', '1762516181', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (367, 'Tripay', '239293-251101539', 'INDOMARET', '', '640', '300060', '251101539', 'T464602822193392HCA', 'https://tripay.co.id/checkout/T464602822193392HCA', '1762516439', '2025-11-07', '1762602839', '', 'PAID', '126750', '1762516536', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (368, 'Tripay', '470152-251107006', 'INDOMARET', '', '733', '100105592', '251107006', 'T4646028222248BYIQE', 'https://tripay.co.id/checkout/T4646028222248BYIQE', '1762517039', '2025-11-07', '1762603439', '', 'PAID', '126750', '1762517680', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (369, 'Tripay', '910313-251101514', 'INDOMARET', '', '615', '100227', '251101514', 'T4646028222280HIMGO', 'https://tripay.co.id/checkout/T4646028222280HIMGO', '1762517106', '2025-11-07', '1762603505', '', 'PAID', '126750', '1762517169', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (370, 'Tripay', '32033-251101356', 'BCAVA', '', '445', '240909951445', '251101356', 'T4646028222406XSP0U', 'https://tripay.co.id/checkout/T4646028222406XSP0U', '1762517303', '2025-11-07', '1762603702', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (371, 'Tripay', '879972-251101401', 'INDOMARET', '', '494', '240909951465', '251101401', 'T4646028222545JBFQA', 'https://tripay.co.id/checkout/T4646028222545JBFQA', '1762517563', '2025-11-07', '1762603963', '', 'PAID', '126750', '1762524668', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (372, 'Tripay', '393060-251101654', 'DANA', '', '756', '240909951576', '251101654', 'T4646028222624FW5E7', 'https://tripay.co.id/checkout/T4646028222624FW5E7', '1762517702', '2025-11-07', '1762521181', '', 'UNPAID', '124000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (373, 'Tripay', '413857-251101654', 'BRIVA', '', '756', '240909951576', '251101654', 'T4646028222732I6DG1', 'https://tripay.co.id/checkout/T4646028222732I6DG1', '1762517864', '2025-11-07', '1762604256', '', 'UNPAID', '126125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (374, 'Tripay', '330975-251101654', 'BRIVA', '', '756', '240909951576', '251101654', 'T4646028222761BD3BJ', 'https://tripay.co.id/checkout/T4646028222761BD3BJ', '1762517905', '2025-11-07', '1762604304', '', 'PAID', '126125', '1762518003', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (375, 'Tripay', '248665-251101503', 'INDOMARET', '', '602', '250825102753', '251101503', 'T4646028222780PETJD', 'https://tripay.co.id/checkout/T4646028222780PETJD', '1762517945', '2025-11-07', '1762604344', '', 'PAID', '126750', '1762519399', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (376, 'Tripay', '987574-251101619', 'SHOPEEPAY', '', '721', '100271', '251101619', 'T4646028222814P9R7K', 'https://tripay.co.id/checkout/T4646028222814P9R7K', '1762517991', '2025-11-07', '1762521471', '', 'PAID', '126875', '1762518017', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (377, 'Tripay', '446741-251101686', 'BRIVA', '', '788', '400007', '251101686', 'T4646028222818ZVPZV', 'https://tripay.co.id/checkout/T4646028222818ZVPZV', '1762517999', '2025-11-07', '1762604398', '', 'PAID', '127125', '1762518139', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (378, 'Tripay', '887013-251101324', 'MANDIRIVA', '', '407', '100162', '251101324', 'T4646028222992WMC4B', 'https://tripay.co.id/checkout/T4646028222992WMC4B', '1762518242', '2025-11-07', '1762604642', '', 'PAID', '127125', '1762518386', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (379, 'Tripay', '29284-251101067', 'ALFAMART', '', '104', '240907151341', '251101067', 'T4646028223167JZXOF', 'https://tripay.co.id/checkout/T4646028223167JZXOF', '1762518504', '2025-11-07', '1762604784', '', 'PAID', '166750', '1762518635', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (380, 'Tripay', '355733-251101091', 'BNIVA', '', '137', '240907151364', '251101091', 'T4646028223530KYLML', 'https://tripay.co.id/checkout/T4646028223530KYLML', '1762519132', '2025-11-07', '1762605411', '', 'PAID', '127125', '1762519217', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (381, 'Tripay', '18217-251101429', 'QRIS', '', '522', '300039', '251101429', 'T4646028223977KGIK8', 'https://tripay.co.id/checkout/T4646028223977KGIK8', '1762519938', '2025-11-07', '1762521737', '', 'PAID', '165952', '1762520037', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (382, 'Tripay', '161081-251101463', 'BRIVA', '', '559', '300050', '251101463', 'T4646028224167BSMO2', 'https://tripay.co.id/checkout/T4646028224167BSMO2', '1762520301', '2025-11-07', '1762606694', '', 'PAID', '127125', '1762520408', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (383, 'Tripay', '534826-251101673', 'INDOMARET', '', '775', '240909951585', '251101673', 'T4646028224313IH34C', 'https://tripay.co.id/checkout/T4646028224313IH34C', '1762520552', '2025-11-07', '1762606951', '', 'PAID', '35750', '1762520634', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (384, 'Tripay', '687621-251101673', 'INDOMARET', '', '775', '240909951585', '251101673', 'T46460282243654G2D4', 'https://tripay.co.id/checkout/T46460282243654G2D4', '1762520653', '2025-11-07', '1762607053', '', 'UNPAID', '35750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (385, 'Tripay', '319273-251101560', 'BSIVA', '', '661', '240909951536', '251101560', 'T4646028224366PRDBH', 'https://tripay.co.id/checkout/T4646028224366PRDBH', '1762520655', '2025-11-07', '1762531335', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (386, 'Tripay', '70250-251101560', 'BSIVA', '', '661', '240909951536', '251101560', 'T4646028224425NWW5Q', 'https://tripay.co.id/checkout/T4646028224425NWW5Q', '1762520799', '2025-11-07', '1762531479', '', 'PAID', '127125', '1762520821', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (387, 'Tripay', '382245-251101378', 'INDOMARET', '', '470', '240909951457', '251101378', 'T4646028224501NGCWY', 'https://tripay.co.id/checkout/T4646028224501NGCWY', '1762520942', '2025-11-07', '1762607342', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (388, 'Tripay', '70049-251101272', 'SHOPEEPAY', '', '350', '20250501041', '251101272', 'T4646028224515QRGY6', 'https://tripay.co.id/checkout/T4646028224515QRGY6', '1762520969', '2025-11-07', '1762524449', '', 'PAID', '126875', '1762521003', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (389, 'Tripay', '973847-251101378', 'INDOMARET', '', '470', '240909951457', '251101378', 'T4646028224557SWKOV', 'https://tripay.co.id/checkout/T4646028224557SWKOV', '1762521016', '2025-11-07', '1762607416', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (390, 'Tripay', '685593-251101378', 'INDOMARET', '', '470', '240909951457', '251101378', 'T4646028224625WM0SW', 'https://tripay.co.id/checkout/T4646028224625WM0SW', '1762521149', '2025-11-07', '1762607548', '', 'PAID', '126750', '1762521527', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (391, 'Tripay', '887769-251101076', 'QRIS2', '', '118', '240907151350', '251101076', 'T4646028224631FSHUA', 'https://tripay.co.id/checkout/T4646028224631FSHUA', '1762521159', '2025-11-07', '1762522958', '', 'PAID', '135000', '1762521218', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (392, 'Tripay', '747999-251101292', 'INDOMARET', '', '371', '250515113159', '251101292', 'T4646028224896GF9HE', 'https://tripay.co.id/checkout/T4646028224896GF9HE', '1762521644', '2025-11-07', '1762608044', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (393, 'Tripay', '54319-251101315', 'QRIS2', '', '397', '240909951432', '251101315', 'T4646028225258WPXVI', 'https://tripay.co.id/checkout/T4646028225258WPXVI', '1762522342', '2025-11-07', '1762524141', '', 'PAID', '165000', '1762522420', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (394, 'Tripay', '789904-251101306', 'BNIVA', '', '388', '100153', '251101306', 'T4646028225443VBCHT', 'https://tripay.co.id/checkout/T4646028225443VBCHT', '1762522678', '2025-11-07', '1762608957', '', 'PAID', '127125', '1762522787', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (395, 'Tripay', '537103-251101649', 'BCAVA', '', '751', '240909951575', '251101649', 'T4646028225660CDFPS', 'https://tripay.co.id/checkout/T4646028225660CDFPS', '1762523040', '2025-11-07', '1762609439', '', 'PAID', '127750', '1762523151', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (396, 'Tripay', '958803-251101384', 'BRIVA', '', '477', '240909951460', '251101384', 'T4646028225829Q96LC', 'https://tripay.co.id/checkout/T4646028225829Q96LC', '1762523344', '2025-11-07', '1762609734', '', 'PAID', '127125', '1762523440', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (397, 'Tripay', '911828-251101273', 'QRIS2', '', '351', '20250501042', '251101273', 'T46460282265982NSZF', 'https://tripay.co.id/checkout/T46460282265982NSZF', '1762525252', '2025-11-07', '1762527051', '', 'PAID', '205000', '1762525273', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (398, 'Tripay', '916186-251101431', 'QRIS2', '', '524', '240909951482', '251101431', 'T4646028227347R4KVC', 'https://tripay.co.id/checkout/T4646028227347R4KVC', '1762527151', '2025-11-07', '1762528950', '', 'PAID', '125000', '1762527199', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (399, 'Tripay', '372045-251101552', 'BCAVA', '', '653', '100237', '251101552', 'T4646028227670XWR23', 'https://tripay.co.id/checkout/T4646028227670XWR23', '1762528215', '2025-11-07', '1762614615', '', 'PAID', '127750', '1762528415', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (400, 'Tripay', '56682-251101021', 'QRIS2', '', '37', '200021', '251101021', 'T4646028227810MZHSQ', 'https://tripay.co.id/checkout/T4646028227810MZHSQ', '1762528769', '2025-11-07', '1762530569', '', 'PAID', '205000', '1762528829', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (401, 'Tripay', '800779-251101579', 'INDOMARET', '', '681', '240909951545', '251101579', 'T4646028227852WRICA', 'https://tripay.co.id/checkout/T4646028227852WRICA', '1762528914', '2025-11-07', '1762615312', '', 'PAID', '166750', '1762529146', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (402, 'Tripay', '321810-251101487', 'INDOMARET', '', '586', '240909951506', '251101487', 'T464602822812623VS2', 'https://tripay.co.id/checkout/T464602822812623VS2', '1762529790', '2025-11-07', '1762616189', '', 'PAID', '166750', '1762529856', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (403, 'Tripay', '465222-251101262', 'INDOMARET', '', '339', '20250501030', '251101262', 'T46460282281424LQPB', 'https://tripay.co.id/checkout/T46460282281424LQPB', '1762529858', '2025-11-07', '1762616258', '', 'PAID', '166750', '1762529925', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (404, 'Tripay', '563971-251101356', 'BCAVA', '', '445', '240909951445', '251101356', 'T4646028228152B0589', 'https://tripay.co.id/checkout/T4646028228152B0589', '1762529903', '2025-11-07', '1762616303', '', 'PAID', '127750', '1762530069', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (405, 'Tripay', '900169-251101565', 'ALFAMART', '', '666', '100248', '251101565', 'T46460282282390XWYG', 'https://tripay.co.id/checkout/T46460282282390XWYG', '1762530188', '2025-11-07', '1762616467', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (406, 'Tripay', '174405-251101084', 'BRIVA', '', '128', '240907151357', '251101084', 'T46460282286313JQJT', 'https://tripay.co.id/checkout/T46460282286313JQJT', '1762532101', '2025-11-07', '1762618492', '', 'PAID', '127125', '1762532169', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (407, 'Tripay', '828865-251101093', 'ALFAMART', '', '139', '240907151366', '251101093', 'T46460282308917IFI1', 'https://tripay.co.id/checkout/T46460282308917IFI1', '1762554180', '2025-11-08', '1762640459', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (408, 'Tripay', '180932-251101624', 'MANDIRIVA', '', '726', '240909951565', '251101624', 'T4646028230948S8LFZ', 'https://tripay.co.id/checkout/T4646028230948S8LFZ', '1762554565', '2025-11-08', '1762640958', '', 'PAID', '127125', '1762554645', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (409, 'Tripay', '280573-251101301', 'BNIVA', '', '381', '250515122704', '251101301', 'T4646028231563OIHSC', 'https://tripay.co.id/checkout/T4646028231563OIHSC', '1762557888', '2025-11-08', '1762644161', '', 'PAID', '127125', '1762557941', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (410, 'Tripay', '203584-251101678', 'DANA', '', '780', '240909951587', '251101678', 'T4646028231825VKPE1', 'https://tripay.co.id/checkout/T4646028231825VKPE1', '1762559151', '2025-11-08', '1762562630', '', 'PAID', '25000', '1762559183', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (411, 'Tripay', '38655-251101164', 'ALFAMART', '', '225', '240907151414', '251101164', 'T4646028232525QJSAJ', 'https://tripay.co.id/checkout/T4646028232525QJSAJ', '1762561682', '2025-11-08', '1762647962', '', 'PAID', '126750', '1762562045', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (412, 'Tripay', '232772-251101350', 'BRIVA', '', '438', '100104869', '251101350', 'T4646028232825CYCR3', 'https://tripay.co.id/checkout/T4646028232825CYCR3', '1762562871', '2025-11-08', '1762649264', '', 'PAID', '127125', '1762564506', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (413, 'Tripay', '292754-251101204', 'BRIVA', '', '275', '300013', '251101204', 'T464602823295423VRK', 'https://tripay.co.id/checkout/T464602823295423VRK', '1762563287', '2025-11-08', '1762649687', '', 'PAID', '127125', '1762563330', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (414, 'Tripay', '707730-251101592', 'INDOMARET', '', '694', '100258', '251101592', 'T4646028233085JWRCE', 'https://tripay.co.id/checkout/T4646028233085JWRCE', '1762563682', '2025-11-08', '1762650082', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (415, 'Tripay', '152674-251101414', 'INDOMARET', '', '507', '240909951472', '251101414', 'T4646028233324VTCNL', 'https://tripay.co.id/checkout/T4646028233324VTCNL', '1762564378', '2025-11-08', '1762650778', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (416, 'Tripay', '799307-251101592', 'INDOMARET', '', '694', '100258', '251101592', 'T4646028233340K1U0N', 'https://tripay.co.id/checkout/T4646028233340K1U0N', '1762564419', '2025-11-08', '1762650819', '', 'PAID', '126750', '1762564691', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (417, 'Tripay', '599128-251101455', 'INDOMARET', '', '550', '100105204', '251101455', 'T46460282334124SGFJ', 'https://tripay.co.id/checkout/T46460282334124SGFJ', '1762564619', '2025-11-08', '1762651018', '', 'PAID', '126750', '1762564996', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (418, 'Tripay', '507445-251101455', 'INDOMARET', '', '550', '100105204', '251101455', 'T46460282335637SGPQ', 'https://tripay.co.id/checkout/T46460282335637SGPQ', '1762565004', '2025-11-08', '1762651404', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (419, 'Tripay', '42160-251101515', 'INDOMARET', '', '616', '100228', '251101515', 'T4646028233672FEAPO', 'https://tripay.co.id/checkout/T4646028233672FEAPO', '1762565345', '2025-11-08', '1762651744', '', 'PAID', '126750', '1762566101', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (420, 'Tripay', '299363-251101403', 'DANA', '', '496', '100196', '251101403', 'T4646028234107GYHQ5', 'https://tripay.co.id/checkout/T4646028234107GYHQ5', '1762566549', '2025-11-08', '1762570028', '', 'PAID', '205000', '1762566676', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (421, 'Tripay', '911354-251101189', 'QRIS', '', '255', '300002', '251101189', 'T4646028234545RZYRQ', 'https://tripay.co.id/checkout/T4646028234545RZYRQ', '1762567730', '2025-11-08', '1762569530', '', 'PAID', '125812', '1762567763', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (422, 'Tripay', '691975-251101512', 'BRIVA', '', '613', '300056', '251101512', 'T4646028235544LKGMA', 'https://tripay.co.id/checkout/T4646028235544LKGMA', '1762570148', '2025-11-08', '1762656548', '', 'PAID', '127125', '1762570262', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (423, 'Tripay', '527720-251101544', 'DANA', '', '645', '300062', '251101544', 'T4646028235809RCRZD', 'https://tripay.co.id/checkout/T4646028235809RCRZD', '1762570901', '2025-11-08', '1762574380', '', 'PAID', '125000', '1762570950', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (424, 'Tripay', '746597-251101109', 'INDOMARET', '', '157', '100062', '251101109', 'T4646028235892FQ8IM', 'https://tripay.co.id/checkout/T4646028235892FQ8IM', '1762571131', '2025-11-08', '1762657530', '', 'PAID', '126750', '1762571450', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (425, 'Tripay', '822582-251101505', 'INDOMARET', '', '605', '240909951513', '251101505', 'T46460282365623IXXO', 'https://tripay.co.id/checkout/T46460282365623IXXO', '1762572771', '2025-11-08', '1762659171', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (426, 'Tripay', '306359-251101505', 'INDOMARET', '', '605', '240909951513', '251101505', 'T4646028236584Y0JRJ', 'https://tripay.co.id/checkout/T4646028236584Y0JRJ', '1762572814', '2025-11-08', '1762659214', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (427, 'Tripay', '304167-251101505', 'INDOMARET', '', '605', '240909951513', '251101505', 'T4646028236594OJ79Q', 'https://tripay.co.id/checkout/T4646028236594OJ79Q', '1762572855', '2025-11-08', '1762659255', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (428, 'Tripay', '449207-251101505', 'INDOMARET', '', '605', '240909951513', '251101505', 'T4646028236600DKZZO', 'https://tripay.co.id/checkout/T4646028236600DKZZO', '1762572874', '2025-11-08', '1762659274', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (429, 'Tripay', '745252-251101505', 'ALFAMART', '', '605', '240909951513', '251101505', 'T4646028236623BTORT', 'https://tripay.co.id/checkout/T4646028236623BTORT', '1762572946', '2025-11-08', '1762659226', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (430, 'Tripay', '790003-251101505', 'ALFAMART', '', '605', '240909951513', '251101505', 'T46460282366319L2Z1', 'https://tripay.co.id/checkout/T46460282366319L2Z1', '1762572977', '2025-11-08', '1762659257', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (431, 'Tripay', '474599-251101505', 'ALFAMART', '', '605', '240909951513', '251101505', 'T4646028236683PEM6A', 'https://tripay.co.id/checkout/T4646028236683PEM6A', '1762573089', '2025-11-08', '1762659368', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (432, 'Tripay', '6933-251101505', 'ALFAMART', '', '605', '240909951513', '251101505', 'T4646028236720IJCBS', 'https://tripay.co.id/checkout/T4646028236720IJCBS', '1762573183', '2025-11-08', '1762659463', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (433, 'Tripay', '258115-251101504', 'ALFAMART', '', '604', '240909951512', '251101504', 'T4646028236768MIJW4', 'https://tripay.co.id/checkout/T4646028236768MIJW4', '1762573336', '2025-11-08', '1762659615', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (434, 'Tripay', '948982-251101435', 'ALFAMART', '', '528', '240909951484', '251101435', 'T4646028236786TQV2M', 'https://tripay.co.id/checkout/T4646028236786TQV2M', '1762573375', '2025-11-08', '1762659655', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (435, 'Tripay', '642777-251101207', 'INDOMARET', '', '279', '100111', '251101207', 'T4646028237535EMR8W', 'https://tripay.co.id/checkout/T4646028237535EMR8W', '1762575427', '2025-11-08', '1762661826', '', 'PAID', '126750', '1762575691', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (436, 'Tripay', '308474-251101335', 'MANDIRIVA', '', '423', '100171', '251101335', 'T4646028237577DL26G', 'https://tripay.co.id/checkout/T4646028237577DL26G', '1762575540', '2025-11-08', '1762661940', '', 'PAID', '127125', '1762575638', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (437, 'Tripay', '502977-251101394', 'INDOMARET', '', '487', '240909951462', '251101394', 'T4646028238740EK5CY', 'https://tripay.co.id/checkout/T4646028238740EK5CY', '1762578833', '2025-11-08', '1762665232', '', 'PAID', '126750', '1762582958', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (438, 'Tripay', '121154-251101492', 'INDOMARET', '', '591', '300054', '251101492', 'T4646028238916A9WNQ', 'https://tripay.co.id/checkout/T4646028238916A9WNQ', '1762579207', '2025-11-08', '1762665607', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (439, 'Tripay', '116123-251101492', 'INDOMARET', '', '591', '300054', '251101492', 'T4646028238927FCOQ3', 'https://tripay.co.id/checkout/T4646028238927FCOQ3', '1762579244', '2025-11-08', '1762665644', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (440, 'Tripay', '188699-251101492', 'INDOMARET', '', '591', '300054', '251101492', 'T46460282389566CRIZ', 'https://tripay.co.id/checkout/T46460282389566CRIZ', '1762579303', '2025-11-08', '1762665703', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (441, 'Tripay', '233420-251101620', 'ALFAMART', '', '722', '240909951563', '251101620', 'T4646028239342Y27KA', 'https://tripay.co.id/checkout/T4646028239342Y27KA', '1762580435', '2025-11-08', '1762666715', '', 'PAID', '126750', '1762580475', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (442, 'Tripay', '114423-251101492', 'INDOMARET', '', '591', '300054', '251101492', 'T4646028240527SVYDJ', 'https://tripay.co.id/checkout/T4646028240527SVYDJ', '1762583701', '2025-11-08', '1762670101', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (443, 'Tripay', '481059-251101492', 'BRIVA', '', '591', '300054', '251101492', 'T4646028240905CVNCT', 'https://tripay.co.id/checkout/T4646028240905CVNCT', '1762584821', '2025-11-08', '1762671220', '', 'PAID', '127125', '1762585031', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (444, 'Tripay', '751416-251101305', 'BCAVA', '', '387', '250515130005', '251101305', 'T4646028242055KJ8KY', 'https://tripay.co.id/checkout/T4646028242055KJ8KY', '1762587808', '2025-11-08', '1762674208', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (445, 'Tripay', '953073-251101121', 'ALFAMART', '', '170', '240907151386', '251101121', 'T4646028242147FF7EB', 'https://tripay.co.id/checkout/T4646028242147FF7EB', '1762588065', '2025-11-08', '1762674345', '', 'PAID', '126750', '1762588975', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (446, 'Tripay', '532597-251101121', 'ALFAMART', '', '170', '240907151386', '251101121', 'T4646028242309FNJEF', 'https://tripay.co.id/checkout/T4646028242309FNJEF', '1762588481', '2025-11-08', '1762674761', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (447, 'Tripay', '266065-251101291', 'INDOMARET', '', '370', '250515112944', '251101291', 'T4646028242442CTFLR', 'https://tripay.co.id/checkout/T4646028242442CTFLR', '1762588793', '2025-11-08', '1762675192', '', 'PAID', '126750', '1762588851', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (448, 'Tripay', '457402-251101188', 'QRIS', '', '254', '300001', '251101188', 'T4646028242891YCUZT', 'https://tripay.co.id/checkout/T4646028242891YCUZT', '1762589771', '2025-11-08', '1762593250', '', 'PAID', '125812', '1762589808', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (449, 'Tripay', '117685-251101618', 'BNIVA', '', '720', '100270', '251101618', 'T46460282434846CJPE', 'https://tripay.co.id/checkout/T46460282434846CJPE', '1762591262', '2025-11-08', '1762677534', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (450, 'Tripay', '452479-251101618', 'BNIVA', '', '720', '100270', '251101618', 'T4646028243538ATWKO', 'https://tripay.co.id/checkout/T4646028243538ATWKO', '1762591408', '2025-11-08', '1762677688', '', 'PAID', '127125', '1762591485', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (451, 'Tripay', '579112-251101085', 'BRIVA', '', '130', '240907151359', '251101085', 'T4646028243844WVH9Q', 'https://tripay.co.id/checkout/T4646028243844WVH9Q', '1762592382', '2025-11-08', '1762678782', '', 'PAID', '127125', '1762592456', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (452, 'Tripay', '443875-251101329', 'INDOMARET', '', '414', '300021', '251101329', 'T4646028244136OXROU', 'https://tripay.co.id/checkout/T4646028244136OXROU', '1762593153', '2025-11-08', '1762679553', '', 'PAID', '126750', '1762593207', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (453, 'Tripay', '959098-251101593', 'INDOMARET', '', '695', '240909951551', '251101593', 'T46460282444385GEZI', 'https://tripay.co.id/checkout/T46460282444385GEZI', '1762594018', '2025-11-08', '1762680418', '', 'PAID', '126750', '1762594270', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (454, 'Tripay', '717280-251101183', 'INDOMARET', '', '249', '20250501055', '251101183', 'T4646028246364EY5WG', 'https://tripay.co.id/checkout/T4646028246364EY5WG', '1762598575', '2025-11-08', '1762684975', '', 'PAID', '126750', '1762599002', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (455, 'Tripay', '419791-251101481', 'INDOMARET', '', '580', '100216', '251101481', 'T46460282463859Q1MH', 'https://tripay.co.id/checkout/T46460282463859Q1MH', '1762598625', '2025-11-08', '1762685024', '', 'PAID', '126750', '1762607618', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (456, 'Tripay', '414770-251101093', 'ALFAMART', '', '139', '240907151366', '251101093', 'T4646028246459YWZQ2', 'https://tripay.co.id/checkout/T4646028246459YWZQ2', '1762598708', '2025-11-08', '1762684988', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (457, 'Tripay', '562169-251101452', 'MANDIRIVA', '', '547', '100208', '251101452', 'T4646028247306XYFWZ', 'https://tripay.co.id/checkout/T4646028247306XYFWZ', '1762600627', '2025-11-08', '1762687020', '', 'PAID', '167125', '1762600724', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (458, 'Tripay', '434933-251107002', 'QRIS2', '', '745', '400002', '251107002', 'T4646028247681AUD0I', 'https://tripay.co.id/checkout/T4646028247681AUD0I', '1762601429', '2025-11-08', '1762603228', '', 'PAID', '55000', '1762601559', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (459, 'Tripay', '438772-251101525', 'INDOMARET', '', '626', '240909951518', '251101525', 'T4646028248564JQ5A1', 'https://tripay.co.id/checkout/T4646028248564JQ5A1', '1762603131', '2025-11-08', '1762689530', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (460, 'Tripay', '701904-251101396', 'MANDIRIVA', '', '489', '300033', '251101396', 'T4646028249247RNCDF', 'https://tripay.co.id/checkout/T4646028249247RNCDF', '1762604397', '2025-11-08', '1762690790', '', 'PAID', '127125', '1762604530', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (461, 'Tripay', '564004-251101129', 'SHOPEEPAY', '', '178', '240907151391', '251101129', 'T4646028249396B0XUV', 'https://tripay.co.id/checkout/T4646028249396B0XUV', '1762604688', '2025-11-08', '1762608167', '', 'PAID', '126875', '1762604760', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (462, 'Tripay', '918792-251101602', 'BCAVA', '', '704', '240909951555', '251101602', 'T4646028251068T1IE3', 'https://tripay.co.id/checkout/T4646028251068T1IE3', '1762608318', '2025-11-08', '1762694717', '', 'PAID', '127750', '1762608380', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (463, 'Tripay', '210126-251101474', 'INDOMARET', '', '572', '240909951499', '251101474', 'T4646028251432XFMEY', 'https://tripay.co.id/checkout/T4646028251432XFMEY', '1762609245', '2025-11-08', '1762695644', '', 'PAID', '126750', '1762609299', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (464, 'Tripay', '498203-251101699', 'INDOMARET', '', '801', '300076', '251101699', 'T4646028254058UCUO0', 'https://tripay.co.id/checkout/T4646028254058UCUO0', '1762618278', '2025-11-08', '1762704677', '', 'UNPAID', '79750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (465, 'Tripay', '548830-251101699', 'INDOMARET', '', '801', '300076', '251101699', 'T4646028254108MQHWW', 'https://tripay.co.id/checkout/T4646028254108MQHWW', '1762618602', '2025-11-08', '1762705002', '', 'UNPAID', '79750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (466, 'Tripay', '919057-251101699', 'INDOMARET', '', '801', '300076', '251101699', 'T4646028254154DDL7T', 'https://tripay.co.id/checkout/T4646028254154DDL7T', '1762618852', '2025-11-08', '1762705251', '', 'PAID', '79750', '1762618906', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (467, 'Tripay', '792822-251101676', 'BCAVA', '', '778', '240909951586', '251101676', 'T4646028257578RALZH', 'https://tripay.co.id/checkout/T4646028257578RALZH', '1762647955', '2025-11-09', '1762734354', '', 'PAID', '32750', '1762648092', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (468, 'Tripay', '589260-251101098', 'BCAVA', '', '145', '240907151371', '251101098', 'T4646028258799WVMUD', 'https://tripay.co.id/checkout/T4646028258799WVMUD', '1762652048', '2025-11-09', '1762738447', '', 'PAID', '207750', '1762652144', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (469, 'Tripay', '752508-251101253', 'SHOPEEPAY', '', '329', '20250501020', '251101253', 'T4646028260589BONXU', 'https://tripay.co.id/checkout/T4646028260589BONXU', '1762656755', '2025-11-09', '1762660235', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (470, 'Tripay', '273995-251101300', 'MANDIRIVA', '', '380', '250515122505', '251101300', 'T4646028260961JXPNP', 'https://tripay.co.id/checkout/T4646028260961JXPNP', '1762657673', '2025-11-09', '1762744066', '', 'PAID', '167125', '1762657785', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (471, 'Tripay', '684285-251101317', 'QRIS2', '', '399', '240909951433', '251101317', 'T4646028261369CPFQ7', 'https://tripay.co.id/checkout/T4646028261369CPFQ7', '1762658659', '2025-11-09', '1762660459', '', 'PAID', '125000', '1762659674', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (472, 'Tripay', '988455-251101596', 'INDOMARET', '', '698', '100259', '251101596', 'T4646028262003QRFWM', 'https://tripay.co.id/checkout/T4646028262003QRFWM', '1762660485', '2025-11-09', '1762746885', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (473, 'Tripay', '316805-251101055', 'INDOMARET', '', '87', '240907151328', '251101055', 'T4646028262299MZ4LS', 'https://tripay.co.id/checkout/T4646028262299MZ4LS', '1762661284', '2025-11-09', '1762747683', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (474, 'Tripay', '45139-251101459', 'BNIVA', '', '554', '100211', '251101459', 'T4646028262897X4O4T', 'https://tripay.co.id/checkout/T4646028262897X4O4T', '1762663098', '2025-11-09', '1762749371', '', 'PAID', '207125', '1762663277', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (475, 'Tripay', '389302-251101127', 'ALFAMART', '', '176', '240907151390', '251101127', 'T4646028263216DZNOE', 'https://tripay.co.id/checkout/T4646028263216DZNOE', '1762663953', '2025-11-09', '1762750232', '', 'PAID', '126750', '1762664256', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (476, 'Tripay', '586750-251101386', 'ALFAMART', '', '479', '100189', '251101386', 'T4646028263319BIQX6', 'https://tripay.co.id/checkout/T4646028263319BIQX6', '1762664203', '2025-11-09', '1762750483', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (477, 'Tripay', '168104-251101386', 'ALFAMART', '', '479', '100189', '251101386', 'T4646028263388C7WUI', 'https://tripay.co.id/checkout/T4646028263388C7WUI', '1762664409', '2025-11-09', '1762750689', '', 'PAID', '126750', '1762665280', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (478, 'Tripay', '239960-251101687', 'BNIVA', '', '789', '400008', '251101687', 'T4646028270638LMFIP', 'https://tripay.co.id/checkout/T4646028270638LMFIP', '1762682994', '2025-11-09', '1762769267', '', 'PAID', '127125', '1762683107', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (479, 'Tripay', '680631-251101039', 'INDOMARET', '', '60', '100025', '251101039', 'T4646028271788XE8VZ', 'https://tripay.co.id/checkout/T4646028271788XE8VZ', '1762685280', '2025-11-09', '1762771679', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (480, 'Tripay', '360177-251101039', 'INDOMARET', '', '60', '100025', '251101039', 'T4646028271851EBGG9', 'https://tripay.co.id/checkout/T4646028271851EBGG9', '1762685399', '2025-11-09', '1762771798', '', 'PAID', '126750', '1762685747', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (481, 'Tripay', '471735-251101550', 'INDOMARET', '', '651', '300066', '251101550', 'T4646028274452HOJJK', 'https://tripay.co.id/checkout/T4646028274452HOJJK', '1762690244', '2025-11-09', '1762776643', '', 'PAID', '126750', '1762690308', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (482, 'Tripay', '474092-251101410', 'QRIS2', '', '503', '240909951469', '251101410', 'T4646028274557OK5XN', 'https://tripay.co.id/checkout/T4646028274557OK5XN', '1762690416', '2025-11-09', '1762692215', '', 'PAID', '125000', '1762690430', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (483, 'Tripay', '607032-251101457', 'MANDIRIVA', '', '552', '100105234', '251101457', 'T4646028278455ILYQZ', 'https://tripay.co.id/checkout/T4646028278455ILYQZ', '1762698462', '2025-11-09', '1762784855', '', 'PAID', '127125', '1762698639', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (484, 'Tripay', '388585-251101313', 'MANDIRIVA', '', '395', '240909951430', '251101313', 'T4646028279568X5FD3', 'https://tripay.co.id/checkout/T4646028279568X5FD3', '1762701939', '2025-11-09', '1762788332', '', 'PAID', '127125', '1762702026', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (485, 'Tripay', '902296-251101332', 'BCAVA', '', '418', '240909951438', '251101332', 'T46460282856223XIJY', 'https://tripay.co.id/checkout/T46460282856223XIJY', '1762736450', '2025-11-10', '1762822850', '', 'PAID', '127750', '1762736561', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (486, 'Tripay', '45075-251101647', 'ALFAMART', '', '749', '240909951573', '251101647', 'T4646028286078RCZI5', 'https://tripay.co.id/checkout/T4646028286078RCZI5', '1762737310', '2025-11-10', '1762823590', '', 'PAID', '126750', '1762737378', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (487, 'Tripay', '182290-251101279', 'BRIVA', '', '358', '20250501049', '251101279', 'T46460282865944UQYQ', 'https://tripay.co.id/checkout/T46460282865944UQYQ', '1762738392', '2025-11-10', '1762824783', '', 'PAID', '127125', '1762738505', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (488, 'Tripay', '849313-251101482', 'QRIS2', '', '581', '240909951504', '251101482', 'T4646028287598GSLYB', 'https://tripay.co.id/checkout/T4646028287598GSLYB', '1762739819', '2025-11-10', '1762743419', '', 'PAID', '125000', '1762739855', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (489, 'Tripay', '182336-251101679', 'INDOMARET', '', '781', '240909951588', '251101679', 'T4646028288481RUQBC', 'https://tripay.co.id/checkout/T4646028288481RUQBC', '1762740739', '2025-11-10', '1762827139', '', 'PAID', '26750', '1762741133', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (490, 'Tripay', '425686-251101525', 'INDOMARET', '', '626', '240909951518', '251101525', 'T4646028288758RGASM', 'https://tripay.co.id/checkout/T4646028288758RGASM', '1762741117', '2025-11-10', '1762827517', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (491, 'Tripay', '591087-251101694', 'ALFAMART', '', '796', '240909951592', '251101694', 'T4646028289011KG4YY', 'https://tripay.co.id/checkout/T4646028289011KG4YY', '1762741528', '2025-11-10', '1762827808', '', 'UNPAID', '60750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (492, 'Tripay', '199764-251101694', 'INDOMARET', '', '796', '240909951592', '251101694', 'T4646028289062Z4XOT', 'https://tripay.co.id/checkout/T4646028289062Z4XOT', '1762741577', '2025-11-10', '1762827977', '', 'UNPAID', '60750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (493, 'Tripay', '349044-251101694', 'INDOMARET', '', '796', '240909951592', '251101694', 'T4646028289096SYHF3', 'https://tripay.co.id/checkout/T4646028289096SYHF3', '1762741645', '2025-11-10', '1762828044', '', 'UNPAID', '60750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (494, 'Tripay', '860380-251101525', 'INDOMARET', '', '626', '240909951518', '251101525', 'T4646028289452SQYLB', 'https://tripay.co.id/checkout/T4646028289452SQYLB', '1762742258', '2025-11-10', '1762828658', '', 'PAID', '126750', '1762743181', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (495, 'Tripay', '262043-251101269', 'DANA', '', '347', '20250501038', '251101269', 'T4646028290984JCXXN', 'https://tripay.co.id/checkout/T4646028290984JCXXN', '1762744483', '2025-11-10', '1762747962', '', 'PAID', '125000', '1762744518', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (496, 'Tripay', '679949-251101089', 'BRIVA', '', '135', '240907151362', '251101089', 'T4646028291176NNXHE', 'https://tripay.co.id/checkout/T4646028291176NNXHE', '1762744810', '2025-11-10', '1762831203', '', 'PAID', '127125', '1762744896', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (497, 'Tripay', '832180-251101489', 'BCAVA', '', '588', '240909951507', '251101489', 'T4646028291341BEXT4', 'https://tripay.co.id/checkout/T4646028291341BEXT4', '1762745135', '2025-11-10', '1762831535', '', 'PAID', '167750', '1762745203', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (498, 'Tripay', '318072-251101694', 'INDOMARET', '', '796', '240909951592', '251101694', 'T4646028292050AO547', 'https://tripay.co.id/checkout/T4646028292050AO547', '1762746328', '2025-11-10', '1762832728', '', 'UNPAID', '60750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (499, 'Tripay', '480324-251101426', 'BRIVA', '', '519', '300038', '251101426', 'T4646028293317WXLIQ', 'https://tripay.co.id/checkout/T4646028293317WXLIQ', '1762748462', '2025-11-10', '1762834854', '', 'PAID', '127125', '1762748640', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (500, 'Tripay', '472907-251101435', 'ALFAMART', '', '528', '240909951484', '251101435', 'T4646028294238CR8VZ', 'https://tripay.co.id/checkout/T4646028294238CR8VZ', '1762749748', '2025-11-10', '1762836028', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (501, 'Tripay', '445697-251101504', 'ALFAMART', '', '604', '240909951512', '251101504', 'T4646028294283HBHQV', 'https://tripay.co.id/checkout/T4646028294283HBHQV', '1762749820', '2025-11-10', '1762836100', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (502, 'Tripay', '986507-251101435', 'ALFAMART', '', '528', '240909951484', '251101435', 'T4646028294434O02AH', 'https://tripay.co.id/checkout/T4646028294434O02AH', '1762750102', '2025-11-10', '1762836382', '', 'PAID', '126750', '1762750354', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (503, 'Tripay', '243156-251101636', 'DANA', '', '738', '100276', '251101636', 'T4646028294554KTTXF', 'https://tripay.co.id/checkout/T4646028294554KTTXF', '1762750323', '2025-11-10', '1762753802', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (504, 'Tripay', '729464-251101636', 'DANA', '', '738', '100276', '251101636', 'T4646028294572PLRR2', 'https://tripay.co.id/checkout/T4646028294572PLRR2', '1762750364', '2025-11-10', '1762753843', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (505, 'Tripay', '635648-251101504', 'ALFAMART', '', '604', '240909951512', '251101504', 'T4646028294577LQ1MZ', 'https://tripay.co.id/checkout/T4646028294577LQ1MZ', '1762750369', '2025-11-10', '1762836649', '', 'PAID', '126750', '1762750399', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (506, 'Tripay', '157043-251101636', 'DANA', '', '738', '100276', '251101636', 'T4646028294585REOYE', 'https://tripay.co.id/checkout/T4646028294585REOYE', '1762750389', '2025-11-10', '1762753869', '', 'PAID', '125000', '1762750408', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (507, 'Tripay', '247499-251101541', 'QRIS2', '', '642', '240909951531', '251101541', 'T4646028295489JSURI', 'https://tripay.co.id/checkout/T4646028295489JSURI', '1762752146', '2025-11-10', '1762753946', '', 'PAID', '125000', '1762752178', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (508, 'Tripay', '605458-251101604', 'BCAVA', '', '706', '240909951556', '251101604', 'T46460282967607ERJY', 'https://tripay.co.id/checkout/T46460282967607ERJY', '1762754529', '2025-11-10', '1762840929', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (509, 'Tripay', '961850-251101604', 'BCAVA', '', '706', '240909951556', '251101604', 'T4646028296895UOSDX', 'https://tripay.co.id/checkout/T4646028296895UOSDX', '1762754809', '2025-11-10', '1762841209', '', 'PAID', '127750', '1762755027', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (510, 'Tripay', '436697-251101628', 'QRIS2', '', '730', '300071', '251101628', 'T4646028299774SAUYI', 'https://tripay.co.id/checkout/T4646028299774SAUYI', '1762760606', '2025-11-10', '1762762406', '', 'PAID', '125000', '1762760634', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (511, 'Tripay', '329992-251101532', 'BRIVA', '', '633', '300059', '251101532', 'T4646028300763KCJOK', 'https://tripay.co.id/checkout/T4646028300763KCJOK', '1762762760', '2025-11-10', '1762849153', '', 'PAID', '127125', '1762762801', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (512, 'Tripay', '527823-251101471', 'BNIVA', '', '569', '100105260', '251101471', 'T4646028301403YSVAS', 'https://tripay.co.id/checkout/T4646028301403YSVAS', '1762763978', '2025-11-10', '1762850257', '', 'PAID', '207125', '1762764119', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (513, 'Tripay', '456612-251101696', 'INDOMARET', '', '798', '240909951594', '251101696', 'T4646028303129OETNP', 'https://tripay.co.id/checkout/T4646028303129OETNP', '1762766889', '2025-11-10', '1762853288', '', 'PAID', '51750', '1762766994', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (514, 'Tripay', '796402-251101280', 'QRIS', '', '359', '20250501050', '251101280', 'T4646028303494UDAUT', 'https://tripay.co.id/checkout/T4646028303494UDAUT', '1762767524', '2025-11-10', '1762769324', '', 'PAID', '125812', '1762767836', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (515, 'Tripay', '378300-251101692', 'QRIS2', '', '794', '240909951590', '251101692', 'T46460283038490T67M', 'https://tripay.co.id/checkout/T46460283038490T67M', '1762768118', '2025-11-10', '1762769917', '', 'UNPAID', '80000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (516, 'Tripay', '254647-251101692', 'QRIS2', '', '794', '240909951590', '251101692', 'T4646028303995E4XM0', 'https://tripay.co.id/checkout/T4646028303995E4XM0', '1762768333', '2025-11-10', '1762770132', '', 'PAID', '80000', '1762768362', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (517, 'Tripay', '684735-251101195', 'INDOMARET', '', '265', '240907151435', '251101195', 'T46460283049195AMWZ', 'https://tripay.co.id/checkout/T46460283049195AMWZ', '1762769605', '2025-11-10', '1762856004', '', 'PAID', '126750', '1762769666', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (518, 'Tripay', '779260-251101292', 'INDOMARET', '', '371', '250515113159', '251101292', 'T4646028305401QGDP0', 'https://tripay.co.id/checkout/T4646028305401QGDP0', '1762770310', '2025-11-10', '1762856709', '', 'PAID', '126750', '1762779453', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (519, 'Tripay', '529401-251101190', 'BRIVA', '', '257', '300004', '251101190', 'T4646028306963XT620', 'https://tripay.co.id/checkout/T4646028306963XT620', '1762772404', '2025-11-10', '1762858802', '', 'PAID', '127125', '1762772705', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (520, 'Tripay', '435381-251101510', 'SHOPEEPAY', '', '611', '100226', '251101510', 'T464602830950106VEP', 'https://tripay.co.id/checkout/T464602830950106VEP', '1762775151', '2025-11-10', '1762778631', '', 'PAID', '126875', '1762775195', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (521, 'Tripay', '936119-251101695', 'INDOMARET', '', '797', '240909951593', '251101695', 'T4646028310876CLTKO', 'https://tripay.co.id/checkout/T4646028310876CLTKO', '1762776635', '2025-11-10', '1762863034', '', 'UNPAID', '60750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (522, 'Tripay', '151391-251101708', 'QRIS2', '', '810', '100296', '251101708', 'T4646028312355S0QGN', 'https://tripay.co.id/checkout/T4646028312355S0QGN', '1762778471', '2025-11-10', '1762780270', '', 'PAID', '17000', '1762778537', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (523, 'Tripay', '748479-251101093', 'INDOMARET', '', '139', '240907151366', '251101093', 'T4646028315433UVKVL', 'https://tripay.co.id/checkout/T4646028315433UVKVL', '1762782344', '2025-11-10', '1762868744', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (524, 'Tripay', '229990-251101093', 'INDOMARET', '', '139', '240907151366', '251101093', 'T4646028315812TQDTT', 'https://tripay.co.id/checkout/T4646028315812TQDTT', '1762782857', '2025-11-10', '1762869257', '', 'PAID', '126750', '1762783153', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (525, 'Tripay', '952911-251101338', 'BNIVA', '', '426', '100173', '251101338', 'T4646028322808VUT16', 'https://tripay.co.id/checkout/T4646028322808VUT16', '1762814948', '2025-11-11', '1762901221', '', 'PAID', '127125', '1762815059', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (526, 'Tripay', '848121-251101703', 'BRIVA', '', '805', '100100001', '251101703', 'T46460283249622Z3TU', 'https://tripay.co.id/checkout/T46460283249622Z3TU', '1762820996', '2025-11-11', '1762907395', '', 'PAID', '27125', '1762821135', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (527, 'Tripay', '646924-251101442', 'MANDIRIVA', '', '535', '240909951486', '251101442', 'T4646028327930SE9VR', 'https://tripay.co.id/checkout/T4646028327930SE9VR', '1762827224', '2025-11-11', '1762913616', '', 'PAID', '127125', '1762827613', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (528, 'Tripay', '3195-251101698', 'INDOMARET', '', '800', '240909951595', '251101698', 'T4646028333157XD983', 'https://tripay.co.id/checkout/T4646028333157XD983', '1762838906', '2025-11-11', '1762925306', '', 'PAID', '43750', '1762839282', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (529, 'Tripay', '63491-251101656', 'QRIS', '', '758', '300072', '251101656', 'T46460283339809R6YI', 'https://tripay.co.id/checkout/T46460283339809R6YI', '1762840866', '2025-11-11', '1762842666', '', 'PAID', '71623', '1762840915', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (530, 'Tripay', '745460-251101412', 'MANDIRIVA', '', '505', '240909951470', '251101412', 'T4646028339294FASUX', 'https://tripay.co.id/checkout/T4646028339294FASUX', '1762853635', '2025-11-11', '1762940027', '', 'PAID', '207125', '1762853716', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (531, 'Tripay', '895651-251101596', 'INDOMARET', '', '698', '100259', '251101596', 'T4646028340825L4EUL', 'https://tripay.co.id/checkout/T4646028340825L4EUL', '1762856795', '2025-11-11', '1762943194', '', 'PAID', '126750', '1762856855', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (532, 'Tripay', '986033-251101343', 'BRIVA', '', '431', '300024', '251101343', 'T4646028342140LS7H8', 'https://tripay.co.id/checkout/T4646028342140LS7H8', '1762858879', '2025-11-11', '1762945271', '', 'PAID', '127125', '1762859316', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (533, 'Tripay', '90306-251101077', 'BCAVA', '', '119', '240907151351', '251101077', 'T4646028343106YS3ED', 'https://tripay.co.id/checkout/T4646028343106YS3ED', '1762860051', '2025-11-11', '1762946450', '', 'PAID', '127750', '1762860106', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (534, 'Tripay', '492673-251101637', 'QRIS2', '', '739', '240909951568', '251101637', 'T4646028346908TUN7U', 'https://tripay.co.id/checkout/T4646028346908TUN7U', '1762866128', '2025-11-11', '1762952408', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (535, 'Tripay', '69289-251101637', 'INDOMARET', '', '739', '240909951568', '251101637', 'T4646028346958KNS6F', 'https://tripay.co.id/checkout/T4646028346958KNS6F', '1762866215', '2025-11-11', '1762952615', '', 'PAID', '126750', '1762867312', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (536, 'Tripay', '724717-251101253', 'SHOPEEPAY', '', '329', '20250501020', '251101253', 'T4646028347974WPAQV', 'https://tripay.co.id/checkout/T4646028347974WPAQV', '1762868476', '2025-11-11', '1762871956', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (537, 'Tripay', '179152-251101253', 'QRIS2', '', '329', '20250501020', '251101253', 'T4646028349101FCKKV', 'https://tripay.co.id/checkout/T4646028349101FCKKV', '1762871466', '2025-11-11', '1762875066', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (538, 'Tripay', '895292-251101253', 'QRIS2', '', '329', '20250501020', '251101253', 'T4646028349126C6IDM', 'https://tripay.co.id/checkout/T4646028349126C6IDM', '1762871548', '2025-11-11', '1762873348', '', 'PAID', '125000', '1762871589', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (539, 'Tripay', '199238-251101420', 'INDOMARET', '', '513', '240909951475', '251101420', 'T4646028355420RMOKN', 'https://tripay.co.id/checkout/T4646028355420RMOKN', '1762911240', '2025-11-12', '1762997640', '', 'PAID', '126750', '1762913207', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (540, 'Tripay', '380764-251101174', 'BNIVA', '', '240', '100101', '251101174', 'T4646028365816ZKJRV', 'https://tripay.co.id/checkout/T4646028365816ZKJRV', '1762939878', '2025-11-12', '1763026150', '', 'PAID', '127125', '1762939947', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (541, 'Tripay', '230166-251101498', 'DANA', '', '597', '100105323', '251101498', 'T4646028366509WL9YC', 'https://tripay.co.id/checkout/T4646028366509WL9YC', '1762941742', '2025-11-12', '1762945221', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (542, 'Tripay', '925442-251101498', 'INDOMARET', '', '597', '100105323', '251101498', 'T4646028366604THQE3', 'https://tripay.co.id/checkout/T4646028366604THQE3', '1762941972', '2025-11-12', '1763028371', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (543, 'Tripay', '707843-251101498', 'DANA', '', '597', '100105323', '251101498', 'T4646028366616TTUXN', 'https://tripay.co.id/checkout/T4646028366616TTUXN', '1762942000', '2025-11-12', '1762945479', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (544, 'Tripay', '147247-251101451', 'BNIVA', '', '546', '300048', '251101451', 'T4646028368216FBAGC', 'https://tripay.co.id/checkout/T4646028368216FBAGC', '1762945868', '2025-11-12', '1763032140', '', 'PAID', '127125', '1762945982', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (545, 'Tripay', '795503-251101372', 'INDOMARET', '', '463', '100183', '251101372', 'T4646028369527PLCDP', 'https://tripay.co.id/checkout/T4646028369527PLCDP', '1762948617', '2025-11-12', '1763035017', '', 'PAID', '126750', '1762948928', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (546, 'Tripay', '893795-251101363', 'BCAVA', '', '452', '240909951448', '251101363', 'T4646028374113AEO4E', 'https://tripay.co.id/checkout/T4646028374113AEO4E', '1762960784', '2025-11-12', '1763047183', '', 'PAID', '127750', '1762960929', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (547, 'Tripay', '772128-251101271', 'BRIVA', '', '349', '20250501040', '251101271', 'T4646028386030PZBOB', 'https://tripay.co.id/checkout/T4646028386030PZBOB', '1763019762', '2025-11-13', '1763106153', '', 'UNPAID', '98125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (548, 'Tripay', '157597-251101271', 'DANA', '', '349', '20250501040', '251101271', 'T4646028386113WV4HK', 'https://tripay.co.id/checkout/T4646028386113WV4HK', '1763020042', '2025-11-13', '1763023521', '', 'PAID', '96000', '1763020152', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (549, 'Tripay', '566062-251101228', 'QRIS2', '', '304', '100124', '251101228', 'T4646028387094BP6NY', 'https://tripay.co.id/checkout/T4646028387094BP6NY', '1763023367', '2025-11-13', '1763025167', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (550, 'Tripay', '739535-251101228', 'QRIS2', '', '304', '100124', '251101228', 'T4646028387793C506N', 'https://tripay.co.id/checkout/T4646028387793C506N', '1763025907', '2025-11-13', '1763027706', '', 'PAID', '165000', '1763026216', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (551, 'Tripay', '105567-251101261', 'INDOMARET', '', '338', '20250501029', '251101261', 'T4646028388386RS0AX', 'https://tripay.co.id/checkout/T4646028388386RS0AX', '1763027800', '2025-11-13', '1763114199', '', 'PAID', '126750', '1763027966', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (552, 'Tripay', '838502-251101695', 'INDOMARET', '', '797', '240909951593', '251101695', 'T4646028389124CFQM6', 'https://tripay.co.id/checkout/T4646028389124CFQM6', '1763029846', '2025-11-13', '1763116245', '', 'PAID', '60750', '1763031150', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (553, 'Tripay', '849269-251101498', 'INDOMARET', '', '597', '100105323', '251101498', 'T46460284001660RJZM', 'https://tripay.co.id/checkout/T46460284001660RJZM', '1763080367', '2025-11-14', '1763166767', '', 'PAID', '126750', '1763080422', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (554, 'Tripay', '823348-251101341', 'DANA', '', '429', '240909951441', '251101341', 'T4646028412275AKQVL', 'https://tripay.co.id/checkout/T4646028412275AKQVL', '1763115351', '2025-11-14', '1763118830', '', 'PAID', '125000', '1763115383', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (555, 'Tripay', '414518-251101549', 'INDOMARET', '', '650', '300065', '251101549', 'T4646028416556VXQME', 'https://tripay.co.id/checkout/T4646028416556VXQME', '1763124320', '2025-11-14', '1763210720', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (556, 'Tripay', '858657-251101549', 'INDOMARET', '', '650', '300065', '251101549', 'T46460284166157ITSN', 'https://tripay.co.id/checkout/T46460284166157ITSN', '1763124436', '2025-11-14', '1763210836', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (557, 'Tripay', '729737-251101549', 'INDOMARET', '', '650', '300065', '251101549', 'T46460284166271XW1U', 'https://tripay.co.id/checkout/T46460284166271XW1U', '1763124482', '2025-11-14', '1763210881', '', 'PAID', '126750', '1763124571', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (558, 'Tripay', '441388-251101352', 'QRIS', '', '440', '100104871', '251101352', 'T4646028416858V4NB7', 'https://tripay.co.id/checkout/T4646028416858V4NB7', '1763124885', '2025-11-14', '1763126684', '', 'PAID', '125812', '1763124921', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (559, 'Tripay', '812528-251101079', 'BCAVA', '', '121', '100050', '251101079', 'T4646028445896WSRUF', 'https://tripay.co.id/checkout/T4646028445896WSRUF', '1763212328', '2025-11-15', '1763298727', '', 'PAID', '127750', '1763212380', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (560, 'Tripay', '22336-251101124', 'DANA', '', '173', '100068', '251101124', 'T4646028449391EQQB2', 'https://tripay.co.id/checkout/T4646028449391EQQB2', '1763222223', '2025-11-15', '1763225702', '', 'PAID', '125000', '1763222297', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (561, 'Tripay', '210907-251101414', 'INDOMARET', '', '507', '240909951472', '251101414', 'T4646028463994RXTYX', 'https://tripay.co.id/checkout/T4646028463994RXTYX', '1763285198', '2025-11-16', '1763371594', '', 'PAID', '126750', '1763299320', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (562, 'Tripay', '129397-251101305', 'BCAVA', '', '387', '250515130005', '251101305', 'T4646028478571H5ECF', 'https://tripay.co.id/checkout/T4646028478571H5ECF', '1763348343', '2025-11-17', '1763434742', '', 'PAID', '127750', '1763348417', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (563, 'Tripay', '345726-251101240', 'BRIVA', '', '316', '20250501006', '251101240', 'T4646028479043WRIFE', 'https://tripay.co.id/checkout/T4646028479043WRIFE', '1763349613', '2025-11-17', '1763436005', '', 'PAID', '127125', '1763349663', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (564, 'Tripay', '603090-251101674', 'QRIS2', '', '776', '100286', '251101674', 'T4646028480679LB31Z', 'https://tripay.co.id/checkout/T4646028480679LB31Z', '1763354894', '2025-11-17', '1763441174', '', 'PAID', '30000', '1763354977', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (565, 'Tripay', '290049-251101197', 'INDOMARET', '', '267', '240907151437', '251101197', 'T4646028488556ZT48C', 'https://tripay.co.id/checkout/T4646028488556ZT48C', '1763380769', '2025-11-17', '1763467169', '', 'PAID', '126750', '1763380816', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (566, 'Tripay', '101249-251101165', 'BCAVA', '', '227', '100096', '251101165', 'T4646028520325IL7TV', 'https://tripay.co.id/checkout/T4646028520325IL7TV', '1763533568', '2025-11-19', '1763619967', '', 'PAID', '127750', '1763533621', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (567, 'Tripay', '511273-251101278', 'BCAVA', '', '357', '20250501048', '251101278', 'T4646028522497EG4ZU', 'https://tripay.co.id/checkout/T4646028522497EG4ZU', '1763541255', '2025-11-19', '1763627655', '', 'PAID', '127750', '1763541814', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (568, 'Tripay', '601003-251101475', 'BRIVA', '', '573', '100105278', '251101475', 'T4646028523687AAJRH', 'https://tripay.co.id/checkout/T4646028523687AAJRH', '1763545001', '2025-11-19', '1763631392', '', 'PAID', '127125', '1763545049', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (569, 'Tripay', '88815-251101470', 'BRIVA', '', '568', '100105254', '251101470', 'T4646028523779QYHHY', 'https://tripay.co.id/checkout/T4646028523779QYHHY', '1763545212', '2025-11-19', '1763631612', '', 'PAID', '127125', '1763545235', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (570, 'Tripay', '594208-251101333', 'BCAVA', '', '419', '100169', '251101333', 'T4646028547271JRXT6', 'https://tripay.co.id/checkout/T4646028547271JRXT6', '1763635973', '2025-11-20', '1763722373', '', 'PAID', '127750', '1763636028', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (571, 'Tripay', '966704-251101677', 'ALFAMART', '', '779', '100287', '251101677', 'T4646028581380LZFOU', 'https://tripay.co.id/checkout/T4646028581380LZFOU', '1763772893', '2025-11-22', '1763776613', '', 'UNPAID', '26750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (572, 'Tripay', '193404-251101598', 'MANDIRIVA', '', '700', '100260', '251101598', 'T4646028607065NC5VE', 'https://tripay.co.id/checkout/T4646028607065NC5VE', '1763891840', '2025-11-23', '1763895552', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (573, 'Tripay', '946368-251101598', 'MANDIRIVA', '', '700', '100260', '251101598', 'T4646028607253H4WKC', 'https://tripay.co.id/checkout/T4646028607253H4WKC', '1763892520', '2025-11-23', '1763896232', '', 'PAID', '127125', '1763892736', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (574, 'Tripay', '830201-251201491', 'BCAVA', '', '590', '105020292', '251201491', 'T4646028763126FDDX8', 'https://tripay.co.id/checkout/T4646028763126FDDX8', '1764547895', '2025-12-01', '1764548915', '', 'PAID', '127750', '1764548656', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (575, 'Tripay', '516149-251201468', 'DANA', '', '566', '105010200', '251201468', 'T4646028764352URAOK', 'https://tripay.co.id/checkout/T4646028764352URAOK', '1764550167', '2025-12-01', '1764551186', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (576, 'Tripay', '779983-251201272', 'QRIS2', '', '349', '105030028', '251201272', 'T4646028767021FQPTK', 'https://tripay.co.id/checkout/T4646028767021FQPTK', '1764553947', '2025-12-01', '1764555747', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (577, 'Tripay', '788161-251201289', 'QRIS2', '', '367', '105020200', '251201289', 'T4646028768354GKCGH', 'https://tripay.co.id/checkout/T4646028768354GKCGH', '1764555388', '2025-12-01', '1764556107', '', 'PAID', '165000', '1764555451', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (578, 'Tripay', '573051-251201322', 'INDOMARET', '', '404', '105020217', '251201322', 'T46460287686415YG2Q', 'https://tripay.co.id/checkout/T46460287686415YG2Q', '1764555775', '2025-12-01', '1764556795', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (579, 'Tripay', '186149-251201322', 'INDOMARET', '', '404', '105020217', '251201322', 'T46460287710157GCFQ', 'https://tripay.co.id/checkout/T46460287710157GCFQ', '1764558992', '2025-12-01', '1764560012', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (580, 'Tripay', '666457-251201322', 'INDOMARET', '', '404', '105020217', '251201322', 'T4646028771409JSGX9', 'https://tripay.co.id/checkout/T4646028771409JSGX9', '1764559507', '2025-12-01', '1764560527', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (581, 'Tripay', '196260-251201322', 'INDOMARET', '', '404', '105020217', '251201322', 'T4646028771461IFXRF', 'https://tripay.co.id/checkout/T4646028771461IFXRF', '1764559602', '2025-12-01', '1764560622', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (582, 'Tripay', '746205-251201322', 'INDOMARET', '', '404', '105020217', '251201322', 'T4646028771541VZ6QM', 'https://tripay.co.id/checkout/T4646028771541VZ6QM', '1764559751', '2025-12-01', '1764560770', '', 'PAID', '126750', '1764559900', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (583, 'Tripay', '460654-251201723', 'BRIVA', '', '831', '105020386', '251201723', 'T4646028773717V9WTS', 'https://tripay.co.id/checkout/T4646028773717V9WTS', '1764562942', '2025-12-01', '1764566662', '', 'PAID', '167125', '1764563885', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (584, 'Tripay', '574648-251201708', 'BRIVA', '', '816', '105050038', '251201708', 'T46460287739548WWLN', 'https://tripay.co.id/checkout/T46460287739548WWLN', '1764563275', '2025-12-01', '1764566995', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (585, 'Tripay', '489748-251201555', 'MANDIRIVA', '', '656', '105010228', '251201555', 'T4646028774242GCKOG', 'https://tripay.co.id/checkout/T4646028774242GCKOG', '1764563753', '2025-12-01', '1764567473', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (586, 'Tripay', '511891-251201555', 'QRIS2', '', '656', '105010228', '251201555', 'T4646028774324EB4FL', 'https://tripay.co.id/checkout/T4646028774324EB4FL', '1764563868', '2025-12-01', '1764564587', '', 'PAID', '125000', '1764563966', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (587, 'Tripay', '768774-251201711', 'INDOMARET', '', '819', '105050041', '251201711', 'T4646028774857GMXLQ', 'https://tripay.co.id/checkout/T4646028774857GMXLQ', '1764564705', '2025-12-01', '1764565724', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (588, 'Tripay', '876266-251201729', 'BCAVA', '', '837', '105010300', '251201729', 'T4646028774863VGXXJ', 'https://tripay.co.id/checkout/T4646028774863VGXXJ', '1764564712', '2025-12-01', '1764565732', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (589, 'Tripay', '583426-251201729', 'BCAVA', '', '837', '105010300', '251201729', 'T4646028775019AJHGE', 'https://tripay.co.id/checkout/T4646028775019AJHGE', '1764564965', '2025-12-01', '1764565984', '', 'PAID', '127750', '1764565925', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (590, 'Tripay', '101618-251201775', 'BCAVA', '', '883', '10510002', '251201775', 'T4646028775151RBXOG', 'https://tripay.co.id/checkout/T4646028775151RBXOG', '1764565150', '2025-12-01', '1764566170', '', 'PAID', '27750', '1764566045', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (591, 'Tripay', '989353-251201727', 'INDOMARET', '', '835', '105030096', '251201727', 'T4646028779216JLDXF', 'https://tripay.co.id/checkout/T4646028779216JLDXF', '1764571606', '2025-12-01', '1767163486', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (592, 'Tripay', '405343-251201462', 'DANA', '', '558', '105030065', '251201462', 'T4646028779270NIELL', 'https://tripay.co.id/checkout/T4646028779270NIELL', '1764571719', '2025-12-01', '1764575198', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (593, 'Tripay', '257936-251201727', 'DANA', '', '835', '105030096', '251201727', 'T4646028779312PK5W2', 'https://tripay.co.id/checkout/T4646028779312PK5W2', '1764571789', '2025-12-01', '1764575269', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (594, 'Tripay', '743554-251201727', 'DANA', '', '835', '105030096', '251201727', 'T4646028779543UY1EK', 'https://tripay.co.id/checkout/T4646028779543UY1EK', '1764572190', '2025-12-01', '1764573209', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (595, 'Tripay', '496573-251201727', 'DANA', '', '835', '105030096', '251201727', 'T4646028779744A1OL0', 'https://tripay.co.id/checkout/T4646028779744A1OL0', '1764572516', '2025-12-01', '1764573535', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (596, 'Tripay', '607563-251201727', 'DANA', '', '835', '105030096', '251201727', 'T4646028779891SMJMV', 'https://tripay.co.id/checkout/T4646028779891SMJMV', '1764572814', '2025-12-01', '1764573833', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (597, 'Tripay', '88047-251201727', 'DANA', '', '835', '105030096', '251201727', 'T4646028781481EWSWS', 'https://tripay.co.id/checkout/T4646028781481EWSWS', '1764575727', '2025-12-01', '1764576746', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (598, 'Tripay', '222379-251201740', 'BCAVA', '', '848', '105010305', '251201740', 'T4646028781589CD4UY', 'https://tripay.co.id/checkout/T4646028781589CD4UY', '1764575912', '2025-12-01', '1764576931', '', 'PAID', '86750', '1764576605', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (599, 'Tripay', '765587-251201740', 'BCAVA', '', '848', '105010305', '251201740', 'T4646028781721W4G9T', 'https://tripay.co.id/checkout/T4646028781721W4G9T', '1764576180', '2025-12-01', '1764577200', '', 'UNPAID', '86750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (600, 'Tripay', '376183-251201727', 'QRIS2', '', '835', '105030096', '251201727', 'T4646028782520OGABQ', 'https://tripay.co.id/checkout/T4646028782520OGABQ', '1764577647', '2025-12-01', '1764578366', '', 'PAID', '125000', '1764578028', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (601, 'Tripay', '6614-251201369', 'BCAVA', '', '459', '105020232', '251201369', 'T46460287828220VQTI', 'https://tripay.co.id/checkout/T46460287828220VQTI', '1764578285', '2025-12-01', '1764579305', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (602, 'Tripay', '171312-251201731', 'INDOMARET', '', '839', '105020390', '251201731', 'T4646028782951ORF5F', 'https://tripay.co.id/checkout/T4646028782951ORF5F', '1764578482', '2025-12-01', '1764579502', '', 'PAID', '126750', '1764578603', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (603, 'Tripay', '856559-251201711', 'INDOMARET', '', '819', '105050041', '251201711', 'T46460287841721HJVF', 'https://tripay.co.id/checkout/T46460287841721HJVF', '1764580674', '2025-12-01', '1764581694', '', 'PAID', '126750', '1764580820', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (604, 'Tripay', '231177-251201732', 'BRIVA', '', '840', '105030098', '251201732', 'T4646028786513TWMTJ', 'https://tripay.co.id/checkout/T4646028786513TWMTJ', '1764584485', '2025-12-01', '1764588197', '', 'PAID', '129125', '1764584739', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (605, 'Tripay', '545545-251201725', 'BCAVA', '', '833', '105020387', '251201725', 'T4646028786608JNCEK', 'https://tripay.co.id/checkout/T4646028786608JNCEK', '1764584615', '2025-12-01', '1764585635', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (606, 'Tripay', '387670-251201732', 'BRIVA', '', '840', '105030098', '251201732', 'T4646028786639GJAA3', 'https://tripay.co.id/checkout/T4646028786639GJAA3', '1764584653', '2025-12-01', '1764588372', '', 'UNPAID', '129125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (607, 'Tripay', '76159-251201725', 'BCAVA', '', '833', '105020387', '251201725', 'T4646028788236QU4TQ', 'https://tripay.co.id/checkout/T4646028788236QU4TQ', '1764586992', '2025-12-01', '1764588012', '', 'PAID', '127750', '1764587156', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (608, 'Tripay', '736756-251201708', 'BRIVA', '', '816', '105050038', '251201708', 'T46460287889948G6NW', 'https://tripay.co.id/checkout/T46460287889948G6NW', '1764588064', '2025-12-01', '1764591777', '', 'PAID', '127125', '1764588179', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (609, 'Tripay', '922332-251201777', 'INDOMARET', '', '885', '10550001', '251201777', 'T4646028789738VJU8S', 'https://tripay.co.id/checkout/T4646028789738VJU8S', '1764588983', '2025-12-01', '1764590003', '', 'UNPAID', '85750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (610, 'Tripay', '219225-251201777', 'DANA', '', '885', '10550001', '251201777', 'T4646028790162INGSJ', 'https://tripay.co.id/checkout/T4646028790162INGSJ', '1764589559', '2025-12-01', '1764590578', '', 'UNPAID', '84000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (611, 'Tripay', '153854-251201468', 'ALFAMART', '', '566', '105010200', '251201468', 'T4646028790727ISSNJ', 'https://tripay.co.id/checkout/T4646028790727ISSNJ', '1764590180', '2025-12-01', '1764593900', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (612, 'Tripay', '518009-251201739', 'QRIS2', '', '847', '105020392', '251201739', 'T4646028790821FLBDR', 'https://tripay.co.id/checkout/T4646028790821FLBDR', '1764590286', '2025-12-01', '1764591005', '', 'PAID', '88000', '1764590342', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (613, 'Tripay', '913197-251201777', 'DANA', '', '885', '10550001', '251201777', 'T4646028790849DCC56', 'https://tripay.co.id/checkout/T4646028790849DCC56', '1764590317', '2025-12-01', '1764591336', '', 'UNPAID', '84000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (614, 'Tripay', '225567-251201733', 'QRIS2', '', '841', '105020391', '251201733', 'T4646028791823B9ZHS', 'https://tripay.co.id/checkout/T4646028791823B9ZHS', '1764591539', '2025-12-01', '1764592259', '', 'PAID', '96000', '1764591571', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (615, 'Tripay', '180889-251201468', 'INDOMARET', '', '566', '105010200', '251201468', 'T4646028792593ALIGQ', 'https://tripay.co.id/checkout/T4646028792593ALIGQ', '1764592535', '2025-12-01', '1764593555', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (616, 'Tripay', '285042-251201468', 'DANA', '', '566', '105010200', '251201468', 'T4646028792983DFIUH', 'https://tripay.co.id/checkout/T4646028792983DFIUH', '1764593090', '2025-12-01', '1764594109', '', 'PAID', '125000', '1764593234', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (617, 'Tripay', '633265-251201718', 'MANDIRIVA', '', '826', '105010297', '251201718', 'T4646028794375YIOMT', 'https://tripay.co.id/checkout/T4646028794375YIOMT', '1764594805', '2025-12-01', '1764598517', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (618, 'Tripay', '96582-251201718', 'MANDIRIVA', '', '826', '105010297', '251201718', 'T4646028794502FI8KQ', 'https://tripay.co.id/checkout/T4646028794502FI8KQ', '1764594927', '2025-12-01', '1764598646', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (619, 'Tripay', '24394-251201718', 'MANDIRIVA', '', '826', '105010297', '251201718', 'T4646028794869KG97Q', 'https://tripay.co.id/checkout/T4646028794869KG97Q', '1764595352', '2025-12-01', '1764599071', '', 'PAID', '127125', '1764595768', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (620, 'Tripay', '133140-251201719', 'QRIS2', '', '827', '105030095', '251201719', 'T4646028796267GIPKY', 'https://tripay.co.id/checkout/T4646028796267GIPKY', '1764596155', '2025-12-01', '1764596875', '', 'PAID', '125000', '1764596220', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (621, 'Tripay', '154689-251201742', 'INDOMARET', '', '850', '105010306', '251201742', 'T4646028797904DIGYD', 'https://tripay.co.id/checkout/T4646028797904DIGYD', '1764597977', '2025-12-01', '1764598997', '', 'UNPAID', '76750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (622, 'Tripay', '895675-251201742', 'QRIS', '', '850', '105010306', '251201742', 'T4646028798014FXM0K', 'https://tripay.co.id/checkout/T4646028798014FXM0K', '1764598146', '2025-12-01', '1764598865', '', 'PAID', '75637', '1764598233', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (623, 'Tripay', '455765-251201422', 'INDOMARET', '', '515', '105020260', '251201422', 'T4646028808247TDECD', 'https://tripay.co.id/checkout/T4646028808247TDECD', '1764638632', '2025-12-02', '1764639652', '', 'PAID', '126750', '1764639055', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (624, 'Tripay', '72071-251201150', 'MANDIRIVA', '', '209', '105020130', '251201150', 'T4646028808256PCEN4', 'https://tripay.co.id/checkout/T4646028808256PCEN4', '1764638662', '2025-12-02', '1764642374', '', 'PAID', '127125', '1764638782', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (625, 'Tripay', '3159-251201207', 'INDOMARET', '', '277', '105010102', '251201207', 'T4646028809220CWFYL', 'https://tripay.co.id/checkout/T4646028809220CWFYL', '1764640381', '2025-12-02', '1764641401', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (626, 'Tripay', '596720-251201108', 'QRIS2', '', '156', '105010058', '251201108', 'T4646028809575M5A8H', 'https://tripay.co.id/checkout/T4646028809575M5A8H', '1764640995', '2025-12-02', '1764641715', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (627, 'Tripay', '64975-251201108', 'MANDIRIVA', '', '156', '105010058', '251201108', 'T4646028810484T3FHR', 'https://tripay.co.id/checkout/T4646028810484T3FHR', '1764642487', '2025-12-02', '1764646199', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (628, 'Tripay', '170357-251201108', 'DANA', '', '156', '105010058', '251201108', 'T4646028810520URZYG', 'https://tripay.co.id/checkout/T4646028810520URZYG', '1764642529', '2025-12-02', '1764643548', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (629, 'Tripay', '770805-251201350', 'INDOMARET', '', '437', '105050004', '251201350', 'T4646028810687YLVZQ', 'https://tripay.co.id/checkout/T4646028810687YLVZQ', '1764642813', '2025-12-02', '1764643833', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (630, 'Tripay', '433186-251201173', 'BCAVA', '', '237', '105020144', '251201173', 'T4646028813553KXK1J', 'https://tripay.co.id/checkout/T4646028813553KXK1J', '1764648129', '2025-12-02', '1764649149', '', 'PAID', '127750', '1764648398', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (631, 'Tripay', '884154-251201416', 'DANA', '', '509', '105030054', '251201416', 'T4646028813958RRRGB', 'https://tripay.co.id/checkout/T4646028813958RRRGB', '1764648835', '2025-12-02', '1764649855', '', 'PAID', '125000', '1764648919', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (632, 'Tripay', '446389-251201378', 'DANA', '', '469', '105050010', '251201378', 'T4646028815337AEWTZ', 'https://tripay.co.id/checkout/T4646028815337AEWTZ', '1764651515', '2025-12-02', '1764652534', '', 'PAID', '125000', '1764651614', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (633, 'Tripay', '827071-251201124', 'DANA', '', '173', '105010064', '251201124', 'T4646028815522UX4UA', 'https://tripay.co.id/checkout/T4646028815522UX4UA', '1764651852', '2025-12-02', '1764652871', '', 'PAID', '125000', '1764651914', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (634, 'Tripay', '250693-251201101', 'DANA', '', '148', '105020096', '251201101', 'T4646028815750YUDYN', 'https://tripay.co.id/checkout/T4646028815750YUDYN', '1764652297', '2025-12-02', '1764653316', '', 'PAID', '125000', '1764652435', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (635, 'Tripay', '158993-251201068', 'QRIS2', '', '105', '105010042', '251201068', 'T4646028816312X3JT6', 'https://tripay.co.id/checkout/T4646028816312X3JT6', '1764653343', '2025-12-02', '1764654063', '', 'UNPAID', '115000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (636, 'Tripay', '243333-251201735', 'BNIVA', '', '843', '105010302', '251201735', 'T46460288177678I4SV', 'https://tripay.co.id/checkout/T46460288177678I4SV', '1764656189', '2025-12-02', '1764657202', '', 'PAID', '94125', '1764656292', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (637, 'Tripay', '376730-251201068', 'QRIS2', '', '105', '105010042', '251201068', 'T4646028818027RNHEV', 'https://tripay.co.id/checkout/T4646028818027RNHEV', '1764656690', '2025-12-02', '1764657409', '', 'PAID', '115000', '1764656855', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (638, 'Tripay', '823340-251201068', 'BRIVA', '', '105', '105010042', '251201068', 'T4646028818040KW4RG', 'https://tripay.co.id/checkout/T4646028818040KW4RG', '1764656711', '2025-12-02', '1764660430', '', 'UNPAID', '117125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (639, 'Tripay', '356473-251201658', 'BRIVA', '', '761', '105010275', '251201658', 'T4646028818143VXJK3', 'https://tripay.co.id/checkout/T4646028818143VXJK3', '1764656924', '2025-12-02', '1764660636', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (640, 'Tripay', '442897-251201659', 'BRIVA', '', '762', '105010276', '251201659', 'T4646028818198C6RA3', 'https://tripay.co.id/checkout/T4646028818198C6RA3', '1764657032', '2025-12-02', '1764660751', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (641, 'Tripay', '68213-251201152', 'ALFAMART', '', '212', '105010080', '251201152', 'T4646028819391A88SW', 'https://tripay.co.id/checkout/T4646028819391A88SW', '1764659270', '2025-12-02', '1764662990', '', 'PAID', '126750', '1764659820', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (642, 'Tripay', '996232-251201257', 'INDOMARET', '', '333', '105020182', '251201257', 'T4646028820712POJGD', 'https://tripay.co.id/checkout/T4646028820712POJGD', '1764661706', '2025-12-02', '1764662726', '', 'PAID', '126750', '1764661802', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (643, 'Tripay', '961350-251201207', 'INDOMARET', '', '277', '105010102', '251201207', 'T46460288217817ATEQ', 'https://tripay.co.id/checkout/T46460288217817ATEQ', '1764663385', '2025-12-02', '1764664404', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (644, 'Tripay', '857925-251201207', 'INDOMARET', '', '277', '105010102', '251201207', 'T4646028821795J7UAN', 'https://tripay.co.id/checkout/T4646028821795J7UAN', '1764663413', '2025-12-02', '1764664433', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (645, 'Tripay', '410393-251201563', 'BRIVA', '', '664', '105010234', '251201563', 'T4646028823365P8EBD', 'https://tripay.co.id/checkout/T4646028823365P8EBD', '1764665705', '2025-12-02', '1764669417', '', 'PAID', '167125', '1764665784', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (646, 'Tripay', '100824-251201207', 'INDOMARET', '', '277', '105010102', '251201207', 'T4646028824016A2NDH', 'https://tripay.co.id/checkout/T4646028824016A2NDH', '1764666733', '2025-12-02', '1764667753', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (647, 'Tripay', '711354-251201207', 'INDOMARET', '', '277', '105010102', '251201207', 'T4646028824069NDGNK', 'https://tripay.co.id/checkout/T4646028824069NDGNK', '1764666838', '2025-12-02', '1764667858', '', 'PAID', '126750', '1764667347', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (648, 'Tripay', '232294-251202007', 'BRIVA', '', '353', '105010133', '251202007', 'T4646028826331WKMQ8', 'https://tripay.co.id/checkout/T4646028826331WKMQ8', '1764670902', '2025-12-02', '1764674614', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (649, 'Tripay', '202155-251202007', 'BRIVA', '', '353', '105010133', '251202007', 'T4646028826416DZTVE', 'https://tripay.co.id/checkout/T4646028826416DZTVE', '1764671066', '2025-12-02', '1764674785', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (650, 'Tripay', '231732-251201066', 'BNIVA', '', '103', '105020062', '251201066', 'T4646028829225NHG3I', 'https://tripay.co.id/checkout/T4646028829225NHG3I', '1764675456', '2025-12-02', '1764676476', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (651, 'Tripay', '314774-251201066', 'BNIVA', '', '103', '105020062', '251201066', 'T4646028829234YZJPU', 'https://tripay.co.id/checkout/T4646028829234YZJPU', '1764675474', '2025-12-02', '1764676494', '', 'PAID', '167125', '1764675556', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (652, 'Tripay', '303302-251201341', 'BSIVA', '', '428', '105010166', '251201341', 'T4646028832784CCVHS', 'https://tripay.co.id/checkout/T4646028832784CCVHS', '1764678975', '2025-12-02', '1764682687', '', 'PAID', '167125', '1764679103', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (653, 'Tripay', '523928-251201565', 'INDOMARET', '', '666', '105010236', '251201565', 'T4646028840714S4GDD', 'https://tripay.co.id/checkout/T4646028840714S4GDD', '1764682425', '2025-12-02', '1764683445', '', 'PAID', '126750', '1764682705', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (654, 'Tripay', '863507-251201567', 'MANDIRIVA', '', '669', '105010239', '251201567', 'T46460288415403GUS4', 'https://tripay.co.id/checkout/T46460288415403GUS4', '1764682869', '2025-12-02', '1764686580', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (655, 'Tripay', '194112-251201567', 'QRIS2', '', '669', '105010239', '251201567', 'T4646028841716IO0LV', 'https://tripay.co.id/checkout/T4646028841716IO0LV', '1764683115', '2025-12-02', '1764683835', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (656, 'Tripay', '334638-251201567', 'QRIS2', '', '669', '105010239', '251201567', 'T4646028841734O94UX', 'https://tripay.co.id/checkout/T4646028841734O94UX', '1764683149', '2025-12-02', '1764683869', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (657, 'Tripay', '337153-251201658', 'BRIVA', '', '761', '105010275', '251201658', 'T4646028841811NFFBU', 'https://tripay.co.id/checkout/T4646028841811NFFBU', '1764683271', '2025-12-02', '1764686990', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (658, 'Tripay', '247042-251201658', 'BRIVA', '', '761', '105010275', '251201658', 'T4646028843177PB0CU', 'https://tripay.co.id/checkout/T4646028843177PB0CU', '1764686070', '2025-12-02', '1764689780', '', 'PAID', '127125', '1764686619', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (659, 'Tripay', '486186-251201659', 'BRIVA', '', '762', '105010276', '251201659', 'T4646028843321CB999', 'https://tripay.co.id/checkout/T4646028843321CB999', '1764686464', '2025-12-02', '1764690184', '', 'PAID', '127125', '1764686562', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (660, 'Tripay', '246078-251201453', 'INDOMARET', '', '548', '105010196', '251201453', 'T4646028848383DYIGR', 'https://tripay.co.id/checkout/T4646028848383DYIGR', '1764718126', '2025-12-03', '1764719146', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (661, 'Tripay', '982934-251201453', 'INDOMARET', '', '548', '105010196', '251201453', 'T46460288500122BTCY', 'https://tripay.co.id/checkout/T46460288500122BTCY', '1764722951', '2025-12-03', '1764723971', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (662, 'Tripay', '37362-251201453', 'INDOMARET', '', '548', '105010196', '251201453', 'T46460288501389BGN8', 'https://tripay.co.id/checkout/T46460288501389BGN8', '1764723260', '2025-12-03', '1764724280', '', 'PAID', '126750', '1764723528', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (663, 'Tripay', '288569-251201690', 'INDOMARET', '', '793', '105010286', '251201690', 'T46460288501551GBW1', 'https://tripay.co.id/checkout/T46460288501551GBW1', '1764723309', '2025-12-03', '1764724329', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (664, 'Tripay', '335506-251201763', 'QRIS2', '', '871', '105020402', '251201763', 'T4646028851069LZZEO', 'https://tripay.co.id/checkout/T4646028851069LZZEO', '1764725342', '2025-12-03', '1764726058', '', 'PAID', '165000', '1764725581', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (665, 'Tripay', '353556-251201690', 'INDOMARET', '', '793', '105010286', '251201690', 'T4646028851143UM4JY', 'https://tripay.co.id/checkout/T4646028851143UM4JY', '1764725479', '2025-12-03', '1764726498', '', 'PAID', '126750', '1764725546', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (666, 'Tripay', '264028-251201350', 'INDOMARET', '', '437', '105050004', '251201350', 'T4646028851410VQBF1', 'https://tripay.co.id/checkout/T4646028851410VQBF1', '1764725973', '2025-12-03', '1767200399', '', 'PAID', '126750', '1764770831', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (667, 'Tripay', '486591-251201473', 'QRIS2', '', '571', '105020282', '251201473', 'T46460288526623MOIR', 'https://tripay.co.id/checkout/T46460288526623MOIR', '1764728474', '2025-12-03', '1764729194', '', 'PAID', '165000', '1764728781', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (668, 'Tripay', '291958-251201064', 'QRIS2', '', '101', '105020060', '251201064', 'T4646028852888J9CJQ', 'https://tripay.co.id/checkout/T4646028852888J9CJQ', '1764728882', '2025-12-03', '1764729601', '', 'PAID', '125000', '1764728968', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (669, 'Tripay', '722471-251201476', 'QRIS2', '', '574', '105020284', '251201476', 'T4646028853061I8DDF', 'https://tripay.co.id/checkout/T4646028853061I8DDF', '1764729201', '2025-12-03', '1764729921', '', 'PAID', '165000', '1764729326', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (670, 'Tripay', '912104-251201335', 'BRIVA', '', '421', '105030038', '251201335', 'T4646028853446CNW96', 'https://tripay.co.id/checkout/T4646028853446CNW96', '1764729906', '2025-12-03', '1764733625', '', 'PAID', '167125', '1764730035', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (671, 'Tripay', '180464-251201287', 'INDOMARET', '', '365', '105010136', '251201287', 'T4646028854172XS375', 'https://tripay.co.id/checkout/T4646028854172XS375', '1764731413', '2025-12-03', '1764732433', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (672, 'Tripay', '384491-251201778', 'QRIS2', '', '886', '10550002', '251201778', 'T4646028854627ASOYX', 'https://tripay.co.id/checkout/T4646028854627ASOYX', '1764732244', '2025-12-03', '1764732964', '', 'PAID', '84000', '1764732265', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (673, 'Tripay', '126651-251201755', 'INDOMARET', '', '863', '105010312', '251201755', 'T4646028855569OUTXF', 'https://tripay.co.id/checkout/T4646028855569OUTXF', '1764734395', '2025-12-03', '1764735415', '', 'PAID', '43750', '1764734452', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (674, 'Tripay', '169008-251201715', 'INDOMARET', '', '823', '105010296', '251201715', 'T4646028859633NIHZS', 'https://tripay.co.id/checkout/T4646028859633NIHZS', '1764742063', '2025-12-03', '1764743083', '', 'PAID', '126750', '1764742345', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (675, 'Tripay', '814057-251201736', 'BRIVA', '', '844', '105030099', '251201736', 'T4646028859996IYWS8', 'https://tripay.co.id/checkout/T4646028859996IYWS8', '1764742800', '2025-12-03', '1764746511', '', 'PAID', '94125', '1764742888', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (676, 'Tripay', '162180-251201160', 'SHOPEEPAY', '', '221', '105010087', '251201160', 'T4646028861233NRVHX', 'https://tripay.co.id/checkout/T4646028861233NRVHX', '1764745337', '2025-12-03', '1764746357', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (677, 'Tripay', '185068-251201160', 'QRIS', '', '221', '105010087', '251201160', 'T4646028861243YLWDQ', 'https://tripay.co.id/checkout/T4646028861243YLWDQ', '1764745349', '2025-12-03', '1764746069', '', 'PAID', '125812', '1764745416', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (678, 'Tripay', '772676-251201237', 'INDOMARET', '', '312', '105030018', '251201237', 'T4646028863716F83J2', 'https://tripay.co.id/checkout/T4646028863716F83J2', '1764749967', '2025-12-03', '1764750987', '', 'PAID', '126750', '1764750022', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (679, 'Tripay', '223340-251201321', 'SHOPEEPAY', '', '403', '105020216', '251201321', 'T4646028865326DUTRH', 'https://tripay.co.id/checkout/T4646028865326DUTRH', '1764752957', '2025-12-03', '1764753976', '', 'PAID', '126875', '1764753014', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (680, 'Tripay', '525437-251201776', 'ALFAMART', '', '884', '10510003', '251201776', 'T46460288673751HBRX', 'https://tripay.co.id/checkout/T46460288673751HBRX', '1764756773', '2025-12-03', '1764760493', '', 'PAID', '22750', '1764756876', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (681, 'Tripay', '769207-251201290', 'QRIS2', '', '368', '105020201', '251201290', 'T4646028869758M4CEU', 'https://tripay.co.id/checkout/T4646028869758M4CEU', '1764760738', '2025-12-03', '1764761458', '', 'PAID', '165000', '1764760772', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (682, 'Tripay', '315408-251201728', 'MANDIRIVA', '', '836', '105030097', '251201728', 'T4646028869895ZLMPW', 'https://tripay.co.id/checkout/T4646028869895ZLMPW', '1764760964', '2025-12-03', '1764764684', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (683, 'Tripay', '210811-251201601', 'INDOMARET', '', '703', '105020335', '251201601', 'T4646028870594U6Q4Y', 'https://tripay.co.id/checkout/T4646028870594U6Q4Y', '1764762040', '2025-12-03', '1764763060', '', 'PAID', '166750', '1764762265', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (684, 'Tripay', '513695-251201309', 'ALFAMART', '', '390', '105010148', '251201309', 'T4646028871061MIL8Z', 'https://tripay.co.id/checkout/T4646028871061MIL8Z', '1764762754', '2025-12-03', '1764766473', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (685, 'Tripay', '119090-251201309', 'INDOMARET', '', '390', '105010148', '251201309', 'T4646028871431NF0IC', 'https://tripay.co.id/checkout/T4646028871431NF0IC', '1764763254', '2025-12-03', '1764764274', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (686, 'Tripay', '448609-251201669', 'MANDIRIVA', '', '772', '105030089', '251201669', 'T4646028873528NQYUQ', 'https://tripay.co.id/checkout/T4646028873528NQYUQ', '1764766763', '2025-12-03', '1764770474', '', 'PAID', '127125', '1764767330', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (687, 'Tripay', '700139-251201669', 'MANDIRIVA', '', '772', '105030089', '251201669', 'T4646028873676MAFBJ', 'https://tripay.co.id/checkout/T4646028873676MAFBJ', '1764766987', '2025-12-03', '1764770707', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (688, 'Tripay', '131907-251201355', 'MANDIRIVA', '', '442', '105050009', '251201355', 'T4646028875358M74R6', 'https://tripay.co.id/checkout/T4646028875358M74R6', '1764769993', '2025-12-03', '1764773705', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (689, 'Tripay', '347268-251201355', 'MANDIRIVA', '', '442', '105050009', '251201355', 'T4646028875455V5LHD', 'https://tripay.co.id/checkout/T4646028875455V5LHD', '1764770165', '2025-12-03', '1764773885', '', 'PAID', '127125', '1764770329', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (690, 'Tripay', '464288-251201622', 'QRIS2', '', '725', '105010265', '251201622', 'T4646028876463DZRFQ', 'https://tripay.co.id/checkout/T4646028876463DZRFQ', '1764772584', '2025-12-03', '1764773303', '', 'PAID', '165000', '1764772961', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (691, 'Tripay', '512563-251201622', 'QRIS2', '', '725', '105010265', '251201622', 'T4646028876593UKFZM', 'https://tripay.co.id/checkout/T4646028876593UKFZM', '1764772924', '2025-12-03', '1764773643', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (692, 'Tripay', '963048-251201249', 'BRIVA', '', '324', '105030021', '251201249', 'T4646028881499WG2SZ', 'https://tripay.co.id/checkout/T4646028881499WG2SZ', '1764806004', '2025-12-04', '1764809716', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (693, 'Tripay', '186634-251201309', 'ALFAMART', '', '390', '105010148', '251201309', 'T4646028881512A613F', 'https://tripay.co.id/checkout/T4646028881512A613F', '1764806054', '2025-12-04', '1764809773', '', 'PAID', '126750', '1764806115', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (694, 'Tripay', '695631-251201502', 'BRIVA', '', '601', '105050028', '251201502', 'T4646028883022JOIUE', 'https://tripay.co.id/checkout/T4646028883022JOIUE', '1764810065', '2025-12-04', '1764813777', '', 'PAID', '127125', '1764810110', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (695, 'Tripay', '24108-251201486', 'BRIVA', '', '585', '105030069', '251201486', 'T4646028883417OZMN3', 'https://tripay.co.id/checkout/T4646028883417OZMN3', '1764810952', '2025-12-04', '1764814664', '', 'PAID', '127125', '1764810999', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (696, 'Tripay', '191236-251201783', 'DANA', '', '891', '10520005', '251201783', 'T46460288834303ZA5D', 'https://tripay.co.id/checkout/T46460288834303ZA5D', '1764810979', '2025-12-04', '1764811998', '', 'PAID', '125000', '1764811003', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (697, 'Tripay', '389141-251201773', 'DANA', '', '881', '10520004', '251201773', 'T4646028883484W4KAA', 'https://tripay.co.id/checkout/T4646028883484W4KAA', '1764811083', '2025-12-04', '1764812102', '', 'PAID', '17000', '1764811094', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (698, 'Tripay', '737714-251201102', 'INDOMARET', '', '149', '105010053', '251201102', 'T4646028883680WACHK', 'https://tripay.co.id/checkout/T4646028883680WACHK', '1764811521', '2025-12-04', '1764812541', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (699, 'Tripay', '897164-251201249', 'BRIVA', '', '324', '105030021', '251201249', 'T4646028884091KH3KH', 'https://tripay.co.id/checkout/T4646028884091KH3KH', '1764812374', '2025-12-04', '1764816087', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (700, 'Tripay', '41624-251201232', 'INDOMARET', '', '307', '105020173', '251201232', 'T4646028884106UEN4E', 'https://tripay.co.id/checkout/T4646028884106UEN4E', '1764812407', '2025-12-04', '1764813427', '', 'PAID', '126750', '1764812476', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (701, 'Tripay', '696504-251201249', 'INDOMARET', '', '324', '105030021', '251201249', 'T4646028884193JIDGV', 'https://tripay.co.id/checkout/T4646028884193JIDGV', '1764812611', '2025-12-04', '1764813630', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (702, 'Tripay', '539344-251201249', 'BRIVA', '', '324', '105030021', '251201249', 'T4646028884233XSFBE', 'https://tripay.co.id/checkout/T4646028884233XSFBE', '1764812726', '2025-12-04', '1764816446', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (703, 'Tripay', '293768-251201443', 'QRIS2', '', '536', '105030062', '251201443', 'T4646028885244PW4VG', 'https://tripay.co.id/checkout/T4646028885244PW4VG', '1764814740', '2025-12-04', '1764815459', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (704, 'Tripay', '487733-251201443', 'INDOMARET', '', '536', '105030062', '251201443', 'T4646028885317MSA5M', 'https://tripay.co.id/checkout/T4646028885317MSA5M', '1764814911', '2025-12-04', '1764815931', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (705, 'Tripay', '405304-251201048', 'QRIS2', '', '76', '105010032', '251201048', 'T46460288858849C02O', 'https://tripay.co.id/checkout/T46460288858849C02O', '1764816155', '2025-12-04', '1764816875', '', 'PAID', '125000', '1764816194', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (706, 'Tripay', '68122-251201499', 'BRIVA', '', '598', '105050025', '251201499', 'T46460288860854ZNOY', 'https://tripay.co.id/checkout/T46460288860854ZNOY', '1764816535', '2025-12-04', '1764820246', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (707, 'Tripay', '483134-251201499', 'BRIVA', '', '598', '105050025', '251201499', 'T4646028886259C6J06', 'https://tripay.co.id/checkout/T4646028886259C6J06', '1764816906', '2025-12-04', '1764820625', '', 'PAID', '127125', '1764816971', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (708, 'Tripay', '839911-251201737', 'INDOMARET', '', '845', '105010303', '251201737', 'T4646028886290MU6RA', 'https://tripay.co.id/checkout/T4646028886290MU6RA', '1764816987', '2025-12-04', '1764818007', '', 'PAID', '93750', '1764817256', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (709, 'Tripay', '189796-251201443', 'INDOMARET', '', '536', '105030062', '251201443', 'T4646028886452BGWGH', 'https://tripay.co.id/checkout/T4646028886452BGWGH', '1764817312', '2025-12-04', '1764818332', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (710, 'Tripay', '948851-251201765', 'INDOMARET', '', '873', '105020404', '251201765', 'T4646028886618CZHJT', 'https://tripay.co.id/checkout/T4646028886618CZHJT', '1764817651', '2025-12-04', '1764818671', '', 'PAID', '106750', '1764817947', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (711, 'Tripay', '752342-251201277', 'INDOMARET', '', '355', '105020193', '251201277', 'T4646028886987MZMR5', 'https://tripay.co.id/checkout/T4646028886987MZMR5', '1764818306', '2025-12-04', '1764819325', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (712, 'Tripay', '382611-251201443', 'INDOMARET', '', '536', '105030062', '251201443', 'T4646028887138VQUZN', 'https://tripay.co.id/checkout/T4646028887138VQUZN', '1764818570', '2025-12-04', '1764819590', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (713, 'Tripay', '318158-251201443', 'INDOMARET', '', '536', '105030062', '251201443', 'T4646028891696UIPMY', 'https://tripay.co.id/checkout/T4646028891696UIPMY', '1764828263', '2025-12-04', '1767200399', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (714, 'Tripay', '806206-251201533', 'DANA', '', '634', '105020307', '251201533', 'T4646028892730AMS9D', 'https://tripay.co.id/checkout/T4646028892730AMS9D', '1764830718', '2025-12-04', '1764831737', '', 'PAID', '125000', '1764830746', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (715, 'Tripay', '278538-251201099', 'BSIVA', '', '146', '105020094', '251201099', 'T4646028892849JBTB5', 'https://tripay.co.id/checkout/T4646028892849JBTB5', '1764831016', '2025-12-04', '1764834729', '', 'PAID', '167125', '1764831315', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (716, 'Tripay', '454373-251201099', 'BSIVA', '', '146', '105020094', '251201099', 'T4646028892984LLDRL', 'https://tripay.co.id/checkout/T4646028892984LLDRL', '1764831289', '2025-12-04', '1764835009', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (717, 'Tripay', '77621-251201102', 'INDOMARET', '', '149', '105010053', '251201102', 'T4646028894109FACYJ', 'https://tripay.co.id/checkout/T4646028894109FACYJ', '1764833801', '2025-12-04', '1764834820', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (718, 'Tripay', '418297-251204001', 'INDOMARET', '', '901', '105010318', '251204001', 'T46460288953899CHGA', 'https://tripay.co.id/checkout/T46460288953899CHGA', '1764836923', '2025-12-04', '1764837942', '', 'PAID', '126750', '1764836970', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (719, 'Tripay', '378790-251201171', 'BCAVA', '', '234', '105020141', '251201171', 'T4646028895403FOGNU', 'https://tripay.co.id/checkout/T4646028895403FOGNU', '1764836954', '2025-12-04', '1764837974', '', 'PAID', '127750', '1764837091', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (720, 'Tripay', '393484-251201045', 'OVO', '', '71', '105020041', '251201045', 'T4646028896012WANKL', 'https://tripay.co.id/checkout/T4646028896012WANKL', '1764838528', '2025-12-04', '1764839548', '', 'UNPAID', '208075', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (721, 'Tripay', '659978-251201045', 'QRIS2', '', '71', '105020041', '251201045', 'T46460288960643Y5U2', 'https://tripay.co.id/checkout/T46460288960643Y5U2', '1764838621', '2025-12-04', '1764839340', '', 'UNPAID', '205000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (722, 'Tripay', '304142-251201045', 'OVO', '', '71', '105020041', '251201045', 'T4646028896159PRKAG', 'https://tripay.co.id/checkout/T4646028896159PRKAG', '1764838789', '2025-12-04', '1764839809', '', 'UNPAID', '208075', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (723, 'Tripay', '583298-251201245', 'INDOMARET', '', '320', '105020177', '251201245', 'T4646028896656C86FT', 'https://tripay.co.id/checkout/T4646028896656C86FT', '1764839879', '2025-12-04', '1764840899', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (724, 'Tripay', '187160-251201278', 'INDOMARET', '', '356', '105020194', '251201278', 'T46460288970462M1KI', 'https://tripay.co.id/checkout/T46460288970462M1KI', '1764840734', '2025-12-04', '1764841754', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (725, 'Tripay', '117504-251201278', 'INDOMARET', '', '356', '105020194', '251201278', 'T46460288971209NBA4', 'https://tripay.co.id/checkout/T46460288971209NBA4', '1764840888', '2025-12-04', '1764841908', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (726, 'Tripay', '903058-251201245', 'INDOMARET', '', '320', '105020177', '251201245', 'T4646028897223HIC7X', 'https://tripay.co.id/checkout/T4646028897223HIC7X', '1764841146', '2025-12-04', '1764842166', '', 'PAID', '126750', '1764841314', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (727, 'Tripay', '363860-251202010', 'QRIS2', '', '457', '105030045', '251202010', 'T4646028897431DAEFN', 'https://tripay.co.id/checkout/T4646028897431DAEFN', '1764841577', '2025-12-04', '1764842296', '', 'PAID', '125000', '1764841638', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (728, 'Tripay', '639765-251201728', 'INDOMARET', '', '836', '105030097', '251201728', 'T4646028898825TZMPO', 'https://tripay.co.id/checkout/T4646028898825TZMPO', '1764844399', '2025-12-04', '1764845419', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (729, 'Tripay', '985078-251201255', 'BRIVA', '', '330', '105030023', '251201255', 'T4646028899317XLNSG', 'https://tripay.co.id/checkout/T4646028899317XLNSG', '1764845290', '2025-12-04', '1764849003', '', 'PAID', '127125', '1764845345', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (730, 'Tripay', '303933-251201363', 'QRIS2', '', '451', '105020229', '251201363', 'T4646028900553VTH4V', 'https://tripay.co.id/checkout/T4646028900553VTH4V', '1764847551', '2025-12-04', '1764848271', '', 'PAID', '165000', '1764847651', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (731, 'Tripay', '9713-251201728', 'INDOMARET', '', '836', '105030097', '251201728', 'T4646028901713YHENM', 'https://tripay.co.id/checkout/T4646028901713YHENM', '1764849410', '2025-12-04', '1764850430', '', 'PAID', '126750', '1764849629', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (732, 'Tripay', '831845-251201278', 'INDOMARET', '', '356', '105020194', '251201278', 'T4646028902304W4UEI', 'https://tripay.co.id/checkout/T4646028902304W4UEI', '1764850330', '2025-12-04', '1764851350', '', 'PAID', '126750', '1764850376', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (733, 'Tripay', '137362-251201102', 'QRIS2', '', '149', '105010053', '251201102', 'T4646028903234EA3I5', 'https://tripay.co.id/checkout/T4646028903234EA3I5', '1764851779', '2025-12-04', '1764852499', '', 'PAID', '125000', '1764851815', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (734, 'Tripay', '492270-251201332', 'MANDIRIVA', '', '417', '105020219', '251201332', 'T4646028903476WVH76', 'https://tripay.co.id/checkout/T4646028903476WVH76', '1764852117', '2025-12-04', '1764855837', '', 'PAID', '127125', '1764852206', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (735, 'Tripay', '921323-251201049', 'QRIS2', '', '79', '105010035', '251201049', 'T4646028903502TYCMA', 'https://tripay.co.id/checkout/T4646028903502TYCMA', '1764852172', '2025-12-04', '1764852891', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (736, 'Tripay', '560644-251201049', 'QRIS2', '', '79', '105010035', '251201049', 'T4646028903526GQ7BN', 'https://tripay.co.id/checkout/T4646028903526GQ7BN', '1764852205', '2025-12-04', '1764852924', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (737, 'Tripay', '612609-251201347', 'INDOMARET', '', '434', '105050001', '251201347', 'T4646028903826TYLA1', 'https://tripay.co.id/checkout/T4646028903826TYLA1', '1764852580', '2025-12-04', '1764853600', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (738, 'Tripay', '971225-251201436', 'DANA', '', '529', '105030058', '251201436', 'T4646028904032WZTIW', 'https://tripay.co.id/checkout/T4646028904032WZTIW', '1764852851', '2025-12-04', '1764853869', '', 'PAID', '125000', '1764852885', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (739, 'Tripay', '257373-251201390', 'SHOPEEPAY', '', '482', '105030048', '251201390', 'T4646028904448ZORMW', 'https://tripay.co.id/checkout/T4646028904448ZORMW', '1764853477', '2025-12-04', '1764854497', '', 'PAID', '126875', '1764853533', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (740, 'Tripay', '444522-251201443', 'INDOMARET', '', '536', '105030062', '251201443', 'T4646028904535L9HGG', 'https://tripay.co.id/checkout/T4646028904535L9HGG', '1764853625', '2025-12-04', '1764854645', '', 'PAID', '126750', '1764854328', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (741, 'Tripay', '683209-251201380', 'INDOMARET', '', '471', '105020240', '251201380', 'T46460289055129C3VR', 'https://tripay.co.id/checkout/T46460289055129C3VR', '1764855379', '2025-12-04', '1764856398', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (742, 'Tripay', '298046-251201020', 'INDOMARET', '', '36', '105020018', '251201020', 'T4646028905754L5QQO', 'https://tripay.co.id/checkout/T4646028905754L5QQO', '1764855847', '2025-12-04', '1764856867', '', 'PAID', '126750', '1764855941', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (743, 'Tripay', '194634-251201488', 'ALFAMART', '', '587', '105010207', '251201488', 'T46460289059862J5GS', 'https://tripay.co.id/checkout/T46460289059862J5GS', '1764856315', '2025-12-04', '1764860035', '', 'PAID', '126750', '1764856369', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (744, 'Tripay', '404277-251201411', 'BCAVA', '', '504', '105030053', '251201411', 'T4646028906049PHIKQ', 'https://tripay.co.id/checkout/T4646028906049PHIKQ', '1764856428', '2025-12-04', '1764857448', '', 'PAID', '127750', '1764856502', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (745, 'Tripay', '185423-251202011', 'QRIS2', '', '238', '105020145', '251202011', 'T4646028907306ZVABK', 'https://tripay.co.id/checkout/T4646028907306ZVABK', '1764859268', '2025-12-04', '1764859988', '', 'PAID', '125000', '1764859378', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (746, 'Tripay', '58752-251201369', 'BCAVA', '', '459', '105020232', '251201369', 'T4646028911341THVIR', 'https://tripay.co.id/checkout/T4646028911341THVIR', '1764887109', '2025-12-05', '1764888128', '', 'PAID', '127750', '1764887255', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (747, 'Tripay', '810708-251201423', 'MANDIRIVA', '', '516', '105020261', '251201423', 'T4646028912996O2MLA', 'https://tripay.co.id/checkout/T4646028912996O2MLA', '1764892419', '2025-12-05', '1764896131', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (748, 'Tripay', '714737-251201423', 'MANDIRIVA', '', '516', '105020261', '251201423', 'T4646028913105J9WPF', 'https://tripay.co.id/checkout/T4646028913105J9WPF', '1764892736', '2025-12-05', '1764896455', '', 'PAID', '167125', '1764892921', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (749, 'Tripay', '741233-251201065', 'QRIS2', '', '102', '105020061', '251201065', 'T4646028913593XDL1U', 'https://tripay.co.id/checkout/T4646028913593XDL1U', '1764893925', '2025-12-05', '1764894644', '', 'PAID', '125000', '1764893974', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (750, 'Tripay', '120706-251201140', 'DANA', '', '195', '105020123', '251201140', 'T4646028914333T626Z', 'https://tripay.co.id/checkout/T4646028914333T626Z', '1764895433', '2025-12-05', '1764896453', '', 'PAID', '125000', '1764895510', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (751, 'Tripay', '812272-251201434', 'BRIVA', '', '527', '105020268', '251201434', 'T4646028914699MQJDP', 'https://tripay.co.id/checkout/T4646028914699MQJDP', '1764896328', '2025-12-05', '1764900047', '', 'PAID', '167125', '1764896468', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (752, 'Tripay', '439732-251201670', 'BCAVA', '', '773', '105020364', '251201670', 'T4646028914784ZAG5X', 'https://tripay.co.id/checkout/T4646028914784ZAG5X', '1764896533', '2025-12-05', '1764897553', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (753, 'Tripay', '675957-251201566', 'INDOMARET', '', '668', '105010238', '251201566', 'T4646028915338LLBCU', 'https://tripay.co.id/checkout/T4646028915338LLBCU', '1764897758', '2025-12-05', '1764898777', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (754, 'Tripay', '198352-251201272', 'INDOMARET', '', '349', '105030028', '251201272', 'T4646028915928E0SU0', 'https://tripay.co.id/checkout/T4646028915928E0SU0', '1764898903', '2025-12-05', '1764899923', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (755, 'Tripay', '965668-251201750', 'QRIS2', '', '858', '105020396', '251201750', 'T4646028916300NW4QP', 'https://tripay.co.id/checkout/T4646028916300NW4QP', '1764899552', '2025-12-05', '1764900271', '', 'UNPAID', '55000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (756, 'Tripay', '628281-251201750', 'QRIS2', '', '858', '105020396', '251201750', 'T4646028916323WPQVD', 'https://tripay.co.id/checkout/T4646028916323WPQVD', '1764899598', '2025-12-05', '1764900318', '', 'PAID', '55000', '1764899678', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (757, 'Tripay', '180772-251201248', 'MANDIRIVA', '', '323', '105020178', '251201248', 'T4646028916806BEEH2', 'https://tripay.co.id/checkout/T4646028916806BEEH2', '1764900530', '2025-12-05', '1764904250', '', 'PAID', '127125', '1764900593', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (758, 'Tripay', '86603-251201313', 'MANDIRIVA', '', '394', '105020211', '251201313', 'T4646028916816WVZ4Z', 'https://tripay.co.id/checkout/T4646028916816WVZ4Z', '1764900550', '2025-12-05', '1764904270', '', 'PAID', '127125', '1764900648', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (759, 'Tripay', '213885-251201243', 'BRIVA', '', '318', '105030019', '251201243', 'T4646028917118WAKGI', 'https://tripay.co.id/checkout/T4646028917118WAKGI', '1764901102', '2025-12-05', '1764904814', '', 'PAID', '127125', '1764901215', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (760, 'Tripay', '840014-251201380', 'INDOMARET', '', '471', '105020240', '251201380', 'T46460289171203SAWS', 'https://tripay.co.id/checkout/T46460289171203SAWS', '1764901104', '2025-12-05', '1767200399', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (761, 'Tripay', '409192-251201746', 'BCAVA', '', '854', '105010308', '251201746', 'T4646028917347BP77W', 'https://tripay.co.id/checkout/T4646028917347BP77W', '1764901570', '2025-12-05', '1764902590', '', 'PAID', '73750', '1764901661', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (762, 'Tripay', '341629-251201348', 'ALFAMART', '', '435', '105050002', '251201348', 'T4646028917846VIDKX', 'https://tripay.co.id/checkout/T4646028917846VIDKX', '1764902458', '2025-12-05', '1764906179', '', 'PAID', '126750', '1764902535', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (763, 'Tripay', '905545-251201008', 'ALFAMART', '', '10', '105010004', '251201008', 'T4646028918101K6LUH', 'https://tripay.co.id/checkout/T4646028918101K6LUH', '1764902884', '2025-12-05', '1764906603', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (764, 'Tripay', '84432-251201462', 'DANA', '', '558', '105030065', '251201462', 'T4646028918222UFRU1', 'https://tripay.co.id/checkout/T4646028918222UFRU1', '1764903111', '2025-12-05', '1764904131', '', 'PAID', '125000', '1764903292', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (765, 'Tripay', '555217-251201717', 'INDOMARET', '', '825', '105030094', '251201717', 'T4646028918394VXQZH', 'https://tripay.co.id/checkout/T4646028918394VXQZH', '1764903437', '2025-12-05', '1764904457', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (766, 'Tripay', '637627-251201418', 'DANA', '', '511', '105020257', '251201418', 'T4646028918504VIKIH', 'https://tripay.co.id/checkout/T4646028918504VIKIH', '1764903633', '2025-12-05', '1764904652', '', 'PAID', '125000', '1764903732', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (767, 'Tripay', '344533-251201249', 'BRIVA', '', '324', '105030021', '251201249', 'T4646028918740MKBSR', 'https://tripay.co.id/checkout/T4646028918740MKBSR', '1764904016', '2025-12-05', '1764907735', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (768, 'Tripay', '619457-251201409', 'BCAVA', '', '502', '105010188', '251201409', 'T4646028919209GNAKG', 'https://tripay.co.id/checkout/T4646028919209GNAKG', '1764904782', '2025-12-05', '1764905801', '', 'PAID', '167750', '1764904848', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (769, 'Tripay', '851891-251201197', 'MANDIRIVA', '', '266', '105020158', '251201197', 'T46460289192613XWVA', 'https://tripay.co.id/checkout/T46460289192613XWVA', '1764904870', '2025-12-05', '1764908582', '', 'PAID', '127125', '1764905399', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (770, 'Tripay', '925091-251201633', 'BRIVA', '', '736', '105050032', '251201633', 'T4646028919477EYFTS', 'https://tripay.co.id/checkout/T4646028919477EYFTS', '1764905272', '2025-12-05', '1764908991', '', 'PAID', '127125', '1764905424', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (771, 'Tripay', '300174-251201268', 'INDOMARET', '', '344', '105030026', '251201268', 'T4646028919668LVZDP', 'https://tripay.co.id/checkout/T4646028919668LVZDP', '1764905632', '2025-12-05', '1764906652', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (772, 'Tripay', '906481-251201556', 'QRIS2', '', '657', '105010229', '251201556', 'T4646028919670VZ2M5', 'https://tripay.co.id/checkout/T4646028919670VZ2M5', '1764905639', '2025-12-05', '1764906358', '', 'PAID', '125000', '1764905684', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (773, 'Tripay', '355734-251201692', 'QRIS2', '', '795', '105020372', '251201692', 'T46460289196751EFYK', 'https://tripay.co.id/checkout/T46460289196751EFYK', '1764905651', '2025-12-05', '1764906370', '', 'PAID', '125000', '1764905884', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (774, 'Tripay', '99715-251201261', 'INDOMARET', '', '337', '105030025', '251201261', 'T46460289200322D20K', 'https://tripay.co.id/checkout/T46460289200322D20K', '1764906216', '2025-12-05', '1764907236', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (775, 'Tripay', '295228-251201469', 'INDOMARET', '', '567', '105030068', '251201469', 'T4646028920325T1TJQ', 'https://tripay.co.id/checkout/T4646028920325T1TJQ', '1764906788', '2025-12-05', '1764907808', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (776, 'Tripay', '885950-251201365', 'BCAVA', '', '453', '105010170', '251201365', 'T4646028920361OB2G2', 'https://tripay.co.id/checkout/T4646028920361OB2G2', '1764906860', '2025-12-05', '1764907880', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (777, 'Tripay', '190444-251201365', 'QRIS2', '', '453', '105010170', '251201365', 'T4646028920465ELOTE', 'https://tripay.co.id/checkout/T4646028920465ELOTE', '1764907052', '2025-12-05', '1764907771', '', 'PAID', '125000', '1764907140', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (778, 'Tripay', '379318-251201479', 'MANDIRIVA', '', '577', '105050021', '251201479', 'T4646028920518PDPCU', 'https://tripay.co.id/checkout/T4646028920518PDPCU', '1764907165', '2025-12-05', '1764910885', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (779, 'Tripay', '122473-251201564', 'ALFAMART', '', '665', '105010235', '251201564', 'T46460289205556PUKE', 'https://tripay.co.id/checkout/T46460289205556PUKE', '1764907248', '2025-12-05', '1764910968', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (780, 'Tripay', '869346-251201479', 'MANDIRIVA', '', '577', '105050021', '251201479', 'T46460289205716HCKS', 'https://tripay.co.id/checkout/T46460289205716HCKS', '1764907282', '2025-12-05', '1764911001', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (781, 'Tripay', '558075-251201564', 'ALFAMART', '', '665', '105010235', '251201564', 'T4646028920658X037X', 'https://tripay.co.id/checkout/T4646028920658X037X', '1764907427', '2025-12-05', '1764911147', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (782, 'Tripay', '217696-251201767', 'BCAVA', '', '875', '105020406', '251201767', 'T4646028920661EUK9A', 'https://tripay.co.id/checkout/T4646028920661EUK9A', '1764907434', '2025-12-05', '1764908454', '', 'UNPAID', '52750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (783, 'Tripay', '344566-251201484', 'BCAVA', '', '583', '105010204', '251201484', 'T4646028920672GVP4F', 'https://tripay.co.id/checkout/T4646028920672GVP4F', '1764907452', '2025-12-05', '1764908472', '', 'PAID', '127750', '1764907524', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (784, 'Tripay', '912006-251201767', 'BCAVA', '', '875', '105020406', '251201767', 'T4646028920756RAMMN', 'https://tripay.co.id/checkout/T4646028920756RAMMN', '1764907635', '2025-12-05', '1764908655', '', 'PAID', '52750', '1764907695', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (785, 'Tripay', '150018-251201479', 'MANDIRIVA', '', '577', '105050021', '251201479', 'T4646028920774G1EGX', 'https://tripay.co.id/checkout/T4646028920774G1EGX', '1764907666', '2025-12-05', '1764911386', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (786, 'Tripay', '362450-251201569', 'BCAVA', '', '671', '105020320', '251201569', 'T4646028920909EKQYH', 'https://tripay.co.id/checkout/T4646028920909EKQYH', '1764907881', '2025-12-05', '1764908900', '', 'PAID', '127750', '1764907929', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (787, 'Tripay', '274850-251201086', 'BCAVA', '', '131', '105020082', '251201086', 'T4646028920932POUWK', 'https://tripay.co.id/checkout/T4646028920932POUWK', '1764907923', '2025-12-05', '1764908943', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (788, 'Tripay', '752407-251201479', 'MANDIRIVA', '', '577', '105050021', '251201479', 'T4646028920937JJY2R', 'https://tripay.co.id/checkout/T4646028920937JJY2R', '1764907935', '2025-12-05', '1764911655', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (789, 'Tripay', '856813-251201496', 'MANDIRIVA', '', '595', '105050022', '251201496', 'T4646028920955LRSMY', 'https://tripay.co.id/checkout/T4646028920955LRSMY', '1764907958', '2025-12-05', '1764911678', '', 'PAID', '127125', '1764908163', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (790, 'Tripay', '721811-251201640', 'DANA', '', '743', '105050035', '251201640', 'T46460289209588A5YJ', 'https://tripay.co.id/checkout/T46460289209588A5YJ', '1764907961', '2025-12-05', '1764908980', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (791, 'Tripay', '473099-251201400', 'DANA', '', '493', '105020247', '251201400', 'T4646028920982QO5SW', 'https://tripay.co.id/checkout/T4646028920982QO5SW', '1764908019', '2025-12-05', '1764909038', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (792, 'Tripay', '353105-251201597', 'DANA', '', '699', '105030086', '251201597', 'T4646028921060AO5XL', 'https://tripay.co.id/checkout/T4646028921060AO5XL', '1764908187', '2025-12-05', '1764909206', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (793, 'Tripay', '275918-251201479', 'MANDIRIVA', '', '577', '105050021', '251201479', 'T4646028921085O7RLW', 'https://tripay.co.id/checkout/T4646028921085O7RLW', '1764908235', '2025-12-05', '1764911947', '', 'PAID', '127125', '1764908566', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (794, 'Tripay', '76367-251201717', 'BRIVA', '', '825', '105030094', '251201717', 'T4646028921096O6QGL', 'https://tripay.co.id/checkout/T4646028921096O6QGL', '1764908257', '2025-12-05', '1764911977', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (795, 'Tripay', '205887-251201717', 'BRIVA', '', '825', '105030094', '251201717', 'T4646028921267JJ0ZQ', 'https://tripay.co.id/checkout/T4646028921267JJ0ZQ', '1764908600', '2025-12-05', '1764912320', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (796, 'Tripay', '57976-251201356', 'BRIVA', '', '444', '105020226', '251201356', 'T4646028921280PQ5N1', 'https://tripay.co.id/checkout/T4646028921280PQ5N1', '1764908632', '2025-12-05', '1764912351', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (797, 'Tripay', '614406-251201356', 'BRIVA', '', '444', '105020226', '251201356', 'T4646028921332FVYKD', 'https://tripay.co.id/checkout/T4646028921332FVYKD', '1764908745', '2025-12-05', '1764912465', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (798, 'Tripay', '705368-251201597', 'DANA', '', '699', '105030086', '251201597', 'T4646028921448H4WUA', 'https://tripay.co.id/checkout/T4646028921448H4WUA', '1764908972', '2025-12-05', '1764909991', '', 'PAID', '125000', '1764909008', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (799, 'Tripay', '908635-251201351', 'ALFAMART', '', '438', '105050005', '251201351', 'T4646028921524FKC0X', 'https://tripay.co.id/checkout/T4646028921524FKC0X', '1764909126', '2025-12-05', '1764912846', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (800, 'Tripay', '607771-251201717', 'BCAVA', '', '825', '105030094', '251201717', 'T4646028921725ZBCAO', 'https://tripay.co.id/checkout/T4646028921725ZBCAO', '1764909510', '2025-12-05', '1764910530', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (801, 'Tripay', '841306-251201186', 'MANDIRIVA', '', '251', '105020152', '251201186', 'T4646028921748OWRN8', 'https://tripay.co.id/checkout/T4646028921748OWRN8', '1764909579', '2025-12-05', '1764913299', '', 'PAID', '127125', '1764909661', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (802, 'Tripay', '402952-251201717', 'BCAVA', '', '825', '105030094', '251201717', 'T4646028921775QMB5P', 'https://tripay.co.id/checkout/T4646028921775QMB5P', '1764909643', '2025-12-05', '1764910663', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (803, 'Tripay', '305767-251201045', 'OVO', '', '71', '105020041', '251201045', 'T4646028922007EUUP0', 'https://tripay.co.id/checkout/T4646028922007EUUP0', '1764910150', '2025-12-05', '1764911170', '', 'UNPAID', '208075', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (804, 'Tripay', '861272-251201115', 'INDOMARET', '', '164', '105020103', '251201115', 'T4646028922040SG8AD', 'https://tripay.co.id/checkout/T4646028922040SG8AD', '1764910208', '2025-12-05', '1764911228', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (805, 'Tripay', '605384-251201045', 'OVO', '', '71', '105020041', '251201045', 'T46460289221406GEUN', 'https://tripay.co.id/checkout/T46460289221406GEUN', '1764910447', '2025-12-05', '1764911467', '', 'PAID', '208075', '1764910510', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (806, 'Tripay', '833571-251201059', 'QRIS2', '', '94', '105020057', '251201059', 'T4646028922215LEABW', 'https://tripay.co.id/checkout/T4646028922215LEABW', '1764910641', '2025-12-05', '1764911360', '', 'PAID', '125000', '1764910717', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (807, 'Tripay', '501746-251201640', 'DANA', '', '743', '105050035', '251201640', 'T4646028922473I6WM1', 'https://tripay.co.id/checkout/T4646028922473I6WM1', '1764911160', '2025-12-05', '1764912179', '', 'PAID', '125000', '1764911212', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (808, 'Tripay', '934408-251201400', 'DANA', '', '493', '105020247', '251201400', 'T4646028922548JVLR1', 'https://tripay.co.id/checkout/T4646028922548JVLR1', '1764911315', '2025-12-05', '1764912335', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (809, 'Tripay', '767632-251201095', 'BCAVA', '', '142', '105020091', '251201095', 'T4646028922731KGNCQ', 'https://tripay.co.id/checkout/T4646028922731KGNCQ', '1764911663', '2025-12-05', '1764912682', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (810, 'Tripay', '653198-251201061', 'BNIVA', '', '96', '105010039', '251201061', 'T4646028922847FGFYT', 'https://tripay.co.id/checkout/T4646028922847FGFYT', '1764911920', '2025-12-05', '1764912940', '', 'PAID', '127125', '1764912032', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (811, 'Tripay', '159277-251201617', 'BRIVA', '', '719', '105020343', '251201617', 'T46460289231337F4UO', 'https://tripay.co.id/checkout/T46460289231337F4UO', '1764912482', '2025-12-05', '1764916202', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (812, 'Tripay', '985708-251201617', 'BRIVA', '', '719', '105020343', '251201617', 'T4646028923207Z4TJQ', 'https://tripay.co.id/checkout/T4646028923207Z4TJQ', '1764912612', '2025-12-05', '1764916331', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (813, 'Tripay', '814892-251201689', 'INDOMARET', '', '792', '105020370', '251201689', 'T4646028923269Z1PPR', 'https://tripay.co.id/checkout/T4646028923269Z1PPR', '1764912719', '2025-12-05', '1764913738', '', 'PAID', '126750', '1764912883', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (814, 'Tripay', '494449-251201268', 'INDOMARET', '', '344', '105030026', '251201268', 'T4646028923365WCNEJ', 'https://tripay.co.id/checkout/T4646028923365WCNEJ', '1764912875', '2025-12-05', '1764913895', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (815, 'Tripay', '708578-251201651', 'BCAVA', '', '754', '105010271', '251201651', 'T4646028923608BSNUL', 'https://tripay.co.id/checkout/T4646028923608BSNUL', '1764913364', '2025-12-05', '1764914384', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (816, 'Tripay', '852491-251201268', 'ALFAMART', '', '344', '105030026', '251201268', 'T4646028923761RPXUK', 'https://tripay.co.id/checkout/T4646028923761RPXUK', '1764913642', '2025-12-05', '1764917362', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (817, 'Tripay', '430789-251201356', 'BRIVA', '', '444', '105020226', '251201356', 'T4646028924028QHLYX', 'https://tripay.co.id/checkout/T4646028924028QHLYX', '1764914044', '2025-12-05', '1764917764', '', 'PAID', '127125', '1764914155', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (818, 'Tripay', '502271-251201296', 'ALFAMART', '', '375', '105020203', '251201296', 'T4646028924233H4PX8', 'https://tripay.co.id/checkout/T4646028924233H4PX8', '1764914406', '2025-12-05', '1764918126', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (819, 'Tripay', '112774-251201296', 'INDOMARET', '', '375', '105020203', '251201296', 'T4646028925402TPUFA', 'https://tripay.co.id/checkout/T4646028925402TPUFA', '1764916232', '2025-12-05', '1764917252', '', 'PAID', '126750', '1764916280', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (820, 'Tripay', '889750-251201527', 'INDOMARET', '', '628', '105020302', '251201527', 'T4646028925486DPRTZ', 'https://tripay.co.id/checkout/T4646028925486DPRTZ', '1764916344', '2025-12-05', '1764917364', '', 'PAID', '126750', '1764916389', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (821, 'Tripay', '25448-251201450', 'SHOPEEPAY', '', '545', '105010194', '251201450', 'T4646028925702JSAKN', 'https://tripay.co.id/checkout/T4646028925702JSAKN', '1764916680', '2025-12-05', '1764917698', '', 'PAID', '126875', '1764916737', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (822, 'Tripay', '968752-251201042', 'DANA', '', '65', '105020038', '251201042', 'T4646028925917KZX0D', 'https://tripay.co.id/checkout/T4646028925917KZX0D', '1764917060', '2025-12-05', '1764918065', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (823, 'Tripay', '497310-251201042', 'DANA', '', '65', '105020038', '251201042', 'T46460289259544YVLE', 'https://tripay.co.id/checkout/T46460289259544YVLE', '1764917116', '2025-12-05', '1764918135', '', 'PAID', '125000', '1764917155', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (824, 'Tripay', '494584-251201074', 'BCAVA', '', '114', '105010045', '251201074', 'T4646028926062CMSSL', 'https://tripay.co.id/checkout/T4646028926062CMSSL', '1764917298', '2025-12-05', '1764918318', '', 'PAID', '127750', '1764917760', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (825, 'Tripay', '42130-251201268', 'INDOMARET', '', '344', '105030026', '251201268', 'T4646028926201HXXO8', 'https://tripay.co.id/checkout/T4646028926201HXXO8', '1764917539', '2025-12-05', '1764918559', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (826, 'Tripay', '417451-251201720', 'QRIS2', '', '828', '105020384', '251201720', 'T4646028926404QDEUW', 'https://tripay.co.id/checkout/T4646028926404QDEUW', '1764917929', '2025-12-05', '1764918648', '', 'PAID', '125000', '1764917973', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (827, 'Tripay', '75885-251201469', 'INDOMARET', '', '567', '105030068', '251201469', 'T4646028926593VXUM5', 'https://tripay.co.id/checkout/T4646028926593VXUM5', '1764918260', '2025-12-05', '1764919280', '', 'PAID', '126750', '1764918331', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (828, 'Tripay', '958328-251201134', 'BCAVA', '', '188', '105010069', '251201134', 'T4646028926624DNGFE', 'https://tripay.co.id/checkout/T4646028926624DNGFE', '1764918312', '2025-12-05', '1764919332', '', 'UNPAID', '167750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (829, 'Tripay', '158655-251201466', 'MANDIRIVA', '', '562', '105020280', '251201466', 'T4646028926878FANFR', 'https://tripay.co.id/checkout/T4646028926878FANFR', '1764918800', '2025-12-05', '1764922512', '', 'PAID', '127125', '1764919006', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (830, 'Tripay', '590770-251201574', 'BRIVA', '', '676', '105010241', '251201574', 'T4646028926918MT9T6', 'https://tripay.co.id/checkout/T4646028926918MT9T6', '1764918862', '2025-12-05', '1764922582', '', 'PAID', '167125', '1764918910', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (831, 'Tripay', '86959-251201057', 'QRIS', '', '89', '105020053', '251201057', 'T4646028927100UENLW', 'https://tripay.co.id/checkout/T4646028927100UENLW', '1764919214', '2025-12-05', '1764919934', '', 'PAID', '125812', '1764919272', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (832, 'Tripay', '494998-251201717', 'BRIVA', '', '825', '105030094', '251201717', 'T46460289272092WT8I', 'https://tripay.co.id/checkout/T46460289272092WT8I', '1764919457', '2025-12-05', '1764923169', '', 'PAID', '127125', '1764919813', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (833, 'Tripay', '437147-251201520', 'QRIS2', '', '621', '105030074', '251201520', 'T4646028927479GUANF', 'https://tripay.co.id/checkout/T4646028927479GUANF', '1764919990', '2025-12-05', '1764920709', '', 'PAID', '125000', '1764920047', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (834, 'Tripay', '349631-251201599', 'BCAVA', '', '701', '105020334', '251201599', 'T4646028927893EPXKQ', 'https://tripay.co.id/checkout/T4646028927893EPXKQ', '1764920799', '2025-12-05', '1764921819', '', 'PAID', '167750', '1764921097', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (835, 'Tripay', '363981-251201275', 'BRIVA', '', '352', '105020192', '251201275', 'T4646028927904VEQJT', 'https://tripay.co.id/checkout/T4646028927904VEQJT', '1764920832', '2025-12-05', '1764924544', '', 'PAID', '127125', '1764920925', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (836, 'Tripay', '118481-251201156', 'BNIVA', '', '217', '105010083', '251201156', 'T46460289281220SJJ7', 'https://tripay.co.id/checkout/T46460289281220SJJ7', '1764921291', '2025-12-05', '1764922311', '', 'PAID', '127125', '1764921346', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (837, 'Tripay', '96949-251201249', 'BRIVA', '', '324', '105030021', '251201249', 'T4646028928149GZVTD', 'https://tripay.co.id/checkout/T4646028928149GZVTD', '1764921338', '2025-12-05', '1764925057', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (838, 'Tripay', '875803-251201219', 'MANDIRIVA', '', '293', '105010113', '251201219', 'T4646028928194C5AQJ', 'https://tripay.co.id/checkout/T4646028928194C5AQJ', '1764921443', '2025-12-05', '1764925155', '', 'PAID', '127125', '1764921524', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (839, 'Tripay', '272242-251201221', 'BRIVA', '', '296', '105020166', '251201221', 'T4646028928227ODJLL', 'https://tripay.co.id/checkout/T4646028928227ODJLL', '1764921502', '2025-12-05', '1764925222', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (840, 'Tripay', '234807-251201221', 'BRIVA', '', '296', '105020166', '251201221', 'T4646028928245G15TX', 'https://tripay.co.id/checkout/T4646028928245G15TX', '1764921534', '2025-12-05', '1764925254', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (841, 'Tripay', '581481-251201001', 'MANDIRIVA', '', '1', '105020001', '251201001', 'T46460289282515XRWA', 'https://tripay.co.id/checkout/T46460289282515XRWA', '1764921545', '2025-12-05', '1764925264', '', 'PAID', '207125', '1764921641', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (842, 'Tripay', '590524-251201441', 'BNIVA', '', '534', '105020270', '251201441', 'T4646028928253MQX3J', 'https://tripay.co.id/checkout/T4646028928253MQX3J', '1764921546', '2025-12-05', '1764922565', '', 'PAID', '167125', '1764921666', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (843, 'Tripay', '480260-251201445', 'QRIS2', '', '538', '105030063', '251201445', 'T4646028928327PB2Q1', 'https://tripay.co.id/checkout/T4646028928327PB2Q1', '1764921685', '2025-12-05', '1764922405', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (844, 'Tripay', '668857-251201249', 'BRIVA', '', '324', '105030021', '251201249', 'T4646028928363HN8XF', 'https://tripay.co.id/checkout/T4646028928363HN8XF', '1764921748', '2025-12-05', '1764925468', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (845, 'Tripay', '991630-251201445', 'DANA', '', '538', '105030063', '251201445', 'T4646028928365RO0WN', 'https://tripay.co.id/checkout/T4646028928365RO0WN', '1764921752', '2025-12-05', '1764922772', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (846, 'Tripay', '417437-251201528', 'INDOMARET', '', '629', '105020303', '251201528', 'T4646028928399DDD9R', 'https://tripay.co.id/checkout/T4646028928399DDD9R', '1764921810', '2025-12-05', '1764922829', '', 'PAID', '126750', '1764921882', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (847, 'Tripay', '311802-251201268', 'BRIVA', '', '344', '105030026', '251201268', 'T46460289284238DNGY', 'https://tripay.co.id/checkout/T46460289284238DNGY', '1764921864', '2025-12-05', '1764925583', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (848, 'Tripay', '92578-251201268', 'INDOMARET', '', '344', '105030026', '251201268', 'T4646028928483VGXDE', 'https://tripay.co.id/checkout/T4646028928483VGXDE', '1764921987', '2025-12-05', '1764923007', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (849, 'Tripay', '685997-251201445', 'QRIS2', '', '538', '105030063', '251201445', 'T4646028928545AX7X7', 'https://tripay.co.id/checkout/T4646028928545AX7X7', '1764922133', '2025-12-05', '1764922852', '', 'PAID', '165000', '1764922207', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (850, 'Tripay', '102491-251201177', 'INDOMARET', '', '242', '105010095', '251201177', 'T4646028928553UL6CL', 'https://tripay.co.id/checkout/T4646028928553UL6CL', '1764922145', '2025-12-05', '1764923165', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (851, 'Tripay', '54978-251201433', 'DANA', '', '526', '105020267', '251201433', 'T4646028928576VRDLL', 'https://tripay.co.id/checkout/T4646028928576VRDLL', '1764922193', '2025-12-05', '1764923212', '', 'PAID', '125000', '1764922220', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (852, 'Tripay', '598908-251201580', 'BRIVA', '', '682', '105010243', '251201580', 'T4646028928714MME5O', 'https://tripay.co.id/checkout/T4646028928714MME5O', '1764922475', '2025-12-05', '1764926195', '', 'PAID', '127125', '1764922520', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (853, 'Tripay', '676062-251201700', 'BNIVA', '', '803', '105010289', '251201700', 'T4646028928826IGHDS', 'https://tripay.co.id/checkout/T4646028928826IGHDS', '1764922691', '2025-12-05', '1764923711', '', 'PAID', '127125', '1764922859', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (854, 'Tripay', '867932-251201761', 'BRIVA', '', '869', '105030102', '251201761', 'T4646028928868PVNEM', 'https://tripay.co.id/checkout/T4646028928868PVNEM', '1764922754', '2025-12-05', '1764926474', '', 'PAID', '46125', '1764922902', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (855, 'Tripay', '10779-251201277', 'INDOMARET', '', '355', '105020193', '251201277', 'T46460289289669R4GS', 'https://tripay.co.id/checkout/T46460289289669R4GS', '1764922913', '2025-12-05', '1764923932', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (856, 'Tripay', '360795-251201529', 'DANA', '', '630', '105020304', '251201529', 'T4646028929089Z3BBF', 'https://tripay.co.id/checkout/T4646028929089Z3BBF', '1764923179', '2025-12-05', '1764924198', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (857, 'Tripay', '823957-251201366', 'QRIS2', '', '455', '105010172', '251201366', 'T4646028929098QXQYY', 'https://tripay.co.id/checkout/T4646028929098QXQYY', '1764923187', '2025-12-05', '1764923907', '', 'PAID', '125000', '1764923225', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (858, 'Tripay', '779602-251201529', 'BCAVA', '', '630', '105020304', '251201529', 'T4646028929171GAVNE', 'https://tripay.co.id/checkout/T4646028929171GAVNE', '1764923316', '2025-12-05', '1764924336', '', 'PAID', '127750', '1764923551', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (859, 'Tripay', '141588-251201645', 'MANDIRIVA', '', '748', '105020352', '251201645', 'T4646028929350VTODA', 'https://tripay.co.id/checkout/T4646028929350VTODA', '1764923639', '2025-12-05', '1764927351', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (860, 'Tripay', '368702-251201287', 'DANA', '', '365', '105010136', '251201287', 'T4646028929375YBVK6', 'https://tripay.co.id/checkout/T4646028929375YBVK6', '1764923687', '2025-12-05', '1764924706', '', 'PAID', '125000', '1764923799', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (861, 'Tripay', '56166-251201762', 'BRIVA', '', '870', '105030103', '251201762', 'T4646028929415A9KKD', 'https://tripay.co.id/checkout/T4646028929415A9KKD', '1764923787', '2025-12-05', '1764927507', '', 'PAID', '36125', '1764923853', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (862, 'Tripay', '156850-251201078', 'BRIVA', '', '120', '105010047', '251201078', 'T4646028929468W3WUF', 'https://tripay.co.id/checkout/T4646028929468W3WUF', '1764923897', '2025-12-05', '1764927617', '', 'PAID', '127125', '1764924190', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (863, 'Tripay', '305724-251201305', 'INDOMARET', '', '384', '105020209', '251201305', 'T4646028929474DACPI', 'https://tripay.co.id/checkout/T4646028929474DACPI', '1764923919', '2025-12-05', '1764924938', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (864, 'Tripay', '58393-251201645', 'BRIVA', '', '748', '105020352', '251201645', 'T4646028929483VMOKN', 'https://tripay.co.id/checkout/T4646028929483VMOKN', '1764923933', '2025-12-05', '1764927652', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (865, 'Tripay', '559988-251201122', 'QRIS', '', '171', '105010062', '251201122', 'T46460289295973OTQ5', 'https://tripay.co.id/checkout/T46460289295973OTQ5', '1764924164', '2025-12-05', '1764924884', '', 'PAID', '206092', '1764924232', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (866, 'Tripay', '920369-251201645', 'QRIS2', '', '748', '105020352', '251201645', 'T4646028929759XI13S', 'https://tripay.co.id/checkout/T4646028929759XI13S', '1764924449', '2025-12-05', '1764925168', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (867, 'Tripay', '920279-251201645', 'INDOMARET', '', '748', '105020352', '251201645', 'T4646028929827G0AP3', 'https://tripay.co.id/checkout/T4646028929827G0AP3', '1764924558', '2025-12-05', '1764925578', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (868, 'Tripay', '971281-251201607', 'DANA', '', '709', '105010257', '251201607', 'T4646028930406TMCDT', 'https://tripay.co.id/checkout/T4646028930406TMCDT', '1764925636', '2025-12-05', '1764926655', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (869, 'Tripay', '737675-251201305', 'INDOMARET', '', '384', '105020209', '251201305', 'T4646028930490L8JEG', 'https://tripay.co.id/checkout/T4646028930490L8JEG', '1764925781', '2025-12-05', '1764926801', '', 'PAID', '126750', '1764925831', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (870, 'Tripay', '732246-251201595', 'INDOMARET', '', '697', '105030085', '251201595', 'T4646028930757KBYMG', 'https://tripay.co.id/checkout/T4646028930757KBYMG', '1764926387', '2025-12-05', '1764927407', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (871, 'Tripay', '915324-251201588', 'BCAVA', '', '690', '105010248', '251201588', 'T4646028930982FAOSF', 'https://tripay.co.id/checkout/T4646028930982FAOSF', '1764926784', '2025-12-05', '1764927803', '', 'PAID', '127750', '1764926846', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (872, 'Tripay', '144819-251201645', 'QRIS2', '', '748', '105020352', '251201645', 'T46460289309844YPQD', 'https://tripay.co.id/checkout/T46460289309844YPQD', '1764926786', '2025-12-05', '1764927505', '', 'PAID', '125000', '1764926815', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (873, 'Tripay', '3316-251201741', 'MANDIRIVA', '', '849', '105020393', '251201741', 'T46460289313894TYCA', 'https://tripay.co.id/checkout/T46460289313894TYCA', '1764927489', '2025-12-05', '1764931208', '', 'UNPAID', '77125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (874, 'Tripay', '217479-251201741', 'MANDIRIVA', '', '849', '105020393', '251201741', 'T4646028931462JG3PZ', 'https://tripay.co.id/checkout/T4646028931462JG3PZ', '1764927684', '2025-12-05', '1764931404', '', 'UNPAID', '77125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (875, 'Tripay', '907526-251201595', 'INDOMARET', '', '697', '105030085', '251201595', 'T4646028931539D6VFP', 'https://tripay.co.id/checkout/T4646028931539D6VFP', '1764927889', '2025-12-05', '1764928909', '', 'PAID', '126750', '1764928210', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (876, 'Tripay', '637490-251201103', 'BNIVA', '', '150', '105020097', '251201103', 'T4646028931596WSUIU', 'https://tripay.co.id/checkout/T4646028931596WSUIU', '1764928087', '2025-12-05', '1764929107', '', 'PAID', '127125', '1764928289', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (877, 'Tripay', '918134-251201440', 'BRIVA', '', '533', '105030061', '251201440', 'T46460289319326KVAP', 'https://tripay.co.id/checkout/T46460289319326KVAP', '1764928560', '2025-12-05', '1764932273', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (878, 'Tripay', '49760-251201440', 'QRIS2', '', '533', '105030061', '251201440', 'T46460289319614SOZ9', 'https://tripay.co.id/checkout/T46460289319614SOZ9', '1764928601', '2025-12-05', '1764929320', '', 'PAID', '125000', '1764928800', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (879, 'Tripay', '502532-251201209', 'INDOMARET', '', '280', '105020162', '251201209', 'T4646028932114X8WJE', 'https://tripay.co.id/checkout/T4646028932114X8WJE', '1764928816', '2025-12-05', '1764929836', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (880, 'Tripay', '693630-251201607', 'DANA', '', '709', '105010257', '251201607', 'T46460289322973VLLI', 'https://tripay.co.id/checkout/T46460289322973VLLI', '1764929048', '2025-12-05', '1764930067', '', 'PAID', '165000', '1764929138', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (881, 'Tripay', '248779-251201302', 'BNIVA', '', '381', '105010141', '251201302', 'T46460289323115YHOV', 'https://tripay.co.id/checkout/T46460289323115YHOV', '1764929075', '2025-12-05', '1764930094', '', 'PAID', '127125', '1764929143', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (882, 'Tripay', '111708-251201049', 'INDOMARET', '', '79', '105010035', '251201049', 'T4646028932315GSPDV', 'https://tripay.co.id/checkout/T4646028932315GSPDV', '1764929078', '2025-12-05', '1764930098', '', 'PAID', '166750', '1764929206', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (883, 'Tripay', '804829-251201406', 'DANA', '', '499', '105010186', '251201406', 'T4646028932480H3ZBT', 'https://tripay.co.id/checkout/T4646028932480H3ZBT', '1764929291', '2025-12-05', '1764930310', '', 'PAID', '125000', '1764929327', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (884, 'Tripay', '772543-251201501', 'DANA', '', '600', '105050027', '251201501', 'T4646028932651LNKPX', 'https://tripay.co.id/checkout/T4646028932651LNKPX', '1764929549', '2025-12-05', '1764930568', '', 'PAID', '165000', '1764929574', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (885, 'Tripay', '591730-251201667', 'INDOMARET', '', '770', '105010279', '251201667', 'T4646028932783S1ZWF', 'https://tripay.co.id/checkout/T4646028932783S1ZWF', '1764929760', '2025-12-05', '1764930778', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (886, 'Tripay', '168135-251201329', 'ALFAMART', '', '412', '105010159', '251201329', 'T4646028932959MSESX', 'https://tripay.co.id/checkout/T4646028932959MSESX', '1764929994', '2025-12-05', '1764933714', '', 'PAID', '166750', '1764930774', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (887, 'Tripay', '471981-251201500', 'INDOMARET', '', '599', '105050026', '251201500', 'T4646028933224IDGKV', 'https://tripay.co.id/checkout/T4646028933224IDGKV', '1764930394', '2025-12-05', '1764931413', '', 'PAID', '126750', '1764930494', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (888, 'Tripay', '837627-251201780', 'BCAVA', '', '888', '10510004', '251201780', 'T4646028933548Z9QEG', 'https://tripay.co.id/checkout/T4646028933548Z9QEG', '1764930941', '2025-12-05', '1764931961', '', 'UNPAID', '24750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (889, 'Tripay', '116563-251201560', 'SHOPEEPAY', '', '661', '105020318', '251201560', 'T46460289336095KU7E', 'https://tripay.co.id/checkout/T46460289336095KU7E', '1764931040', '2025-12-05', '1764932060', '', 'PAID', '126875', '1764931072', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (890, 'Tripay', '881118-251201780', 'QRIS', '', '888', '10510004', '251201780', 'T46460289336689ZU7X', 'https://tripay.co.id/checkout/T46460289336689ZU7X', '1764931130', '2025-12-05', '1764931849', '', 'PAID', '22452', '1764931256', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (891, 'Tripay', '133580-251201394', 'INDOMARET', '', '487', '105020245', '251201394', 'T46460289338994UUMQ', 'https://tripay.co.id/checkout/T46460289338994UUMQ', '1764931469', '2025-12-05', '1764932489', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (892, 'Tripay', '481605-251201446', 'INDOMARET', '', '540', '105020273', '251201446', 'T46460289339706HUNM', 'https://tripay.co.id/checkout/T46460289339706HUNM', '1764931568', '2025-12-05', '1764932587', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (893, 'Tripay', '388500-251201334', 'MANDIRIVA', '', '419', '105010162', '251201334', 'T4646028934013PTBWT', 'https://tripay.co.id/checkout/T4646028934013PTBWT', '1764931628', '2025-12-05', '1764935348', '', 'PAID', '127125', '1764931700', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (894, 'Tripay', '258635-251201592', 'QRIS', '', '694', '105010249', '251201592', 'T4646028934088JAAII', 'https://tripay.co.id/checkout/T4646028934088JAAII', '1764931715', '2025-12-05', '1764932434', '', 'PAID', '125812', '1764931771', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (895, 'Tripay', '725616-251201234', 'INDOMARET', '', '309', '105020175', '251201234', 'T4646028934160EIXNX', 'https://tripay.co.id/checkout/T4646028934160EIXNX', '1764931832', '2025-12-05', '1764932852', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (896, 'Tripay', '462846-251201104', 'ALFAMART', '', '151', '105010054', '251201104', 'T4646028934457RYYNA', 'https://tripay.co.id/checkout/T4646028934457RYYNA', '1764932345', '2025-12-05', '1764936065', '', 'PAID', '126750', '1764932887', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (897, 'Tripay', '972290-251201429', 'SHOPEEPAY', '', '522', '105030057', '251201429', 'T4646028934523EAKHI', 'https://tripay.co.id/checkout/T4646028934523EAKHI', '1764932452', '2025-12-05', '1764933468', '', 'PAID', '167475', '1764932474', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (898, 'Tripay', '380244-251201300', 'BRIVA', '', '379', '105020207', '251201300', 'T46460289345436QQ9O', 'https://tripay.co.id/checkout/T46460289345436QQ9O', '1764932486', '2025-12-05', '1764936198', '', 'PAID', '127125', '1764932556', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (899, 'Tripay', '5618-251201667', 'INDOMARET', '', '770', '105010279', '251201667', 'T4646028934656PVKWW', 'https://tripay.co.id/checkout/T4646028934656PVKWW', '1764932682', '2025-12-05', '1764933702', '', 'PAID', '126750', '1764932811', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (900, 'Tripay', '918401-251201566', 'INDOMARET', '', '668', '105010238', '251201566', 'T4646028934696NCYTH', 'https://tripay.co.id/checkout/T4646028934696NCYTH', '1764932765', '2025-12-05', '1764933785', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (901, 'Tripay', '257313-251201347', 'INDOMARET', '', '434', '105050001', '251201347', 'T4646028934727QN4O1', 'https://tripay.co.id/checkout/T4646028934727QN4O1', '1764932822', '2025-12-05', '1764933842', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (902, 'Tripay', '943882-251201497', 'INDOMARET', '', '596', '105050023', '251201497', 'T4646028935685YF4OO', 'https://tripay.co.id/checkout/T4646028935685YF4OO', '1764934191', '2025-12-05', '1764935211', '', 'PAID', '126750', '1764934305', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (903, 'Tripay', '392504-251201548', 'BRIVA', '', '649', '105030080', '251201548', 'T4646028935824MQV6Q', 'https://tripay.co.id/checkout/T4646028935824MQV6Q', '1764934383', '2025-12-05', '1764938103', '', 'PAID', '127125', '1764934591', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (904, 'Tripay', '244984-251201749', 'QRIS2', '', '857', '105040008', '251201749', 'T4646028936110UATLK', 'https://tripay.co.id/checkout/T4646028936110UATLK', '1764934717', '2025-12-05', '1764935436', '', 'PAID', '63000', '1764934753', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (905, 'Tripay', '710616-251201566', 'INDOMARET', '', '668', '105010238', '251201566', 'T4646028936126X9WNA', 'https://tripay.co.id/checkout/T4646028936126X9WNA', '1764934750', '2025-12-05', '1764935769', '', 'PAID', '126750', '1764934910', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (906, 'Tripay', '192425-251201234', 'INDOMARET', '', '309', '105020175', '251201234', 'T4646028936426BTIN9', 'https://tripay.co.id/checkout/T4646028936426BTIN9', '1764935159', '2025-12-05', '1764936179', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (907, 'Tripay', '313968-251201347', 'MANDIRIVA', '', '434', '105050001', '251201347', 'T4646028936813IQ0HS', 'https://tripay.co.id/checkout/T4646028936813IQ0HS', '1764935595', '2025-12-05', '1764939314', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (908, 'Tripay', '197028-251201347', 'MANDIRIVA', '', '434', '105050001', '251201347', 'T4646028936851VPZYS', 'https://tripay.co.id/checkout/T4646028936851VPZYS', '1764935642', '2025-12-05', '1764939362', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (909, 'Tripay', '8471-251201404', 'ALFAMART', '', '497', '105010185', '251201404', 'T46460289368852MMEN', 'https://tripay.co.id/checkout/T46460289368852MMEN', '1764935686', '2025-12-05', '1764939406', '', 'PAID', '126750', '1764936531', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (910, 'Tripay', '87153-251201347', 'DANA', '', '434', '105050001', '251201347', 'T4646028936921Z2K9F', 'https://tripay.co.id/checkout/T4646028936921Z2K9F', '1764935731', '2025-12-05', '1764936751', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (911, 'Tripay', '354280-251201234', 'INDOMARET', '', '309', '105020175', '251201234', 'T46460289369508GNLP', 'https://tripay.co.id/checkout/T46460289369508GNLP', '1764935769', '2025-12-05', '1764936789', '', 'PAID', '126750', '1764935930', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (912, 'Tripay', '244982-251201347', 'MANDIRIVA', '', '434', '105050001', '251201347', 'T4646028936975HRFJG', 'https://tripay.co.id/checkout/T4646028936975HRFJG', '1764935797', '2025-12-05', '1764939516', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (913, 'Tripay', '25167-251201244', 'DANA', '', '319', '105010124', '251201244', 'T4646028937036XST9S', 'https://tripay.co.id/checkout/T4646028937036XST9S', '1764935887', '2025-12-05', '1764936905', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (914, 'Tripay', '97356-251201642', 'QRIS2', '', '745', '105050037', '251201642', 'T4646028937077REQBF', 'https://tripay.co.id/checkout/T4646028937077REQBF', '1764935964', '2025-12-05', '1764936684', '', 'PAID', '125000', '1764935982', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (915, 'Tripay', '579440-251201244', 'DANA', '', '319', '105010124', '251201244', 'T4646028937133FGQOI', 'https://tripay.co.id/checkout/T4646028937133FGQOI', '1764936023', '2025-12-05', '1764937042', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (916, 'Tripay', '107978-251201631', 'MANDIRIVA', '', '734', '105050030', '251201631', 'T4646028937490ZIYH0', 'https://tripay.co.id/checkout/T4646028937490ZIYH0', '1764936457', '2025-12-05', '1764940177', '', 'PAID', '127125', '1764936616', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (917, 'Tripay', '993145-251201177', 'INDOMARET', '', '242', '105010095', '251201177', 'T4646028938245NEZQD', 'https://tripay.co.id/checkout/T4646028938245NEZQD', '1764937459', '2025-12-05', '1764938478', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (918, 'Tripay', '54604-251201347', 'ALFAMART', '', '434', '105050001', '251201347', 'T4646028938274TI1X5', 'https://tripay.co.id/checkout/T4646028938274TI1X5', '1764937498', '2025-12-05', '1764941218', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (919, 'Tripay', '558165-251201210', 'BRIVA', '', '281', '105010105', '251201210', 'T4646028938321HXYII', 'https://tripay.co.id/checkout/T4646028938321HXYII', '1764937568', '2025-12-05', '1764941287', '', 'PAID', '127125', '1764938884', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (920, 'Tripay', '363176-251201752', 'BRIVA', '', '860', '105030101', '251201752', 'T4646028938536URS1D', 'https://tripay.co.id/checkout/T4646028938536URS1D', '1764937840', '2025-12-05', '1764941559', '', 'PAID', '57125', '1764938110', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (921, 'Tripay', '860128-251201317', 'QRIS2', '', '398', '105030034', '251201317', 'T4646028939039ZYL4D', 'https://tripay.co.id/checkout/T4646028939039ZYL4D', '1764938528', '2025-12-05', '1764939245', '', 'PAID', '165000', '1764938612', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (922, 'Tripay', '393161-251201210', 'BRIVA', '', '281', '105010105', '251201210', 'T4646028939190KPAHJ', 'https://tripay.co.id/checkout/T4646028939190KPAHJ', '1764938740', '2025-12-05', '1764942460', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (923, 'Tripay', '805255-251201394', 'INDOMARET', '', '487', '105020245', '251201394', 'T4646028939216Q1WYV', 'https://tripay.co.id/checkout/T4646028939216Q1WYV', '1764938786', '2025-12-05', '1764939805', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (924, 'Tripay', '882311-251201177', 'INDOMARET', '', '242', '105010095', '251201177', 'T46460289395337D76D', 'https://tripay.co.id/checkout/T46460289395337D76D', '1764939140', '2025-12-05', '1764940160', '', 'PAID', '126750', '1764939444', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (925, 'Tripay', '814325-251201630', 'INDOMARET', '', '733', '105050029', '251201630', 'T4646028939594XJSTO', 'https://tripay.co.id/checkout/T4646028939594XJSTO', '1764939211', '2025-12-05', '1764940231', '', 'PAID', '126750', '1764939766', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (926, 'Tripay', '124404-251201630', 'INDOMARET', '', '733', '105050029', '251201630', 'T4646028939744BSFJ0', 'https://tripay.co.id/checkout/T4646028939744BSFJ0', '1764939420', '2025-12-05', '1764940440', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (927, 'Tripay', '179349-251201394', 'INDOMARET', '', '487', '105020245', '251201394', 'T4646028940202FK61K', 'https://tripay.co.id/checkout/T4646028940202FK61K', '1764940068', '2025-12-05', '1764941088', '', 'PAID', '126750', '1764940249', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (928, 'Tripay', '968013-251201260', 'BRIVA', '', '336', '105020183', '251201260', 'T4646028940286XDZYS', 'https://tripay.co.id/checkout/T4646028940286XDZYS', '1764940191', '2025-12-05', '1764943911', '', 'PAID', '127125', '1764940339', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (929, 'Tripay', '782641-251201209', 'INDOMARET', '', '280', '105020162', '251201209', 'T4646028940336YJNU9', 'https://tripay.co.id/checkout/T4646028940336YJNU9', '1764940253', '2025-12-05', '1764941273', '', 'PAID', '126750', '1764940326', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (930, 'Tripay', '173891-251201016', 'MANDIRIVA', '', '27', '105020013', '251201016', 'T464602894044122008', 'https://tripay.co.id/checkout/T464602894044122008', '1764940372', '2025-12-05', '1764944082', '', 'PAID', '207125', '1764940434', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (931, 'Tripay', '595444-251201759', 'BRIVA', '', '867', '105020400', '251201759', 'T4646028940770A4RB7', 'https://tripay.co.id/checkout/T4646028940770A4RB7', '1764940866', '2025-12-05', '1764944585', '', 'PAID', '127125', '1764941356', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (932, 'Tripay', '156955-251201744', 'BNIVA', '', '852', '105010307', '251201744', 'T4646028940792R8I0L', 'https://tripay.co.id/checkout/T4646028940792R8I0L', '1764940894', '2025-12-05', '1764941913', '', 'PAID', '77125', '1764940971', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (933, 'Tripay', '157034-251201590', 'QRIS2', '', '692', '105020331', '251201590', 'T4646028940882A25ZM', 'https://tripay.co.id/checkout/T4646028940882A25ZM', '1764941040', '2025-12-05', '1764941760', '', 'PAID', '165000', '1764941083', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (934, 'Tripay', '494121-251201249', 'BRIVA', '', '324', '105030021', '251201249', 'T4646028941266WF3QB', 'https://tripay.co.id/checkout/T4646028941266WF3QB', '1764941600', '2025-12-05', '1764945320', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (935, 'Tripay', '85098-251201249', 'BRIVA', '', '324', '105030021', '251201249', 'T4646028941334EXF0Y', 'https://tripay.co.id/checkout/T4646028941334EXF0Y', '1764941704', '2025-12-05', '1764945416', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (936, 'Tripay', '427866-251201704', 'BCAVA', '', '809', '105020378', '251201704', 'T4646028941418TFHB3', 'https://tripay.co.id/checkout/T4646028941418TFHB3', '1764941836', '2025-12-05', '1764942855', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (937, 'Tripay', '896270-251201704', 'BCAVA', '', '809', '105020378', '251201704', 'T4646028941504NBL6L', 'https://tripay.co.id/checkout/T4646028941504NBL6L', '1764941984', '2025-12-05', '1764943003', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (938, 'Tripay', '363272-251201249', 'BRIVA', '', '324', '105030021', '251201249', 'T4646028941512KWBSS', 'https://tripay.co.id/checkout/T4646028941512KWBSS', '1764941993', '2025-12-05', '1764945713', '', 'PAID', '127125', '1764942060', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (939, 'Tripay', '988697-251201119', 'INDOMARET', '', '168', '105020107', '251201119', 'T4646028941520DCMXC', 'https://tripay.co.id/checkout/T4646028941520DCMXC', '1764942017', '2025-12-05', '1764943036', '', 'PAID', '126750', '1764942063', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (940, 'Tripay', '785587-251201261', 'DANA', '', '337', '105030025', '251201261', 'T4646028941588VDKSN', 'https://tripay.co.id/checkout/T4646028941588VDKSN', '1764942131', '2025-12-05', '1764943151', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (941, 'Tripay', '469910-251201704', 'BCAVA', '', '809', '105020378', '251201704', 'T4646028941624WKBTW', 'https://tripay.co.id/checkout/T4646028941624WKBTW', '1764942189', '2025-12-05', '1764943209', '', 'PAID', '127750', '1764942371', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (942, 'Tripay', '911673-251201105', 'QRIS2', '', '152', '105020098', '251201105', 'T4646028941737MREK1', 'https://tripay.co.id/checkout/T4646028941737MREK1', '1764942359', '2025-12-05', '1764943079', '', 'PAID', '125000', '1764942452', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (943, 'Tripay', '301223-251201261', 'DANA', '', '337', '105030025', '251201261', 'T4646028942139PVF6O', 'https://tripay.co.id/checkout/T4646028942139PVF6O', '1764943038', '2025-12-05', '1764944057', '', 'PAID', '125000', '1764943309', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (944, 'Tripay', '17136-251201268', 'BCAVA', '', '344', '105030026', '251201268', 'T4646028942328IEKI8', 'https://tripay.co.id/checkout/T4646028942328IEKI8', '1764943395', '2025-12-05', '1764944415', '', 'PAID', '127750', '1764943683', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (945, 'Tripay', '79411-251201398', 'BRIVA', '', '491', '105010182', '251201398', 'T4646028942556KZ5QB', 'https://tripay.co.id/checkout/T4646028942556KZ5QB', '1764943806', '2025-12-05', '1764947526', '', 'PAID', '127125', '1764943898', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (946, 'Tripay', '164145-251201283', 'QRIS', '', '361', '105020197', '251201283', 'T4646028942767EYMO5', 'https://tripay.co.id/checkout/T4646028942767EYMO5', '1764944188', '2025-12-05', '1764944907', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (947, 'Tripay', '313233-251201283', 'INDOMARET', '', '361', '105020197', '251201283', 'T4646028942881VUFIO', 'https://tripay.co.id/checkout/T4646028942881VUFIO', '1764944379', '2025-12-05', '1764945398', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (948, 'Tripay', '928318-251201283', 'QRIS2', '', '361', '105020197', '251201283', 'T46460289428937O8QW', 'https://tripay.co.id/checkout/T46460289428937O8QW', '1764944400', '2025-12-05', '1764945120', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (949, 'Tripay', '700886-251201115', 'INDOMARET', '', '164', '105020103', '251201115', 'T4646028943580VOY6I', 'https://tripay.co.id/checkout/T4646028943580VOY6I', '1764945715', '2025-12-05', '1764946735', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (950, 'Tripay', '428542-251201115', 'INDOMARET', '', '164', '105020103', '251201115', 'T4646028943594GFHQ9', 'https://tripay.co.id/checkout/T4646028943594GFHQ9', '1764945767', '2025-12-05', '1764946787', '', 'PAID', '166750', '1764946479', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (951, 'Tripay', '976628-251201277', 'INDOMARET', '', '355', '105020193', '251201277', 'T4646028943744DVUCG', 'https://tripay.co.id/checkout/T4646028943744DVUCG', '1764946065', '2025-12-05', '1764947085', '', 'PAID', '166750', '1764946184', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (952, 'Tripay', '908208-251201340', 'BNIVA', '', '427', '105020222', '251201340', 'T4646028944382FPWRV', 'https://tripay.co.id/checkout/T4646028944382FPWRV', '1764947616', '2025-12-05', '1764948629', '', 'PAID', '127125', '1764947996', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (953, 'Tripay', '391137-251201318', 'BRIVA', '', '399', '105020215', '251201318', 'T4646028944558BQEQ0', 'https://tripay.co.id/checkout/T4646028944558BQEQ0', '1764948103', '2025-12-05', '1764951822', '', 'PAID', '127125', '1764948149', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (954, 'Tripay', '541980-251201671', 'BCAVA', '', '774', '105020365', '251201671', 'T4646028945301CLAWV', 'https://tripay.co.id/checkout/T4646028945301CLAWV', '1764950234', '2025-12-05', '1764951253', '', 'PAID', '127750', '1764950413', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (955, 'Tripay', '634878-251201283', 'QRIS2', '', '361', '105020197', '251201283', 'T46460289453298IYF6', 'https://tripay.co.id/checkout/T46460289453298IYF6', '1764950321', '2025-12-05', '1764951040', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (956, 'Tripay', '98365-251201283', 'QRIS2', '', '361', '105020197', '251201283', 'T4646028945594IB925', 'https://tripay.co.id/checkout/T4646028945594IB925', '1764951316', '2025-12-05', '1764952035', '', 'PAID', '125000', '1764951338', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (957, 'Tripay', '755829-251201582', 'SHOPEEPAY', '', '684', '105010244', '251201582', 'T4646028945726YN2GD', 'https://tripay.co.id/checkout/T4646028945726YN2GD', '1764951879', '2025-12-05', '1764952899', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (958, 'Tripay', '586485-251201582', 'SHOPEEPAY', '', '684', '105010244', '251201582', 'T46460289458287SGPN', 'https://tripay.co.id/checkout/T46460289458287SGPN', '1764952270', '2025-12-05', '1764953289', '', 'PAID', '126875', '1764952330', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (959, 'Tripay', '329732-251201629', 'DANA', '', '732', '105010267', '251201629', 'T46460289478253H13F', 'https://tripay.co.id/checkout/T46460289478253H13F', '1764969568', '2025-12-06', '1764970587', '', 'PAID', '125000', '1764969604', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (960, 'Tripay', '581640-251201367', 'BNIVA', '', '456', '105020231', '251201367', 'T46460289483542FCWJ', 'https://tripay.co.id/checkout/T46460289483542FCWJ', '1764973540', '2025-12-06', '1764974553', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (961, 'Tripay', '324650-251201367', 'BRIVA', '', '456', '105020231', '251201367', 'T4646028948442MVCEH', 'https://tripay.co.id/checkout/T4646028948442MVCEH', '1764973913', '2025-12-06', '1764977632', '', 'PAID', '127125', '1764974025', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (962, 'Tripay', '59516-251201459', 'BNIVA', '', '554', '105010198', '251201459', 'T4646028948591YJUQX', 'https://tripay.co.id/checkout/T4646028948591YJUQX', '1764974525', '2025-12-06', '1764975538', '', 'UNPAID', '207125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (963, 'Tripay', '244493-251201459', 'BNIVA', '', '554', '105010198', '251201459', 'T4646028948607DISGK', 'https://tripay.co.id/checkout/T4646028948607DISGK', '1764974577', '2025-12-06', '1764975597', '', 'PAID', '207125', '1764974687', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (964, 'Tripay', '390529-251201399', 'BNIVA', '', '492', '105010183', '251201399', 'T4646028948876V6PW6', 'https://tripay.co.id/checkout/T4646028948876V6PW6', '1764975576', '2025-12-06', '1764976595', '', 'PAID', '127125', '1764975724', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (965, 'Tripay', '866040-251201251', 'INDOMARET', '', '326', '105030022', '251201251', 'T4646028949144PIMTW', 'https://tripay.co.id/checkout/T4646028949144PIMTW', '1764976567', '2025-12-06', '1764977587', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (966, 'Tripay', '604607-251201094', 'ALFAMART', '', '140', '105020089', '251201094', 'T4646028949680K8MWN', 'https://tripay.co.id/checkout/T4646028949680K8MWN', '1764978165', '2025-12-06', '1764981884', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (967, 'Tripay', '696965-251201512', 'BRIVA', '', '613', '105030072', '251201512', 'T4646028950592EOCCA', 'https://tripay.co.id/checkout/T4646028950592EOCCA', '1764980476', '2025-12-06', '1764984188', '', 'PAID', '127125', '1764980627', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (968, 'Tripay', '829116-251201163', 'SHOPEEPAY', '', '224', '105010089', '251201163', 'T4646028950805JPVS3', 'https://tripay.co.id/checkout/T4646028950805JPVS3', '1764980955', '2025-12-06', '1764981975', '', 'PAID', '126875', '1764980993', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (969, 'Tripay', '301939-251201485', 'DANA', '', '584', '105010205', '251201485', 'T46460289511354B9I3', 'https://tripay.co.id/checkout/T46460289511354B9I3', '1764981655', '2025-12-06', '1764982675', '', 'PAID', '125000', '1764981682', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (970, 'Tripay', '386335-251201442', 'MANDIRIVA', '', '535', '105020271', '251201442', 'T4646028953511HBIEB', 'https://tripay.co.id/checkout/T4646028953511HBIEB', '1764986802', '2025-12-06', '1764990513', '', 'PAID', '127125', '1764987196', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (971, 'Tripay', '798747-251201730', 'INDOMARET', '', '838', '105020389', '251201730', 'T46460289539429NKFQ', 'https://tripay.co.id/checkout/T46460289539429NKFQ', '1764987730', '2025-12-06', '1764988749', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (972, 'Tripay', '260153-251201478', 'DANA', '', '576', '105020286', '251201478', 'T4646028954397MDMDJ', 'https://tripay.co.id/checkout/T4646028954397MDMDJ', '1764988713', '2025-12-06', '1764989732', '', 'PAID', '125000', '1764988754', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (973, 'Tripay', '697453-251201008', 'ALFAMART', '', '10', '105010004', '251201008', 'T4646028954765DFMP7', 'https://tripay.co.id/checkout/T4646028954765DFMP7', '1764989412', '2025-12-06', '1764993132', '', 'PAID', '166750', '1764991319', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (974, 'Tripay', '643209-251201594', 'ALFAMART', '', '696', '105020333', '251201594', 'T46460289547826N1HT', 'https://tripay.co.id/checkout/T46460289547826N1HT', '1764989459', '2025-12-06', '1764993178', '', 'PAID', '126750', '1764989488', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (975, 'Tripay', '93829-251201730', 'INDOMARET', '', '838', '105020389', '251201730', 'T4646028954813YUDXA', 'https://tripay.co.id/checkout/T4646028954813YUDXA', '1764989526', '2025-12-06', '1764990546', '', 'PAID', '126750', '1764989898', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (976, 'Tripay', '231153-251201605', 'MANDIRIVA', '', '707', '105010255', '251201605', 'T4646028954831JEVRO', 'https://tripay.co.id/checkout/T4646028954831JEVRO', '1764989565', '2025-12-06', '1764993285', '', 'PAID', '127125', '1764989652', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (977, 'Tripay', '162245-251201508', 'BNIVA', '', '608', '105010213', '251201508', 'T4646028955177W0R47', 'https://tripay.co.id/checkout/T4646028955177W0R47', '1764990408', '2025-12-06', '1764991420', '', 'PAID', '167125', '1764990457', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (978, 'Tripay', '842270-251201206', 'INDOMARET', '', '276', '105030014', '251201206', 'T4646028955420BIFFZ', 'https://tripay.co.id/checkout/T4646028955420BIFFZ', '1764990933', '2025-12-06', '1764991953', '', 'PAID', '126750', '1764990999', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (979, 'Tripay', '328917-251201008', 'ALFAMART', '', '10', '105010004', '251201008', 'T4646028955573Y3JFE', 'https://tripay.co.id/checkout/T4646028955573Y3JFE', '1764991188', '2025-12-06', '1764994908', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (980, 'Tripay', '631781-251201492', 'QRIS2', '', '591', '105030070', '251201492', 'T4646028955614WPCZA', 'https://tripay.co.id/checkout/T4646028955614WPCZA', '1764991295', '2025-12-06', '1764992014', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (981, 'Tripay', '593861-251201480', 'ALFAMART', '', '578', '105010202', '251201480', 'T4646028955643MDGKT', 'https://tripay.co.id/checkout/T4646028955643MDGKT', '1764991361', '2025-12-06', '1764995081', '', 'PAID', '126750', '1764992067', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (982, 'Tripay', '553583-251201494', 'ALFAMART', '', '593', '105010208', '251201494', 'T4646028955704GDVGP', 'https://tripay.co.id/checkout/T4646028955704GDVGP', '1764991476', '2025-12-06', '1764995196', '', 'PAID', '126750', '1764992120', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (983, 'Tripay', '191397-251201280', 'BRIVA', '', '358', '105030029', '251201280', 'T4646028955706VFAKS', 'https://tripay.co.id/checkout/T4646028955706VFAKS', '1764991482', '2025-12-06', '1764995194', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (984, 'Tripay', '539660-251201375', 'QRIS2', '', '466', '105020236', '251201375', 'T4646028955762BIZZB', 'https://tripay.co.id/checkout/T4646028955762BIZZB', '1764991611', '2025-12-06', '1764992331', '', 'PAID', '125000', '1764991671', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (985, 'Tripay', '532509-251201726', 'QRIS2', '', '834', '105020388', '251201726', 'T46460289562160YPNQ', 'https://tripay.co.id/checkout/T46460289562160YPNQ', '1764992670', '2025-12-06', '1764993389', '', 'PAID', '125000', '1764992708', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (986, 'Tripay', '18149-251201756', 'ALFAMIDI', '', '864', '105010313', '251201756', 'T4646028956273CJV8O', 'https://tripay.co.id/checkout/T4646028956273CJV8O', '1764992786', '2025-12-06', '1764996505', '', 'UNPAID', '43750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (987, 'Tripay', '796756-251201446', 'INDOMARET', '', '540', '105020273', '251201446', 'T4646028956491NFMSJ', 'https://tripay.co.id/checkout/T4646028956491NFMSJ', '1764993329', '2025-12-06', '1764994349', '', 'PAID', '126750', '1764993862', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (988, 'Tripay', '317849-251201256', 'INDOMARET', '', '332', '105010128', '251201256', 'T4646028956720KAGSV', 'https://tripay.co.id/checkout/T4646028956720KAGSV', '1764993788', '2025-12-06', '1764994808', '', 'PAID', '126750', '1764994750', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (989, 'Tripay', '502855-251201236', 'BCAVA', '', '311', '105010119', '251201236', 'T4646028956875LHZPK', 'https://tripay.co.id/checkout/T4646028956875LHZPK', '1764994102', '2025-12-06', '1764995121', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (990, 'Tripay', '624764-251201536', 'INDOMARET', '', '637', '105020310', '251201536', 'T464602895724812KHO', 'https://tripay.co.id/checkout/T464602895724812KHO', '1764994845', '2025-12-06', '1764995865', '', 'PAID', '126750', '1764995046', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (991, 'Tripay', '595730-251201076', 'QRIS2', '', '118', '105020072', '251201076', 'T4646028957444VTGMC', 'https://tripay.co.id/checkout/T4646028957444VTGMC', '1764995282', '2025-12-06', '1764996002', '', 'PAID', '135000', '1764995402', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (992, 'Tripay', '965716-251201316', 'INDOMARET', '', '397', '105020214', '251201316', 'T4646028957686ACZCJ', 'https://tripay.co.id/checkout/T4646028957686ACZCJ', '1764995736', '2025-12-06', '1764996756', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (993, 'Tripay', '904490-251201543', 'BCAVA', '', '644', '105020315', '251201543', 'T4646028957785TA4Z4', 'https://tripay.co.id/checkout/T4646028957785TA4Z4', '1764995910', '2025-12-06', '1764996930', '', 'PAID', '127750', '1764996009', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (994, 'Tripay', '373564-251201537', 'BRIVA', '', '638', '105020311', '251201537', 'T4646028959095WGPGZ', 'https://tripay.co.id/checkout/T4646028959095WGPGZ', '1764998621', '2025-12-06', '1765002333', '', 'PAID', '127125', '1764998673', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (995, 'Tripay', '191560-251201691', 'QRIS2', '', '794', '105020371', '251201691', 'T4646028959321UOXJF', 'https://tripay.co.id/checkout/T4646028959321UOXJF', '1764999089', '2025-12-06', '1764999807', '', 'PAID', '125000', '1764999191', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (996, 'Tripay', '308821-251201579', 'INDOMARET', '', '681', '105020327', '251201579', 'T4646028961022AE2GJ', 'https://tripay.co.id/checkout/T4646028961022AE2GJ', '1765003098', '2025-12-06', '1765004118', '', 'PAID', '166750', '1765003317', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (997, 'Tripay', '819762-251201135', 'DANA', '', '189', '105010070', '251201135', 'T4646028961229ZLWLY', 'https://tripay.co.id/checkout/T4646028961229ZLWLY', '1765003610', '2025-12-06', '1765004629', '', 'PAID', '125000', '1765003624', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (998, 'Tripay', '786757-251201674', 'BRIVA', '', '777', '105030090', '251201674', 'T4646028961908T1WWN', 'https://tripay.co.id/checkout/T4646028961908T1WWN', '1765005294', '2025-12-06', '1765009006', '', 'PAID', '127125', '1765005352', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (999, 'Tripay', '255594-251201357', 'BCAVA', '', '445', '105020227', '251201357', 'T4646028962162GL98C', 'https://tripay.co.id/checkout/T4646028962162GL98C', '1765006060', '2025-12-06', '1765007080', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1000, 'Tripay', '497692-251201482', 'QRIS2', '', '581', '105020288', '251201482', 'T4646028962165GIVH5', 'https://tripay.co.id/checkout/T4646028962165GIVH5', '1765006064', '2025-12-06', '1765006784', '', 'PAID', '125000', '1765006093', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1001, 'Tripay', '808085-251201199', 'MANDIRIVA', '', '268', '105020160', '251201199', 'T4646028962564OXWTA', 'https://tripay.co.id/checkout/T4646028962564OXWTA', '1765007128', '2025-12-06', '1765010847', '', 'PAID', '167125', '1765007224', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1002, 'Tripay', '745391-251202009', 'INDOMARET', '', '196', '105020124', '251202009', 'T4646028962651DKJQ3', 'https://tripay.co.id/checkout/T4646028962651DKJQ3', '1765007382', '2025-12-06', '1765008402', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1003, 'Tripay', '968407-251202009', 'ALFAMART', '', '196', '105020124', '251202009', 'T4646028962700HS0DO', 'https://tripay.co.id/checkout/T4646028962700HS0DO', '1765007535', '2025-12-06', '1765011255', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1004, 'Tripay', '224330-251201706', 'BCAVA', '', '811', '105010292', '251201706', 'T4646028963192OXGG9', 'https://tripay.co.id/checkout/T4646028963192OXGG9', '1765008896', '2025-12-06', '1765009916', '', 'PAID', '127750', '1765008944', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1005, 'Tripay', '416104-251201072', 'MANDIRIVA', '', '111', '105020067', '251201072', 'T4646028963341DW7JW', 'https://tripay.co.id/checkout/T4646028963341DW7JW', '1765009285', '2025-12-06', '1765012997', '', 'PAID', '137125', '1765009458', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1006, 'Tripay', '173205-251201515', 'INDOMARET', '', '616', '105010217', '251201515', 'T4646028963502ZJV6W', 'https://tripay.co.id/checkout/T4646028963502ZJV6W', '1765009745', '2025-12-06', '1765010764', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1007, 'Tripay', '315028-251201676', 'ALFAMART', '', '779', '105010282', '251201676', 'T4646028963538ERC8W', 'https://tripay.co.id/checkout/T4646028963538ERC8W', '1765009820', '2025-12-06', '1765013539', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1008, 'Tripay', '786514-251201615', 'BRIVA', '', '717', '105010261', '251201615', 'T4646028963710OQQF5', 'https://tripay.co.id/checkout/T4646028963710OQQF5', '1765010263', '2025-12-06', '1765013975', '', 'PAID', '127125', '1765010404', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1009, 'Tripay', '641287-251201518', 'BCAVA', '', '619', '105010220', '251201518', 'T4646028964115HITLC', 'https://tripay.co.id/checkout/T4646028964115HITLC', '1765011371', '2025-12-06', '1765012391', '', 'PAID', '127750', '1765011781', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1010, 'Tripay', '500482-251201070', 'MANDIRIVA', '', '107', '105010044', '251201070', 'T4646028964363LWHXN', 'https://tripay.co.id/checkout/T4646028964363LWHXN', '1765011941', '2025-12-06', '1765015653', '', 'UNPAID', '117125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1011, 'Tripay', '736510-251201047', 'BRIVA', '', '74', '105020043', '251201047', 'T4646028964379IDVF0', 'https://tripay.co.id/checkout/T4646028964379IDVF0', '1765011967', '2025-12-06', '1765015687', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1012, 'Tripay', '959389-251201047', 'SHOPEEPAY', '', '74', '105020043', '251201047', 'T4646028964397ADSG0', 'https://tripay.co.id/checkout/T4646028964397ADSG0', '1765012054', '2025-12-06', '1765013073', '', 'UNPAID', '167475', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1013, 'Tripay', '103038-251201514', 'INDOMARET', '', '615', '105010216', '251201514', 'T46460289645277DEVB', 'https://tripay.co.id/checkout/T46460289645277DEVB', '1765012456', '2025-12-06', '1765013475', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1014, 'Tripay', '484163-251201455', 'BSIVA', '', '550', '105050015', '251201455', 'T4646028964555UMTLN', 'https://tripay.co.id/checkout/T4646028964555UMTLN', '1765012530', '2025-12-06', '1765016250', '', 'PAID', '127125', '1765012777', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1015, 'Tripay', '647767-251201682', 'BNIVA', '', '785', '105040003', '251201682', 'T4646028964595IEDSK', 'https://tripay.co.id/checkout/T4646028964595IEDSK', '1765012603', '2025-12-06', '1765013616', '', 'PAID', '127125', '1765012671', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1016, 'Tripay', '81200-251201495', 'BCAVA', '', '594', '105020293', '251201495', 'T46460289647993JYUH', 'https://tripay.co.id/checkout/T46460289647993JYUH', '1765013149', '2025-12-06', '1765014169', '', 'PAID', '127750', '1765013196', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1017, 'Tripay', '417367-251201085', 'BRIVA', '', '130', '105020081', '251201085', 'T4646028964828MUW8C', 'https://tripay.co.id/checkout/T4646028964828MUW8C', '1765013216', '2025-12-06', '1765016929', '', 'PAID', '127125', '1765013318', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1018, 'Tripay', '620729-251201602', 'DANA', '', '704', '105020336', '251201602', 'T4646028964864W9QP0', 'https://tripay.co.id/checkout/T4646028964864W9QP0', '1765013325', '2025-12-06', '1765014345', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1019, 'Tripay', '140956-251201084', 'BRIVA', '', '128', '105020079', '251201084', 'T4646028964974S2YZC', 'https://tripay.co.id/checkout/T4646028964974S2YZC', '1765013589', '2025-12-06', '1765017309', '', 'PAID', '127125', '1765013643', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1020, 'Tripay', '918973-251201189', 'QRIS', '', '254', '105030001', '251201189', 'T4646028965059NTFBI', 'https://tripay.co.id/checkout/T4646028965059NTFBI', '1765013796', '2025-12-06', '1765014515', '', 'PAID', '125812', '1765013830', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1021, 'Tripay', '805241-251201756', 'INDOMARET', '', '864', '105010313', '251201756', 'T4646028965069R9TDW', 'https://tripay.co.id/checkout/T4646028965069R9TDW', '1765013829', '2025-12-06', '1765014849', '', 'UNPAID', '43750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1022, 'Tripay', '522052-251201621', 'BNIVA', '', '724', '105010264', '251201621', 'T4646028965078PKUL9', 'https://tripay.co.id/checkout/T4646028965078PKUL9', '1765013850', '2025-12-06', '1765014863', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1023, 'Tripay', '707231-251201190', 'QRIS', '', '255', '105030002', '251201190', 'T4646028965115ODRXU', 'https://tripay.co.id/checkout/T4646028965115ODRXU', '1765013923', '2025-12-06', '1765014642', '', 'PAID', '125812', '1765013943', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1024, 'Tripay', '713298-251201756', 'INDOMARET', '', '864', '105010313', '251201756', 'T4646028965360MZ1GF', 'https://tripay.co.id/checkout/T4646028965360MZ1GF', '1765014519', '2025-12-06', '1765015538', '', 'PAID', '43750', '1765014559', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1025, 'Tripay', '329238-251201481', 'INDOMARET', '', '580', '105010203', '251201481', 'T4646028965494TAMYE', 'https://tripay.co.id/checkout/T4646028965494TAMYE', '1765014883', '2025-12-06', '1765015903', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1026, 'Tripay', '610655-251201456', 'ALFAMART', '', '551', '105050016', '251201456', 'T46460289656281FHID', 'https://tripay.co.id/checkout/T46460289656281FHID', '1765015210', '2025-12-06', '1765018930', '', 'PAID', '126750', '1765016291', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1027, 'Tripay', '428308-251201770', 'MANDIRIVA', '', '878', '10520002', '251201770', 'T4646028965723UIPOW', 'https://tripay.co.id/checkout/T4646028965723UIPOW', '1765015443', '2025-12-06', '1765019162', '', 'UNPAID', '27125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1028, 'Tripay', '820464-251201770', 'MANDIRIVA', '', '878', '10520002', '251201770', 'T4646028965784BN0J5', 'https://tripay.co.id/checkout/T4646028965784BN0J5', '1765015593', '2025-12-06', '1765019305', '', 'UNPAID', '27125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1029, 'Tripay', '702629-251201128', 'INDOMARET', '', '177', '105010065', '251201128', 'T4646028965838EXHBT', 'https://tripay.co.id/checkout/T4646028965838EXHBT', '1765015706', '2025-12-06', '1765016726', '', 'PAID', '126750', '1765015805', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1030, 'Tripay', '478336-251201012', 'QRIS2', '', '19', '105020009', '251201012', 'T4646028966104KL8B9', 'https://tripay.co.id/checkout/T4646028966104KL8B9', '1765016196', '2025-12-06', '1765016915', '', 'PAID', '205000', '1765016312', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1031, 'Tripay', '115443-251201770', 'SHOPEEPAY', '', '878', '10520002', '251201770', 'T4646028966185GU4DD', 'https://tripay.co.id/checkout/T4646028966185GU4DD', '1765016317', '2025-12-06', '1765017337', '', 'PAID', '25500', '1765016342', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1032, 'Tripay', '668458-251201359', 'DANA', '', '447', '105020228', '251201359', 'T4646028966195HFVMV', 'https://tripay.co.id/checkout/T4646028966195HFVMV', '1765016335', '2025-12-06', '1765017354', '', 'PAID', '165000', '1765016368', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1033, 'Tripay', '818645-251201039', 'INDOMARET', '', '60', '105010025', '251201039', 'T4646028966430H7XW0', 'https://tripay.co.id/checkout/T4646028966430H7XW0', '1765016860', '2025-12-06', '1765017880', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1034, 'Tripay', '450154-251201664', 'BCAVA', '', '767', '105020362', '251201664', 'T4646028966546BKMSZ', 'https://tripay.co.id/checkout/T4646028966546BKMSZ', '1765017154', '2025-12-06', '1765018173', '', 'PAID', '127750', '1765017230', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1035, 'Tripay', '534643-251201236', 'ALFAMART', '', '311', '105010119', '251201236', 'T4646028966562V17XH', 'https://tripay.co.id/checkout/T4646028966562V17XH', '1765017187', '2025-12-06', '1765020907', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1036, 'Tripay', '993940-251201454', 'DANA', '', '549', '105050014', '251201454', 'T46460289666414A5HC', 'https://tripay.co.id/checkout/T46460289666414A5HC', '1765017400', '2025-12-06', '1765018419', '', 'PAID', '125000', '1765017445', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1037, 'Tripay', '310394-251201236', 'BCAVA', '', '311', '105010119', '251201236', 'T4646028966739O4C52', 'https://tripay.co.id/checkout/T4646028966739O4C52', '1765017594', '2025-12-06', '1765018613', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1038, 'Tripay', '430129-251201602', 'DANA', '', '704', '105020336', '251201602', 'T4646028966801HL3U4', 'https://tripay.co.id/checkout/T4646028966801HL3U4', '1765017718', '2025-12-06', '1765018738', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1039, 'Tripay', '938817-251201236', 'BCAVA', '', '311', '105010119', '251201236', 'T4646028966864SIELD', 'https://tripay.co.id/checkout/T4646028966864SIELD', '1765017802', '2025-12-06', '1765018822', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1040, 'Tripay', '282170-251201192', 'BRIVA', '', '258', '105030005', '251201192', 'T4646028966869JJBTE', 'https://tripay.co.id/checkout/T4646028966869JJBTE', '1765017809', '2025-12-06', '1765021521', '', 'PAID', '127125', '1765018202', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1041, 'Tripay', '341699-251201583', 'QRIS2', '', '685', '105010245', '251201583', 'T4646028967047UXTZY', 'https://tripay.co.id/checkout/T4646028967047UXTZY', '1765018109', '2025-12-06', '1765018829', '', 'PAID', '125000', '1765018746', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1042, 'Tripay', '20291-251201583', 'QRIS2', '', '685', '105010245', '251201583', 'T4646028967079RMW6X', 'https://tripay.co.id/checkout/T4646028967079RMW6X', '1765018186', '2025-12-06', '1765018905', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1043, 'Tripay', '792278-251201662', 'MANDIRIVA', '', '765', '105020360', '251201662', 'T4646028967174IWWKW', 'https://tripay.co.id/checkout/T4646028967174IWWKW', '1765018395', '2025-12-06', '1765022115', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1044, 'Tripay', '256122-251201417', 'BCAVA', '', '510', '105010189', '251201417', 'T4646028967501SJTS2', 'https://tripay.co.id/checkout/T4646028967501SJTS2', '1765019005', '2025-12-06', '1765020025', '', 'PAID', '127750', '1765019050', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1045, 'Tripay', '508412-251201424', 'BCAVA', '', '517', '105020262', '251201424', 'T4646028967559OXEX9', 'https://tripay.co.id/checkout/T4646028967559OXEX9', '1765019118', '2025-12-06', '1765020138', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1046, 'Tripay', '977475-251201515', 'INDOMARET', '', '616', '105010217', '251201515', 'T4646028967814LFM6K', 'https://tripay.co.id/checkout/T4646028967814LFM6K', '1765019610', '2025-12-06', '1765020629', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1047, 'Tripay', '637197-251201515', 'ALFAMART', '', '616', '105010217', '251201515', 'T4646028967891E7E7K', 'https://tripay.co.id/checkout/T4646028967891E7E7K', '1765019784', '2025-12-06', '1765023504', '', 'PAID', '126750', '1765020512', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1048, 'Tripay', '379247-251201230', 'INDOMARET', '', '305', '105020171', '251201230', 'T4646028968072THAQH', 'https://tripay.co.id/checkout/T4646028968072THAQH', '1765020180', '2025-12-06', '1765021199', '', 'PAID', '126750', '1765020873', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1049, 'Tripay', '571709-251201236', 'INDOMARET', '', '311', '105010119', '251201236', 'T4646028968143WBF3H', 'https://tripay.co.id/checkout/T4646028968143WBF3H', '1765020318', '2025-12-06', '1765021337', '', 'PAID', '126750', '1765020624', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1050, 'Tripay', '67390-251201339', 'BNIVA', '', '426', '105030040', '251201339', 'T4646028968157LE1C8', 'https://tripay.co.id/checkout/T4646028968157LE1C8', '1765020350', '2025-12-06', '1765021363', '', 'PAID', '127125', '1765020500', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1051, 'Tripay', '648991-251201347', 'BRIVA', '', '434', '105050001', '251201347', 'T4646028968291A7RYY', 'https://tripay.co.id/checkout/T4646028968291A7RYY', '1765020595', '2025-12-06', '1765024315', '', 'PAID', '127125', '1765020646', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1052, 'Tripay', '233281-251201251', 'INDOMARET', '', '326', '105030022', '251201251', 'T464602896839011PXS', 'https://tripay.co.id/checkout/T464602896839011PXS', '1765020746', '2025-12-06', '1765021766', '', 'PAID', '126750', '1765021347', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1053, 'Tripay', '601532-251201039', 'INDOMARET', '', '60', '105010025', '251201039', 'T4646028968393WHXTV', 'https://tripay.co.id/checkout/T4646028968393WHXTV', '1765020753', '2025-12-06', '1765021773', '', 'PAID', '126750', '1765021468', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1054, 'Tripay', '87055-251201251', 'INDOMARET', '', '326', '105030022', '251201251', 'T4646028968411418BZ', 'https://tripay.co.id/checkout/T4646028968411418BZ', '1765020776', '2025-12-06', '1765021795', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1055, 'Tripay', '508930-251201024', 'ALFAMART', '', '40', '105020022', '251201024', 'T4646028968904ZRFXH', 'https://tripay.co.id/checkout/T4646028968904ZRFXH', '1765021632', '2025-12-06', '1765025352', '', 'PAID', '126750', '1765022496', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1056, 'Tripay', '922496-251201254', 'QRIS2', '', '329', '105010126', '251201254', 'T4646028969378GHEPY', 'https://tripay.co.id/checkout/T4646028969378GHEPY', '1765022469', '2025-12-06', '1765023188', '', 'PAID', '125000', '1765022567', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1057, 'Tripay', '107039-251201623', 'QRIS', '', '726', '105020345', '251201623', 'T4646028969570MMRKU', 'https://tripay.co.id/checkout/T4646028969570MMRKU', '1765022811', '2025-12-06', '1765023530', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1058, 'Tripay', '680746-251201602', 'DANA', '', '704', '105020336', '251201602', 'T4646028969662HEZG7', 'https://tripay.co.id/checkout/T4646028969662HEZG7', '1765022977', '2025-12-06', '1765023996', '', 'PAID', '125000', '1765023019', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1059, 'Tripay', '347040-251201154', 'INDOMARET', '', '215', '105010082', '251201154', 'T4646028970436FLSHM', 'https://tripay.co.id/checkout/T4646028970436FLSHM', '1765024328', '2025-12-06', '1765025348', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1060, 'Tripay', '337518-251201471', 'BNIVA', '', '569', '105050019', '251201471', 'T4646028970664XTKMI', 'https://tripay.co.id/checkout/T4646028970664XTKMI', '1765024803', '2025-12-06', '1765025816', '', 'UNPAID', '207125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1061, 'Tripay', '222987-251201471', 'BNIVA', '', '569', '105050019', '251201471', 'T4646028970737IE2H5', 'https://tripay.co.id/checkout/T4646028970737IE2H5', '1765024943', '2025-12-06', '1765025963', '', 'PAID', '207125', '1765025019', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1062, 'Tripay', '247928-251201159', 'SHOPEEPAY', '', '220', '105010086', '251201159', 'T4646028970760YF4E2', 'https://tripay.co.id/checkout/T4646028970760YF4E2', '1765024980', '2025-12-06', '1765026000', '', 'PAID', '126875', '1765025024', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1063, 'Tripay', '377601-251201743', 'INDOMARET', '', '851', '105030100', '251201743', 'T4646028970808IXL1C', 'https://tripay.co.id/checkout/T4646028970808IXL1C', '1765025086', '2025-12-06', '1765026106', '', 'UNPAID', '76750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1064, 'Tripay', '942877-251201743', 'INDOMARET', '', '851', '105030100', '251201743', 'T4646028970998RVTNE', 'https://tripay.co.id/checkout/T4646028970998RVTNE', '1765025414', '2025-12-06', '1765026433', '', 'PAID', '76750', '1765025494', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1065, 'Tripay', '687012-251201154', 'INDOMARET', '', '215', '105010082', '251201154', 'T4646028971400KCHPM', 'https://tripay.co.id/checkout/T4646028971400KCHPM', '1765026254', '2025-12-06', '1765027274', '', 'PAID', '126750', '1765026664', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1066, 'Tripay', '968929-251201632', 'INDOMARET', '', '735', '105050031', '251201632', 'T4646028971460NTKAF', 'https://tripay.co.id/checkout/T4646028971460NTKAF', '1765026376', '2025-12-06', '1765027396', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1067, 'Tripay', '84157-251201632', 'INDOMARET', '', '735', '105050031', '251201632', 'T4646028971608QATWI', 'https://tripay.co.id/checkout/T4646028971608QATWI', '1765026681', '2025-12-06', '1765027701', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1068, 'Tripay', '675758-251201247', 'INDOMARET', '', '322', '105010125', '251201247', 'T4646028971687M7U8G', 'https://tripay.co.id/checkout/T4646028971687M7U8G', '1765026854', '2025-12-06', '1765027874', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1069, 'Tripay', '150728-251201009', 'BCAVA', '', '14', '105010007', '251201009', 'T4646028971694LMVCW', 'https://tripay.co.id/checkout/T4646028971694LMVCW', '1765026878', '2025-12-06', '1765027897', '', 'PAID', '127750', '1765026928', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1070, 'Tripay', '163063-251201632', 'INDOMARET', '', '735', '105050031', '251201632', 'T46460289717874NVTE', 'https://tripay.co.id/checkout/T46460289717874NVTE', '1765027112', '2025-12-06', '1765028132', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1071, 'Tripay', '623751-251201632', 'INDOMARET', '', '735', '105050031', '251201632', 'T46460289718526VLL7', 'https://tripay.co.id/checkout/T46460289718526VLL7', '1765027269', '2025-12-06', '1765028288', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1072, 'Tripay', '668800-251201632', 'INDOMARET', '', '735', '105050031', '251201632', 'T4646028971929PX67Y', 'https://tripay.co.id/checkout/T4646028971929PX67Y', '1765027443', '2025-12-06', '1765028463', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1073, 'Tripay', '505907-251201632', 'INDOMARET', '', '735', '105050031', '251201632', 'T4646028971986AMMSK', 'https://tripay.co.id/checkout/T4646028971986AMMSK', '1765027567', '2025-12-06', '1765028587', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1074, 'Tripay', '938844-251201632', 'INDOMARET', '', '735', '105050031', '251201632', 'T4646028972144UBMKI', 'https://tripay.co.id/checkout/T4646028972144UBMKI', '1765027883', '2025-12-06', '1765028903', '', 'PAID', '126750', '1765028394', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1075, 'Tripay', '813347-251201396', 'MANDIRIVA', '', '489', '105030051', '251201396', 'T4646028972413JEUKE', 'https://tripay.co.id/checkout/T4646028972413JEUKE', '1765028440', '2025-12-06', '1765032160', '', 'PAID', '127125', '1765028547', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1076, 'Tripay', '398104-251201316', 'INDOMARET', '', '397', '105020214', '251201316', 'T4646028972416WQHBO', 'https://tripay.co.id/checkout/T4646028972416WQHBO', '1765028443', '2025-12-06', '1765029463', '', 'PAID', '166750', '1765028516', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1077, 'Tripay', '797441-251201357', 'BCAVA', '', '445', '105020227', '251201357', 'T4646028972550CI1KQ', 'https://tripay.co.id/checkout/T4646028972550CI1KQ', '1765028716', '2025-12-06', '1765029736', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1078, 'Tripay', '518433-251201247', 'INDOMARET', '', '322', '105010125', '251201247', 'T4646028973199ARKC1', 'https://tripay.co.id/checkout/T4646028973199ARKC1', '1765030064', '2025-12-06', '1765031083', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1079, 'Tripay', '706309-251201247', 'INDOMARET', '', '322', '105010125', '251201247', 'T4646028973437R0KKG', 'https://tripay.co.id/checkout/T4646028973437R0KKG', '1765030650', '2025-12-06', '1765031670', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1080, 'Tripay', '267156-251201247', 'INDOMARET', '', '322', '105010125', '251201247', 'T4646028973480OVGBL', 'https://tripay.co.id/checkout/T4646028973480OVGBL', '1765030759', '2025-12-06', '1765031779', '', 'PAID', '126750', '1765031410', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1081, 'Tripay', '934067-251201330', 'BCAVA', '', '414', '105030037', '251201330', 'T4646028982942V9NC7', 'https://tripay.co.id/checkout/T4646028982942V9NC7', '1765063649', '2025-12-07', '1765064669', '', 'PAID', '127750', '1765063746', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1082, 'Tripay', '654223-251201748', 'BRIVA', '', '856', '105010309', '251201748', 'T4646028983632FTBAX', 'https://tripay.co.id/checkout/T4646028983632FTBAX', '1765066485', '2025-12-07', '1765070196', '', 'PAID', '73125', '1765066705', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1083, 'Tripay', '622787-251201351', 'BRIVA', '', '438', '105050005', '251201351', 'T4646028984642C3EN0', 'https://tripay.co.id/checkout/T4646028984642C3EN0', '1765069722', '2025-12-07', '1765073434', '', 'PAID', '127125', '1765069756', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1084, 'Tripay', '291868-251201325', 'MANDIRIVA', '', '407', '105010155', '251201325', 'T4646028984729G60VI', 'https://tripay.co.id/checkout/T4646028984729G60VI', '1765069952', '2025-12-07', '1765073671', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1085, 'Tripay', '295928-251201325', 'MANDIRIVA', '', '407', '105010155', '251201325', 'T4646028984785YZV5X', 'https://tripay.co.id/checkout/T4646028984785YZV5X', '1765070098', '2025-12-07', '1765073817', '', 'PAID', '127125', '1765070154', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1086, 'Tripay', '600171-251201094', 'ALFAMART', '', '140', '105020089', '251201094', 'T46460289854844VROZ', 'https://tripay.co.id/checkout/T46460289854844VROZ', '1765072001', '2025-12-07', '1765075721', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1087, 'Tripay', '60741-251201387', 'QRIS2', '', '479', '105010179', '251201387', 'T4646028985641RZWOT', 'https://tripay.co.id/checkout/T4646028985641RZWOT', '1765072421', '2025-12-07', '1765073141', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1088, 'Tripay', '658677-251201387', 'ALFAMART', '', '479', '105010179', '251201387', 'T4646028985713TVUIA', 'https://tripay.co.id/checkout/T4646028985713TVUIA', '1765072582', '2025-12-07', '1765076301', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1089, 'Tripay', '350425-251201503', 'INDOMARET', '', '602', '105010209', '251201503', 'T4646028985794YANMT', 'https://tripay.co.id/checkout/T4646028985794YANMT', '1765072830', '2025-12-07', '1765073850', '', 'PAID', '126750', '1765073464', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1090, 'Tripay', '612891-251201094', 'BRIVA', '', '140', '105020089', '251201094', 'T4646028986155NEI86', 'https://tripay.co.id/checkout/T4646028986155NEI86', '1765073717', '2025-12-07', '1765077429', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1091, 'Tripay', '332559-251201303', 'INDOMARET', '', '382', '105010142', '251201303', 'T4646028986215ZRMGC', 'https://tripay.co.id/checkout/T4646028986215ZRMGC', '1765073856', '2025-12-07', '1765074875', '', 'PAID', '126750', '1765074386', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1092, 'Tripay', '242430-251201174', 'QRIS2', '', '239', '105020146', '251201174', 'T4646028986800Y6KV6', 'https://tripay.co.id/checkout/T4646028986800Y6KV6', '1765075518', '2025-12-07', '1765076238', '', 'PAID', '125000', '1765075535', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1093, 'Tripay', '702228-251201387', 'ALFAMART', '', '479', '105010179', '251201387', 'T4646028987384JFXGA', 'https://tripay.co.id/checkout/T4646028987384JFXGA', '1765077033', '2025-12-07', '1765080752', '', 'PAID', '126750', '1765077066', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1094, 'Tripay', '127392-251201346', 'ALFAMART', '', '433', '105020225', '251201346', 'T4646028987928HYY5L', 'https://tripay.co.id/checkout/T4646028987928HYY5L', '1765078586', '2025-12-07', '1765082306', '', 'PAID', '126750', '1765079008', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1095, 'Tripay', '175752-251201094', 'BRIVA', '', '140', '105020089', '251201094', 'T4646028988013UJNSA', 'https://tripay.co.id/checkout/T4646028988013UJNSA', '1765078819', '2025-12-07', '1765082539', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1096, 'Tripay', '21430-251201094', 'ALFAMART', '', '140', '105020089', '251201094', 'T4646028988015X68YJ', 'https://tripay.co.id/checkout/T4646028988015X68YJ', '1765078831', '2025-12-07', '1765082551', '', 'PAID', '126750', '1765079169', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1097, 'Tripay', '694318-251201657', 'BRIVA', '', '760', '105010274', '251201657', 'T4646028988140V8N3S', 'https://tripay.co.id/checkout/T4646028988140V8N3S', '1765079126', '2025-12-07', '1765082846', '', 'PAID', '127125', '1765079229', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1098, 'Tripay', '189977-251201481', 'INDOMARET', '', '580', '105010203', '251201481', 'T4646028989262Y2OKR', 'https://tripay.co.id/checkout/T4646028989262Y2OKR', '1765082286', '2025-12-07', '1765083306', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1099, 'Tripay', '139523-251201481', 'INDOMARET', '', '580', '105010203', '251201481', 'T46460289895232I5JH', 'https://tripay.co.id/checkout/T46460289895232I5JH', '1765083059', '2025-12-07', '1765084079', '', 'PAID', '126750', '1765083121', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1100, 'Tripay', '127526-251201293', 'INDOMARET', '', '371', '105010139', '251201293', 'T4646028991939NAZEP', 'https://tripay.co.id/checkout/T4646028991939NAZEP', '1765089351', '2025-12-07', '1765090370', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1101, 'Tripay', '977145-251201051', 'QRIS2', '', '82', '105020046', '251201051', 'T46460289925413U78F', 'https://tripay.co.id/checkout/T46460289925413U78F', '1765090991', '2025-12-07', '1765091711', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1102, 'Tripay', '834428-251201113', 'BCAVA', '', '162', '105020102', '251201113', 'T4646028993556UKLMT', 'https://tripay.co.id/checkout/T4646028993556UKLMT', '1765094071', '2025-12-07', '1765095091', '', 'PAID', '127750', '1765094124', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1103, 'Tripay', '618794-251201361', 'INDOMARET', '', '449', '105010168', '251201361', 'T4646028993695KZTLJ', 'https://tripay.co.id/checkout/T4646028993695KZTLJ', '1765094426', '2025-12-07', '1765095446', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1104, 'Tripay', '803720-251201509', 'INDOMARET', '', '610', '105020296', '251201509', 'T4646028994361MLONE', 'https://tripay.co.id/checkout/T4646028994361MLONE', '1765096546', '2025-12-07', '1765097566', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1105, 'Tripay', '109268-251201509', 'ALFAMIDI', '', '610', '105020296', '251201509', 'T4646028994641UV5MV', 'https://tripay.co.id/checkout/T4646028994641UV5MV', '1765097399', '2025-12-07', '1765101119', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1106, 'Tripay', '499405-251201025', 'ALFAMART', '', '41', '105020023', '251201025', 'T46460289949090OW2M', 'https://tripay.co.id/checkout/T46460289949090OW2M', '1765098167', '2025-12-07', '1765101887', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1107, 'Tripay', '122519-251201492', 'BRIVA', '', '591', '105030070', '251201492', 'T46460289949711JDIS', 'https://tripay.co.id/checkout/T46460289949711JDIS', '1765098360', '2025-12-07', '1765102073', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1108, 'Tripay', '139002-251201492', 'QRIS2', '', '591', '105030070', '251201492', 'T4646028995000G9JLP', 'https://tripay.co.id/checkout/T4646028995000G9JLP', '1765098448', '2025-12-07', '1765099167', '', 'PAID', '125000', '1765098514', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1109, 'Tripay', '33264-251201131', 'ALFAMIDI', '', '181', '105010066', '251201131', 'T4646028995316NWIUJ', 'https://tripay.co.id/checkout/T4646028995316NWIUJ', '1765099281', '2025-12-07', '1765103000', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1110, 'Tripay', '676359-251201509', 'BRIVA', '', '610', '105020296', '251201509', 'T4646028995808V8MA0', 'https://tripay.co.id/checkout/T4646028995808V8MA0', '1765100592', '2025-12-07', '1765104303', '', 'PAID', '127125', '1765100675', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1111, 'Tripay', '42873-251201521', 'SHOPEEPAY', '', '622', '105010222', '251201521', 'T4646028996122S8UDP', 'https://tripay.co.id/checkout/T4646028996122S8UDP', '1765101440', '2025-12-07', '1765102460', '', 'PAID', '126875', '1765101583', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1112, 'Tripay', '770937-251201229', 'ALFAMART', '', '304', '105010117', '251201229', 'T4646028997372KO6OA', 'https://tripay.co.id/checkout/T4646028997372KO6OA', '1765104621', '2025-12-07', '1765108341', '', 'PAID', '166750', '1765105734', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1113, 'Tripay', '675235-251201025', 'BRIVA', '', '41', '105020023', '251201025', 'T4646028997968HDAMJ', 'https://tripay.co.id/checkout/T4646028997968HDAMJ', '1765106004', '2025-12-07', '1765109724', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1114, 'Tripay', '428845-251201025', 'ALFAMART', '', '41', '105020023', '251201025', 'T4646028998424E03VJ', 'https://tripay.co.id/checkout/T4646028998424E03VJ', '1765107027', '2025-12-07', '1765110747', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1115, 'Tripay', '575083-251201025', 'ALFAMART', '', '41', '105020023', '251201025', 'T4646028998540BTPUL', 'https://tripay.co.id/checkout/T4646028998540BTPUL', '1765107287', '2025-12-07', '1765111007', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1116, 'Tripay', '81900-251201649', 'MANDIRIVA', '', '752', '105010270', '251201649', 'T4646028998762VLEYS', 'https://tripay.co.id/checkout/T4646028998762VLEYS', '1765107728', '2025-12-07', '1765111441', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1117, 'Tripay', '123469-251201293', 'INDOMARET', '', '371', '105010139', '251201293', 'T46460289987700SV42', 'https://tripay.co.id/checkout/T46460289987700SV42', '1765107747', '2025-12-07', '1765108766', '', 'PAID', '126750', '1765108204', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1118, 'Tripay', '139982-251201025', 'ALFAMART', '', '41', '105020023', '251201025', 'T4646028998926XESMW', 'https://tripay.co.id/checkout/T4646028998926XESMW', '1765108069', '2025-12-07', '1765111789', '', 'PAID', '166750', '1765108345', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1119, 'Tripay', '326119-251201205', 'BRIVA', '', '275', '105030013', '251201205', 'T46460290000481HY1P', 'https://tripay.co.id/checkout/T46460290000481HY1P', '1765110411', '2025-12-07', '1765114123', '', 'PAID', '127125', '1765110526', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1120, 'Tripay', '998533-251201424', 'BCAVA', '', '517', '105020262', '251201424', 'T464602900026558NQZ', 'https://tripay.co.id/checkout/T464602900026558NQZ', '1765110917', '2025-12-07', '1765111937', '', 'PAID', '127750', '1765111045', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1121, 'Tripay', '991224-251201619', 'QRIS', '', '721', '105010263', '251201619', 'T4646029000932GFPBW', 'https://tripay.co.id/checkout/T4646029000932GFPBW', '1765112231', '2025-12-07', '1765112951', '', 'PAID', '125812', '1765112269', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1122, 'Tripay', '6635-251201391', 'BRIVA', '', '483', '105030049', '251201391', 'T464602900172273FEW', 'https://tripay.co.id/checkout/T464602900172273FEW', '1765113764', '2025-12-07', '1765117476', '', 'PAID', '127125', '1765113816', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1123, 'Tripay', '582708-251201374', 'INDOMARET', '', '464', '105030047', '251201374', 'T4646029002532ARYXV', 'https://tripay.co.id/checkout/T4646029002532ARYXV', '1765115785', '2025-12-07', '1765116805', '', 'PAID', '126750', '1765116423', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1124, 'Tripay', '965191-251201263', 'INDOMARET', '', '339', '105020185', '251201263', 'T4646029003402DBZSJ', 'https://tripay.co.id/checkout/T4646029003402DBZSJ', '1765118450', '2025-12-07', '1765119470', '', 'PAID', '166750', '1765118569', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1125, 'Tripay', '18247-251201487', 'QRIS2', '', '586', '105010206', '251201487', 'T4646029004513RDMES', 'https://tripay.co.id/checkout/T4646029004513RDMES', '1765123362', '2025-12-07', '1765124081', '', 'PAID', '165000', '1765123435', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1126, 'Tripay', '178122-251201297', 'BCAVA', '', '376', '105020204', '251201297', 'T4646029005387JHUOW', 'https://tripay.co.id/checkout/T4646029005387JHUOW', '1765129798', '2025-12-08', '1765130818', '', 'PAID', '127750', '1765130020', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1127, 'Tripay', '748505-251201089', 'BCAVA', '', '135', '105020084', '251201089', 'T4646029005949NRYKP', 'https://tripay.co.id/checkout/T4646029005949NRYKP', '1765139746', '2025-12-08', '1765140766', '', 'PAID', '127750', '1765139796', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1128, 'Tripay', '6080-251201463', 'BRIVA', '', '559', '105030066', '251201463', 'T4646029009330URILD', 'https://tripay.co.id/checkout/T4646029009330URILD', '1765157398', '2025-12-08', '1765161111', '', 'PAID', '127125', '1765158089', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1129, 'Tripay', '276045-251201675', 'BCAVA', '', '778', '105020367', '251201675', 'T4646029009765RSI9M', 'https://tripay.co.id/checkout/T4646029009765RSI9M', '1765158603', '2025-12-08', '1765159623', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1130, 'Tripay', '976865-251201513', 'BCAVA', '', '614', '105030073', '251201513', 'T4646029009791EUEIO', 'https://tripay.co.id/checkout/T4646029009791EUEIO', '1765158679', '2025-12-08', '1765159699', '', 'PAID', '127750', '1765158733', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1131, 'Tripay', '273284-251201613', 'BCAVA', '', '715', '105020340', '251201613', 'T4646029009886SLYS3', 'https://tripay.co.id/checkout/T4646029009886SLYS3', '1765158935', '2025-12-08', '1765159954', '', 'PAID', '127750', '1765158965', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1132, 'Tripay', '257692-251201431', 'QRIS2', '', '524', '105020265', '251201431', 'T4646029009899ES4OC', 'https://tripay.co.id/checkout/T4646029009899ES4OC', '1765158969', '2025-12-08', '1765159689', '', 'PAID', '125000', '1765159001', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1133, 'Tripay', '36302-251201179', 'QRIS2', '', '244', '105020148', '251201179', 'T4646029009964NFH6D', 'https://tripay.co.id/checkout/T4646029009964NFH6D', '1765159097', '2025-12-08', '1765159817', '', 'PAID', '125000', '1765159144', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1134, 'Tripay', '965939-251201121', 'ALFAMART', '', '170', '105020109', '251201121', 'T4646029010180VCVMV', 'https://tripay.co.id/checkout/T4646029010180VCVMV', '1765159552', '2025-12-08', '1765163272', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1135, 'Tripay', '895229-251201532', 'BRIVA', '', '633', '105030075', '251201532', 'T4646029010189PYV1E', 'https://tripay.co.id/checkout/T4646029010189PYV1E', '1765159573', '2025-12-08', '1765163283', '', 'PAID', '127125', '1765159629', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1136, 'Tripay', '836193-251201291', 'BSIVA', '', '369', '105030031', '251201291', 'T4646029010256I2QDI', 'https://tripay.co.id/checkout/T4646029010256I2QDI', '1765159739', '2025-12-08', '1765163459', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1137, 'Tripay', '428221-251201648', 'BCAVA', '', '751', '105020355', '251201648', 'T4646029010299IDZ2S', 'https://tripay.co.id/checkout/T4646029010299IDZ2S', '1765159829', '2025-12-08', '1765160849', '', 'PAID', '127750', '1765159874', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1138, 'Tripay', '565935-251201420', 'INDOMARET', '', '513', '105020258', '251201420', 'T4646029010315546HB', 'https://tripay.co.id/checkout/T4646029010315546HB', '1765159873', '2025-12-08', '1765160893', '', 'PAID', '126750', '1765160830', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1139, 'Tripay', '395160-251201641', 'ALFAMART', '', '744', '105050036', '251201641', 'T4646029010342MAYG7', 'https://tripay.co.id/checkout/T4646029010342MAYG7', '1765159930', '2025-12-08', '1765163649', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1140, 'Tripay', '384638-251201641', 'INDOMARET', '', '744', '105050036', '251201641', 'T4646029010358JMCFF', 'https://tripay.co.id/checkout/T4646029010358JMCFF', '1765159958', '2025-12-08', '1765160978', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1141, 'Tripay', '333144-251201641', 'INDOMARET', '', '744', '105050036', '251201641', 'T464602901037255RRP', 'https://tripay.co.id/checkout/T464602901037255RRP', '1765159986', '2025-12-08', '1765161006', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1142, 'Tripay', '708432-251201291', 'BSIVA', '', '369', '105030031', '251201291', 'T4646029010413QCLYU', 'https://tripay.co.id/checkout/T4646029010413QCLYU', '1765160067', '2025-12-08', '1765163787', '', 'PAID', '127125', '1765160188', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1143, 'Tripay', '981637-251201641', 'INDOMARET', '', '744', '105050036', '251201641', 'T4646029010416EOTWT', 'https://tripay.co.id/checkout/T4646029010416EOTWT', '1765160078', '2025-12-08', '1765161098', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1144, 'Tripay', '359638-251201307', 'BNIVA', '', '388', '105010146', '251201307', 'T4646029010516RKCOC', 'https://tripay.co.id/checkout/T4646029010516RKCOC', '1765160281', '2025-12-08', '1765161293', '', 'PAID', '127125', '1765160481', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1145, 'Tripay', '543129-251201504', 'ALFAMART', '', '604', '105020294', '251201504', 'T46460290105417D5DQ', 'https://tripay.co.id/checkout/T46460290105417D5DQ', '1765160332', '2025-12-08', '1765164052', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1146, 'Tripay', '837180-251201144', 'INDOMARET', '', '201', '105020127', '251201144', 'T4646029010566UCUVK', 'https://tripay.co.id/checkout/T4646029010566UCUVK', '1765160389', '2025-12-08', '1765161409', '', 'PAID', '126750', '1765160450', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1147, 'Tripay', '90842-251201435', 'ALFAMART', '', '528', '105020269', '251201435', 'T4646029010569LHGDP', 'https://tripay.co.id/checkout/T4646029010569LHGDP', '1765160392', '2025-12-08', '1765164112', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1148, 'Tripay', '767649-251201612', 'BNIVA', '', '714', '105020339', '251201612', 'T4646029010591XAOZ9', 'https://tripay.co.id/checkout/T4646029010591XAOZ9', '1765160437', '2025-12-08', '1765161457', '', 'PAID', '127125', '1765160508', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1149, 'Tripay', '886102-251201430', 'DANA', '', '523', '105020264', '251201430', 'T46460290106237YJ9P', 'https://tripay.co.id/checkout/T46460290106237YJ9P', '1765160512', '2025-12-08', '1765161531', '', 'PAID', '165000', '1765160539', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1150, 'Tripay', '947932-251201641', 'BCAVA', '', '744', '105050036', '251201641', 'T4646029010653OJ7SM', 'https://tripay.co.id/checkout/T4646029010653OJ7SM', '1765160608', '2025-12-08', '1765161628', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1151, 'Tripay', '996042-251201641', 'BCAVA', '', '744', '105050036', '251201641', 'T4646029010737BWHZ5', 'https://tripay.co.id/checkout/T4646029010737BWHZ5', '1765160766', '2025-12-08', '1765161785', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1152, 'Tripay', '458728-251201641', 'DANA', '', '744', '105050036', '251201641', 'T46460290107755IEQW', 'https://tripay.co.id/checkout/T46460290107755IEQW', '1765160904', '2025-12-08', '1765161923', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1153, 'Tripay', '825358-251201641', 'BNIVA', '', '744', '105050036', '251201641', 'T46460290108037AZAW', 'https://tripay.co.id/checkout/T46460290108037AZAW', '1765160978', '2025-12-08', '1765161990', '', 'PAID', '127125', '1765161185', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1154, 'Tripay', '277008-251201262', 'INDOMARET', '', '338', '105020184', '251201262', 'T4646029011016BAT0U', 'https://tripay.co.id/checkout/T4646029011016BAT0U', '1765161391', '2025-12-08', '1765162411', '', 'PAID', '126750', '1765161648', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1155, 'Tripay', '831480-251201184', 'INDOMARET', '', '249', '105020150', '251201184', 'T4646029011127WMTNC', 'https://tripay.co.id/checkout/T4646029011127WMTNC', '1765161687', '2025-12-08', '1765162707', '', 'PAID', '126750', '1765161851', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1156, 'Tripay', '934691-251201196', 'INDOMARET', '', '265', '105020157', '251201196', 'T4646029011137HTQ23', 'https://tripay.co.id/checkout/T4646029011137HTQ23', '1765161721', '2025-12-08', '1765162741', '', 'PAID', '126750', '1765162166', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1157, 'Tripay', '200834-251201747', 'BCAVA', '', '855', '105020395', '251201747', 'T4646029012014FI7CK', 'https://tripay.co.id/checkout/T4646029012014FI7CK', '1765163958', '2025-12-08', '1765164978', '', 'PAID', '73750', '1765164004', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1158, 'Tripay', '612376-251201647', 'QRIS2', '', '750', '105020354', '251201647', 'T4646029012248PDYEL', 'https://tripay.co.id/checkout/T4646029012248PDYEL', '1765164523', '2025-12-08', '1765165242', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1159, 'Tripay', '669015-251201647', 'QRIS2', '', '750', '105020354', '251201647', 'T4646029012289EDKPP', 'https://tripay.co.id/checkout/T4646029012289EDKPP', '1765164595', '2025-12-08', '1765165314', '', 'PAID', '125000', '1765164642', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1160, 'Tripay', '274117-251201768', 'BCAVA', '', '876', '105020407', '251201768', 'T4646029012349BHEBN', 'https://tripay.co.id/checkout/T4646029012349BHEBN', '1765164740', '2025-12-08', '1765165760', '', 'PAID', '44750', '1765164787', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1161, 'Tripay', '834412-251201757', 'QRIS', '', '865', '105020398', '251201757', 'T4646029012605ZODVQ', 'https://tripay.co.id/checkout/T4646029012605ZODVQ', '1765165361', '2025-12-08', '1765166080', '', 'UNPAID', '38508', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1162, 'Tripay', '962711-251201155', 'BCAVA', '', '216', '105020134', '251201155', 'T46460290126595MMSE', 'https://tripay.co.id/checkout/T46460290126595MMSE', '1765165478', '2025-12-08', '1765166498', '', 'PAID', '127750', '1765166229', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1163, 'Tripay', '338136-251201067', 'ALFAMART', '', '104', '105020063', '251201067', 'T4646029012827C826D', 'https://tripay.co.id/checkout/T4646029012827C826D', '1765165879', '2025-12-08', '1765169599', '', 'PAID', '166750', '1765166331', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1164, 'Tripay', '820474-251201373', 'INDOMARET', '', '463', '105010174', '251201373', 'T4646029013133VK8J5', 'https://tripay.co.id/checkout/T4646029013133VK8J5', '1765166607', '2025-12-08', '1765167626', '', 'PAID', '126750', '1765166885', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1165, 'Tripay', '891795-251201635', 'QRIS2', '', '738', '105010269', '251201635', 'T46460290131341Y7FE', 'https://tripay.co.id/checkout/T46460290131341Y7FE', '1765166607', '2025-12-08', '1765167327', '', 'PAID', '125000', '1765166667', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1166, 'Tripay', '206627-251201758', 'QRIS2', '', '866', '105020399', '251201758', 'T4646029013244AC7CD', 'https://tripay.co.id/checkout/T4646029013244AC7CD', '1765166855', '2025-12-08', '1765167574', '', 'PAID', '125000', '1765166891', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1167, 'Tripay', '769105-251201452', 'MANDIRIVA', '', '547', '105010195', '251201452', 'T4646029013305WICQT', 'https://tripay.co.id/checkout/T4646029013305WICQT', '1765166989', '2025-12-08', '1765170701', '', 'PAID', '167125', '1765167071', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1168, 'Tripay', '413421-251201211', 'BNIVA', '', '282', '105030015', '251201211', 'T4646029013700NUOSF', 'https://tripay.co.id/checkout/T4646029013700NUOSF', '1765167852', '2025-12-08', '1765168863', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1169, 'Tripay', '601617-251201211', 'QRIS', '', '282', '105030015', '251201211', 'T4646029013734Y8TPK', 'https://tripay.co.id/checkout/T4646029013734Y8TPK', '1765167929', '2025-12-08', '1765168648', '', 'PAID', '125812', '1765167949', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1170, 'Tripay', '242559-251201698', 'INDOMARET', '', '801', '105030092', '251201698', 'T4646029014183JCW3R', 'https://tripay.co.id/checkout/T4646029014183JCW3R', '1765168975', '2025-12-08', '1765169995', '', 'PAID', '166750', '1765169036', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1171, 'Tripay', '934696-251201504', 'ALFAMART', '', '604', '105020294', '251201504', 'T4646029014431T5FFD', 'https://tripay.co.id/checkout/T4646029014431T5FFD', '1765169672', '2025-12-08', '1765173391', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1172, 'Tripay', '314105-251201504', 'INDOMARET', '', '604', '105020294', '251201504', 'T4646029014453M1G9I', 'https://tripay.co.id/checkout/T4646029014453M1G9I', '1765169723', '2025-12-08', '1765170743', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1173, 'Tripay', '73077-251201435', 'INDOMARET', '', '528', '105020269', '251201435', 'T46460290144812LYBW', 'https://tripay.co.id/checkout/T46460290144812LYBW', '1765169817', '2025-12-08', '1765170837', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1174, 'Tripay', '746721-251201435', 'INDOMARET', '', '528', '105020269', '251201435', 'T4646029014511TQEFA', 'https://tripay.co.id/checkout/T4646029014511TQEFA', '1765169890', '2025-12-08', '1765170910', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1175, 'Tripay', '811875-251201504', 'INDOMARET', '', '604', '105020294', '251201504', 'T4646029014554HYXNT', 'https://tripay.co.id/checkout/T4646029014554HYXNT', '1765170004', '2025-12-08', '1765171023', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1176, 'Tripay', '53891-251201435', 'INDOMARET', '', '528', '105020269', '251201435', 'T4646029014577AUKRY', 'https://tripay.co.id/checkout/T4646029014577AUKRY', '1765170053', '2025-12-08', '1765171073', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1177, 'Tripay', '668838-251201504', 'DANA', '', '604', '105020294', '251201504', 'T4646029014704VHUZ7', 'https://tripay.co.id/checkout/T4646029014704VHUZ7', '1765170359', '2025-12-08', '1765171378', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1178, 'Tripay', '328751-251201504', 'DANA', '', '604', '105020294', '251201504', 'T4646029015188SW2LQ', 'https://tripay.co.id/checkout/T4646029015188SW2LQ', '1765171534', '2025-12-08', '1765172553', '', 'PAID', '125000', '1765171562', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1179, 'Tripay', '32780-251201435', 'DANA', '', '528', '105020269', '251201435', 'T4646029015213MTI3C', 'https://tripay.co.id/checkout/T4646029015213MTI3C', '1765171606', '2025-12-08', '1765172625', '', 'PAID', '125000', '1765171626', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1180, 'Tripay', '90388-251201361', 'INDOMARET', '', '449', '105010168', '251201361', 'T46460290154041X2KQ', 'https://tripay.co.id/checkout/T46460290154041X2KQ', '1765172020', '2025-12-08', '1765173039', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1181, 'Tripay', '696783-251201663', 'BRIVA', '', '766', '105020361', '251201663', 'T4646029015408RJN0I', 'https://tripay.co.id/checkout/T4646029015408RJN0I', '1765172028', '2025-12-08', '1765175739', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1182, 'Tripay', '216791-251201663', 'BRIVA', '', '766', '105020361', '251201663', 'T4646029015530JD6UX', 'https://tripay.co.id/checkout/T4646029015530JD6UX', '1765172364', '2025-12-08', '1765176084', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1183, 'Tripay', '766425-251201663', 'BRIVA', '', '766', '105020361', '251201663', 'T4646029015826Z1OOX', 'https://tripay.co.id/checkout/T4646029015826Z1OOX', '1765173032', '2025-12-08', '1765176745', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1184, 'Tripay', '348516-251201745', 'BNIVA', '', '853', '105020394', '251201745', 'T46460290159181MWVX', 'https://tripay.co.id/checkout/T46460290159181MWVX', '1765173241', '2025-12-08', '1765174254', '', 'PAID', '77125', '1765173311', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1185, 'Tripay', '611974-251201757', 'INDOMARET', '', '865', '105020398', '251201757', 'T4646029016281V3WM5', 'https://tripay.co.id/checkout/T4646029016281V3WM5', '1765174183', '2025-12-08', '1765175203', '', 'PAID', '39750', '1765174308', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1186, 'Tripay', '773044-251201345', 'QRIS2', '', '432', '105030042', '251201345', 'T4646029016625H6LAA', 'https://tripay.co.id/checkout/T4646029016625H6LAA', '1765175110', '2025-12-08', '1765175830', '', 'PAID', '165000', '1765175191', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1187, 'Tripay', '787351-251201091', 'BNIVA', '', '137', '105020086', '251201091', 'T4646029017141RW3JW', 'https://tripay.co.id/checkout/T4646029017141RW3JW', '1765176412', '2025-12-08', '1765177424', '', 'PAID', '127125', '1765176498', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1188, 'Tripay', '90430-251201336', 'MANDIRIVA', '', '423', '105010164', '251201336', 'T4646029017247ULQ7R', 'https://tripay.co.id/checkout/T4646029017247ULQ7R', '1765176735', '2025-12-08', '1765180455', '', 'PAID', '127125', '1765177010', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1189, 'Tripay', '283978-251201314', 'MANDIRIVA', '', '395', '105020212', '251201314', 'T4646029017279BXKAQ', 'https://tripay.co.id/checkout/T4646029017279BXKAQ', '1765176843', '2025-12-08', '1765180563', '', 'PAID', '127125', '1765176960', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1190, 'Tripay', '629511-251201766', 'QRIS2', '', '874', '105020405', '251201766', 'T4646029017679FCREI', 'https://tripay.co.id/checkout/T4646029017679FCREI', '1765177951', '2025-12-08', '1765178671', '', 'PAID', '83000', '1765178082', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1191, 'Tripay', '84370-251201279', 'BCAVA', '', '357', '105020195', '251201279', 'T4646029018082LE6LW', 'https://tripay.co.id/checkout/T4646029018082LE6LW', '1765179151', '2025-12-08', '1765180171', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1192, 'Tripay', '863675-251201544', 'BCAVA', '', '645', '105030078', '251201544', 'T4646029018534MXNDY', 'https://tripay.co.id/checkout/T4646029018534MXNDY', '1765180282', '2025-12-08', '1765181302', '', 'PAID', '127750', '1765180453', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1193, 'Tripay', '419883-251201709', 'BRIVA', '', '817', '105050039', '251201709', 'T4646029018563MKCMR', 'https://tripay.co.id/checkout/T4646029018563MKCMR', '1765180341', '2025-12-08', '1765184052', '', 'PAID', '127125', '1765180441', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1194, 'Tripay', '468198-251201361', 'INDOMARET', '', '449', '105010168', '251201361', 'T4646029018606G4LA9', 'https://tripay.co.id/checkout/T4646029018606G4LA9', '1765180438', '2025-12-08', '1765181458', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1195, 'Tripay', '135880-251201285', 'INDOMARET', '', '363', '105020198', '251201285', 'T4646029018792HODHX', 'https://tripay.co.id/checkout/T4646029018792HODHX', '1765180957', '2025-12-08', '1765181977', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1196, 'Tripay', '471308-251201489', 'BCAVA', '', '588', '105020290', '251201489', 'T4646029019110QUAYD', 'https://tripay.co.id/checkout/T4646029019110QUAYD', '1765181877', '2025-12-08', '1765182897', '', 'PAID', '167750', '1765181945', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1197, 'Tripay', '52139-251201771', 'BRIVA', '', '879', '10530001', '251201771', 'T4646029019152SR8YV', 'https://tripay.co.id/checkout/T4646029019152SR8YV', '1765181993', '2025-12-08', '1765185705', '', 'PAID', '23125', '1765182110', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1198, 'Tripay', '82996-251201379', 'INDOMARET', '', '470', '105020239', '251201379', 'T4646029019501EQQOG', 'https://tripay.co.id/checkout/T4646029019501EQQOG', '1765183097', '2025-12-08', '1765184117', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1199, 'Tripay', '934337-251201467', 'INDOMARET', '', '563', '105020281', '251201467', 'T4646029019519BASHS', 'https://tripay.co.id/checkout/T4646029019519BASHS', '1765183156', '2025-12-08', '1765184176', '', 'PAID', '166750', '1765183583', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1200, 'Tripay', '322177-251201379', 'INDOMARET', '', '470', '105020239', '251201379', 'T4646029019629F9ABU', 'https://tripay.co.id/checkout/T4646029019629F9ABU', '1765183448', '2025-12-08', '1765184468', '', 'PAID', '126750', '1765183533', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1201, 'Tripay', '446678-251201600', 'DANA', '', '702', '105010253', '251201600', 'T4646029019659WDVNL', 'https://tripay.co.id/checkout/T4646029019659WDVNL', '1765183541', '2025-12-08', '1765184561', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1202, 'Tripay', '271076-251201535', 'BNIVA', '', '636', '105020309', '251201535', 'T4646029019665OUYD1', 'https://tripay.co.id/checkout/T4646029019665OUYD1', '1765183562', '2025-12-08', '1765184575', '', 'PAID', '127125', '1765183598', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1203, 'Tripay', '680442-251201252', 'QRIS2', '', '327', '105020180', '251201252', 'T4646029019954JC9ST', 'https://tripay.co.id/checkout/T4646029019954JC9ST', '1765184357', '2025-12-08', '1765185076', '', 'PAID', '125000', '1765184388', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1204, 'Tripay', '436162-251201401', 'INDOMARET', '', '494', '105020248', '251201401', 'T46460290199848EQR2', 'https://tripay.co.id/checkout/T46460290199848EQR2', '1765184451', '2025-12-08', '1765185470', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1205, 'Tripay', '36857-251201604', 'BCAVA', '', '706', '105020337', '251201604', 'T4646029020330VFHVN', 'https://tripay.co.id/checkout/T4646029020330VFHVN', '1765185414', '2025-12-08', '1765186434', '', 'PAID', '127750', '1765185569', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1206, 'Tripay', '366594-251201620', 'INDOMARET', '', '722', '105020344', '251201620', 'T46460290203436R2VZ', 'https://tripay.co.id/checkout/T46460290203436R2VZ', '1765185440', '2025-12-08', '1765186459', '', 'PAID', '126750', '1765185968', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1207, 'Tripay', '944486-251201449', 'BNIVA', '', '544', '105050013', '251201449', 'T4646029020678MSSPF', 'https://tripay.co.id/checkout/T4646029020678MSSPF', '1765186284', '2025-12-08', '1765187296', '', 'PAID', '127125', '1765186346', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1208, 'Tripay', '812830-251201425', 'QRIS2', '', '518', '105030055', '251201425', 'T4646029021031ZRFHU', 'https://tripay.co.id/checkout/T4646029021031ZRFHU', '1765187084', '2025-12-08', '1765187803', '', 'PAID', '125000', '1765187128', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1209, 'Tripay', '135211-251201393', 'MANDIRIVA', '', '485', '105030050', '251201393', 'T4646029021162DHNYT', 'https://tripay.co.id/checkout/T4646029021162DHNYT', '1765187386', '2025-12-08', '1765191105', '', 'PAID', '167125', '1765187705', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1210, 'Tripay', '585434-251201685', 'BRIVA', '', '788', '105040006', '251201685', 'T4646029021679YRKVM', 'https://tripay.co.id/checkout/T4646029021679YRKVM', '1765188596', '2025-12-08', '1765192309', '', 'PAID', '127125', '1765188687', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1211, 'Tripay', '807896-251201653', 'MANDIRIVA', '', '756', '105020357', '251201653', 'T4646029022023GXFLB', 'https://tripay.co.id/checkout/T4646029022023GXFLB', '1765189466', '2025-12-08', '1765193186', '', 'PAID', '167125', '1765189952', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1212, 'Tripay', '261620-251201191', 'BRIVA', '', '257', '105030004', '251201191', 'T4646029022227WKE2X', 'https://tripay.co.id/checkout/T4646029022227WKE2X', '1765189933', '2025-12-08', '1765193652', '', 'PAID', '127125', '1765190034', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1213, 'Tripay', '694320-251201636', 'INDOMARET', '', '739', '105020348', '251201636', 'T4646029022517UGTXG', 'https://tripay.co.id/checkout/T4646029022517UGTXG', '1765190651', '2025-12-08', '1765191671', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1214, 'Tripay', '593064-251201421', 'MANDIRIVA', '', '514', '105020259', '251201421', 'T4646029022541MKIS4', 'https://tripay.co.id/checkout/T4646029022541MKIS4', '1765190700', '2025-12-08', '1765194412', '', 'PAID', '127125', '1765191114', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1215, 'Tripay', '478760-251201401', 'INDOMARET', '', '494', '105020248', '251201401', 'T4646029022600H97UK', 'https://tripay.co.id/checkout/T4646029022600H97UK', '1765190814', '2025-12-08', '1765191833', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1216, 'Tripay', '23293-251201279', 'BCAVA', '', '357', '105020195', '251201279', 'T4646029022622E542O', 'https://tripay.co.id/checkout/T4646029022622E542O', '1765190876', '2025-12-08', '1765191896', '', 'PAID', '127750', '1765190976', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1217, 'Tripay', '393952-251201531', 'BRIVA', '', '632', '105020306', '251201531', 'T4646029022645WTTJV', 'https://tripay.co.id/checkout/T4646029022645WTTJV', '1765190907', '2025-12-08', '1765194626', '', 'PAID', '127125', '1765191123', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1218, 'Tripay', '346662-251201581', 'BRIVA', '', '683', '105030084', '251201581', 'T4646029023102Z5S1U', 'https://tripay.co.id/checkout/T4646029023102Z5S1U', '1765191865', '2025-12-08', '1765195577', '', 'PAID', '127125', '1765191903', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1219, 'Tripay', '142007-251201686', 'BNIVA', '', '789', '105040007', '251201686', 'T4646029023129RVLZB', 'https://tripay.co.id/checkout/T4646029023129RVLZB', '1765191943', '2025-12-08', '1765192963', '', 'PAID', '127125', '1765192198', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1220, 'Tripay', '305496-251201498', 'INDOMARET', '', '597', '105050024', '251201498', 'T4646029023813VCWFT', 'https://tripay.co.id/checkout/T4646029023813VCWFT', '1765193442', '2025-12-08', '1765194462', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1221, 'Tripay', '146905-251201662', 'MANDIRIVA', '', '765', '105020360', '251201662', 'T4646029023901MSHTU', 'https://tripay.co.id/checkout/T4646029023901MSHTU', '1765193610', '2025-12-08', '1765197323', '', 'PAID', '127125', '1765193744', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1222, 'Tripay', '521560-251201683', 'BNIVA', '', '786', '105040004', '251201683', 'T4646029023965TTKUI', 'https://tripay.co.id/checkout/T4646029023965TTKUI', '1765193733', '2025-12-08', '1765194753', '', 'PAID', '167125', '1765193826', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1223, 'Tripay', '200828-251201280', 'BRIVA', '', '358', '105030029', '251201280', 'T4646029024027FM3LO', 'https://tripay.co.id/checkout/T4646029024027FM3LO', '1765193865', '2025-12-08', '1765197584', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1224, 'Tripay', '999221-251201281', 'BRIVA', '', '359', '105030030', '251201281', 'T4646029024234WEI8N', 'https://tripay.co.id/checkout/T4646029024234WEI8N', '1765194266', '2025-12-08', '1765197978', '', 'PAID', '127125', '1765194387', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1225, 'Tripay', '97546-251201710', 'BRIVA', '', '818', '105050040', '251201710', 'T4646029024248DHKFL', 'https://tripay.co.id/checkout/T4646029024248DHKFL', '1765194295', '2025-12-08', '1765198014', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1226, 'Tripay', '451948-251201498', 'INDOMARET', '', '597', '105050024', '251201498', 'T4646029024256YL145', 'https://tripay.co.id/checkout/T4646029024256YL145', '1765194300', '2025-12-08', '1765195320', '', 'PAID', '126750', '1765194703', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1227, 'Tripay', '650326-251201710', 'INDOMARET', '', '818', '105050040', '251201710', 'T4646029024497YTDFY', 'https://tripay.co.id/checkout/T4646029024497YTDFY', '1765194796', '2025-12-08', '1765195816', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1228, 'Tripay', '140676-251201204', 'BRIVA', '', '274', '105030012', '251201204', 'T4646029024773CG4TQ', 'https://tripay.co.id/checkout/T4646029024773CG4TQ', '1765195343', '2025-12-08', '1765199054', '', 'PAID', '127125', '1765195395', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1229, 'Tripay', '641650-251201623', 'MANDIRIVA', '', '726', '105020345', '251201623', 'T4646029024979G3VC3', 'https://tripay.co.id/checkout/T4646029024979G3VC3', '1765195735', '2025-12-08', '1765199455', '', 'PAID', '127125', '1765195824', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1230, 'Tripay', '133606-251201242', 'ALFAMART', '', '317', '105010123', '251201242', 'T4646029025041XTOBE', 'https://tripay.co.id/checkout/T4646029025041XTOBE', '1765195844', '2025-12-08', '1765199564', '', 'PAID', '126750', '1765196656', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1231, 'Tripay', '831636-251201702', 'BRIVA', '', '807', '105030093', '251201702', 'T4646029025575TLKNH', 'https://tripay.co.id/checkout/T4646029025575TLKNH', '1765196958', '2025-12-08', '1765200678', '', 'PAID', '127125', '1765197079', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1232, 'Tripay', '663678-251201372', 'BCAVA', '', '462', '105020234', '251201372', 'T4646029025690ZDWQL', 'https://tripay.co.id/checkout/T4646029025690ZDWQL', '1765197199', '2025-12-08', '1765198219', '', 'PAID', '127750', '1765197667', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1233, 'Tripay', '991337-251201655', 'QRIS', '', '758', '105030088', '251201655', 'T4646029025835KM5LA', 'https://tripay.co.id/checkout/T4646029025835KM5LA', '1765197544', '2025-12-08', '1765198263', '', 'PAID', '125812', '1765197578', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1234, 'Tripay', '45092-251201637', 'BCAVA', '', '740', '105020349', '251201637', 'T4646029026235OF4OM', 'https://tripay.co.id/checkout/T4646029026235OF4OM', '1765198343', '2025-12-08', '1765199362', '', 'PAID', '127750', '1765198445', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1235, 'Tripay', '533236-251201716', 'INDOMARET', '', '824', '105020383', '251201716', 'T4646029026282N970N', 'https://tripay.co.id/checkout/T4646029026282N970N', '1765198450', '2025-12-08', '1765199469', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1236, 'Tripay', '79871-251201217', 'ALFAMART', '', '289', '105020165', '251201217', 'T46460290265804OCHX', 'https://tripay.co.id/checkout/T46460290265804OCHX', '1765199100', '2025-12-08', '1765202819', '', 'PAID', '126750', '1765199229', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1237, 'Tripay', '672941-251201716', 'INDOMARET', '', '824', '105020383', '251201716', 'T4646029027129UKAFS', 'https://tripay.co.id/checkout/T4646029027129UKAFS', '1765200370', '2025-12-08', '1765201390', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1238, 'Tripay', '965789-251201716', 'INDOMARET', '', '824', '105020383', '251201716', 'T4646029027144LD1CJ', 'https://tripay.co.id/checkout/T4646029027144LD1CJ', '1765200405', '2025-12-08', '1765201424', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1239, 'Tripay', '242962-251201053', 'BRIVA', '', '85', '105020049', '251201053', 'T4646029027218MBCYJ', 'https://tripay.co.id/checkout/T4646029027218MBCYJ', '1765200598', '2025-12-08', '1765204310', '', 'PAID', '127125', '1765200678', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1240, 'Tripay', '495361-251201716', 'INDOMARET', '', '824', '105020383', '251201716', 'T4646029027441XSCHH', 'https://tripay.co.id/checkout/T4646029027441XSCHH', '1765201161', '2025-12-08', '1765202180', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1241, 'Tripay', '822941-251201716', 'INDOMARET', '', '824', '105020383', '251201716', 'T46460290274780T5N5', 'https://tripay.co.id/checkout/T46460290274780T5N5', '1765201259', '2025-12-08', '1765202279', '', 'PAID', '126750', '1765201519', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1242, 'Tripay', '683418-251201493', 'INDOMARET', '', '592', '105030071', '251201493', 'T4646029028152CENNY', 'https://tripay.co.id/checkout/T4646029028152CENNY', '1765202936', '2025-12-08', '1765203956', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1243, 'Tripay', '690087-251201493', 'INDOMARET', '', '592', '105030071', '251201493', 'T4646029028253HNEPB', 'https://tripay.co.id/checkout/T4646029028253HNEPB', '1765203209', '2025-12-08', '1765204229', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1244, 'Tripay', '802182-251201493', 'SHOPEEPAY', '', '592', '105030071', '251201493', 'T4646029028274QVH7P', 'https://tripay.co.id/checkout/T4646029028274QVH7P', '1765203263', '2025-12-08', '1765204283', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1245, 'Tripay', '553522-251201493', 'INDOMARET', '', '592', '105030071', '251201493', 'T4646029028290HK3NF', 'https://tripay.co.id/checkout/T4646029028290HK3NF', '1765203307', '2025-12-08', '1765204327', '', 'PAID', '126750', '1765203396', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1246, 'Tripay', '338279-251201710', 'ALFAMART', '', '818', '105050040', '251201710', 'T4646029028510NAKCY', 'https://tripay.co.id/checkout/T4646029028510NAKCY', '1765203914', '2025-12-08', '1765207634', '', 'PAID', '126750', '1765204020', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1247, 'Tripay', '479549-251201315', 'INDOMARET', '', '396', '105020213', '251201315', 'T4646029029015HFYQL', 'https://tripay.co.id/checkout/T4646029029015HFYQL', '1765205430', '2025-12-08', '1765206450', '', 'PAID', '166750', '1765206098', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1248, 'Tripay', '557920-251201539', 'INDOMARET', '', '640', '105030076', '251201539', 'T4646029029252PRN2U', 'https://tripay.co.id/checkout/T4646029029252PRN2U', '1765206307', '2025-12-08', '1765207327', '', 'PAID', '126750', '1765206537', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1249, 'Tripay', '61720-251201410', 'QRIS2', '', '503', '105020252', '251201410', 'T4646029029725K5FM5', 'https://tripay.co.id/checkout/T4646029029725K5FM5', '1765208327', '2025-12-08', '1765209046', '', 'PAID', '125000', '1765208343', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1250, 'Tripay', '335928-251201353', 'QRIS2', '', '440', '105050007', '251201353', 'T4646029032021PVDFM', 'https://tripay.co.id/checkout/T4646029032021PVDFM', '1765233033', '2025-12-09', '1765233753', '', 'PAID', '125000', '1765233084', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1251, 'Tripay', '963333-251201164', 'ALFAMART', '', '225', '105020136', '251201164', 'T4646029033451LWI9N', 'https://tripay.co.id/checkout/T4646029033451LWI9N', '1765239709', '2025-12-09', '1765243429', '', 'PAID', '126750', '1765239754', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1252, 'Tripay', '182503-251201779', 'INDOMARET', '', '887', '10550003', '251201779', 'T4646029033890UAOMI', 'https://tripay.co.id/checkout/T4646029033890UAOMI', '1765241098', '2025-12-09', '1765242117', '', 'UNPAID', '85750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1253, 'Tripay', '751798-251201127', 'ALFAMART', '', '176', '105020112', '251201127', 'T4646029034825L2PT2', 'https://tripay.co.id/checkout/T4646029034825L2PT2', '1765243981', '2025-12-09', '1765247701', '', 'PAID', '126750', '1765244394', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1254, 'Tripay', '191324-251201676', 'ALFAMART', '', '779', '105010282', '251201676', 'T4646029034982ITYSH', 'https://tripay.co.id/checkout/T4646029034982ITYSH', '1765244403', '2025-12-09', '1765248123', '', 'PAID', '126750', '1765244765', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1255, 'Tripay', '221165-251201311', 'QRIS2', '', '392', '105010150', '251201311', 'T4646029035042DY7WX', 'https://tripay.co.id/checkout/T4646029035042DY7WX', '1765244575', '2025-12-09', '1765245294', '', 'PAID', '125000', '1765244651', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1256, 'Tripay', '823980-251201352', 'ALFAMART', '', '439', '105050006', '251201352', 'T4646029035143YCMIQ', 'https://tripay.co.id/checkout/T4646029035143YCMIQ', '1765244902', '2025-12-09', '1765248622', '', 'PAID', '126750', '1765245927', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1257, 'Tripay', '912187-251201342', 'DANA', '', '429', '105020223', '251201342', 'T4646029037171BGRII', 'https://tripay.co.id/checkout/T4646029037171BGRII', '1765249788', '2025-12-09', '1765250807', '', 'PAID', '125000', '1765249823', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1258, 'Tripay', '429604-251201112', 'MANDIRIVA', '', '160', '105020100', '251201112', 'T46460290379618Q6A4', 'https://tripay.co.id/checkout/T46460290379618Q6A4', '1765251675', '2025-12-09', '1765255395', '', 'PAID', '127125', '1765251819', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1259, 'Tripay', '60868-251201672', 'INDOMARET', '', '775', '105020366', '251201672', 'T4646029038424YFQCK', 'https://tripay.co.id/checkout/T4646029038424YFQCK', '1765252837', '2025-12-09', '1765253857', '', 'PAID', '126750', '1765252881', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1260, 'Tripay', '544360-251201754', 'INDOMARET', '', '862', '105020397', '251201754', 'T4646029038479TM4OU', 'https://tripay.co.id/checkout/T4646029038479TM4OU', '1765252945', '2025-12-09', '1765253965', '', 'UNPAID', '47750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1261, 'Tripay', '182409-251201779', 'QRIS2', '', '887', '10550003', '251201779', 'T4646029040764JSY0W', 'https://tripay.co.id/checkout/T4646029040764JSY0W', '1765258666', '2025-12-09', '1765259385', '', 'PAID', '84000', '1765258700', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1262, 'Tripay', '675843-251201401', 'INDOMARET', '', '494', '105020248', '251201401', 'T4646029042021LBGOZ', 'https://tripay.co.id/checkout/T4646029042021LBGOZ', '1765261936', '2025-12-09', '1765262956', '', 'PAID', '126750', '1765262016', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1263, 'Tripay', '834926-251201285', 'INDOMARET', '', '363', '105020198', '251201285', 'T4646029045175N690L', 'https://tripay.co.id/checkout/T4646029045175N690L', '1765270200', '2025-12-09', '1765271220', '', 'PAID', '126750', '1765270334', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1264, 'Tripay', '238638-251201111', 'BCAVA', '', '159', '105020099', '251201111', 'T4646029048552RKFEJ', 'https://tripay.co.id/checkout/T4646029048552RKFEJ', '1765277413', '2025-12-09', '1765278433', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1265, 'Tripay', '662657-251201272', 'DANA', '', '349', '105030028', '251201272', 'T4646029050330QY3FJ', 'https://tripay.co.id/checkout/T4646029050330QY3FJ', '1765280888', '2025-12-09', '1765281908', '', 'PAID', '125000', '1765280957', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1266, 'Tripay', '630561-251201451', 'INDOMARET', '', '546', '105030064', '251201451', 'T4646029051625ES6PS', 'https://tripay.co.id/checkout/T4646029051625ES6PS', '1765282982', '2025-12-09', '1765284002', '', 'PAID', '126750', '1765283030', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1267, 'Tripay', '631717-251201636', 'INDOMARET', '', '739', '105020348', '251201636', 'T4646029051745Y0NZW', 'https://tripay.co.id/checkout/T4646029051745Y0NZW', '1765283192', '2025-12-09', '1765284212', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1268, 'Tripay', '720103-251201111', 'INDOMARET', '', '159', '105020099', '251201111', 'T4646029053886UTX0H', 'https://tripay.co.id/checkout/T4646029053886UTX0H', '1765287451', '2025-12-09', '1765288470', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1269, 'Tripay', '830779-251201111', 'ALFAMART', '', '159', '105020099', '251201111', 'T4646029054589CCGUY', 'https://tripay.co.id/checkout/T4646029054589CCGUY', '1765289089', '2025-12-09', '1765292809', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1270, 'Tripay', '224253-251201111', 'BCAVA', '', '159', '105020099', '251201111', 'T4646029054659UWAHX', 'https://tripay.co.id/checkout/T4646029054659UWAHX', '1765289264', '2025-12-09', '1765290284', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1271, 'Tripay', '365290-251201627', 'QRIS', '', '730', '105030087', '251201627', 'T46460290547608FN9F', 'https://tripay.co.id/checkout/T46460290547608FN9F', '1765289544', '2025-12-09', '1765290263', '', 'PAID', '125812', '1765289586', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1272, 'Tripay', '405178-251201111', 'ALFAMART', '', '159', '105020099', '251201111', 'T4646029054807WCPYU', 'https://tripay.co.id/checkout/T4646029054807WCPYU', '1765289692', '2025-12-09', '1765293412', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1273, 'Tripay', '524731-251201111', 'ALFAMART', '', '159', '105020099', '251201111', 'T4646029055036MXHRL', 'https://tripay.co.id/checkout/T4646029055036MXHRL', '1765290296', '2025-12-09', '1765294016', '', 'PAID', '126750', '1765290394', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1274, 'Tripay', '866652-251201697', 'INDOMARET', '', '800', '105020376', '251201697', 'T4646029060908AH67J', 'https://tripay.co.id/checkout/T4646029060908AH67J', '1765326073', '2025-12-10', '1765327092', '', 'PAID', '126750', '1765326301', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1275, 'Tripay', '345610-251201525', 'INDOMARET', '', '626', '105020300', '251201525', 'T4646029065773NYZWQ', 'https://tripay.co.id/checkout/T4646029065773NYZWQ', '1765335991', '2025-12-10', '1765337011', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1276, 'Tripay', '952166-251201525', 'INDOMARET', '', '626', '105020300', '251201525', 'T4646029066225DB1GQ', 'https://tripay.co.id/checkout/T4646029066225DB1GQ', '1765336853', '2025-12-10', '1765337872', '', 'PAID', '126750', '1765337310', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1277, 'Tripay', '399856-251201208', 'ALFAMART', '', '279', '105010104', '251201208', 'T4646029069968PUQG0', 'https://tripay.co.id/checkout/T4646029069968PUQG0', '1765344097', '2025-12-10', '1765347817', '', 'PAID', '126750', '1765344165', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1278, 'Tripay', '696272-251201705', 'INDOMARET', '', '810', '105010291', '251201705', 'T4646029070883WWIFP', 'https://tripay.co.id/checkout/T4646029070883WWIFP', '1765345903', '2025-12-10', '1765346923', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1279, 'Tripay', '285059-251201550', 'INDOMARET', '', '651', '105030082', '251201550', 'T4646029073751VUDG7', 'https://tripay.co.id/checkout/T4646029073751VUDG7', '1765351599', '2025-12-10', '1765352619', '', 'PAID', '126750', '1765351692', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1280, 'Tripay', '626566-251201705', 'INDOMARET', '', '810', '105010291', '251201705', 'T46460290741277E6K8', 'https://tripay.co.id/checkout/T46460290741277E6K8', '1765352480', '2025-12-10', '1765353500', '', 'PAID', '126750', '1765352777', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1281, 'Tripay', '402318-251201344', 'BRIVA', '', '431', '105030041', '251201344', 'T4646029078612QFDZY', 'https://tripay.co.id/checkout/T4646029078612QFDZY', '1765361320', '2025-12-10', '1765365040', '', 'PAID', '127125', '1765362079', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1282, 'Tripay', '731659-251201465', 'QRIS', '', '561', '105020279', '251201465', 'T46460290795348PI9B', 'https://tripay.co.id/checkout/T46460290795348PI9B', '1765362728', '2025-12-10', '1765363447', '', 'PAID', '125812', '1765362780', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1283, 'Tripay', '977849-251201646', 'MANDIRIVA', '', '749', '105020353', '251201646', 'T4646029085163ZVM2W', 'https://tripay.co.id/checkout/T4646029085163ZVM2W', '1765369924', '2025-12-10', '1765373644', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1284, 'Tripay', '95978-251201646', 'QRIS2', '', '749', '105020353', '251201646', 'T4646029085298BPAJ2', 'https://tripay.co.id/checkout/T4646029085298BPAJ2', '1765370086', '2025-12-10', '1765370805', '', 'PAID', '125000', '1765370130', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1285, 'Tripay', '321550-251201636', 'INDOMARET', '', '739', '105020348', '251201636', 'T4646029085658B4EDL', 'https://tripay.co.id/checkout/T4646029085658B4EDL', '1765370543', '2025-12-10', '1765371562', '', 'PAID', '126750', '1765370748', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1286, 'Tripay', '196847-251201675', 'BCAVA', '', '778', '105020367', '251201675', 'T4646029104326AU04M', 'https://tripay.co.id/checkout/T4646029104326AU04M', '1765427163', '2025-12-11', '1765428183', '', 'PAID', '127750', '1765427286', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1287, 'Tripay', '488682-251201412', 'MANDIRIVA', '', '505', '105020253', '251201412', 'T4646029112524UXXPN', 'https://tripay.co.id/checkout/T4646029112524UXXPN', '1765447983', '2025-12-11', '1765451703', '', 'PAID', '207125', '1765448062', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1288, 'Tripay', '660309-251201333', 'BCAVA', '', '418', '105020220', '251201333', 'T4646029115691BDMMX', 'https://tripay.co.id/checkout/T4646029115691BDMMX', '1765454255', '2025-12-11', '1765455275', '', 'PAID', '127750', '1765454478', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1289, 'Tripay', '483626-251201129', 'BCAVA', '', '178', '105020113', '251201129', 'T4646029116224VNMOF', 'https://tripay.co.id/checkout/T4646029116224VNMOF', '1765455144', '2025-12-11', '1765456163', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1290, 'Tripay', '41385-251201129', 'SHOPEEPAY', '', '178', '105020113', '251201129', 'T4646029116268HQ5R7', 'https://tripay.co.id/checkout/T4646029116268HQ5R7', '1765455242', '2025-12-11', '1765456262', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1291, 'Tripay', '355796-251201549', 'INDOMARET', '', '650', '105030081', '251201549', 'T4646029116710I5X1P', 'https://tripay.co.id/checkout/T4646029116710I5X1P', '1765456167', '2025-12-11', '1765457186', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1292, 'Tripay', '539500-251201549', 'INDOMARET', '', '650', '105030081', '251201549', 'T4646029117987VEK7H', 'https://tripay.co.id/checkout/T4646029117987VEK7H', '1765458705', '2025-12-11', '1765459724', '', 'PAID', '126750', '1765458779', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1293, 'Tripay', '63091-251201414', 'INDOMARET', '', '507', '105020255', '251201414', 'T4646029119866IXI8U', 'https://tripay.co.id/checkout/T4646029119866IXI8U', '1765463137', '2025-12-11', '1765464157', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1294, 'Tripay', '515813-251201098', 'BCAVA', '', '145', '105020093', '251201098', 'T4646029121668LCYZH', 'https://tripay.co.id/checkout/T4646029121668LCYZH', '1765470846', '2025-12-11', '1765471866', '', 'PAID', '207750', '1765470888', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1295, 'Tripay', '433148-251201426', 'BRIVA', '', '519', '105030056', '251201426', 'T4646029125534OKADI', 'https://tripay.co.id/checkout/T4646029125534OKADI', '1765501148', '2025-12-12', '1765504860', '', 'PAID', '127125', '1765501178', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1296, 'Tripay', '74294-251201474', 'INDOMARET', '', '572', '105020283', '251201474', 'T4646029130838MXKGA', 'https://tripay.co.id/checkout/T4646029130838MXKGA', '1765517082', '2025-12-12', '1765518102', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1297, 'Tripay', '750925-251201474', 'ALFAMART', '', '572', '105020283', '251201474', 'T4646029130912XHDT7', 'https://tripay.co.id/checkout/T4646029130912XHDT7', '1765517296', '2025-12-12', '1765521016', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1298, 'Tripay', '18611-251201474', 'DANA', '', '572', '105020283', '251201474', 'T4646029131045DOHTP', 'https://tripay.co.id/checkout/T4646029131045DOHTP', '1765517780', '2025-12-12', '1765518799', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1299, 'Tripay', '752430-251201129', 'SHOPEEPAY', '', '178', '105020113', '251201129', 'T4646029135639WZVVO', 'https://tripay.co.id/checkout/T4646029135639WZVVO', '1765531785', '2025-12-12', '1765532804', '', 'PAID', '126875', '1765531815', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1300, 'Tripay', '316749-251201694', 'INDOMARET', '', '797', '105020374', '251201694', 'T4646029141615AUAM9', 'https://tripay.co.id/checkout/T4646029141615AUAM9', '1765546043', '2025-12-12', '1765547063', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1301, 'Tripay', '990342-251201121', 'ALFAMART', '', '170', '105020109', '251201121', 'T4646029141653G5J4W', 'https://tripay.co.id/checkout/T4646029141653G5J4W', '1765546140', '2025-12-12', '1765549860', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1302, 'Tripay', '489313-251201414', 'INDOMARET', '', '507', '105020255', '251201414', 'T4646029141817HO8XM', 'https://tripay.co.id/checkout/T4646029141817HO8XM', '1765546498', '2025-12-12', '1765547518', '', 'PAID', '126750', '1765546667', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1303, 'Tripay', '489245-251201694', 'BCAVA', '', '797', '105020374', '251201694', 'T4646029141871RXYWA', 'https://tripay.co.id/checkout/T4646029141871RXYWA', '1765546617', '2025-12-12', '1765547637', '', 'PAID', '127750', '1765546694', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1304, 'Tripay', '907325-251201121', 'ALFAMART', '', '170', '105020109', '251201121', 'T4646029141956RUQTY', 'https://tripay.co.id/checkout/T4646029141956RUQTY', '1765546827', '2025-12-12', '1765550547', '', 'PAID', '126750', '1765547210', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1305, 'Tripay', '84956-251201611', 'INDOMARET', '', '713', '105020338', '251201611', 'T4646029143905IZAPQ', 'https://tripay.co.id/checkout/T4646029143905IZAPQ', '1765552583', '2025-12-12', '1765553603', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1306, 'Tripay', '898651-251201195', 'BCAVA', '', '261', '105020155', '251201195', 'T464602914404616HCQ', 'https://tripay.co.id/checkout/T464602914404616HCQ', '1765553215', '2025-12-12', '1765554235', '', 'PAID', '127750', '1765553260', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1307, 'Tripay', '236855-251201611', 'INDOMARET', '', '713', '105020338', '251201611', 'T46460291612405NJX6', 'https://tripay.co.id/checkout/T46460291612405NJX6', '1765627633', '2025-12-13', '1765628653', '', 'PAID', '126750', '1765627714', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1308, 'Tripay', '163476-251201470', 'BRIVA', '', '568', '105050018', '251201470', 'T4646029169606XXH6F', 'https://tripay.co.id/checkout/T4646029169606XXH6F', '1765674949', '2025-12-14', '1765678660', '', 'PAID', '127125', '1765674993', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1309, 'Tripay', '255390-251201558', 'OVO', '', '659', '105010231', '251201558', 'T46460291698215MFBD', 'https://tripay.co.id/checkout/T46460291698215MFBD', '1765675783', '2025-12-14', '1765676803', '', 'PAID', '126875', '1765675817', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1310, 'Tripay', '725067-251201634', 'INDOMARET', '', '737', '105010268', '251201634', 'T4646029170382AEJND', 'https://tripay.co.id/checkout/T4646029170382AEJND', '1765677700', '2025-12-14', '1765678719', '', 'PAID', '126750', '1765677756', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1311, 'Tripay', '743141-251201301', 'MANDIRIVA', '', '380', '105010140', '251201301', 'T4646029170823B9AKA', 'https://tripay.co.id/checkout/T4646029170823B9AKA', '1765679038', '2025-12-14', '1765682750', '', 'PAID', '167125', '1765679194', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1312, 'Tripay', '828070-251201002', 'DANA', '', '2', '105010001', '251201002', 'T4646029170831JSHVC', 'https://tripay.co.id/checkout/T4646029170831JSHVC', '1765679067', '2025-12-14', '1765680086', '', 'UNPAID', '165251', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1313, 'Tripay', '16131-251201002', 'ALFAMART', '', '2', '105010001', '251201002', 'T4646029170884Q7T0U', 'https://tripay.co.id/checkout/T4646029170884Q7T0U', '1765679268', '2025-12-14', '1765682988', '', 'UNPAID', '167001', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1314, 'Tripay', '17272-251201679', 'BNIVA', '', '782', '105010283', '251201679', 'T4646029171682BY3GH', 'https://tripay.co.id/checkout/T4646029171682BY3GH', '1765681841', '2025-12-14', '1765682853', '', 'PAID', '127125', '1765681915', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1315, 'Tripay', '270507-251201306', 'BCAVA', '', '387', '105010145', '251201306', 'T4646029171848TISLJ', 'https://tripay.co.id/checkout/T4646029171848TISLJ', '1765682320', '2025-12-14', '1765683340', '', 'PAID', '127750', '1765682395', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1316, 'Tripay', '71517-251201687', 'BCAVA', '', '790', '105010285', '251201687', 'T4646029171982O6RHM', 'https://tripay.co.id/checkout/T4646029171982O6RHM', '1765682689', '2025-12-14', '1765683708', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1317, 'Tripay', '239539-251201687', 'BCAVA', '', '790', '105010285', '251201687', 'T4646029172015UM8MM', 'https://tripay.co.id/checkout/T4646029172015UM8MM', '1765682816', '2025-12-14', '1765683836', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1318, 'Tripay', '772916-251201687', 'ALFAMART', '', '790', '105010285', '251201687', 'T4646029172174AA7GH', 'https://tripay.co.id/checkout/T4646029172174AA7GH', '1765683287', '2025-12-14', '1765687006', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1319, 'Tripay', '152124-251201751', 'BRIVA', '', '859', '105010310', '251201751', 'T4646029172662IOHEJ', 'https://tripay.co.id/checkout/T4646029172662IOHEJ', '1765684733', '2025-12-14', '1765688445', '', 'PAID', '57125', '1765684884', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1320, 'Tripay', '479648-251201178', 'QRIS2', '', '243', '105010096', '251201178', 'T46460291728144OK5Y', 'https://tripay.co.id/checkout/T46460291728144OK5Y', '1765685183', '2025-12-14', '1765685902', '', 'PAID', '125000', '1765685262', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1321, 'Tripay', '892424-251201696', 'BRIVA', '', '799', '105010287', '251201696', 'T4646029190663ZSOBT', 'https://tripay.co.id/checkout/T4646029190663ZSOBT', '1765758230', '2025-12-15', '1765761942', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1322, 'Tripay', '932688-251201270', 'DANA', '', '347', '105010132', '251201270', 'T4646029190980VIIOA', 'https://tripay.co.id/checkout/T4646029190980VIIOA', '1765759143', '2025-12-15', '1765760162', '', 'PAID', '125000', '1765759177', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1323, 'Tripay', '676319-251214001', 'INDOMARET', '', '902', '105020412', '251214001', 'T4646029198668Y297B', 'https://tripay.co.id/checkout/T4646029198668Y297B', '1765780016', '2025-12-15', '1765781036', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1324, 'Tripay', '371271-251214001', 'INDOMARET', '', '902', '105020412', '251214001', 'T4646029198909N6CSJ', 'https://tripay.co.id/checkout/T4646029198909N6CSJ', '1765780824', '2025-12-15', '1765781844', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1325, 'Tripay', '37442-251201564', 'ALFAMART', '', '665', '105010235', '251201564', 'T4646029199738GQOUS', 'https://tripay.co.id/checkout/T4646029199738GQOUS', '1765783370', '2025-12-15', '1765787090', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1326, 'Tripay', '375712-251201564', 'ALFAMART', '', '665', '105010235', '251201564', 'T4646029200219MVHDF', 'https://tripay.co.id/checkout/T4646029200219MVHDF', '1765784680', '2025-12-15', '1765788400', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1327, 'Tripay', '739640-251214001', 'INDOMARET', '', '902', '105020412', '251214001', 'T4646029203627EAOOJ', 'https://tripay.co.id/checkout/T4646029203627EAOOJ', '1765793249', '2025-12-15', '1765794269', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1328, 'Tripay', '108504-251214001', 'INDOMARET', '', '902', '105020412', '251214001', 'T4646029204360OZG7O', 'https://tripay.co.id/checkout/T4646029204360OZG7O', '1765795063', '2025-12-15', '1765796083', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1329, 'Tripay', '421495-251214001', 'INDOMARET', '', '902', '105020412', '251214001', 'T4646029204361WXTYD', 'https://tripay.co.id/checkout/T4646029204361WXTYD', '1765795063', '2025-12-15', '1765796083', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1330, 'Tripay', '303181-251214001', 'INDOMARET', '', '902', '105020412', '251214001', 'T4646029204423N2KGF', 'https://tripay.co.id/checkout/T4646029204423N2KGF', '1765795233', '2025-12-15', '1765796253', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1331, 'Tripay', '931808-251214001', 'INDOMARET', '', '902', '105020412', '251214001', 'T4646029204461M7EZW', 'https://tripay.co.id/checkout/T4646029204461M7EZW', '1765795344', '2025-12-15', '1765796364', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1332, 'Tripay', '658558-251214001', 'INDOMARET', '', '902', '105020412', '251214001', 'T4646029204916NTW2H', 'https://tripay.co.id/checkout/T4646029204916NTW2H', '1765796322', '2025-12-15', '1765797342', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1333, 'Tripay', '584944-251214001', 'INDOMARET', '', '902', '105020412', '251214001', 'T4646029205567Q38US', 'https://tripay.co.id/checkout/T4646029205567Q38US', '1765797785', '2025-12-15', '1765798805', '', 'PAID', '126750', '1765797891', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1334, 'Tripay', '99142-251201564', 'ALFAMART', '', '665', '105010235', '251201564', 'T4646029206402DM6TA', 'https://tripay.co.id/checkout/T4646029206402DM6TA', '1765799367', '2025-12-15', '1765803086', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1335, 'Tripay', '254774-251201564', 'ALFAMART', '', '665', '105010235', '251201564', 'T46460292065063ELUN', 'https://tripay.co.id/checkout/T46460292065063ELUN', '1765799568', '2025-12-15', '1765803288', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1336, 'Tripay', '928108-251201385', 'QRIS2', '', '477', '105020242', '251201385', 'T46460292113661QKJJ', 'https://tripay.co.id/checkout/T46460292113661QKJJ', '1765810069', '2025-12-15', '1765810789', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1337, 'Tripay', '113527-251201385', 'QRIS2', '', '477', '105020242', '251201385', 'T4646029212102FZDSJ', 'https://tripay.co.id/checkout/T4646029212102FZDSJ', '1765813181', '2025-12-15', '1765813901', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1338, 'Tripay', '28694-251201564', 'ALFAMART', '', '665', '105010235', '251201564', 'T46460292144144MLTL', 'https://tripay.co.id/checkout/T46460292144144MLTL', '1765835787', '2025-12-16', '1765839506', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1339, 'Tripay', '110591-251201552', 'BCAVA', '', '653', '105010225', '251201552', 'T4646029216961SHSAT', 'https://tripay.co.id/checkout/T4646029216961SHSAT', '1765846259', '2025-12-16', '1765847279', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1340, 'Tripay', '170586-251201552', 'BCAVA', '', '653', '105010225', '251201552', 'T4646029216975WGQYA', 'https://tripay.co.id/checkout/T4646029216975WGQYA', '1765846313', '2025-12-16', '1765847333', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1341, 'Tripay', '688639-251201552', 'BCAVA', '', '653', '105010225', '251201552', 'T4646029217940JUFRJ', 'https://tripay.co.id/checkout/T4646029217940JUFRJ', '1765849227', '2025-12-16', '1765850247', '', 'PAID', '127750', '1765850119', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1342, 'Tripay', '534593-251201564', 'ALFAMART', '', '665', '105010235', '251201564', 'T4646029236140RITKH', 'https://tripay.co.id/checkout/T4646029236140RITKH', '1765902741', '2025-12-16', '1765906461', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1343, 'Tripay', '503669-251201703', 'INDOMARET', '', '808', '105010290', '251201703', 'T4646029271849H17A7', 'https://tripay.co.id/checkout/T4646029271849H17A7', '1766056292', '2025-12-18', '1767200399', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1344, 'Tripay', '51613-251201703', 'ALFAMART', '', '808', '105010290', '251201703', 'T4646029271948UDFKM', 'https://tripay.co.id/checkout/T4646029271948UDFKM', '1766056536', '2025-12-18', '1766142816', '', 'PAID', '126750', '1766056762', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1345, 'Tripay', '4124-251201086', 'BCAVA', '', '131', '105020082', '251201086', 'T4646029317755YP4H2', 'https://tripay.co.id/checkout/T4646029317755YP4H2', '1766217959', '2025-12-20', '1766218978', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1346, 'Tripay', '825451-251201086', 'BCAVA', '', '131', '105020082', '251201086', 'T4646029317774XBS1O', 'https://tripay.co.id/checkout/T4646029317774XBS1O', '1766218010', '2025-12-20', '1766219030', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1347, 'Tripay', '456722-251201086', 'INDOMARET', '', '131', '105020082', '251201086', 'T4646029317874KCWHW', 'https://tripay.co.id/checkout/T4646029317874KCWHW', '1766218273', '2025-12-20', '1766219293', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1348, 'Tripay', '65651-251201086', 'INDOMARET', '', '131', '105020082', '251201086', 'T4646029323293V2BWH', 'https://tripay.co.id/checkout/T4646029323293V2BWH', '1766230967', '2025-12-20', '1766231987', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1349, 'Tripay', '934789-251201086', 'DANA', '', '131', '105020082', '251201086', 'T46460293235170MDOE', 'https://tripay.co.id/checkout/T46460293235170MDOE', '1766231345', '2025-12-20', '1766232364', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1350, 'Tripay', '797258-251201086', 'INDOMARET', '', '131', '105020082', '251201086', 'T4646029323538SWPAF', 'https://tripay.co.id/checkout/T4646029323538SWPAF', '1766231383', '2025-12-20', '1766232403', '', 'PAID', '126750', '1766231576', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1351, 'Tripay', '403394-251201130', 'DANA', '', '180', '105020115', '251201130', 'T4646029341057SLM28', 'https://tripay.co.id/checkout/T4646029341057SLM28', '1766292003', '2025-12-21', '1766293022', '', 'PAID', '125000', '1766292030', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1352, 'Tripay', '432161-251201077', 'BCAVA', '', '119', '105020073', '251201077', 'T4646029361995WVFBX', 'https://tripay.co.id/checkout/T4646029361995WVFBX', '1766374141', '2025-12-22', '1766375161', '', 'PAID', '127750', '1766374185', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1353, 'Tripay', '406099-251201385', 'QRIS2', '', '477', '105020242', '251201385', 'T4646029402372DCTLJ', 'https://tripay.co.id/checkout/T4646029402372DCTLJ', '1766546534', '2025-12-24', '1766547254', '', 'PAID', '125000', '1766546575', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1354, 'Tripay', '883175-251201165', 'BCAVA', '', '227', '105010090', '251201165', 'T46460294221584XNTR', 'https://tripay.co.id/checkout/T46460294221584XNTR', '1766629967', '2025-12-25', '1766630987', '', 'PAID', '127750', '1766630009', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1355, 'Tripay', '289284-251201510', 'SHOPEEPAY', '', '611', '105010215', '251201510', 'T4646029428035PM5WT', 'https://tripay.co.id/checkout/T4646029428035PM5WT', '1766648944', '2025-12-25', '1766649963', '', 'PAID', '126875', '1766648985', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1356, 'Tripay', '939301-251201541', 'QRIS2', '', '642', '105020313', '251201541', 'T4646029454529OZOB5', 'https://tripay.co.id/checkout/T4646029454529OZOB5', '1766754157', '2025-12-26', '1766754876', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1357, 'Tripay', '978481-251201600', 'DANA', '', '702', '105010253', '251201600', 'T4646029486210YN09V', 'https://tripay.co.id/checkout/T4646029486210YN09V', '1766913882', '2025-12-28', '1766914901', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1358, 'Tripay', '444053-260101755', 'QRIS', '', '850', '105010306', '260101755', 'T4646029563860JXBFS', 'https://tripay.co.id/checkout/T4646029563860JXBFS', '1767209458', '2026-01-01', '1767210178', '', 'PAID', '125812', '1767209585', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1359, 'Tripay', '792644-260101601', 'MANDIRIVA', '', '690', '105010248', '260101601', 'T4646029566766VZSD1', 'https://tripay.co.id/checkout/T4646029566766VZSD1', '1767227861', '2026-01-01', '1767231580', '', 'PAID', '127125', '1767227973', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1360, 'Tripay', '390614-260101329', 'BCAVA', '', '400', '105010151', '260101329', 'T4646029566790CGMMX', 'https://tripay.co.id/checkout/T4646029566790CGMMX', '1767227910', '2026-01-01', '1767228930', '', 'PAID', '207750', '1767228150', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1361, 'Tripay', '349679-260101765', 'BRIVA', '', '860', '105030101', '260101765', 'T4646029568802JCFLE', 'https://tripay.co.id/checkout/T4646029568802JCFLE', '1767232435', '2026-01-01', '1767236154', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1362, 'Tripay', '840791-260101765', 'BRIVA', '', '860', '105030101', '260101765', 'T4646029568973AOE6W', 'https://tripay.co.id/checkout/T4646029568973AOE6W', '1767232798', '2026-01-01', '1767236517', '', 'PAID', '127125', '1767232848', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1363, 'Tripay', '766068-260101180', 'BCAVA', '', '237', '105020144', '260101180', 'T4646029569439TMCXJ', 'https://tripay.co.id/checkout/T4646029569439TMCXJ', '1767233609', '2026-01-01', '1767234628', '', 'PAID', '127750', '1767233743', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1364, 'Tripay', '323483-260101851', 'MANDIRIVA', '', '948', '105020431', '260101851', 'T46460295699864TJIG', 'https://tripay.co.id/checkout/T46460295699864TJIG', '1767234508', '2026-01-01', '1767238227', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1365, 'Tripay', '225077-260101851', 'SHOPEEPAY', '', '948', '105020431', '260101851', 'T4646029570016WNIJZ', 'https://tripay.co.id/checkout/T4646029570016WNIJZ', '1767234547', '2026-01-01', '1767235566', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1366, 'Tripay', '308956-260101851', 'MANDIRIVA', '', '948', '105020431', '260101851', 'T4646029570076S5I8G', 'https://tripay.co.id/checkout/T4646029570076S5I8G', '1767234645', '2026-01-01', '1767238364', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1367, 'Tripay', '667382-260101753', 'QRIS2', '', '848', '105010305', '260101753', 'T4646029570227ADGQY', 'https://tripay.co.id/checkout/T4646029570227ADGQY', '1767234885', '2026-01-01', '1767235605', '', 'PAID', '125000', '1767234924', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1368, 'Tripay', '595354-260101573', 'BSIVA', '', '661', '105020318', '260101573', 'T4646029571278KJ3X5', 'https://tripay.co.id/checkout/T4646029571278KJ3X5', '1767236603', '2026-01-01', '1767240322', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1369, 'Tripay', '969319-260101573', 'BSIVA', '', '661', '105020318', '260101573', 'T4646029571388AA4BO', 'https://tripay.co.id/checkout/T4646029571388AA4BO', '1767236767', '2026-01-01', '1767240487', '', 'PAID', '127125', '1767236839', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1370, 'Tripay', '191302-260101251', 'BRIVA', '', '318', '105030019', '260101251', 'T4646029572560ZIOCE', 'https://tripay.co.id/checkout/T4646029572560ZIOCE', '1767238604', '2026-01-01', '1767242324', '', 'PAID', '127125', '1767238649', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1371, 'Tripay', '18764-260101593', 'BRIVA', '', '682', '105010243', '260101593', 'T4646029572918MXP64', 'https://tripay.co.id/checkout/T4646029572918MXP64', '1767239102', '2026-01-01', '1767242822', '', 'PAID', '127125', '1767239129', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1372, 'Tripay', '234317-260101112', 'QRIS2', '', '156', '105010058', '260101112', 'T4646029572988C4FUA', 'https://tripay.co.id/checkout/T4646029572988C4FUA', '1767239216', '2026-01-01', '1767239936', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1373, 'Tripay', '545990-260101112', 'QRIS2', '', '156', '105010058', '260101112', 'T4646029573007QPYLL', 'https://tripay.co.id/checkout/T4646029573007QPYLL', '1767239243', '2026-01-01', '1767239963', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1374, 'Tripay', '485205-260101299', 'QRIS2', '', '367', '105020200', '260101299', 'T4646029573141SHAWV', 'https://tripay.co.id/checkout/T4646029573141SHAWV', '1767239478', '2026-01-01', '1767240197', '', 'PAID', '165000', '1767239543', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1375, 'Tripay', '531317-260101612', 'BCAVA', '', '701', '105020334', '260101612', 'T4646029575368ZWPIC', 'https://tripay.co.id/checkout/T4646029575368ZWPIC', '1767243153', '2026-01-01', '1767244173', '', 'PAID', '167750', '1767243298', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1376, 'Tripay', '990810-260101257', 'BRIVA', '', '324', '105030021', '260101257', 'T4646029575630DWO6W', 'https://tripay.co.id/checkout/T4646029575630DWO6W', '1767243535', '2026-01-01', '1767247255', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1377, 'Tripay', '78871-260101546', 'DANA', '', '634', '105020307', '260101546', 'T4646029575924670QE', 'https://tripay.co.id/checkout/T4646029575924670QE', '1767244067', '2026-01-01', '1767245086', '', 'PAID', '125000', '1767244115', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1378, 'Tripay', '240312-260101310', 'BRIVA', '', '379', '105020207', '260101310', 'T4646029578619QVSVC', 'https://tripay.co.id/checkout/T4646029578619QVSVC', '1767248607', '2026-01-01', '1767252327', '', 'PAID', '127125', '1767248664', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1379, 'Tripay', '847017-260101257', 'BRIVA', '', '324', '105030021', '260101257', 'T4646029578762VXNCM', 'https://tripay.co.id/checkout/T4646029578762VXNCM', '1767248846', '2026-01-01', '1767252566', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1380, 'Tripay', '689159-260101822', 'BCAVA', '', '919', '105020420', '260101822', 'T4646029579555XW2QB', 'https://tripay.co.id/checkout/T4646029579555XW2QB', '1767250494', '2026-01-01', '1767251514', '', 'UNPAID', '77750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1381, 'Tripay', '279010-260101822', 'ALFAMART', '', '919', '105020420', '260101822', 'T4646029579750CBME7', 'https://tripay.co.id/checkout/T4646029579750CBME7', '1767250899', '2026-01-01', '1767254618', '', 'UNPAID', '76750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1382, 'Tripay', '599940-260101822', 'SHOPEEPAY', '', '919', '105020420', '260101822', 'T4646029579768XFCIS', 'https://tripay.co.id/checkout/T4646029579768XFCIS', '1767250944', '2026-01-01', '1767251964', '', 'UNPAID', '76125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1383, 'Tripay', '60636-260101822', 'QRIS', '', '919', '105020420', '260101822', 'T4646029579792ZLCAJ', 'https://tripay.co.id/checkout/T4646029579792ZLCAJ', '1767250985', '2026-01-01', '1767251705', '', 'UNPAID', '75637', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1384, 'Tripay', '747276-260101822', 'DANA', '', '919', '105020420', '260101822', 'T4646029579825CC0JT', 'https://tripay.co.id/checkout/T4646029579825CC0JT', '1767251048', '2026-01-01', '1767252068', '', 'UNPAID', '75000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1385, 'Tripay', '653832-260101333', 'INDOMARET', '', '404', '105020217', '260101333', 'T4646029579849XNNM6', 'https://tripay.co.id/checkout/T4646029579849XNNM6', '1767251087', '2026-01-01', '1767252107', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1386, 'Tripay', '965171-260101864', 'BCAVA', '', '961', '105020437', '260101864', 'T4646029579919PXYAP', 'https://tripay.co.id/checkout/T4646029579919PXYAP', '1767251201', '2026-01-01', '1767252221', '', 'UNPAID', '52750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1387, 'Tripay', '906445-260101822', 'INDOMARET', '', '919', '105020420', '260101822', 'T4646029580005JMCOW', 'https://tripay.co.id/checkout/T4646029580005JMCOW', '1767251404', '2026-01-01', '1767252424', '', 'UNPAID', '76750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1388, 'Tripay', '864984-260101822', 'BCAVA', '', '919', '105020420', '260101822', 'T46460295800126N0IJ', 'https://tripay.co.id/checkout/T46460295800126N0IJ', '1767251420', '2026-01-01', '1767252440', '', 'UNPAID', '77750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1389, 'Tripay', '37837-260101822', 'SHOPEEPAY', '', '919', '105020420', '260101822', 'T4646029580026KPAVK', 'https://tripay.co.id/checkout/T4646029580026KPAVK', '1767251448', '2026-01-01', '1767252468', '', 'UNPAID', '76125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1390, 'Tripay', '119303-260101822', 'DANA', '', '919', '105020420', '260101822', 'T4646029580039LUSWB', 'https://tripay.co.id/checkout/T4646029580039LUSWB', '1767251469', '2026-01-01', '1767252488', '', 'UNPAID', '75000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1391, 'Tripay', '698937-260101822', 'SHOPEEPAY', '', '919', '105020420', '260101822', 'T4646029580172HDCMV', 'https://tripay.co.id/checkout/T4646029580172HDCMV', '1767251758', '2026-01-01', '1767252777', '', 'UNPAID', '76125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1392, 'Tripay', '424782-260101822', 'QRIS', '', '919', '105020420', '260101822', 'T4646029580193RGJVF', 'https://tripay.co.id/checkout/T4646029580193RGJVF', '1767251774', '2026-01-01', '1767252493', '', 'UNPAID', '75637', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1393, 'Tripay', '743038-260101822', 'QRIS2', '', '919', '105020420', '260101822', 'T4646029580216VNNWQ', 'https://tripay.co.id/checkout/T4646029580216VNNWQ', '1767251821', '2026-01-01', '1767252541', '', 'UNPAID', '75000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1394, 'Tripay', '4433-260101822', 'QRIS', '', '919', '105020420', '260101822', 'T4646029580657LLQWC', 'https://tripay.co.id/checkout/T4646029580657LLQWC', '1767252651', '2026-01-01', '1767253370', '', 'UNPAID', '75637', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1395, 'Tripay', '489340-260101822', 'QRIS', '', '919', '105020420', '260101822', 'T4646029580753KBHKI', 'https://tripay.co.id/checkout/T4646029580753KBHKI', '1767252845', '2026-01-01', '1767253565', '', 'UNPAID', '75637', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1396, 'Tripay', '223231-260101822', 'QRIS', '', '919', '105020420', '260101822', 'T4646029580769CDFJI', 'https://tripay.co.id/checkout/T4646029580769CDFJI', '1767252882', '2026-01-01', '1767253602', '', 'UNPAID', '75637', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1397, 'Tripay', '53454-260101193', 'QRIS2', '', '251', '105020152', '260101193', 'T4646029581076T4QHQ', 'https://tripay.co.id/checkout/T4646029581076T4QHQ', '1767253437', '2026-01-01', '1767254156', '', 'PAID', '125000', '1767253462', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1398, 'Tripay', '745354-260101333', 'INDOMARET', '', '404', '105020217', '260101333', 'T4646029581435ERTQ7', 'https://tripay.co.id/checkout/T4646029581435ERTQ7', '1767254170', '2026-01-01', '1767255189', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1399, 'Tripay', '990393-260101864', 'BCAVA', '', '961', '105020437', '260101864', 'T4646029581657E8TOD', 'https://tripay.co.id/checkout/T4646029581657E8TOD', '1767254649', '2026-01-01', '1767255668', '', 'PAID', '52750', '1767254819', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1400, 'Tripay', '161210-260101847', 'QRIS2', '', '944', '105010334', '260101847', 'T46460295818858QQF7', 'https://tripay.co.id/checkout/T46460295818858QQF7', '1767255042', '2026-01-01', '1767255762', '', 'UNPAID', '55000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1401, 'Tripay', '681202-260101333', 'ALFAMART', '', '404', '105020217', '260101333', 'T4646029581920OTEK5', 'https://tripay.co.id/checkout/T4646029581920OTEK5', '1767255116', '2026-01-01', '1767258836', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1402, 'Tripay', '288964-260101441', 'ALFAMART', '', '521', '105020263', '260101441', 'T4646029581980CWIGR', 'https://tripay.co.id/checkout/T4646029581980CWIGR', '1767255273', '2026-01-01', '1767258992', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1403, 'Tripay', '366133-260101628', 'BRIVA', '', '717', '105010261', '260101628', 'T4646029582039QQLUG', 'https://tripay.co.id/checkout/T4646029582039QQLUG', '1767255399', '2026-01-01', '1767259119', '', 'PAID', '127125', '1767255438', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1404, 'Tripay', '899147-260101156', 'MANDIRIVA', '', '209', '105020130', '260101156', 'T4646029582104AZQG8', 'https://tripay.co.id/checkout/T4646029582104AZQG8', '1767255539', '2026-01-01', '1767259259', '', 'PAID', '127125', '1767255670', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1405, 'Tripay', '739963-260101847', 'INDOMARET', '', '944', '105010334', '260101847', 'T4646029582291WCUCH', 'https://tripay.co.id/checkout/T4646029582291WCUCH', '1767255901', '2026-01-01', '1767256921', '', 'UNPAID', '56750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1406, 'Tripay', '904355-260101441', 'ALFAMART', '', '521', '105020263', '260101441', 'T4646029582560WXPKD', 'https://tripay.co.id/checkout/T4646029582560WXPKD', '1767256464', '2026-01-01', '1767342743', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1407, 'Tripay', '491705-260101441', 'ALFAMART', '', '521', '105020263', '260101441', 'T4646029582597LNEFO', 'https://tripay.co.id/checkout/T4646029582597LNEFO', '1767256538', '2026-01-01', '1767260258', '', 'PAID', '126750', '1767256589', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1408, 'Tripay', '468433-260101847', 'QRIS2', '', '944', '105010334', '260101847', 'T4646029583261TRIZY', 'https://tripay.co.id/checkout/T4646029583261TRIZY', '1767257930', '2026-01-01', '1767258650', '', 'UNPAID', '55000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1409, 'Tripay', '569949-260101847', 'MANDIRIVA', '', '944', '105010334', '260101847', 'T4646029583317JZW63', 'https://tripay.co.id/checkout/T4646029583317JZW63', '1767258040', '2026-01-01', '1767261760', '', 'PAID', '57125', '1767259002', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1410, 'Tripay', '885231-260101153', 'QRIS2', '', '205', '105010077', '260101153', 'T4646029583874XYVXM', 'https://tripay.co.id/checkout/T4646029583874XYVXM', '1767259188', '2026-01-01', '1767259907', '', 'PAID', '125000', '1767259346', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1411, 'Tripay', '325145-260101430', 'QRIS2', '', '510', '105010189', '260101430', 'T4646029585072EVETC', 'https://tripay.co.id/checkout/T4646029585072EVETC', '1767261706', '2026-01-01', '1767262425', '', 'PAID', '125000', '1767261851', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1412, 'Tripay', '739491-260101001', 'MANDIRIVA', '', '1', '105020001', '260101001', 'T46460295851619BQ5K', 'https://tripay.co.id/checkout/T46460295851619BQ5K', '1767261870', '2026-01-01', '1767265582', '', 'PAID', '207125', '1767261920', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1413, 'Tripay', '280958-260101831', 'BCAVA', '', '928', '105020423', '260101831', 'T4646029585558VOIL6', 'https://tripay.co.id/checkout/T4646029585558VOIL6', '1767262523', '2026-01-01', '1767263543', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1414, 'Tripay', '265002-260101831', 'QRIS2', '', '928', '105020423', '260101831', 'T4646029585575INFBQ', 'https://tripay.co.id/checkout/T4646029585575INFBQ', '1767262575', '2026-01-01', '1767263294', '', 'PAID', '125000', '1767262655', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1415, 'Tripay', '357508-260101724', 'INDOMARET', '', '819', '105050041', '260101724', 'T4646029587285PK3RL', 'https://tripay.co.id/checkout/T4646029587285PK3RL', '1767265581', '2026-01-01', '1767266601', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1416, 'Tripay', '411514-260101874', 'INDOMARET', '', '971', '105020445', '260101874', 'T4646029588142DMRJ4', 'https://tripay.co.id/checkout/T4646029588142DMRJ4', '1767267013', '2026-01-01', '1767268033', '', 'UNPAID', '31750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1417, 'Tripay', '105994-260101874', 'INDOMARET', '', '971', '105020445', '260101874', 'T4646029589116PW4QQ', 'https://tripay.co.id/checkout/T4646029589116PW4QQ', '1767268666', '2026-01-01', '1767269686', '', 'PAID', '31750', '1767269263', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1418, 'Tripay', '296541-260101456', 'INDOMARET', '', '536', '105030062', '260101456', 'T4646029589431HVNKK', 'https://tripay.co.id/checkout/T4646029589431HVNKK', '1767269161', '2026-01-01', '1767270180', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1419, 'Tripay', '991092-260101132', 'INDOMARET', '', '177', '105010065', '260101132', 'T4646029596874ES0TL', 'https://tripay.co.id/checkout/T4646029596874ES0TL', '1767284535', '2026-01-01', '1767285555', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1420, 'Tripay', '454454-260101111', 'QRIS2', '', '155', '105010057', '260101111', 'T46460296007853OULM', 'https://tripay.co.id/checkout/T46460296007853OULM', '1767304309', '2026-01-02', '1767305029', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1421, 'Tripay', '427604-260101757', 'BNIVA', '', '852', '105010307', '260101757', 'T4646029602693FHIPB', 'https://tripay.co.id/checkout/T4646029602693FHIPB', '1767312339', '2026-01-02', '1767313351', '', 'PAID', '127125', '1767312450', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1422, 'Tripay', '764611-260101863', 'SHOPEEPAY', '', '960', '105030114', '260101863', 'T4646029605377YSIQJ', 'https://tripay.co.id/checkout/T4646029605377YSIQJ', '1767318067', '2026-01-02', '1767319087', '', 'UNPAID', '50750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1423, 'Tripay', '808072-260101825', 'INDOMARET', '', '922', '105030106', '260101825', 'T4646029605578Y3IHA', 'https://tripay.co.id/checkout/T4646029605578Y3IHA', '1767318336', '2026-01-02', '1767319356', '', 'PAID', '72750', '1767319239', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1424, 'Tripay', '393912-260101738', 'BCAVA', '', '833', '105020387', '260101738', 'T4646029607103D8SYG', 'https://tripay.co.id/checkout/T4646029607103D8SYG', '1767320906', '2026-01-02', '1767321926', '', 'PAID', '127750', '1767320993', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1425, 'Tripay', '546690-260101830', 'QRIS2', '', '927', '105010329', '260101830', 'T4646029607306WIHKM', 'https://tripay.co.id/checkout/T4646029607306WIHKM', '1767321228', '2026-01-02', '1767321948', '', 'PAID', '125000', '1767321260', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1426, 'Tripay', '111905-260101576', 'DANA', '', '664', '105010234', '260101576', 'T4646029607396QNU0X', 'https://tripay.co.id/checkout/T4646029607396QNU0X', '1767321379', '2026-01-02', '1767322398', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1427, 'Tripay', '484901-260101576', 'BSIVA', '', '664', '105010234', '260101576', 'T4646029607468QSUON', 'https://tripay.co.id/checkout/T4646029607468QSUON', '1767321494', '2026-01-02', '1767325215', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1428, 'Tripay', '511696-260101826', 'INDOMARET', '', '923', '105030107', '260101826', 'T46460296084847YFXV', 'https://tripay.co.id/checkout/T46460296084847YFXV', '1767323138', '2026-01-02', '1767324158', '', 'UNPAID', '64750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1429, 'Tripay', '942450-260101742', 'BCAVA', '', '837', '105010300', '260101742', 'T4646029608515ZHR06', 'https://tripay.co.id/checkout/T4646029608515ZHR06', '1767323199', '2026-01-02', '1767324219', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1430, 'Tripay', '865005-260101742', 'BCAVA', '', '837', '105010300', '260101742', 'T4646029609530B9GNI', 'https://tripay.co.id/checkout/T4646029609530B9GNI', '1767324871', '2026-01-02', '1767325891', '', 'PAID', '127750', '1767324927', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1431, 'Tripay', '307613-260101863', 'SHOPEEPAY', '', '960', '105030114', '260101863', 'T4646029609742PZY3K', 'https://tripay.co.id/checkout/T4646029609742PZY3K', '1767325172', '2026-01-02', '1767326192', '', 'PAID', '50750', '1767325274', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1432, 'Tripay', '765609-260101826', 'BRIVA', '', '923', '105030107', '260101826', 'T4646029609913QB1DT', 'https://tripay.co.id/checkout/T4646029609913QB1DT', '1767325425', '2026-01-02', '1767329138', '', 'PAID', '65125', '1767325469', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1433, 'Tripay', '968742-260101486', 'QRIS2', '', '571', '105020282', '260101486', 'T46460296101361YKB7', 'https://tripay.co.id/checkout/T46460296101361YKB7', '1767325761', '2026-01-02', '1767326481', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1434, 'Tripay', '326546-260101489', 'QRIS2', '', '574', '105020284', '260101489', 'T4646029610233WKJJA', 'https://tripay.co.id/checkout/T4646029610233WKJJA', '1767325917', '2026-01-02', '1767326636', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1435, 'Tripay', '682540-260101682', 'MANDIRIVA', '', '772', '105030089', '260101682', 'T4646029611209ARDIO', 'https://tripay.co.id/checkout/T4646029611209ARDIO', '1767327457', '2026-01-02', '1767331169', '', 'PAID', '127125', '1767327580', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1436, 'Tripay', '567391-260101531', 'DANA', '', '619', '105010220', '260101531', 'T4646029611210ZRIFC', 'https://tripay.co.id/checkout/T4646029611210ZRIFC', '1767327458', '2026-01-02', '1767328477', '', 'PAID', '125000', '1767327499', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1437, 'Tripay', '558917-260101063', 'QRIS2', '', '94', '105020057', '260101063', 'T4646029612285JFKV8', 'https://tripay.co.id/checkout/T4646029612285JFKV8', '1767329402', '2026-01-02', '1767330122', '', 'PAID', '125000', '1767329479', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1438, 'Tripay', '910610-260101759', 'BCAVA', '', '854', '105010308', '260101759', 'T4646029613058XTLLE', 'https://tripay.co.id/checkout/T4646029613058XTLLE', '1767330968', '2026-01-02', '1767331988', '', 'PAID', '127750', '1767331017', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1439, 'Tripay', '209140-260101610', 'QRIS2', '', '699', '105030086', '260101610', 'T4646029613144HZT0A', 'https://tripay.co.id/checkout/T4646029613144HZT0A', '1767331205', '2026-01-02', '1767331925', '', 'PAID', '125000', '1767331306', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1440, 'Tripay', '626251-260101736', 'BRIVA', '', '831', '105020386', '260101736', 'T4646029613380U83TT', 'https://tripay.co.id/checkout/T4646029613380U83TT', '1767331717', '2026-01-02', '1767335429', '', 'PAID', '167125', '1767331872', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1441, 'Tripay', '293487-260101475', 'DANA', '', '558', '105030065', '260101475', 'T4646029616030C7UAH', 'https://tripay.co.id/checkout/T4646029616030C7UAH', '1767336523', '2026-01-02', '1767337543', '', 'PAID', '125000', '1767336717', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1442, 'Tripay', '127835-260101076', 'BCAVA', '', '111', '105020067', '260101076', 'T4646029616248IT1K7', 'https://tripay.co.id/checkout/T4646029616248IT1K7', '1767336919', '2026-01-02', '1767337939', '', 'UNPAID', '137750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1443, 'Tripay', '466816-260101076', 'DANA', '', '111', '105020067', '260101076', 'T4646029616298CG6U3', 'https://tripay.co.id/checkout/T4646029616298CG6U3', '1767337028', '2026-01-02', '1767338048', '', 'PAID', '135000', '1767337392', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1444, 'Tripay', '26290-260101528', 'INDOMARET', '', '616', '105010217', '260101528', 'T4646029617270LYPCI', 'https://tripay.co.id/checkout/T4646029617270LYPCI', '1767339082', '2026-01-02', '1767340102', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1445, 'Tripay', '233124-260101646', 'BRIVA', '', '736', '105050032', '260101646', 'T4646029617663RNFLP', 'https://tripay.co.id/checkout/T4646029617663RNFLP', '1767339945', '2026-01-02', '1767343657', '', 'PAID', '127125', '1767339986', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1446, 'Tripay', '262708-260101435', 'INDOMARET', '', '515', '105020260', '260101435', 'T4646029617735JGOFW', 'https://tripay.co.id/checkout/T4646029617735JGOFW', '1767340062', '2026-01-02', '1767341081', '', 'PAID', '126750', '1767340135', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1447, 'Tripay', '601942-260101301', 'BSIVA', '', '369', '105030031', '260101301', 'T4646029618110CXRTR', 'https://tripay.co.id/checkout/T4646029618110CXRTR', '1767340755', '2026-01-02', '1767344467', '', 'PAID', '127125', '1767340831', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1448, 'Tripay', '29084-260101439', 'BRIVA', '', '519', '105030056', '260101439', 'T4646029618232GSMPC', 'https://tripay.co.id/checkout/T4646029618232GSMPC', '1767341023', '2026-01-02', '1767344743', '', 'PAID', '127125', '1767341117', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1449, 'Tripay', '937152-260101325', 'BCAVA', '', '396', '105020213', '260101325', 'T4646029618472NMGD9', 'https://tripay.co.id/checkout/T4646029618472NMGD9', '1767341530', '2026-01-02', '1767342550', '', 'PAID', '167750', '1767341643', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1450, 'Tripay', '377502-260101580', 'BRIVA', '', '669', '105010239', '260101580', 'T4646029618694IENOJ', 'https://tripay.co.id/checkout/T4646029618694IENOJ', '1767341941', '2026-01-02', '1767345654', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1451, 'Tripay', '732485-260101580', 'BRIVA', '', '669', '105010239', '260101580', 'T4646029618695NALON', 'https://tripay.co.id/checkout/T4646029618695NALON', '1767341942', '2026-01-02', '1767345662', '', 'PAID', '127125', '1767342185', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1452, 'Tripay', '318487-260101580', 'BRIVA', '', '669', '105010239', '260101580', 'T4646029618757SOCNW', 'https://tripay.co.id/checkout/T4646029618757SOCNW', '1767342064', '2026-01-02', '1767345783', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1453, 'Tripay', '442867-251201600', 'BRIVA', '', '702', '105010253', '251201600', 'T4646029619049F9KVP', 'https://tripay.co.id/checkout/T4646029619049F9KVP', '1767342627', '2026-01-02', '1767346338', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1454, 'Tripay', '88686-260101713', 'QRIS2', '', '803', '105010289', '260101713', 'T4646029619098DVK9F', 'https://tripay.co.id/checkout/T4646029619098DVK9F', '1767342727', '2026-01-02', '1767343447', '', 'PAID', '125000', '1767342814', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1455, 'Tripay', '360663-251201600', 'ALFAMIDI', '', '702', '105010253', '251201600', 'T4646029619114MSSOA', 'https://tripay.co.id/checkout/T4646029619114MSSOA', '1767342760', '2026-01-02', '1767346479', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1456, 'Tripay', '154924-251201600', 'ALFAMIDI', '', '702', '105010253', '251201600', 'T4646029619149TYR1B', 'https://tripay.co.id/checkout/T4646029619149TYR1B', '1767342825', '2026-01-02', '1767346545', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1457, 'Tripay', '589754-251201600', 'ALFAMIDI', '', '702', '105010253', '251201600', 'T4646029619166E7QVX', 'https://tripay.co.id/checkout/T4646029619166E7QVX', '1767342872', '2026-01-02', '1767346592', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1458, 'Tripay', '396619-251201600', 'ALFAMIDI', '', '702', '105010253', '251201600', 'T4646029619187VR7KB', 'https://tripay.co.id/checkout/T4646029619187VR7KB', '1767342933', '2026-01-02', '1767346652', '', 'PAID', '126750', '1767343077', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1459, 'Tripay', '220855-260101040', 'BCAVA', '', '58', '105020035', '260101040', 'T4646029619468KWRHL', 'https://tripay.co.id/checkout/T4646029619468KWRHL', '1767343506', '2026-01-02', '1767344525', '', 'PAID', '127750', '1767343767', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1460, 'Tripay', '728291-260101218', 'QRIS', '', '282', '105030015', '260101218', 'T4646029620775LYMYZ', 'https://tripay.co.id/checkout/T4646029620775LYMYZ', '1767346080', '2026-01-02', '1767346800', '', 'PAID', '125812', '1767346120', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1461, 'Tripay', '592339-260101821', 'BRIVA', '', '918', '105010325', '260101821', 'T4646029622336VFZII', 'https://tripay.co.id/checkout/T4646029622336VFZII', '1767349018', '2026-01-02', '1767352730', '', 'PAID', '82125', '1767349089', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1462, 'Tripay', '928323-260101245', 'INDOMARET', '', '312', '105030018', '260101245', 'T46460296235580WZDN', 'https://tripay.co.id/checkout/T46460296235580WZDN', '1767351174', '2026-01-02', '1767352194', '', 'PAID', '126750', '1767351424', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1463, 'Tripay', '905337-260101391', 'QRIS2', '', '469', '105050010', '260101391', 'T4646029623842DOI8C', 'https://tripay.co.id/checkout/T4646029623842DOI8C', '1767351705', '2026-01-02', '1767352425', '', 'PAID', '125000', '1767351882', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1464, 'Tripay', '170024-260101300', 'QRIS2', '', '368', '105020201', '260101300', 'T46460296238997Q7QC', 'https://tripay.co.id/checkout/T46460296238997Q7QC', '1767351858', '2026-01-02', '1767352577', '', 'PAID', '165000', '1767351909', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1465, 'Tripay', '637103-260101868', 'BRIVA', '', '965', '105030115', '260101868', 'T4646029625274FPFLM', 'https://tripay.co.id/checkout/T4646029625274FPFLM', '1767354410', '2026-01-02', '1767358129', '', 'UNPAID', '48125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1466, 'Tripay', '870765-260101355', 'MANDIRIVA', '', '430', '105020224', '260101355', 'T4646029625459JW22D', 'https://tripay.co.id/checkout/T4646029625459JW22D', '1767354706', '2026-01-02', '1767358426', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1467, 'Tripay', '483574-260101868', 'QRIS2', '', '965', '105030115', '260101868', 'T4646029627710AEU3X', 'https://tripay.co.id/checkout/T4646029627710AEU3X', '1767358506', '2026-01-02', '1767359226', '', 'PAID', '46000', '1767358597', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1468, 'Tripay', '42204-260101098', 'ALFAMART', '', '140', '105020089', '260101098', 'T46460296284105FNXM', 'https://tripay.co.id/checkout/T46460296284105FNXM', '1767359692', '2026-01-02', '1767363411', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1469, 'Tripay', '955126-260101098', 'ALFAMART', '', '140', '105020089', '260101098', 'T4646029628449CE7L7', 'https://tripay.co.id/checkout/T4646029628449CE7L7', '1767359745', '2026-01-02', '1767363465', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1470, 'Tripay', '855710-260101242', 'INDOMARET', '', '309', '105020175', '260101242', 'T46460296287865SQX7', 'https://tripay.co.id/checkout/T46460296287865SQX7', '1767360342', '2026-01-02', '1767361362', '', 'PAID', '126750', '1767361173', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1471, 'Tripay', '162941-260101733', 'QRIS2', '', '828', '105020384', '260101733', 'T4646029628820HOWAR', 'https://tripay.co.id/checkout/T4646029628820HOWAR', '1767360369', '2026-01-02', '1767361088', '', 'PAID', '125000', '1767360451', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1472, 'Tripay', '745948-260101262', 'INDOMARET', '', '329', '105010126', '260101262', 'T4646029629144M4HTQ', 'https://tripay.co.id/checkout/T4646029629144M4HTQ', '1767360978', '2026-01-02', '1767361998', '', 'PAID', '126750', '1767361516', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1473, 'Tripay', '232709-260101509', 'MANDIRIVA', '', '595', '105050022', '260101509', 'T4646029629727G3C6K', 'https://tripay.co.id/checkout/T4646029629727G3C6K', '1767362153', '2026-01-02', '1767365866', '', 'PAID', '127125', '1767362290', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1474, 'Tripay', '432947-260101422', 'BCAVA', '', '502', '105010188', '260101422', 'T4646029630152RMXER', 'https://tripay.co.id/checkout/T4646029630152RMXER', '1767363080', '2026-01-02', '1767364100', '', 'PAID', '167750', '1767363144', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1475, 'Tripay', '114510-260101845', 'INDOMARET', '', '942', '105030110', '260101845', 'T4646029630160ITBOD', 'https://tripay.co.id/checkout/T4646029630160ITBOD', '1767363111', '2026-01-02', '1767364131', '', 'UNPAID', '56750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1476, 'Tripay', '790204-260101845', 'INDOMARET', '', '942', '105030110', '260101845', 'T4646029630331HJ8FK', 'https://tripay.co.id/checkout/T4646029630331HJ8FK', '1767363569', '2026-01-02', '1767364589', '', 'PAID', '56750', '1767363616', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1477, 'Tripay', '373217-260101842', 'BRIVA', '', '939', '105030108', '260101842', 'T4646029630712NISUM', 'https://tripay.co.id/checkout/T4646029630712NISUM', '1767364439', '2026-01-02', '1767368151', '', 'PAID', '127125', '1767364714', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1478, 'Tripay', '690359-251201110', 'BRIVA', '', '158', '105010060', '251201110', 'T4646029631392NGWIF', 'https://tripay.co.id/checkout/T4646029631392NGWIF', '1767366188', '2026-01-02', '1767369907', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1479, 'Tripay', '103511-260101635', 'QRIS2', '', '725', '105010265', '260101635', 'T464602963539672U7U', 'https://tripay.co.id/checkout/T464602963539672U7U', '1767394410', '2026-01-03', '1767395130', '', 'PAID', '165000', '1767394465', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1480, 'Tripay', '483097-260101106', 'INDOMARET', '', '149', '105010053', '260101106', 'T4646029635569Y0SBP', 'https://tripay.co.id/checkout/T4646029635569Y0SBP', '1767395290', '2026-01-03', '1767396310', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1481, 'Tripay', '63872-260101745', 'BRIVA', '', '840', '105030098', '260101745', 'T46460296355710ALET', 'https://tripay.co.id/checkout/T46460296355710ALET', '1767395299', '2026-01-03', '1767399011', '', 'PAID', '167125', '1767395373', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1482, 'Tripay', '53402-260101407', 'INDOMARET', '', '487', '105020245', '260101407', 'T4646029637328KM2OE', 'https://tripay.co.id/checkout/T4646029637328KM2OE', '1767401073', '2026-01-03', '1767402093', '', 'PAID', '126750', '1767401395', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1483, 'Tripay', '455312-260101811', 'INDOMARET', '', '907', '105010322', '260101811', 'T4646029638531YVWYJ', 'https://tripay.co.id/checkout/T4646029638531YVWYJ', '1767403877', '2026-01-03', '1767404897', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1484, 'Tripay', '256117-260101848', 'ALFAMART', '', '945', '105010335', '260101848', 'T4646029638797RPXF7', 'https://tripay.co.id/checkout/T4646029638797RPXF7', '1767404440', '2026-01-03', '1767408160', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1485, 'Tripay', '521710-260101403', 'SHOPEEPAY', '', '482', '105030048', '260101403', 'T4646029639450VR3TQ', 'https://tripay.co.id/checkout/T4646029639450VR3TQ', '1767405819', '2026-01-03', '1767406839', '', 'PAID', '126875', '1767405864', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1486, 'Tripay', '385102-260101848', 'ALFAMART', '', '945', '105010335', '260101848', 'T4646029640630EYKPJ', 'https://tripay.co.id/checkout/T4646029640630EYKPJ', '1767408097', '2026-01-03', '1767411817', '', 'PAID', '126750', '1767408744', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1487, 'Tripay', '429219-260101419', 'DANA', '', '499', '105010186', '260101419', 'T46460296408424EHV2', 'https://tripay.co.id/checkout/T46460296408424EHV2', '1767408547', '2026-01-03', '1767409567', '', 'PAID', '125000', '1767408585', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1488, 'Tripay', '706820-260101521', 'BNIVA', '', '608', '105010213', '260101521', 'T4646029641954LAKD2', 'https://tripay.co.id/checkout/T4646029641954LAKD2', '1767410689', '2026-01-03', '1767411701', '', 'PAID', '167125', '1767410714', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1489, 'Tripay', '534835-260101231', 'BRIVA', '', '298', '105020167', '260101231', 'T4646029642055HV1VM', 'https://tripay.co.id/checkout/T4646029642055HV1VM', '1767410892', '2026-01-03', '1767414612', '', 'PAID', '167125', '1767411007', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1490, 'Tripay', '735673-260101750', 'INDOMARET', '', '845', '105010303', '260101750', 'T46460296428342S23Q', 'https://tripay.co.id/checkout/T46460296428342S23Q', '1767412387', '2026-01-03', '1767413407', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1491, 'Tripay', '933670-260101372', 'BRIVA', '', '448', '105030044', '260101372', 'T4646029643472JRTAO', 'https://tripay.co.id/checkout/T4646029643472JRTAO', '1767413667', '2026-01-03', '1767417379', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1492, 'Tripay', '376910-260101372', 'BRIVA', '', '448', '105030044', '260101372', 'T4646029643486D1BKL', 'https://tripay.co.id/checkout/T4646029643486D1BKL', '1767413692', '2026-01-03', '1767417412', '', 'PAID', '127125', '1767413932', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1493, 'Tripay', '559065-260101522', 'ALFAMIDI', '', '610', '105020296', '260101522', 'T4646029643912JT7WF', 'https://tripay.co.id/checkout/T4646029643912JT7WF', '1767414551', '2026-01-03', '1767418270', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1494, 'Tripay', '937242-260101750', 'INDOMARET', '', '845', '105010303', '260101750', 'T4646029644900SD3OV', 'https://tripay.co.id/checkout/T4646029644900SD3OV', '1767416714', '2026-01-03', '1767417733', '', 'PAID', '126750', '1767417135', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1495, 'Tripay', '511326-260101576', 'BSIVA', '', '664', '105010234', '260101576', 'T4646029645418IZVLK', 'https://tripay.co.id/checkout/T4646029645418IZVLK', '1767417882', '2026-01-03', '1767421602', '', 'PAID', '167125', '1767418272', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1496, 'Tripay', '142788-260101568', 'QRIS2', '', '656', '105010228', '260101568', 'T4646029645954OFSPB', 'https://tripay.co.id/checkout/T4646029645954OFSPB', '1767419174', '2026-01-03', '1767419894', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1497, 'Tripay', '912951-260101568', 'QRIS2', '', '656', '105010228', '260101568', 'T4646029646025TSV0O', 'https://tripay.co.id/checkout/T4646029646025TSV0O', '1767419320', '2026-01-03', '1767420040', '', 'PAID', '125000', '1767420026', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1498, 'Tripay', '636749-260101622', 'BCAVA', '', '711', '105010259', '260101622', 'T4646029647298WPMNW', 'https://tripay.co.id/checkout/T4646029647298WPMNW', '1767422131', '2026-01-03', '1767423151', '', 'PAID', '127750', '1767422243', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1499, 'Tripay', '60660-260101465', 'MANDIRIVA', '', '547', '105010195', '260101465', 'T4646029647899PDYPK', 'https://tripay.co.id/checkout/T4646029647899PDYPK', '1767423576', '2026-01-03', '1767427289', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1500, 'Tripay', '635836-260101465', 'MANDIRIVA', '', '547', '105010195', '260101465', 'T4646029647915YWVMF', 'https://tripay.co.id/checkout/T4646029647915YWVMF', '1767423635', '2026-01-03', '1767427354', '', 'PAID', '167125', '1767423753', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1501, 'Tripay', '611786-260101347', 'INDOMARET', '', '421', '105030038', '260101347', 'T4646029648130WK99U', 'https://tripay.co.id/checkout/T4646029648130WK99U', '1767424142', '2026-01-03', '1769878799', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1502, 'Tripay', '81704-260101860', 'BRIVA', '', '957', '105010341', '260101860', 'T4646029648374MR79B', 'https://tripay.co.id/checkout/T4646029648374MR79B', '1767424658', '2026-01-03', '1767428370', '', 'PAID', '94125', '1767424697', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1503, 'Tripay', '680170-260101377', 'BCAVA', '', '453', '105010170', '260101377', 'T4646029648703KPZKT', 'https://tripay.co.id/checkout/T4646029648703KPZKT', '1767425369', '2026-01-03', '1767426389', '', 'PAID', '127750', '1767425434', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1504, 'Tripay', '417641-260101662', 'MANDIRIVA', '', '752', '105010270', '260101662', 'T4646029648873UCYDI', 'https://tripay.co.id/checkout/T4646029648873UCYDI', '1767425815', '2026-01-03', '1767429527', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1505, 'Tripay', '2953-260101634', 'BNIVA', '', '724', '105010264', '260101634', 'T4646029650784PLXP1', 'https://tripay.co.id/checkout/T4646029650784PLXP1', '1767430397', '2026-01-03', '1767431407', '', 'PAID', '127125', '1767430523', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1506, 'Tripay', '781198-260101724', 'INDOMARET', '', '819', '105050041', '260101724', 'T4646029651352LQ5J5', 'https://tripay.co.id/checkout/T4646029651352LQ5J5', '1767431648', '2026-01-03', '1767432668', '', 'PAID', '126750', '1767432573', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1507, 'Tripay', '559924-260101861', 'BRIVA', '', '958', '105030112', '260101861', 'T4646029652293PQZQW', 'https://tripay.co.id/checkout/T4646029652293PQZQW', '1767433732', '2026-01-03', '1767437444', '', 'UNPAID', '94125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1508, 'Tripay', '448169-260101214', 'INDOMARET', '', '277', '105010102', '260101214', 'T4646029652307XSYPH', 'https://tripay.co.id/checkout/T4646029652307XSYPH', '1767433756', '2026-01-03', '1767434775', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1509, 'Tripay', '914878-260101861', 'DANA', '', '958', '105030112', '260101861', 'T4646029652344592DK', 'https://tripay.co.id/checkout/T4646029652344592DK', '1767433849', '2026-01-03', '1767434869', '', 'PAID', '92000', '1767434452', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1510, 'Tripay', '554836-260101214', 'INDOMARET', '', '277', '105010102', '260101214', 'T4646029652358ZV6QV', 'https://tripay.co.id/checkout/T4646029652358ZV6QV', '1767433875', '2026-01-03', '1767434895', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1511, 'Tripay', '361320-260101214', 'INDOMARET', '', '277', '105010102', '260101214', 'T4646029652372EW77X', 'https://tripay.co.id/checkout/T4646029652372EW77X', '1767433903', '2026-01-03', '1767434923', '', 'PAID', '126750', '1767434320', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1512, 'Tripay', '826401-260101516', 'ALFAMART', '', '602', '105010209', '260101516', 'T4646029653137N0A84', 'https://tripay.co.id/checkout/T4646029653137N0A84', '1767435661', '2026-01-03', '1767439381', '', 'PAID', '126750', '1767436549', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1513, 'Tripay', '269523-260101586', 'BRIVA', '', '675', '105010240', '260101586', 'T4646029653357PGLGK', 'https://tripay.co.id/checkout/T4646029653357PGLGK', '1767436112', '2026-01-03', '1767439832', '', 'PAID', '167125', '1767436145', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1514, 'Tripay', '401734-260101834', 'SHOPEEPAY', '', '931', '105010331', '260101834', 'T4646029653825JN6LM', 'https://tripay.co.id/checkout/T4646029653825JN6LM', '1767436963', '2026-01-03', '1767437982', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1515, 'Tripay', '970368-260101492', 'MANDIRIVA', '', '577', '105050021', '260101492', 'T4646029654231WT0RO', 'https://tripay.co.id/checkout/T4646029654231WT0RO', '1767437836', '2026-01-03', '1767441555', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1516, 'Tripay', '930916-260101492', 'MANDIRIVA', '', '577', '105050021', '260101492', 'T4646029654257PTFKG', 'https://tripay.co.id/checkout/T4646029654257PTFKG', '1767437886', '2026-01-03', '1767441606', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1517, 'Tripay', '996138-260101492', 'MANDIRIVA', '', '577', '105050021', '260101492', 'T4646029654276ZRJYT', 'https://tripay.co.id/checkout/T4646029654276ZRJYT', '1767437919', '2026-01-03', '1767441638', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1518, 'Tripay', '256041-260101492', 'MANDIRIVA', '', '577', '105050021', '260101492', 'T4646029654310JYIOD', 'https://tripay.co.id/checkout/T4646029654310JYIOD', '1767438014', '2026-01-03', '1767441734', '', 'PAID', '127125', '1767438084', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1519, 'Tripay', '232933-260101768', 'BCAVA', '', '863', '105010312', '260101768', 'T4646029654566KWIR0', 'https://tripay.co.id/checkout/T4646029654566KWIR0', '1767438541', '2026-01-03', '1767439561', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1520, 'Tripay', '515169-260101768', 'QRIS', '', '863', '105010312', '260101768', 'T4646029654619UIZ4I', 'https://tripay.co.id/checkout/T4646029654619UIZ4I', '1767438627', '2026-01-03', '1767439347', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1521, 'Tripay', '563088-260101768', 'BCAVA', '', '863', '105010312', '260101768', 'T4646029654684SXGDF', 'https://tripay.co.id/checkout/T4646029654684SXGDF', '1767438733', '2026-01-03', '1767439753', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1522, 'Tripay', '633323-260101768', 'QRIS2', '', '863', '105010312', '260101768', 'T4646029654739MOUYD', 'https://tripay.co.id/checkout/T4646029654739MOUYD', '1767438813', '2026-01-03', '1767439532', '', 'PAID', '125000', '1767438837', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1523, 'Tripay', '274848-260101834', 'DANA', '', '931', '105010331', '260101834', 'T4646029655401VXTGP', 'https://tripay.co.id/checkout/T4646029655401VXTGP', '1767440011', '2026-01-03', '1767441030', '', 'PAID', '125000', '1767440051', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1524, 'Tripay', '131032-260101833', 'DANA', '', '930', '105010330', '260101833', 'T4646029655451PMYUH', 'https://tripay.co.id/checkout/T4646029655451PMYUH', '1767440101', '2026-01-03', '1767441121', '', 'PAID', '125000', '1767440121', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1525, 'Tripay', '172233-260101060', 'MANDIRIVA', '', '88', '105020052', '260101060', 'T4646029655698S8O1Y', 'https://tripay.co.id/checkout/T4646029655698S8O1Y', '1767440513', '2026-01-03', '1767444226', '', 'PAID', '127125', '1767440637', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1526, 'Tripay', '367952-260101614', 'INDOMARET', '', '703', '105020335', '260101614', 'T4646029655957OIHMT', 'https://tripay.co.id/checkout/T4646029655957OIHMT', '1767440952', '2026-01-03', '1767441972', '', 'PAID', '166750', '1767441752', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1527, 'Tripay', '241988-260101849', 'DANA', '', '946', '105010336', '260101849', 'T4646029656354V7MCK', 'https://tripay.co.id/checkout/T4646029656354V7MCK', '1767441631', '2026-01-03', '1767442651', '', 'PAID', '125000', '1767441657', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1528, 'Tripay', '733576-260101778', 'INDOMARET', '', '873', '105020404', '260101778', 'T4646029656997RBNS1', 'https://tripay.co.id/checkout/T4646029656997RBNS1', '1767442713', '2026-01-03', '1767443733', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1529, 'Tripay', '202209-260101276', 'BRIVA', '', '344', '105030026', '260101276', 'T4646029659067WRQNN', 'https://tripay.co.id/checkout/T4646029659067WRQNN', '1767446309', '2026-01-03', '1767450020', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1530, 'Tripay', '750577-260101072', 'QRIS2', '', '105', '105010042', '260101072', 'T4646029659538G3CQA', 'https://tripay.co.id/checkout/T4646029659538G3CQA', '1767447215', '2026-01-03', '1767447935', '', 'PAID', '115000', '1767447284', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1531, 'Tripay', '275259-260101167', 'QRIS', '', '221', '105010087', '260101167', 'T4646029660221BYT9C', 'https://tripay.co.id/checkout/T4646029660221BYT9C', '1767448705', '2026-01-03', '1767449424', '', 'PAID', '125812', '1767448758', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1532, 'Tripay', '284354-260101778', 'INDOMARET', '', '873', '105020404', '260101778', 'T4646029660450TXSDW', 'https://tripay.co.id/checkout/T4646029660450TXSDW', '1767449214', '2026-01-03', '1767450234', '', 'PAID', '166750', '1767449522', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1533, 'Tripay', '574809-260101780', 'BCAVA', '', '875', '105020406', '260101780', 'T4646029660650XG1IC', 'https://tripay.co.id/checkout/T4646029660650XG1IC', '1767449619', '2026-01-03', '1767450639', '', 'PAID', '127750', '1767449676', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1534, 'Tripay', '982027-260101844', 'DANA', '', '941', '105030109', '260101844', 'T464602966207905P6F', 'https://tripay.co.id/checkout/T464602966207905P6F', '1767453179', '2026-01-03', '1767454198', '', 'PAID', '55000', '1767453227', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1535, 'Tripay', '799775-260101256', 'BNIVA', '', '323', '105020178', '260101256', 'T46460296629097YV1N', 'https://tripay.co.id/checkout/T46460296629097YV1N', '1767455985', '2026-01-03', '1767456998', '', 'PAID', '127125', '1767456262', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1536, 'Tripay', '537365-260101352', 'INDOMARET', '', '427', '105020222', '260101352', 'T4646029665472TTEIJ', 'https://tripay.co.id/checkout/T4646029665472TTEIJ', '1767478590', '2026-01-04', '1767479610', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1537, 'Tripay', '110391-260101446', 'DANA', '', '526', '105020267', '260101446', 'T46460296671171BKHL', 'https://tripay.co.id/checkout/T46460296671171BKHL', '1767486023', '2026-01-04', '1767487042', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1538, 'Tripay', '402910-260101620', 'DANA', '', '709', '105010257', '260101620', 'T4646029668500LYLXY', 'https://tripay.co.id/checkout/T4646029668500LYLXY', '1767489796', '2026-01-04', '1767490816', '', 'PAID', '165000', '1767489828', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1539, 'Tripay', '322073-260101353', 'SHOPEEPAY', '', '428', '105010166', '260101353', 'T4646029668578YYKLC', 'https://tripay.co.id/checkout/T4646029668578YYKLC', '1767489996', '2026-01-04', '1767491016', '', 'PAID', '167475', '1767490036', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1540, 'Tripay', '300599-260101126', 'QRIS2', '', '171', '105010062', '260101126', 'T4646029668609WRM16', 'https://tripay.co.id/checkout/T4646029668609WRM16', '1767490051', '2026-01-04', '1767490770', '', 'PAID', '205000', '1767490109', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1541, 'Tripay', '432363-260101569', 'QRIS2', '', '657', '105010229', '260101569', 'T4646029668619GJKK0', 'https://tripay.co.id/checkout/T4646029668619GJKK0', '1767490080', '2026-01-04', '1767490799', '', 'PAID', '125000', '1767490117', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1542, 'Tripay', '687291-260101703', 'INDOMARET', '', '793', '105010286', '260101703', 'T4646029668823ITZCU', 'https://tripay.co.id/checkout/T4646029668823ITZCU', '1767490623', '2026-01-04', '1767491643', '', 'PAID', '126750', '1767491616', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1543, 'Tripay', '861330-260101813', 'DANA', '', '910', '105010323', '260101813', 'T4646029668980XM57U', 'https://tripay.co.id/checkout/T4646029668980XM57U', '1767490930', '2026-01-04', '1767491949', '', 'PAID', '92000', '1767491060', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1544, 'Tripay', '698615-260101764', 'BRIVA', '', '859', '105010310', '260101764', 'T4646029669433KSI93', 'https://tripay.co.id/checkout/T4646029669433KSI93', '1767491815', '2026-01-04', '1767495528', '', 'PAID', '127125', '1767491930', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1545, 'Tripay', '810560-260101513', 'QRIS2', '', '599', '105050026', '260101513', 'T4646029669532WIYUT', 'https://tripay.co.id/checkout/T4646029669532WIYUT', '1767492010', '2026-01-04', '1767492729', '', 'PAID', '125000', '1767492081', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1546, 'Tripay', '520542-260101625', 'BNIVA', '', '714', '105020339', '260101625', 'T4646029669876H7VMU', 'https://tripay.co.id/checkout/T4646029669876H7VMU', '1767492722', '2026-01-04', '1767493734', '', 'PAID', '127125', '1767492806', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1547, 'Tripay', '89666-260101446', 'DANA', '', '526', '105020267', '260101446', 'T46460296699314TJIX', 'https://tripay.co.id/checkout/T46460296699314TJIX', '1767492831', '2026-01-04', '1767493850', '', 'PAID', '125000', '1767492854', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1548, 'Tripay', '172533-260101658', 'BRIVA', '', '748', '105020352', '260101658', 'T4646029670872ZR30P', 'https://tripay.co.id/checkout/T4646029670872ZR30P', '1767494766', '2026-01-04', '1767498486', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1549, 'Tripay', '699926-260101809', 'BRIVA', '', '905', '105010320', '260101809', 'T4646029671201QILMY', 'https://tripay.co.id/checkout/T4646029671201QILMY', '1767495459', '2026-01-04', '1767499172', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1550, 'Tripay', '405668-260101809', 'DANA', '', '905', '105010320', '260101809', 'T4646029671234T5BZY', 'https://tripay.co.id/checkout/T4646029671234T5BZY', '1767495531', '2026-01-04', '1767496550', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1551, 'Tripay', '809071-260101809', 'QRIS2', '', '905', '105010320', '260101809', 'T46460296713170LRDG', 'https://tripay.co.id/checkout/T46460296713170LRDG', '1767495697', '2026-01-04', '1767496417', '', 'PAID', '125000', '1767495816', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1552, 'Tripay', '127751-260101466', 'INDOMARET', '', '548', '105010196', '260101466', 'T4646029671694ZXISH', 'https://tripay.co.id/checkout/T4646029671694ZXISH', '1767496541', '2026-01-04', '1767497561', '', 'PAID', '126750', '1767496656', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1553, 'Tripay', '524024-260101333', 'ALFAMART', '', '404', '105020217', '260101333', 'T4646029672095Y5ZWK', 'https://tripay.co.id/checkout/T4646029672095Y5ZWK', '1767497303', '2026-01-04', '1767501023', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1554, 'Tripay', '18771-260101161', 'INDOMARET', '', '215', '105010082', '260101161', 'T4646029674308ITUKT', 'https://tripay.co.id/checkout/T4646029674308ITUKT', '1767500955', '2026-01-04', '1767501975', '', 'PAID', '126750', '1767501131', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1555, 'Tripay', '52768-260101522', 'DANA', '', '610', '105020296', '260101522', 'T4646029674338BRSBX', 'https://tripay.co.id/checkout/T4646029674338BRSBX', '1767501017', '2026-01-04', '1767502037', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1556, 'Tripay', '221158-260101512', 'BRIVA', '', '598', '105050025', '260101512', 'T4646029674712JXWCK', 'https://tripay.co.id/checkout/T4646029674712JXWCK', '1767501435', '2026-01-04', '1767505154', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1557, 'Tripay', '796238-260101522', 'MANDIRIVA', '', '610', '105020296', '260101522', 'T464602967495103WFI', 'https://tripay.co.id/checkout/T464602967495103WFI', '1767501729', '2026-01-04', '1767505448', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1558, 'Tripay', '25756-260101512', 'BRIVA', '', '598', '105050025', '260101512', 'T4646029674959ZSK7X', 'https://tripay.co.id/checkout/T4646029674959ZSK7X', '1767501752', '2026-01-04', '1767505471', '', 'PAID', '127125', '1767501812', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1559, 'Tripay', '626460-260102002', 'BRIVA', '', '989', '105050044', '260102002', 'T4646029675070FVB4T', 'https://tripay.co.id/checkout/T4646029675070FVB4T', '1767501923', '2026-01-04', '1767505642', '', 'PAID', '127125', '1767502072', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1560, 'Tripay', '611376-260101522', 'BRIVA', '', '610', '105020296', '260101522', 'T4646029676446PXB6V', 'https://tripay.co.id/checkout/T4646029676446PXB6V', '1767503203', '2026-01-04', '1767506922', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1561, 'Tripay', '299427-260101057', 'QRIS2', '', '85', '105020049', '260101057', 'T4646029677655YN35Z', 'https://tripay.co.id/checkout/T4646029677655YN35Z', '1767504878', '2026-01-04', '1767505598', '', 'PAID', '125000', '1767504893', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1562, 'Tripay', '268024-260101288', 'INDOMARET', '', '356', '105020194', '260101288', 'T4646029678509VZSE8', 'https://tripay.co.id/checkout/T4646029678509VZSE8', '1767506034', '2026-01-04', '1767507054', '', 'PAID', '126750', '1767506699', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1563, 'Tripay', '737414-260101360', 'INDOMARET', '', '435', '105050002', '260101360', 'T4646029680767BINCV', 'https://tripay.co.id/checkout/T4646029680767BINCV', '1767508734', '2026-01-04', '1767509753', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1564, 'Tripay', '938341-260101456', 'QRIS2', '', '536', '105030062', '260101456', 'T4646029681775BQY46', 'https://tripay.co.id/checkout/T4646029681775BQY46', '1767510321', '2026-01-04', '1767511040', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1565, 'Tripay', '934685-260101456', 'BRIVA', '', '536', '105030062', '260101456', 'T46460296818295DBFF', 'https://tripay.co.id/checkout/T46460296818295DBFF', '1767510447', '2026-01-04', '1767514167', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1566, 'Tripay', '237523-260101259', 'INDOMARET', '', '326', '105030022', '260101259', 'T46460296823698TOBH', 'https://tripay.co.id/checkout/T46460296823698TOBH', '1767511737', '2026-01-04', '1767512756', '', 'PAID', '126750', '1767512199', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1567, 'Tripay', '537395-260101342', 'BCAVA', '', '414', '105030037', '260101342', 'T4646029682734HCKXD', 'https://tripay.co.id/checkout/T4646029682734HCKXD', '1767512655', '2026-01-04', '1767513675', '', 'PAID', '127750', '1767512727', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1568, 'Tripay', '983588-260101515', 'INDOMARET', '', '601', '105050028', '260101515', 'T4646029682791BJIN5', 'https://tripay.co.id/checkout/T4646029682791BJIN5', '1767512792', '2026-01-04', '1767513812', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1569, 'Tripay', '960518-260101515', 'INDOMARET', '', '601', '105050028', '260101515', 'T4646029683322QGDON', 'https://tripay.co.id/checkout/T4646029683322QGDON', '1767514051', '2026-01-04', '1767515071', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1570, 'Tripay', '958377-260101184', 'INDOMARET', '', '242', '105010095', '260101184', 'T4646029683655HOYVS', 'https://tripay.co.id/checkout/T4646029683655HOYVS', '1767514822', '2026-01-04', '1767515842', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1571, 'Tripay', '530935-260101515', 'INDOMARET', '', '601', '105050028', '260101515', 'T4646029683840JBTYF', 'https://tripay.co.id/checkout/T4646029683840JBTYF', '1767515263', '2026-01-04', '1767516283', '', 'PAID', '126750', '1767515460', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1572, 'Tripay', '542705-260101871', 'BCAVA', '', '968', '105020442', '260101871', 'T4646029684145JJJ79', 'https://tripay.co.id/checkout/T4646029684145JJJ79', '1767515930', '2026-01-04', '1767516950', '', 'PAID', '36750', '1767516484', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1573, 'Tripay', '831393-260101184', 'INDOMARET', '', '242', '105010095', '260101184', 'T4646029684619PG359', 'https://tripay.co.id/checkout/T4646029684619PG359', '1767517092', '2026-01-04', '1767518112', '', 'PAID', '126750', '1767517389', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1574, 'Tripay', '251127-260101731', 'MANDIRIVA', '', '826', '105010297', '260101731', 'T4646029685853H4HTR', 'https://tripay.co.id/checkout/T4646029685853H4HTR', '1767519989', '2026-01-04', '1767523700', '', 'PAID', '127125', '1767520216', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1575, 'Tripay', '383541-260101253', 'INDOMARET', '', '320', '105020177', '260101253', 'T4646029685927IK8LQ', 'https://tripay.co.id/checkout/T4646029685927IK8LQ', '1767520145', '2026-01-04', '1767521165', '', 'PAID', '126750', '1767520917', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1576, 'Tripay', '549424-260101424', 'BRIVA', '', '504', '105030053', '260101424', 'T4646029686714NSYXA', 'https://tripay.co.id/checkout/T4646029686714NSYXA', '1767521829', '2026-01-04', '1767525548', '', 'PAID', '127125', '1767521945', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1577, 'Tripay', '496889-260101206', 'MANDIRIVA', '', '268', '105020160', '260101206', 'T4646029686983FY4E3', 'https://tripay.co.id/checkout/T4646029686983FY4E3', '1767522372', '2026-01-04', '1767526085', '', 'PAID', '167125', '1767524314', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1578, 'Tripay', '199921-260101319', 'ALFAMART', '', '390', '105010148', '260101319', 'T4646029687264MJPQJ', 'https://tripay.co.id/checkout/T4646029687264MJPQJ', '1767522951', '2026-01-04', '1767526671', '', 'PAID', '126750', '1767522977', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1579, 'Tripay', '536182-260101775', 'INDOMARET', '', '870', '105030103', '260101775', 'T4646029687660I8GF5', 'https://tripay.co.id/checkout/T4646029687660I8GF5', '1767523662', '2026-01-04', '1767524682', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1580, 'Tripay', '661930-260101359', 'DANA', '', '434', '105050001', '260101359', 'T4646029687920JKKPD', 'https://tripay.co.id/checkout/T4646029687920JKKPD', '1767524153', '2026-01-04', '1767525172', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1581, 'Tripay', '510296-260101359', 'ALFAMART', '', '434', '105050001', '260101359', 'T464602968793376DY5', 'https://tripay.co.id/checkout/T464602968793376DY5', '1767524178', '2026-01-04', '1767527898', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1582, 'Tripay', '220156-260101721', 'BCAVA', '', '816', '105050038', '260101721', 'T4646029688450CYAXA', 'https://tripay.co.id/checkout/T4646029688450CYAXA', '1767525167', '2026-01-04', '1767526187', '', 'PAID', '127750', '1767525251', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1583, 'Tripay', '737285-260101752', 'QRIS2', '', '847', '105020392', '260101752', 'T4646029689016XCWW4', 'https://tripay.co.id/checkout/T4646029689016XCWW4', '1767526247', '2026-01-04', '1767526967', '', 'PAID', '125000', '1767526313', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1584, 'Tripay', '829782-260101340', 'INDOMARET', '', '412', '105010159', '260101340', 'T4646029689153BK6V2', 'https://tripay.co.id/checkout/T4646029689153BK6V2', '1767526455', '2026-01-04', '1767527475', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1585, 'Tripay', '269087-260101238', 'ALFAMART', '', '305', '105020171', '260101238', 'T4646029689628EHYCH', 'https://tripay.co.id/checkout/T4646029689628EHYCH', '1767527222', '2026-01-04', '1767530941', '', 'PAID', '126750', '1767528255', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1586, 'Tripay', '803067-260101822', 'QRIS', '', '919', '105020420', '260101822', 'T4646029689708QJV4V', 'https://tripay.co.id/checkout/T4646029689708QJV4V', '1767527309', '2026-01-04', '1767528029', '', 'UNPAID', '75637', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1587, 'Tripay', '673311-260101362', 'INDOMARET', '', '437', '105050004', '260101362', 'T4646029689915YUYBP', 'https://tripay.co.id/checkout/T4646029689915YUYBP', '1767527814', '2026-01-04', '1767528818', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1588, 'Tripay', '289945-260101362', 'ALFAMART', '', '437', '105050004', '260101362', 'T4646029690794WMFV7', 'https://tripay.co.id/checkout/T4646029690794WMFV7', '1767528445', '2026-01-04', '1767532164', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1589, 'Tripay', '495564-260101795', 'DANA', '', '891', '10520005', '260101795', 'T4646029691017HUHDG', 'https://tripay.co.id/checkout/T4646029691017HUHDG', '1767528599', '2026-01-04', '1767529618', '', 'PAID', '125000', '1767528624', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1590, 'Tripay', '312996-260101786', 'DANA', '', '881', '10520004', '260101786', 'T46460296911581J2HW', 'https://tripay.co.id/checkout/T46460296911581J2HW', '1767528698', '2026-01-04', '1767529717', '', 'UNPAID', '17000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1591, 'Tripay', '405957-260101340', 'ALFAMART', '', '412', '105010159', '260101340', 'T4646029691665XEUHI', 'https://tripay.co.id/checkout/T4646029691665XEUHI', '1767529283', '2026-01-04', '1767533002', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1592, 'Tripay', '221862-260101877', 'BRIVA', '', '974', '105020448', '260101877', 'T4646029692332K9JUK', 'https://tripay.co.id/checkout/T4646029692332K9JUK', '1767529953', '2026-01-04', '1767533665', '', 'PAID', '27125', '1767530023', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1593, 'Tripay', '51088-260101108', 'INDOMARET', '', '151', '105010054', '260101108', 'T4646029692344NXKNW', 'https://tripay.co.id/checkout/T4646029692344NXKNW', '1767529976', '2026-01-04', '1767530996', '', 'PAID', '126750', '1767530398', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1594, 'Tripay', '3936-260101456', 'INDOMARET', '', '536', '105030062', '260101456', 'T46460296923655AJVN', 'https://tripay.co.id/checkout/T46460296923655AJVN', '1767529998', '2026-01-04', '1767531018', '', 'PAID', '126750', '1767530155', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1595, 'Tripay', '528908-260101159', 'ALFAMART', '', '212', '105010080', '260101159', 'T4646029692613PYBFZ', 'https://tripay.co.id/checkout/T4646029692613PYBFZ', '1767530391', '2026-01-04', '1767534110', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1596, 'Tripay', '787330-260101103', 'INDOMARET', '', '146', '105020094', '260101103', 'T4646029692683CEB1W', 'https://tripay.co.id/checkout/T4646029692683CEB1W', '1767530472', '2026-01-04', '1767531491', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1597, 'Tripay', '690485-260101801', 'DANA', '', '897', '105020410', '260101801', 'T4646029693478CZSI2', 'https://tripay.co.id/checkout/T4646029693478CZSI2', '1767531764', '2026-01-04', '1767532783', '', 'PAID', '125000', '1767531792', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1598, 'Tripay', '512420-260101603', 'QRIS2', '', '692', '105020331', '260101603', 'T46460296936643VPFO', 'https://tripay.co.id/checkout/T46460296936643VPFO', '1767532107', '2026-01-04', '1767532827', '', 'PAID', '165000', '1767532160', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1599, 'Tripay', '152996-260101297', 'BRIVA', '', '365', '105010136', '260101297', 'T4646029693870WRGHG', 'https://tripay.co.id/checkout/T4646029693870WRGHG', '1767532418', '2026-01-04', '1767536137', '', 'PAID', '127125', '1767532647', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1600, 'Tripay', '665721-260101762', 'BRIVA', '', '857', '105040008', '260101762', 'T46460296942769OIKU', 'https://tripay.co.id/checkout/T46460296942769OIKU', '1767533177', '2026-01-04', '1767536896', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1601, 'Tripay', '276577-260101409', 'MANDIRIVA', '', '489', '105030051', '260101409', 'T4646029694589ODTGA', 'https://tripay.co.id/checkout/T4646029694589ODTGA', '1767533754', '2026-01-04', '1767537466', '', 'PAID', '127125', '1767533823', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1602, 'Tripay', '402859-260101103', 'INDOMARET', '', '146', '105020094', '260101103', 'T4646029694637GKNS9', 'https://tripay.co.id/checkout/T4646029694637GKNS9', '1767533857', '2026-01-04', '1767534877', '', 'PAID', '166750', '1767534281', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1603, 'Tripay', '946669-260101883', 'INDOMARET', '', '980', '105010345', '260101883', 'T4646029694682YCHLM', 'https://tripay.co.id/checkout/T4646029694682YCHLM', '1767533936', '2026-01-04', '1767534956', '', 'PAID', '39750', '1767534036', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1604, 'Tripay', '849307-260101762', 'BRIVA', '', '857', '105040008', '260101762', 'T4646029695375TQTKD', 'https://tripay.co.id/checkout/T4646029695375TQTKD', '1767535120', '2026-01-04', '1767538832', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1605, 'Tripay', '838622-260101159', 'INDOMARET', '', '212', '105010080', '260101159', 'T4646029695726IONRS', 'https://tripay.co.id/checkout/T4646029695726IONRS', '1767535925', '2026-01-04', '1767536945', '', 'PAID', '126750', '1767536111', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1606, 'Tripay', '75758-260101850', 'INDOMARET', '', '947', '105010337', '260101850', 'T4646029695789GAZW7', 'https://tripay.co.id/checkout/T4646029695789GAZW7', '1767536049', '2026-01-04', '1767537069', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1607, 'Tripay', '967936-260101362', 'INDOMARET', '', '437', '105050004', '260101362', 'T4646029695850X2TO9', 'https://tripay.co.id/checkout/T4646029695850X2TO9', '1767536163', '2026-01-04', '1767537183', '', 'PAID', '126750', '1767536428', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1608, 'Tripay', '207277-260101762', 'QRIS2', '', '857', '105040008', '260101762', 'T4646029696648FC2NT', 'https://tripay.co.id/checkout/T4646029696648FC2NT', '1767537864', '2026-01-04', '1767538583', '', 'PAID', '125000', '1767537902', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1609, 'Tripay', '124404-260101850', 'INDOMARET', '', '947', '105010337', '260101850', 'T46460296973894E05A', 'https://tripay.co.id/checkout/T46460296973894E05A', '1767539823', '2026-01-04', '1767540842', '', 'PAID', '126750', '1767540085', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1610, 'Tripay', '108869-260101053', 'QRIS2', '', '79', '105010035', '260101053', 'T4646029698703DFJNW', 'https://tripay.co.id/checkout/T4646029698703DFJNW', '1767545232', '2026-01-04', '1767545952', '', 'PAID', '165000', '1767545296', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1611, 'Tripay', '527625-260101776', 'QRIS', '', '871', '105020402', '260101776', 'T4646029700126ZCI1B', 'https://tripay.co.id/checkout/T4646029700126ZCI1B', '1767559152', '2026-01-05', '1767559871', '', 'PAID', '165952', '1767559211', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1612, 'Tripay', '931923-260101217', 'BRIVA', '', '281', '105010105', '260101217', 'T4646029701151KPTAY', 'https://tripay.co.id/checkout/T4646029701151KPTAY', '1767567362', '2026-01-05', '1767571074', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1613, 'Tripay', '869970-260101730', 'BRIVA', '', '825', '105030094', '260101730', 'T4646029701720QFKO3', 'https://tripay.co.id/checkout/T4646029701720QFKO3', '1767569416', '2026-01-05', '1767573136', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1614, 'Tripay', '954620-260101754', 'ALFAMART', '', '849', '105020393', '260101754', 'T4646029702141OPEL4', 'https://tripay.co.id/checkout/T4646029702141OPEL4', '1767570865', '2026-01-05', '1767574585', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1615, 'Tripay', '712095-260101653', 'DANA', '', '743', '105050035', '260101653', 'T4646029702300B3SU4', 'https://tripay.co.id/checkout/T4646029702300B3SU4', '1767571336', '2026-01-05', '1767572355', '', 'PAID', '125000', '1767571410', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1616, 'Tripay', '664698-260101498', 'QRIS', '', '584', '105010205', '260101498', 'T464602970297001IKK', 'https://tripay.co.id/checkout/T464602970297001IKK', '1767573078', '2026-01-05', '1767573798', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1617, 'Tripay', '383946-260101498', 'QRIS', '', '584', '105010205', '260101498', 'T4646029702984V9Q3P', 'https://tripay.co.id/checkout/T4646029702984V9Q3P', '1767573100', '2026-01-05', '1767573819', '', 'PAID', '125812', '1767573214', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1618, 'Tripay', '194834-260101018', 'BCAVA', '', '27', '105020013', '260101018', 'T4646029703093OMRSM', 'https://tripay.co.id/checkout/T4646029703093OMRSM', '1767573362', '2026-01-05', '1767574382', '', 'PAID', '207750', '1767573398', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1619, 'Tripay', '12429-260101867', 'QRIS2', '', '964', '105020439', '260101867', 'T46460297034384ZL7U', 'https://tripay.co.id/checkout/T46460297034384ZL7U', '1767574166', '2026-01-05', '1767574886', '', 'PAID', '46000', '1767574226', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1620, 'Tripay', '737688-260101749', 'BRIVA', '', '844', '105030099', '260101749', 'T4646029703509DSEQX', 'https://tripay.co.id/checkout/T4646029703509DSEQX', '1767574308', '2026-01-05', '1767578020', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1621, 'Tripay', '618669-260101749', 'BRIVA', '', '844', '105030099', '260101749', 'T46460297035317KV8E', 'https://tripay.co.id/checkout/T46460297035317KV8E', '1767574369', '2026-01-05', '1767578089', '', 'PAID', '127125', '1767574458', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1622, 'Tripay', '848729-260101346', 'MANDIRIVA', '', '419', '105010162', '260101346', 'T4646029703537HJ8TP', 'https://tripay.co.id/checkout/T4646029703537HJ8TP', '1767574377', '2026-01-05', '1767578097', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1623, 'Tripay', '795234-260101270', 'INDOMARET', '', '338', '105020184', '260101270', 'T4646029703555OWAME', 'https://tripay.co.id/checkout/T4646029703555OWAME', '1767574412', '2026-01-05', '1767575432', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1624, 'Tripay', '284665-260101181', 'BRIVA', '', '238', '105020145', '260101181', 'T4646029703624ZGNLP', 'https://tripay.co.id/checkout/T4646029703624ZGNLP', '1767574548', '2026-01-05', '1767578268', '', 'PAID', '127125', '1767574619', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1625, 'Tripay', '667223-260101447', 'BRIVA', '', '527', '105020268', '260101447', 'T4646029703714AAZYF', 'https://tripay.co.id/checkout/T4646029703714AAZYF', '1767574714', '2026-01-05', '1767578434', '', 'PAID', '167125', '1767574930', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1626, 'Tripay', '463373-260101382', 'INDOMARET', '', '459', '105020232', '260101382', 'T4646029703811P4QTF', 'https://tripay.co.id/checkout/T4646029703811P4QTF', '1767574908', '2026-01-05', '1767575928', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1627, 'Tripay', '171567-260101671', 'INDOMARET', '', '761', '105010275', '260101671', 'T4646029703958KJLUT', 'https://tripay.co.id/checkout/T4646029703958KJLUT', '1767575207', '2026-01-05', '1767576227', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1628, 'Tripay', '351262-260101609', 'INDOMARET', '', '698', '105010251', '260101609', 'T4646029704001YOFRP', 'https://tripay.co.id/checkout/T4646029704001YOFRP', '1767575276', '2026-01-05', '1767576296', '', 'PAID', '126750', '1767575338', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1629, 'Tripay', '79667-260101438', 'QRIS2', '', '518', '105030055', '260101438', 'T4646029704013NNPW5', 'https://tripay.co.id/checkout/T4646029704013NNPW5', '1767575295', '2026-01-05', '1767576014', '', 'PAID', '125000', '1767575335', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1630, 'Tripay', '309440-260101732', 'QRIS2', '', '827', '105030095', '260101732', 'T4646029704016QEZ5J', 'https://tripay.co.id/checkout/T4646029704016QEZ5J', '1767575311', '2026-01-05', '1767576030', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1631, 'Tripay', '203940-260101772', 'INDOMARET', '', '867', '105020400', '260101772', 'T4646029704032COIOC', 'https://tripay.co.id/checkout/T4646029704032COIOC', '1767575328', '2026-01-05', '1767576348', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1632, 'Tripay', '468891-260101660', 'QRIS2', '', '750', '105020354', '260101660', 'T4646029704060UFYSQ', 'https://tripay.co.id/checkout/T4646029704060UFYSQ', '1767575365', '2026-01-05', '1767576085', '', 'PAID', '125000', '1767575518', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1633, 'Tripay', '439608-260101748', 'BNIVA', '', '843', '105010302', '260101748', 'T4646029704121REPLC', 'https://tripay.co.id/checkout/T4646029704121REPLC', '1767575479', '2026-01-05', '1767576499', '', 'PAID', '127125', '1767575608', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1634, 'Tripay', '791378-260101116', 'MANDIRIVA', '', '160', '105020100', '260101116', 'T46460297041362XHBG', 'https://tripay.co.id/checkout/T46460297041362XHBG', '1767575499', '2026-01-05', '1767579219', '', 'PAID', '127125', '1767575606', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1635, 'Tripay', '713418-260101732', 'QRIS2', '', '827', '105030095', '260101732', 'T4646029704292B8KJE', 'https://tripay.co.id/checkout/T4646029704292B8KJE', '1767575749', '2026-01-05', '1767576468', '', 'PAID', '125000', '1767575832', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1636, 'Tripay', '926733-260101178', 'BCAVA', '', '234', '105020141', '260101178', 'T4646029704569INVDX', 'https://tripay.co.id/checkout/T4646029704569INVDX', '1767576192', '2026-01-05', '1767577212', '', 'PAID', '127750', '1767576284', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1637, 'Tripay', '14792-260101400', 'ALFAMART', '', '479', '105010179', '260101400', 'T4646029704774XTDV9', 'https://tripay.co.id/checkout/T4646029704774XTDV9', '1767576606', '2026-01-05', '1767580326', '', 'PAID', '126750', '1767577329', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1638, 'Tripay', '637078-260101048', 'OVO', '', '71', '105020041', '260101048', 'T4646029704870YV6NH', 'https://tripay.co.id/checkout/T4646029704870YV6NH', '1767576754', '2026-01-05', '1767577774', '', 'UNPAID', '208075', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1639, 'Tripay', '63920-260101048', 'OVO', '', '71', '105020041', '260101048', 'T4646029705026CTTV8', 'https://tripay.co.id/checkout/T4646029705026CTTV8', '1767576995', '2026-01-05', '1767578015', '', 'UNPAID', '208075', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1640, 'Tripay', '625068-260101431', 'DANA', '', '511', '105020257', '260101431', 'T46460297050434B2RL', 'https://tripay.co.id/checkout/T46460297050434B2RL', '1767577021', '2026-01-05', '1767578040', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1641, 'Tripay', '800908-260101048', 'SHOPEEPAY', '', '71', '105020041', '260101048', 'T4646029705049JDNRX', 'https://tripay.co.id/checkout/T4646029705049JDNRX', '1767577033', '2026-01-05', '1767578053', '', 'PAID', '208075', '1767577078', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1642, 'Tripay', '713264-260101431', 'DANA', '', '511', '105020257', '260101431', 'T4646029705108GSR46', 'https://tripay.co.id/checkout/T4646029705108GSR46', '1767577147', '2026-01-05', '1767578166', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1643, 'Tripay', '627164-260101431', 'DANA', '', '511', '105020257', '260101431', 'T4646029705190OCQJL', 'https://tripay.co.id/checkout/T4646029705190OCQJL', '1767577288', '2026-01-05', '1767578307', '', 'PAID', '125000', '1767577356', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1644, 'Tripay', '366578-260101270', 'INDOMARET', '', '338', '105020184', '260101270', 'T4646029705244S5SCG', 'https://tripay.co.id/checkout/T4646029705244S5SCG', '1767577393', '2026-01-05', '1767578413', '', 'PAID', '126750', '1767577464', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1645, 'Tripay', '544463-260101695', 'BNIVA', '', '785', '105040003', '260101695', 'T4646029705414FQY0N', 'https://tripay.co.id/checkout/T4646029705414FQY0N', '1767577690', '2026-01-05', '1767578710', '', 'PAID', '127125', '1767577732', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1646, 'Tripay', '657132-260101666', 'QRIS2', '', '756', '105020357', '260101666', 'T4646029705800P7XWT', 'https://tripay.co.id/checkout/T4646029705800P7XWT', '1767578356', '2026-01-05', '1767579076', '', 'PAID', '165000', '1767578438', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1647, 'Tripay', '717429-260101881', 'INDOMARET', '', '978', '105010344', '260101881', 'T4646029705895XDMDD', 'https://tripay.co.id/checkout/T4646029705895XDMDD', '1767578500', '2026-01-05', '1767579520', '', 'UNPAID', '43750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1648, 'Tripay', '336327-260101375', 'QRIS2', '', '451', '105020229', '260101375', 'T4646029706424ZHODM', 'https://tripay.co.id/checkout/T4646029706424ZHODM', '1767579378', '2026-01-05', '1767580097', '', 'PAID', '165000', '1767579407', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1649, 'Tripay', '539481-260101683', 'BCAVA', '', '773', '105020364', '260101683', 'T4646029706439KMPIQ', 'https://tripay.co.id/checkout/T4646029706439KMPIQ', '1767579391', '2026-01-05', '1767580411', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1650, 'Tripay', '519891-260101852', 'INDOMARET', '', '949', '105020432', '260101852', 'T4646029706679NOWNX', 'https://tripay.co.id/checkout/T4646029706679NOWNX', '1767579804', '2026-01-05', '1767580824', '', 'PAID', '126750', '1767580362', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1651, 'Tripay', '562685-260101340', 'ALFAMART', '', '412', '105010159', '260101340', 'T4646029706704UASOU', 'https://tripay.co.id/checkout/T4646029706704UASOU', '1767579839', '2026-01-05', '1767583559', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1652, 'Tripay', '548338-260101683', 'BCAVA', '', '773', '105020364', '260101683', 'T4646029706847BM7ZW', 'https://tripay.co.id/checkout/T4646029706847BM7ZW', '1767580059', '2026-01-05', '1767581078', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1653, 'Tripay', '401826-260101340', 'BCAVA', '', '412', '105010159', '260101340', 'T4646029707279RRSPA', 'https://tripay.co.id/checkout/T4646029707279RRSPA', '1767580845', '2026-01-05', '1767581865', '', 'PAID', '167750', '1767581271', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1654, 'Tripay', '108678-260101482', 'INDOMARET', '', '567', '105030068', '260101482', 'T4646029707323IILWU', 'https://tripay.co.id/checkout/T4646029707323IILWU', '1767580941', '2026-01-05', '1767581961', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1655, 'Tripay', '56096-260101869', 'BRIVA', '', '966', '105020440', '260101869', 'T4646029707355P56AS', 'https://tripay.co.id/checkout/T4646029707355P56AS', '1767580987', '2026-01-05', '1767584707', '', 'UNPAID', '48125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1656, 'Tripay', '647745-260101869', 'BRIVA', '', '966', '105020440', '260101869', 'T46460297074043AT8S', 'https://tripay.co.id/checkout/T46460297074043AT8S', '1767581079', '2026-01-05', '1767584799', '', 'UNPAID', '48125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1657, 'Tripay', '984604-260101869', 'ALFAMART', '', '966', '105020440', '260101869', 'T46460297075501PGFK', 'https://tripay.co.id/checkout/T46460297075501PGFK', '1767581300', '2026-01-05', '1767585020', '', 'UNPAID', '47750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1658, 'Tripay', '915445-260101312', 'BNIVA', '', '381', '105010141', '260101312', 'T4646029707676JZO5X', 'https://tripay.co.id/checkout/T4646029707676JZO5X', '1767581453', '2026-01-05', '1767582473', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1659, 'Tripay', '982510-260101869', 'ALFAMART', '', '966', '105020440', '260101869', 'T4646029707822KCNOG', 'https://tripay.co.id/checkout/T4646029707822KCNOG', '1767581694', '2026-01-05', '1767585414', '', 'UNPAID', '47750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1660, 'Tripay', '617230-260101252', 'BNIVA', '', '319', '105010124', '260101252', 'T46460297079486DERO', 'https://tripay.co.id/checkout/T46460297079486DERO', '1767581890', '2026-01-05', '1767582909', '', 'PAID', '127125', '1767582042', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1661, 'Tripay', '683603-260101528', 'INDOMARET', '', '616', '105010217', '260101528', 'T4646029708058C7KZT', 'https://tripay.co.id/checkout/T4646029708058C7KZT', '1767582085', '2026-01-05', '1767583105', '', 'PAID', '126750', '1767582656', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1662, 'Tripay', '74439-260101869', 'INDOMARET', '', '966', '105020440', '260101869', 'T4646029708066FZXRS', 'https://tripay.co.id/checkout/T4646029708066FZXRS', '1767582103', '2026-01-05', '1767583123', '', 'UNPAID', '47750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1663, 'Tripay', '981348-260101869', 'INDOMARET', '', '966', '105020440', '260101869', 'T4646029708210XY5PJ', 'https://tripay.co.id/checkout/T4646029708210XY5PJ', '1767582326', '2026-01-05', '1767583346', '', 'UNPAID', '47750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1664, 'Tripay', '512361-260105001', 'INDOMARET', '', '640', '105030076', '260105001', 'T4646029708282P87DA', 'https://tripay.co.id/checkout/T4646029708282P87DA', '1767582438', '2026-01-05', '1767583458', '', 'PAID', '126750', '1767583169', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1665, 'Tripay', '825120-260101379', 'BRIVA', '', '456', '105020231', '260101379', 'T4646029708316R9TWM', 'https://tripay.co.id/checkout/T4646029708316R9TWM', '1767582510', '2026-01-05', '1767586229', '', 'PAID', '127125', '1767583436', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1666, 'Tripay', '572062-260101869', 'BRIVA', '', '966', '105020440', '260101869', 'T4646029708357HWAHC', 'https://tripay.co.id/checkout/T4646029708357HWAHC', '1767582568', '2026-01-05', '1767586287', '', 'UNPAID', '48125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1667, 'Tripay', '246195-260101869', 'BRIVA', '', '966', '105020440', '260101869', 'T4646029708443LACW1', 'https://tripay.co.id/checkout/T4646029708443LACW1', '1767582704', '2026-01-05', '1767586416', '', 'UNPAID', '48125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1668, 'Tripay', '769711-260101869', 'INDOMARET', '', '966', '105020440', '260101869', 'T4646029708500L1PHO', 'https://tripay.co.id/checkout/T4646029708500L1PHO', '1767582786', '2026-01-05', '1767583806', '', 'PAID', '47750', '1767582983', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1669, 'Tripay', '8275-260101791', 'MANDIRIVA', '', '886', '10550002', '260101791', 'T4646029708763XBB02', 'https://tripay.co.id/checkout/T4646029708763XBB02', '1767583253', '2026-01-05', '1767586972', '', 'PAID', '127125', '1767583340', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1670, 'Tripay', '654772-260101763', 'QRIS2', '', '858', '105020396', '260101763', 'T46460297088037FPWW', 'https://tripay.co.id/checkout/T46460297088037FPWW', '1767583329', '2026-01-05', '1767584049', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1671, 'Tripay', '732885-260101763', 'QRIS2', '', '858', '105020396', '260101763', 'T4646029708818H8BSW', 'https://tripay.co.id/checkout/T4646029708818H8BSW', '1767583343', '2026-01-05', '1767584063', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1672, 'Tripay', '389784-260101459', 'INDOMARET', '', '540', '105020273', '260101459', 'T4646029708855IY76Y', 'https://tripay.co.id/checkout/T4646029708855IY76Y', '1767583409', '2026-01-05', '1767584428', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1673, 'Tripay', '68003-260101763', 'QRIS2', '', '858', '105020396', '260101763', 'T4646029708912E1FI8', 'https://tripay.co.id/checkout/T4646029708912E1FI8', '1767583509', '2026-01-05', '1767584229', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1674, 'Tripay', '925727-260101763', 'BRIVA', '', '858', '105020396', '260101763', 'T4646029708974C05EJ', 'https://tripay.co.id/checkout/T4646029708974C05EJ', '1767583631', '2026-01-05', '1767587343', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1675, 'Tripay', '780406-260101276', 'BRIVA', '', '344', '105030026', '260101276', 'T46460297091260HMWG', 'https://tripay.co.id/checkout/T46460297091260HMWG', '1767583867', '2026-01-05', '1767587587', '', 'PAID', '127125', '1767584836', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1676, 'Tripay', '340111-260101459', 'DANA', '', '540', '105020273', '260101459', 'T4646029710444TEIJH', 'https://tripay.co.id/checkout/T4646029710444TEIJH', '1767586094', '2026-01-05', '1767587113', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1677, 'Tripay', '720455-260101323', 'MANDIRIVA', '', '394', '105020211', '260101323', 'T4646029710951NDMP4', 'https://tripay.co.id/checkout/T4646029710951NDMP4', '1767587048', '2026-01-05', '1767590767', '', 'PAID', '127125', '1767587206', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1678, 'Tripay', '64067-260101705', 'QRIS2', '', '795', '105020372', '260101705', 'T46460297110055NCSL', 'https://tripay.co.id/checkout/T46460297110055NCSL', '1767587132', '2026-01-05', '1767587851', '', 'PAID', '125000', '1767587176', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1679, 'Tripay', '19697-260101763', 'QRIS2', '', '858', '105020396', '260101763', 'T4646029711054BCKHZ', 'https://tripay.co.id/checkout/T4646029711054BCKHZ', '1767587207', '2026-01-05', '1767587927', '', 'PAID', '125000', '1767587333', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1680, 'Tripay', '397762-260101881', 'ALFAMART', '', '978', '105010344', '260101881', 'T4646029711155PBSTD', 'https://tripay.co.id/checkout/T4646029711155PBSTD', '1767587338', '2026-01-05', '1767591058', '', 'UNPAID', '43750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1681, 'Tripay', '326186-260101360', 'ALFAMART', '', '435', '105050002', '260101360', 'T4646029711159KROOE', 'https://tripay.co.id/checkout/T4646029711159KROOE', '1767587342', '2026-01-05', '1767591061', '', 'PAID', '126750', '1767587401', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1682, 'Tripay', '370914-260101881', 'ALFAMIDI', '', '978', '105010344', '260101881', 'T4646029711182KD63P', 'https://tripay.co.id/checkout/T4646029711182KD63P', '1767587382', '2026-01-05', '1767591101', '', 'UNPAID', '43750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1683, 'Tripay', '399253-260101881', 'ALFAMART', '', '978', '105010344', '260101881', 'T46460297112588R0JB', 'https://tripay.co.id/checkout/T46460297112588R0JB', '1767587513', '2026-01-05', '1767591233', '', 'UNPAID', '43750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1684, 'Tripay', '292634-260101482', 'INDOMARET', '', '567', '105030068', '260101482', 'T46460297113742YU8C', 'https://tripay.co.id/checkout/T46460297113742YU8C', '1767587712', '2026-01-05', '1767588732', '', 'PAID', '126750', '1767587837', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1685, 'Tripay', '380728-260101608', 'INDOMARET', '', '697', '105030085', '260101608', 'T4646029711480MGDIG', 'https://tripay.co.id/checkout/T4646029711480MGDIG', '1767587885', '2026-01-05', '1767588905', '', 'PAID', '126750', '1767588211', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1686, 'Tripay', '145341-260101486', 'QRIS2', '', '571', '105020282', '260101486', 'T4646029711968G1LEG', 'https://tripay.co.id/checkout/T4646029711968G1LEG', '1767588750', '2026-01-05', '1767589470', '', 'PAID', '165000', '1767588787', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1687, 'Tripay', '783433-260101489', 'QRIS2', '', '574', '105020284', '260101489', 'T4646029712078JXX5I', 'https://tripay.co.id/checkout/T4646029712078JXX5I', '1767588912', '2026-01-05', '1767589631', '', 'PAID', '165000', '1767588936', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1688, 'Tripay', '569434-251201110', 'BRIVA', '', '158', '105010060', '251201110', 'T4646029712106JW9TO', 'https://tripay.co.id/checkout/T4646029712106JW9TO', '1767588952', '2026-01-05', '1767592665', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1689, 'Tripay', '440445-260101121', 'MANDIRIVA', '', '166', '105020105', '260101121', 'T4646029712110NJK1H', 'https://tripay.co.id/checkout/T4646029712110NJK1H', '1767588954', '2026-01-05', '1767592670', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1690, 'Tripay', '45450-260101455', 'MANDIRIVA', '', '535', '105020271', '260101455', 'T4646029712799KTRRG', 'https://tripay.co.id/checkout/T4646029712799KTRRG', '1767590133', '2026-01-05', '1767593845', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1691, 'Tripay', '863215-260101368', 'BRIVA', '', '444', '105020226', '260101368', 'T46460297128303Q8LY', 'https://tripay.co.id/checkout/T46460297128303Q8LY', '1767590178', '2026-01-05', '1767593898', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1692, 'Tripay', '180334-251201241', 'QRIS2', '', '316', '105010122', '251201241', 'T4646029713406GDGDY', 'https://tripay.co.id/checkout/T4646029713406GDGDY', '1767591163', '2026-01-05', '1767591882', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1693, 'Tripay', '759907-260101249', 'QRIS2', '', '316', '105010122', '260101249', 'T4646029713421DZKX1', 'https://tripay.co.id/checkout/T4646029713421DZKX1', '1767591199', '2026-01-05', '1767591912', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1694, 'Tripay', '104078-260101540', 'INDOMARET', '', '628', '105020302', '260101540', 'T4646029713535HLNNQ', 'https://tripay.co.id/checkout/T4646029713535HLNNQ', '1767591374', '2026-01-05', '1767592394', '', 'PAID', '126750', '1767591482', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1695, 'Tripay', '600016-260101306', 'INDOMARET', '', '375', '105020203', '260101306', 'T4646029713708DAFUF', 'https://tripay.co.id/checkout/T4646029713708DAFUF', '1767591660', '2026-01-05', '1767592679', '', 'PAID', '126750', '1767591735', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1696, 'Tripay', '979557-260101602', 'BCAVA', '', '691', '105020330', '260101602', 'T4646029714383IWU8H', 'https://tripay.co.id/checkout/T4646029714383IWU8H', '1767592880', '2026-01-05', '1767593899', '', 'UNPAID', '167750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1697, 'Tripay', '810876-260101602', 'BCAVA', '', '691', '105020330', '260101602', 'T4646029714406XXHJA', 'https://tripay.co.id/checkout/T4646029714406XXHJA', '1767592928', '2026-01-05', '1767593948', '', 'UNPAID', '167750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1698, 'Tripay', '527535-260101602', 'BCAVA', '', '691', '105020330', '260101602', 'T4646029714497P4OHW', 'https://tripay.co.id/checkout/T4646029714497P4OHW', '1767593068', '2026-01-05', '1767594087', '', 'PAID', '167750', '1767593164', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1699, 'Tripay', '474159-260101287', 'INDOMARET', '', '355', '105020193', '260101287', 'T4646029714661YLEJQ', 'https://tripay.co.id/checkout/T4646029714661YLEJQ', '1767593306', '2026-01-05', '1767594326', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1700, 'Tripay', '501424-260101556', 'QRIS2', '', '644', '105020315', '260101556', 'T46460297147658MZKX', 'https://tripay.co.id/checkout/T46460297147658MZKX', '1767593466', '2026-01-05', '1767594186', '', 'PAID', '125000', '1767593541', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1701, 'Tripay', '239885-260101312', 'BNIVA', '', '381', '105010141', '260101312', 'T4646029715249IPJPU', 'https://tripay.co.id/checkout/T4646029715249IPJPU', '1767594261', '2026-01-05', '1767595274', '', 'PAID', '127125', '1767594327', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1702, 'Tripay', '878936-260101499', 'BRIVA', '', '585', '105030069', '260101499', 'T46460297153125ONFN', 'https://tripay.co.id/checkout/T46460297153125ONFN', '1767594388', '2026-01-05', '1767598107', '', 'PAID', '127125', '1767594446', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1703, 'Tripay', '823367-260101204', 'MANDIRIVA', '', '266', '105020158', '260101204', 'T4646029715345EH23U', 'https://tripay.co.id/checkout/T4646029715345EH23U', '1767594436', '2026-01-05', '1767598156', '', 'PAID', '127125', '1767594744', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1704, 'Tripay', '362828-260101549', 'BNIVA', '', '637', '105020310', '260101549', 'T4646029715960GKQH6', 'https://tripay.co.id/checkout/T4646029715960GKQH6', '1767595463', '2026-01-05', '1767596482', '', 'PAID', '127125', '1767595606', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1705, 'Tripay', '11378-260101459', 'DANA', '', '540', '105020273', '260101459', 'T4646029716061PAJJO', 'https://tripay.co.id/checkout/T4646029716061PAJJO', '1767595634', '2026-01-05', '1767596653', '', 'PAID', '125000', '1767595684', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1706, 'Tripay', '809327-260101469', 'ALFAMIDI', '', '551', '105050016', '260101469', 'T4646029716119IB22N', 'https://tripay.co.id/checkout/T4646029716119IB22N', '1767595719', '2026-01-05', '1767599439', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1707, 'Tripay', '256738-260101455', 'MANDIRIVA', '', '535', '105020271', '260101455', 'T4646029717000A3SEH', 'https://tripay.co.id/checkout/T4646029717000A3SEH', '1767597135', '2026-01-05', '1767600855', '', 'PAID', '127125', '1767597352', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1708, 'Tripay', '522285-260101090', 'INDOMARET', '', '131', '105020082', '260101090', 'T4646029717478PSTOJ', 'https://tripay.co.id/checkout/T4646029717478PSTOJ', '1767597995', '2026-01-05', '1767599015', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1709, 'Tripay', '472784-260101840', 'INDOMARET', '', '937', '105020428', '260101840', 'T4646029717553ZE5FS', 'https://tripay.co.id/checkout/T4646029717553ZE5FS', '1767598115', '2026-01-05', '1767599135', '', 'UNPAID', '78750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1710, 'Tripay', '39293-260101772', 'INDOMARET', '', '867', '105020400', '260101772', 'T4646029717787ZH2XL', 'https://tripay.co.id/checkout/T4646029717787ZH2XL', '1767598496', '2026-01-05', '1767599516', '', 'PAID', '126750', '1767598537', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1711, 'Tripay', '409561-260101840', 'INDOMARET', '', '937', '105020428', '260101840', 'T4646029718401UXIDT', 'https://tripay.co.id/checkout/T4646029718401UXIDT', '1767599553', '2026-01-05', '1767600573', '', 'PAID', '78750', '1767599655', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1712, 'Tripay', '662755-260101774', 'BRIVA', '', '869', '105030102', '260101774', 'T46460297186271HK9D', 'https://tripay.co.id/checkout/T46460297186271HK9D', '1767599932', '2026-01-05', '1767603652', '', 'UNPAID', '167125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1713, 'Tripay', '115137-260101381', 'QRIS2', '', '458', '105030046', '260101381', 'T4646029719240RWEEJ', 'https://tripay.co.id/checkout/T4646029719240RWEEJ', '1767601012', '2026-01-05', '1767601732', '', 'PAID', '125000', '1767601167', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1714, 'Tripay', '889956-260101730', 'BRIVA', '', '825', '105030094', '260101730', 'T4646029719431VHNPK', 'https://tripay.co.id/checkout/T4646029719431VHNPK', '1767601340', '2026-01-05', '1767605060', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1715, 'Tripay', '674341-260101213', 'BRIVA', '', '276', '105030014', '260101213', 'T4646029719670UHR3R', 'https://tripay.co.id/checkout/T4646029719670UHR3R', '1767601768', '2026-01-05', '1767605479', '', 'PAID', '127125', '1767601825', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1716, 'Tripay', '855840-260101730', 'BRIVA', '', '825', '105030094', '260101730', 'T4646029719683VMCM6', 'https://tripay.co.id/checkout/T4646029719683VMCM6', '1767601796', '2026-01-05', '1767605516', '', 'PAID', '127125', '1767601907', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1717, 'Tripay', '45744-260101746', 'BCAVA', '', '841', '105020391', '260101746', 'T4646029719850XICJF', 'https://tripay.co.id/checkout/T4646029719850XICJF', '1767602076', '2026-01-05', '1767603095', '', 'PAID', '127750', '1767602103', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1718, 'Tripay', '532813-260101774', 'BRIVA', '', '869', '105030102', '260101774', 'T4646029720132HDF1Z', 'https://tripay.co.id/checkout/T4646029720132HDF1Z', '1767602569', '2026-01-05', '1767606282', '', 'PAID', '167125', '1767602616', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1719, 'Tripay', '254374-260101056', 'QRIS2', '', '84', '105020048', '260101056', 'T4646029720505AVRV1', 'https://tripay.co.id/checkout/T4646029720505AVRV1', '1767603252', '2026-01-05', '1767603971', '', 'PAID', '125000', '1767603304', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1720, 'Tripay', '672972-260101775', 'INDOMARET', '', '870', '105030103', '260101775', 'T4646029720666WE8OK', 'https://tripay.co.id/checkout/T4646029720666WE8OK', '1767603506', '2026-01-05', '1769878799', '', 'PAID', '126750', '1767606253', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1721, 'Tripay', '407445-260101074', 'MANDIRIVA', '', '107', '105010044', '260101074', 'T4646029720697IA5WA', 'https://tripay.co.id/checkout/T4646029720697IA5WA', '1767603569', '2026-01-05', '1767607289', '', 'UNPAID', '117125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1722, 'Tripay', '352806-260101805', 'INDOMARET', '', '901', '105010318', '260101805', 'T4646029720830WF6OB', 'https://tripay.co.id/checkout/T4646029720830WF6OB', '1767603822', '2026-01-05', '1767604842', '', 'PAID', '126750', '1767603905', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1723, 'Tripay', '746019-251201110', 'BRIVA', '', '158', '105010060', '251201110', 'T4646029721536EE7AJ', 'https://tripay.co.id/checkout/T4646029721536EE7AJ', '1767604913', '2026-01-05', '1767608624', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1724, 'Tripay', '155828-251201110', 'BRIVA', '', '158', '105010060', '251201110', 'T4646029721653R0WMD', 'https://tripay.co.id/checkout/T4646029721653R0WMD', '1767605107', '2026-01-05', '1767608827', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1725, 'Tripay', '76872-260101216', 'INDOMARET', '', '280', '105020162', '260101216', 'T4646029721744MPSLW', 'https://tripay.co.id/checkout/T4646029721744MPSLW', '1767605238', '2026-01-05', '1767606258', '', 'PAID', '126750', '1767605303', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1726, 'Tripay', '923522-260101140', 'MANDIRIVA', '', '190', '105020120', '260101140', 'T4646029721812HIFMX', 'https://tripay.co.id/checkout/T4646029721812HIFMX', '1767605325', '2026-01-05', '1767609045', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1727, 'Tripay', '603820-251201110', 'BRIVA', '', '158', '105010060', '251201110', 'T4646029722036P4RKQ', 'https://tripay.co.id/checkout/T4646029722036P4RKQ', '1767605719', '2026-01-05', '1767609438', '', 'PAID', '127125', '1767605802', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1728, 'Tripay', '943997-260101587', 'BRIVA', '', '676', '105010241', '260101587', 'T4646029722362R7JFW', 'https://tripay.co.id/checkout/T4646029722362R7JFW', '1767606278', '2026-01-05', '1767609989', '', 'PAID', '167125', '1767606334', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1729, 'Tripay', '369935-260101207', 'BRIVA', '', '269', '105020161', '260101207', 'T4646029722714UFNAD', 'https://tripay.co.id/checkout/T4646029722714UFNAD', '1767606770', '2026-01-05', '1767610489', '', 'PAID', '127125', '1767606897', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1730, 'Tripay', '895449-260101607', 'ALFAMART', '', '696', '105020333', '260101607', 'T4646029722810CX1VA', 'https://tripay.co.id/checkout/T4646029722810CX1VA', '1767606940', '2026-01-05', '1767693220', '', 'PAID', '126750', '1767607043', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1731, 'Tripay', '921800-260101344', 'MANDIRIVA', '', '417', '105020219', '260101344', 'T4646029722817K94CA', 'https://tripay.co.id/checkout/T4646029722817K94CA', '1767606960', '2026-01-05', '1767610672', '', 'PAID', '127125', '1767607057', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1732, 'Tripay', '417047-260102003', 'SHOPEEPAY', '', '990', '105050045', '260102003', 'T4646029723931D0KME', 'https://tripay.co.id/checkout/T4646029723931D0KME', '1767608701', '2026-01-05', '1767609720', '', 'UNPAID', '42630', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1733, 'Tripay', '697776-260101227', 'MANDIRIVA', '', '293', '105010113', '260101227', 'T46460297242953WY4L', 'https://tripay.co.id/checkout/T46460297242953WY4L', '1767609259', '2026-01-05', '1767612978', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1734, 'Tripay', '785860-260101227', 'MANDIRIVA', '', '293', '105010113', '260101227', 'T4646029724445SHLPE', 'https://tripay.co.id/checkout/T4646029724445SHLPE', '1767609505', '2026-01-05', '1767613217', '', 'PAID', '127125', '1767609557', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1735, 'Tripay', '433398-260101008', 'ALFAMART', '', '10', '105010004', '260101008', 'T4646029724759S8X9E', 'https://tripay.co.id/checkout/T4646029724759S8X9E', '1767610031', '2026-01-05', '1767613751', '', 'PAID', '166750', '1767610274', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1736, 'Tripay', '410904-260102003', 'SHOPEEPAY', '', '990', '105050045', '260102003', 'T46460297248218WVQL', 'https://tripay.co.id/checkout/T46460297248218WVQL', '1767610133', '2026-01-05', '1767611152', '', 'PAID', '42630', '1767610177', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1737, 'Tripay', '595163-260101458', 'QRIS2', '', '538', '105030063', '260101458', 'T4646029725038L6NW2', 'https://tripay.co.id/checkout/T4646029725038L6NW2', '1767610459', '2026-01-05', '1767611178', '', 'PAID', '165000', '1767610520', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1738, 'Tripay', '105415-260101510', 'INDOMARET', '', '596', '105050023', '260101510', 'T4646029725575WOBHC', 'https://tripay.co.id/checkout/T4646029725575WOBHC', '1767611058', '2026-01-05', '1767612077', '', 'PAID', '126750', '1767611314', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1739, 'Tripay', '695832-260101645', 'INDOMARET', '', '735', '105050031', '260101645', 'T4646029726252IAUFD', 'https://tripay.co.id/checkout/T4646029726252IAUFD', '1767612011', '2026-01-05', '1767613031', '', 'PAID', '126750', '1767612564', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1740, 'Tripay', '790672-260101642', 'DANA', '', '732', '105010267', '260101642', 'T4646029726342TUJPU', 'https://tripay.co.id/checkout/T4646029726342TUJPU', '1767612126', '2026-01-05', '1767613145', '', 'PAID', '125000', '1767612171', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1741, 'Tripay', '475051-260101248', 'INDOMARET', '', '315', '105010121', '260101248', 'T46460297263843HVMB', 'https://tripay.co.id/checkout/T46460297263843HVMB', '1767612177', '2026-01-05', '1767613197', '', 'PAID', '126750', '1767612769', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1742, 'Tripay', '337160-260101728', 'QRIS2', '', '823', '105010296', '260101728', 'T4646029726583A4XOY', 'https://tripay.co.id/checkout/T4646029726583A4XOY', '1767612408', '2026-01-05', '1767613128', '', 'PAID', '125000', '1767612482', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1743, 'Tripay', '107933-260101387', 'INDOMARET', '', '464', '105030047', '260101387', 'T4646029726701PRMBG', 'https://tripay.co.id/checkout/T4646029726701PRMBG', '1767612582', '2026-01-05', '1767613602', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1744, 'Tripay', '692237-260101026', 'ALFAMART', '', '40', '105020022', '260101026', 'T4646029727553SX0MM', 'https://tripay.co.id/checkout/T4646029727553SX0MM', '1767613559', '2026-01-05', '1767617279', '', 'PAID', '126750', '1767613937', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1745, 'Tripay', '213617-260101711', 'INDOMARET', '', '801', '105030092', '260101711', 'T464602972761873QYJ', 'https://tripay.co.id/checkout/T464602972761873QYJ', '1767613610', '2026-01-05', '1767614629', '', 'PAID', '166750', '1767613680', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1746, 'Tripay', '256419-260101189', 'INDOMARET', '', '247', '105010099', '260101189', 'T4646029727922V3CUG', 'https://tripay.co.id/checkout/T4646029727922V3CUG', '1767613946', '2026-01-05', '1767614965', '', 'PAID', '166750', '1767614072', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1747, 'Tripay', '321000-260101332', 'SHOPEEPAY', '', '403', '105020216', '260101332', 'T4646029727959DQOJE', 'https://tripay.co.id/checkout/T4646029727959DQOJE', '1767613987', '2026-01-05', '1767615006', '', 'PAID', '126875', '1767614051', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1748, 'Tripay', '60127-260101293', 'QRIS2', '', '361', '105020197', '260101293', 'T4646029728001RHR63', 'https://tripay.co.id/checkout/T4646029728001RHR63', '1767614033', '2026-01-05', '1767614752', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1749, 'Tripay', '493494-260101090', 'INDOMARET', '', '131', '105020082', '260101090', 'T4646029728235KGIKI', 'https://tripay.co.id/checkout/T4646029728235KGIKI', '1767614310', '2026-01-05', '1767615329', '', 'PAID', '126750', '1767614525', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1750, 'Tripay', '215047-260101359', 'ALFAMART', '', '434', '105050001', '260101359', 'T4646029728353SXMZJ', 'https://tripay.co.id/checkout/T4646029728353SXMZJ', '1767614451', '2026-01-05', '1767618170', '', 'PAID', '126750', '1767614511', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1751, 'Tripay', '523308-260101823', 'QRIS2', '', '920', '105010326', '260101823', 'T4646029728414VLW3R', 'https://tripay.co.id/checkout/T4646029728414VLW3R', '1767614509', '2026-01-05', '1767615228', '', 'PAID', '71000', '1767614573', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1752, 'Tripay', '957057-260101269', 'DANA', '', '337', '105030025', '260101269', 'T4646029728537EXA1G', 'https://tripay.co.id/checkout/T4646029728537EXA1G', '1767614653', '2026-01-05', '1767615672', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1753, 'Tripay', '246710-260101254', 'BRIVA', '', '321', '105030020', '260101254', 'T4646029728938KYUCP', 'https://tripay.co.id/checkout/T4646029728938KYUCP', '1767615065', '2026-01-05', '1767618784', '', 'PAID', '127125', '1767615175', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1754, 'Tripay', '438342-260101404', 'BRIVA', '', '483', '105030049', '260101404', 'T4646029729090MBJMI', 'https://tripay.co.id/checkout/T4646029729090MBJMI', '1767615218', '2026-01-05', '1767618929', '', 'PAID', '127125', '1767615266', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1755, 'Tripay', '492620-260101802', 'QRIS', '', '898', '105010316', '260101802', 'T4646029729126QDHSE', 'https://tripay.co.id/checkout/T4646029729126QDHSE', '1767615256', '2026-01-05', '1767615976', '', 'UNPAID', '22452', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1756, 'Tripay', '780247-260101382', 'INDOMARET', '', '459', '105020232', '260101382', 'T4646029729196WBGCJ', 'https://tripay.co.id/checkout/T4646029729196WBGCJ', '1767615339', '2026-01-05', '1767616359', '', 'PAID', '126750', '1767615402', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1757, 'Tripay', '966923-260101269', 'DANA', '', '337', '105030025', '260101269', 'T46460297292389LWCG', 'https://tripay.co.id/checkout/T46460297292389LWCG', '1767615384', '2026-01-05', '1767616403', '', 'PAID', '125000', '1767615397', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1758, 'Tripay', '10524-260101802', 'QRIS', '', '898', '105010316', '260101802', 'T4646029729604QVF06', 'https://tripay.co.id/checkout/T4646029729604QVF06', '1767615761', '2026-01-05', '1767616481', '', 'PAID', '22452', '1767615816', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1759, 'Tripay', '160933-260101605', 'QRIS', '', '694', '105010249', '260101605', 'T46460297297641LYQG', 'https://tripay.co.id/checkout/T46460297297641LYQG', '1767615911', '2026-01-05', '1767616631', '', 'PAID', '125812', '1767616015', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1760, 'Tripay', '145549-260101268', 'BRIVA', '', '336', '105020183', '260101268', 'T4646029730032RC4DU', 'https://tripay.co.id/checkout/T4646029730032RC4DU', '1767616199', '2026-01-05', '1767619918', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1761, 'Tripay', '99729-260101445', 'QRIS2', '', '525', '105020266', '260101445', 'T4646029730443UXNRD', 'https://tripay.co.id/checkout/T4646029730443UXNRD', '1767616649', '2026-01-05', '1767617369', '', 'PAID', '125000', '1767616679', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1762, 'Tripay', '734794-260101345', 'MANDIRIVA', '', '418', '105020220', '260101345', 'T4646029730598YDVSE', 'https://tripay.co.id/checkout/T4646029730598YDVSE', '1767616825', '2026-01-05', '1767620537', '', 'PAID', '127125', '1767616912', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1763, 'Tripay', '288855-260101327', 'SHOPEEPAY', '', '398', '105030034', '260101327', 'T46460297306224A9ME', 'https://tripay.co.id/checkout/T46460297306224A9ME', '1767616844', '2026-01-05', '1767617864', '', 'UNPAID', '167475', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1764, 'Tripay', '118436-260101327', 'QRIS2', '', '398', '105030034', '260101327', 'T46460297306302GHKE', 'https://tripay.co.id/checkout/T46460297306302GHKE', '1767616866', '2026-01-05', '1767617586', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1765, 'Tripay', '739715-260101417', 'ALFAMART', '', '497', '105010185', '260101417', 'T4646029730658JIOWE', 'https://tripay.co.id/checkout/T4646029730658JIOWE', '1767616894', '2026-01-05', '1767703174', '', 'PAID', '126750', '1767617295', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1766, 'Tripay', '592148-260101327', 'QRIS2', '', '398', '105030034', '260101327', 'T46460297306592ZP04', 'https://tripay.co.id/checkout/T46460297306592ZP04', '1767616896', '2026-01-05', '1767617615', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1767, 'Tripay', '192549-260101268', 'BRIVA', '', '336', '105020183', '260101268', 'T4646029731215RXVR0', 'https://tripay.co.id/checkout/T4646029731215RXVR0', '1767617518', '2026-01-05', '1767621230', '', 'PAID', '127125', '1767617881', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1768, 'Tripay', '742571-260101293', 'QRIS2', '', '361', '105020197', '260101293', 'T4646029731641GLT8L', 'https://tripay.co.id/checkout/T4646029731641GLT8L', '1767617986', '2026-01-05', '1767618706', '', 'PAID', '125000', '1767618028', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1769, 'Tripay', '572529-260101082', 'BRIVA', '', '120', '105010047', '260101082', 'T4646029731931LIHB1', 'https://tripay.co.id/checkout/T4646029731931LIHB1', '1767618312', '2026-01-05', '1767622023', '', 'PAID', '127125', '1767618433', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1770, 'Tripay', '589326-260101263', 'BRIVA', '', '330', '105030023', '260101263', 'T4646029731966IKKYK', 'https://tripay.co.id/checkout/T4646029731966IKKYK', '1767618353', '2026-01-05', '1767622072', '', 'PAID', '127125', '1767618427', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1771, 'Tripay', '60625-260101326', 'QRIS2', '', '397', '105020214', '260101326', 'T46460297320377RTIZ', 'https://tripay.co.id/checkout/T46460297320377RTIZ', '1767618437', '2026-01-05', '1767619157', '', 'PAID', '165000', '1767618534', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1772, 'Tripay', '371046-260101796', 'SHOPEEPAY', '', '892', '105020408', '260101796', 'T4646029732133MWGVH', 'https://tripay.co.id/checkout/T4646029732133MWGVH', '1767618534', '2026-01-05', '1767619554', '', 'UNPAID', '126875', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1773, 'Tripay', '578803-260101796', 'SHOPEEPAY', '', '892', '105020408', '260101796', 'T4646029732162PXWOV', 'https://tripay.co.id/checkout/T4646029732162PXWOV', '1767618563', '2026-01-05', '1767619583', '', 'PAID', '126875', '1767618634', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1774, 'Tripay', '342486-260101761', 'INDOMARET', '', '856', '105010309', '260101761', 'T4646029733313GMTVO', 'https://tripay.co.id/checkout/T4646029733313GMTVO', '1767619950', '2026-01-05', '1767620970', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1775, 'Tripay', '729022-260101368', 'BRIVA', '', '444', '105020226', '260101368', 'T4646029734093EROGL', 'https://tripay.co.id/checkout/T4646029734093EROGL', '1767621014', '2026-01-05', '1767624726', '', 'PAID', '127125', '1767621217', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1776, 'Tripay', '978713-260101327', 'QRIS2', '', '398', '105030034', '260101327', 'T4646029734131UZQ8D', 'https://tripay.co.id/checkout/T4646029734131UZQ8D', '1767621060', '2026-01-05', '1767621780', '', 'UNPAID', '165000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1777, 'Tripay', '433073-260101327', 'QRIS2', '', '398', '105030034', '260101327', 'T46460297341368NXMI', 'https://tripay.co.id/checkout/T46460297341368NXMI', '1767621069', '2026-01-05', '1767621788', '', 'PAID', '165000', '1767621121', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1778, 'Tripay', '429814-260101449', 'DANA', '', '529', '105030058', '260101449', 'T4646029734170AVSBX', 'https://tripay.co.id/checkout/T4646029734170AVSBX', '1767621135', '2026-01-05', '1767622154', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1779, 'Tripay', '551127-260101045', 'DANA', '', '65', '105020038', '260101045', 'T46460297342101VEIO', 'https://tripay.co.id/checkout/T46460297342101VEIO', '1767621192', '2026-01-05', '1767622212', '', 'PAID', '125000', '1767621239', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1780, 'Tripay', '159889-260101761', 'INDOMARET', '', '856', '105010309', '260101761', 'T4646029734458NVQDY', 'https://tripay.co.id/checkout/T4646029734458NVQDY', '1767621545', '2026-01-05', '1767622565', '', 'PAID', '126750', '1767621770', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1781, 'Tripay', '452325-260101385', 'BCAVA', '', '462', '105020234', '260101385', 'T4646029734545FIJLF', 'https://tripay.co.id/checkout/T4646029734545FIJLF', '1767621702', '2026-01-05', '1767622722', '', 'PAID', '127750', '1767621947', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1782, 'Tripay', '172161-260101285', 'QRIS2', '', '353', '105010133', '260101285', 'T4646029734824NXW5Q', 'https://tripay.co.id/checkout/T4646029734824NXW5Q', '1767622093', '2026-01-05', '1767622813', '', 'PAID', '165000', '1767622124', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1783, 'Tripay', '721546-260101881', 'ALFAMART', '', '978', '105010344', '260101881', 'T4646029734971E6XMM', 'https://tripay.co.id/checkout/T4646029734971E6XMM', '1767622298', '2026-01-05', '1767626018', '', 'UNPAID', '43750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1784, 'Tripay', '944533-260101119', 'INDOMARET', '', '164', '105020103', '260101119', 'T4646029735188WNH5G', 'https://tripay.co.id/checkout/T4646029735188WNH5G', '1767622640', '2026-01-05', '1767623660', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1785, 'Tripay', '445659-260101070', 'BNIVA', '', '103', '105020062', '260101070', 'T46460297353837L1JP', 'https://tripay.co.id/checkout/T46460297353837L1JP', '1767622945', '2026-01-05', '1767623964', '', 'PAID', '167125', '1767623009', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1786, 'Tripay', '890493-260101671', 'BRIVA', '', '761', '105010275', '260101671', 'T4646029735665KCWOA', 'https://tripay.co.id/checkout/T4646029735665KCWOA', '1767623299', '2026-01-05', '1767627019', '', 'PAID', '127125', '1767623627', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1787, 'Tripay', '647272-260101672', 'BRIVA', '', '762', '105010276', '260101672', 'T46460297358952XNYZ', 'https://tripay.co.id/checkout/T46460297358952XNYZ', '1767623675', '2026-01-05', '1767627386', '', 'PAID', '127125', '1767623717', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1788, 'Tripay', '978064-260101392', 'INDOMARET', '', '470', '105020239', '260101392', 'T4646029735989DR27W', 'https://tripay.co.id/checkout/T4646029735989DR27W', '1767623845', '2026-01-05', '1767624865', '', 'PAID', '126750', '1767623926', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1789, 'Tripay', '705953-260101449', 'DANA', '', '529', '105030058', '260101449', 'T4646029736172JMCB5', 'https://tripay.co.id/checkout/T4646029736172JMCB5', '1767624184', '2026-01-05', '1767625204', '', 'PAID', '125000', '1767624212', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1790, 'Tripay', '119059-260101658', 'QRIS2', '', '748', '105020352', '260101658', 'T464602973644790N7W', 'https://tripay.co.id/checkout/T464602973644790N7W', '1767624701', '2026-01-05', '1767625421', '', 'PAID', '125000', '1767624850', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1791, 'Tripay', '954514-260101881', 'QRIS2', '', '978', '105010344', '260101881', 'T4646029736532E9WOC', 'https://tripay.co.id/checkout/T4646029736532E9WOC', '1767624885', '2026-01-05', '1767625605', '', 'PAID', '42000', '1767624928', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1792, 'Tripay', '819853-260101723', 'ALFAMART', '', '818', '105050040', '260101723', 'T464602973653981FAD', 'https://tripay.co.id/checkout/T464602973653981FAD', '1767624899', '2026-01-05', '1767628619', '', 'PAID', '126750', '1767624940', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1793, 'Tripay', '113140-260101287', 'INDOMARET', '', '355', '105020193', '260101287', 'T4646029736583BNFCP', 'https://tripay.co.id/checkout/T4646029736583BNFCP', '1767625010', '2026-01-05', '1767626030', '', 'PAID', '166750', '1767625593', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1794, 'Tripay', '398230-260101119', 'INDOMARET', '', '164', '105020103', '260101119', 'T4646029736815DWQRJ', 'https://tripay.co.id/checkout/T4646029736815DWQRJ', '1767625493', '2026-01-05', '1767626513', '', 'PAID', '166750', '1767625966', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1795, 'Tripay', '74717-260101022', 'INDOMARET', '', '36', '105020018', '260101022', 'T4646029736979EQ9PQ', 'https://tripay.co.id/checkout/T4646029736979EQ9PQ', '1767625871', '2026-01-05', '1767626890', '', 'PAID', '126750', '1767626160', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1796, 'Tripay', '955061-260101394', 'MANDIRIVA', '', '472', '105010175', '260101394', 'T4646029737296DZJWY', 'https://tripay.co.id/checkout/T4646029737296DZJWY', '1767626575', '2026-01-05', '1767630294', '', 'PAID', '127125', '1767626680', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1797, 'Tripay', '900967-260101078', 'BCAVA', '', '114', '105010045', '260101078', 'T4646029737973CDIQS', 'https://tripay.co.id/checkout/T4646029737973CDIQS', '1767628390', '2026-01-05', '1767629410', '', 'PAID', '127750', '1767628462', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1798, 'Tripay', '91327-260101472', 'BRIVA', '', '554', '105010198', '260101472', 'T4646029739024XYSD6', 'https://tripay.co.id/checkout/T4646029739024XYSD6', '1767631948', '2026-01-05', '1767635659', '', 'PAID', '207125', '1767632282', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1799, 'Tripay', '240182-260101296', 'BRIVA', '', '364', '105020199', '260101296', 'T4646029741069MO1XP', 'https://tripay.co.id/checkout/T4646029741069MO1XP', '1767649271', '2026-01-06', '1767652983', '', 'PAID', '127125', '1767649443', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1800, 'Tripay', '843812-260101244', 'BCAVA', '', '311', '105010119', '260101244', 'T4646029741120KXSJV', 'https://tripay.co.id/checkout/T4646029741120KXSJV', '1767649670', '2026-01-06', '1767650690', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1801, 'Tripay', '25275-260101244', 'BCAVA', '', '311', '105010119', '260101244', 'T464602974112594UJZ', 'https://tripay.co.id/checkout/T464602974112594UJZ', '1767649710', '2026-01-06', '1767650730', '', 'PAID', '127750', '1767649813', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1802, 'Tripay', '503851-260101592', 'INDOMARET', '', '681', '105020327', '260101592', 'T4646029742264TMIER', 'https://tripay.co.id/checkout/T4646029742264TMIER', '1767654989', '2026-01-06', '1767656009', '', 'UNPAID', '166750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1803, 'Tripay', '769384-260101829', 'DANA', '', '926', '105020422', '260101829', 'T4646029744195VDPWW', 'https://tripay.co.id/checkout/T4646029744195VDPWW', '1767660397', '2026-01-06', '1767661416', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1804, 'Tripay', '389710-260101880', 'INDOMARET', '', '977', '105030116', '260101880', 'T4646029745930036BB', 'https://tripay.co.id/checkout/T4646029745930036BB', '1767663993', '2026-01-06', '1767665013', '', 'UNPAID', '22750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1805, 'Tripay', '641220-260101882', 'INDOMARET', '', '979', '105030117', '260101882', 'T4646029746126WRHPS', 'https://tripay.co.id/checkout/T4646029746126WRHPS', '1767664378', '2026-01-06', '1767665397', '', 'UNPAID', '22750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1806, 'Tripay', '820880-260101523', 'QRIS', '', '611', '105010215', '260101523', 'T4646029746478FQABZ', 'https://tripay.co.id/checkout/T4646029746478FQABZ', '1767664904', '2026-01-06', '1767665624', '', 'UNPAID', '125812', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1807, 'Tripay', '313028-260101469', 'ALFAMART', '', '551', '105050016', '260101469', 'T4646029747811HBLFM', 'https://tripay.co.id/checkout/T4646029747811HBLFM', '1767666586', '2026-01-06', '1767670306', '', 'PAID', '126750', '1767668666', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1808, 'Tripay', '904011-260101880', 'INDOMARET', '', '977', '105030116', '260101880', 'T4646029748246AVUCT', 'https://tripay.co.id/checkout/T4646029748246AVUCT', '1767667380', '2026-01-06', '1767668401', '', 'PAID', '22750', '1767667445', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1809, 'Tripay', '363600-260101882', 'INDOMARET', '', '979', '105030117', '260101882', 'T4646029748336UNA3R', 'https://tripay.co.id/checkout/T4646029748336UNA3R', '1767667568', '2026-01-06', '1767668588', '', 'PAID', '22750', '1767667614', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1810, 'Tripay', '146514-260101387', 'INDOMARET', '', '464', '105030047', '260101387', 'T4646029750352TS12I', 'https://tripay.co.id/checkout/T4646029750352TS12I', '1767671429', '2026-01-06', '1767672449', '', 'PAID', '126750', '1767671981', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1811, 'Tripay', '920296-260101694', 'INDOMARET', '', '784', '105040002', '260101694', 'T46460297512679TT0X', 'https://tripay.co.id/checkout/T46460297512679TT0X', '1767673099', '2026-01-06', '1767674118', '', 'PAID', '166750', '1767673494', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1812, 'Tripay', '742412-260101770', 'INDOMARET', '', '865', '105020398', '260101770', 'T4646029753108LK3LU', 'https://tripay.co.id/checkout/T4646029753108LK3LU', '1767675603', '2026-01-06', '1767676622', '', 'PAID', '126750', '1767676134', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1813, 'Tripay', '490885-260101013', 'BCAVA', '', '19', '105020009', '260101013', 'T4646029755794BUIDC', 'https://tripay.co.id/checkout/T4646029755794BUIDC', '1767679870', '2026-01-06', '1767680889', '', 'PAID', '207750', '1767680509', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1814, 'Tripay', '619863-260101436', 'BRIVA', '', '516', '105020261', '260101436', 'T4646029756490YCGPH', 'https://tripay.co.id/checkout/T4646029756490YCGPH', '1767681510', '2026-01-06', '1767685222', '', 'PAID', '167125', '1767681738', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1815, 'Tripay', '87791-260101388', 'QRIS2', '', '466', '105020236', '260101388', 'T4646029757113AVJUL', 'https://tripay.co.id/checkout/T4646029757113AVJUL', '1767682958', '2026-01-06', '1767683678', '', 'PAID', '125000', '1767682994', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1816, 'Tripay', '249940-260101406', 'SHOPEEPAY', '', '485', '105030050', '260101406', 'T4646029758054OSGBQ', 'https://tripay.co.id/checkout/T4646029758054OSGBQ', '1767685207', '2026-01-06', '1767686224', '', 'UNPAID', '167475', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1817, 'Tripay', '155566-260101884', 'SHOPEEPAY', '', '981', '105010346', '260101884', 'T4646029758056SFWDV', 'https://tripay.co.id/checkout/T4646029758056SFWDV', '1767685211', '2026-01-06', '1767686230', '', 'PAID', '42630', '1767685263', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1818, 'Tripay', '203090-260101406', 'MANDIRIVA', '', '485', '105030050', '260101406', 'T46460297580847SKZD', 'https://tripay.co.id/checkout/T46460297580847SKZD', '1767685269', '2026-01-06', '1767688980', '', 'PAID', '167125', '1767685507', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1819, 'Tripay', '476237-260101101', 'BNIVA', '', '144', '105010052', '260101101', 'T46460297581510Y87I', 'https://tripay.co.id/checkout/T46460297581510Y87I', '1767685403', '2026-01-06', '1767686422', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1820, 'Tripay', '114060-260101101', 'QRIS2', '', '144', '105010052', '260101101', 'T4646029758200EX909', 'https://tripay.co.id/checkout/T4646029758200EX909', '1767685520', '2026-01-06', '1767686240', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1821, 'Tripay', '83664-260101820', 'BCAVA', '', '917', '105020419', '260101820', 'T4646029758206TQZJY', 'https://tripay.co.id/checkout/T4646029758206TQZJY', '1767685526', '2026-01-06', '1767686546', '', 'PAID', '86750', '1767685595', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1822, 'Tripay', '200043-260101508', 'BCAVA', '', '594', '105020293', '260101508', 'T46460297584911LKUT', 'https://tripay.co.id/checkout/T46460297584911LKUT', '1767686182', '2026-01-06', '1767687202', '', 'PAID', '127750', '1767686215', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1823, 'Tripay', '156860-260101550', 'BRIVA', '', '638', '105020311', '260101550', 'T4646029758746XP7JB', 'https://tripay.co.id/checkout/T4646029758746XP7JB', '1767686799', '2026-01-06', '1767690510', '', 'PAID', '127125', '1767686839', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1824, 'Tripay', '963046-260101369', 'BCAVA', '', '445', '105020227', '260101369', 'T4646029758814RJ5BO', 'https://tripay.co.id/checkout/T4646029758814RJ5BO', '1767686961', '2026-01-06', '1767687981', '', 'PAID', '127750', '1767687040', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1825, 'Tripay', '161179-260101101', 'QRIS2', '', '144', '105010052', '260101101', 'T4646029758841T3CIG', 'https://tripay.co.id/checkout/T4646029758841T3CIG', '1767687007', '2026-01-06', '1767687726', '', 'PAID', '125000', '1767687129', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1826, 'Tripay', '352877-260101636', 'MANDIRIVA', '', '726', '105020345', '260101636', 'T4646029758983MXST2', 'https://tripay.co.id/checkout/T4646029758983MXST2', '1767687331', '2026-01-06', '1767691050', '', 'PAID', '127125', '1767687482', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1827, 'Tripay', '254382-260101491', 'DANA', '', '576', '105020286', '260101491', 'T4646029759092YLO9H', 'https://tripay.co.id/checkout/T4646029759092YLO9H', '1767687628', '2026-01-06', '1767688647', '', 'PAID', '125000', '1767687655', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1828, 'Tripay', '549909-260101106', 'INDOMARET', '', '149', '105010053', '260101106', 'T4646029759304GGJB3', 'https://tripay.co.id/checkout/T4646029759304GGJB3', '1767688171', '2026-01-06', '1767689190', '', 'PAID', '126750', '1767688326', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1829, 'Tripay', '653967-260101174', 'BCAVA', '', '230', '105010093', '260101174', 'T4646029759772L6RAO', 'https://tripay.co.id/checkout/T4646029759772L6RAO', '1767689229', '2026-01-06', '1767690249', '', 'PAID', '127750', '1767689289', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1830, 'Tripay', '261785-260101313', 'INDOMARET', '', '382', '105010142', '260101313', 'T4646029759962KNJIU', 'https://tripay.co.id/checkout/T4646029759962KNJIU', '1767689711', '2026-01-06', '1767690731', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1831, 'Tripay', '859466-260101315', 'INDOMARET', '', '384', '105020209', '260101315', 'T4646029760197DHCQH', 'https://tripay.co.id/checkout/T4646029760197DHCQH', '1767690243', '2026-01-06', '1767691263', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1832, 'Tripay', '39031-260101505', 'BCAVA', '', '591', '105030070', '260101505', 'T46460297604240KDXD', 'https://tripay.co.id/checkout/T46460297604240KDXD', '1767690815', '2026-01-06', '1767691834', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1833, 'Tripay', '451801-260101505', 'QRIS2', '', '591', '105030070', '260101505', 'T4646029760438CKVLO', 'https://tripay.co.id/checkout/T4646029760438CKVLO', '1767690845', '2026-01-06', '1767691565', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1834, 'Tripay', '441152-260101596', 'QRIS2', '', '685', '105010245', '260101596', 'T4646029760442TIP0X', 'https://tripay.co.id/checkout/T4646029760442TIP0X', '1767690851', '2026-01-06', '1767691570', '', 'PAID', '125000', '1767691022', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1835, 'Tripay', '257436-260101505', 'QRIS2', '', '591', '105030070', '260101505', 'T4646029760451XYFJ1', 'https://tripay.co.id/checkout/T4646029760451XYFJ1', '1767690871', '2026-01-06', '1767691591', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1836, 'Tripay', '941614-260101596', 'QRIS2', '', '685', '105010245', '260101596', 'T4646029760455CQWCS', 'https://tripay.co.id/checkout/T4646029760455CQWCS', '1767690885', '2026-01-06', '1767691605', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1837, 'Tripay', '844568-260101744', 'INDOMARET', '', '839', '105020390', '260101744', 'T46460297605496KNZY', 'https://tripay.co.id/checkout/T46460297605496KNZY', '1767691066', '2026-01-06', '1767692086', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1838, 'Tripay', '214836-260106001', 'BRIVA', '', '956', '105010340', '260106001', 'T4646029760555HGAYI', 'https://tripay.co.id/checkout/T4646029760555HGAYI', '1767691083', '2026-01-06', '1767694795', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1839, 'Tripay', '473490-260101315', 'INDOMARET', '', '384', '105020209', '260101315', 'T4646029760586PEXFJ', 'https://tripay.co.id/checkout/T4646029760586PEXFJ', '1767691146', '2026-01-06', '1767692166', '', 'PAID', '126750', '1767691272', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1840, 'Tripay', '860908-260101719', 'BCAVA', '', '811', '105010292', '260101719', 'T4646029760634ZCOVT', 'https://tripay.co.id/checkout/T4646029760634ZCOVT', '1767691276', '2026-01-06', '1767692296', '', 'PAID', '127750', '1767691329', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1841, 'Tripay', '520946-260101618', 'MANDIRIVA', '', '707', '105010255', '260101618', 'T4646029760715P9GZ8', 'https://tripay.co.id/checkout/T4646029760715P9GZ8', '1767691485', '2026-01-06', '1767695204', '', 'PAID', '127125', '1767691586', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1842, 'Tripay', '848478-260101398', 'BRIVA', '', '477', '105020242', '260101398', 'T46460297607471CBDE', 'https://tripay.co.id/checkout/T46460297607471CBDE', '1767691554', '2026-01-06', '1767695274', '', 'PAID', '127125', '1767691687', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1843, 'Tripay', '440099-260101378', 'QRIS2', '', '455', '105010172', '260101378', 'T4646029760906I0LXT', 'https://tripay.co.id/checkout/T4646029760906I0LXT', '1767691850', '2026-01-06', '1767692569', '', 'PAID', '125000', '1767691883', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1844, 'Tripay', '380102-260101677', 'QRIS', '', '767', '105020362', '260101677', 'T4646029760923X6AHV', 'https://tripay.co.id/checkout/T4646029760923X6AHV', '1767691891', '2026-01-06', '1767692610', '', 'PAID', '125812', '1767691920', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1845, 'Tripay', '255906-260101741', 'MANDIRIVA', '', '836', '105030097', '260101741', 'T4646029760985DYYAB', 'https://tripay.co.id/checkout/T4646029760985DYYAB', '1767692016', '2026-01-06', '1767695735', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1846, 'Tripay', '944952-260101052', 'QRIS2', '', '77', '105010033', '260101052', 'T4646029761069HJCNB', 'https://tripay.co.id/checkout/T4646029761069HJCNB', '1767692210', '2026-01-06', '1767692930', '', 'PAID', '125000', '1767692302', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1847, 'Tripay', '658952-260101741', 'MANDIRIVA', '', '836', '105030097', '260101741', 'T4646029761117WFWGE', 'https://tripay.co.id/checkout/T4646029761117WFWGE', '1767692308', '2026-01-06', '1767696028', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1848, 'Tripay', '268409-260101870', 'BCAVA', '', '967', '105020441', '260101870', 'T4646029761153ZSXNQ', 'https://tripay.co.id/checkout/T4646029761153ZSXNQ', '1767692372', '2026-01-06', '1767693392', '', 'PAID', '36750', '1767692477', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1849, 'Tripay', '841628-260101061', 'BNIVA', '', '89', '105020053', '260101061', 'T4646029761413CVWZC', 'https://tripay.co.id/checkout/T4646029761413CVWZC', '1767692857', '2026-01-06', '1767693869', '', 'PAID', '127125', '1767692961', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1850, 'Tripay', '119742-260101443', 'DANA', '', '523', '105020264', '260101443', 'T4646029761421WE1AI', 'https://tripay.co.id/checkout/T4646029761421WE1AI', '1767692876', '2026-01-06', '1767693896', '', 'PAID', '165000', '1767692897', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1851, 'Tripay', '720369-260101083', 'QRIS2', '', '121', '105010048', '260101083', 'T4646029761560JG8U9', 'https://tripay.co.id/checkout/T4646029761560JG8U9', '1767693173', '2026-01-06', '1767693892', '', 'PAID', '125000', '1767693222', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1852, 'Tripay', '345232-260101582', 'DANA', '', '671', '105020320', '260101582', 'T4646029761653KSH4N', 'https://tripay.co.id/checkout/T4646029761653KSH4N', '1767693375', '2026-01-06', '1767694394', '', 'PAID', '125000', '1767693394', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1853, 'Tripay', '202555-251201079', 'QRIS2', '', '121', '105010048', '251201079', 'T4646029761663NVHWE', 'https://tripay.co.id/checkout/T4646029761663NVHWE', '1767693398', '2026-01-06', '1767694117', '', 'PAID', '125000', '1767693428', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1854, 'Tripay', '349588-260101313', 'INDOMARET', '', '382', '105010142', '260101313', 'T4646029761799KH3YB', 'https://tripay.co.id/checkout/T4646029761799KH3YB', '1767693725', '2026-01-06', '1767694745', '', 'PAID', '126750', '1767694108', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1855, 'Tripay', '315637-260101855', 'DANA', '', '952', '105010338', '260101855', 'T4646029761935FGKSM', 'https://tripay.co.id/checkout/T4646029761935FGKSM', '1767693937', '2026-01-06', '1767694956', '', 'PAID', '125000', '1767693954', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1856, 'Tripay', '644665-260101105', 'DANA', '', '148', '105020096', '260101105', 'T4646029761947FGWZY', 'https://tripay.co.id/checkout/T4646029761947FGWZY', '1767693952', '2026-01-06', '1767694971', '', 'PAID', '125000', '1767694175', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1857, 'Tripay', '155486-260101771', 'QRIS2', '', '866', '105020399', '260101771', 'T4646029762057YCSZJ', 'https://tripay.co.id/checkout/T4646029762057YCSZJ', '1767694184', '2026-01-06', '1767694904', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1858, 'Tripay', '54153-260101162', 'MANDIRIVA', '', '216', '105020134', '260101162', 'T4646029762197FWCBW', 'https://tripay.co.id/checkout/T4646029762197FWCBW', '1767694471', '2026-01-06', '1767698190', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1859, 'Tripay', '294835-260101442', 'MANDIRIVA', '', '522', '105030057', '260101442', 'T4646029762268NP5YI', 'https://tripay.co.id/checkout/T4646029762268NP5YI', '1767694609', '2026-01-06', '1767698328', '', 'PAID', '167125', '1767694723', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1860, 'Tripay', '637186-260101336', 'MANDIRIVA', '', '407', '105010155', '260101336', 'T4646029762301Z9QJK', 'https://tripay.co.id/checkout/T4646029762301Z9QJK', '1767694685', '2026-01-06', '1767698397', '', 'PAID', '127125', '1767694769', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1861, 'Tripay', '218611-260101316', 'BCAVA', '', '387', '105010145', '260101316', 'T4646029762365ZPIFR', 'https://tripay.co.id/checkout/T4646029762365ZPIFR', '1767694821', '2026-01-06', '1767695840', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1862, 'Tripay', '471553-260101495', 'QRIS2', '', '581', '105020288', '260101495', 'T4646029762394TGHKC', 'https://tripay.co.id/checkout/T4646029762394TGHKC', '1767694888', '2026-01-06', '1767695608', '', 'PAID', '125000', '1767694928', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1863, 'Tripay', '738916-260101857', 'BCAVA', '', '954', '105020436', '260101857', 'T4646029762506IOFT5', 'https://tripay.co.id/checkout/T4646029762506IOFT5', '1767695151', '2026-01-06', '1767696171', '', 'PAID', '127750', '1767695231', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1864, 'Tripay', '91429-260101412', 'BNIVA', '', '492', '105010183', '260101412', 'T4646029762556SVEFO', 'https://tripay.co.id/checkout/T4646029762556SVEFO', '1767695263', '2026-01-06', '1767696283', '', 'PAID', '127125', '1767695404', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1865, 'Tripay', '786337-260101717', 'BCAVA', '', '809', '105020378', '260101717', 'T4646029762625BRTD0', 'https://tripay.co.id/checkout/T4646029762625BRTD0', '1767695377', '2026-01-06', '1767696397', '', 'PAID', '127750', '1767695438', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1866, 'Tripay', '511422-260101098', 'ALFAMART', '', '140', '105020089', '260101098', 'T46460297628949MRQZ', 'https://tripay.co.id/checkout/T46460297628949MRQZ', '1767695896', '2026-01-06', '1767699615', '', 'PAID', '126750', '1767698502', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1867, 'Tripay', '737923-260101068', 'QRIS2', '', '101', '105020060', '260101068', 'T4646029763432W39VM', 'https://tripay.co.id/checkout/T4646029763432W39VM', '1767696998', '2026-01-06', '1767697718', '', 'PAID', '125000', '1767697044', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1868, 'Tripay', '183919-260101876', 'QRIS2', '', '973', '105020447', '260101876', 'T4646029763569C5BGD', 'https://tripay.co.id/checkout/T4646029763569C5BGD', '1767697263', '2026-01-06', '1767697983', '', 'PAID', '25000', '1767697473', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1869, 'Tripay', '150280-260101088', 'BRIVA', '', '128', '105020079', '260101088', 'T4646029763859NPX7M', 'https://tripay.co.id/checkout/T4646029763859NPX7M', '1767697808', '2026-01-06', '1767701527', '', 'PAID', '127125', '1767697874', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1870, 'Tripay', '355517-260101729', 'INDOMARET', '', '824', '105020383', '260101729', 'T4646029763920CVIO2', 'https://tripay.co.id/checkout/T4646029763920CVIO2', '1767697902', '2026-01-06', '1767698921', '', 'PAID', '126750', '1767698235', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1871, 'Tripay', '880164-260101722', 'BRIVA', '', '817', '105050039', '260101722', 'T4646029764065TS7LB', 'https://tripay.co.id/checkout/T4646029764065TS7LB', '1767698168', '2026-01-06', '1767701888', '', 'PAID', '127125', '1767698227', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1872, 'Tripay', '112061-260101702', 'ALFAMART', '', '792', '105020370', '260101702', 'T46460297640784WRZK', 'https://tripay.co.id/checkout/T46460297640784WRZK', '1767698201', '2026-01-06', '1767701921', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1873, 'Tripay', '57872-260101715', 'BCAVA', '', '807', '105030093', '260101715', 'T4646029764226TIPRD', 'https://tripay.co.id/checkout/T4646029764226TIPRD', '1767698494', '2026-01-06', '1767699514', '', 'PAID', '127750', '1767698524', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1874, 'Tripay', '47802-260101643', 'INDOMARET', '', '733', '105050029', '260101643', 'T4646029764568TAIAJ', 'https://tripay.co.id/checkout/T4646029764568TAIAJ', '1767699074', '2026-01-06', '1767700094', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1875, 'Tripay', '882756-260101352', 'BCAVA', '', '427', '105020222', '260101352', 'T4646029764602VUQSS', 'https://tripay.co.id/checkout/T4646029764602VUQSS', '1767699135', '2026-01-06', '1767700155', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1876, 'Tripay', '637771-260101352', 'BNIVA', '', '427', '105020222', '260101352', 'T4646029764651PHM7I', 'https://tripay.co.id/checkout/T4646029764651PHM7I', '1767699238', '2026-01-06', '1767700258', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1877, 'Tripay', '835528-260101702', 'INDOMARET', '', '792', '105020370', '260101702', 'T4646029764768CP37E', 'https://tripay.co.id/checkout/T4646029764768CP37E', '1767699475', '2026-01-06', '1767700495', '', 'PAID', '126750', '1767699592', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1878, 'Tripay', '348557-260101501', 'ALFAMART', '', '587', '105010207', '260101501', 'T4646029764781BX2WC', 'https://tripay.co.id/checkout/T4646029764781BX2WC', '1767699492', '2026-01-06', '1767703211', '', 'PAID', '126750', '1767699521', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1879, 'Tripay', '225731-260101352', 'INDOMARET', '', '427', '105020222', '260101352', 'T4646029764807ZZHVH', 'https://tripay.co.id/checkout/T4646029764807ZZHVH', '1767699548', '2026-01-06', '1767700568', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1880, 'Tripay', '408373-260101463', 'BCAVA', '', '545', '105010194', '260101463', 'T4646029764870AGCZM', 'https://tripay.co.id/checkout/T4646029764870AGCZM', '1767699662', '2026-01-06', '1767700682', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1881, 'Tripay', '646257-260101463', 'BCAVA', '', '545', '105010194', '260101463', 'T46460297649561CGHE', 'https://tripay.co.id/checkout/T46460297649561CGHE', '1767699830', '2026-01-06', '1767700849', '', 'PAID', '127750', '1767699945', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1882, 'Tripay', '522300-260101170', 'SHOPEEPAY', '', '224', '105010089', '260101170', 'T46460297650476PGNP', 'https://tripay.co.id/checkout/T46460297650476PGNP', '1767700014', '2026-01-06', '1767701033', '', 'PAID', '126875', '1767700047', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1883, 'Tripay', '165638-260101364', 'BRIVA', '', '439', '105050006', '260101364', 'T4646029765121OKAKH', 'https://tripay.co.id/checkout/T4646029765121OKAKH', '1767700134', '2026-01-06', '1767703854', '', 'PAID', '127125', '1767700298', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1884, 'Tripay', '617158-260101123', 'INDOMARET', '', '168', '105020107', '260101123', 'T4646029765339B7JW2', 'https://tripay.co.id/checkout/T4646029765339B7JW2', '1767700458', '2026-01-06', '1767701477', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1885, 'Tripay', '749772-260101352', 'BNIVA', '', '427', '105020222', '260101352', 'T4646029765615H2OUS', 'https://tripay.co.id/checkout/T4646029765615H2OUS', '1767700858', '2026-01-06', '1767701869', '', 'PAID', '127125', '1767701243', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1886, 'Tripay', '303023-260101781', 'BCAVA', '', '876', '105020407', '260101781', 'T46460297656534AEMT', 'https://tripay.co.id/checkout/T46460297656534AEMT', '1767700899', '2026-01-06', '1767701918', '', 'PAID', '127750', '1767700950', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1887, 'Tripay', '876577-260101462', 'INDOMARET', '', '544', '105050013', '260101462', 'T4646029766138B29AR', 'https://tripay.co.id/checkout/T4646029766138B29AR', '1767701623', '2026-01-06', '1767702643', '', 'PAID', '126750', '1767701731', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1888, 'Tripay', '585903-260101009', 'BCAVA', '', '14', '105010007', '260101009', 'T4646029766540OA10V', 'https://tripay.co.id/checkout/T4646029766540OA10V', '1767702260', '2026-01-06', '1767703280', '', 'PAID', '127750', '1767702294', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1889, 'Tripay', '906385-260101846', 'QRIS', '', '943', '105030111', '260101846', 'T4646029766603HEYVS', 'https://tripay.co.id/checkout/T4646029766603HEYVS', '1767702368', '2026-01-06', '1767703087', '', 'UNPAID', '55567', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1890, 'Tripay', '943265-260101862', 'INDOMARET', '', '959', '105030113', '260101862', 'T4646029766647MKCIO', 'https://tripay.co.id/checkout/T4646029766647MKCIO', '1767702437', '2026-01-06', '1767703456', '', 'PAID', '51750', '1767702490', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1891, 'Tripay', '2594-260101038', 'INDOMARET', '', '56', '105020033', '260101038', 'T4646029766816IRBU4', 'https://tripay.co.id/checkout/T4646029766816IRBU4', '1767702792', '2026-01-06', '1767703812', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1892, 'Tripay', '132603-260101655', 'QRIS2', '', '745', '105050037', '260101655', 'T4646029767254OEIXJ', 'https://tripay.co.id/checkout/T4646029767254OEIXJ', '1767703473', '2026-01-06', '1767704192', '', 'PAID', '125000', '1767703564', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1893, 'Tripay', '100050-260101328', 'QRIS2', '', '399', '105020215', '260101328', 'T4646029767419CBXKM', 'https://tripay.co.id/checkout/T4646029767419CBXKM', '1767703703', '2026-01-06', '1767704423', '', 'PAID', '125000', '1767703737', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1894, 'Tripay', '380601-260101142', 'QRIS2', '', '192', '105010071', '260101142', 'T4646029767530EBT7I', 'https://tripay.co.id/checkout/T4646029767530EBT7I', '1767703823', '2026-01-06', '1767704543', '', 'UNPAID', '125000', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1895, 'Tripay', '49021-260101846', 'QRIS', '', '943', '105030111', '260101846', 'T46460297677289QTHB', 'https://tripay.co.id/checkout/T46460297677289QTHB', '1767704155', '2026-01-06', '1767704875', '', 'PAID', '55567', '1767704198', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1896, 'Tripay', '44996-260101643', 'INDOMARET', '', '733', '105050029', '260101643', 'T4646029768017IKDAI', 'https://tripay.co.id/checkout/T4646029768017IKDAI', '1767704613', '2026-01-06', '1767705632', '', 'UNPAID', '126750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1897, 'Tripay', '248423-260101615', 'DANA', '', '704', '105020336', '260101615', 'T464602976817206LNP', 'https://tripay.co.id/checkout/T464602976817206LNP', '1767704862', '2026-01-06', '1767705881', '', 'PAID', '125000', '1767704893', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1898, 'Tripay', '982152-260101199', 'BCAVA', '', '258', '105030005', '260101199', 'T4646029768306QPG6A', 'https://tripay.co.id/checkout/T4646029768306QPG6A', '1767705085', '2026-01-06', '1767706105', '', 'UNPAID', '127750', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_services`, `invoice`, `reference`, `payment_url`, `transaction_time`, `date_created`, `expired`, `instructions`, `status_payment`, `amount`, `paid_at`, `result`) VALUES (1899, 'Tripay', '249749-260101142', 'BRIVA', '', '192', '105010071', '260101142', 'T4646029768633B1EBM', 'https://tripay.co.id/checkout/T4646029768633B1EBM', '1767705674', '2026-01-06', '1767709394', '', 'UNPAID', '127125', '', '');
INSERT INTO `payment_gateway_transaction` (`id`, `vendor`, `external_id`, `method`, `code_number`, `customer_id`, `no_servi