#
# TABLE STRUCTURE FOR: bank
#

DROP TABLE IF EXISTS `bank`;

CREATE TABLE `bank` (
  `bank_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `no_rek` varchar(128) NOT NULL,
  `owner` varchar(128) NOT NULL,
  `create_by` int(11) NOT NULL,
  PRIMARY KEY (`bank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `bank` (`bank_id`, `name`, `no_rek`, `owner`, `create_by`) VALUES (3, 'MANDIRI', '1440000003100', 'PT Terabyte Network Indonesia', 0);
INSERT INTO `bank` (`bank_id`, `name`, `no_rek`, `owner`, `create_by`) VALUES (4, 'BRI', '006501003100560', 'PT Terabyte Network Indonesia', 0);
INSERT INTO `bank` (`bank_id`, `name`, `no_rek`, `owner`, `create_by`) VALUES (5, 'BCA', '0894003100', 'PT Terabyte Network Indonesia', 0);


#
# TABLE STRUCTURE FOR: bot_telegram
#

DROP TABLE IF EXISTS `bot_telegram`;

CREATE TABLE `bot_telegram` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(128) NOT NULL,
  `username_bot` varchar(128) NOT NULL,
  `username_owner` varchar(128) NOT NULL,
  `id_telegram_owner` varchar(128) NOT NULL,
  `id_group_teknisi` varchar(50) NOT NULL,
  `create_by` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `notif_new_customer` int(11) NOT NULL,
  `notif_income_payment_gateway` int(11) NOT NULL,
  `notif_new_ticket` int(11) NOT NULL,
  `notif_update_ticket` int(11) NOT NULL,
  `text_new_customer` text NOT NULL,
  `text_income_payment_gateway` text NOT NULL,
  `text_new_ticket` text NOT NULL,
  `text_update_ticket` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `bot_telegram` (`id`, `token`, `username_bot`, `username_owner`, `id_telegram_owner`, `id_group_teknisi`, `create_by`, `is_active`, `notif_new_customer`, `notif_income_payment_gateway`, `notif_new_ticket`, `notif_update_ticket`, `text_new_customer`, `text_income_payment_gateway`, `text_new_ticket`, `text_update_ticket`) VALUES (1, '', '', '', '', '', 0, 0, 0, 0, 0, 0, '', '', '', '');


#
# TABLE STRUCTURE FOR: briva
#

DROP TABLE IF EXISTS `briva`;

CREATE TABLE `briva` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `is_active` int(11) NOT NULL,
  `mode` int(11) NOT NULL,
  `auto_pay` int(11) NOT NULL,
  `account_number` text NOT NULL,
  `consumer_key` text NOT NULL,
  `consumer_secret` text NOT NULL,
  `institution` tinytext NOT NULL,
  `briva` tinytext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: cat_expenditure
#

DROP TABLE IF EXISTS `cat_expenditure`;

CREATE TABLE `cat_expenditure` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `remark` text NOT NULL,
  `create_by` int(11) NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `cat_expenditure` (`category_id`, `name`, `remark`, `create_by`) VALUES (1, 'Fiberstar', ' Pembayaran Metro', 0);


#
# TABLE STRUCTURE FOR: cat_income
#

DROP TABLE IF EXISTS `cat_income`;

CREATE TABLE `cat_income` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `remark` text NOT NULL,
  `create_by` int(11) NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `cat_income` (`category_id`, `name`, `remark`, `create_by`) VALUES (1, 'Tagihan', 'Otomatis by System', 0);


#
# TABLE STRUCTURE FOR: company
#

DROP TABLE IF EXISTS `company`;

CREATE TABLE `company` (
  `id` int(11) NOT NULL,
  `company_name` varchar(100) NOT NULL,
  `sub_name` varchar(128) NOT NULL,
  `description` text NOT NULL,
  `picture` text NOT NULL,
  `logo` text NOT NULL,
  `whatsapp` varchar(100) NOT NULL,
  `facebook` varchar(100) NOT NULL,
  `twitter` varchar(100) NOT NULL,
  `instagram` varchar(100) NOT NULL,
  `phone` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `owner` varchar(128) NOT NULL,
  `video` text NOT NULL,
  `address` text NOT NULL,
  `due_date` int(11) NOT NULL,
  `ppn` int(11) NOT NULL,
  `admin_fee` int(11) NOT NULL,
  `terms` text NOT NULL,
  `policy` text NOT NULL,
  `expired` varchar(50) NOT NULL,
  `isolir` int(11) NOT NULL,
  `import` int(11) NOT NULL,
  `apps_name` varchar(20) NOT NULL,
  `kode_billing` varchar(20) NOT NULL,
  `cek_bill` int(11) NOT NULL,
  `cek_usage` int(11) NOT NULL,
  `latitude` text NOT NULL,
  `longitude` text NOT NULL,
  `phonecode` int(11) NOT NULL,
  `country` int(11) NOT NULL,
  `currency` varchar(50) NOT NULL,
  `timezone` varchar(50) NOT NULL,
  `tawk` text NOT NULL,
  `speedtest` text NOT NULL,
  `maintenance` int(11) NOT NULL,
  `watermark` int(11) NOT NULL,
  `version` text NOT NULL,
  `last_update` text NOT NULL,
  `bcava` text NOT NULL,
  `licence` text NOT NULL,
  `auto_update` int(11) NOT NULL,
  `google-site-verification` text NOT NULL,
  `google-tag-manager` text NOT NULL,
  `tax_id_number` text NOT NULL,
  `favicon` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `company` (`id`, `company_name`, `sub_name`, `description`, `picture`, `logo`, `whatsapp`, `facebook`, `twitter`, `instagram`, `phone`, `email`, `owner`, `video`, `address`, `due_date`, `ppn`, `admin_fee`, `terms`, `policy`, `expired`, `isolir`, `import`, `apps_name`, `kode_billing`, `cek_bill`, `cek_usage`, `latitude`, `longitude`, `phonecode`, `country`, `currency`, `timezone`, `tawk`, `speedtest`, `maintenance`, `watermark`, `version`, `last_update`, `bcava`, `licence`, `auto_update`, `google-site-verification`, `google-tag-manager`, `tax_id_number`, `favicon`) VALUES (1, 'PT. Terabyte Network Indonesia', 'Internet Service Provider', '<p><strong>Demikian pula</strong>, tidak adakah orang yang mencintai atau mengejar atau ingin mengalami penderitaan, bukan semata-mata karena penderitaan itu sendiri, tetapi karena sesekali terjadi keadaan di mana susah-payah dan penderitaan dapat memberikan kepadanya kesenangan yang besar. Sebagai contoh sederhana, siapakah di antara kita yang pernah melakukan pekerjaan fisik ya<strong>ng berat, selain untuk memperoleh manfaat daripadanya? Tetapi siapakah yang berhak untuk mencari kesalahan pada diri orang</strong> yang memilih untuk menikmati kesenangan yang tidak menimbulkan akibat-akibat yang mengganggu, atau orang yang menghindari penderitaan yang tidak menghasilkan kesenangan?s</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><!--?= $company[\'company_name\'] ?--><!--?=$company[\'company_name\']?\r\n--></p>\r\n', 'picture-191121-62a0af9970.jpg', 'logo-221220241.jpg', '081222200030', '', 'luigifauzi', '', '6282130415558', 'terabytenetworkindonesia@gmail.com', 'PT Terabyte Network Indonesia', 'https://www.youtube.com/watch?v=SiPuvEFaC3g', 'JL Raya Mendalan Desa Mendalan Kecamatan Winongan Kabupaten Pasuruan', 0, 0, 0, '<p>df</p>\r\n', '0', '', 0, 0, 'BYTEHOME', '105', 1, 1, '-7.205830295257313', '107.8256392478943', 62, 0, '', 'Asia/Bangkok', '', '', 0, 0, '', '', '', '315901e17379afc9|xgD6Va0mEWj3rE/bh+CxwfwHzIVtXPa4V+TDf0+qEhyz3ueX/cLBa35wFRlnnU5TSfiYE5ToJ+Jv2eYYElAvZBAeMHY8t4N7/9AvYxS+CZoL7TwAgNwnd+c4AR0MZ5qt', 0, '', '', '', '');


#
# TABLE STRUCTURE FOR: confirm_payment
#

DROP TABLE IF EXISTS `confirm_payment`;

CREATE TABLE `confirm_payment` (
  `confirm_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `no_services` varchar(25) NOT NULL,
  `metode_payment` varchar(50) NOT NULL,
  `date_payment` varchar(50) NOT NULL,
  `status` varchar(20) NOT NULL,
  `remark` text NOT NULL,
  `date_created` int(11) NOT NULL,
  `picture` text NOT NULL,
  PRIMARY KEY (`confirm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: country
#

DROP TABLE IF EXISTS `country`;

CREATE TABLE `country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `iso` char(2) NOT NULL,
  `name` varchar(80) NOT NULL,
  `nicename` varchar(80) NOT NULL,
  `iso3` char(3) DEFAULT NULL,
  `numcode` smallint(6) DEFAULT NULL,
  `phonecode` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=254 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (1, 'AF', 'AFGHANISTAN', 'Afghanistan', 'AFG', 4, 93);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (2, 'AL', 'ALBANIA', 'Albania', 'ALB', 8, 355);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (3, 'DZ', 'ALGERIA', 'Algeria', 'DZA', 12, 213);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (4, 'AS', 'AMERICAN SAMOA', 'American Samoa', 'ASM', 16, 1684);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (5, 'AD', 'ANDORRA', 'Andorra', 'AND', 20, 376);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (6, 'AO', 'ANGOLA', 'Angola', 'AGO', 24, 244);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (7, 'AI', 'ANGUILLA', 'Anguilla', 'AIA', 660, 1264);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (8, 'AQ', 'ANTARCTICA', 'Antarctica', 'ATA', 10, 0);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (9, 'AG', 'ANTIGUA AND BARBUDA', 'Antigua and Barbuda', 'ATG', 28, 1268);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (10, 'AR', 'ARGENTINA', 'Argentina', 'ARG', 32, 54);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (11, 'AM', 'ARMENIA', 'Armenia', 'ARM', 51, 374);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (12, 'AW', 'ARUBA', 'Aruba', 'ABW', 533, 297);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (13, 'AU', 'AUSTRALIA', 'Australia', 'AUS', 36, 61);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (14, 'AT', 'AUSTRIA', 'Austria', 'AUT', 40, 43);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (15, 'AZ', 'AZERBAIJAN', 'Azerbaijan', 'AZE', 31, 994);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (16, 'BS', 'BAHAMAS', 'Bahamas', 'BHS', 44, 1242);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (17, 'BH', 'BAHRAIN', 'Bahrain', 'BHR', 48, 973);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (18, 'BD', 'BANGLADESH', 'Bangladesh', 'BGD', 50, 880);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (19, 'BB', 'BARBADOS', 'Barbados', 'BRB', 52, 1246);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (20, 'BY', 'BELARUS', 'Belarus', 'BLR', 112, 375);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (21, 'BE', 'BELGIUM', 'Belgium', 'BEL', 56, 32);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (22, 'BZ', 'BELIZE', 'Belize', 'BLZ', 84, 501);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (23, 'BJ', 'BENIN', 'Benin', 'BEN', 204, 229);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (24, 'BM', 'BERMUDA', 'Bermuda', 'BMU', 60, 1441);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (25, 'BT', 'BHUTAN', 'Bhutan', 'BTN', 64, 975);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (26, 'BO', 'BOLIVIA', 'Bolivia', 'BOL', 68, 591);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (27, 'BA', 'BOSNIA AND HERZEGOVINA', 'Bosnia and Herzegovina', 'BIH', 70, 387);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (28, 'BW', 'BOTSWANA', 'Botswana', 'BWA', 72, 267);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (29, 'BV', 'BOUVET ISLAND', 'Bouvet Island', 'BVT', 74, 0);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (30, 'BR', 'BRAZIL', 'Brazil', 'BRA', 76, 55);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (31, 'IO', 'BRITISH INDIAN OCEAN TERRITORY', 'British Indian Ocean Territory', 'IOT', 86, 246);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (32, 'BN', 'BRUNEI DARUSSALAM', 'Brunei Darussalam', 'BRN', 96, 673);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (33, 'BG', 'BULGARIA', 'Bulgaria', 'BGR', 100, 359);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (34, 'BF', 'BURKINA FASO', 'Burkina Faso', 'BFA', 854, 226);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (35, 'BI', 'BURUNDI', 'Burundi', 'BDI', 108, 257);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (36, 'KH', 'CAMBODIA', 'Cambodia', 'KHM', 116, 855);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (37, 'CM', 'CAMEROON', 'Cameroon', 'CMR', 120, 237);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (38, 'CA', 'CANADA', 'Canada', 'CAN', 124, 1);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (39, 'CV', 'CAPE VERDE', 'Cape Verde', 'CPV', 132, 238);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (40, 'KY', 'CAYMAN ISLANDS', 'Cayman Islands', 'CYM', 136, 1345);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (41, 'CF', 'CENTRAL AFRICAN REPUBLIC', 'Central African Republic', 'CAF', 140, 236);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (42, 'TD', 'CHAD', 'Chad', 'TCD', 148, 235);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (43, 'CL', 'CHILE', 'Chile', 'CHL', 152, 56);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (44, 'CN', 'CHINA', 'China', 'CHN', 156, 86);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (45, 'CX', 'CHRISTMAS ISLAND', 'Christmas Island', 'CXR', 162, 61);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (46, 'CC', 'COCOS (KEELING) ISLANDS', 'Cocos (Keeling) Islands', NULL, NULL, 672);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (47, 'CO', 'COLOMBIA', 'Colombia', 'COL', 170, 57);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (48, 'KM', 'COMOROS', 'Comoros', 'COM', 174, 269);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (49, 'CG', 'CONGO', 'Congo', 'COG', 178, 242);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (50, 'CD', 'CONGO, THE DEMOCRATIC REPUBLIC OF THE', 'Congo, the Democratic Republic of the', 'COD', 180, 242);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (51, 'CK', 'COOK ISLANDS', 'Cook Islands', 'COK', 184, 682);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (52, 'CR', 'COSTA RICA', 'Costa Rica', 'CRI', 188, 506);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (53, 'CI', 'COTE D\'IVOIRE', 'Cote D\'Ivoire', 'CIV', 384, 225);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (54, 'HR', 'CROATIA', 'Croatia', 'HRV', 191, 385);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (55, 'CU', 'CUBA', 'Cuba', 'CUB', 192, 53);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (56, 'CY', 'CYPRUS', 'Cyprus', 'CYP', 196, 357);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (57, 'CZ', 'CZECH REPUBLIC', 'Czech Republic', 'CZE', 203, 420);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (58, 'DK', 'DENMARK', 'Denmark', 'DNK', 208, 45);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (59, 'DJ', 'DJIBOUTI', 'Djibouti', 'DJI', 262, 253);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (60, 'DM', 'DOMINICA', 'Dominica', 'DMA', 212, 1767);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (61, 'DO', 'DOMINICAN REPUBLIC', 'Dominican Republic', 'DOM', 214, 1809);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (62, 'EC', 'ECUADOR', 'Ecuador', 'ECU', 218, 593);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (63, 'EG', 'EGYPT', 'Egypt', 'EGY', 818, 20);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (64, 'SV', 'EL SALVADOR', 'El Salvador', 'SLV', 222, 503);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (65, 'GQ', 'EQUATORIAL GUINEA', 'Equatorial Guinea', 'GNQ', 226, 240);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (66, 'ER', 'ERITREA', 'Eritrea', 'ERI', 232, 291);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (67, 'EE', 'ESTONIA', 'Estonia', 'EST', 233, 372);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (68, 'ET', 'ETHIOPIA', 'Ethiopia', 'ETH', 231, 251);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (69, 'FK', 'FALKLAND ISLANDS (MALVINAS)', 'Falkland Islands (Malvinas)', 'FLK', 238, 500);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (70, 'FO', 'FAROE ISLANDS', 'Faroe Islands', 'FRO', 234, 298);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (71, 'FJ', 'FIJI', 'Fiji', 'FJI', 242, 679);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (72, 'FI', 'FINLAND', 'Finland', 'FIN', 246, 358);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (73, 'FR', 'FRANCE', 'France', 'FRA', 250, 33);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (74, 'GF', 'FRENCH GUIANA', 'French Guiana', 'GUF', 254, 594);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (75, 'PF', 'FRENCH POLYNESIA', 'French Polynesia', 'PYF', 258, 689);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (76, 'TF', 'FRENCH SOUTHERN TERRITORIES', 'French Southern Territories', 'ATF', 260, 0);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (77, 'GA', 'GABON', 'Gabon', 'GAB', 266, 241);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (78, 'GM', 'GAMBIA', 'Gambia', 'GMB', 270, 220);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (79, 'GE', 'GEORGIA', 'Georgia', 'GEO', 268, 995);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (80, 'DE', 'GERMANY', 'Germany', 'DEU', 276, 49);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (81, 'GH', 'GHANA', 'Ghana', 'GHA', 288, 233);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (82, 'GI', 'GIBRALTAR', 'Gibraltar', 'GIB', 292, 350);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (83, 'GR', 'GREECE', 'Greece', 'GRC', 300, 30);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (84, 'GL', 'GREENLAND', 'Greenland', 'GRL', 304, 299);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (85, 'GD', 'GRENADA', 'Grenada', 'GRD', 308, 1473);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (86, 'GP', 'GUADELOUPE', 'Guadeloupe', 'GLP', 312, 590);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (87, 'GU', 'GUAM', 'Guam', 'GUM', 316, 1671);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (88, 'GT', 'GUATEMALA', 'Guatemala', 'GTM', 320, 502);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (89, 'GN', 'GUINEA', 'Guinea', 'GIN', 324, 224);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (90, 'GW', 'GUINEA-BISSAU', 'Guinea-Bissau', 'GNB', 624, 245);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (91, 'GY', 'GUYANA', 'Guyana', 'GUY', 328, 592);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (92, 'HT', 'HAITI', 'Haiti', 'HTI', 332, 509);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (93, 'HM', 'HEARD ISLAND AND MCDONALD ISLANDS', 'Heard Island and Mcdonald Islands', 'HMD', 334, 0);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (94, 'VA', 'HOLY SEE (VATICAN CITY STATE)', 'Holy See (Vatican City State)', 'VAT', 336, 39);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (95, 'HN', 'HONDURAS', 'Honduras', 'HND', 340, 504);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (96, 'HK', 'HONG KONG', 'Hong Kong', 'HKG', 344, 852);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (97, 'HU', 'HUNGARY', 'Hungary', 'HUN', 348, 36);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (98, 'IS', 'ICELAND', 'Iceland', 'ISL', 352, 354);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (99, 'IN', 'INDIA', 'India', 'IND', 356, 91);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (100, 'ID', 'INDONESIA', 'Indonesia', 'IDN', 360, 62);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (101, 'IR', 'IRAN, ISLAMIC REPUBLIC OF', 'Iran, Islamic Republic of', 'IRN', 364, 98);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (102, 'IQ', 'IRAQ', 'Iraq', 'IRQ', 368, 964);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (103, 'IE', 'IRELAND', 'Ireland', 'IRL', 372, 353);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (104, 'IL', 'ISRAEL', 'Israel', 'ISR', 376, 972);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (105, 'IT', 'ITALY', 'Italy', 'ITA', 380, 39);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (106, 'JM', 'JAMAICA', 'Jamaica', 'JAM', 388, 1876);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (107, 'JP', 'JAPAN', 'Japan', 'JPN', 392, 81);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (108, 'JO', 'JORDAN', 'Jordan', 'JOR', 400, 962);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (109, 'KZ', 'KAZAKHSTAN', 'Kazakhstan', 'KAZ', 398, 7);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (110, 'KE', 'KENYA', 'Kenya', 'KEN', 404, 254);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (111, 'KI', 'KIRIBATI', 'Kiribati', 'KIR', 296, 686);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (112, 'KP', 'KOREA, DEMOCRATIC PEOPLE\'S REPUBLIC OF', 'Korea, Democratic People\'s Republic of', 'PRK', 408, 850);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (113, 'KR', 'KOREA, REPUBLIC OF', 'Korea, Republic of', 'KOR', 410, 82);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (114, 'KW', 'KUWAIT', 'Kuwait', 'KWT', 414, 965);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (115, 'KG', 'KYRGYZSTAN', 'Kyrgyzstan', 'KGZ', 417, 996);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (116, 'LA', 'LAO PEOPLE\'S DEMOCRATIC REPUBLIC', 'Lao People\'s Democratic Republic', 'LAO', 418, 856);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (117, 'LV', 'LATVIA', 'Latvia', 'LVA', 428, 371);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (118, 'LB', 'LEBANON', 'Lebanon', 'LBN', 422, 961);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (119, 'LS', 'LESOTHO', 'Lesotho', 'LSO', 426, 266);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (120, 'LR', 'LIBERIA', 'Liberia', 'LBR', 430, 231);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (121, 'LY', 'LIBYAN ARAB JAMAHIRIYA', 'Libyan Arab Jamahiriya', 'LBY', 434, 218);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (122, 'LI', 'LIECHTENSTEIN', 'Liechtenstein', 'LIE', 438, 423);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (123, 'LT', 'LITHUANIA', 'Lithuania', 'LTU', 440, 370);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (124, 'LU', 'LUXEMBOURG', 'Luxembourg', 'LUX', 442, 352);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (125, 'MO', 'MACAO', 'Macao', 'MAC', 446, 853);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (126, 'MK', 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF', 'Macedonia, the Former Yugoslav Republic of', 'MKD', 807, 389);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (127, 'MG', 'MADAGASCAR', 'Madagascar', 'MDG', 450, 261);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (128, 'MW', 'MALAWI', 'Malawi', 'MWI', 454, 265);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (129, 'MY', 'MALAYSIA', 'Malaysia', 'MYS', 458, 60);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (130, 'MV', 'MALDIVES', 'Maldives', 'MDV', 462, 960);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (131, 'ML', 'MALI', 'Mali', 'MLI', 466, 223);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (132, 'MT', 'MALTA', 'Malta', 'MLT', 470, 356);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (133, 'MH', 'MARSHALL ISLANDS', 'Marshall Islands', 'MHL', 584, 692);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (134, 'MQ', 'MARTINIQUE', 'Martinique', 'MTQ', 474, 596);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (135, 'MR', 'MAURITANIA', 'Mauritania', 'MRT', 478, 222);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (136, 'MU', 'MAURITIUS', 'Mauritius', 'MUS', 480, 230);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (137, 'YT', 'MAYOTTE', 'Mayotte', 'MYT', 175, 269);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (138, 'MX', 'MEXICO', 'Mexico', 'MEX', 484, 52);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (139, 'FM', 'MICRONESIA, FEDERATED STATES OF', 'Micronesia, Federated States of', 'FSM', 583, 691);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (140, 'MD', 'MOLDOVA, REPUBLIC OF', 'Moldova, Republic of', 'MDA', 498, 373);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (141, 'MC', 'MONACO', 'Monaco', 'MCO', 492, 377);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (142, 'MN', 'MONGOLIA', 'Mongolia', 'MNG', 496, 976);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (143, 'MS', 'MONTSERRAT', 'Montserrat', 'MSR', 500, 1664);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (144, 'MA', 'MOROCCO', 'Morocco', 'MAR', 504, 212);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (145, 'MZ', 'MOZAMBIQUE', 'Mozambique', 'MOZ', 508, 258);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (146, 'MM', 'MYANMAR', 'Myanmar', 'MMR', 104, 95);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (147, 'NA', 'NAMIBIA', 'Namibia', 'NAM', 516, 264);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (148, 'NR', 'NAURU', 'Nauru', 'NRU', 520, 674);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (149, 'NP', 'NEPAL', 'Nepal', 'NPL', 524, 977);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (150, 'NL', 'NETHERLANDS', 'Netherlands', 'NLD', 528, 31);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (151, 'AN', 'NETHERLANDS ANTILLES', 'Netherlands Antilles', 'ANT', 530, 599);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (152, 'NC', 'NEW CALEDONIA', 'New Caledonia', 'NCL', 540, 687);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (153, 'NZ', 'NEW ZEALAND', 'New Zealand', 'NZL', 554, 64);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (154, 'NI', 'NICARAGUA', 'Nicaragua', 'NIC', 558, 505);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (155, 'NE', 'NIGER', 'Niger', 'NER', 562, 227);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (156, 'NG', 'NIGERIA', 'Nigeria', 'NGA', 566, 234);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (157, 'NU', 'NIUE', 'Niue', 'NIU', 570, 683);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (158, 'NF', 'NORFOLK ISLAND', 'Norfolk Island', 'NFK', 574, 672);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (159, 'MP', 'NORTHERN MARIANA ISLANDS', 'Northern Mariana Islands', 'MNP', 580, 1670);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (160, 'NO', 'NORWAY', 'Norway', 'NOR', 578, 47);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (161, 'OM', 'OMAN', 'Oman', 'OMN', 512, 968);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (162, 'PK', 'PAKISTAN', 'Pakistan', 'PAK', 586, 92);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (163, 'PW', 'PALAU', 'Palau', 'PLW', 585, 680);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (164, 'PS', 'PALESTINIAN TERRITORY, OCCUPIED', 'Palestinian Territory, Occupied', NULL, NULL, 970);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (165, 'PA', 'PANAMA', 'Panama', 'PAN', 591, 507);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (166, 'PG', 'PAPUA NEW GUINEA', 'Papua New Guinea', 'PNG', 598, 675);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (167, 'PY', 'PARAGUAY', 'Paraguay', 'PRY', 600, 595);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (168, 'PE', 'PERU', 'Peru', 'PER', 604, 51);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (169, 'PH', 'PHILIPPINES', 'Philippines', 'PHL', 608, 63);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (170, 'PN', 'PITCAIRN', 'Pitcairn', 'PCN', 612, 0);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (171, 'PL', 'POLAND', 'Poland', 'POL', 616, 48);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (172, 'PT', 'PORTUGAL', 'Portugal', 'PRT', 620, 351);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (173, 'PR', 'PUERTO RICO', 'Puerto Rico', 'PRI', 630, 1787);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (174, 'QA', 'QATAR', 'Qatar', 'QAT', 634, 974);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (175, 'RE', 'REUNION', 'Reunion', 'REU', 638, 262);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (176, 'RO', 'ROMANIA', 'Romania', 'ROM', 642, 40);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (177, 'RU', 'RUSSIAN FEDERATION', 'Russian Federation', 'RUS', 643, 70);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (178, 'RW', 'RWANDA', 'Rwanda', 'RWA', 646, 250);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (179, 'SH', 'SAINT HELENA', 'Saint Helena', 'SHN', 654, 290);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (180, 'KN', 'SAINT KITTS AND NEVIS', 'Saint Kitts and Nevis', 'KNA', 659, 1869);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (181, 'LC', 'SAINT LUCIA', 'Saint Lucia', 'LCA', 662, 1758);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (182, 'PM', 'SAINT PIERRE AND MIQUELON', 'Saint Pierre and Miquelon', 'SPM', 666, 508);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (183, 'VC', 'SAINT VINCENT AND THE GRENADINES', 'Saint Vincent and the Grenadines', 'VCT', 670, 1784);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (184, 'WS', 'SAMOA', 'Samoa', 'WSM', 882, 684);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (185, 'SM', 'SAN MARINO', 'San Marino', 'SMR', 674, 378);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (186, 'ST', 'SAO TOME AND PRINCIPE', 'Sao Tome and Principe', 'STP', 678, 239);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (187, 'SA', 'SAUDI ARABIA', 'Saudi Arabia', 'SAU', 682, 966);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (188, 'SN', 'SENEGAL', 'Senegal', 'SEN', 686, 221);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (189, 'CS', 'SERBIA AND MONTENEGRO', 'Serbia and Montenegro', 'MNE', 499, 381);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (190, 'SC', 'SEYCHELLES', 'Seychelles', 'SYC', 690, 248);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (191, 'SL', 'SIERRA LEONE', 'Sierra Leone', 'SLE', 694, 232);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (192, 'SG', 'SINGAPORE', 'Singapore', 'SGP', 702, 65);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (193, 'SK', 'SLOVAKIA', 'Slovakia', 'SVK', 703, 421);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (194, 'SI', 'SLOVENIA', 'Slovenia', 'SVN', 705, 386);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (195, 'SB', 'SOLOMON ISLANDS', 'Solomon Islands', 'SLB', 90, 677);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (196, 'SO', 'SOMALIA', 'Somalia', 'SOM', 706, 252);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (197, 'ZA', 'SOUTH AFRICA', 'South Africa', 'ZAF', 710, 27);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (198, 'GS', 'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS', 'South Georgia and the South Sandwich Islands', 'SGS', 239, 0);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (199, 'ES', 'SPAIN', 'Spain', 'ESP', 724, 34);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (200, 'LK', 'SRI LANKA', 'Sri Lanka', 'LKA', 144, 94);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (201, 'SD', 'SUDAN', 'Sudan', 'SDN', 736, 249);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (202, 'SR', 'SURINAME', 'Suriname', 'SUR', 740, 597);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (203, 'SJ', 'SVALBARD AND JAN MAYEN', 'Svalbard and Jan Mayen', 'SJM', 744, 47);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (204, 'SZ', 'SWAZILAND', 'Swaziland', 'SWZ', 748, 268);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (205, 'SE', 'SWEDEN', 'Sweden', 'SWE', 752, 46);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (206, 'CH', 'SWITZERLAND', 'Switzerland', 'CHE', 756, 41);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (207, 'SY', 'SYRIAN ARAB REPUBLIC', 'Syrian Arab Republic', 'SYR', 760, 963);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (208, 'TW', 'TAIWAN, PROVINCE OF CHINA', 'Taiwan, Province of China', 'TWN', 158, 886);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (209, 'TJ', 'TAJIKISTAN', 'Tajikistan', 'TJK', 762, 992);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (210, 'TZ', 'TANZANIA, UNITED REPUBLIC OF', 'Tanzania, United Republic of', 'TZA', 834, 255);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (211, 'TH', 'THAILAND', 'Thailand', 'THA', 764, 66);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (212, 'TL', 'TIMOR-LESTE', 'Timor-Leste', 'TLS', 626, 670);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (213, 'TG', 'TOGO', 'Togo', 'TGO', 768, 228);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (214, 'TK', 'TOKELAU', 'Tokelau', 'TKL', 772, 690);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (215, 'TO', 'TONGA', 'Tonga', 'TON', 776, 676);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (216, 'TT', 'TRINIDAD AND TOBAGO', 'Trinidad and Tobago', 'TTO', 780, 1868);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (217, 'TN', 'TUNISIA', 'Tunisia', 'TUN', 788, 216);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (218, 'TR', 'TURKEY', 'Turkey', 'TUR', 792, 90);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (219, 'TM', 'TURKMENISTAN', 'Turkmenistan', 'TKM', 795, 7370);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (220, 'TC', 'TURKS AND CAICOS ISLANDS', 'Turks and Caicos Islands', 'TCA', 796, 1649);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (221, 'TV', 'TUVALU', 'Tuvalu', 'TUV', 798, 688);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (222, 'UG', 'UGANDA', 'Uganda', 'UGA', 800, 256);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (223, 'UA', 'UKRAINE', 'Ukraine', 'UKR', 804, 380);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (224, 'AE', 'UNITED ARAB EMIRATES', 'United Arab Emirates', 'ARE', 784, 971);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (225, 'GB', 'UNITED KINGDOM', 'United Kingdom', 'GBR', 826, 44);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (226, 'US', 'UNITED STATES', 'United States', 'USA', 840, 1);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (227, 'UM', 'UNITED STATES MINOR OUTLYING ISLANDS', 'United States Minor Outlying Islands', 'UMI', 581, 1);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (228, 'UY', 'URUGUAY', 'Uruguay', 'URY', 858, 598);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (229, 'UZ', 'UZBEKISTAN', 'Uzbekistan', 'UZB', 860, 998);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (230, 'VU', 'VANUATU', 'Vanuatu', 'VUT', 548, 678);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (231, 'VE', 'VENEZUELA', 'Venezuela', 'VEN', 862, 58);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (232, 'VN', 'VIET NAM', 'Viet Nam', 'VNM', 704, 84);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (233, 'VG', 'VIRGIN ISLANDS, BRITISH', 'Virgin Islands, British', 'VGB', 92, 1284);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (234, 'VI', 'VIRGIN ISLANDS, U.S.', 'Virgin Islands, U.s.', 'VIR', 850, 1340);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (235, 'WF', 'WALLIS AND FUTUNA', 'Wallis and Futuna', 'WLF', 876, 681);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (236, 'EH', 'WESTERN SAHARA', 'Western Sahara', 'ESH', 732, 212);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (237, 'YE', 'YEMEN', 'Yemen', 'YEM', 887, 967);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (238, 'ZM', 'ZAMBIA', 'Zambia', 'ZMB', 894, 260);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (239, 'ZW', 'ZIMBABWE', 'Zimbabwe', 'ZWE', 716, 263);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (240, 'RS', 'SERBIA', 'Serbia', 'SRB', 688, 381);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (241, 'AP', 'ASIA PACIFIC REGION', 'Asia / Pacific Region', '0', 0, 0);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (242, 'ME', 'MONTENEGRO', 'Montenegro', 'MNE', 499, 382);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (243, 'AX', 'ALAND ISLANDS', 'Aland Islands', 'ALA', 248, 358);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (244, 'BQ', 'BONAIRE, SINT EUSTATIUS AND SABA', 'Bonaire, Sint Eustatius and Saba', 'BES', 535, 599);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (245, 'CW', 'CURACAO', 'Curacao', 'CUW', 531, 599);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (246, 'GG', 'GUERNSEY', 'Guernsey', 'GGY', 831, 44);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (247, 'IM', 'ISLE OF MAN', 'Isle of Man', 'IMN', 833, 44);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (248, 'JE', 'JERSEY', 'Jersey', 'JEY', 832, 44);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (249, 'XK', 'KOSOVO', 'Kosovo', '---', 0, 381);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (250, 'BL', 'SAINT BARTHELEMY', 'Saint Barthelemy', 'BLM', 652, 590);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (251, 'MF', 'SAINT MARTIN', 'Saint Martin', 'MAF', 663, 590);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (252, 'SX', 'SINT MAARTEN', 'Sint Maarten', 'SXM', 534, 1);
INSERT INTO `country` (`id`, `iso`, `name`, `nicename`, `iso3`, `numcode`, `phonecode`) VALUES (253, 'SS', 'SOUTH SUDAN', 'South Sudan', 'SSD', 728, 211);


#
# TABLE STRUCTURE FOR: coupon
#

DROP TABLE IF EXISTS `coupon`;

CREATE TABLE `coupon` (
  `coupon_id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `is_active` int(11) NOT NULL,
  `percent` int(11) NOT NULL,
  `one_time` int(11) NOT NULL,
  `max_active` int(11) NOT NULL,
  `max_limit` int(11) NOT NULL,
  `created` int(11) NOT NULL,
  `expired` varchar(50) NOT NULL,
  `remark` text NOT NULL,
  `create_by` int(11) NOT NULL,
  PRIMARY KEY (`coupon_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: cover_operator
#

DROP TABLE IF EXISTS `cover_operator`;

CREATE TABLE `cover_operator` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `coverage_id` int(11) NOT NULL,
  `operator` int(11) NOT NULL,
  `create_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: cover_package
#

DROP TABLE IF EXISTS `cover_package`;

CREATE TABLE `cover_package` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coverage_id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL,
  `created` int(11) NOT NULL,
  `create_by` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

#
# TABLE STRUCTURE FOR: coverage
#

DROP TABLE IF EXISTS `coverage`;

CREATE TABLE `coverage` (
  `coverage_id` int(11) NOT NULL AUTO_INCREMENT,
  `c_name` varchar(128) NOT NULL,
  `address` text NOT NULL,
  `id_prov` varchar(50) NOT NULL,
  `id_kab` varchar(50) NOT NULL,
  `id_kec` varchar(50) NOT NULL,
  `id_kel` varchar(50) NOT NULL,
  `comment` text NOT NULL,
  `latitude` text NOT NULL,
  `longitude` text NOT NULL,
  `radius` int(11) NOT NULL,
  `public` int(11) NOT NULL,
  `code_area` varchar(9) NOT NULL,
  `create_by` int(11) NOT NULL,
  `coverage_mitra` int(11) NOT NULL,
  PRIMARY KEY (`coverage_id`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `coverage` (`coverage_id`, `c_name`, `address`, `id_prov`, `id_kab`, `id_kec`, `id_kel`, `comment`, `latitude`, `longitude`, `radius`, `public`, `code_area`, `create_by`, `coverage_mitra`) VALUES (1, 'Pusat Server', 'jl mendalan rt1 rw8 desa mendalan kecamatan winongan kabupaten pasuruan', '', '', '', '', '', '-7.722808758627467', '112.9378739338887', 100, 1, '1001', 0, 0);
INSERT INTO `coverage` (`coverage_id`, `c_name`, `address`, `id_prov`, `id_kab`, `id_kec`, `id_kel`, `comment`, `latitude`, `longitude`, `radius`, `public`, `code_area`, `create_by`, `coverage_mitra`) VALUES (5, 'Kademangan', 'Kademangan', '', '', '', '', '', '', '', 0, 1, '01', 3797, 0);
INSERT INTO `coverage` (`coverage_id`, `c_name`, `address`, `id_prov`, `id_kab`, `id_kec`, `id_kel`, `comment`, `latitude`, `longitude`, `radius`, `public`, `code_area`, `create_by`, `coverage_mitra`) VALUES (6, 'Kanigaran', 'Kanigaran', '', '', '', '', '', '', '', 0, 1, '02', 3797, 0);
INSERT INTO `coverage` (`coverage_id`, `c_name`, `address`, `id_prov`, `id_kab`, `id_kec`, `id_kel`, `comment`, `latitude`, `longitude`, `radius`, `public`, `code_area`, `create_by`, `coverage_mitra`) VALUES (7, 'Bantaran', 'Bantaran', '', '', '', '', '', '', '', 0, 1, '03', 5565, 0);
INSERT INTO `coverage` (`coverage_id`, `c_name`, `address`, `id_prov`, `id_kab`, `id_kec`, `id_kel`, `comment`, `latitude`, `longitude`, `radius`, `public`, `code_area`, `create_by`, `coverage_mitra`) VALUES (121, 'Dringu', 'Dringu', '', '', '', '', '', '', '', 0, 1, '04', 5565, 0);
INSERT INTO `coverage` (`coverage_id`, `c_name`, `address`, `id_prov`, `id_kab`, `id_kec`, `id_kel`, `comment`, `latitude`, `longitude`, `radius`, `public`, `code_area`, `create_by`, `coverage_mitra`) VALUES (122, 'TONGAS', 'TONGAS', '', '', '', '', '', '', '', 0, 1, '05', 5565, 0);


#
# TABLE STRUCTURE FOR: coverage_doc
#

DROP TABLE IF EXISTS `coverage_doc`;

CREATE TABLE `coverage_doc` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `coverage_id` int(11) NOT NULL,
  `remark` text NOT NULL,
  `document` text NOT NULL,
  `created` int(11) NOT NULL,
  `createby` int(11) NOT NULL,
  `updated` int(11) NOT NULL,
  `updateby` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: currencies
#

DROP TABLE IF EXISTS `currencies`;

CREATE TABLE `currencies` (
  `code` varchar(15) NOT NULL,
  `name` varchar(100) NOT NULL,
  `number` char(5) NOT NULL,
  `subunits_in_unit` int(11) NOT NULL,
  `countries` longtext NOT NULL COMMENT '(DC2Type:json_array)',
  PRIMARY KEY (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AED', 'UAE Dirham', '784', 100, '[\"UNITED ARAB EMIRATES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AFN', 'Afghani', '971', 100, '[\"AFGHANISTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ALL', 'Lek', '008', 100, '[\"ALBANIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AMD', 'Armenian Dram', '051', 100, '[\"ARMENIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ANG', 'Netherlands Antillean Guilder', '532', 100, '[\"CURA\\u00c7AO\",\"SINT MAARTEN (DUTCH PART)\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AOA', 'Kwanza', '973', 100, '[\"ANGOLA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ARS', 'Argentine Peso', '032', 100, '[\"ARGENTINA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AUD', 'Australian Dollar', '036', 100, '[\"AUSTRALIA\",\"CHRISTMAS ISLAND\",\"COCOS (KEELING) ISLANDS\",\"HEARD ISLAND AND McDONALD ISLANDS\",\"KIRIBATI\",\"NAURU\",\"NORFOLK ISLAND\",\"TUVALU\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AWG', 'Aruban Florin', '533', 100, '[\"ARUBA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('AZN', 'Azerbaijanian Manat', '944', 100, '[\"AZERBAIJAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BAM', 'Convertible Mark', '977', 100, '[\"BOSNIA AND HERZEGOVINA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BBD', 'Barbados Dollar', '052', 100, '[\"BARBADOS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BDT', 'Taka', '050', 100, '[\"BANGLADESH\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BGN', 'Bulgarian Lev', '975', 100, '[\"BULGARIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BHD', 'Bahraini Dinar', '048', 1000, '[\"BAHRAIN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BIF', 'Burundi Franc', '108', 1, '[\"BURUNDI\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BMD', 'Bermudian Dollar', '060', 100, '[\"BERMUDA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BND', 'Brunei Dollar', '096', 100, '[\"BRUNEI DARUSSALAM\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BOB', 'Boliviano', '068', 100, '[\"BOLIVIA, PLURINATIONAL STATE OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BOV', 'Mvdol', '984', 100, '[\"BOLIVIA, PLURINATIONAL STATE OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BRL', 'Brazilian Real', '986', 100, '[\"BRAZIL\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BSD', 'Bahamian Dollar', '044', 100, '[\"BAHAMAS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BTN', 'Ngultrum', '064', 100, '[\"BHUTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BWP', 'Pula', '072', 100, '[\"BOTSWANA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BYR', 'Belarussian Ruble', '974', 1, '[\"BELARUS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('BZD', 'Belize Dollar', '084', 100, '[\"BELIZE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CAD', 'Canadian Dollar', '124', 100, '[\"CANADA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CDF', 'Congolese Franc', '976', 100, '[\"CONGO, DEMOCRATIC REPUBLIC OF THE \"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CHE', 'WIR Euro', '947', 100, '[\"SWITZERLAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CHF', 'Swiss Franc', '756', 100, '[\"LIECHTENSTEIN\",\"SWITZERLAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CHW', 'WIR Franc', '948', 100, '[\"SWITZERLAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CLF', 'Unidad de Fomento', '990', 10000, '[\"CHILE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CLP', 'Chilean Peso', '152', 1, '[\"CHILE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CNY', 'Yuan Renminbi', '156', 100, '[\"CHINA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('COP', 'Colombian Peso', '170', 100, '[\"COLOMBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('COU', 'Unidad de Valor Real', '970', 100, '[\"COLOMBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CRC', 'Costa Rican Colon', '188', 100, '[\"COSTA RICA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CUC', 'Peso Convertible', '931', 100, '[\"CUBA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CUP', 'Cuban Peso', '192', 100, '[\"CUBA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CVE', 'Cape Verde Escudo', '132', 100, '[\"CAPE VERDE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('CZK', 'Czech Koruna', '203', 100, '[\"CZECH REPUBLIC\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('DJF', 'Djibouti Franc', '262', 1, '[\"DJIBOUTI\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('DKK', 'Danish Krone', '208', 100, '[\"DENMARK\",\"FAROE ISLANDS\",\"GREENLAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('DOP', 'Dominican Peso', '214', 100, '[\"DOMINICAN REPUBLIC\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('DZD', 'Algerian Dinar', '012', 100, '[\"ALGERIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('EGP', 'Egyptian Pound', '818', 100, '[\"EGYPT\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ERN', 'Nakfa', '232', 100, '[\"ERITREA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ETB', 'Ethiopian Birr', '230', 100, '[\"ETHIOPIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('EUR', 'Euro', '978', 100, '[\"\\u00c5LAND ISLANDS\",\"ANDORRA\",\"AUSTRIA\",\"BELGIUM\",\"CYPRUS\",\"ESTONIA\",\"EUROPEAN UNION\",\"FINLAND\",\"FRANCE\",\"FRENCH GUIANA\",\"FRENCH SOUTHERN TERRITORIES\",\"GERMANY\",\"GREECE\",\"GUADELOUPE\",\"HOLY SEE (VATICAN CITY STATE)\",\"IRELAND\",\"ITALY\",\"LATVIA\",\"LUXEMBOURG\",\"MALTA\",\"MARTINIQUE\",\"MAYOTTE\",\"MONACO\",\"MONTENEGRO\",\"NETHERLANDS\",\"PORTUGAL\",\"R\\u00c9UNION\",\"SAINT BARTH\\u00c9LEMY\",\"SAINT MARTIN (FRENCH PART)\",\"SAINT PIERRE AND MIQUELON\",\"SAN MARINO\",\"SLOVAKIA\",\"SLOVENIA\",\"SPAIN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('FJD', 'Fiji Dollar', '242', 100, '[\"FIJI\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('FKP', 'Falkland Islands Pound', '238', 100, '[\"FALKLAND ISLANDS (MALVINAS)\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GBP', 'Pound Sterling', '826', 100, '[\"GUERNSEY\",\"ISLE OF MAN\",\"JERSEY\",\"UNITED KINGDOM\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GEL', 'Lari', '981', 100, '[\"GEORGIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GHS', 'Ghana Cedi', '936', 100, '[\"GHANA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GIP', 'Gibraltar Pound', '292', 100, '[\"GIBRALTAR\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GMD', 'Dalasi', '270', 100, '[\"GAMBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GNF', 'Guinea Franc', '324', 1, '[\"GUINEA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GTQ', 'Quetzal', '320', 100, '[\"GUATEMALA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('GYD', 'Guyana Dollar', '328', 100, '[\"GUYANA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('HKD', 'Hong Kong Dollar', '344', 100, '[\"HONG KONG\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('HNL', 'Lempira', '340', 100, '[\"HONDURAS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('HRK', 'Croatian Kuna', '191', 100, '[\"CROATIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('HTG', 'Gourde', '332', 100, '[\"HAITI\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('HUF', 'Forint', '348', 100, '[\"HUNGARY\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('IDR', 'Rupiah', '360', 100, '[\"INDONESIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ILS', 'New Israeli Sheqel', '376', 100, '[\"ISRAEL\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('INR', 'Indian Rupee', '356', 100, '[\"BHUTAN\",\"INDIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('IQD', 'Iraqi Dinar', '368', 1000, '[\"IRAQ\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('IRR', 'Iranian Rial', '364', 100, '[\"IRAN, ISLAMIC REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ISK', 'Iceland Krona', '352', 1, '[\"ICELAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('JMD', 'Jamaican Dollar', '388', 100, '[\"JAMAICA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('JOD', 'Jordanian Dinar', '400', 1000, '[\"JORDAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('JPY', 'Yen', '392', 1, '[\"JAPAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KES', 'Kenyan Shilling', '404', 100, '[\"KENYA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KGS', 'Som', '417', 100, '[\"KYRGYZSTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KHR', 'Riel', '116', 100, '[\"CAMBODIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KMF', 'Comoro Franc', '174', 1, '[\"COMOROS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KPW', 'North Korean Won', '408', 100, '[\"KOREA, DEMOCRATIC PEOPLE\\u2019S REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KRW', 'Won', '410', 1, '[\"KOREA, REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KWD', 'Kuwaiti Dinar', '414', 1000, '[\"KUWAIT\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KYD', 'Cayman Islands Dollar', '136', 100, '[\"CAYMAN ISLANDS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('KZT', 'Tenge', '398', 100, '[\"KAZAKHSTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LAK', 'Kip', '418', 100, '[\"LAO PEOPLE\\u2019S DEMOCRATIC REPUBLIC\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LBP', 'Lebanese Pound', '422', 100, '[\"LEBANON\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LKR', 'Sri Lanka Rupee', '144', 100, '[\"SRI LANKA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LRD', 'Liberian Dollar', '430', 100, '[\"LIBERIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LSL', 'Loti', '426', 100, '[\"LESOTHO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LTL', 'Lithuanian Litas', '440', 100, '[\"LITHUANIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('LYD', 'Libyan Dinar', '434', 1000, '[\"LIBYA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MAD', 'Moroccan Dirham', '504', 100, '[\"MOROCCO\",\"WESTERN SAHARA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MDL', 'Moldovan Leu', '498', 100, '[\"MOLDOVA, REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MGA', 'Malagasy Ariary', '969', 100, '[\"MADAGASCAR\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MKD', 'Denar', '807', 100, '[\"MACEDONIA, THE FORMER \\nYUGOSLAV REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MMK', 'Kyat', '104', 100, '[\"MYANMAR\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MNT', 'Tugrik', '496', 100, '[\"MONGOLIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MOP', 'Pataca', '446', 100, '[\"MACAO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MRO', 'Ouguiya', '478', 100, '[\"MAURITANIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MUR', 'Mauritius Rupee', '480', 100, '[\"MAURITIUS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MVR', 'Rufiyaa', '462', 100, '[\"MALDIVES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MWK', 'Kwacha', '454', 100, '[\"MALAWI\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MXN', 'Mexican Peso', '484', 100, '[\"MEXICO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MXV', 'Mexican Unidad de Inversion (UDI)', '979', 100, '[\"MEXICO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MYR', 'Malaysian Ringgit', '458', 100, '[\"MALAYSIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('MZN', 'Mozambique Metical', '943', 100, '[\"MOZAMBIQUE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NAD', 'Namibia Dollar', '516', 100, '[\"NAMIBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NGN', 'Naira', '566', 100, '[\"NIGERIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NIO', 'Cordoba Oro', '558', 100, '[\"NICARAGUA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NOK', 'Norwegian Krone', '578', 100, '[\"BOUVET ISLAND\",\"NORWAY\",\"SVALBARD AND JAN MAYEN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NPR', 'Nepalese Rupee', '524', 100, '[\"NEPAL\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('NZD', 'New Zealand Dollar', '554', 100, '[\"COOK ISLANDS\",\"NEW ZEALAND\",\"NIUE\",\"PITCAIRN\",\"TOKELAU\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('OMR', 'Rial Omani', '512', 1000, '[\"OMAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PAB', 'Balboa', '590', 100, '[\"PANAMA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PEN', 'Nuevo Sol', '604', 100, '[\"PERU\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PGK', 'Kina', '598', 100, '[\"PAPUA NEW GUINEA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PHP', 'Philippine Peso', '608', 100, '[\"PHILIPPINES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PKR', 'Pakistan Rupee', '586', 100, '[\"PAKISTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PLN', 'Zloty', '985', 100, '[\"POLAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('PYG', 'Guarani', '600', 1, '[\"PARAGUAY\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('QAR', 'Qatari Rial', '634', 100, '[\"QATAR\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('RON', 'New Romanian Leu', '946', 100, '[\"ROMANIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('RSD', 'Serbian Dinar', '941', 100, '[\"SERBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('RUB', 'Russian Ruble', '643', 100, '[\"RUSSIAN FEDERATION\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('RWF', 'Rwanda Franc', '646', 1, '[\"RWANDA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SAR', 'Saudi Riyal', '682', 100, '[\"SAUDI ARABIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SBD', 'Solomon Islands Dollar', '090', 100, '[\"SOLOMON ISLANDS\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SCR', 'Seychelles Rupee', '690', 100, '[\"SEYCHELLES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SDG', 'Sudanese Pound', '938', 100, '[\"SUDAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SEK', 'Swedish Krona', '752', 100, '[\"SWEDEN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SGD', 'Singapore Dollar', '702', 100, '[\"SINGAPORE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SHP', 'Saint Helena Pound', '654', 100, '[\"SAINT HELENA, ASCENSION AND \\nTRISTAN DA CUNHA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SLL', 'Leone', '694', 100, '[\"SIERRA LEONE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SOS', 'Somali Shilling', '706', 100, '[\"SOMALIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SRD', 'Surinam Dollar', '968', 100, '[\"SURINAME\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SSP', 'South Sudanese Pound', '728', 100, '[\"SOUTH SUDAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('STD', 'Dobra', '678', 100, '[\"SAO TOME AND PRINCIPE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SVC', 'El Salvador Colon', '222', 100, '[\"EL SALVADOR\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SYP', 'Syrian Pound', '760', 100, '[\"SYRIAN ARAB REPUBLIC\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('SZL', 'Lilangeni', '748', 100, '[\"SWAZILAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('THB', 'Baht', '764', 100, '[\"THAILAND\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TJS', 'Somoni', '972', 100, '[\"TAJIKISTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TMT', 'Turkmenistan New Manat', '934', 100, '[\"TURKMENISTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TND', 'Tunisian Dinar', '788', 1000, '[\"TUNISIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TOP', 'Pa’anga', '776', 100, '[\"TONGA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TRY', 'Turkish Lira', '949', 100, '[\"TURKEY\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TTD', 'Trinidad and Tobago Dollar', '780', 100, '[\"TRINIDAD AND TOBAGO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TWD', 'New Taiwan Dollar', '901', 100, '[\"TAIWAN, PROVINCE OF CHINA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('TZS', 'Tanzanian Shilling', '834', 100, '[\"TANZANIA, UNITED REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('UAH', 'Hryvnia', '980', 100, '[\"UKRAINE\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('UGX', 'Uganda Shilling', '800', 1, '[\"UGANDA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('USD', 'US Dollar', '840', 100, '[\"AMERICAN SAMOA\",\"BONAIRE, SINT EUSTATIUS AND SABA\",\"BRITISH INDIAN OCEAN TERRITORY\",\"ECUADOR\",\"EL SALVADOR\",\"GUAM\",\"HAITI\",\"MARSHALL ISLANDS\",\"MICRONESIA, FEDERATED STATES OF\",\"NORTHERN MARIANA ISLANDS\",\"PALAU\",\"PANAMA\",\"PUERTO RICO\",\"TIMOR-LESTE\",\"TURKS AND CAICOS ISLANDS\",\"UNITED STATES\",\"UNITED STATES MINOR OUTLYING ISLANDS\",\"VIRGIN ISLANDS (BRITISH)\",\"VIRGIN ISLANDS (U.S.)\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('USN', 'US Dollar (Next day)', '997', 100, '[\"UNITED STATES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('UYI', 'Uruguay Peso en Unidades Indexadas (URUIURUI)', '940', 1, '[\"URUGUAY\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('UYU', 'Peso Uruguayo', '858', 100, '[\"URUGUAY\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('UZS', 'Uzbekistan Sum', '860', 100, '[\"UZBEKISTAN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('VEF', 'Bolivar', '937', 100, '[\"VENEZUELA, BOLIVARIAN REPUBLIC OF\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('VND', 'Dong', '704', 1, '[\"VIET NAM\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('VUV', 'Vatu', '548', 1, '[\"VANUATU\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('WST', 'Tala', '882', 100, '[\"SAMOA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XAF', 'CFA Franc BEAC', '950', 1, '[\"CAMEROON\",\"CENTRAL AFRICAN REPUBLIC\",\"CHAD\",\"CONGO\",\"EQUATORIAL GUINEA\",\"GABON\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XCD', 'East Caribbean Dollar', '951', 100, '[\"ANGUILLA\",\"ANTIGUA AND BARBUDA\",\"DOMINICA\",\"GRENADA\",\"MONTSERRAT\",\"SAINT KITTS AND NEVIS\",\"SAINT LUCIA\",\"SAINT VINCENT AND THE GRENADINES\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XDR', 'SDR (Special Drawing Right)', '960', 1, '[\"INTERNATIONAL MONETARY FUND (IMF)\\u00a0\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XOF', 'CFA Franc BCEAO', '952', 1, '[\"BENIN\",\"BURKINA FASO\",\"C\\u00d4TE D\'IVOIRE\",\"GUINEA-BISSAU\",\"MALI\",\"NIGER\",\"SENEGAL\",\"TOGO\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XPF', 'CFP Franc', '953', 1, '[\"FRENCH POLYNESIA\",\"NEW CALEDONIA\",\"WALLIS AND FUTUNA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XSU', 'Sucre', '994', 1, '[\"SISTEMA UNITARIO DE COMPENSACION REGIONAL DE PAGOS \\\"SUCRE\\\"\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('XUA', 'ADB Unit of Account', '965', 1, '[\"MEMBER COUNTRIES OF THE AFRICAN DEVELOPMENT BANK GROUP\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('YER', 'Yemeni Rial', '886', 100, '[\"YEMEN\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ZAR', 'Rand', '710', 100, '[\"LESOTHO\",\"NAMIBIA\",\"SOUTH AFRICA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ZMW', 'Zambian Kwacha', '967', 100, '[\"ZAMBIA\"]');
INSERT INTO `currencies` (`code`, `name`, `number`, `subunits_in_unit`, `countries`) VALUES ('ZWL', 'Zimbabwe Dollar', '932', 100, '[\"ZIMBABWE\"]');


#
# TABLE STRUCTURE FOR: customer
#

DROP TABLE IF EXISTS `customer`;

CREATE TABLE `customer` (
  `customer_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `no_services` varchar(128) NOT NULL,
  `email` varchar(128) NOT NULL,
  `register_date` varchar(50) NOT NULL,
  `due_date` int(11) NOT NULL,
  `address` text NOT NULL,
  `no_wa` varchar(128) NOT NULL,
  `c_status` varchar(128) NOT NULL,
  `ppn` int(11) NOT NULL,
  `no_ktp` varchar(128) NOT NULL,
  `ktp` text NOT NULL,
  `created` int(11) NOT NULL,
  `mode_user` varchar(50) NOT NULL,
  `user_mikrotik` varchar(128) NOT NULL,
  `mitra` int(11) NOT NULL,
  `coverage` int(11) NOT NULL,
  `auto_isolir` int(11) NOT NULL,
  `type_id` varchar(50) NOT NULL,
  `router` int(11) NOT NULL,
  `codeunique` int(11) NOT NULL,
  `phonecode` int(11) NOT NULL,
  `latitude` text NOT NULL,
  `longitude` text NOT NULL,
  `user_profile` varchar(50) NOT NULL,
  `action` int(11) NOT NULL,
  `type_payment` int(11) NOT NULL,
  `max_due_isolir` int(11) NOT NULL,
  `olt` int(11) NOT NULL,
  `connection` int(11) NOT NULL,
  `cust_amount` int(11) NOT NULL,
  `mac_address` varchar(50) NOT NULL,
  `level` int(11) NOT NULL,
  `cust_description` text NOT NULL,
  `type_ip` int(11) NOT NULL,
  `id_odc` int(11) NOT NULL,
  `id_odp` int(11) NOT NULL,
  `no_port_odp` int(11) NOT NULL,
  `month_due_date` int(11) NOT NULL,
  `serial_number` text NOT NULL,
  `pass_mikrotik` text NOT NULL,
  `slot` int(11) NOT NULL,
  `port` int(11) NOT NULL,
  `onu_index` int(11) NOT NULL,
  `onu_type` text NOT NULL,
  `vlan` int(11) NOT NULL,
  `send_bill` int(11) NOT NULL,
  `no_va` text NOT NULL,
  `up_onu` text NOT NULL,
  `down_onu` text NOT NULL,
  `customer_mitra` int(11) NOT NULL,
  `createby` int(11) NOT NULL,
  `uuid` text NOT NULL,
  `nomorcodeuniq` int(11) NOT NULL,
  `mediaconnection` int(11) NOT NULL,
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `uniq_no_services` (`no_services`)
) ENGINE=InnoDB AUTO_INCREMENT=1063 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (1, 'Bambang Wisnu', '105020001', 'bambangwisnu@bytehome.id', '24-07-25', 5, 'Balong Bendo Probolinggo', '6281357383093', 'Aktif', 0, '3515121502780000', '', 1725697921, 'PPPOE', 'balongbendo_bambang', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 3, 19, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (2, 'Noviana', '105010001', 'noviana01@bytehome.id', '24-08-08', 5, ' Jl Tangkuban perahu Pilang', '6283861989363', 'Aktif', 0, '3325135511830000', '', 1725699230, 'PPPOE', 'pilang_noviana', 0, 5, 1, 'KTP', 17, 1, 62, '', '', 'paket 30Mbps', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 3, 53, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (3, 'Saifullah', '105020002', 'saifullah01@gmail.com', '2024-08-10', 5, 'Jl KH Abdul hamid,Kebonsari Kulon, Kanigaran', '6281276829001', 'Non-Aktif', 0, '351318312800002', '', 1725699952, 'PPPOE', 'kanigaran_saifullah', 0, 1, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 2, 1, 18, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (4, 'Sofi Eka Anggraini', '105010002', 'sofieka@bytehome.id', '24-08-12', 5, 'Jl.Wijaya Kusuma,Sukabumi,Mayangan', '6283189850689', 'Non-Aktif', 0, '357403600608003', '', 1725700505, 'PPPOE', 'wijayakusuma_sofi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 45, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (5, 'Umi Kulsum', '105020003', 'umikulsum01@bytehome.id', '2024-07-12', 5, 'Wonoasih', '6281330741481', 'Aktif', 0, '', '', 1725932901, 'PPPOE', 'wonoasih_kulsum', 0, 6, 1, 'KTP', 10, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 13, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (6, 'Havied Saputra', '105020004', 'haviedsaputra01@bytehome.id', '24-09-14', 5, 'Jl.Cangkring, Kanigaran', '6289682909018', 'Aktif', 0, '', '', 1725933277, 'PPPOE', 'cangkring_havied', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 18, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (7, 'Tutmiati', '105010003', 'tutmiati01@bytehome.id', '24-07-20', 5, 'Taman Semeru Perum Permai', '62895321721525', 'Aktif', 0, '', '', 1725933511, 'PPPOE', 'triwungkidul_tutmiati', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 20, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (8, 'Ghofur Wijaksono', '105020005', 'ghofurwijaksono01@bytehome.id', '24-07-25', 5, 'Gang Kirana, Kanigaran', '6285257788258', 'Aktif', 0, '3574042210830010', '', 1725933964, 'PPPOE', 'kirana_ghofur', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 18, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (9, 'Rio Andi Andika', '105020006', 'rioandiandika01@bytehome.id', '24-08-28', 5, 'Jl.Cangkring, Kanigaran', '6285648407387', 'Aktif', 0, '3574041003970000', '', 1725934209, 'PPPOE', 'cangkring_rio', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 18, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (10, 'Ahmad Kudri', '105010004', 'ahmadkkudri@bytehome.id', '24-07-29', 5, 'Jl.Kelud, Ketapang', '6285143409968', 'Aktif', 0, '3574052004900000', '', 1725934622, 'PPPOE', 'kelud_kudri', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 5, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (11, 'Abdurahman Saleh', '105010005', 'abdurahmansaleh01@bytehome.id', '24-09-30', 4, 'Jl.Merbabu, Kanigaran', '6282335561627', 'Non-Aktif', 0, '3574011702860000', '', 1725934830, 'PPPOE', 'merbabu_abdurrahman', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 0, '', 0, '', 0, 3, 31, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (12, 'Ahmad Taufiq', '105020007', 'ahmadtaufiq@bytehome.id', '24-08-01', 5, 'Asian Cell Jalan Dr Sutomo', '6282337716768', 'Non-Aktif', 0, '3513220501860000', '', 1725935372, 'PPPOE', 'jlnsutomo_taufiq', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 30, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (13, 'Supriyanto', '105010006', 'supriyanto01@bytehome.id', '24-08-02', 5, 'Jl. Merbabu, Kec. Kademangan', '6285330891082', 'Non-Aktif', 0, '3574011010630000', '', 1725935907, 'PPPOE', 'merbabu_supriyanto', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 32, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (14, 'Sulastri', '105010007', 'sulastri01@bytehome.id', '23-08-02', 5, 'Jl. Merbabu, Kec. Kademangan', '628563460418', 'Aktif', 0, '3513183007980000', '', 1725936171, 'PPPOE', 'merbabu_sulastri', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 32, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (15, 'Sapik', '105010008', 'sapik01@bytehome.id', '24-09-02', 5, 'Jl. Merbabu, Kec. Kademangan', '6285645369547', 'Aktif', 0, '3574012910780000', '', 1725936346, 'PPPOE', 'merbabu_sapik', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 32, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (17, 'Luxman Hidayatulloh', '105010010', 'luxmanhidayatulloh10@bytehome.id', '24-09-03', 5, 'Jl. Merbabu, Kec. Kademangan', '6283136544903', 'Aktif', 0, '3574010401990000', '', 1725937390, 'PPPOE', 'merbabu_luxman', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 32, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (18, 'Ririn Indah Astutik', '105020008', 'ririnindahastutik01@bytehome.id', '24-08-05', 5, 'Jl Cokroaminoto GG Cemara No 9', '6281331069445', 'Aktif', 0, '3574046702790000', '', 1725937600, 'PPPOE', 'cemara_ririn', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 51, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (19, 'Bambang Ariyanto', '105020009', 'bambangariyanto01@bytehome.id', '24-08-05', 5, 'Jl Cokroaminoto GG Cemara No 34', '6285330925005', 'Aktif', 0, '3574040107770210', '', 1725938196, 'PPPOE', 'kirana_bambang', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 51, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (20, 'Mujib', '105010011', 'mujib01@bytehome.id', '24-08-07', 5, 'Jl Damai, Ketapang', '6282335521855', 'Aktif', 0, '3574012612680000', '', 1725938433, 'PPPOE', 'damai_mujib', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 3, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (21, 'Faulina Tri Anjani', '105020010', 'faulinatrianjani01@bytehome.id', '24-08-09', 5, 'Jl Sultan Agung, Kanigaran', '6282338193194', 'Non-Aktif', 0, '3574046508940000', '', 1725939388, 'PPPOE', 'kanigaran_anjani', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 41, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (22, 'Yulian Pramana', '105020011', 'yulianpramana01@bytehome.id', '24-08-10', 5, 'Jl KH Abdul hamid,Kebonsari Kulon, Kanigaran', '6287760324290', 'Aktif', 0, '3527060107931050', '', 1726103484, 'PPPOE', 'kanigaran_yulian', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 4, 41, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (23, 'Moh. Sholeh', '105020012', 'hanafi01@bytehome.id', '24-08-12', 5, 'Jl. slamet riyadi, Kanigaran', '6282335523310', 'Aktif', 0, '3527060107931050', '', 1726104523, 'PPPOE', 'kanigaran_sholeh', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 52, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (24, 'Aji Pamungkas', '105010012', 'ajipamungkas01@bytehome.id', '24-08-13', 5, 'Jl. Seruni, Sukabumi, Mayangan', '6289608352868', 'Aktif', 0, '6402063110830010', '', 1726104906, 'PPPOE', 'seruni_aji', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 44, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (25, 'Fajar Teguh Wijonarko', '105010013', 'fajarteguhwijonarko01@bytehome.id', '24-08-15', 5, 'Jl Porong Perum Grand Hilton, Sumber wetan', '6282337858787', 'Non-Aktif', 0, '3513201610940000', '', 1726111521, 'PPPOE', 'hilton_fajar', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 10Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 38, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (26, 'Kantor Kelurahan', '105010014', 'kantorkelurahan01@bytehome.id', '24-08-15', 5, 'Jl.Wijaya Kusuma,Sukabumi,Mayangan', '6285257784804', 'Free', 0, '', '', 1726111767, 'PPPOE', 'kantor_sukabumi', 0, 5, 0, 'KTP', 10, 0, 0, '', '', 'paket 10Mbps', 0, 0, 0, 0, 0, 165000, '', 0, '', 0, 3, 44, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (27, 'Bayu Wirasmanto', '105020013', 'bayuwirasmanto01@bytehome.id', '24-08-17', 5, 'Jl. Danau Sentani, Jrebeng Kulon', '6285256225671', 'Aktif', 0, '7406040610920000', '', 1726111923, 'PPPOE', 'danausentani_bayu', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 48, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (28, 'Anang Sukrisna', '105010015', 'anangsukrisna01@bytehome.id', '24-08-19', 5, 'Jl. Supriyadi, Kademangan', '6282331317323', 'Non-Aktif', 0, '3574011901770000', '', 1726112121, 'PPPOE', 'supriyadi_anangsukrisna', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 3, 27, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (29, 'Sugianto', '105010016', 'sugianto01@bytehome.id', '24-08-21', 5, ' Jl Tangkuban Perahu, Pilang', '6285607611719', 'Aktif', 0, '3574012405830000', '', 1726112279, 'PPPOE', 'pilang_sugianto', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 3, 53, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (30, 'Devita Nur Andira', '105020014', 'devitanurandira01@bytehome.id', '24-08-21', 5, 'Asian Cell 2 Jalan Dr Sutomo', '6282233748488', 'Non-Aktif', 0, '3574046412050000', '', 1726113701, 'PPPOE', 'jlnsutomo_devita', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 54, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (31, 'Danis Tri Dermawan', '105020015', 'danistridermawan01@bytehome.id', '24-08-22', 5, 'Jl.KH.Abdul Hamid GG Kebon', '6289519005209', 'Aktif', 0, '3574042508800000', '', 1726114312, 'PPPOE', 'kanigaran_danis', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 41, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (32, 'Nur Ana', '105020016', 'nurana01@bytehome.id', '24-08-26', 5, 'JL.Gatot Subroto Mayangan', '6285299415109', 'Non-Aktif', 0, '7312054503910000', '', 1726114664, 'PPPOE', 'gatot_nurana', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 55, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (33, 'Elis Indrawati', '105010017', 'elisindrawati01@bytehome.id', '24-08-26', 5, 'Jl.Semeru Triwung Kidul', '6285232195884', 'Aktif', 0, '3513216103840000', '', 1726115084, 'PPPOE', 'semeru_elis1', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 56, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (34, 'Rudi Hartono', '105010018', 'rudihartono01@bytehome.id', '24-08-30', 5, 'Perum Permata kademangan', '6282334052507', 'Non-Aktif', 0, '3574034407800000', '', 1726115941, 'PPPOE', 'permata_rudi', 0, 5, 1, 'KTP', 10, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 60, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (35, 'Umaryati', '105020017', 'Umaryati@bytehome.id', '24-08-31', 5, 'Jl. Kh abdul khamid, Jrebeng lor', '6285755351127', 'Non-Aktif', 0, '3574054808790000', '', 1727235753, 'PPPOE', 'jlabdulkhamid_umaryati', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 59, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (36, 'Merry Noviana', '105020018', 'Merrynoviana@bytehome.id', '24-09-04', 5, 'Jl Ikan Cumi Cumi, Mayangan', '6282142408797', 'Aktif', 0, '3574034211010000', '', 1727236658, 'PPPOE', 'cumicumi_merry', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 65, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (37, 'Farid Widiyatmoko', '105020019', 'Faridwidiyatmoko@bytehome.id', '24-09-05', 5, 'Kantor Kodim 0820 Probolinggo', '6282233430123', 'Aktif', 0, '3515162503640000', '', 1727237073, 'PPPOE', 'kantorkodim_farid', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 1, 205000, '', 0, '', 0, 4, 66, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (38, 'Cindy Natalia', '105020020', 'Cindynatalia@bytehome.id', '24-09-05', 5, 'Jl.Cangkring, Kanigaran', '6289676472786', 'Aktif', 0, '3574046010020010', '', 1727237282, 'PPPOE', 'jlncangkring_cindy', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 18, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (39, 'Sulastri', '105020021', 'Sulastri02@bytehome.id', '24-09-06', 5, 'Jl.Cangkring, Kanigaran', '62895331281400', 'Aktif', 0, '3574044102720000', '', 1727237555, 'PPPOE', 'jlncangkring_sulastri', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 18, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (40, 'Hariyanti', '105020022', 'Hariyanti@bytehome.id', '24-09-07', 5, 'Jl. Ikan Cumi Cumi', '62895327241598', 'Aktif', 0, '3574035302950000', '', 1727237727, 'PPPOE', 'cumicumi_hariyanti', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 65, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (41, 'Winarti', '105020023', 'Winarti@bytehome.id', '24-09-10', 5, 'Jalan Ikan Tongkol Mayangan', '6285236474104', 'Aktif', 0, '3574036507840000', '', 1727237951, 'PPPOE', 'tongkol_winarti', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 67, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (42, 'Salama', '105020024', 'Salama@bytehome.id', '24-09-11', 5, 'Jalan Ikan Tongkol Mayangan', '6289518688859', 'Aktif', 0, '3574035710750000', '', 1727238103, 'PPPOE', 'tongkol_salama', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 67, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (43, 'Valendria Flora', '105020025', 'Valendriaflora@bytehome.id', '24-09-11', 5, 'Jl.Cangkring, Kanigaran', '6289523895643', 'Aktif', 0, '3574046307060000', '', 1727238619, 'PPPOE', 'jlncangkring_valendria', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 18, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (44, 'Muhammad Roy Fayzal. R', '105020026', 'muhammadroyfayzal@bytehome.id', '24-09-13', 5, 'Jalan Cangkring Gang 2 Nomor 103 Kota Probolinggo', '6282330539300', 'Non-Aktif', 0, '3574041203940000', '', 1727239210, 'PPPOE', 'cangkring_roy', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 40Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 18, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (45, 'Nur Linda Wahyuni', '105020027', 'nurlindawahyuni@bytehome.id', '24-09-14', 5, 'Jl.Cangkring, Kanigaran', '6285784722810', 'Aktif', 0, '357404510820003', '', 1727239444, 'PPPOE', 'cangkring_linda', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 18, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (46, 'Jumiati', '105020028', 'jumiati@bytehome.id', '24-09-14', 5, 'Jl.Cangkring, Kanigaran', '62881027659888', 'Aktif', 0, '3574045005880000', '', 1727239660, 'PPPOE', 'jlncangkring_jumiati', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 18, 8, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (47, 'Veronica Kristinawati', '105010019', 'veronicakristinawati@bytehome.id', '24-09-16', 5, 'Perum Kopian Barat', '6285230468906', 'Aktif', 0, '3574015303660000', '', 1727239875, 'PPPOE', 'perumkopian_veronica', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 3, 3, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (48, 'Rista Silvia', '105020029', 'ristasilvia@bytehome.id', '24-09-19', 5, 'Jl. KY Ilyas Jrebeng Kidul', '6285853916795', 'Aktif', 0, '3574025204920000', '', 1727240444, 'PPPOE', 'jrebengkidul_rista', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 70, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (49, 'Sulis Tiarni', '105010020', 'sulistiarni@bytehome.id', '24-09-20', 5, 'Blok Kolor NO.22 Kademangan', '6287705579536', 'Non-Aktif', 0, '3513215803010010', '', 1727243372, 'PPPOE', 'kademangan_sulis', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'paket 10Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 72, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (50, 'Abdur Rohman', '105020030', 'abdurrohman@bytehome.id', '24-09-21', 5, 'Jl. Cangkring', '6285604039158', 'Aktif', 0, '3574041409010000', '', 1727243549, 'PPPOE', 'jlncangkring_rahman', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 18, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (51, 'Uswatun Hasanah', '105010021', 'uswatunhasanah@bytehome.id', '24-09-21', 5, 'Jl. Argopuro, Kademangan', '6282331601484', 'Aktif', 0, '3574016508840010', '', 1727244006, 'PPPOE', 'jlnargopuro_uswatun', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 3, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (52, 'Endang', '105010022', 'endang@bytehome.id', '24-09-21', 5, 'Jl. Batur Kademangan', '6282131943073', 'Non-Aktif', 0, '3574015504800000', '', 1727244167, 'PPPOE', 'batur_endang', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 72, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (53, 'Mislahi Homsatun', '105010023', 'mislahihomsatun@bytehome.id', '24-09-23', 5, 'Jl. Bengawan Solo', '6285330222225', 'Aktif', 0, '35132264404880000', '', 1727244320, 'PPPOE', 'bengawansolo_mislahi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 38, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (54, 'Sri Astutik', '105020031', 'sriastutik1@bytehome.id', '24-10-03', 5, 'Jalan Cangkring', '6285233783804', 'Aktif', 0, '', '', 1729587539, 'PPPOE', 'cangkring_astutik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 18, 10, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (55, 'Kardina Dyah Wilujeng', '105020032', 'kardinadyahwilujeng@bytehome.id', '24-10-03', 5, 'JL.Cangkring', '6281336536122', 'Non-Aktif', 0, '', '', 1729587790, 'PPPOE', 'cangkring_kardina', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 18, 11, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (56, 'Erfan Hariyanto', '105020033', 'erfanhariyanto@bytehome.id', '24-10-05', 5, 'JL.Sunan Ampel Jrebeng Lor', '6285942865081', 'Aktif', 0, '', '', 1729588050, 'PPPOE', 'jrebenglor_erfan', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 71, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (57, 'Misdah Lestari', '105020034', 'misdahlestari@bytehome.id', '24-10-07', 5, 'JL.KH Abdul Hamid No.105 Kebonsari kulon', '628233450262', 'Aktif', 0, '', '', 1729588255, 'PPPOE', 'kanigaran_misdah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 40, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (58, 'Kukuh Rahedi Bramantyo', '105020035', 'kukuhrahedibramantyo@bytehome.id', '24-10-08', 5, 'JL. Porong sumber wetan', '6282313233187', 'Aktif', 0, '', '', 1729588482, 'PPPOE', 'jlporong_kukuh', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 48, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (59, 'Rohmatul Hikmah', '105010024', 'rohmatulhikmah@bytehome.id', '24-10-02', 5, 'Kopian Ketapang', '6285233699963', 'Aktif', 0, '', '', 1729738258, 'PPPOE', 'kopian_rohmatul', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 2, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (60, 'Hairus Sholeh', '105010025', 'hairussholeh@bytehome.id', '24-10-16', 5, 'JL.Semeru Gg Rinjani', '6283129334439', 'Aktif', 0, '', '', 1729738938, 'PPPOE', 'semeru_hairus', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 56, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (61, 'Ita Purnamasari', '105010026', 'itapurnamasari1@bytehome.id', '24-10-18', 5, 'Jl. Brantas Kademangan', '628817133603', 'Non-Aktif', 0, '', '', 1729739106, 'PPPOE', 'brantas_ita', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 33, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (62, 'Lailatul Komariah', '105020036', 'lailatulkomariah1@bytehome.id', '24-09-28', 5, 'Jl Sunan Ampel Jrebeng Lor', '6285784905641', 'Aktif', 0, '', '', 1729927029, 'PPPOE', 'jlsunanampel_komariah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 78, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (63, 'Nining Agustin', '105010027', 'niningagustin@bytehome.id', '24-10-01', 5, 'Jl Cempaka Mayangan', '6285348770153', 'Non-Aktif', 0, '', '', 1729927350, 'PPPOE', 'cempaka_nining', 0, 5, 1, 'KTP', 10, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 81, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (64, 'M. Mirza Alfiansyah', '105020037', 'mmirzaalfiansyah@bytehome.id', '24-10-03', 5, 'JL.Cokroaminoto GG 11', '6281230914693', 'Aktif', 0, '', '', 1729927497, 'PPPOE', 'jlcokroaminoto_mirza', 0, 6, 1, 'KTP', 10, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 82, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (65, 'Lilik Hindun', '105020038', 'lilikhindun@bytehome.id', '24-10-07', 5, 'JL.Sunan Ampel Jrebeng Lor', '6289502239640', 'Aktif', 0, '', '', 1729927651, 'PPPOE', 'jlsunanampel_lilik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 77, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (66, 'Prita Yulinda Anggriani', '105010028', 'pritayulindaanggriani@bytehome.id', '24-10-09', 5, 'Jl. Argopuro XVII/3 Ds. Ketapang', '6282338310853', 'Aktif', 0, '', '', 1729929955, 'PPPOE', 'ketapang_prita', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 83, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (67, 'Achmad Afandy', '105010029', 'achmadafandy@bytehome.id', '24-10-09', 5, 'Jl. Cempaka No. 59 Ds. Sukabumi ', '6285815036073', 'Non-Aktif', 0, '', '', 1729930158, 'PPPOE', 'cempaka_afandy', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 81, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (68, 'Muhammad Arif', '105020039', 'muhammadarif1@bytehome.id', '24-10-10', 5, 'Jl. Kali Ciliwung', '6285258880990', 'Aktif', 0, '', '', 1729930324, 'PPPOE', 'jlciliwung_arif', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 85, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (69, 'Ambarwati', '105020040', 'ambarwati1@bytehome.id', '24-10-11', 5, 'Jl. Ikan Cumi Cumi Mayangan', '6282331414172', 'Non-Aktif', 0, '', '', 1729930991, 'PPPOE', 'cumicumi_ambarwati', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 65, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (70, 'Ainul Mashudi', '105010030', 'ainulmashudi@bytehome.id', '24-10-12', 5, 'KP Bromo Fhising Jl Sukarno Hatta no 98 Kel pilang', '6285234312789', 'Non-Aktif', 0, '', '', 1729992863, 'PPPOE', 'soekarnohatta_mashudi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 100Mbps', 1, 0, 1, 0, 0, 385000, '', 0, '', 0, 3, 86, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (71, 'Yuni Kurnia Adiyanti', '105020041', 'yunikurniaadiyanti@bytehome.id', '24-10-14', 5, 'Jalan Cokroaminoto Gg Kirana No 37', '628113437959', 'Aktif', 0, '', '', 1729993055, 'PPPOE', 'kirana_yuni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 51, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (72, 'Nurul Fadilah', '105010031', 'nurulfadilah@bytehome.id', '24-10-15', 5, 'JL.Anggrek Pilang', '6282142393240', 'Non-Aktif', 0, '', '', 1729993204, 'PPPOE', 'anggrekpilang_nurul', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 87, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (73, 'Mihari', '105020042', 'mihari@bytehome.id', '24-10-17', 5, 'Jalan ABDUL Azis GG kemiri KEBONSARI kulon', '6282230042329', 'Aktif', 0, '', '', 1729993351, 'PPPOE', 'kebonsari_mihari', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 10Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 88, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (74, 'Sulistiani', '105020043', 'sulistiani1@bytehome.id', '24-10-19', 5, 'Jl Cokroaminoto GG 10 No 98 A', '6285233355478', 'Aktif', 0, '', '', 1729993518, 'PPPOE', 'jlcokroaminoto_sulistiani', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 82, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (75, 'Yeni Widiastutik', '105020044', 'yeniwidiastutik@bytehome.id', '24-10-21', 5, 'Jl. Cokroaminoto GG 10 No 94', '6285232697989', 'Non-Aktif', 0, '', '', 1729993684, 'PPPOE', 'cokrominoto_yeni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 82, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (76, 'Maria Ulfa', '105010032', 'mariaulfa1@bytehome.id', '24-10-21', 5, 'Jl. Merapi Perum New Kartika Regency A2 Triwunglor', '6283848700942', 'Aktif', 0, '', '', 1729993868, 'PPPOE', 'jlmerapi_mariaulfa', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 49, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (77, 'Lailatul Munawaroh', '105010033', 'lailatulmunawaroh@bytehome.id', '24-10-25', 5, 'Jl. Argopuro Ketapang (Kopian, tetangga kontrakan)', '6285236702596', 'Aktif', 0, '', '', 1729997867, 'PPPOE', 'kopian_lailatul', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 2, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (78, 'Ferdi Soni Wijayanto', '105010034', 'ferdisoniwijayanto@bytehome.id', '24-10-26', 5, 'Jl. Ky Hasin Mas Ds. Curahgrinting (Jl. Kapuas)', '6289509538045', 'Non-Aktif', 0, '', '', 1729998054, 'PPPOE', 'jlnkapuas_ferdi', 0, 5, 1, 'KTP', 10, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 34, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (79, 'Shise Aryhana', '105010035', 'shisearyhana@bytehome.id', '24-11-01', 5, 'Jl. Jambu, Sumber Wetan, Kedopok', '6282249422634', 'Aktif', 0, '', '', 1730517014, 'PPPOE', 'jljambu_shise', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 89, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (80, 'Ita Purnamasari', '105010036', 'itapurnamasari2@bytehome.id', '24-10-18', 5, 'Jl. Brantas Kademangan', '628817133603', 'Non-Aktif', 0, '', '', 1730535547, 'PPPOE', 'brantas_ita', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 33, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (81, 'Noviani Susanti', '105020045', 'novianisusanti@bytehome.id', '24-11-01', 5, 'Jl. Angguran Raya, Kebonsari Kulon', '6281285719677', 'Aktif', 0, '', '', 1732173891, 'PPPOE', 'angguranraya_noviani', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 41, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (82, 'Ahmad Fauzan', '105020046', 'ahmadfauzan@bytehome.id', '24-11-01', 5, 'Jl. Sunan Ampel Ds. Jrebeng Lor', '6285745577581', 'Aktif', 0, '', '', 1732174114, 'PPPOE', 'jrebenglor_fauzan', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 70, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (83, 'Imam Faniti', '105020047', 'imamfaniti@bytehome.id', '24-11-01', 5, 'Jl. Ikan Banyar Ds. Mayangan', '6289516942904', 'Non-Aktif', 0, '', '', 1732174838, 'PPPOE', 'jlnikantongkol_imam', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 63, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (84, 'Yatik Farida', '105020048', 'yatikfarida@bytehome.id', '24-11-01', 5, 'Jl. Raya Panglima Sudirman Kebonsari kulon', '6285183098449', 'Aktif', 0, '', '', 1732175033, 'PPPOE', 'jlpangsud_yatik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (85, 'Roni Fajri', '105020049', 'ronifajri@bytehome.id', '24-11-01', 5, 'Jl. Raya Panglima Sudirman Kebonsari kulon', '6282334143896', 'Aktif', 0, '', '', 1732175232, 'PPPOE', 'jlpangsud_roni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (86, 'Hariono', '105020050', 'hariono2@bytehome.id', '24-11-01', 5, 'Jl. Raya Panglima Sudirman Jati Mayangan', '6287746562360', 'Aktif', 0, '', '', 1732237540, 'PPPOE', 'jlpangsud_hariono', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (87, 'Siti Aminah', '105020051', 'sitiaminah4@bytehome.id', '24-11-01', 5, 'Jl. Raya Panglima Sudirman Kebonsari kulon', '6282302306704', 'Aktif', 0, '', '', 1732237933, 'PPPOE', 'jlpangsud_sitiaminah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (88, 'Sumaidah', '105020052', 'sumaidah@bytehome.id', '24-11-01', 5, 'Jl. Raya Panglima Sudirman Kebonsari kulon', '6283843680722', 'Aktif', 0, '', '', 1732238140, 'PPPOE', 'jlpangsud_sumaida', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (89, 'Erma Wahyuni', '105020053', 'ermawahyuni@bytehome.id', '24-11-01', 5, 'Jl. Raya Panglima Sudirman Kebonsari kulon', '6289682972259', 'Aktif', 0, '', '', 1732238276, 'PPPOE', 'jlpangsud_ermawahyuni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (90, 'Foni Octa Fiyanti', '105020054', 'fonioctafiyanti@bytehome.id', '24-11-01', 5, 'Jl. Raya Panglima Sudirman Kebonsari kulon', '6285231415953', 'Non-Aktif', 0, '', '', 1732238544, 'PPPOE', 'jlpangsud_foni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 90, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (91, 'Dwi Fitria UIfa', '105020055', 'dwifitriauIfa@bytehome.id', '24-11-01', 5, 'Jl. Raya Panglima Sudirman Kebonsari kulon', '6281393325037', 'Aktif', 0, '', '', 1732239046, 'PPPOE', 'jlpangsud_dwifitriaulfa', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (92, 'Yahya Verdian Susilo', '105010037', 'yahyaverdiansusilo@bytehome.id', '24-11-01', 5, 'Dsn. Langgaran Ds. Kalisalam (jl. anggrek pilang)', '6285788347248', 'Non-Aktif', 0, '', '', 1732239634, 'PPPOE', 'anggrekpilang_yahyaverdiawan', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 93, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (93, 'Ahmad Badri', '105020056', 'ahmadbadri@bytehome.id', '24-11-01', 5, 'Jl. Raya Panglima Sudirman Kebonsari kulon', '85655604709', 'Non-Aktif', 0, '', '', 1732239737, 'PPPOE', 'jlpangsud_badri', 0, 6, 1, 'KTP', 10, 0, 62, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 8, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (94, 'Alexander Nataluis', '105020057', 'alexandernataluis@bytehome.id', '24-11-01', 5, 'Jl. Cokrominoto Gg Cemara 21 kanigaran', '6289526071705', 'Aktif', 0, '', '', 1732239871, 'PPPOE', 'cokrominoto_alexander', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 51, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (95, 'Yuli Purwitasari', '105010038', 'yulipurwitasari@bytehome.id', '24-11-01', 5, 'Jl. Gunung Batur Kademangan', '6285230520569', 'Aktif', 0, '', '', 1732240200, 'PPPOE', 'jlgunungbatur_yuli', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 94, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (96, 'Dimas Fani Putra Maulana', '105010039', 'dimasfaniputramaulana@bytehome.id', '24-11-01', 5, 'Jl. Gunung Batur Kademangan', '6289679369426', 'Aktif', 0, '', '', 1732240463, 'PPPOE', 'jlgunungbatur_dimas', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 94, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (97, 'Hayatun Nufus', '105010040', 'hayatunnufus@bytehome.id', '24-11-01', 5, 'Jl. Gunung Batur Kademangan', '6282313887723', 'Non-Aktif', 0, '', '', 1732240696, 'PPPOE', 'jlgunungbatur_hayatun', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 94, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (98, 'Icha Fauziah Wulandari', '105010041', 'ichafauziahwulandari@bytehome.id', '24-11-01', 5, 'Perumahan Kopian Gg Griya', '6281336998159', 'Aktif', 0, '', '', 1732240856, 'PPPOE', 'kopianbarat_icha', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 83, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (99, 'Erik Adi Putra', '105020058', 'erikAdiputra@bytehome.id', '24-11-07', 5, 'Jl. Raya Panglima Sudirman Kebonsari kulon', '6287844325230', 'Non-Aktif', 0, '', '', 1732949103, 'PPPOE', 'jlpangsud_erik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 10Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 90, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (100, 'Anik Purwati', '105020059', 'anikpurwati@bytehome.id', '24-11-21', 5, 'Jl. Raya Panglima Sudirman Kebonsari kulon', '6282334819647', 'Aktif', 0, '', '', 1732949919, 'PPPOE', 'jlpangsud_anikpurwati', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 5Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 95, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (101, 'Satrio Dirgantara', '105020060', 'satriodirgantara@bytehome.id', '24-12-01', 5, 'Jl. Raya Panglima Sudirman Kebonsari kulon', '628970696822', 'Aktif', 0, '', '', 1735286807, 'PPPOE', 'jlpangsud_satrio', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 90, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (102, 'Choirul Jannatulah Akbar', '105020061', 'choiruljannatulakbar@bytehome.id', '24-12-01', 5, '                                        Jl. Slamet riyadi, Kanigaran Grand Hilton                                    ', '6283838263364', 'Aktif', 0, '', '', 1735288723, 'PPPOE', 'grandhilton_choirul', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 39, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (103, 'Dedy Purnomo', '105020062', 'dedypurnomo@bytehome.id', '24-12-01', 5, 'Jl. Walikota Gatot Ds. Kanigaran (Grand Hilton)', '6281333101931', 'Aktif', 0, '', '', 1735288860, 'PPPOE', 'grandhilton_dedy', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 39, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (104, 'M. Ainus Syifak', '105020063', 'ainussyifak@bytehome.id', '24-12-01', 5, 'Jl. Dr. Sutomo Gg Bunga No. 4 Kanigaran (Jl. Ciliwung)', '62895622347297', 'Aktif', 0, '', '', 1735347827, 'PPPOE', 'jlciliwung_ainus', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 85, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (105, 'Misyono', '105010042', 'misyono@bytehome.id', '24-12-01', 5, 'Perumahan Diva Dava Curahgrinting', '6285257727732', 'Aktif', 0, '', '', 1735350822, 'PPPOE', 'perumcurahgrinting_misyono', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 115000, '', 0, '', 0, 3, 35, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (106, 'Sholehuddin', '105010043', 'sholehuddin@bytehome.id', '24-12-01', 5, 'Perumahan Diva Dava Curahgrinting', '6282338862485', 'Aktif', 0, '', '', 1735351333, 'PPPOE', 'perumcurahgrinting_sholehudin', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 115000, '', 0, '', 0, 3, 35, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (107, 'Surya Adji Febri', '105010044', 'suryaadjifebri@bytehome.id', '24-12-01', 5, 'Jl. Argopuro Gg 10 No. 4 Ketapang (Perumahan Kopian Barat)', '6285230191142', 'Aktif', 0, '', '', 1735352132, 'PPPOE', 'kopian_surya', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 115000, '', 0, '', 0, 3, 83, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (108, 'Agus Setiawan', '105020064', 'agussetiawan2@bytehome.id', '24-12-01', 5, 'Jl. Kyai Jogo Ds. Jrebeng Kidul', '6285212384574', 'Non-Aktif', 0, '', '', 1735352282, 'PPPOE', 'jrebengkidul_agus', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 115000, '', 0, '', 0, 4, 70, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (109, 'Moh. Kadir', '105020065', 'kadir@bytehome.id', '24-12-01', 5, 'Jl. Kh. Ahmad Dahlan No 131 Ds. Kebonsari Kulon', '6282144939833', 'Non-Aktif', 0, '', '', 1735352701, 'PPPOE', 'kebonsari_kadir', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 40, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (110, 'Hosniyah', '105020066', 'hosniyah@bytehome.id', '24-12-01', 5, 'Jl.Achmad Dahlan II Ds. Kebonsari Wetan', '6281225435560', 'Aktif', 0, '', '', 1735353395, 'PPPOE', 'kebonsari_hosniyah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 115000, '', 0, '', 0, 4, 41, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (111, 'Rival Indraharja', '105020067', 'rivalindraharja@bytehome.id', '24-12-01', 5, 'Jl. Merapi Gg At Taqwa No 18 Ds.Triwung Lor (Grand Hilton)', '6282331649154', 'Aktif', 0, '', '', 1735354025, 'PPPOE', 'grandhilton_rival', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 20Mbps', 1, 0, 1, 0, 0, 135000, '', 0, '', 0, 4, 48, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (112, 'Ameliatus Sa\'diyah', '105020068', 'ameliatussdiyah@bytehome.id', '24-12-01', 5, 'Jl. Sunan Ampel Ds. Jrebeng Lor', '6289524801137', 'Aktif', 0, '', '', 1735354822, 'PPPOE', 'jlsunanampel_ameliyatus', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 115000, '', 0, '', 0, 4, 40, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (113, 'Destriana Rohmawati', '105020069', 'destrianarohmawati@bytehome.id', '24-12-01', 5, 'Jl. Kh. Ahmad Dahlan No 131 Ds. Kebonsari Kulon', '6289529461541', 'Non-Aktif', 0, '', '', 1735355792, 'PPPOE', 'kebonsari_destriana', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 115000, '', 0, '', 0, 4, 40, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (114, 'Heri Supriyanto', '105010045', 'herisupriyanto@bytehome.id', '24-12-01', 5, 'jl. Semeru Dsn. Subur Ds. Triwung Kidul', '6285349360827', 'Aktif', 0, '', '', 1735356325, 'PPPOE', 'jlsemeru_heri', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 20, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (115, 'Yohanes Freddy Malo', '105020070', 'yohanesfreddymalo@bytehome.id', '24-12-01', 5, 'Perumahan Jl. Ciliwung', '6285755838193', 'Aktif', 0, '', '', 1735356703, 'PPPOE', 'jlciliwung_yohanes', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 1, 205000, '', 0, '', 0, 4, 97, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (116, 'Hartatik', '105020071', 'hartatik@bytehome.id', '24-12-11', 5, 'Jl. Kali Ciliwung Perum Griya Ciliwung Jrebeng Kulon', '6281235936218', 'Non-Aktif', 0, '', '', 1735635765, 'PPPOE', 'stadionbanyuangga_hartatik', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 98, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (117, 'Tri Wahyuni', '105010046', 'triwahyuni2@bytehome.id', '24-12-11', 5, 'Jl. Cempaka Sukabumi Mayangan', '6283867952191', 'Non-Aktif', 0, '', '', 1735635943, 'PPPOE', 'jlncempaka_triwahyuni', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 98, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (118, 'M. Miftahul Huda', '105020072', 'miftahulhuda@bytehome.id', '24-12-20', 5, 'Jl. Sunan Ampel Ds. Jrebeng Lor', '6285608951469', 'Aktif', 0, '', '', 1735637012, 'PPPOE', 'jrebenglor_miftahul', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 20Mbps', 1, 0, 1, 0, 0, 135000, '', 0, '', 0, 4, 97, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (119, 'Harun Al Rasyid', '105020073', 'harunalrasyid@bytehome.id', '24-12-27', 5, 'Jl. Dr. Moh Saleh 5-D Ds. Tisnonegaran  (Perum Bogowonto)', '62811301472', 'Aktif', 0, '', '', 1735637392, 'PPPOE', 'perumbogowonto_harun', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 99, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (120, 'Jumaidi', '105010047', 'jumaidi@bytehome.id', '24-12-27', 5, 'Jl. Soekarno Hatta Ketapang', '6289507010406', 'Aktif', 0, '', '', 1738030505, 'PPPOE', 'jlsoekarnohatta_jumaidi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 100, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (121, 'Mahfud Abdullah', '105010048', 'mahfudabdullah@bytehome.id', '24-12-27', 5, 'Kantor NU Jalan Semeru', '81331410016', 'Aktif', 0, '', '', 1738030716, 'PPPOE', 'jlsemeru_mahfud', 0, 5, 1, 'KTP', 17, 0, 62, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 101, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (122, 'Drs, Abdul Fatah BC HK', '105010049', 'drsabdulfatahbchk@bytehome.id', '24-12-28', 5, 'Jl. Damai Gg I no. 10 Ds. Ketapang', '6285336937343', 'Aktif', 0, '', '', 1738030958, 'PPPOE', 'jldamai_abdulfatah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 3, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (123, 'Devi Kustianingsih', '105020074', 'devikustianingsih@bytehome.id', '24-12-28', 5, 'Jl. MT Mutaqin Jrebeng Lor', '6281334734811', 'Aktif', 0, '', '', 1738031167, 'PPPOE', 'jalanmt_devi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 1, 205000, '', 0, '', 0, 4, 78, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (124, 'Luksiana Indah', '105020075', 'luksianaindah@bytehome.id', '24-12-31', 5, 'Perum Bogowonto', '6285940850144', 'Non-Aktif', 0, '', '', 1738031651, 'PPPOE', 'perumbogowonto_luksiana', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 99, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (125, 'Bambang Budi Hartono', '105020076', 'bambangbudihartono@bytehome.id', '25-01-02', 5, 'Jl. Sunan Bonang Gg Mangga Jrebeng Wetan', '628125242174', 'Non-Aktif', 0, '', '', 1738031815, 'PPPOE', 'jlsunanbonang_bambang', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 102, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (126, 'Wiwik Wijayanti', '105020077', 'wiwikwijayanti@bytehome.id', '25-01-02', 5, 'Jl. Cangkring II/08 B Ds. Kanigaran', '6285746902549', 'Aktif', 0, '', '', 1738031996, 'PPPOE', 'cangkring_wiwik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 18, 12, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (127, 'Tutik Handayani', '105020078', 'tutikhandayani@bytehome.id', '25-01-03', 5, 'Jl. Priksan Gg Kelinci Ds. Kebonsari kulon (Jl. A. Dahlan)', '6285204991868', 'Aktif', 0, '', '', 1738032161, 'PPPOE', 'jlahmaddahlan_tutik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 40, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (128, 'Robbi Ismono', '105020079', 'robbiismono@bytehome.id', '25-01-03', 5, 'Perum Mutiara Bogowonto Ds. Kareng lor', '6285231062344', 'Aktif', 0, '', '', 1738032321, 'PPPOE', 'perumbogowonto_robbi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 99, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (129, 'Moch. Ibrahim', '105020080', 'mochibrahim@bytehome.id', '25-01-03', 5, 'Jl. Raya Panglima Sudirman Gg VI A No 108 Ds. Kebonsari Kulon', '6289518780061', 'Non-Aktif', 0, '', '', 1738032786, 'PPPOE', 'jlpangsud_ibrahim', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (130, 'Rohman', '105020081', 'rohman3@bytehome.id', '25-01-04', 5, 'Perum Mutiara Bogowonto Ds. Kareng lor', '6285338301966', 'Aktif', 0, '', '', 1738032992, 'PPPOE', 'perumbogowonto_rohman', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 99, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (131, 'David Rahmad Mardhika', '105020082', 'davidrahmadmardhika@bytehome.id', '25-01-04', 5, 'Lingkungan Esan Ds. Jrebeng Kidul', '6282258247237', 'Aktif', 0, '', '', 1738033564, 'PPPOE', 'jrebengkidul_david', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 70, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (132, 'Hafid Muhajir', '105020083', 'hafidmuhajir@bytehome.id', '25-01-06', 5, 'Jl. Sunan Ampel Ds. Jrebeng Lor', '6281334563030', 'Non-Aktif', 0, '', '', 1738034057, 'PPPOE', 'jlsunanampel_havid', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 78, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (133, 'M. Ainul Yaqin', '105010050', 'mainulyaqin@bytehome.id', '25-01-07', 5, 'Jl. Argopuro 10a', '6282257211310', 'Aktif', 0, '', '', 1738034370, 'PPPOE', 'jlargopuro_ainul', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 83, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (134, 'Abdul Syukur', '105010051', 'abdulsyukur@bytehome.id', '25-01-07', 5, 'Perum Permata Regency', '6285233362921', 'Aktif', 0, '', '', 1738034571, 'PPPOE', 'perumpermata_syukur', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 103, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (135, 'Fera Andini', '105020084', 'feraandini@bytehome.id', '25-01-07', 5, 'Jl. Cangkring No 122 Ds. Kanigaran', '6282172245944', 'Aktif', 0, '', '', 1738034761, 'PPPOE', 'jlcangkring_fera', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 104, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (136, 'Emy Sulamsih', '105020085', 'emysulamsih@bytehome.id', '25-01-07', 5, 'Jl. Cangkring 105 Ds. Kanigaran', '6282330232361', 'Aktif', 0, '', '', 1738035075, 'PPPOE', 'jlcangkring_emy', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 18, 13, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (137, 'M. Afif Amrulloh', '105020086', 'mafifamrulloh@bytehome.id', '25-01-08', 5, 'Jl. Priksan Gg Kelinci Ds. Kebonsari kulon', '628885157072', 'Aktif', 0, '', '', 1738035619, 'PPPOE', 'jlpriksan_afif', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 105, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (138, 'Andri Purwari', '105020087', 'andripurwari@bytehome.id', '25-01-09', 5, 'Jl. Ikan Tongkol Ds. Mayangan', '6285235568619', 'Aktif', 0, '', '', 1738036716, 'PPPOE', 'tongkol_andri', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 67, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (139, 'Nor Hasan', '105020088', 'norhasan@bytehome.id', '25-01-11', 5, 'Jl. Sadewa Ds. Kanigaran', '6287856287367', 'Aktif', 0, '', '', 1738037408, 'PPPOE', 'jlsadewa_norhasan', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 24, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (140, 'Hermin', '105020089', 'hermin1@bytehome.id', '25-01-13', 5, 'Jl. Ikan Tongkol Ds. Mayangan', '6282245350149', 'Aktif', 0, '', '', 1738037732, 'PPPOE', 'tongkol_hermin', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 67, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (141, 'Buadi', '105020090', 'buadi1@bytehome.id', '25-01-16', 5, 'Jl. KH. Abdul Azis No 14 Kebonsari Kulon', '6285331222930', 'Non-Aktif', 0, '', '', 1738038827, 'PPPOE', 'kebonsarikulon_buadi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 88, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (142, 'Dita Kusuma Dewi', '105020091', 'ditakusumadewi@bytehome.id', '25-01-18', 5, 'Jl. Kh Ahmad Dahlan Kebonsari Kulon', '6283893327175', 'Aktif', 0, '', '', 1738039486, 'PPPOE', 'kebonsari_dita', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 41, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (143, 'Zuraida Nailul Ula', '105020092', 'zuraidanailulula@bytehome.id', '25-01-24', 5, 'Jl. Ikan Kerapung 6 No. 16 Ds. Mangunharjo', '6281615172761', 'Aktif', 0, '', '', 1738045381, 'PPPOE', 'kebunsarikulon_zuraida', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 29, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (144, 'Wahyu Andika Darma', '105010052', 'wahyuandikadarma@bytehome.id', '25-01-24', 5, 'Jl. Asahan Ds. Curahgrinting ', '6281236194326', 'Aktif', 0, '', '', 1738045882, 'PPPOE', 'jlasahan_wahyu', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 106, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (145, 'M. Saiful Bahri', '105020093', 'saifulbahri@bytehome.id', '25-01-09', 5, 'Alfamidi Super Probolinggo', '6282245543901', 'Aktif', 0, '', '', 1738046567, 'PPPOE', 'saiful_alfamidi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 63, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (146, 'Siti Maulidiyatul Karomah', '105020094', 'sitimaulidiyatulkaromah@bytehome.id', '25-01-09', 5, 'Jl. Sunan Ampel Ds. Jrebeng Lor', '6282230550563', 'Aktif', 0, '', '', 1738047158, 'PPPOE', 'jlsunanampel_karomah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 78, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (147, 'Moch Natu', '105020095', 'mochnatu@bytehome.id', '25-01-10', 5, 'Jl. Cangkring Gg II Kanigaran', '6282334209008', 'Aktif', 0, '', '', 1738047313, 'PPPOE', 'jlcangkring_natu', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 104, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (148, 'Marsi', '105020096', 'Marsi@bytehome.id', '25-01-16', 5, 'Jl. Sunan Ampel Ds. Jrebeng Lor', '6282266913355', 'Aktif', 0, '', '', 1738047403, 'PPPOE', 'jrebenglor_marsi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 70, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (149, 'Shendy Pristi Wahyono', '105010053', 'shendypristiwahyono@bytehome.id', '25-01-16', 5, 'Jl. Wijaya Kusuma Sukabumi Mayangan', '6285785455131', 'Aktif', 0, '', '', 1738047898, 'PPPOE', 'jlwijayakusuma_shendy', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 43, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (150, 'Jumaati', '105020097', 'jumiati3@bytehome.id', '25-01-14', 5, 'Jl. Cangkring Kanigaran', '6281249023201', 'Aktif', 0, '', '', 1738047994, 'PPPOE', 'jlcangkring_jumaati', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 104, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (151, 'Lilik Sriliati', '105010054', 'liliksriliati@bytehome.id', '25-01-13', 5, 'Jl. Cisadane Kademangan', '089636570309', 'Aktif', 0, '', '', 1738048089, 'PPPOE', 'jlcisadane_lilik', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 33, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (152, 'Lia Mahendra', '105020098', 'liamahendra@bytehome.id', '25-01-20', 5, 'Jl. Angguran Raya, Kebonsari Kulon', '6281331618336', 'Aktif', 0, '', '', 1738048231, 'PPPOE', 'kebonsarikulon_lia', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 41, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (153, 'Mahfud Farizaal', '105010055', 'mahfudfarizaal@bytehome.id', '25-01-24', 5, 'Jl. Semeru Kademangan', '6285258880170', 'Non-Aktif', 0, '', '', 1738048628, 'PPPOE', 'jlnsemeru_farizaal', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 25, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (154, 'Heriyanto', '105010056', 'heriyanto3@bytehome.id', '25-01-24', 5, 'Jl. Semeru Kademangan', '6285231992752', 'Aktif', 0, '', '', 1738048966, 'PPPOE', 'jlsemeru_heriyanto', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 20, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (155, 'Aven Fauzi', '105010057', 'avenfauzi@bytehome.id', '25-01-24', 5, 'Jl. Semeru Kademangan', '6287893041661', 'Aktif', 0, '', '', 1738049330, 'PPPOE', 'jlsemeru_avenfauzi', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 19, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (156, 'Muhammad Ja\'far', '105010058', 'muhammadjafar@bytehome.id', '25-01-21', 5, 'Jl. Flamboyan 1/02  Ds. Pilang Kademangan', '6282334209802', 'Aktif', 0, '', '', 1738050149, 'PPPOE', 'jlflamboyan_jafar', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 107, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (157, 'M. Mahrus Alie', '105010059', 'mahrusalie@bytehome.id', '25-01-10', 5, 'Dusun Melati Ds. Pesisir', '6287889080559', 'Aktif', 0, '', '', 1738050253, 'PPPOE', 'pesisir_ali', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 108, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (158, 'Faizal Ibnu Almadani', '105010060', 'faizalIibnualmadani@bytehome.id', '25-01-10', 5, 'Jl. Langsep Dusun Gerdu Ds. Pakistaji (Flamboyan)', '6281515626176', 'Aktif', 0, '', '', 1738050394, 'PPPOE', 'jlflamboyan_faizal', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 107, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (159, 'Ita Wadi Lestari', '105020099', 'itawadilestari@bytehome.id', '25-01-21', 5, 'Jl. Musi Ds. Jrebeng Kulon', '6282143568102', 'Aktif', 0, '', '', 1738050490, 'PPPOE', 'jlmusi_itawadi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 109, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (160, 'Nugroho Ardwi', '105020100', 'nugrohoardwi@bytehome.id', '25-01-14', 5, 'Perum Asabri D-144 Ds. Kanigaran', '6282331504850', 'Aktif', 0, '', '', 1738050605, 'PPPOE', 'perumasabri_nugroho', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 110, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (161, 'Halimatus Sa\'diyah', '105020101', 'halimatussadiyah@bytehome.id', '25-01-21', 5, 'Jl. Ikan Kerapu Mayangan', '6289522687159', 'Non-Aktif', 0, '', '', 1738050729, 'PPPOE', 'jlikanbelanak_halimatus', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 195, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (162, 'Hari Rachmad', '105020102', 'harifrachmad@bytehome.id', '25-01-16', 5, 'Randu Pangger', '6289681948735', 'Aktif', 0, '', '', 1738051115, 'PPPOE', 'randupangger_hari', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 112, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (163, 'Hendra Arif Wibowo', '105010061', 'hendraarifwibowo@bytehome.id', '25-01-16', 5, 'Jl. Merapi Gg III Perum Griya Harapan Indah B 27 Triwung Lor', '6285203897955', 'Aktif', 0, '', '', 1738051324, 'PPPOE', 'jlmerapi_hendra', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 100Mbps', 1, 0, 1, 0, 1, 250000, '', 0, '', 0, 3, 113, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (164, 'Angger Subekti', '105020103', 'anggarsubekti@bytehome.id', '25-01-16', 5, 'Jl. Melon Ds. Kedopok', '628970002769', 'Aktif', 0, '', '', 1738051699, 'PPPOE', 'jlkedopok_anggar', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 115, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (165, 'Dadang Kosaeni', '105020104', 'dadangkosaeni@bytehome.id', '25-01-22', 5, 'Jl. Kapten Patimura Blok D Ds. Mangunharjo', '6282302015357', 'Aktif', 0, '', '', 1738051865, 'PPPOE', 'jlpatimura_dadang', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 114, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (166, 'Syah Dhani Rizky Ramadhani', '105020105', 'syahdhanirizkyramadhani@bytehome.id', '25-01-22', 5, 'Jl. Kapten Patimura Blok D Ds. Mangunharjo', '6289515361088', 'Aktif', 0, '', '', 1738051999, 'PPPOE', 'jlpatimura_dhani', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 114, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (167, 'Wahyu Illahi', '105020106', 'wahyuillahi@bytehome.id', '25-02-06', 5, 'Jl. Ikan Paus Mayangan (Perum Grandk Hilton)', '6282335526094', 'Aktif', 0, '', '', 1738726225, 'PPPOE', 'grandhilton_wahyu', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 39, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (168, 'Sugeng', '105020107', 'Sugeng@bytehome.id', '25-01-15', 5, 'Jl. Mayjenharyono IV / 15 B Ds. Mangunharjo (Perum Grend Hilton)', '6282231277733', 'Aktif', 0, '', '', 1738726611, 'PPPOE', 'grandhilton_sugeng', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 39, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (169, 'Agustina', '105020108', 'Agustina@bytehome.id', '25-01-22', 5, 'Jl. Ikan Cumi Cumi Mayangan', '6285231128125', 'Aktif', 0, '', '', 1738726893, 'PPPOE', 'jlcumicumi_agustina', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 65, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (170, 'Zakaria Fitranda', '105020109', 'zakariafitranda@bytehome.id', '25-01-14', 5, 'Jl. Slamet Riyadi Gg. Larasati Kanigaran', '6282331218294', 'Aktif', 0, '', '', 1738728199, 'PPPOE', 'jlslametriyadi_zakaria', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 0, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 116, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (171, 'Misnanto', '105010062', 'misnanto@bytehome.id', '25-02-27', 5, 'Jl. Merbabu, Kec. Kademangan', '6289524572662', 'Aktif', 0, '', '', 1740384483, 'PPPOE', 'merbabu_misnanto', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 3, 32, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (172, 'Rivaldo Ferdi Firmansyah', '105010063', 'rivaldoferdifirmansyah@bytehome.id', '25-01-27', 5, 'Jl. Merbabu, Kec. Kademangan', '6288989076351', 'Aktif', 0, '', '', 1740385195, 'PPPOE', 'merbabu_rivaldo', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 3, 32, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (173, 'Mohammad Arifin', '105010064', 'mohammadarifin@bytehome.id', '25-01-27', 5, 'Jl. Gunung Batur Kademangan', '6282142103852', 'Aktif', 0, '', '', 1740455775, 'PPPOE', 'gunungbatur_arifin', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 72, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (174, 'Deby Amelia', '105020110', 'debyamelia@bytehome.id', '25-01-28', 5, 'Jl. Imam Bonjol', '6285855144682', 'Aktif', 0, '', '', 1740456005, 'PPPOE', 'jlimambonjol_deby', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 55, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (175, 'Nur Arif Yulistian', '105020111', 'nurarifyulistian@bythome.id', '25-01-28', 5, 'Jl. Ikan Tongkol Ds. Mayangan', '082335732267', 'Aktif', 0, '', '', 1740456332, 'PPPOE', 'jkikantongkol_yulistian', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 67, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (176, 'M. Rizki Akbar', '105020112', 'mrizkyakbar@bytehome.id', '25-01-28', 5, 'Jl. Ikan Tongkol Ds. Mayangan', '6289629944587', 'Aktif', 0, '', '', 1740456484, 'PPPOE', 'jlikantongkol_akbar', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 67, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (177, 'Suyono', '105010065', 'suyono@bytehome.id', '25-01-28', 5, 'Jl. Cisadane Kademangan', '6285791483470', 'Aktif', 0, '', '', 1740456616, 'PPPOE', 'jlcisadane_suyono', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 33, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (178, 'Imam Wahyudi', '105020113', 'imamwahyudi@bytehome.id', '25-01-29', 5, 'Jl. Letjen Suprapto Ds. Mangunharjo', '6285235384509', 'Aktif', 0, '', '', 1740481215, 'PPPOE', 'jlletjensuprapto_imam', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 55, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (179, 'Selamet Hariyanto', '105020114', 'slamethariyanto@bytehome.id', '25-01-30', 5, 'Jl. Ikan Kakap Ds. Mayangan', '6285706722127', 'Non-Aktif', 0, '', '', 1740537287, 'PPPOE', 'jlikankakap_slamethariyanto', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 63, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (180, 'Putri Budi Lestari', '105020115', 'putribudi@bytehome.id', '25-01-31', 5, 'Jl. Mayjen Hartyono Gg 7 Ds. Jati Mayangan', '6282236401887', 'Aktif', 0, '', '', 1740539937, 'PPPOE', 'jlmayjen_putri', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 96, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (181, 'Drs sugeng koesdriyanto', '105010066', 'sugengkoesdriyanto@bytehome.id', '25-02-01', 5, 'Jl Damai rumah bali', '6285645068742', 'Aktif', 0, '', '', 1740541184, 'PPPOE', 'jldamai_drssugeng', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 3, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (182, 'Zubaidah', '105010067', 'zubaidahh@bytehome.id', '25-02-01', 5, 'Jl. Asahan curahgrinting', '6285784904606', 'Non-Aktif', 0, '', '', 1740541498, 'PPPOE', 'curahgrinting_subaidah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 36, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (183, 'Maskur', '105010068', 'maskur@bytehome.id', '25-02-01', 5, 'Perum Diva ', '6285258843171', 'Aktif', 0, '', '', 1740541981, 'PPPOE', 'perumdiva_maskur', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 0, 0, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (184, 'Agus Supriantoni', '105020116', 'agussupriantoni@bytehome.id', '25-02-01', 5, 'Jl. Cangkring gg 2 no 94', '6282332219346', 'Non-Aktif', 0, '', '', 1740542619, 'PPPOE', 'jlcangkring_supriantoni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 104, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (185, 'Sofia Alawiyah', '105020117', 'sofiaalawiyah@bytehome.id', '25-02-05', 5, 'Jl. Ikan Kerapu', '6285933864521', 'Aktif', 0, '', '', 1740542803, 'PPPOE', 'jlikankerapu_sofia', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 111, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (186, 'Haffit Muzzani', '105020118', 'haffitmuzzani@bytehome.id', '25-02-05', 5, 'Jl. Abdul Aziz Curahgrinting ', '6282335738396', 'Non-Aktif', 0, '', '', 1740543046, 'PPPOE', 'curahgrinting_muzzani', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 36, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (187, 'Heni rizky amilia', '105020119', 'henirizky@bytehome.id', '25-02-06', 5, 'Jl. Cangkring', '6285738627738', 'Non-Aktif', 0, '', '', 1740543565, 'PPPOE', 'jlcangkring_heni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 104, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (188, 'Eko Saputra', '105010069', 'ekosaputro@bytehome.id', '25-02-07', 5, 'JL. Asahan ', '6282230994014', 'Aktif', 0, '', '', 1740544705, 'PPPOE', 'jlasahan_ekosaputro', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 101, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (189, 'Basriyah', '105010070', 'basriyah@bytehome.id', '25-02-10', 5, 'Dsn. Darungan, Mentor, Sumberasih', '6282301865415', 'Aktif', 0, '', '', 1740544895, 'PPPOE', 'darungan_basriyah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 117, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (190, 'Nizar', '105020120', 'nizar@bytehome.id', '25-02-10', 5, 'Jl. Ir H juanda ', '6285155217412', 'Aktif', 0, '', '', 1740545105, 'PPPOE', 'kebonsarikulon_nizar', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 88, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (191, 'Deka Nofikandari', '105020121', 'dekanofikandari@bytehome.id', '25-02-11', 5, 'Jl. Priksan gg Bengkel No 8', '6282330627743', 'Aktif', 0, '', '', 1740545438, 'PPPOE', 'jlpangsud_deka', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 10, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (192, 'Dwi Ratna Safitri', '105010071', 'dwiratnasafitri@bytehome.id', '25-02-11', 5, 'Perum Nafira Triwungkidul B11', '6282336887220', 'Aktif', 0, '', '', 1740545651, 'PPPOE', 'perumnafira_ratna', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 113, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (193, 'Farid Widiyatmoko', '105020122', 'Faridwidiyatmoko2@bytehome.id', '25-02-13', 5, 'KODIM 0820', '6282233430123', 'Aktif', 0, '', '', 1740547292, 'PPPOE', 'kodim0820_farid', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 66, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (194, 'Dwi Jayanti', '105010072', 'dwijayanti@bytehome.id', '25-02-13', 5, 'Rusunawa Semeru ', '6282334115159', 'Aktif', 0, '', '', 1740548202, 'PPPOE', 'rusunawa_dwijayanti', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 20, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (195, 'Samsul Arifin', '105020123', 'samsularifinproling@bytehome.id', '25-02-17', 5, 'Jl. Sunan Klaijogo GG.3, Jati, Mayangan', '6285330055572', 'Aktif', 0, '', '', 1740549376, 'PPPOE', 'jlsunankalijogo_arifin', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 95, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (196, 'Ulfa Maisaroh', '105020124', 'ulfamaisaroh@bytehome.id', '25-02-17', 5, 'Jl Slamet Riyadi, Kanigaran', '6281216624848', 'Aktif', 0, '', '', 1740549519, 'PPPOE', 'jlslametriyadi_ulfa', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 52, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (197, 'Fuad', '105020125', 'fuad@bytehome.id', '25-02-18', 5, 'Jl. Panglima Sudirman', '6282339662833', 'Non-Aktif', 0, '', '', 1740549852, 'PPPOE', 'jlpangsud_fuad', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 90, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (198, 'SULIONO', '105010073', 'suliono@bytehome.id', '25-02-18', 5, 'JL.Bengawan Solo Gg.merpati', '6282295738180', 'Aktif', 0, '', '', 1740550064, 'PPPOE', 'jlbengawansolo_suliono', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 3, 25, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (199, 'Mariya', '105010074', 'mariya@bytehome.id', '25-02-21', 5, 'Dsn. Melati Pesisir Sumberasih', '6282330535954', 'Aktif', 0, '', '', 1740550318, 'PPPOE', 'pesisir_maria', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 3, 108, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (200, 'Juwarni', '105020126', 'juwarni@bytehome.id', '25-02-21', 5, 'JL Ikan Tongkol, Mayangan, Kota Prob', '6282229797933', 'Aktif', 0, '', '', 1740553532, 'PPPOE', 'jlikantongkol_juwarni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 61, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (201, 'Hasbul Halili', '105020127', 'hasbulhalili@bytehome.id', '25-02-22', 5, 'KODIM 0820', '6282128576679', 'Aktif', 0, '', '', 1740553831, 'PPPOE', 'kodim0820_hasbul', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 66, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (202, 'Tuslimah', '105010075', 'tuslimah@bytehome.id', '25-01-29', 5, 'Jl. Blok Kolor Kademangan', '6282335737697', 'Aktif', 0, '', '', 1740618462, 'PPPOE', 'jlblokkolor_tuslimah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 118, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (203, 'Safira', '105020128', 'safira@bytehome.id', '25-01-30', 5, 'Graha Muliya', '6285179905900', 'Non-Aktif', 0, '', '', 1740618590, 'PPPOE', 'grahamuliya_safira', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 119, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (204, 'Emy Hendrawati', '105010076', 'emyhendrawati@bytehome.id', '25-01-31', 5, 'Jl. Sunan Kali Jaga', '6285238513479', 'Aktif', 0, '', '', 1740618719, 'PPPOE', 'jlsunankalijaga_emy', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 120, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (205, 'Budi Santoso', '105010077', 'budisantoso@bytehome.id', '25-01-31', 5, 'Jl. Sunan Kali Jaga', '6285258842184', 'Aktif', 0, '', '', 1740619562, 'PPPOE', 'jlsunankalijogo_budi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 120, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (206, 'Silvia Dinda Arista', '105010078', 'silviadinda@bytehome.id', '25-01-31', 5, 'Dsn. Makmur Triwung Kidul', '6285373007100', 'Non-Aktif', 0, '', '', 1740619707, 'PPPOE', 'triwungkidul_silvia', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 121, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (207, 'Markus Sudrajat', '105010079', 'markussudrajat@bytehome.id', '25-02-01', 5, 'Jl Cempaka', '6285233919904', 'Aktif', 0, '', '', 1740625987, 'PPPOE', 'jlcempaka_markus', 0, 6, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 122, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (208, 'Samsul Hidayat', '105020129', 'samsulhidayat@bytehome.id', '25-02-04', 5, 'Jl. Priksan gg residence no a6', '6285257230170', 'Aktif', 0, '', '', 1740631484, 'PPPOE', 'residence_samsul', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 123, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (209, 'Andi Riyanto', '105020130', 'andiriyanto@bytehome.id', '25-02-05', 5, 'Jl. Anggrek mayangan', '6285233043691', 'Aktif', 0, '', '', 1740631688, 'PPPOE', 'jlanggrek_andi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 124, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (210, 'Siti Nurfadillah', '105020131', 'sitinurfadillah@bytehome.id', '25-02-06', 5, 'Jl. ikan belanak gg kav 1 no 5', '6282230976980', 'Aktif', 0, '', '', 1740631835, 'PPPOE', 'jlikanbelanak_nurfadhillah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 4, 125, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (211, 'Syaiful Arif', '105020132', 'syaifularif@bytehome.id', '25-02-08', 5, 'Jl. Kerapu gg 1 no 11', '6281336790809', 'Aktif', 0, '', '', 1740632312, 'PPPOE', 'jlikankerapu_syaiful', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 126, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (212, 'Mochammad Wildan', '105010080', 'mochammadwildan@bytehome.id', '25-02-10', 5, 'Dsn. Pacar Sumberasih ', '083142343999', 'Aktif', 0, '', '', 1740633017, 'PPPOE', 'dusunpacar_wildan', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 128, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (213, 'Endrawati', '105010081', 'endrawati@bytehome.id', '25-02-11', 5, 'Dsn. Tanah Merah Sumberasih', '6285134435948', 'Aktif', 0, '', '', 1740633241, 'PPPOE', 'tanahmerah_endrawati', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 128, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (214, 'IDRIS', '105020133', 'idris2@bytehome.id', '25-02-11', 5, 'JL. KH Abdurrahman Wahid ', '6282330638548', 'Non-Aktif', 0, '', '', 1740633484, 'PPPOE', 'khabdurrahman_idris', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 129, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (215, 'Abdul Kamil', '105010082', 'abdulkamil@bytehome.id', '25-02-12', 5, 'Dsn. Makmur Triwung Kidul', '6285258754152', 'Aktif', 0, '', '', 1740633952, 'PPPOE', 'triwungkidul_abdulkamil', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 121, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (216, 'Dian Agus Kurniawan', '105020134', 'dianaguskurniawan@bytehome.id', '25-02-12', 5, 'Cokroaminotp', '6287755755526', 'Aktif', 0, '', '', 1740634825, 'PPPOE', 'cokroaminoto_dianagus', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 130, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (217, 'Karunia Aldian', '105010083', 'karuniaaldian@bytehome.id', '25-02-12', 5, 'Jl. Soekarno-Hatta No.6 Sukabumi, ', '6281252515141', 'Aktif', 0, '', '', 1740635275, 'PPPOE', 'jlsoekarnohatta_karunia', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 131, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (218, 'Ira wijayanti', '105010084', 'irawijayanti@bytehome.id', '25-02-13', 5, 'Jl. rinjani Triwung kidul', '6283833654115', 'Aktif', 0, '', '', 1740635416, 'PPPOE', 'triwungkidul_Irawijayanti', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 56, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (219, 'Della yunita anggraini', '105010085', 'Dellayunita@bytehome.id', '25-02-14', 5, 'Dsn. Tanah Merah Sumberasih (lembah kembar)', '6282264883649', 'Aktif', 0, '', '', 1740635943, 'PPPOE', 'sumberasih_della', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 128, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (220, 'Sri Utari', '105010086', 'sriutari@bytehome.id', '25-02-14', 5, 'Dsn. Tanah Merah Sumberasih (lembah kembar)', '628563466992', 'Aktif', 0, '', '', 1740636207, 'PPPOE', 'sumberasih_ sriutari', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 128, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (221, 'Tatik tamara', '105010087', 'tatitamara@bytehome.id', '25-02-14', 5, 'Dsn. Tanah Merah Sumberasih (lembah kembar)', '6285334628956', 'Aktif', 0, '', '', 1740636338, 'PPPOE', 'sumberasih_tatik', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 132, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (222, 'Robiatus Saqinah', '105020135', 'robiatussaqinah@bytehome.id', '25-02-14', 5, 'JL.Sunan Bonang Jrebeng Wetan', '62881036030645', 'Aktif', 0, '', '', 1740636618, 'PPPOE', 'jrebengwetan_robiatus', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 133, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (223, 'Siti Maslamah', '105010088', 'sitimaslamah@bytehome.id', '25-02-15', 5, 'Pilang Kademangan', '85231131436', 'Aktif', 0, '', '', 1740636796, 'PPPOE', 'pilang_maslamah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 134, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (224, 'diaz octavia', '105010089', 'diazoctavia@bytehome.id', '25-02-15', 5, 'Pilang gg sarikoyo', '6281336381711', 'Aktif', 0, '', '', 1740637551, 'PPPOE', 'pilang_diaz', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 0, 0, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (225, 'Syamsul Anam', '105020136', 'syamsulanam@bytehome.id', '25-02-18', 5, 'Jl lingkar utara, mayangan', '6285330847865', 'Aktif', 0, '', '', 1740638182, 'PPPOE', 'jllingkarutara_syamsul', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 136, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (226, 'Tulus Wahyudi Rizki', '105020137', 'tuluswahyudi@bytehome.id', '25-02-18', 5, 'JL.Lingkar utara Probolinggo', '6285171721701', 'Non-Aktif', 0, '', '', 1740640770, 'PPPOE', 'jllingkarutara_tulus', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 136, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (227, 'Anggun Sani Kusuma', '105010090', 'anggunsani@bytehome.id', '25-02-19', 5, 'Lemah kembar, sumberasih', '6282316359428', 'Aktif', 0, '', '', 1740640976, 'PPPOE', 'sumberasih_anggun', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 137, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (228, 'Mulyono', '105010091', 'mulyono@bytehome.id', '25-02-19', 5, 'Lemah kembar, sumberasih', '6281235432380', 'Non-Aktif', 0, '', '', 1740641149, 'PPPOE', 'lemahkembar_mulyono2', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 132, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (229, 'Misrani', '105010092', 'misrani@bytehome.id', '25-02-19', 5, 'Lemah kembar, sumberasih', '6281336220604', 'Aktif', 0, '', '', 1740641317, 'PPPOE', 'lembahkembar_misrani', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 137, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (230, 'Nur Hasanah', '105010093', 'nurhasanah@bytehome.id', '25-02-19', 5, 'Dsn. Krajan Triwungkidul ', '62881036774701', 'Aktif', 0, '', '', 1740641470, 'PPPOE', 'jllemahkembar_nurkhasanah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 138, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (231, 'Ali', '105020138', 'aliproling@bytehome.id', '25-02-19', 5, 'Blok Kolor Kademangan', '6282334659554', 'Aktif', 0, '', '', 1740641585, 'PPPOE', 'blokkolor_ali', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 121, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (232, 'Suwadi', '105020139', 'suwadi@bytehome.id', '25-02-20', 5, 'Jl. MT. Haryono gg. 10 no. 102', '6281358074959', 'Aktif', 0, '', '', 1740641693, 'PPPOE', 'jlmtharyono_suwadi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 139, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (233, 'Tommy Suliasmanto', '105020140', 'tommy@bytehome.id', '25-02-22', 5, 'Jl. Kapten Patimura No.09', '6287759788061', 'Aktif', 0, '', '', 1740642778, 'PPPOE', 'jlpatimura_tommy', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 141, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (234, 'Sam ANugrah Prakasa', '105020141', 'samanugrah@bytehome.id', '25-02-22', 5, 'Jl Kh hasan gg. Anggrek 06 Sukoharjo', '6282334669955', 'Aktif', 0, '', '', 1740643023, 'PPPOE', 'jlkhhhasan_sam', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 142, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (235, 'Nurul Hafisah', '105020142', 'nurulhafisah@bytehome.id', '25-02-25', 5, 'Jl ikan belanak mangunharjo', '6282245149028', 'Non-Aktif', 0, '', '', 1740643165, 'PPPOE', 'jlikanbelanak_hafisah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 125, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (236, 'M Rizky alfian alif', '105020143', 'mrizkyalfian@bytehome.id', '25-02-25', 5, 'Jl. Bengawan Solo', '6285336338424', 'Aktif', 0, '', '', 1740643380, 'PPPOE', 'jlbengawansolo_alfian', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 144, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (237, 'Wahyu Agus Suyanto', '105020144', 'wahyuagus@bytehome.id', '25-02-25', 5, 'Jl KH. Abdul Aziz', '6282333139228', 'Aktif', 0, '', '', 1740643496, 'PPPOE', 'jlkhabdulaziz_wahyuagus', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 88, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (238, 'M. Hanafi Imanuddin', '105020145', 'mhanafiimanuddin@bytehome.id', '25-02-27', 5, 'Jl KH Hasan genggong ', '6289671455563', 'Aktif', 0, '', '', 1740644105, 'PPPOE', 'jlkhhhasan_hanafi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 143, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (239, 'Yuliana Sani Ariska', '105020146', 'yulianasani@bytehome.id', '25-02-26', 5, 'Jl KH Abdul Aziz gg 2', '6282241381410', 'Aktif', 0, '', '', 1740644487, 'PPPOE', 'jlkhabdulaziz_yuliana', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 145, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (240, 'Muhammad Safaat', '105010094', 'safaat2@bytehome.id', '25-02-21', 5, 'Dsn. Makmur Triwung Kidul', '6285134380593', 'Aktif', 0, '', '', 1740721939, 'PPPOE', 'triwungkidul_safaat', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 140, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (241, 'Ahmad Zainul Hafid', '105020147', 'zainulhafid@bytehome.id', '25-01-29', 5, 'Jl. Musi Ds. Jrebeng Kulon', '6288990456486', 'Non-Aktif', 0, '', '', 1740986366, 'PPPOE', 'jlmusi_zainulhafid', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 99, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (242, 'Erda Permata Sari', '105010095', 'erda@bytehome.id', '25-04-07', 5, 'Jl Wijaya Kusuma ', '6289522691578', 'Aktif', 0, '', '', 1746082905, 'PPPOE', 'jlwijayakusuma_erda', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 43, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (243, 'Dewantara Andi Saktian', '105010096', 'dewantara@bytehome.id', '25-02-27', 5, 'JL Merapi Griya Harapan GG II 24 B', '6281249426158', 'Aktif', 0, '', '', 1746098565, 'PPPOE', 'jlmerapi_dewantara', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 113, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (244, 'M. Rizal', '105020148', 'mrizal@bytehome.id', '25-02-27', 5, 'Jl KH Abdul Aziz gg 2 No. 25', '6281246853421', 'Aktif', 0, '', '', 1746098804, 'PPPOE', 'jlkhabdulaziz_mrizal', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 145, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (245, 'Enfri Lee Marten', '105010097', 'enfrilee@bytehome.id', '25-03-03', 5, 'Jl Cempaka', '6281142604858', 'Aktif', 0, '', '', 1746099733, 'PPPOE', 'cempaka_enfrileemartin', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 106, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (246, 'Ayu Handini', '105010098', 'ayuhandini@bytehome.id', '25-03-04', 5, 'Jl Soekarno Hatta', '6281515475669', 'Aktif', 0, '', '', 1746100350, 'PPPOE', 'jlsoekarnohatta_ayuhandini', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 134, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (247, 'Lia Hermawati', '105010099', 'liahermawati@bytehome.id', '25-05-04', 5, 'Jl Soekarno Hatta', '628214751662', 'Aktif', 0, '', '', 1746100462, 'PPPOE', 'jlsoekarnohatta_lia', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 131, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (248, 'Mochammad Ilham', '105020149', 'ilhampro@bytehome.id', '25-03-05', 5, 'Jl Mastrip GG Kelapa', '6281332124075', 'Aktif', 0, '', '', 1746100791, 'PPPOE', 'jlmastrip_ilham', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 102, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (249, 'Dohan Divo', '105020150', 'dohandivo@bytehome.id', '25-01-03', 5, 'Jl Cokroaminoto (JNt Cargo)', '6287776998330', 'Aktif ', 0, '', '', 1766554751, 'PPPOE', 'jlkhabdulaziz_dohandivo', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 147, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (250, 'Usman Ainul Yaqin', '105020151', 'usmanainulyaqin@bytehome.id', '25-03-01', 5, 'Jl Cokroaminoto', '6282237233161', 'Aktif', 0, '', '', 1766554752, 'PPPOE', 'jlcokroaminoto_usman', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 146, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (251, 'Antonius', '105020152', 'antonius@bytehome.id', '25-03-01', 5, 'Jl Perum Pendopo Kencana Wiroborang', '62895631157221', 'Aktif ', 0, '', '', 1766554753, 'PPPOE', 'perumpendopo_anthonius', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 152, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (252, 'Sukma Wulandari', '105020153', 'sukmawulandari@bytehome.id', '25-03-01', 5, 'Jl Cokroaminoto', '6289522686996', 'Aktif', 0, '', '', 1766554754, 'PPPOE', 'jlcokroaminoto_sukma', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 146, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (253, 'Krisdiana', '105020154', 'krisdiana@bytehome.id', '25-03-01', 5, 'Jl Cangkring GG III', '6285335462652', 'Aktif ', 0, '', '', 1766554755, 'PPPOE', 'jlcangkring_krisdiana', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 149, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (254, 'Sri Dwi Haryati', '105030001', 'sridwiharyati@bytehome.id', '25-03-04', 5, 'Jl Mayangan Pasar Bantaran', '6282245580741', 'Aktif ', 0, '', '', 1766554756, 'PPPOE', 'jlmayangan_sridwi', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 153, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (255, 'Siti Aisyah', '105030002', 'sitiaisyah002@bytehome.id', '25-03-05', 5, 'Jl Mayangan Pasar Bantaran', '6282229735525', 'Aktif', 0, '', '', 1766554757, 'PPPOE', 'jlmayangan_sitiaisyah', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 153, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (256, 'Rozana Mayanti', '105030003', 'rozanamayanti@bytehome.id', '25-03-05', 5, 'Jl Patokan Bantaran', '6282244499883', 'Non-Aktif', 0, '', '', 1766554758, 'PPPOE', 'jlpatokan_rozana', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 5, 154, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (257, 'Martatik', '105030004', 'martatik@bytehome.id', '25-03-05', 5, 'Jl Patokan Bantaran', '6282313233666', 'Aktif ', 0, '', '', 1766554759, 'PPPOE', 'jlpatokan_martatik', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 154, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (258, 'Sukmawati', '105030005', 'sukmawati@bytehome.id', '25-03-06', 5, 'Jl Patokan Bantaran', '6282314956874', 'Aktif', 0, '', '', 1766554760, 'PPPOE', 'jlpatokan_sukmawati', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 154, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (259, 'Saifur Rizal', '105030006', 'izzakarina@bytehome.id', '25-03-06', 5, 'Jl Mayangan Bantaran ', '6285204882523', 'Aktif ', 0, '', '', 1766554761, 'PPPOE', 'jlmayangan_izzakarina', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 154, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (260, 'Salim Yudi Purwanto', '105030007', 'salimyudipurwanto@bytehome.id', '25-03-07', 5, 'Dsn Krajan Kropak', '6282258597163', 'Aktif ', 0, '', '', 1766554762, 'PPPOE', 'dsnkrajan_salim', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 5, 157, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (261, 'Pandi', '105020155', 'pandi@bytehome.id', '25-03-07', 5, 'JL Amir Hamzah', '6281259425611', 'Aktif', 0, '', '', 1766554763, 'PPPOE', 'jlamirrhamzah_pandi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 156, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (262, 'Aridul Maarif', '105030008', 'aridulmaarif@bytehome.id', '25-03-07', 5, 'Jl Mayangan Bantaran ', '6282334819670', 'Non-Aktif', 0, '', '', 1766554764, 'PPPOE', 'jlmayangan_aridul', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 127000, '', 0, '', 0, 5, 157, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (263, 'Siti Kotija', '105020156', 'sitikotija@bytehome.id', '25-03-07', 5, 'Jl Moh Saleh', '6281230254277', 'Non-Aktif', 0, '', '', 1766554765, 'PPPOE', 'jlmohsaleh_sitikotija', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 158, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (264, 'Nemo', '105010100', 'nemo@bytehome.id', '25-03-09', 5, 'Jl Bendi GG Krisna No. 6', '6285330891082', 'Non-Aktif', 0, '', '', 1766554766, 'PPPOE', 'jlbendi_nemo', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 159, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (265, 'Bibi Slamet', '105020157', 'bibitslamet@bytehome.id', '25-03-10', 5, 'Jl Cokroaminoto', '6282337140233', 'Aktif', 0, '', '', 1766554767, 'PPPOE', 'jlcokro_bibi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 146, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (266, 'Achmad Sidik', '105020158', 'achmadsidik@bytehome.id', '25-03-10', 5, 'Kebonsariwetan', '6282336831344', 'Aktif ', 0, '', '', 1766554768, 'PPPOE', 'kebonsariwetan_sidik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 42, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (267, 'Tri Dina Maqfirah', '105020159', 'tridinamaqfirah@bytehome.id', '25-03-11', 5, 'Jl KH Ahmad Dahlan ', '6282331757892', 'Aktif', 0, '', '', 1766554769, 'PPPOE', 'jlakhmaddahlan_dina', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 42, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (268, 'Ramli Effendi', '105020160', 'ramlieffendi@bytehome.id', '25-03-11', 5, 'Jl Priksan GG Rajawali', '6285331098832', 'Aktif ', 0, '', '', 1766554770, 'PPPOE', 'jlpriksan_ramli', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 91, 30, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (269, 'Alvian ari pradana', '105020161', 'alvianaripradana@bytehome.id', '25-03-12', 5, 'Jl KH Abdul Hamid ', '6285204244107', 'Aktif', 0, '', '', 1766554771, 'PPPOE', ' jlkhabdulhamid_alvian', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 173, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (270, 'Nur Hasan', '105030009', 'nurhasan@bytehome.id', '25-03-12', 5, 'Dsn Krajan Tempuran Bantaran', '6285258880114', 'Aktif ', 0, '', '', 1766554772, 'PPPOE', ' dsnkrajan_nurhasan', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 5, 175, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (271, 'Ronny Eka', '105010101', 'ronnyeka@bytehome.id', '25-03-13', 5, 'Pesisir ', '6282333010582', 'Aktif', 0, '', '', 1766554773, 'PPPOE', 'pesisir_roni', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 108, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (272, 'Ummi Kulsum', '105030010', 'ummikulsum@bytehome.id', '25-03-13', 5, 'Jl Kyai Anom Tempuran Bantaran ', '6285204882523', 'Non-Aktif', 0, '', '', 1766554774, 'PPPOE', ' jlkyanom_kulsum', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 174, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (273, 'M Samsul Arifin', '105030011', 'msamsularifin@bytehome.id', '25-03-13', 5, 'Dsn Krajan ', '6282332554588', 'Aktif', 0, '', '', 1766554775, 'PPPOE', ' dsnkrajan_samsul', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 163, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (274, 'Didi Sulaiman', '105030012', 'didisulaiman@bytehome.id', '25-03-15', 5, 'Dsn Kaporan Patokan Bantaran ', '6282338961964', 'Aktif ', 0, '', '', 1766554776, 'PPPOE', 'dsnkaporan_didi', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 163, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (275, 'Misnadi', '105030013', 'misnadi@bytehome.id', '25-03-15', 5, 'Dsn Kaporan Patokan Bantaran ', '6283180633835', 'Aktif', 0, '', '', 1766554777, 'PPPOE', 'dsnkaporan_misnadi', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 163, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (276, 'Busaji', '105030014', 'busaji@bytehome.id', '25-03-15', 5, 'Dsn Kaporan Patokan Bantaran ', '62895404888321', 'Aktif ', 0, '', '', 1766554778, 'PPPOE', 'dsnkaporan_busaji', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 163, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (277, 'Rivan Dian firmansyah', '105010102', 'rivandianfirmansyah@bytehome.id', '25-03-15', 5, 'Blok Kolor Kademangan', '6283170399276', 'Aktif', 0, '', '', 1766554779, 'PPPOE', 'blokkolor_rivan', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 72, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (278, 'Viva Sanjayani', '105010103', 'vivasanjayani@bytehome.id', '25-03-17', 5, 'Lemah kembar, sumberasih', '6283848880088', 'Non-Aktif', 0, '', '', 1766554780, 'PPPOE', 'lembahkembar_viva', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 132, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (279, 'Rofi Dwi Sagara', '105010104', 'rofidwisagara@bytehome.id', '25-03-17', 5, 'Jl Brantas', '6282229776747', 'Aktif', 0, '', '', 1766554781, 'PPPOE', 'jlbrantas_rofidwi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 25, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (280, 'Ali', '105020162', 'aliii002@bytehome.id', '25-03-17', 5, 'JL Amir Hamzah', '6285257371750', 'Aktif ', 0, '', '', 1766554782, 'PPPOE', 'jlamirrhamzah_ali', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 42, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (281, 'Vina Rahmatin', '105010105', 'vinarahmatin@bytehome.id', '25-03-17', 5, 'Jl Merbabu', '6282248068226', 'Aktif', 0, '', '', 1766554783, 'PPPOE', 'merbabu_vina', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 32, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (282, 'TIKA', '105030015', 'tika@bytehome.id', '25-03-18', 5, 'Jl Raya Bantaran', '6285233078456', 'Aktif ', 0, '', '', 1766554784, 'PPPOE', 'jlrayabantaran_tika', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 177, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (283, 'Hosnawiyah', '105010106', 'hosnawiyah@bytehome.id', '25-03-19', 5, 'Jl Semeru', '62895334135385', 'Aktif', 0, '', '', 1766554785, 'PPPOE', 'jlsemeru_hosnawiyah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 56, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (284, 'Laily Badriyah', '105010107', 'lailybadriyah@bytehome.id', '25-03-19', 5, 'Jl KH Abdul Hamid ', '6281249009457', 'Aktif ', 0, '', '', 1766554786, 'PPPOE', 'jlwijayakusuma_laily', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 93, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (285, 'M Feri irawan', '105010108', 'mferiirawan@bytehome.id', '25-03-19', 5, 'Jl Prof Dr Hamka ', '6281916890701', 'Aktif', 0, '', '', 1766554787, 'PPPOE', 'jldrhamka_feri', 0, 5, 1, 'KTP', 17, 0, 0, '-7.797025016287051', '113.26548179977468', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 93, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (286, 'M Yunus', '105010109', 'myunus@bytehome.id', '25-03-19', 5, 'Jl Merbabu', '6281234868656', 'Aktif ', 0, '', '', 1766554788, 'PPPOE', 'jlmerbabu_yunus', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 32, 8, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (287, 'Siti Umilah', '105020163', 'sitiumilah@bytehome.id', '25-03-20', 5, 'Jl Ikan Tongkol ', '62895322547890', 'Aktif', 0, '', '', 1766554789, 'PPPOE', 'jlikantongkol_umilah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 61, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (288, 'Yusup', '105020164', 'yusup@bytehome.id', '25-03-20', 5, 'Jl Ikan Cumi ', '62895396177471', 'Aktif ', 0, '', '', 1766554790, 'PPPOE', 'jlikancumi_yusup', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (289, 'Isnaini', '105020165', 'isnaini@bytehome.id', '25-03-21', 5, 'Jl Ikan Tongkol ', '6287822546117', 'Aktif', 0, '', '', 1766554791, 'PPPOE', 'jlikantongkol_isnaini', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 179, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (290, 'Dewi Milasari', '105010110', 'dewimilasari@bytehome.id', '25-03-21', 5, 'Mentor Sumberasih ', '6285176949253', 'Non-Aktif', 0, '', '', 1766554792, 'PPPOE', 'mentor_dewimilasari', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 117, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (291, 'Linda Octavia maharani', '105010111', 'lindaoctaviamaharani@bytehome.id', '25-03-22', 5, 'Ketapang ', '6285184969861', 'Non-Aktif', 0, '', '', 1766554793, 'PPPOE', 'ketapang_linda', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 180, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (292, 'Sagiman', '105010112', 'sagiman@bytehome.id', '25-03-23', 5, 'GG Delima, Pilang', '6281359307556', 'Aktif ', 0, '', '', 1766554794, 'PPPOE', 'ggdelima_sagiman', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 134, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (293, 'Imam Khairul Rasyid', '105010113', 'imamkhairulrasyid@bytehome.id', '25-03-23', 5, 'Jl Supriyadi', '628111529914', 'Aktif', 0, '', '', 1766554795, 'PPPOE', 'jlsupriyadi_khairul', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 166, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (294, 'Siti Nuraini', '105030016', 'sitinuraini@bytehome.id', '25-03-24', 5, 'Dsn Krajan Bantaran', '6285204234253', 'Non-Aktif', 0, '', '', 1766554796, 'PPPOE', 'dsnkrajan_nuraini ', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 157, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (295, 'Saiful Ulum', '105030017', 'saifululum@bytehome.id', '25-03-24', 5, 'Dsn Krajan Bantaran ', '6282333060784', 'Aktif', 0, '', '', 1766554797, 'PPPOE', 'dsnkrajan_ulum', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 157, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (296, 'Ida Yanti', '105020166', 'idayanti@bytehome.id', '25-03-24', 5, 'Jl Ikan Tongkol Mayangan ', '6282338571201', 'Aktif ', 0, '', '', 1766554798, 'PPPOE', 'jlikantongkol_ida', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 62, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (297, 'Amirus Solihin', '105010114', 'amirussolihin@bytehome.id', '25-03-25', 5, 'Blok Kolor Kademangan', '6287705579536', 'Aktif', 0, '', '', 1766554799, 'PPPOE', 'blokkolor_amirus', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 72, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (298, 'Zainullah', '105020167', 'zainullah@bytehome.id', '25-03-25', 5, 'Jl.Dr Moch Soleh ', '6287859928600', 'Aktif ', 0, '', '', 1766554800, 'PPPOE', 'jldrsaleh_zainullah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 158, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (299, 'Fendi Hariyanto', '105020168', 'fendihariyanto@bytehome.id', '', 5, 'GG Mawar, Randu Pangger', '6282141515843', 'Aktif', 0, '', '', 1766554801, 'PPPOE', 'randupangger_fendi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 1, 205000, '', 0, '', 0, 4, 112, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (300, 'Anis Mutmainah', '105020169', 'anismutmainah@bytehome.id', '25-03-06', 5, 'Jl Pahlawan GG Siran', '6282231688860', 'Aktif ', 0, '', '', 1766554802, 'PPPOE', 'ggsiran_anis', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 88, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (301, 'Agus Salim', '105020170', 'agussalim@bytehome.id', '25-03-26', 5, 'Jl Pahlawan GG Siran ', '6282232348065', 'Aktif', 0, '', '', 1766554803, 'PPPOE', 'ggsiran_agus', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 88, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (302, 'Eva susanti', '105010115', 'evasusanti@bytehome.id', '25-03-06', 5, 'Rusunawa Semeru ', '6285134383484', 'Aktif ', 0, '', '', 1766554804, 'PPPOE', 'rusunawa_eva', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 20, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (303, 'Nur Wahid', '105010116', 'nurwahid@bytehome.id', '25-03-26', 5, 'Jl Raya Sukapura, Sepoh Gembol ', '6281906765134', 'Aktif', 0, '', '', 1766554805, 'PPPOE', 'jlrayasukapura_nurwahid', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 181, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (304, 'Sheila Cantika', '105010117', 'sheilacantika@bytehome.id', '25-03-26', 5, 'Jl Supriyadi gg Pesantren III', '82139053487', 'Aktif ', 0, '', '', 1766554806, 'PPPOE', 'jlsupriyadi_sheila', 0, 5, 1, 'KTP', 17, 0, 62, '', '', 'paket 30Mbps', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 3, 182, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (305, 'Ima Dwi Rahmawati', '105020171', 'imadwirahmawati@bytehome.id', '25-03-26', 5, 'JL Amir Hamzah Pakistaji ', '6282335736362', 'Aktif', 0, '', '', 1766554807, 'PPPOE', 'jlamirhamzah_ima ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 79, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (306, 'Hj Nur Asmaningsih', '105020172', 'hjnurasmaningsih@bytehome.id', '25-03-26', 5, 'Perum Asabri Jl Aa Maramis Blok B No 68', '6285259375045', 'Aktif ', 0, '', '', 1766554808, 'PPPOE', 'perumasabri_nur ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 183, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (307, 'Vivi Sumanti', '105020173', 'vivisumanti@bytehome.id', '25-03-26', 5, 'Jl Ikan Hiu GG I ', '6282141486324', 'Aktif', 0, '', '', 1766554809, 'PPPOE', 'jlikanhiu_sumanti ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps ', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 67, 8, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (308, 'Dwi Okky', '105020174', 'dwiokky@bytehome.id', '25-03-28', 5, 'Jl Panglima Sudirman ', '6282335603778', 'Aktif ', 0, '', '', 1766554810, 'PPPOE', 'jlpangsud_okky ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 184, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (309, 'Nur Fadilah', '105020175', 'nurfadilah@bytehome.id', '25-04-07', 5, 'Jl Cokroaminoto gg siran ', '6289518802762', 'Aktif ', 0, '', '', 1766554811, 'PPPOE', 'ggistiharo_nurfadilah ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 146, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (310, 'Choirul Anam', '105010118', 'choirulanam@bytehome.id', '25-04-07', 5, 'Jl Sukun Triwunglor', '6282143256578', 'Aktif', 0, '', '', 1766554812, 'PPPOE', 'jlsukun_irul', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 47, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (311, 'Andika', '105010119', 'andika@bytehome.id', '25-04-07', 5, 'Jl Cisadane ', '6281510850781', 'Aktif ', 0, '', '', 1766554813, 'PPPOE', 'jlcisadane_andika', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 33, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (312, 'Prisma Khoirul Anam', '105030018', 'prismakhoirulanam@bytehome.id', '25-04-07', 5, 'Dsn Kaporan Bantaran', '62895392668285', 'Aktif ', 0, '', '', 1766554815, 'PPPOE', 'dskaporan_khoirul ', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 176, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (313, 'Moch Idris', '105020176', 'mochidris@bytehome.id', '25-04-08', 5, 'Jl Pahlawan GG Siran ', '6282334810237', 'Aktif', 0, '', '', 1766554816, 'PPPOE', 'ggsiran_idriss ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 88, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (314, 'R Hoemardianto satoto', '105010120', 'rhoemardiantosatoto@bytehome.id', '25-04-08', 5, 'Jl Anggrek Kuning', '6285784914370', 'Aktif ', 0, '', '', 1766554817, 'PPPOE', 'jlanggrekkuning_hoemardianto', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 93, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (315, 'Wahyu Agustin', '105010121', 'wahyuagustin@bytehome.id', '25-04-08', 5, 'Jl Wijaya Kusuma ', '6285606230587', 'Aktif', 0, '', '', 1766554818, 'PPPOE', 'jlwijayakusuma_wahyu', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 43, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (316, 'Ahmad Faisol Hadi', '105010122', 'ahmadfaisolhadi@bytehome.id', '25-04-08', 5, 'Jl Kelud GG Sukun', '6281770831837', 'Aktif ', 0, '', '', 1766554819, 'PPPOE', 'jlkelud_faisol', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 5, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (317, 'Suratman', '105010123', 'suratman@bytehome.id', '25-04-08', 5, 'Jl Cisadane ', '6285138037035', 'Aktif', 0, '', '', 1766554820, 'PPPOE', 'jlcisadane_suratman', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 33, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (318, 'Adjie Aziz Goffar', '105030019', 'adjieazizgoffar@bytehome.id', '25-04-09', 5, 'Jl Mayangan Bantaran ', '6282234509091', 'Aktif ', 0, '', '', 1766554821, 'PPPOE', 'jlmayangan_adjie ', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 153, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (319, 'Luthfiyanto', '105010124', 'luthfiyanto@bytehome.id', '25-04-09', 5, 'Jl Brawijaya Sumberasih', '6285138507711', 'Aktif', 0, '', '', 1766554822, 'PPPOE', 'jlbrawijaya_lutfhiyanto', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 137, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (320, 'Adelia Rizki Rahmadhani', '105020177', 'adeliarizkirahmadhani@bytehome.id', '25-04-09', 5, 'Perum Grandhilton', '6282334502795', 'Aktif', 0, '', '', 1766554824, 'PPPOE', 'grandhilton_adelia ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 39, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (321, 'Hermawan', '105030020', 'hermawan@bytehome.id', '25-04-09', 5, 'Jl Raya Bantaran', '6282131378966', 'Aktif ', 0, '', '', 1766554825, 'PPPOE', 'jlrayabantaran_hermawan ', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 185, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (322, 'M Ramdani Siroj', '105010125', 'mramdanisiroj@bytehome.id', '25-04-09', 5, 'Dsn Sading Triwunglor', '6285784914558', 'Aktif', 0, '', '', 1766554826, 'PPPOE', 'dsnsading_ramdani', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 186, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (323, 'Eko Hermanto', '105020178', 'ekohermanto@bytehome.id', '25-04-10', 5, 'Jl Musi Gg Saroja', '6289504106185', 'Aktif ', 0, '', '', 1766554827, 'PPPOE', 'ggsaroja_eko ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 64, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (324, 'Muhamad Wahyudi', '105030021', 'muhamadwahyudi@bytehome.id', '25-04-10', 5, 'Pasar sambek kropak ', '6281330284822', 'Aktif', 0, '', '', 1766554828, 'PPPOE', 'kropak_wahyudi ', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 187, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (325, 'Dewi Chusnul', '105020179', 'dewichusnul@bytehome.id', '25-04-10', 5, 'Jl KH. Abdul Aziz GG SIran', '6282311386811', 'Aktif ', 0, '', '', 1766554829, 'PPPOE', 'ggsiran_dewi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 88, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (326, 'Yuliani ', '105030022', 'yuliani002@bytehome.id', '25-10-04', 5, 'Dsn Krajan Bantaran', '6282234781664', 'Aktif', 0, '', '', 1766554830, 'PPPOE', 'dsnkrajan_yuliani ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 90, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (327, 'Muzayyanah', '105020180', 'muzayyanah@bytehome.id', '25-04-12', 5, 'Jl Panglima Sudirman ', '6287861217114', 'Aktif', 0, '', '', 1766554831, 'PPPOE', 'jlpangsud_muzayyanah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 189, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (328, 'Mery Herdiana', '105020181', 'meryherdiana@bytehome.id', '25-04-12', 5, 'Jl Kh Abdul Aziz', '6283853993077', 'Aktif ', 0, '', '', 1766554832, 'PPPOE', 'jlabdulaziz_meri ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 88, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (329, 'Umi Kholifah', '105010126', 'umikholifah@bytehome.id', '25-04-12', 5, 'Jl Wijaya Kusuma', '6283872280431', 'Aktif', 0, '', '', 1766554833, 'PPPOE', 'jlwijayakusuma_kholifah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 44, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (330, 'Slamet Riyadi', '105030023', 'slametriyadi@bytehome.id', '25-04-12', 5, 'Dsn Kaporan ', '6282142866724', 'Aktif ', 0, '', '', 1766554834, 'PPPOE', 'dsnkaporan_slametriyadi ', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 163, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (331, 'Fendik Sutato', '105010127', 'fendiksutato@bytehome.id', '25-04-14', 5, 'Jl Bendi GG Nakula ', '6285850012571', 'Non-Aktif', 0, '', '', 1766554835, 'PPPOE', 'jlbendi_fendik', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 190, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (332, 'Putri Sapitya NIngsih', '105010128', 'putrisapityaningsih@bytehome.id', '25-04-14', 5, 'Blok Kolor', '6289512849048', 'Aktif ', 0, '', '', 1766554836, 'PPPOE', 'blokkolor_sapitya', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 118, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (333, 'Nur Aini', '105020182', 'nuraini002@bytehome.id', '25-04-15', 5, 'Jl ky Hasin Mas Curahgrinting', '6285204876891', 'Aktif', 0, '', '', 1766554837, 'PPPOE', 'jlkyhasin_aini ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 191, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (334, 'Dodik Novianto', '105010129', 'dodiknovianto@bytehome.id', '25-04-16', 5, 'Muneng KIdul ', '62895406460866', 'Aktif ', 0, '', '', 1766554838, 'PPPOE', 'munengkidul_dodik', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 162, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (335, 'Lukman Hakim', '105030024', 'lukmanhakim002@bytehome.id', '25-04-16', 5, 'Jl Raya BAntaran ', '6282333596684', 'Aktif', 0, '', '', 1766554839, 'PPPOE', 'jlrayabantaran_lukman ', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 5, 192, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (336, 'Nurul Fadhilah', '105020183', 'nurulfadhilah@bytehome.id', '25-04-16', 5, 'Perum Mutiara Bogowonto', '6282229787232', 'Aktif ', 0, '', '', 1766554840, 'PPPOE', 'perumbogowonto_nurull ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 99, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (337, 'Mustofa', '105030025', 'mustofa0002@bytehome.id', '25-04-17', 5, 'Dsn Krajan Bantaran', '6281246370968', 'Aktif', 0, '', '', 1766554841, 'PPPOE', 'dsnkrajan_mustofa', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 174, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (338, 'M Roni Wijaya', '105020184', 'mroniwijaya@bytehome.id', '25-04-17', 5, 'Jl KH Ahmad dahlan GG Bingkilan ', '6285738128773', 'Aktif ', 0, '', '', 1766554842, 'PPPOE', 'ggbingkilan_roni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 115, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (339, 'Joni Pranata', '105020185', 'jonipranata@bytehome.id', '25-04-18', 5, 'Jl KH Hasan GG Kenongo ', '6283854546018', 'Aktif', 0, '', '', 1766554843, 'PPPOE', 'ggdelima_joni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps ', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 193, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (340, 'Luluk Irawati', '105020186', 'lulukirawati@bytehome.id', '25-04-18', 5, 'Jl KH Hasan GG Kenongo ', '62895413535674', 'Aktif ', 0, '', '', 1766554844, 'PPPOE', 'ggkenongo_luluk', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 193, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (341, 'Putri Endika', '105020187', 'putriendika@bytehome.id', '25-04-18', 5, 'JL Dr Sutomo', '6282143339321', 'Aktif', 0, '', '', 1766554845, 'PPPOE', 'jldrsutomo_endika ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 194, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (342, 'M. Rusdi', '105020188', 'mrusdi@bytehome.id', '25-04-18', 5, 'Jl Ikan Belanak Mayangan ', '6289518700496', 'Aktif ', 0, '', '', 1766554846, 'PPPOE', 'jlikanbelanak_rusdi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', '50M', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 195, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (343, 'Muhammad Efendi', '105010130', 'muhammadefendi@bytehome.id', '25-04-18', 5, 'Dsn Darungan Mentor', '6285231626036', 'Aktif', 0, '', '', 1766554847, 'PPPOE', 'dsndarungan_efendi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 196, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (344, 'Abdurrohim', '105030026', 'abdurrohim@bytehome.id', '25-04-18', 5, 'Dsn Kropak Bantaran ', '6282330449863', 'Aktif ', 0, '', '', 1766554848, 'PPPOE', 'kropak_abdurrohim ', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 197, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (345, 'Haizus syarof', '105030027', 'haizussyarof@bytehome.id', '25-04-19', 5, 'Dsn Kropak Bantaran ', '6282333836635', 'Aktif', 0, '', '', 1766554849, 'PPPOE', 'dsnkrajan_haizus', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 197, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (346, 'Moch sholehudin', '105010131', 'mochsholehudin@bytehome.id', '25-04-20', 5, 'Dsn Darungan Mentor ', '6282333533672', 'Aktif', 0, '', '', 1766554850, 'PPPOE', 'dsndarungan_sholehudin', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 196, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (347, 'Yudha wicaksana', '105010132', 'yudhawicaksana@bytehome.id', '25-04-20', 5, 'Jl Semeru ', '6282330233047', 'Aktif', 0, '', '', 1766554851, 'PPPOE', 'jlsemeru_yudha', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 20, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (348, 'Amry Nuari', '105020189', 'amrynuari@bytehome.id', '25-04-21', 5, 'Jl Mastrip Gg Kelapa Sawit ', '628123186509', 'Aktif ', 0, '', '', 1766554852, 'PPPOE', 'ggkelapa_amry', 0, 6, 1, 'KTP', 10, 0, 0, '', '', '15M', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 102, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (349, 'A. Sanusi', '105030028', 'asanusi@bytehome.id', '25-04-21', 5, 'Jl Raya BAntaran ', '6283879465934', 'Aktif', 0, '', '', 1766554853, 'PPPOE', 'jlrayabantaran_sanusi', 0, 7, 1, 'KTP', 10, 0, 62, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 192, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (350, 'Suwarno', '105020190', 'suwarno@bytehome.id', '25-04-21', 5, 'Jl Soekarno Hatta GG Delima', '6281336381711', 'Aktif ', 0, '', '', 1766554854, 'PPPOE', 'ggdelima_suwarno', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 134, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (351, 'M Farrel', '105020191', 'mfarrel@bytehome.id', '25-04-22', 5, 'Jl Panglima Sudirman', '6285330615041', 'Aktif', 0, '', '', 1766554855, 'PPPOE', 'jlpangsud_farrel ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 1, 205000, '', 0, '', 0, 4, 172, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (352, 'Ferly Rejif Fanny', '105020192', 'ferlyrejiffanny@bytehome.id', '25-04-22', 5, 'JL Ikan Banyar Mayangan ', '6289515540946', 'Aktif ', 0, '', '', 1766554856, 'PPPOE', 'jlikanbanyar_ferly', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 67, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (353, 'Abu Sofyan', '105010133', 'abusofyan@bytehome.id', '25-04-23', 5, 'Jl Himalaya GG 5B no. 6', '082237883224', 'Aktif', 0, '', '', 1766554857, 'PPPOE', 'jlhimayalaya_sofyan', 0, 5, 1, 'KTP', 17, 0, 62, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 198, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (354, 'Siti Kartini', '105010134', 'sitikartini@bytehome.id', '25-04-23', 5, 'Jl Brantas Pilang Permai', '6281227101109', 'Aktif ', 0, '', '', 1766554858, 'PPPOE', 'pilangpermai_kartini', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 12, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (355, 'Roro Hurustiani', '105020193', 'rorohurustiani@bytehome.id', '25-04-23', 5, 'Jl Ahmad Dahlan Gg Bingkilan ', '6287743269427', 'Aktif', 0, '', '', 1766554859, 'PPPOE', 'ggbingkilan_roro ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps ', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 42, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (356, 'Iwan Prasetyo', '105020194', 'iwanprasetyo@bytehome.id', '25-04-23', 5, 'Jl Kh Ahmad dahlan ', '62895341513929', 'Aktif ', 0, '', '', 1766554860, 'PPPOE', 'jlkhahmaddahlan_iwan ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 40, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (357, 'Warda Algadri Umar', '105020195', 'wardaalgadriumar@bytehome.id', '25-04-24', 5, 'Jl Nusa Indah Baru No 2', '6282131395422', 'Aktif', 0, '', '', 1766554861, 'PPPOE', 'jlnusaindah_warda', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 199, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (358, 'Titik Makrifah', '105030029', 'titikmakrifah@bytehome.id', '25-04-24', 5, 'Jl Raya Bantaran ', '6285230582137', 'Aktif ', 0, '', '', 1766554862, 'PPPOE', 'tempuran_titik', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 174, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (359, 'Aminatus Zahro', '105030030', 'aminatuszahro@bytehome.id', '25-04-25', 5, 'Jl Raya Bantaran ', '6285231103887', 'Aktif', 0, '', '', 1766554863, 'PPPOE', 'jlrayabantaran_aminatus', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 174, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (360, 'M Hasbullah', '105020196', 'mhasbullah@bytehome.id', '25-04-25', 5, 'Jl KH Genggong Gg KY Nur Bulan ', '6285331607027', 'Aktif ', 0, '', '', 1766554864, 'PPPOE', 'jlkhhasan_hasbullah ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 172, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (361, 'Bambang Ali Susilo', '105020197', 'bambangalisusilo@bytehome.id', '', 5, 'Jl Panglima Sudirman ', '6287779404648', 'Aktif', 0, '', '', 1766554865, 'PPPOE', 'jlpangsud_bambang', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps ', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 90, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (362, 'M idris', '105010135', 'midris@bytehome.id', '25-04-26', 5, 'Jl Cisadane ', '6287722216255', 'Aktif ', 0, '', '', 1766554866, 'PPPOE', 'jlcisadane_idris', 0, 6, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 90, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (363, 'Pugoh Dwi Laksono', '105020198', 'pugohdwilaksono@bytehome.id', '25-04-26', 5, 'Jl Bengawan Solo ', '62895403610517', 'Aktif', 0, '', '', 1766554867, 'PPPOE', 'jlbengawansolo_pugoh ', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 200, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (364, 'Firdaus Bay Arifin', '105020199', 'firdausbay@bytehome.id', '25-03-08', 5, 'Jl Bridgen Katamso gg 2', '6285234642304', 'Aktif', 0, '', '', 1746237126, 'PPPOE', 'jlbridgen_firdaus', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 55, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (365, 'Wahyudi Pratama', '105010136', 'wahyudipratama@bytehome.id', '25-03-09', 5, 'Jl Flamboyan GG I', '6282395575290', 'Aktif', 0, '', '', 1746237543, 'PPPOE', 'jlflamboyan_wahyudi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 87, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (366, 'Wawan Hartono', '105010137', 'wawanhartono@bytehome.id', '25-04-27', 5, 'Rusunawa semeru', '6281334078842', 'Aktif', 0, '', '', 1747278373, 'PPPOE', 'rusunawa_wawanhartono', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 20, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (367, 'Akbar Julianto', '105020200', 'akbar@bytehome.id', '25-04-27', 5, 'Jl Panglima Sudirman ', '6285646037859', 'Aktif', 0, '', '', 1747278688, 'PPPOE', 'jlpangsud_julianto', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 91, 11, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (368, 'Novita Deviana', '105020201', 'novitadeviana@bytehome.id', '25-04-27', 5, 'Jl Amir Hamzah ', '6281358166742', 'Aktif', 0, '', '', 1747279340, 'PPPOE', 'jlamirhamzah_deviana', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 78, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (369, 'Agus Budiono', '105030031', 'agusbudiono@bytehome.id', '25-04-28', 5, 'Jl Mayangan Bantaran ', '6285228550153', 'Aktif', 0, '', '', 1747279634, 'PPPOE', 'jlmayangan_budiono', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 153, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (370, 'Anang Mulyadi', '105010138', 'anangmulyadi@bytehome.id', '25-04-28', 5, 'Muneng KIdul ', '6282229207812', 'Aktif', 0, '', '', 1747283498, 'PPPOE', 'munengkiudul_anang', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 162, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (371, 'Desi wulandari', '105010139', 'desiwulandari@bytehome.id', '25-04-28', 5, 'Muneng KIdul ', '6285646002024', 'Aktif', 0, '', '', 1747283815, 'PPPOE', 'munengkidul_desi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 162, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (372, 'Miftahul Ulum', '105030032', 'miftahul@bytehome.id', '25-04-28', 5, 'JL RAYA BANTARAN', '6285258779912', 'Non-Aktif', 0, '', '', 1747284104, 'PPPOE', 'jlrayabantaran_miftahul', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 163, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (373, 'Sholeh Herman Felany', '105030033', 'sholehherman@bytehome.id', '25-04-29', 5, 'Dsn Kaporan Bantaran ', '6283893793438', 'Aktif', 0, '', '', 1747284246, 'PPPOE', 'dsnkaporan_sholeh', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 155, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (374, 'Abdur Rohim', '105020202', 'abdur@bytehome.id', '25-04-29', 5, 'Jl Cumi-cumi Mayangan ', '6289504280302', 'Aktif', 0, '', '', 1747284393, 'PPPOE', 'jlikancumicumi_abdur', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 65, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (375, 'Asmori', '105020203', 'asmori@bytehome.id', '25-04-29', 5, 'Jl Ikan Tongkol ', '6285259710780', 'Aktif', 0, '', '', 1747284709, 'PPPOE', 'jlikantongkol_asmori', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 61, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (376, 'Diniah Nursam', '105020204', 'diniah@bytehome.id', '25-04-30', 5, 'Jl Priksan gg panda', '6281235434394', 'Aktif', 0, '', '', 1747284855, 'PPPOE', 'priksan_diniah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 164, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (377, 'Anggih Dwi Lacsamana', '105020205', 'anggih@bytehome.id', '25-04-30', 5, 'Jl Panglima Sudirman ', '6282247147070', 'Aktif', 0, '', '', 1747285021, 'PPPOE', 'jlpangsud_anggih', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 165, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (378, 'Niati', '105020206', 'niati@bytehome.id', '25-05-01', 5, 'Jl Ikan Cumi Cumi ', '6282334022919', 'Aktif', 0, '', '', 1747285149, 'PPPOE', 'jlikancumi_niati', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 65, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (379, 'Abu Amar', '105020207', 'abuamar@bytehome.id', '25-05-01', 5, 'Jl Ikan Tongkol Mayangan ', '6285257940107', 'Aktif', 0, '', '', 1747285392, 'PPPOE', 'jlikantongkol_abuamar', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 61, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (380, 'Rayan bagus', '105010140', 'rayan@bytehome.id', '25-05-01', 5, 'Jl Supriadi ', '6281235690543', 'Aktif', 0, '', '', 1747286801, 'PPPOE', 'jlsupriyadi_rayan', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 1, 165000, '', 0, '', 0, 3, 166, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (381, 'Dewi Parawatiningsih', '105010141', 'dewiparawati@bytehome.id', '25-05-02', 5, 'Muneng KIdul ', '6282139547976', 'Aktif', 0, '', '', 1747287643, 'PPPOE', 'munengkidul_dewi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 162, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (382, 'Sumarning', '105010142', 'sumarning@bytehome.id', '25-05-03', 5, 'Jl Wijaya Kusuma', '6289699857383', 'Aktif', 0, '', '', 1747287767, 'PPPOE', 'jlwijayakusuma_sumarning', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 45, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (383, 'Jirov Kumar', '105020208', 'jirov@bytehome.id', '25-05-03', 5, 'Jl Panglima Sudirman', '6281775218949', 'Aktif', 0, '', '', 1747288157, 'PPPOE', 'jlpangsud_jirov', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 11, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (384, 'Rika Rustiyah', '105020209', 'rika@bytehome.id', '25-05-04', 5, 'Jl Ikan Cumi Cumi ', '6289662635660', 'Aktif', 0, '', '', 1747288303, 'PPPOE', 'jlikancumi_rika', 0, 6, 1, 'KTP', 10, 0, 62, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 167, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (385, 'Supriatun', '105010143', 'supriatun@bytehome.id', '25-05-05', 5, 'Jl Semeru ', '6285165656879', 'Non-Aktif', 0, '', '', 1747288467, 'PPPOE', 'jlsemeru_supriatun', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 7, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (386, 'Sudarsono', '105010144', 'sudarsoono@bytehome.id', '25-05-05', 5, 'Jl Kaliamas Pohsangit Kidul ', '6285234644157', 'Non-Aktif', 0, '', '', 1747288775, 'PPPOE', 'pohsangitkidul_sudarsono', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 168, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (387, 'Raden Ajeng Uluwiyah', '105010145', 'radenajeng@bytehome.id', '25-05-06', 5, 'Jl Semeru Kademangan ', '6285729562486', 'Aktif', 0, '', '', 1747288934, 'PPPOE', 'jlsemeru_ajeng', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 101, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (388, 'Budiono', '105010146', 'budiono@bytehome.id', '25-05-08', 5, 'Jl Cempaka ', '6285233691027', 'Aktif', 0, '', '', 1747456659, 'PPPOE', 'jlcempaka_budiono', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 98, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (389, 'Debi Sudarso', '105010147', 'debisudarso@bytehome.id', '25-05-09', 5, 'Blok Tanjung Kademangan ', '6285706191131', 'Aktif', 0, '', '', 1747456986, 'PPPOE', 'bloktanjung_debi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 169, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (390, 'Imam Maliki', '105010148', 'imammaliki@bytehome.id', '25-05-09', 5, 'Triwung Kidul  Kademangan ', '6285258164135', 'Aktif', 0, '', '', 1747457149, 'PPPOE', 'triwungkidul_imam', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 171, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (391, 'Ach Son Haji', '105010149', 'sonhajipro@bytehome.id', '25-05-09', 5, 'Jl semeru ', '6282330509667', 'Aktif', 0, '', '', 1747457663, 'PPPOE', 'jlsemeru_sonhaji', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 25, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (392, 'Yosi Ricky', '105010150', 'yosi@bytehome.id', '25-05-10', 5, 'Perumahn diva dava ', '6282333242876', 'Aktif', 0, '', '', 1747457836, 'PPPOE', 'perumahandiva_yosi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 35, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (393, 'Hafindri Dwi Yunita', '105020210', 'hafindri@bytehome.id', '25-05-11', 5, 'Jl Manalagi ', '6285725270950', 'Aktif', 0, '', '', 1747458031, 'PPPOE', 'jlmanalagi_hafindri', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 84, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (394, 'Muhammad Tifan', '105020211', 'muhammadtifan@bytehome.id', '25-05-12', 5, 'Jl KH Hasan gg Pelita', '6288991815000', 'Aktif', 0, '', '', 1747458425, 'PPPOE', 'ggpelita_tifan', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 172, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (395, 'Nanang Hariyanto', '105020212', 'nananghariyanto@bytehome.id', '25-05-13', 5, 'Jl Maramis ', '82333812980', 'Aktif', 0, '', '', 1747458580, 'PPPOE', 'jlmaramis_nanang', 0, 6, 1, 'KTP', 10, 0, 62, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 21, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (396, 'Musthofa Ali', '105020213', 'musthofaali@bytehome.id', '25-05-13', 5, 'JL Gatot Subroto', '6289654206677', 'Aktif', 0, '', '', 1747458769, 'PPPOE', 'jlgatotsubroto_musthofa', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 139, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (397, 'Korisah', '105020214', 'korisah@bytehome.id', '25-05-13', 5, 'Jl Abdul Aziz ', '6285211744278', 'Aktif', 0, '', '', 1747458896, 'PPPOE', 'jlabdulaziz_korisah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 145, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (398, 'Akhmad Yusuf', '105030034', 'akhmadyusuf@bytehome.id', '25-05-14', 5, 'Dsn. Pakis Patokan Bantaran ', '6282302332049', 'Aktif', 0, '', '', 1747459016, 'PPPOE', 'dsnpkis_akhmad', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 5, 154, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (399, 'Syaifuddin Jauhari', '105020215', 'syaifuddin@bytehome.id', '25-05-14', 5, 'JL. KH hasan Gg Pelita ', '6285213243808', 'Aktif', 0, '', '', 1747459254, 'PPPOE', 'ggpelita_syaifuddin', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 143, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (400, 'Bagus Gunawan Kusuma', '105010151', 'bagus@bytehome.id', '25-05-14', 5, 'Rusunawa semeru', '6281313181342', 'Aktif', 0, '', '', 1747459380, 'PPPOE', 'rusunawa_bagus', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 3, 20, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (401, 'Ahmad Taufiq', '105010152', 'ahmadtaufiqq@bytehome.id', '25-05-14', 5, 'Jl Galunggung ', '6281252775567', 'Aktif', 0, '', '', 1747459899, 'PPPOE', 'jlgalunggung_ahmad', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 121, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (402, 'Neng Siti Salama', '105030035', 'nengsiti@bytehome.id', '25-05-14', 5, 'Kropak Bantaran ', '6285808282622', 'Aktif', 0, '', '', 1747810082, 'PPPOE', 'kropak_siti', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 208, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (403, 'Siti nur azizah', '105020216', 'sitinurazizahhh@bytehome.id', '25-05-15', 5, 'Jl Sunan Ampel ', '6289652083100', 'Aktif', 0, '', '', 1747810355, 'PPPOE', 'jlsunanampel_siti', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 202, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (404, 'Ahmad Taufiq', '105020217', 'ahmadproling@bytehome.id', '25-05-15', 5, 'JL Pattimura', '6287776145467', 'Aktif', 0, '', '', 1747811452, 'PPPOE', 'jlpattimura_taufiq', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 203, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (405, 'Hudaifah', '105010153', 'hudaifah@bytehome.id', '25-05-16', 5, 'Jl Merbabu ', '6281332908877', 'Aktif', 0, '', '', 1747811638, 'PPPOE', 'jlmerbabu_hudaifah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 31, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (406, 'Indah Wahyuni', '105010154', 'indahwhyuni@bytehome.id', '25-05-16', 5, 'Jl Supriadi ', '6282335736400', 'Aktif', 0, '', '', 1747811769, 'PPPOE', 'jlsupriadi_indah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 182, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (407, 'Kasiono', '105010155', 'kasiono@bytehome.id', '25-05-17', 5, 'Sumberwetan ', '6285235588341', 'Aktif', 0, '', '', 1747812721, 'PPPOE', 'sumberwetan_kasiono', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 204, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (408, 'Ilham', '105010156', 'ilhamproling@bytehome.id', '25-05-18', 5, 'Dsn Krajan Triwungkidul ', '6285707033381', 'Aktif', 0, '', '', 1747812881, 'PPPOE', 'triwungkidul_ilham', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 205, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (409, 'Muhammad Fajar', '105010157', 'muhammadfajar@bytehome.id', '25-05-18', 5, 'Jl Kelud ', '6281247246655', 'Aktif', 0, '', '', 1747813055, 'PPPOE', 'jlkelud_fajar', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 6, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (410, 'Hasan', '105030036', 'hasanproling@bytehome.id', '25-05-19', 5, 'Patokan Bantaran ', '6285204939388', 'Non-Aktif', 0, '', '', 1747813226, 'PPPOE', 'patokan_hasan', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 155, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (411, 'Lailatul Fahriya', '105010158', 'lailtulfahriya@bytehome.id', '25-05-19', 5, 'Jl Brawijaya', '6282234781896', 'Aktif', 0, '', '', 1747813367, 'PPPOE', 'jlbrawijaya_fahria', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 207, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (412, 'Indyana Halimatus', '105010159', 'indyana@bytehome.id', '25-05-19', 5, 'Jl Brantas', '6285859414616', 'Aktif', 0, '', '', 1747815830, 'PPPOE', 'jlbrantas_indyana', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 12, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (413, 'Laura Oktavia', '105010160', 'lauraoktvia@bytehome.id', '25-05-19', 5, 'Rusunawa semeru ', '6285604380384', 'Aktif', 0, '', '', 1747815996, 'PPPOE', 'rusunawa_laura', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 20, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (414, 'Karso Akbar', '105030037', 'karso@bytehome.id', '25-05-20', 5, 'Tempuran Bantaran ', '6285231726119', 'Aktif', 0, '', '', 1747816328, 'PPPOE', 'tempuran_karso', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 208, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (415, 'Seneman', '105010161', 'seneman@bytehome.id', '25-05-20', 5, 'Dusun Krajan Sumberasih', '628314626874', 'Aktif', 0, '', '', 1747816488, 'PPPOE', 'dsnkrajan_seneman', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 207, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (416, 'Nailatul Ramadani', '105020218', 'nailatul@bytehome.id', '25-05-21', 5, 'Jl Cangkring GG 5 ', '6285964218009', 'Non-Aktif', 0, '', '', 1747816621, 'PPPOE', 'cangkring_naila', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 209, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (417, 'Suratiningsih', '105020219', 'suratiningsiih@bytehome.id', '25-05-21', 5, 'GG Flamboyan ', '6282257114886', 'Aktif', 0, '', '', 1748054030, 'PPPOE', 'ggflamboyan_suratiningsih', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 210, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (418, 'Togok Hariyono', '105020220', 'togok@bytehome.id', '25-05-21', 5, 'GG Flamboyan ', '6282141515585', 'Aktif', 0, '', '', 1748054159, 'PPPOE', 'ggflamboyan_togok', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 210, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (419, 'Roviul azizah', '105010162', 'roviul@bytehome.id', '25-05-21', 5, 'Jl Galunggung ', '6281336777220', 'Aktif', 0, '', '', 1748056432, 'PPPOE', 'jlglunggung_roviul', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 211, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (420, 'Santi Setyawati', '105020221', 'santi@bytehome.id', '25-05-22', 5, 'Jl KH Hasan Genggong ', '6282245151738', 'Non-Aktif', 0, '', '', 1748056595, 'PPPOE', 'genggong_santi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 142, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (421, 'Putri', '105030038', 'putribantaran@bytehome.id', '25-05-22', 5, 'Jl Raya Bantaran ', '62895406033925', 'Aktif', 0, '', '', 1748057101, 'PPPOE', 'jlrayabantaran_putri', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 5, 212, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (422, 'Ahmad Bahsun', '105010163', 'ahmadbahsun@bytehome.id', '25-05-22', 5, 'Jl Galunggung ', '6282332959645', 'Non-Aktif', 0, '', '', 1748057211, 'PPPOE', 'jlglunggung_bahsun', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 121, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (423, 'Mita Widyawati', '105010164', 'mitawidyawati@bytehome.id', '25-05-07', 5, 'JL Citarum ', '6282236921472', 'Aktif', 0, '', '', 1748058353, 'PPPOE', 'jlcitarum_mita', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 170, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (424, 'Sri Wulandari', '105010165', 'sriwulandaaari@bytehome.id', '25-04-21', 5, 'PERUM PERMATA REGENCY', '6289526320403', 'Aktif', 0, '', '', 1748145396, 'PPPOE', 'perumpermata_sri', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 103, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (425, 'Samsul Huda', '105030039', 'samsulhudapro@bytehome.id', '25-05-23', 5, 'Tempuran Bantaran ', '6285335423322', 'Aktif', 0, '', '', 1748318151, 'PPPOE', 'tempuran_samsul', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 175, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (426, 'Veve Febrianti', '105030040', 'vevefebrianti@bytehome.id', '25-05-23', 5, 'Perum  Kademangan permata regency ', '6285385667794', 'Aktif', 0, '', '', 1748318429, 'PPPOE', 'permataregency_veve', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 103, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (427, 'Nina hidayati', '105020222', 'ninahidayati@bytehome.id', '25-05-23', 5, 'Jl Walikota Gatot GG 10 ', '6285259137515', 'Aktif', 0, '', '', 1748318570, 'PPPOE', 'jlgatot_nina', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 191, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (428, 'Fatah Jati Pamungkas', '105010166', 'fatahjati@bytehome.id', '25-05-23', 5, 'Jl Damai gg 3', '6281212472488', 'Aktif', 0, '', '', 1748319142, 'PPPOE', 'jldamai_fatah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 9, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (429, 'Abdul Ajiz', '105020223', 'abdulajizz@bytehome.id', '25-05-24', 5, 'JL Panglima Sudirman ', '6289526503856', 'Aktif', 0, '', '', 1748319476, 'PPPOE', 'jlpangsud_ajiz', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 152, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (430, 'Wigit Ganda', '105020224', 'wigitganda@bytehome.id', '25-05-24', 5, 'Jl Mt Haryono gg X', '6285234192783', 'Aktif', 0, '', '', 1748319610, 'PPPOE', 'jlmtharyono_wigit', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 119, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (431, 'Umar', '105030041', 'umardsnslamet@bytehome.id', '25-05-24', 5, 'Dsn Slamet Bantaran ', '62895351037212', 'Aktif', 0, '', '', 1748319735, 'PPPOE', 'dsnslamet_umar', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 185, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (432, 'Moh Maulana Abas', '105030042', 'maulanaabas@bytehome.id', '25-05-26', 5, 'Tempuran Bantaran ', '6282323930987', 'Aktif', 0, '', '', 1748321760, 'PPPOE', 'tempuran_abas', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 5, 175, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (433, 'Moch Irsyad', '105020225', 'mochirsyad@bytehome.id', '25-05-26', 5, 'JL Ikan dorang', '62895334136296', 'Aktif', 0, '', '', 1748322783, 'PPPOE', 'jlikandorang_irsyad', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 63, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (434, 'Sulika', '105050001', 'sulika4@bytehome.id', '25-05-29', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '6285847897420', 'Aktif', 0, '', '', 1749702128, 'PPPOE', 'gunungtugel_sulika', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 137, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (435, 'Wafia', '105050002', 'wafia@bytehome.id', '25-05-28', 5, 'Dsn. Makan Ds. Curahtulis', '6281252450365', 'Aktif', 0, '', '', 1749702319, 'PPPOE', 'curahtulis_wafia', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 136, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (436, 'Nur Ainainatil Ilwin', '105050003', 'nurainainatililwin@bytehome.id', '25-05-29', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '6281555988235', 'Aktif', 0, '', '', 1749702657, 'PPPOE', 'gunungtugel_ilwin', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 174, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (437, 'Agung Martono', '105050004', 'agungmartono@bytehome.id', '25-05-29', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '6281238046615', 'Aktif', 0, '', '', 1749702813, 'PPPOE', 'gunungtugel_agung', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 175, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (438, 'Anisatul Hasanah', '105050005', 'anisatulhasanah@bytehome.id', '25-05-29', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '6285791254825', 'Aktif', 0, '', '', 1749702977, 'PPPOE', 'gunungtugel_anisatul', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1026, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (439, 'Mustakim', '105050006', 'mustakim3@bytehome.id', '25-05-29', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '6285855828814', 'Aktif', 0, '', '', 1749703149, 'PPPOE', 'gunungtugel_mustakim', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1010, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (440, 'Samsul Qomarudin', '105050007', 'samsulqomarudin@bytehome.id', '25-05-29', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '6281252765936', 'Aktif', 0, '', '', 1749703309, 'PPPOE', 'gunungtugel_samsul', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 165, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (441, 'Fadila', '105050008', 'fadila@bytehome.id', '25-05-30', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '6281904683081', 'Aktif', 0, '', '', 1749703766, 'PPPOE', 'gunungtugel_fadila', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (442, 'Sunarianto', '105050009', 'sunarianto@bytehome.id', '25-06-09', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '085731749391', 'Aktif', 0, '', '', 1749805196, 'PPPOE', 'gunungtugel_sunapianto', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1004, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (443, 'Muhammad Taufik', '105030043', 'muhammadtaufik@bytehome.id', '25-05-27', 5, 'Jl Raya Bantaran ', '6289616371989', 'Non-Aktif', 0, '', '', 1750469833, 'PPPOE', 'jlrayabantaran_taufik', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 185, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (444, 'Andik Kuswanto', '105020226', 'andikkuswanto@bytehome.id', '25-05-28', 5, 'Jl Dr Sutomo ', '6285648868491', 'Aktif', 0, '', '', 1750469994, 'PPPOE', 'jldrsutomo_andik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 54, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (445, 'Retno Dwi Winarni', '105020227', 'retno@bytehome.id', '25-05-28', 5, 'Jl Arif Rahman Hakim', '6285236439000', 'Aktif', 0, '', '', 1750470170, 'PPPOE', 'jlarif_retno', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 213, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (446, 'Sanadi', '105010167', 'sanadi@bytehome.id', '25-06-29', 5, 'Munengkidul ', '62881038021439', 'Aktif', 0, '', '', 1750470320, 'PPPOE', 'munengkidul_sanadi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 162, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (447, 'Lutfi Alvian', '105020228', 'lutfialvian@bytehome.id', '25-05-29', 5, 'Jl Serma Abdurrahman ', '6281231924545', 'Aktif', 0, '', '', 1750470511, 'PPPOE', 'jlserma_lutfi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 214, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (448, 'Yayuk Timur Rahayu', '105030044', 'yayuktimur@bytehome.id', '25-06-29', 5, 'JL Mayangan Bantaran ', '6282315780871', 'Aktif', 0, '', '', 1750470654, 'PPPOE', 'jlmayangan_yayuk', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 153, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (449, 'Rizky putra febriansyah', '105010168', 'rizkyputra@bytehome.id', '25-06-29', 5, 'Terminal Bayuangga ', '6281249007347', 'Aktif', 0, '', '', 1750476915, 'PPPOE', 'terminal_rizky', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 215, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (450, 'Siti Mudrika', '105010169', 'mudrika@bytehome.id', '25-06-30', 5, 'Jl Damai Ketapang', '6282259999075', 'Aktif', 0, '', '', 1750477096, 'PPPOE', 'jldamai_mudrika', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 9, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (451, 'Mohammad Yazif Shola Khuddin', '105020229', 'yazif@bytehome.id', '25-05-30', 5, 'Jl Gubernur Suryo GG Johar', '6285156898257', 'Aktif', 0, '', '', 1750485824, 'PPPOE', 'jlgubernur_yazif', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 216, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (452, 'Nazwa Nurnaina Putri', '105020230', 'nazwaa@bythome.id', '25-06-01', 5, 'Jl Cangkring GG 2 ', '6285257994934', 'Aktif', 0, '', '', 1750485988, 'PPPOE', 'cangkring_nazwa', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 104, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (453, 'Ayu Tri Purwanti', '105010170', 'ayutri@bytehome.id', '25-06-02', 5, 'Perum Kopian', '6281235134144', 'Aktif', 0, '', '', 1750487362, 'PPPOE', 'kopian_ayu', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 3, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (454, 'Mailatul Hasanah', '105010171', 'mailatul@bytehome.id', '25-06-02', 5, 'Dsn Blobo Banjarsari', '6285330833546', 'Non-Aktif', 0, '', '', 1750487623, 'PPPOE', 'dsnblobo_mailatul', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'EXPIRED', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 218, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (455, 'Iis Rahmawati', '105010172', 'iisrahmawati@bytehome.id', '25-06-02', 5, 'Lemahkembar Tanah Merah ', '6282332505478', 'Aktif', 0, '', '', 1750487804, 'PPPOE', 'lemahkembar_iis', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 132, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (456, 'Dedik Wahyu', '105020231', 'dedikwahyu@bytehome.id', '25-06-03', 5, 'Jl Panglima Sudirman', '6285697102848', 'Aktif', 0, '', '', 1750487953, 'PPPOE', 'jlpangsud_dedik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 172, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (457, 'Moch Adi Wijayansyah', '105030045', 'adiwijayansyah@bytehome.id', '25-06-03', 5, 'JL.Kenanga Bantaran ', '6281359365812', 'Aktif', 0, '', '', 1750488705, 'PPPOE', 'jlkenanga_adi', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 217, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (458, 'Deven linuar aria', '105030046', 'devenn@bytehome.id', '25-06-03', 5, 'Jl Wijaya Kusuma', '6281215763386', 'Aktif', 0, '', '', 1750488881, 'PPPOE', 'jlwijaya_deven', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 131, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (459, 'Moch Ferry', '105020232', 'ferry@bytehome.id', '25-06-04', 5, 'JL LUMAJANG ', '6285755583710', 'Aktif', 0, '', '', 1750489685, 'PPPOE', 'jllumajang_ferry', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 219, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (460, 'Titik Indriani', '105020233', 'titikindriani@bytehome.id', '25-06-04', 5, 'Jl melon Kedopok', '6281216129345', 'Aktif', 0, '', '', 1750489838, 'PPPOE', 'jlmelon_titik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 220, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (461, 'Diah Ayu Fajarwati', '105010173', 'diahayu@bytehome.id', '25-06-04', 5, 'Perum Kopian', '6281331265636', 'Aktif', 0, '', '', 1750491555, 'PPPOE', 'kopian_diah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 83, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (462, 'Abdurrahman Wahid', '105020234', 'wahidd@bytehome.id', '25-06-05', 5, 'Jl Sunan Bonang ', '082140201659', 'Aktif', 0, '', '', 1750492437, 'PPPOE', 'jlsunanbonanang_abdurrahmanwahid', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 221, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (463, 'Desi Tri Yuliana', '105010174', 'desitri@bytehome.id', '25-06-05', 5, 'Munengkidul ', '6285785085055', 'Aktif', 0, '', '', 1750493820, 'PPPOE', 'munengkidul_desitri', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 222, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (464, 'Yoga Pratama', '105030047', 'yoga@bytehome.id', '25-06-05', 5, 'Tempuran Bantaran ', '6282243372318', 'Aktif', 0, '', '', 1750493948, 'PPPOE', 'tempuran_yoga', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 208, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (465, 'Dwi Angga Setyawan', '105020235', 'dwiangga@bytehome.id', '25-06-07', 5, 'Jl Cangkring GG 5 ', '6285649219979', 'Non-Aktif', 0, '', '', 1750494060, 'PPPOE', 'cangkring_angga', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 209, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (466, 'Syahbyl  Dimasky', '105020236', 'syahbyl@bytehome.id', '25-06-07', 5, 'Jl Walikotagatot ', '62881036093497', 'Aktif', 0, '', '', 1750494238, 'PPPOE', 'jlgatot_syahbyl', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 191, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (467, 'Veri Fatur Juni Ardiansyah', '105020237', 'veryfatur@bytehome.id', '25-06-07', 5, 'Jl Cangkring Gg 5', '6282245143745', 'Aktif', 0, '', '', 1750494449, 'PPPOE', 'cangkring_veri', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 223, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (468, 'Sundari', '105020238', 'sundariii@bytehome.id', '25-06-07', 5, 'GG PESANTREN', '6282237003005', 'Aktif', 0, '', '', 1750494703, 'PPPOE', 'ggpesantren_sundari', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 224, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (469, 'Agus Sugiono', '105050010', 'agussugiono@bytehome.id', '25-06-19', 5, 'Gunung Tugel ', '6285646674335', 'Aktif', 0, '', '', 1750645775, 'PPPOE', 'gunungtugel_agus', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 156, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (470, 'Moch Mirwan Wahyudi', '105020239', 'mirwan@bytehome.id', '25-06-08', 5, 'Kebonsari Kulon Gg Kenongo', '6285234663355', 'Aktif', 0, '', '', 1750650401, 'PPPOE', 'ggkenongo_mirwan', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 88, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (471, 'Paiman', '105020240', 'paimannnn@bytehome.id', '25-06-08', 5, 'Jl Panglima sudirman', '085735069562', 'Aktif', 0, '', '', 1750650976, 'PPPOE', 'jlpangsud_paiman', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 90, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (472, 'Hartatik Yuliana', '105010175', 'hartatikpro@bytehome.id', '25-06-09', 5, 'Rusunawa', '62881026961916', 'Aktif', 0, '', '', 1750651451, 'PPPOE', 'rusunawa_yuliana', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 20, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (473, 'Disy ismandana', '105020241', 'disy@bytehome.id', '25-06-10', 5, 'Jl Pangsud GG 9 ', '6281455091593', 'Non-Aktif', 0, '', '', 1750651717, 'PPPOE', 'jlpangsud_disy', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 165, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (474, 'Rasya Alif kumara', '105010176', 'rasyaalif@bytehome.id', '25-06-10', 5, 'perum sumbertaman indah ', '6289520166101', 'Aktif', 0, '', '', 1750651867, 'PPPOE', 'sumbertaman_rasya', 0, 5, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 225, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (475, 'Suyono', '105010177', 'suyonooo@bytehome.id', '25-06-10', 5, 'Jl Cempaka Sukabumi', '6282143804663', 'Aktif', 0, '', '', 1750652088, 'PPPOE', 'jlcempaka_suyono', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 98, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (476, 'Robbil Izzati', '105010178', 'robbiizzati@bytehome.id', '25-06-11', 5, 'Jl Pisang Sumberwetan ', '6282210466141', 'Aktif', 0, '', '', 1750652318, 'PPPOE', 'jlpisang_robbil', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 204, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (477, 'M. Qomaruddin', '105020242', 'qomaruddin@bythome.id', '25-06-11', 5, 'Kebonsari kulon GG.Bingkilan', '6281336228177', 'Aktif', 0, '', '', 1750652481, 'PPPOE', 'ggbingkilan_qomaruddin', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 115, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (478, 'Adi Kurniawan', '105020243', 'adikurniawan@bytehome.id', '25-06-12', 5, 'Perum Cisadane ', '6287711812935', 'Aktif', 0, '', '', 1750652601, 'PPPOE', 'cisadane_adi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 35, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (479, 'Siti rohma', '105010179', 'sitirohmaaa@bytehome.id', '25-06-12', 5, 'Triwungkidul ', '62895346263626', 'Aktif', 0, '', '', 1750652748, 'PPPOE', 'triwungkidul_rohma', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 205, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (480, 'Dewi Wulandari', '105010180', 'dewiwulandari@bytehome.id', '25-06-12', 5, 'Curahgrinting Kurnia Land ', '6289509884774', 'Aktif', 0, '', '', 1750653195, 'PPPOE', 'curahgrinting_dewi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 226, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (481, 'Meridianti', '105010181', 'meridianti@bytehome.id', '25-06-13', 5, 'Jl Kaliamas', '6287754427132', 'Aktif', 0, '', '', 1750653312, 'PPPOE', 'jlkaliamas_merdianti', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 168, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (482, 'Ubaydillah arifin', '105030048', 'ubaydillah@bytehome.id', '25-06-14', 5, 'Legundi Bantaran ', '082338804620', 'Aktif', 0, '', '', 1750653426, 'PPPOE', 'legundi_ubaydillah', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 227, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (483, 'Slamet Hariyanto', '105030049', 'slamethariyantooooo@bytehome.id', '25-06-14', 5, 'Legundi Bantaran ', '6285204228213', 'Aktif', 0, '', '', 1750653655, 'PPPOE', 'legundi_slamet', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 227, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (484, 'Yuni Astuti', '105020244', 'yuniastuti@bytehome.id', '25-06-14', 5, 'Perum Kartika ', '6281350990280', 'Aktif', 0, '', '', 1750653764, 'PPPOE', 'perumkartika_yuni', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 49, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (485, 'Syamsul Arifin', '105030050', 'syamsularifinpro@bytehome.id', '25-06-14', 5, 'Legundi Bantaran ', '6282336171854', 'Aktif', 0, '', '', 1750653900, 'PPPOE', 'legundi_syamsul', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 5, 228, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (487, 'Laetitia everesta', '105020245', 'laetitia@bytehome.id', '25-06-14', 5, 'Jl Cangkring Gg 3 ', '6285646511891', 'Aktif', 0, '', '', 1750654140, 'PPPOE', 'cangkring_laetitia', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 149, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (488, 'Maksum Efendi', '105020246', 'maksumefendii@bytehome.id', '25-06-15', 5, 'Jl Imam Bonjol ', '6289654128878', 'Aktif', 0, '', '', 1750654253, 'PPPOE', 'jlimambonjol_maksum', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 55, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (489, 'Hannan Badri', '105030051', 'hananbadripro@bytehome.id', '25-06-17', 5, 'Patokan Bantaran ', '6285727807560', 'Aktif', 0, '', '', 1750654367, 'PPPOE', 'patokan_hanan', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 155, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (490, 'Bunari', '105030052', 'mashabi@bytehome.id', '25-06-18', 5, 'Tempuran Bantaran ', '682332554540', 'Aktif', 0, '', '', 1750654817, 'PPPOE', 'tempuran_bunari', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 0, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 229, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (491, 'Mas Habi', '105010182', 'mashabiiii@bytehome.id', '25-06-18', 5, 'Jl Pisang Sumberwetan ', '6282332554540', 'Aktif', 0, '', '', 1750655025, 'PPPOE', 'jlpisang_mashasbi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 230, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (492, 'Saifullah Sholeh', '105010183', 'hasbullahsoleh@bytehome.id', '25-06-18', 5, 'Jl Pisang Sumberwetan ', '6285257723678', 'Aktif', 0, '', '', 1750655127, 'PPPOE', 'jlpisang_hasbullah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 230, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (493, 'Dedy Zamroni', '105020247', 'dedyzamroni@bytehome.id', '25-06-19', 5, 'GG Rajawali Kebonsari Kulon ', '6285895009286', 'Aktif', 0, '', '', 1750655287, 'PPPOE', 'ggrajawali_dedy', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 231, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (494, 'Riko Tri Surahman', '105020248', 'rikotriii@bytehome.id', '25-06-19', 5, 'Jl Mastrip Wonoasih ', '6285258167888', 'Aktif', 0, '', '', 1750655445, 'PPPOE', 'jlmastrip_riko', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 16, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (495, 'Zakiyatul Fakhiroh', '105020249', 'zakiyatulfakhiroh@bytehome.id', '25-06-19', 5, 'Perum Grandhilton ', '628962843985', 'Aktif', 0, '', '', 1750655733, 'PPPOE', 'grandhilton_zakiyatul', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 39, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (496, 'M Najib Nailul', '105010184', 'najibnailul@bytehome.id', '25-06-19', 5, 'Jl Merbabu ', '6282233480800', 'Aktif', 0, '', '', 1750656385, 'PPPOE', 'jlmerbabu_najib', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 1, 205000, '', 0, '', 0, 3, 32, 8, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (497, 'Anis Nurhasanih', '105010185', 'anisnurhasanih@bytehome.id', '25-06-19', 5, 'Jl Bengawan Solo ', '6281510850781', 'Aktif', 0, '', '', 1750656532, 'PPPOE', 'jlbengawansolo_anis', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 32, 8, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (498, 'Syaifullah', '105020250', 'syaifullahproling@bytehome.id', '25-06-21', 5, 'Jl Abdul Hamid ', '6281276829001', 'Aktif', 0, '', '', 1750753729, 'PPPOE', 'jlabdhamid_syaifullah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 41, 8, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (499, 'Kasim', '105010186', 'kasimmm@bytehome.id', '25-06-20', 5, 'Jl Himalaya ', '6285232836723', 'Aktif', 0, '', '', 1750753873, 'PPPOE', 'jlhimalaya_kasim', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 113, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (500, 'Irene Abelia Ismail', '105010187', 'ireneabelia@bytehome.id', '25-06-20', 5, 'Jl Ijen Pilang GG 1', '6282338596830', 'Aktif', 0, '', '', 1750825426, 'PPPOE', 'pilang_irene', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 233, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (501, 'Subianto', '105020251', 'subianto@bytehome.id', '25-06-21', 5, 'Jl Cangkring ', '6289507911644', 'Aktif', 0, '', '', 1750825869, 'PPPOE', 'cangkring_subianto', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 104, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (502, 'Abdul Muiz', '105010188', 'abdulmuiz@bytehome.id', '25-06-22', 5, 'Blok Pasar Kademangan', '6285211744277', 'Aktif', 0, '', '', 1750826169, 'PPPOE', 'blokpasar_muiz', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 27, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (503, 'Novan Kurniawan', '105020252', 'novankurniawan@bytehome.id', '25-06-22', 5, 'JL.KH.abdul Azis Kebonsari ', '6282142951335', 'Aktif', 0, '', '', 1750826310, 'PPPOE', 'jlabdulaziz_novan', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 145, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (504, 'Moh.Adrian Alvarizi', '105030053', 'adrianalvarizi@bytehome.id', '25-06-23', 5, 'Jl Mayangan Bantaran ', '6282335612245', 'Aktif', 0, '', '', 1750826611, 'PPPOE', 'jlmayangan_adrian', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 153, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (505, 'La Ode Muhammad', '105020253', 'laode@bytehome.id', '25-06-23', 5, 'Perum Asabri', '6285233415555', 'Aktif', 0, '', '', 1750826888, 'PPPOE', 'asabri_laode', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 4, 183, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (506, 'Dwi Lestari', '105020254', 'dwilestaripro@bytehome.id', '25-06-23', 5, 'Jl Ikan Tongkol ', '6285134977993', 'Aktif', 0, '', '', 1750827579, 'PPPOE', 'jlikantongkol_dwi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 67, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (507, 'Sulvia Tri Utami', '105020255', 'sulviatri@bytehome.id', '25-06-24', 5, 'Jl Panglima Sudirman', '62895414180096', 'Aktif', 0, '', '', 1750906561, 'PPPOE', 'jlpangsud_sulvia', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 12, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (508, 'Estuning arum', '105020256', 'estuning@bytehome.id', '25-06-24', 5, 'GG Siran Kebonsari kulon ', '6285198158786', 'Aktif', 0, '', '', 1750906680, 'PPPOE', 'ggsiran_estuning', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 234, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (509, 'Chusnul Rohma', '105030054', 'chusnul@bytehome.id', '25-06-24', 5, 'Jl Kauman Bantaran ', '6282334838791', 'Aktif', 0, '', '', 1750906809, 'PPPOE', 'jlkauman_chusnul', 0, 7, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 217, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (510, 'Ulul Azmi', '105010189', 'ululazmiprooo@bytehome.id', '25-06-10', 5, 'Ketapang probolinggo', '6285806252740', 'Aktif', 0, '', '', 1750910397, 'PPPOE', 'ketapang_ulul', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 232, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (511, 'RM Kancis', '105020257', 'kancispro@bytehome.id', '25-06-21', 5, 'Jl Gubernur Suryo ', '6285710159672', 'Aktif', 0, '', '', 1750913934, 'PPPOE', 'jlgubernursuryo_kancis', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 235, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (512, 'Abdul Halim', '105010190', 'abdulhalimpro@bytehome.id', '25-06-25', 5, 'Dsn Blobo Banjarsari ', '6281234397789', 'Non-Aktif', 0, '', '', 1750922703, 'PPPOE', 'dsnblobo_abdulhalim', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 236, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (513, 'Moh Havid', '105020258', 'havidprooo@bytehome.id', '25-06-26', 5, 'Jl Amir Hamzah ', '6285655961139', 'Aktif', 0, '', '', 1750922811, 'PPPOE', 'jlamirhamzah_havid', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 79, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (514, 'Yosi Fermansyah', '105020259', 'yosifermansyah@bytehome.id', '25-06-26', 5, 'Jl lumajang', '6281217958123', 'Aktif', 0, '', '', 1750924043, 'PPPOE', 'jlpriksan_yosi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 123, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (515, 'Elis Rahmawati', '105020260', 'elisrahmawati@bytehome.id', '25-06-26', 5, 'GG Siran Kebonsari kulon ', '6285233748226', 'Aktif', 0, '', '', 1750996442, 'PPPOE', 'ggsiran_elis', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 234, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (516, 'Suparman', '105020261', 'suparmanpro@bytehome.id', '25-06-27', 5, 'GG Karya Bakti', '6285259525889', 'Aktif', 0, '', '', 1752291495, 'PPPOE', 'karyabakti_sudirman', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 234, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (517, 'ILYAS', '105020262', 'ilyaspro@bytehome.id', '25-06-28', 5, 'Jl Panglima Sudirman ', '6289516359340', 'Aktif', 0, '', '', 1752291929, 'PPPOE', 'jlpangsud_ilyas', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 90, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (518, 'Siti NurJannah', '105030055', 'sitinurjannah@bytehome.id', '25-06-29', 5, 'Tempuran Bantaran ', '6281573138810', 'Aktif', 0, '', '', 1752292108, 'PPPOE', 'tempuran_nurjannah', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 175, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (519, 'Mustika', '105030056', 'mustikapro@bytehome.id', '25-06-29', 5, 'Tempuran Bantaran', '6281215605335', 'Aktif', 0, '', '', 1752292296, 'PPPOE', 'tempuran_mustika', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 229, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (520, 'Abdirto', '105010191', 'abdirto@bytehome.id', '25-06-30', 5, 'Jl Himalaya', '628561950431', 'Aktif', 0, '', '', 1752461427, 'PPPOE', 'jlhimalaya_abdirto', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 238, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (521, 'Wulandari', '105020263', 'wulandariproling@bytehome.id', '25-06-30', 5, 'Jl Sultan Agung', '6282245110648', 'Aktif', 0, '', '', 1752462182, 'PPPOE', 'jlsultanagung_wulandari', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 18, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (522, 'Khoirul Umam', '105030057', 'khoirulumamproling@bytehome.id', '25-07-01', 5, 'Tempuran Bantaran ', '6285233764430', 'Aktif', 0, '', '', 1752462443, 'PPPOE', 'tempuran_khoirul', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 5, 239, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (523, 'Rofiudin ali wardana', '105020264', 'rofiudinali@bytehome.id', '25-07-01', 5, 'Jl Lumajang ', '6282132833419', 'Aktif', 0, '', '', 1752462649, 'PPPOE', 'jllumajang_rofiudin', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 237, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (524, 'Iffa Camelia', '105020265', 'iffacamelia@bytehome.id', '25-07-02', 5, 'Kh Hasan GG Melati ', '6289518895984', 'Aktif', 0, '', '', 1752462847, 'PPPOE', 'ggmelati_iffa', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 112, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (525, 'Abu Bakar', '105020266', 'abubakarproling@bytehome.id', '25-07-02', 5, 'Jl Kyai Anom ', '6281235433078', 'Aktif', 0, '', '', 1752463036, 'PPPOE', 'jlkyaianom_abubakar', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 240, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (526, 'Laila Afkarina', '105020267', 'lailaafkarinaa@bytehome.id', '25-07-02', 5, 'Jl Kyai Anom ', '6285333829864', 'Aktif', 0, '', '', 1752463192, 'PPPOE', 'jlkyaianom_laila', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 240, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (527, 'Anik Rimbawati', '105020268', 'anikrimbawatiproling@bytehome.id', '25-07-03', 5, 'jlmastrip', '6282334808240', 'Aktif', 0, '', '', 1752464966, 'PPPOE', 'jlmastrip_anikk', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 245, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (528, 'Prisal Pratama Putra', '105020269', 'prisalpratamaputra@bytehome.id', '25-07-04', 5, 'Jl Lumajang ', '6289517695752', 'Aktif', 0, '', '', 1752465085, 'PPPOE', 'jllumajang_prisal', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 237, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (529, 'Dwi Devi', '105030058', 'dwidevipro@bytehome.id', '25-07-04', 5, 'Jl Mayangan Bantaran ', '6282250385567', 'Aktif', 0, '', '', 1752467853, 'PPPOE', 'jlmayangan_dwidevi', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 153, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (530, 'Eka Anang', '105010192', 'ekaanangpro@bytehome.id', '25-07-05', 5, 'Perum Himalaya GG.1B', '6281246658508', 'Aktif', 0, '', '', 1752467968, 'PPPOE', 'jlhimalaya_ekanang', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 241, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (531, 'Achmad Sutomo', '105030059', 'achmadsutomopro@bytehome.id', '25-07-07', 5, 'Patokan Bantaran ', '6285259093877', 'Aktif', 0, '', '', 1752468139, 'PPPOE', 'patokan_sutomo', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 242, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (532, 'Tukri', '105030060', 'tukriproling@bytehome.id', '25-07-08', 5, 'Kaporan Bantaran ', '6283114427763', 'Aktif', 0, '', '', 1752468474, 'PPPOE', 'kaporan_tukri', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 5, 242, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (533, 'Ayu Wulandari', '105030061', 'ayuwulandaripro@bytehome.id', '25-07-08', 5, 'Dsn Kaporan Bantaran ', '6285855144828', 'Aktif', 0, '', '', 1752468658, 'PPPOE', 'kaporan_ayu', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 0, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 242, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (534, 'Fran Nur cahyo', '105020270', 'franurcahyo@bytehome.id', '25-07-08', 5, 'Jl Cangkring GG 2 ', '6282354577782', 'Aktif', 0, '', '', 1752468773, 'PPPOE', 'cangkring_fran', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 104, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (535, 'Yusfi Effendi', '105020271', 'yusfipro@bytehome.id', '25-07-08', 5, 'Jrebenglor ', '6285236648725', 'Aktif', 0, '', '', 1752468869, 'PPPOE', 'jrebenglor_yusfi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 68, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (536, 'Anisa Maulidia', '105030062', 'anisamaulidia@bytehome.id', '25-07-09', 5, 'Dsn Kaporan Bantaran ', '6289502440100', 'Aktif', 0, '', '', 1752468970, 'PPPOE', 'kaporan_anisa', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 242, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (537, 'Sri Patmiati', '105020272', 'sripatmiatipro@bytehome.id', '25-07-09', 5, 'Jl Walikota Gatot GG XI', '6285231458423', 'Aktif', 0, '', '', 1752469219, 'PPPOE', 'jlgatot_patmiati', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 244, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (538, 'Toyyib', '105030063', 'toyyibproling@bytehome.id', '25-07-09', 5, 'Tempuran Bantaran ', '6285234987465', 'Aktif', 0, '', '', 1752469335, 'PPPOE', 'tempuran_toyyib', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 5, 229, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (539, 'Andrian Darma Oktaviano', '105010193', 'andriandarma@bytehome.id', '25-07-09', 5, 'Jl Flamboyan Pilang ', '6285785455088', 'Non-Aktif', 0, '', '', 1752469458, 'PPPOE', 'pilang_adrian', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 87, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (540, 'Rinda Dwi', '105020273', 'rindadwipro@bytehome.id', '25-07-10', 5, 'Jl Panglima Sudirman ', '6285234020351', 'Aktif', 0, '', '', 1752469605, 'PPPOE', 'jlpangsud_rinda', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 90, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (541, 'Endang Sulistiowati', '105020274', 'endangproling@bytehome.id', '25-07-10', 5, 'Jl Panglima Sudirman ', '6285141024397', 'Non-Aktif', 0, '', '', 1752469760, 'PPPOE', 'jlpangsud_endang', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 90, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (542, 'Siti Salamah Ningsih', '105050011', 'sitisalamahningsih@bytehome.id', '25-07-01', 5, 'Jl Perning Dusun Jalit Ds. Tongaswetan', '6285230834531', 'Aktif', 0, '', '', 1752477914, 'PPPOE', 'tongaswetan_salamah', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 164, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (543, 'Misbahul Munir', '105050012', 'misbahulmunir00@bytehome.id', '25-07-01', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '6282139558426', 'Aktif', 0, '', '', 1752478564, 'PPPOE', 'dungun_misbahul', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 154, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (544, 'Sohib', '105050013', 'sohib4@bytehome.id', '25-07-01', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '6282335525995', 'Aktif', 0, '', '', 1752479055, 'PPPOE', 'gunungtugel_sohib', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 169, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (545, 'Diah Aprilia', '105010194', 'diahapriliapro@bytehome.id', '25-07-10', 5, 'Jl Flamboyan Pilang gg 3', '6288989614325', 'Aktif', 0, '', '', 1752479543, 'PPPOE', 'pilang_diah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 87, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (546, 'Ashuri Salasa', '105030064', 'ashurisalasa@bytehome.id', '25-07-10', 5, 'Jl Mayangan Bantaran ', '6285236445930', 'Aktif', 0, '', '', 1752479708, 'PPPOE', 'jlmayangan_ashuri', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 153, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (547, 'Kartika', '105010195', 'kartikapro@bytehome.id', '25-07-10', 5, 'Asrama Zipur ', '628113600788', 'Aktif', 0, '', '', 1752479856, 'PPPOE', 'zipur_kartika', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 290000, '', 0, '', 0, 3, 131, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (548, 'Titik sumaryati', '105010196', 'titiksumaryati@bytehome.id', '25-07-12', 5, 'Jl Bengawan Solo ', '6282336679417', 'Aktif', 0, '', '', 1752480624, 'PPPOE', 'jlbengawansolo_titik', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 28, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (549, 'Zumrotul Warda Al Choiriyah', '105050014', 'zumrotulwarda@bytehome.id', '25-07-02', 5, 'Dsn. Pohgosong Ds. Tongas Kulon', '62895326168617', 'Aktif', 0, '', '', 1752485376, 'PPPOE', 'pohgosong_zumrotul', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 167, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (550, 'Titik Marmiati', '105050015', 'titikmarmiati@bytehome.id', '25-07-10', 5, 'Dsn. Krajan Ds. Dungun Tongas nguling', '6282141258287', 'Aktif', 0, '', '', 1752719881, 'PPPOE', 'dunguntongas_titik', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 174, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (551, 'Sri Mandayati', '105050016', 'srimandayati@bytehome.id', '25-07-10', 5, 'Dsn. Krajan Ds. Bayeman Tongas', '6285259725223', 'Aktif', 0, '', '', 1752721397, 'PPPOE', 'bayeman_srimanda', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 120, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (552, 'Yeni Wijayati', '105050017', 'yeniwijayati@bytehome.id', '25-07-15', 5, 'Dsn. Guung Tugel Ds. Curahtulis', '6281549740296', 'Aktif', 0, '', '', 1752739494, 'PPPOE', 'gunungtugel_yeni', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1655, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (553, 'Ongky Riski ashari', '105010197', 'ongkyproling@bytehome.id', '25-07-11', 5, 'Jl Bengawan Solo GG Merpati ', '6285259700418', 'Aktif', 0, '', '', 1753075242, 'PPPOE', 'ggmerpati_ongky', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 246, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (554, 'Gofur Abdul', '105010198', 'gofurabdul@bytehome.id', '25-07-11', 5, 'Jl Citarum ', '6282139919569', 'Aktif', 0, '', '', 1753075410, 'PPPOE', 'jlcitarum_ghofur', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 50Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 3, 247, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (555, 'Asih Wahyu', '105020275', 'asihwahyu@bytehome.id', '25-07-11', 5, 'JL Ikan hiu Mayangan ', '89665334524', 'Non-Aktif', 0, '', '', 1753076031, 'PPPOE', 'jlikanhiu_asih', 0, 6, 1, 'KTP', 10, 0, 62, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 158, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (556, 'Belfa Juaria', '105020276', 'belfajuaria@bytehome.id', '25-07-12', 5, 'Jl Sunan Muria ', '6289699782565', 'Aktif', 0, '', '', 1753076239, 'PPPOE', 'jlsunanmuria_belfa', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 59, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (557, 'Desi Amalia', '105020277', 'desiamalia@bytehome.id', '25-07-13', 5, 'Jl Kh Ahmad dahlan ', '6285210631689', 'Aktif', 0, '', '', 1753076500, 'PPPOE', 'jlkhahmaddahlan_desi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 115, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (558, 'Abd Jabir', '105030065', 'abdjabir@bytehome.id', '25-07-14', 5, 'Jl Mayangan Bantaran ', '6285257822554', 'Aktif', 0, '', '', 1753076607, 'PPPOE', 'jlmayangan_jabir', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 153, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (559, 'Putri Wulandari', '105030066', 'putriwulandari@bytehome.id', '25-07-15', 5, 'Kaporan Bantaran ', '6283136340024', 'Aktif', 0, '', '', 1753077047, 'PPPOE', 'kaporan_putri', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 242, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (560, 'Sholehudin', '105020278', 'sholehudin@bytehome.id', '25-07-15', 5, 'Jl Ikan Tongkol ', '62895322547890', 'Aktif', 0, '', '', 1753077378, 'PPPOE', 'jlikantongkol_sholehudin', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 61, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (561, 'Novita Triana', '105020279', 'novitaproling@bytehome.id', '25-07-16', 5, 'Jl Kh Ahmad dahlan ', '6289520228447', 'Aktif', 0, '', '', 1753080373, 'PPPOE', 'jlkhahmaddahlan_novita', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 115, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (562, 'Dede Permana', '105020280', 'dedepermana@bytehome.id', '25-07-16', 5, 'Jl Lingkar Utara ', '6285285498357', 'Aktif', 0, '', '', 1753080550, 'PPPOE', 'jllingkarutara_dede', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 136, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (563, 'Lina Andriati', '105020281', 'linaandriati@bytehome.id', '25-07-16', 5, 'Jl Teuku Umar ', '6289621274608', 'Aktif', 0, '', '', 1753081085, 'PPPOE', 'jlteukuumar_lina', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 96, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (564, 'M Haerul', '105030067', 'haerulpro@bytehome.id', '25-07-17', 5, 'Kaporan Bantaran ', '6282337082112', 'Non-Aktif', 0, '', '', 1753081239, 'PPPOE', 'kaporan_haerul', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 242, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (565, 'Sariyani', '105010199', 'sariyaniproling@bytehome.id', '25-07-18', 5, 'Jl Citarum ', '62895351065687', 'Non-Aktif', 0, '', '', 1753081587, 'PPPOE', 'jlcitarum_sariyani', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 10, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (566, 'Mukarroma Tunnisak', '105010200', 'mukarroma@bytehome.id', '25-07-18', 5, 'Triwungkidul ', '6287740963755', 'Aktif', 0, '', '', 1753083275, 'PPPOE', 'triwungkidul_mukarroma', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 171, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (567, 'Alfia Wardani', '105030068', 'alfiawardani@bytehome.id', '25-07-19', 5, 'Kaporan Bantaran ', '6288989857078', 'Aktif', 0, '', '', 1753083636, 'PPPOE', 'kaporan_alifia', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 242, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (568, 'Rian Novia Sandy', '105050018', 'riannoviasandy@bytehome.id', '25-07-18', 5, 'Pasar Bayeman Tongas', '6285230761485', 'Aktif', 0, '', '', 1753086293, 'PPPOE', 'bayeman_rian', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 104, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (569, 'Muftakul Ulum', '105050019', 'muftakululum@bytehome.id', '25-07-19', 5, 'Dsn. Kulak Utara Ds. Wringinanom', '6285736123082', 'Aktif', 0, '', '', 1753088096, 'PPPOE', 'Waringinanom_muftakul', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '50 Mbps', 1, 0, 1, 0, 0, 205000, '', 0, '', 0, 2, 1, 122, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (570, 'Sherli Dwi Agustin', '105010201', 'sherliproling@bytehome.id', '25-07-08', 5, 'Jl Argopuro ', '6285233828080', 'Aktif', 0, '', '', 1753321891, 'PPPOE', 'jlargopuro_sherli', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 243, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (571, 'Adi Pandowo', '105020282', 'adipandowo@bytehome.id', '25-07-14', 5, 'Pelabuhan Baru', '6282265557622', 'Aktif', 0, '', '', 1753322678, 'PPPOE', 'pelabuhanbaru_adi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 248, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (572, 'Senemah', '105020283', 'sanemahproling@bytehome.id', '25-07-14', 5, 'Pelabuhan Baru', '6281225909035', 'Aktif', 0, '', '', 1753322914, 'PPPOE', 'pelabuhanbaru_senemah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 248, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (573, 'Rian Novia Sandy - garasi', '105050020', 'riannoviasandy0@bytehome.id', '25-07-22', 5, 'Bayeman Tongas Garasi Depan Rumah', '6285230761485', 'Aktif', 0, '', '', 1753323607, 'PPPOE', 'bayeman_novia', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 103, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (574, 'Abdul Hamid', '105020284', 'abdulhamidproling@bytehome.id', '25-07-15', 5, 'Pelabuhan Baru', '6282265557622', 'Aktif', 0, '', '', 1753323772, 'PPPOE', 'pelabuhanbaru_abdulhamid', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 248, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (575, 'Samaudi', '105020285', 'samaudipro@bytehome.id', '25-07-17', 5, 'Jl Mastrip', '6285258830752', 'Aktif', 0, '', '', 1753323935, 'PPPOE', 'jlmastrip_samaudi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 249, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (576, 'Umar Faruk', '105020286', 'umarfarukproling@bytehome.id', '25-07-17', 5, 'Jrebengkulon ', '6285878000559', 'Aktif', 0, '', '', 1753324179, 'PPPOE', 'jrebengkulon_umar', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 250, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (577, 'Ach Dani Holili', '105050021', 'achdaniholili@bytehome.id', '25-07-23', 5, 'JL. Perning Dusun Jalit Ds. Tongaswetan', '6282110443909', 'Aktif', 0, '', '', 1753324787, 'PPPOE', 'tongaswetan_dani', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 284, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (578, 'Riyadhus zubaidah', '105010202', 'riyadhus@bytehome.id', '25-07-21', 5, 'Jl Raya Bromo ', '6285156078196', 'Aktif', 0, '', '', 1753340987, 'PPPOE', 'jlbromo_riyadhus', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 171, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (579, 'Siska Yuni Dwi', '105020287', 'siskayunidwi@bytehome.id', '25-07-21', 5, 'Jl Porong', '6285165717788', 'Non-Aktif', 0, '', '', 1753341130, 'PPPOE', 'jlporong_siska', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 48, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (580, 'Satugi Widodo', '105010203', 'satugiwidodo@bytehome.id', '25-07-21', 5, 'JL Soekarno hatta Gg Delima', '6285258790664', 'Aktif', 0, '', '', 1753341269, 'PPPOE', 'ggdelima_satugi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 134, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (581, 'Rhandika Jaka', '105020288', 'rhadikajaka@bytehome.id', '25-07-21', 5, 'Jl Letjen Suprapto ', '6289615696087', 'Aktif', 0, '', '', 1753341739, 'PPPOE', 'jlletjen_rhandika', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 96, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (582, 'Tio San Hauw', '105020289', 'tiosanhauw@bytehome.id', '25-07-21', 5, 'Jl Letjen Suprapto ', '6282332453465', 'Aktif', 0, '', '', 1753341908, 'PPPOE', 'jlletjen_tiosan', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 96, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (583, 'Christina Dewi', '105010204', 'christinadewi@bytehome.id', '25-07-21', 5, 'Perum Kopian Barat ', '6287721181802', 'Aktif', 0, '', '', 1753342141, 'PPPOE', 'kopian_christina', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 3, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (584, 'Ade Pramono', '105010205', 'adepramono@bytehome.id', '25-07-22', 5, 'Rusunawa Semeru ', '6281215849411', 'Aktif', 0, '', '', 1753343433, 'PPPOE', 'rusunawa_ade', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 20, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (585, 'Babussalam', '105030069', 'Babussalam@bytehome.id', '25-07-22', 5, 'Tempuran Bantaran ', '6285204234286', 'Aktif', 0, '', '', 1753343979, 'PPPOE', 'tempuran_babussalam', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 240, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (586, 'Zalipa', '105010206', 'zalipa@bytehome.id', '25-07-22', 5, 'Jl Flamboyan ', '62895334139677', 'Aktif', 0, '', '', 1753344288, 'PPPOE', 'jlflamboyan_zalipa', 0, 6, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 210, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (587, 'Umar Sholeh', '105010207', 'umarsholeh@bytehome.id', '25-07-22', 5, 'Dsn Krajan Triwungkidul ', '6285297046632', 'Aktif', 0, '', '', 1753346077, 'PPPOE', 'dsnkrajan_umar', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 138, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (588, 'Maulana Habib', '105020290', 'maulanapro@bytehome.id', '25-07-23', 5, 'jlbogowonto', '6285187816709', 'Aktif', 0, '', '', 1753346484, 'PPPOE', 'jlbogowonto_maulana', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 99, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (589, 'Qodir', '105020291', 'qodirproling@bytehome.id', '25-07-22', 5, 'Jl Ikan Banyar ', '62895325847937', 'Aktif', 0, '', '', 1753409683, 'PPPOE', 'jlikanbanyar_qodir', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 63, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (590, 'Rosa Amelia Putri', '105020292', 'rosaameliaproling@bytehome.id', '25-07-19', 5, 'JL Anggur ', '62881027862859', 'Aktif', 0, '', '', 1753409845, 'PPPOE', 'jlanggur_rosa', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 251, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (591, 'Mas Aldi Faisal', '105030070', 'masaldipro@bytehome.id', '25-07-23', 5, 'Kedungsupit ', '6285137752155', 'Aktif', 0, '', '', 1753410022, 'PPPOE', 'kedungsupit_masaldi', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 254, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (592, 'Ghufron Zaini', '105030071', 'ghufronzaini@bytehome.id', '25-07-24', 5, 'Kramat Agung ', '6282225831954', 'Aktif', 0, '', '', 1753410181, 'PPPOE', 'kramatagung_ghufron', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 252, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (593, 'Endang Sunarsih', '105010208', 'endangsunarsihpro@bytehome.id', '25-07-25', 5, 'Muneng', '6285349361247', 'Aktif', 0, '', '', 1753668843, 'PPPOE', 'muneng_endang', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 257, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (594, 'Susi Susanti', '105020293', 'susisusantipro@bytehome.id', '25-07-26', 5, 'Jl Mastrip', '6282293720764', 'Aktif', 0, '', '', 1753669056, 'PPPOE', 'jlmastrip_susi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 255, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (595, 'Rizki Ramadhani', '105050022', 'rizkiramadhani@bytehome.id', '25-07-28', 5, 'Jl. Perning Dsn. Jalid Ds. Tongaswetan', '6285804032945', 'Aktif', 0, '', '', 1754875163, 'PPPOE', 'tongaswetan_rizki', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 53, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (596, 'Agung Sedayu', '105050023', 'agungsedayu@bytehome.id', '25-07-29', 5, 'Dsn. Jalit Jl. Raya Tongas Ds. Tongas Wetan', '6285257789909', 'Aktif', 0, '', '', 1754877376, 'PPPOE', 'tongaswetan_agung', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 78, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (597, 'Nali', '105050024', 'nali@bytehome.id', '25-07-30', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '6285258842980', 'Aktif', 0, '', '', 1754881276, 'PPPOE', 'gunungtugel_nali', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 136, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (598, 'M. Hermanto', '105050025', 'm.hermanto@bytehome.id', '25-08-01', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '6282228891119', 'Aktif', 0, '', '', 1754886605, 'PPPOE', 'gunungtugel_hermanto', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 117, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (599, 'Dheo Aprilianto Sulistyo', '105050026', 'dheoapriliantosulistyo@bytehome.id', '25-08-11', 5, 'Dsn. Krajan Ds. Bayeman Tongas', '6282257548071', 'Aktif', 0, '', '', 1755052011, 'PPPOE', 'bayeman_dheo', 0, 1, 1, 'KTP', 16, 0, 0, '', '', '15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 161, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (600, 'Khoteb Ahmad', '105050027', 'khotebahmad@bytehome.id', '25-08-15', 5, 'Pondok Tahfidul Qur\'an An-Nur Wringinanom', '6285259597778', 'Aktif', 0, '', '', 1755648966, 'PPPOE', 'wringinanom_khoteb', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 2, 1, 50, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (601, 'Elsa Oktavia', '105050028', 'elsaoktavia@bytehome.id', '25-08-23', 5, 'Dsn. Kulak Selatan Ds. Wringinanom', '6285707965303', 'Aktif', 0, '', '', 1756091385, 'PPPOE', 'wringinanom_elsa', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 87, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (602, 'Wulandari', '105010209', 'wulandariketapang@bytehome.id', '25-08-08', 5, 'Jl Raya Bromo Ketapang ', '6285606364943', 'Aktif', 0, '', '', 1756092547, 'PPPOE', 'ketapang_wulan', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 7, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (603, 'Tolhal Alfariz', '105010210', 'tolhahh@bytehome.id', '25-08-28', 5, 'Jl Kalimas ', '6283830560540', 'Non-Aktif', 0, '', '', 1756092811, 'PPPOE', 'jlkaliamas_tolhah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 168, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (604, 'Prisal', '105020294', 'prisalpro@bytehome.id', '25-08-28', 5, 'Jl Lumajang ', '6289517695752', 'Aktif', 0, '', '', 1756093441, 'PPPOE', 'jllumajang_pratama', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 237, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (605, 'Slamet Raharjo', '105020295', 'slametraharjo@bytehome.id', '25-08-28', 5, 'Jl Lumajan', '6285930922318', 'Aktif', 0, '', '', 1756093674, 'PPPOE', 'jllumajang_slamet', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 237, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (606, 'M Ainul Yaqin', '105010211', 'ainulyaqinpro@bytehome.id', '25-08-28', 5, 'JL Soekarno hatta ', '62895326984444', 'Aktif', 0, '', '', 1756093880, 'PPPOE', 'jlsoekarno_ainul', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 10, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (607, 'Pranata Hendra', '105010212', 'pranatahendra@bytehome.id', '25-07-29', 5, 'Pilang Permai ', '6285745427713', 'Aktif', 0, '', '', 1756097427, 'PPPOE', 'pilang_pranata', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 12, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (608, 'Yulia Widiastuti', '105010213', 'yuliawidiastuti@bytehome.id', '25-07-29', 5, 'JL Soekarno hatta ', '6281335876488', 'Aktif', 0, '', '', 1756097585, 'PPPOE', 'jlsoekarno_yulia', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 26, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (609, 'Lenny Novianti', '105010214', 'lennynovianti@bytehome.id', '25-08-30', 5, 'Jl Supriyadi Kaademangan', '6283870048833', 'Non-Aktif', 0, '', '', 1756103175, 'PPPOE', 'jlsupriyadi_lenny', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 26, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (610, 'Zize mefilia', '105020296', 'zizemefilia@bytehome.id', '25-07-30', 5, 'JL Pattimura', '6285215413483', 'Aktif', 0, '', '', 1756103326, 'PPPOE', 'jlpattimura_zize', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 141, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (611, 'Robby', '105010215', 'robbyproling@bytehome.id', '25-07-31', 5, 'Pilang ', '6289652165965', 'Aktif', 0, '', '', 1756103929, 'PPPOE', 'pilang_robby', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 53, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (612, 'Bagas Trio', '105020297', 'bagastrio@bytehome.id', '25-07-31', 5, 'Jl Panglima Sudirman ', '6287755750439', 'Aktif', 0, '', '', 1756105534, 'PPPOE', 'jlpangsud_bagas', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 91, 13, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (613, 'Latifa', '105030072', 'latifapro@bytehome.id', '25-08-03', 5, 'Kaporan Bantaran ', '6281332908854', 'Aktif', 0, '', '', 1756105909, 'PPPOE', 'kaporan_latifa', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 192, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (614, 'Srimawati', '105030073', 'srimawati@bytehome.id', '25-08-04', 5, 'Jl Raya Bantaran ', '6285735117955', 'Aktif', 0, '', '', 1756106041, 'PPPOE', 'jlrayabantaran_srimawati', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 187, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (615, 'Sutaji', '105010216', 'sutajipro@bytehome.id', '25-08-04', 5, 'Munengkidul ', '6285257290354', 'Aktif', 0, '', '', 1756106164, 'PPPOE', 'munengkidul_sutaji', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 162, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (616, 'Rofikatul Hidayah', '105010217', 'rofikatulhidayah@bytehome.id', '25-08-05', 5, 'Dsn Blobo Banjarsari ', '6283197760008', 'Aktif', 0, '', '', 1756106285, 'PPPOE', 'dsnblobo_rofikatul', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 218, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (617, 'Siti Maryani', '105010218', 'sitimaryani@bytehome.id', '25-08-05', 5, 'Jl Flamboyan GG 1 ', '6281336821122', 'Aktif', 0, '', '', 1756106656, 'PPPOE', 'jlflamboyan_maryani', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 87, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (618, 'Havid Julianto', '105010219', 'havidjulianto@bytehome.id', '25-08-05', 5, 'Jl Kalimas ', '6282245999783', 'Aktif', 0, '', '', 1756106892, 'PPPOE', 'jlkalimas_havid', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 168, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (619, 'Samsul Arifin', '105010220', 'samsularifinpro@bytehome.id', '25-08-05', 5, 'Dsn Krajan Triwungkidul ', '6285234640244', 'Aktif', 0, '', '', 1756107364, 'PPPOE', 'dsnkrajan_arifin', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 138, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (620, 'Sugianto', '105010221', 'sugiantoprolingbgt@bytehome.id', '25-08-07', 5, 'Pilang ', '6282332505478', 'Aktif', 0, '', '', 1756107716, 'PPPOE', 'tanahmerah_sugianto', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 132, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (621, 'Hadi Slamet', '105030074', 'hadiproling@bytehome.id', '25-08-07', 5, 'Patokan Bantaran ', '6285648165307', 'Aktif', 0, '', '', 1756107932, 'PPPOE', 'patokan_hadi', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 154, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (622, 'Sumarni', '105010222', 'sumarniproling@bytehome.id', '25-08-07', 5, 'Tanah Merah Lemah Kembar', '6285231662834', 'Aktif', 0, '', '', 1756108194, 'PPPOE', 'tanahmerah_sumarni', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 132, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (623, 'Romy', '105020298', 'romyprolingasli@bytehome.id', '25-08-07', 5, 'Jl Dr Soetomo ', '6285165656879', 'Aktif', 0, '', '', 1756108764, 'PPPOE', 'jldrsoetomo_romi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 194, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (624, 'Sahri', '105010223', 'sahriproling@bytehome.id', '25-08-08', 5, 'Jl Pisang Sumberwetan ', '6283875489158', 'Aktif', 0, '', '', 1756109123, 'PPPOE', 'jlpisang_sahri', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 230, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (625, 'Hadi Sugiarto', '105020299', 'hadisugiarto@bytehome.id', '25-08-08', 5, 'Jl Abd Aziz', '6281234581996', 'Aktif', 0, '', '', 1756109249, 'PPPOE', 'jlabdaziz_hadi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 29, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (626, 'Syahroni', '105020300', 'syahronipro@bytehome.id', '25-08-09', 5, 'Jrebenglor ', '6289510090949', 'Aktif', 0, '', '', 1756109364, 'PPPOE', 'jrebenglor_syahroni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 70, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (627, 'Syamsul Arifin', '105020301', 'syamsulpro@bytehome.id', '25-08-11', 5, 'Perum Asabri', '6282338108873', 'Aktif', 0, '', '', 1756191829, 'PPPOE', 'asabri_syamsul', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 110, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (628, 'Abdullah', '105020302', 'abdullahproling@bytehome.id', '25-08-11', 5, 'Jl Ikan Tongkol ', '6281803706852', 'Aktif', 0, '', '', 1756196106, 'PPPOE', 'ggsusu_abdullah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 179, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (629, 'Subaktiyono', '105020303', 'subaktiyonoprp@bytehome.id', '25-08-15', 5, 'JL Ikan hiu Mayangan ', '6285231977826', 'Aktif', 0, '', '', 1756270464, 'PPPOE', 'jlikanhiu_Subaktiyono', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 158, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (630, 'Galang Prasetya', '105020304', 'galangprasetya@bytehome.id', '25-08-19', 5, 'Angguran ', '628976374280', 'Aktif', 0, '', '', 1756270652, 'PPPOE', 'angguran_galang', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 41, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (631, 'Khoyimi Kurni Yahya', '105020305', 'khoyimi@bytehome.id', '25-08-22', 5, 'Jl Bingkilan kebonsari wetan', '6282331844528', 'Aktif', 0, '', '', 1756270869, 'PPPOE', 'jlbingkilan_khoyimi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 115, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (632, 'Moch ishaq Subhianto', '105020306', 'ishaqpro@bytehome.id', '25-08-22', 5, 'Jl Porong Perumahan Grandhilton ', '6285742810589', 'Aktif', 0, '', '', 1756270996, 'PPPOE', 'jlporong_ishaq', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 39, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (633, 'Rudianto', '105030075', 'rudiantopro@bytehome.id', '25-08-23', 5, 'Kropak Bantaran ', '6282338539388', 'Aktif', 0, '', '', 1756271276, 'PPPOE', 'kropak_rudianto', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 229, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (634, 'M zakil Amin', '105020307', 'zakilaminpro@bytehome.id', '25-08-24', 5, 'Sumbertaman ', '6282337645011', 'Aktif', 0, '', '', 1756271582, 'PPPOE', 'jlbingkilan_zakil', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 237, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (635, 'Moh Roni Wijaya', '105020308', 'roniwijayapro@byteome.id', '25-08-27', 5, 'Sumbertaman ', '6285730478652', 'Aktif', 0, '', '', 1756271703, 'PPPOE', 'sumbertaman_roni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 237, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (636, 'Uswatun Khasanah', '105020309', 'uswatun@bytehome.id', '25-08-26', 5, 'Jl Sekar ', '6282132454106', 'Aktif', 0, '', '', 1756272071, 'PPPOE', 'jlsekar_uswatun', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 24, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (637, 'Aspuri', '105020310', 'aspurii@bytehome.id', '25-08-26', 5, ' JL.KH.Ahmad Dahlan', '6285259152005', 'Aktif', 0, '', '', 1756272233, 'PPPOE', 'jlkhahamaddahlan_aspuri', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 42, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (638, 'Ummi', '105020311', 'ummiprolingbgt@bytehome.id', '25-08-26', 5, 'Kantor Kementrian Agama Probolinggo ', '6285236063143', 'Aktif', 0, '', '', 1756272346, 'PPPOE', 'kemenag_ummi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 67, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (639, 'Devi', '105020312', 'deviprolinggg@bytehome.id', '25-08-27', 5, 'Jl Bogowonto ', '6285283747883', 'Aktif', 0, '', '', 1756282179, 'PPPOE', 'jlbogowonto_devi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 258, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (640, 'Moh Syahroni', '105030076', 'syahroniprolinggg@bytehome.id', '25-07-31', 5, 'Jl Raya Bantaran ', '6282277988900', 'Aktif', 0, '', '', 1756282314, 'PPPOE', 'jlrayabantaran_syahroni', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 260, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (641, 'Moh Sahlan', '105030077', 'sahlanproling@bytehome.id', '25-08-01', 5, 'Jl Raya Bantaran ', '6281336613730', 'Aktif', 0, '', '', 1756282507, 'PPPOE', 'jlrayabantaran_sahlan', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 260, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (642, 'Rosalinda', '105020313', 'rosalindapro@bytehome.id', '25-08-07', 5, 'Kebonsari GG Bayuusari ', '628979904132', 'Aktif', 0, '', '', 1756282635, 'PPPOE', 'kebonsari_rosalinda', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 264, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (643, 'Nanik', '105020314', 'nanikproling@bytehome.id', '25-08-07', 5, 'Jl Ikan Cumi-Cumi Mayangan', '6285169826393', 'Aktif', 0, '', '', 1756282736, 'PPPOE', 'jlikancumi_nanik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 167, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (644, 'Ahmad Havid Ramadhan', '105020315', 'havidramadhan@bytehome.id', '25-08-09', 5, 'Kedungasem ', '6282138017095', 'Aktif', 0, '', '', 1756282948, 'PPPOE', 'kedungasem_havid', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 265, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (645, 'M Ali Basya', '105030078', 'alibasya@bytehome.id', '25-08-12', 5, 'JL Raya Bantaran ', '6285204985469', 'Aktif', 0, '', '', 1756283058, 'PPPOE', 'jlrayabantaran_alibasya', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 266, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (646, 'Siti Aminah', '105020316', 'sitiaminahprolingg@bytehome.id', '25-08-14', 5, 'Jl Sunan Ampel ', '6281338917425', 'Aktif', 0, '', '', 1756283238, 'PPPOE', 'jlsunanampel_siti', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 268, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (647, 'Yuliatin', '105030079', 'yuliatinproling@bytehome.id', '25-08-14', 5, 'Tempuran Bantaran ', '6285313880735', 'Aktif', 0, '', '', 1756283381, 'PPPOE', 'tempuran_yuliatin', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 30Mbps', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 5, 269, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (648, 'Suliyati', '105020317', 'suliyatiproling@bytehome.id', '25-08-14', 5, 'Jl Buton Sukabumi ', '6285335667986', 'Aktif', 0, '', '', 1756283537, 'PPPOE', 'jlbuton_suliyati', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 270, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (649, 'M Bahyun', '105030080', 'bahyunpro@bytehome.id', '25-08-18', 5, 'Kropak Bantaran ', '6283827477698', 'Aktif', 0, '', '', 1756283712, 'PPPOE', 'kropak_bahyun', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 271, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (650, 'Saiho', '105030081', 'saihooo@bytehome.id', '25-08-21', 5, 'Dsn Bintaosan ', '6283136779622', 'Aktif', 0, '', '', 1756283836, 'PPPOE', 'dsnbintaosan_saiho', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 5, 272, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (651, 'Suhan', '105030082', 'suhanproling@bytehome.id', '25-08-23', 5, 'Kropak Bantaran ', '6285232112126', 'Aktif', 0, '', '', 1756284024, 'PPPOE', 'kropak_suhan', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 272, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (652, 'Rinto Boy', '105010224', 'rintoboy@bytehome.id', '25-08-01', 5, 'Jl Citarum ', '6285234422666', 'Aktif', 0, '', '', 1756385179, 'PPPOE', 'jlcitarum_rinto', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 261, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (653, 'Sulaimi', '105010225', 'sulaimipro@bytehome.id', '25-08-02', 5, 'Lemahkembar Tanah Merah', '6285608115800', 'Aktif', 0, '', '', 1756385301, 'PPPOE', 'lemahkembar_sulaimi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 0, 0, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (655, 'Rudi Hartono', '105010227', 'rudiharpro@bytehome.id', '25-08-11', 5, 'Jl Cempaka Sukabumi', '6282333979186', 'Aktif', 0, '', '', 1756428017, 'PPPOE', 'cempaka_rudi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 98, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (656, 'Zakaria Effendi', '105010228', 'zakariaefendipro@bytehome.id', '25-08-11', 5, 'Jl citarum ', '6281335698448', 'Aktif', 0, '', '', 1756428651, 'PPPOE', 'jlcitarum_zakaria', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 0, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (657, 'Akbar Sukma', '105010229', 'akbarsukmapro@bytehome.id', '25-08-12', 5, 'Jl citarum ', '6285608942550', 'Aktif', 0, '', '', 1756428759, 'PPPOE', 'jlcitarum_akbar', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 267, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (658, 'Muhammad Ali', '105010230', 'muhammadalipro@bytehome.id', '25-08-15', 5, 'Munengkidul ', '6283869644326', 'Aktif', 0, '', '', 1756428857, 'PPPOE', 'munengkidul_ali', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 162, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (659, 'Frysat Wahyudepyanto', '105010231', 'frysat@bytehome.id', '25-08-19', 5, 'Jl Citarum ', '628563451616', 'Aktif', 0, '', '', 1756428947, 'PPPOE', 'jlcitarum_frysat', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 170, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (660, 'Aryo Ponco Nugraha', '105010232', 'aryoponco@bytehome.id', '25-08-19', 5, 'Jl soekarno Hatta ', '6281249630000', 'Aktif', 0, '', '', 1756429087, 'PPPOE', 'jlsoekarno_aryo', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 10, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (661, 'Devinda Syahada', '105020318', 'devindasyahada@bytehome.id', '25-08-20', 5, 'Jl Pattimura', '6283846813875', 'Aktif', 0, '', '', 1756432596, 'PPPOE', 'jlpattimura_devinda', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 275, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (662, 'Achmad Dardiri', '105010233', 'achmaddaridiri@bytehome.id', '25-08-21', 5, 'Ketapang ', '6282142930036', 'Aktif', 0, '', '', 1756432756, 'PPPOE', 'ketapang_dardiri', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 180, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (663, 'Yuni Wulandari', '105020319', 'yuniwulandaripro@bytehome.id', '25-08-22', 5, 'Jl Mastrip GG 11 ', '6289530118471', 'Aktif', 0, '', '', 1756432877, 'PPPOE', 'jlmastrip_yuni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 274, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (664, 'Rudi Prasetyo', '105010234', 'rudiprasetyapro@bytehome.id', '25-08-23', 5, 'Jl Wijaya Kusuma', '6285649917118', 'Aktif', 0, '', '', 1756433042, 'PPPOE', 'jlwijayakusuma_rudi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 44, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (665, 'Bebun', '105010235', 'bebunpro@bytehome.id', '25-08-25', 5, 'Mentor ', '6285138511882', 'Aktif', 0, '', '', 1756433558, 'PPPOE', 'mentor_bebun', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 263, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (666, 'Iis', '105010236', 'iistriwung@bytehome.id', '25-08-25', 5, 'Triwungkidul ', '6285732382230', 'Aktif', 0, '', '', 1756433712, 'PPPOE', 'triwung_iis', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 20, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (667, 'Shalsabila Nurannisah', '105010237', 'Shalsabilapro@bytehome.id', '25-08-26', 5, 'Jl Citarum ', '6287749553677', 'Non-Aktif', 0, '', '', 1756433832, 'PPPOE', 'jlcitarum_shalsabila', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 170, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (668, 'Puji Arif', '105010238', 'pujiarifpro@bytehome.id', '25-08-26', 5, 'Dusun Kalicangka Mentor', '6281323117024', 'Aktif', 0, '', '', 1756434215, 'PPPOE', 'mentor_puji', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 276, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (669, 'Panji Buana Putra', '105010239', 'panjibuanapro@bytehome.id', '25-09-27', 5, 'Munengkidul ', '6289696292532', 'Aktif', 0, '', '', 1758594567, 'PPPOE', 'munengkidul_panji', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 162, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (670, 'Siti Sulaiha', '105030083', 'sitisulaihap@bytehome.id', '25-09-27', 5, 'Dsn Timbangan Jl Raya Bantaran ', '6285231189437', 'Aktif', 0, '', '', 1758594794, 'PPPOE', 'dsntimbangan_sulaiha', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 163, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (671, 'Achmad Sadikin', '105020320', 'sadikinpro@bytehome.id', '25-09-27', 5, 'Kebonsari Kulon ', '6285606095374', 'Aktif', 0, '', '', 1758594913, 'PPPOE', 'kebonsari_sadikin', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 223, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (672, 'Fitri Wahyuningsih', '105020321', 'fitriproling@bytehome.id', '25-09-28', 5, 'Jl Cangkring GG 2 ', '6282335315764', 'Aktif', 0, '', '', 1758595096, 'PPPOE', 'cangkring_fitri', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 104, 8, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (673, 'Asriyati', '105020322', 'asriyatipro@bytehome.id', '25-09-28', 5, 'JL.sunan Ampel jrebeng lor', '6282229954018', 'Aktif', 0, '', '', 1758595345, 'PPPOE', 'jrebenglor_asriyati', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 202, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (674, 'Titik Indriani', '105020323', 'titikpro@bytehome.id', '25-09-28', 5, 'Jl Cokroaminoto ', '6281216129345', 'Aktif', 0, '', '', 1758596640, 'PPPOE', 'jlcokro_titik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 130, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (675, 'Yuliana', '105010240', 'yulianaproling@bytehome.id', '25-09-30', 5, 'Jl Himalaya GG 9 A ', '6281249316635', 'Aktif', 0, '', '', 1758596974, 'PPPOE', 'jlhimalaya_yuliana', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 113, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (676, 'Ryan metalyano', '105010241', 'metalyono@bytehome.id', '25-08-30', 5, 'Jl Bendi ', '6285234964686', 'Aktif', 0, '', '', 1758597227, 'PPPOE', 'jlbendi_ryan', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 159, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (677, 'Misto', '105020324', 'mistoproling@bytehome.id', '25-09-30', 5, 'Jrebenglor ', '6289532546273', 'Aktif', 0, '', '', 1758597386, 'PPPOE', 'jrebenglor_Misto', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 201, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (678, 'Ryanika Rosanty Dewi', '105020325', 'ryanikaproling@bytehome.id', '25-09-01', 5, 'JL.KH.genggong', '6285231834400', 'Aktif', 0, '', '', 1758597645, 'PPPOE', 'genggong_Ryanika', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 210, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (679, 'Edy Riyanto', '105020326', 'edyriyantopro@bytehome.id', '25-09-02', 5, 'Perum Grandhilton  ', '6282257833330', 'Aktif', 0, '', '', 1758597818, 'PPPOE', 'grandhilton_edy', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 39, 8, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (680, 'Yuda indra putra', '105010242', 'yudaindra@bytehome.id', '25-09-02', 5, 'Sumurmati ', '6282143438087', 'Aktif', 0, '', '', 1758601034, 'PPPOE', 'sumurmati_yuda', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 276, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (681, 'Kiyoshi Bernhardy Galviien', '105020327', 'kiyoshipro@bytehome.id', '25-09-03', 5, 'Jl Musi', '628155029510', 'Aktif', 0, '', '', 1758601134, 'PPPOE', 'jlmusi_kiyoshi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 226, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (682, 'Istiqma', '105010243', 'istiqmapro@bytehome.id', '25-09-03', 5, 'Jl Wijaya Kusuma', '6281217853938', 'Aktif', 0, '', '', 1758601352, 'PPPOE', 'jlwijayakusuma_istiqma', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 43, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (683, 'Lili', '105030084', 'lilipro@bytehome.id', '25-09-03', 5, 'Bantaran ', '6283893545515', 'Aktif', 0, '', '', 1758601597, 'PPPOE', 'bantaran_lili', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 5, 192, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (684, 'Ismail', '105010244', 'Ismailpro@bytehome.id', '25-09-04', 5, 'JL Himalaya ', '6282335103039', 'Aktif', 0, '', '', 1758601925, 'PPPOE', 'jlhimalaya_ismail', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 241, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (685, 'Muhammad Danil', '105010245', 'danilmentor@bytehome.id', '25-09-05', 5, 'Mentor ', '6283877849228', 'Aktif', 0, '', '', 1758602095, 'PPPOE', 'mentor_danil', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 207, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (686, 'Novian Mofatihul', '105020328', 'novianpro@bytehome.id', '25-09-05', 5, 'Jl Cangkring ', '6288803675155', 'Aktif', 0, '', '', 1758602361, 'PPPOE', 'cangkring_novian', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 104, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (687, 'Endah Puji Lestari', '105010246', 'endahpujipro@bytehome.id', '25-09-08', 5, 'Jl Wijaya Kusuma ', '6282140642828', 'Aktif', 0, '', '', 1758602578, 'PPPOE', 'jlwijayakusuma_endah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 44, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (688, 'Solihin', '105010247', 'solihinnnn@bytehome.id', '25-09-08', 5, 'Jl Himalaya', '6282234483388', 'Aktif', 0, '', '', 1758603016, 'PPPOE', 'jlhimalaya_solihin', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 198, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (689, 'Suhartiwik', '105020329', 'suhartiwikpro@bytehome.id', '25-09-10', 5, 'Jl Genggong ', '6289518725587', 'Aktif', 0, '', '', 1758603160, 'PPPOE', 'genggong_suhartiwik', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 142, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (690, 'Juwariyah', '105010248', 'juwariyahpro@bytehome.id', '25-09-11', 5, 'Jl Wijaya Kusuma', '6289612500900', 'Aktif', 0, '', '', 1758603310, 'PPPOE', 'jlwijayakusuma_juwariyah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 43, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (691, 'Indah Novita', '105020330', 'widodopro@bytehome.id', '25-09-11', 5, 'Jl Gatot Subroto ', '621391983259', 'Aktif', 0, '', '', 1758603467, 'PPPOE', 'gatsu_widodo', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 96, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (692, 'Velyza Yuniar Aliman', '105020331', 'velyzayuni@bytehome.id', '25-09-11', 5, 'Jl Ikan Cumi-Cumi Mayangan', '6282245143689', 'Aktif', 0, '', '', 1758603626, 'PPPOE', 'jlcumi_velyza', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 65, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (693, 'Anis putri rahmawati', '105020332', 'anisputri@bytehome.id', '25-09-11', 5, 'Jl Hasan Genggong ', '6282245151738', 'Aktif', 0, '', '', 1758604022, 'PPPOE', 'genggong_anis', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 142, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (694, 'Taufiq Hidayah', '105010249', 'taufiqhidayahpro@bytehome.id', '25-09-11', 5, 'JL Soekarno hatta Gg Delima', '6282334443187', 'Aktif', 0, '', '', 1758604166, 'PPPOE', 'ggdelima_taufiq', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 134, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (695, 'Sugeng', '105010250', 'sugengpro@bytehome.id', '25-09-14', 5, 'Jl Ikan Paus ', '6282132075281', 'Aktif', 0, '', '', 1758604377, 'PPPOE', 'jlikanpaus_sugeng', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 64, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (696, 'Sagi Harianto', '105020333', 'sagiharianto@bytehome.id', '25-09-15', 5, 'Jl Cangkring ', '6283861092862', 'Aktif', 0, '', '', 1758604483, 'PPPOE', 'cangkring_sagi', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 104, 10, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (697, 'Nurhayati', '105030085', 'nurhayatipro@bytehome.id', '25-09-15', 5, 'Legundi Bantaran ', '6283831820270', 'Aktif', 0, '', '', 1758604774, 'PPPOE', 'legundi_nurhayati', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 227, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (698, 'Brian Rasya Efendi', '105010251', 'brianrasya@bytehome.id', '25-09-16', 5, 'Jl Dr Wahidin ', '628813268557', 'Aktif', 0, '', '', 1758605146, 'PPPOE', 'jldrwahidin_brian', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 166, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (699, 'Amir Mahmud', '105030086', 'amirmahmud@bytehome.id', '25-09-15', 5, 'Kropak Bantaran ', '6285330062692', 'Aktif', 0, '', '', 1758605667, 'PPPOE', 'kropak_amir', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 175, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (700, 'Fiti Fira Andriana', '105010252', 'fififira@bytehome.id', '25-09-17', 5, 'GG Delima Pilang ', '85213242989', 'Aktif', 0, '', '', 1758605793, 'PPPOE', 'ggdelima_fira', 0, 5, 1, 'KTP', 17, 0, 62, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 134, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (701, 'Gerinata', '105020334', 'gerinatapro@bytehome.id', '25-09-17', 5, 'Jl Teuku Umar ', '6281235972999', 'Aktif', 0, '', '', 1758605919, 'PPPOE', 'teukuumar_gerinata', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 96, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (702, 'Diva Yosafatana', '105010253', 'divaprooo@bytehome.id', '25-09-18', 5, 'Jl Flamboyan ', '6283185807052', 'Aktif', 0, '', '', 1758606053, 'PPPOE', 'jlflamboyan_diva', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 87, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (703, 'Mistarum', '105020335', 'mistarum@bytehome.id', '25-09-18', 5, 'Jl Ikan Tongkol ', '6287753897245', 'Aktif', 0, '', '', 1758606383, 'PPPOE', 'jlikantongkol_mistarum', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 67, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (704, 'Habibah yahya', '105020336', 'habibahyahya@bytehome.id', '25-09-19', 5, 'Jl MT Haryono', '6285735064696', 'Aktif', 0, '', '', 1758606499, 'PPPOE', 'mthryono_habibah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 96, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (705, 'Devi Natalia', '105010254', 'devinataliapro@bytehome.id', '25-09-19', 5, 'Jl Brantas ', '6285165717833', 'Aktif', 0, '', '', 1758606634, 'PPPOE', 'jlbrantas_devi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 25, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (706, 'Marfuah', '105020337', 'marfuahpro@bytehome.id', '25-09-21', 5, 'Bridgen Katamso ', '6283890974473', 'Aktif', 0, '', '', 1758607008, 'PPPOE', 'bridgenkatamso_marfuah', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 119, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (707, 'Wihastini', '105010255', 'wihastinipro@bytehome.id', '25-09-28', 5, 'Jl Himalaya ', '62895352653600', 'Aktif', 0, '', '', 1758695020, 'PPPOE', 'jlhimalaya_wihastini', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 277, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (708, 'Sri Utami', '105010256', 'sriutamipro@bytehome.id', '25-08-29', 5, 'Sumurmati ', '0', 'Aktif', 0, '', '', 1758695191, 'PPPOE', 'sumurmati_sriutami2', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 278, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (709, 'Ar Rosyid Bambang', '105010257', 'arrosyidp@bytehome.id', '25-08-29', 5, 'Sumurmati ', '6285257616270', 'Aktif', 0, '', '', 1758774456, 'PPPOE', 'sumurmati_arrosyid', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 278, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (710, 'Erni Rahmawati', '105010258', 'ernipro@bytehome.id', '25-09-30', 5, 'Sumurmati ', '6281522924514', 'Aktif', 0, '', '', 1758775095, 'PPPOE', 'sumurmati_erni', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 278, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (711, 'Sofiah Intan', '105010259', 'sofiahintanpro@bytehome.id', '25-09-04', 5, 'Triwunglor', '6282233896851', 'Aktif', 0, '', '', 1758775430, 'PPPOE', 'triwung_sofiah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 279, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (712, 'Djuwatin Utami', '105010260', 'djuwatinpro@bytehome.id', '25-09-05', 5, '', '6281357745153', 'Aktif', 0, '', '', 1758775601, 'PPPOE', 'sumurmati_djuwatin', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 280, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (713, 'Muhammad solehudin', '105020338', 'sholehudinpro@bytehome.id', '25-09-05', 5, 'Kedopok ', '6285649438657', 'Aktif', 0, '', '', 1758784131, 'PPPOE', 'kedopok_solehudin', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 281, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (714, 'Muhammad Muwafiq', '105020339', 'muwafiq@bytehome.id', '25-09-08', 5, 'Jl bengawan solo ', '6289670438801', 'Aktif', 0, '', '', 1758784233, 'PPPOE', 'bengawansolo_muwafiq', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 281, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (715, 'Rino Rahman', '105020340', 'rinorahman@bytehome.id', '25-09-09', 5, 'Jl Mastrip ', '6285735117955', 'Aktif', 0, '', '', 1758784338, 'PPPOE', 'jlmastrip_rino', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 282, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (716, 'Yudha Adi Permana', '105020341', 'yudhaadi@bytehome.id', '25-09-10', 5, 'Jl Letjen Suprapto ', '628977492098', 'Aktif', 0, '', '', 1758784448, 'PPPOE', 'jlletjen_yudha', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 283, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (717, 'Shantina Apsari', '105010261', 'shantinas@bytehome.id', '25-09-12', 5, 'Sumurmati ', '6282141492168', 'Aktif', 0, '', '', 1758784581, 'PPPOE', 'sumurmati_shantina', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 284, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (718, 'Lina Muryanti', '105020342', 'muryati@bytehome.id', '25-09-12', 5, 'Jl Cangkring ', '628994410302', 'Aktif', 0, '', '', 1758784780, 'PPPOE', 'cangkring_lina', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 104, 11, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (719, 'Adam Malik', '105020343', 'adammaliko@bytehome.id', '25-09-13', 5, 'Jl Pahlawan ', '6282214656661', 'Aktif', 0, '', '', 1758785347, 'PPPOE', 'jlpahlawan_adam', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 285, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (720, 'Moch Ragil Wahyu', '105010262', 'ragilwahyu@bytehome.id', '25-09-15', 5, 'Jl kalimas Posangit kidul', '6289601975312', 'Aktif', 0, '', '', 1758785557, 'PPPOE', 'jlkalimas_wahyu', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 286, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (721, 'Muhammad Ahsan', '105010263', 'ahsanbgt@bytehome.id', '25-09-17', 5, 'Dsn Lori Sumberasih', '6285337552653', 'Aktif', 0, '', '', 1758785790, 'PPPOE', 'dsnlori_ahsan', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 280, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (722, 'Muliani Kusuma Permadi', '105020344', 'mulianipro@bytehome.id', '25-09-20', 5, 'Sumbertaman', '6282131606970', 'Aktif', 0, '', '', 1758785985, 'PPPOE', 'sumbertaman_muliani', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 287, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (724, 'Siti Mahruma', '105010264', 'mahrumaa@bytehome.id', '25-09-20', 5, 'Sumberwetan ', '6283818458002', 'Aktif', 0, '', '', 1758786214, 'PPPOE', 'sumberwetan_mahruma', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 288, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (725, 'Didik Setiawan', '105010265', 'didiksett@bytehome.id', '25-09-22', 5, 'Jl Citarum', '6281232442519', 'Aktif', 0, '', '', 1758786328, 'PPPOE', 'jlcitarum_didik', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 289, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (726, 'Erfan Purwanto', '105020345', 'erfanpur@bytehome.id', '25-09-22', 5, 'Jl Dr Wahidin ', '6285258497521', 'Aktif', 0, '', '', 1758786440, 'PPPOE', 'jlwahidin_erfan', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 290, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (727, 'Siti Munawaroh', '105020346', 'munawarohb@bytehome.id', '25-09-23', 5, 'Jl Mastrip ', '6285319819472', 'Aktif', 0, '', '', 1758786549, 'PPPOE', 'jlmastrip_munawaroh', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 282, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (728, 'Heti Setyorini', '105010266', 'hetisetyorinipro@bytehome.id', '25-09-12', 5, 'Dsn Kalicangka Mentor ', '6283829608391', 'Aktif', 0, '', '', 1758789219, 'PPPOE', 'mentor_setyorini', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 291, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (729, 'Meliya Panca Pratiwi', '105040001', 'meliyayos@bytehome.id', '25-09-19', 5, 'Jl Yos Sudarso ', '6289657493995', 'Aktif', 0, '', '', 1758789376, 'PPPOE', 'jlyossudarso_meliya', 0, 121, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 8, 292, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (730, 'M sahur', '105030087', 'sahurpro@bytehome.id', '25-09-22', 5, 'Jl Kenanga Bantara ', '6282335492998', 'Aktif', 0, '', '', 1758789483, 'PPPOE', 'kenanga_sahur', 0, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 294, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (731, 'M khoirul nurusman', '105020347', 'khoirulpro@bytehome.id', '25-09-22', 5, 'Gg Priksan Wiroborang ', '62895334324598', 'Aktif', 0, '', '', 1758789585, 'PPPOE', 'priksan_khoirul', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 189, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (732, 'Kholilafatus Arofah', '105010267', 'arofahpro@bytehome.id', '25-09-23', 5, 'Jl Raya Sukapura', '6281357715227', 'Aktif', 0, '', '', 1758789704, 'PPPOE', 'jlrayasukapura_arofah', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 293, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (733, 'Imam Sutadji', '105050029', 'imamsutadji@bytehome.id', '25-09-24', 5, 'Jl. Perning Ds. Tongaswetan', '6281330272666', 'Aktif', 0, '', '', 1758859502, 'PPPOE', 'tongaswetan_imam', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (734, 'Syech Bafaqih', '105050030', 'syechbafaqih@bytehome.id', '25-09-24', 5, 'Dsn. Sumberan Ds. Dungun Tongas', '6281232146709', 'Aktif', 0, '', '', 1758869958, 'PPPOE', 'dungun_bafaqih', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (735, 'Rohim', '105050031', 'rohim2@pasuruannet.com', '25-09-24', 5, 'Dsn. Kulak Utara Ds. Wringinanom', '6285655611409', 'Aktif', 0, '', '', 1758871314, 'PPPOE', 'tongas_rohim', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 213, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (736, 'Alviani Masrohatul Ai\'niah', '105050032', 'alvianimasrohatul@bytehome.id', '25-09-24', 5, 'Dsn. Kulak Selatan Ds. Wringinanom', '628123280967', 'Aktif', 0, '', '', 1758872116, 'PPPOE', 'wringinanom_alviani', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (737, 'Adhi Ribut prakoso', '105010268', 'Adhiribut@bytehome.id', '25-09-25', 5, 'Jl Cempaka ', '628980522854', 'Aktif', 0, '', '', 1758940028, 'PPPOE', 'jlcempaka_adhi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 295, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (738, 'Dwi Bagus Fahroni', '105010269', 'fahroni@bytehome.id', '25-09-26', 5, 'Sumberwetan ', '6282234173406', 'Aktif', 0, '', '', 1758940131, 'PPPOE', 'sumberwetan_bagus', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 286, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (739, 'Nuriya', '105020348', 'nuriiyaa@bytehome.id', '25-09-26', 5, 'Jl Cangkring ', '081235234551', 'Aktif', 0, '', '', 1758940267, 'PPPOE', 'cangkring_nuriya', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 223, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (740, 'Inawati', '105020349', 'inawatipro@bytehome.id', '25-10-29', 5, 'Jl Ikan Cumi', '6282143561754', 'Aktif', 0, '', '', 1759736032, 'PPPOE', 'jlcumi_inawati', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 167, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (741, 'Ardianta', '105050033', 'ardianta@bytehome.id', '25-10-05', 5, 'Dsn. Krajan Kidul Ds. Curahdringu', '6282338993408', 'Aktif', 0, '', '', 1760498348, 'PPPOE', 'curahdringu_ardianta', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 0, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (742, 'Muhammad Bahtiar Rizki', '105050034', 'bahtiarrizki@bytehome.id', '25-10-06', 5, 'Wringinanom', '6282337667473', 'Aktif', 0, '', '', 1760512544, 'PPPOE', 'wringinanom_bahtiar', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (743, 'Solehudin Ardiansyah', '105050035', 'solehudinardiansyah@bytehome.id', '25-10-06', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '085792001793', 'Aktif', 0, '', '', 1760512745, 'PPPOE', 'gunungtugel_ardiansyah', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (744, 'Suemi Indah Wati', '105050036', 'suemiindahwati@bytehome.id', '25-10-13', 5, 'Tongas Dsn.Bayeman tengah', '6285800893271', 'Aktif', 0, '', '', 1760761532, 'PPPOE', 'bayeman_suemi', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 101, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (745, 'Khoirun Nisak', '105050037', 'khoirunnisak1@bytehome.id', '25-10-17', 5, 'Dsn. Krajan Kidul Ds. Curahdringu', '6285806736584', 'Aktif', 0, '', '', 1760931806, 'PPPOE', 'curahdringu_nisak', 0, 121, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 8, 292, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (746, 'Moch Choliq', '105020350', 'choliqprobb@bytehome.id', '25-09-28', 5, 'GG Siran Jl Abd Aziz ', '82302423675', 'Aktif', 0, '', '', 1761201979, 'PPPOE', 'ggsiran_choliq', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 88, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (747, 'Dewi Wahyuni', '105020351', 'dewilingkarutara@bytehome.id', '25-09-28', 5, 'Jl lingkar utara', '83875513425', 'Aktif', 0, '', '', 1761202351, 'PPPOE', 'jllingkarutara_wahyuni', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 126, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (748, 'Rendy Widi Susanto', '105020352', 'rendybogowonto@bytehome.id', '25-10-02', 5, 'Jl Bogownto ', '82313294256', 'Aktif', 0, '', '', 1761202580, 'PPPOE', 'jlbogowonto_rendy', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 258, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (749, 'Anang Mashadi', '105020353', 'anangmashadi@bytehome.id', '25-10-23', 5, 'Mayangan ', '88989258967', 'Aktif', 0, '', '', 1761202738, 'PPPOE', 'mayangan_mashadi', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 264, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (750, 'Mohammad Amin Sahbana', '105020354', 'aminsahbana@bytehome.id', '25-10-23', 5, 'Jl Kh Hasan Genggong ', '87871674488', 'Aktif', 0, '', '', 1761203426, 'PPPOE', 'jlhasan_amin', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 264, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (751, 'Halimatus Indahsyah', '105020355', 'halimatusprolingg@bytehome.id', '25-10-03', 5, 'Jl Bisri Samsuri Kebonsari Kulon ', '85204923366', 'Aktif', 0, '', '', 1761203707, 'PPPOE', 'kebonsarikulon_halimatuss', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 209, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (752, 'Moh Efendi', '105010270', 'efendipro@bytehome.id', '25-10-05', 5, 'Tangkuban perahu, Pilang ', '82142639841', 'Aktif', 0, '', '', 1761204283, 'PPPOE', 'pilang_efendi', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 0, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (753, 'Sulasmini', '105020356', 'sulasminipro@bytehome.id', '25-10-07', 5, 'Perum Gabriela ', '82140642828', 'Aktif', 0, '', '', 1761204549, 'PPPOE', 'gabriela_sulasmi', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 170, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (754, 'Desy Dwi', '105010271', 'desydwi@bytehome.id', '25-10-07', 5, 'Sumurmati ', '82332871483', 'Aktif', 0, '', '', 1761207086, 'PPPOE', 'sumurmati_desy', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 280, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (755, 'Suriyeh', '105010272', 'suriyeh@bytehome.id', '25-10-09', 5, 'Jl Ky Khasim Mas ', '82335768116', 'Aktif', 0, '', '', 1761208136, 'PPPOE', 'khasimmas_suriyeh', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 36, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (756, 'Muji As Ari', '105020357', 'mujiasari@bytehome.id', '25-10-10', 5, 'Jl Panglima Sudirman ', '85233783768', 'Aktif', 0, '', '', 1761208505, 'PPPOE', 'pangsud_muji', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 91, 14, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (757, 'Rendy Faisal Azis', '105010273', 'rendypro@bytehome.id', '25-10-13', 5, 'Jl Supriadi Kademangan ', '85155100168', 'Aktif', 0, '', '', 1761208705, 'PPPOE', 'jlsupriadi_rendy', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 182, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (758, 'Lukmanul Hakim', '105030088', 'lukmanulpro@bytehome.id', '25-10-13', 5, 'Legundi Bantaran ', '82312147103', 'Aktif', 0, '', '', 1761208995, 'PPPOE', 'legundi_hakim', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 266, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (759, 'Alifia Cindy Rahayu', '105020358', 'alifiaserma@bytehome.id', '25-10-13', 5, 'Jl Serma Abdurrahman ', '81331615076', 'Aktif', 0, '', '', 1761209518, 'PPPOE', 'jlserma_alifia', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 112, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (760, 'Ira Firoroh', '105010274', 'irafiroroh@bytehome.id', '25-10-14', 5, 'Mentor ', '85231901323', 'Aktif', 0, '', '', 1761270391, 'PPPOE', 'mentor_ira', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 207, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (761, 'Muhammad Arif', '105010275', 'arifpro@bytehome.id', '25-10-14', 5, 'Dsn Makmur ', '8983962874', 'Aktif', 0, '', '', 1761270583, 'PPPOE', 'dsnmakmur_arif', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 279, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (762, 'Samsul Hadi', '105010276', 'samsulhadipro@bytehome.id', '25-10-14', 5, 'Dsn Makmur Kademangan ', '81515438559', 'Aktif', 0, '', '', 1761270795, 'PPPOE', 'dsnmakmur_hadi', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 279, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (763, 'Misbahul Ulum', '105010277', 'misbahululumpro@bytehome.id', '25-10-14', 5, 'Gg Pesantren Jl Supriadi ', '85143411477', 'Aktif', 0, '', '', 1761270943, 'PPPOE', 'jlsupriadi_misbahul', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 182, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (764, 'Ari Purnomo', '105020359', 'aripurnomo@bytehome.id', '25-10-15', 5, 'Jl Kh Ahmad Dahlan ', '82334171258', 'Aktif', 0, '', '', 1761271405, 'PPPOE', 'ahmaddahlan_ari', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 285, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (765, 'Titin Chasana', '105020360', 'titinchasana@bytehome.id', '25-10-15', 5, 'Mayangan', '81216751508', 'Aktif', 0, '', '', 1761271612, 'PPPOE', 'mayangan_titin', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 158, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (766, 'Imam Syafii', '105020361', 'imamsyafiipro@bytehome.id', '25-10-15', 5, 'Jl Slamet riyadi', '81333090631', 'Aktif', 0, '', '', 1761271793, 'PPPOE', 'slametriyadi_imam', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 52, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (767, 'Kevin Aprianto', '105020362', 'kevinpangsud@bytehome.id', '25-10-18', 5, 'Jl Panglima Sudirman ', '85204232964', 'Aktif', 0, '', '', 1761271996, 'PPPOE', 'pangsud_kevin', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 90, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (768, 'Ummu Nisak', '105010278', 'ummunisak@bytehome.id', '25-10-19', 5, 'Rusunawa Semeru ', '82330301408', 'Aktif', 0, '', '', 1761272284, 'PPPOE', 'rusun_ummu', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 20, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (769, 'Mike Yuliana', '105020363', 'mikeyuliana@bytehome.id', '25-10-19', 5, 'Perum Pesona Bogownto ', '81330285982', 'Aktif', 0, '', '', 1761272600, 'PPPOE', 'jlbogowonto_mike', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 99, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (770, 'Fitriana Dewi lestari', '105010279', 'fitrianadwi@bytehome.id', '25-10-19', 5, 'Rusunawa Semeru ', '81249372023', 'Aktif', 0, '', '', 1761272802, 'PPPOE', 'rusunawa_fitrii', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 20, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (771, 'Sri Kanti', '105010280', 'srikantipro@bytehome.id', '25-10-20', 5, 'GG Tetes Mentor ', '81227377130', 'Aktif', 0, '', '', 1761272966, 'PPPOE', 'ggtetes_srikanti', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 205, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (772, 'Vina Anggita Dewi', '105030089', 'vinaanggita@bytehome.id', '25-10-21', 5, 'Legundi Bantaran ', '85784330643', 'Aktif', 0, '', '', 1761287522, 'PPPOE', 'legundi_vina', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 227, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (773, 'Shohibul Haq', '105020364', 'shohibulhaqq@bytehome.id', '25-10-24', 5, 'Jl Mastrip ', '85231170822', 'Aktif', 0, '', '', 1761287733, 'PPPOE', 'jlmastrip_shohibul', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 249, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (774, 'Lilis Indrawati', '105020365', 'lilisindrawati@bytehome.id', '25-10-22', 5, 'Jl Ikan Hiiu Mayangan ', '85230523277', 'Aktif', 0, '', '', 1761287992, 'PPPOE', 'ikanhiu_lilis', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 158, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (775, 'Supeno', '105020366', 'supeno@bytehome.id', '25-10-22', 5, 'JL Cangkring ', '81252405743', 'Aktif', 0, '', '', 1761288116, 'PPPOE', 'cangkring_supeno', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 223, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (776, 'Ahmad Agus Sholihin', '105010281', 'agussholihin@bytehome.id', '25-10-23', 5, 'Gunung Batur Kademangan ', '85785470865', 'Aktif', 0, '', '', 1761288420, 'PPPOE', 'gunungbatur_agus', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 72, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (777, 'Pandu Hendra Winata', '105030090', 'pandubantaran@bytehome.id', '25-10-23', 5, 'Jl Raya Bantaran ', '81334027797', 'Aktif', 0, '', '', 1761288726, 'PPPOE', 'jlrayabantaran_pandu', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 175, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (778, 'Dwi Nur Erika', '105020367', 'dwinurerika@bytehome.id', '25-10-24', 5, 'GG Pesantren Wonoasih ', '87859159873', 'Aktif', 0, '', '', 1761294504, 'PPPOE', 'wonoasih_erika', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 16, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (779, 'Yuliatin', '105010282', 'yuliatiiin@bytehome.id', '25-10-24', 5, 'Triwunglor ', '83867533756', 'Aktif', 0, '', '', 1761295362, 'PPPOE', 'triwunglor_yuliatin', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 138, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (780, 'Muhammad Wahyudi', '105020368', 'wahyudiiii@bytehome.id', '25-10-24', 5, 'Jrebenglor ', '82230704266', 'Aktif', 0, '', '', 1761295742, 'PPPOE', 'jrebenglor_wahyudi', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 68, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (781, 'Ahmad Sholeh', '105020369', 'sholehcangkring@bytehome.id', '25-10-24', 5, 'Jl Cangkring ', '85233387844', 'Aktif', 0, '', '', 1761295854, 'PPPOE', 'cangkring_sholeh', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 223, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (782, 'Nayla Puspa Hayu R Dhani', '105010283', 'naylapro@bytehome.id', '25-09-28', 5, 'Jl Cimanuk Kademangan ', '85836009671', 'Aktif', 0, '', '', 1761366144, 'PPPOE', 'cimanuk_nayla', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 291, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (783, 'Buasih', '105010284', 'buasih@bytehome.id', '25-09-29', 5, 'Jl Cimanuk Kademangan ', '82245104335', 'Aktif', 0, '', '', 1761366363, 'PPPOE', 'cimanuk_buasih', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 291, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (784, 'Anik Rismawati', '105040002', 'anikrismawati@bytehome.id', '25-09-30', 5, 'Perum Griya Idaman Recidence', '85129506226', 'Aktif', 0, '', '', 1761366558, 'PPPOE', 'griyaidaman_anik', 5565, 121, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 8, 0, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (785, 'M Jayadi', '105040003', 'jayadi@bytehome.id', '25-09-30', 5, 'Perum Griya Idaman Recidence ', '895338325407', 'Aktif', 0, '', '', 1761367908, 'PPPOE', 'griyaidaman_jayadi', 5565, 121, 1, 'KTP', 10, 0, 0, '', '', 'paket 15Mbps', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 8, 296, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (786, 'Ongki Putra', '105040004', 'ongkyputra@bytehome.id', '25-10-01', 5, 'Jl Kaliamas Dringu ', '81226142221', 'Aktif', 0, '', '', 1761368158, 'PPPOE', 'jlkaliamas_ongki', 5565, 121, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 8, 297, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (787, 'Farid Widiyatmoko', '105040005', 'faridpro@bytehome.id', '25-10-02', 5, 'Dsn Nenek  Indah ringu ', '82233430123', 'Aktif', 0, '', '', 1761368287, 'PPPOE', 'dsnnenek_farid', 5565, 121, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 8, 298, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (788, 'Hariyanto', '105040006', 'hariyantoop@bytehome.id', '25-10-25', 5, 'Dsn Nenek  Indah ringu ', '85235526574', 'Aktif', 0, '', '', 1761368438, 'PPPOE', 'dringu_hariyanto', 5565, 121, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 8, 298, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (789, 'Mohammad Alfian', '105040007', 'alfiannn@bytehome.id', '25-10-03', 5, 'Dsn Nenek Indah Dringu ', '83113208136', 'Aktif', 0, '', '', 1761368827, 'PPPOE', 'dsnenek_alfian', 5565, 121, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 8, 297, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (790, 'Novia Eka Budi', '105010285', 'noviaeka@bytehome.id', '25-10-04', 5, 'Jl Cimanuk Perum Mahameru ', '81382719910', 'Aktif', 0, '', '', 1761369078, 'PPPOE', 'cimanuk_buadi', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 291, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (791, 'Arianto Efendi', '105030091', 'ariantoefendi@bytehome.id', '25-10-06', 5, 'Karanganyar Bantaran ', '87889291204', 'Aktif', 0, '', '', 1761369314, 'PPPOE', 'bantaran_arianto', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 299, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (792, 'Agus Heri Irianto', '105020370', 'heriirianto@bytehome.id', '25-10-07', 5, 'Jl Sunan Giri ', '82331337339', 'Aktif', 0, '', '', 1761369728, 'PPPOE', 'sunangiri_agus', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 300, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (793, 'Mohammad Agus', '105010286', 'agustales@bytehome.id', '25-10-08', 5, 'Jl Tales Kademangan ', '87705575540', 'Aktif', 0, '', '', 1761369953, 'PPPOE', 'jltales_agus', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 301, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (794, 'Very', '105020371', 'verypro@bytehome.id', '25-10-11', 5, 'Jl Mastrip', '81232738604', 'Aktif', 0, '', '', 1761370076, 'PPPOE', 'jlmastrip_very', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 302, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (795, 'Abdul Muqtadir', '105020372', 'abdulmuqtadir@bytehome.id', '25-10-25', 5, 'Jl Ikan Hiu Mayangan ', '895110088882', 'Aktif', 0, '', '', 1761370367, 'PPPOE', 'ikanhiu_muqtadir', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 303, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (796, 'Luluk Isyamsih', '105020373', 'lulukis@bytehome.id', '25-10-25', 5, 'Jl Sunan ampel ', '85602114883', 'Aktif', 0, '', '', 1761370513, 'PPPOE', 'sunanampel_luluk', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 304, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (797, 'Arik Suswati', '105020374', 'ariksus@bytehome.id', '25-10-25', 5, 'Jl Sunan ampel ', '82245913367', 'Aktif', 0, '', '', 1761370621, 'PPPOE', 'sunanampel_arik', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 304, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (798, 'Galih Wahyu', '105020375', 'galihwahyu@bytehome.id', '25-10-18', 5, 'Jl Sunan Kalijaga Perum Blue safir', '085385639407', 'Aktif', 0, '', '', 1761370820, 'PPPOE', 'sunankalijaga_galih', 0, 6, 1, 'KTP', 10, 0, 62, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 305, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (799, 'Jumaali', '105010287', 'jumaali@bytehome.id', '25-10-20', 5, 'Banjarsari', '85228529129', 'Aktif', 0, '', '', 1761373870, 'PPPOE', 'banjarsari_jumaali', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 306, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (800, 'Lisa Yulianti', '105020376', 'lisagatot@bytehome.id', '25-10-20', 5, 'Jl Walikotagatot', '85234222871', 'Aktif', 0, '', '', 1761373993, 'PPPOE', 'gatot_lisa', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 307, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (801, 'Marsono', '105030092', 'marsono@bytehome.id', '25-10-21', 5, 'Dsn Kaporan ', '82337771881', 'Aktif', 0, '', '', 1761374112, 'PPPOE', 'dsnkaporan_marsono', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 5, 308, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (802, 'Abdul Karim', '105010288', 'abdulkarim@bytehome.id', '25-10-21', 5, 'Jl Tambora ', '85165717833', 'Aktif', 0, '', '', 1761374232, 'PPPOE', 'jltambora_karim', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 309, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (803, 'Alda Arlina S', '105010289', 'aldapro@bytehome.id', '25-10-22', 5, 'Jl Citarum ', '81230675723', 'Aktif', 0, '', '', 1761374551, 'PPPOE', 'jlcitarum_alda', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 310, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (806, 'Devi', '105020377', 'devipro@bytehome.id', '25-10-06', 5, 'Jl Kh Hasan Genggong ', '81334734811', 'Aktif', 0, '', '', 1761546897, 'PPPOE', 'genggong_devi', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 311, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (807, 'Fausi', '105030093', 'fausilegundi@bytehome.id', '25-10-27', 5, 'Legundi Bantaran', '89527846741', 'Aktif', 0, '', '', 1761547009, 'PPPOE', 'legundi_fausi', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 227, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (808, 'Titis Purmaningsih', '105010290', 'titispurba@bytehome.id', '25-10-27', 5, 'Triwunglor ', '89527846741', 'Aktif', 0, '', '', 1761547199, 'PPPOE', 'triwunglor_titis', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 47, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (809, 'Firman', '105020378', 'firmanhiu@bytehome.id', '25-10-25', 5, 'Jl Ikan Hiu Mayangan ', '85188690204', 'Aktif', 0, '', '', 1761548680, 'PPPOE', 'ikanhiu_firman', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 312, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (810, 'Lilik Yuliati', '105010291', 'lilikyul@bytehome.id', '25-10-26', 5, 'Jl Kelud ', '82142867350', 'Aktif', 0, '', '', 1761548873, 'PPPOE', 'jlkelud_yuliati', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 6, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (811, 'Septina', '105010292', 'septinajlkeld@bytehome.id', '25-10-26', 5, 'Jl Kelud', '81210331959', 'Aktif', 0, '', '', 1761548969, 'PPPOE', 'jlkelud_septiana', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 6, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (812, 'Suparmi', '105010293', 'suparmi@bytehome.id', '25-10-31', 5, 'Jl Cimanuk', '81092891819', 'Aktif', 0, '', '', 1761883621, 'PPPOE', 'cimanuk_suparmi', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 291, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (813, 'Rudi Prastyo', '105010294', 'wiratama.prasetya@gmail.com', '25-11-02', 0, 'JL.WIJAYA KUSUMA NO.90B', '85649917118', 'Menunggu', 0, '3508191011830010', '', 1762079214, '', 'jlwijayakusuma_rudi ', 0, 0, 0, 'KTP', 0, 0, 0, '', '', '', 0, 0, 0, 0, 0, 0, '', 0, '', 0, 0, 0, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (814, 'Yuni Wulandari', '105020379', 'yuniwulandari48373@gmail.com', '25-11-04', 0, ' Jl. Mastrip Gg 1 RT/RW 003/013 kel. Kanigaran, Kec. Kanigaran Kota Probolinggo', '89530118471', 'Menunggu', 0, '3574035306020010', '', 1762249393, '', 'jlmastrip_yuni ', 0, 0, 0, 'KTP', 0, 0, 0, '', '', '', 0, 0, 0, 0, 0, 0, '', 0, '', 0, 0, 0, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (815, 'Bambang wisnu dwi wardhana', '105010295', 'bambangwdw54@gmail.com', '25-11-07', 0, ' Jalan raya bromo kelurahan triwung kidul kota probolinggo', '81357383093', 'Menunggu', 0, '3515121502780000', '', 1762508986, '', '', 0, 0, 0, 'KTP', 0, 0, 0, '', '', '', 0, 0, 0, 0, 0, 0, '', 0, '', 0, 0, 0, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 0, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (816, 'Muhlis Ardiansyah', '105050038', 'muhlisardiansyah@bytehome.id', '25-11-11', 5, 'Dsn. Gunung Tugel Ds. Curahtulis', '81553299719', 'Aktif', 0, '', '', 1762829173, 'PPPOE', 'gunungtugel_muhlis', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 3797, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (817, 'Meli Serlivia', '105050039', 'meliserlivia@bytehome.id', '25-11-17', 5, 'Dsn. Krajan Ds. Curahtulis', '857067392620', 'Aktif', 0, '', '', 1763346635, 'PPPOE', 'krajantongas_serlivia', 3797, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 3797, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (818, 'Abd. alim', '105050040', 'abdalim@bytehome.id', '25-10-28', 5, 'Dsn. Krajan Ds. Curahtulis', '85258791731', 'Aktif', 0, '', '', 1763346944, 'PPPOE', 'curahtulis_alim', 3797, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 3797, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (819, 'Luluk Musrifah', '105050041', 'lulukmusrifah@bytehome.id', '25-11-17', 5, 'Dsn. Krajan Ds. Curahtulis', '085607213059', 'Aktif', 0, '', '', 1763347965, 'PPPOE', 'curahtulis_musrifah', 0, 1, 1, 'KTP', 16, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 2, 1, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 3797, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (820, 'Nadifa', '105020380', 'nadifapangsud@bytehmo.id', '25-11-19', 5, 'Jl Panglima Sudirman', '87844168415', 'Aktif', 0, '', '', 1763519811, 'PPPOE', 'pangsud_nadifa', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 91, 15, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (821, 'Bima Yogi Basuseno', '105020381', 'basuseno@bytehome.id', '25-10-27', 5, 'JL Cangkring', '89522111666', 'Aktif', 0, '', '', 1763520853, 'PPPOE', 'cangkring_bima', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 104, 12, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (822, 'Nanik Kusmiarsini', '105020382', 'nanikpro@bytehome.id', '25-11-27', 5, 'Jl Cangkring ', '82143804663', 'Aktif', 0, '', '', 1763522057, 'PPPOE', 'cangkring_nanik', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 104, 13, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (823, 'Didik Arifin', '105010296', 'didikari@bytehome.id', '25-10-27', 5, 'Jl Kalimas', '81462307379', 'Aktif', 0, '', '', 1763691595, 'PPPOE', 'jlkalimas_didik', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 168, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (824, 'Hery Sugianto', '105020383', 'herysugianto@bytehome.id', '25-10-28', 5, 'Jl Hasyim Ashari ', '85385535487', 'Aktif', 0, '', '', 1763692165, 'PPPOE', 'jlhasyim_heri', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 231, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (825, 'Holipa', '105030094', 'holipaban@bytehome.id', '25-10-28', 5, 'Banataran', '85258497292', 'Aktif', 0, '', '', 1763692501, 'PPPOE', 'bantaran_holipa', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 240, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (826, 'Yuliana', '105010297', 'yulianapro@byteome.id', '25-11-28', 5, 'Jl Raya Bromo ', '82257157224', 'Aktif', 0, '', '', 1763692709, 'PPPOE', 'jlrayabromo_yuliana', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 7, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (827, 'Joko Irawan', '105030095', 'jokoirawanpro@bytehome.id', '2025-10-29', 5, 'kedungsupit', '085704104213', 'Aktif', 0, '0', '', 1763692864, 'PPPOE', '', 0, 7, 1, 'KTP', 10, 0, 62, '', '', '', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 254, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (828, 'Ahmad Zainul', '105020384', 'ahmadzainul@bytehome.id', '25-10-29', 5, 'Jl Kh Hasyim Ashari ', '82228688353', 'Aktif', 0, '', '', 1763693153, 'PPPOE', 'jlhasyim_zainul', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 231, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (829, 'Holila', '105010298', 'holilapro@bytehome.id', '25-10-29', 5, 'lemahkembar ', '82332505478', 'Aktif', 0, '', '', 1763693274, 'PPPOE', 'lemahkembar_holila', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 132, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (830, 'M Rudi Nabillah', '105020385', 'mrudinab@bytehome.id', '25-11-21', 5, 'Jrebenglor ', '85853482773', 'Aktif', 0, '', '', 1763694329, 'PPPOE', 'jrebenglor_rudi', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 78, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (831, 'Saulus Hari Gunawan', '105020386', 'saulus@bytehome.id', '25-11-21', 5, 'Sukoharjo ', '81336852599', 'Aktif', 0, '', '', 1763694934, 'PPPOE', 'sukoharjo_saulus', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 112, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (832, 'Lil Ykayanti', '105010299', 'lilykyanti@bytehome.id', '25-11-04', 5, 'Sumberwetan ', '81216127395', 'Aktif', 0, '', '', 1763695096, 'PPPOE', 'sumberwetan_lilykayanti', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 60, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (833, 'Ghaitsa Zahira', '105020387', 'ghaitsa@bytehome.id', '25-11-04', 5, 'Jl Ir suratmi', '85790345737', 'Aktif', 0, '', '', 1763695863, 'PPPOE', 'irsutmi_ghaitsa', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 17, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (834, 'Mohammad Rafi', '105020388', 'rafiii@bytehome.id', '25-11-21', 5, 'Jl. Ikan Hiu Mayangan', '895413531221', 'Aktif', 0, '', '', 1763698060, 'PPPOE', 'ikanhiu_rafii', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 312, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (835, 'ETI', '105030096', 'etipro@bytehome.id', '25-11-05', 5, 'Kropak Bantaran ', '083166987625', 'Aktif', 0, '', '', 1763698244, 'PPPOE', 'kropak_eti', 0, 7, 1, 'KTP', 10, 0, 62, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 157, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (836, 'Kusnoadi', '105030097', 'kusnoadipro@bytehome.id', '25-11-06', 5, 'Jl Raya Bantaran ', '81264588132', 'Aktif', 0, '', '', 1763698617, 'PPPOE', 'kusnoadii_bantaran', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 266, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (837, 'T Nurul Hasanah', '105010300', 'nurulhasaanah@bytehome.id', '25-11-06', 5, 'Rusunawa Semeru ', '85288780408', 'Aktif', 0, '', '', 1763698795, 'PPPOE', 'rusunawa_nurul', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 20, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (838, 'Lusiana', '105020389', 'lusianapro@bytehome.id', '25-11-06', 5, 'Jl Amir Hamzah', '89509739141', 'Aktif', 0, '', '', 1763698958, 'PPPOE', 'jlamirhamzah_lusiana', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 79, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (839, 'Sukarti', '105020390', 'sukartipro@bytehome.id', '25-11-06', 5, 'Jl Hasyim Ashari ', '85138510958', 'Aktif', 0, '', '', 1763709823, 'PPPOE', 'jlhasyim_sukarti', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 96, 8, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (840, 'Dhenny Liska Milasari', '105030098', 'dhennylis@bytehome.id', '25-11-21', 5, 'Jl Citarum ', '81330764744', 'Aktif', 0, '', '', 1763710029, 'PPPOE', 'jlcitarum_dhenny', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 3, 289, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (841, 'Moch Ridhwan Prasetyo', '105020391', 'ridhwanprasetyo@bytehome.id', '25-11-07', 5, 'Jl Ikan Paus GG Nur ', '085157762569', 'Aktif', 0, '', '', 1763710172, 'PPPOE', 'ikanpaus_ridwan', 0, 6, 1, 'KTP', 10, 0, 62, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 312, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (842, 'Mochammad Hoiron Ludvi', '105010301', 'ludvi@bytehome.id', '2025-10-07', 5, 'Jl Seruni', '08990157621', 'Aktif', 0, '', '', 1763710555, 'PPPOE', 'sukabumi_ludvi', 0, 5, 1, 'KTP', 17, 0, 62, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 44, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (843, 'Teguh Dwi', '105010302', 'teguhdwipro@bytehome.id', '2025-11-08', 5, 'Pilang kademangan ', '082334011999', 'Aktif', 0, '', '', 1763714517, 'PPPOE', 'pilang_teguh', 0, 5, 1, 'KTP', 17, 0, 62, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 134, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (844, 'TK AR RUHAMA', '105030099', 'sitiproo@bytehome.id', '2025-11-08', 5, 'Jl Raya Bantaran ', '085259148477', 'Aktif', 0, '', '', 1763714730, 'PPPOE', 'bantaran_sitii', 0, 7, 1, 'KTP', 10, 0, 62, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 155, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (845, 'Moch Suryadi', '105010303', 'suryadipro@bytehome.id', '2025-11-08', 5, 'Pilang ', '085335140431', 'Aktif', 0, '', '', 1763715069, 'PPPOE', 'pilang_suryadi', 0, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 134, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (846, 'Musa', '105010304', 'musapro@bytehome.id', '2025-11-08', 5, 'Jl KH Fadhol Kademangan ', '089524370029', 'Aktif', 0, '', '', 1763715432, 'PPPOE', 'jlkhfadhol_musa', 0, 5, 1, 'KTP', 17, 0, 62, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 169, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (847, 'Yudistira Wardana', '105020392', 'yudistirapro@bytehome.id', '25-11-09', 5, 'Jl Letjen Suprapto ', '87852801905', 'Aktif', 0, '', '', 1763715720, 'PPPOE', 'jlletjen_yudistira', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 96, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (848, 'Abdur Rohim', '105010305', 'rohimsumur@bytehome.id', '25-11-10', 5, 'Sumur Mati', '85607648357', 'Aktif', 0, '', '', 1763716107, 'PPPOE', 'sumurmati_rohim', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 278, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (849, 'Wasusiana', '105020393', 'wasusiana@bytehome.id', '25-11-22', 5, 'GG Bingkilan', '85733562572', 'Aktif', 0, '', '', 1763774843, 'PPPOE', 'ggbingkilan_wasusiana', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 115, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (850, 'Yupianto', '105010306', 'yupiantopro@bytehome.id', '25-11-12', 5, 'Jl Cempaka Sukabumi', '85934583348', 'Aktif', 0, '', '', 1763774957, 'PPPOE', 'jlcempaka_yupianto', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 98, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (851, 'Widyo Hutomo', '105030100', 'widyohutomo@bytehome.id', '25-11-12', 5, 'Tempuran Bantaran ', '82335768673', 'Aktif', 0, '', '', 1763775063, 'PPPOE', 'tempuran_widyo', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 229, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (852, 'Bulan Anantasya', '105010307', 'bulananantasya@bytehome.id', '25-11-12', 5, 'Jl Cisadane ', '85853234931', 'Aktif', 0, '', '', 1763775186, 'PPPOE', 'jlcisadane_bulan', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 34, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (853, 'Lisa Tri Yulia Ningrum', '105020394', 'lisapro@bytehome.id', '25-11-12', 5, 'Perum Grandhilton  ', '81358971750', 'Aktif', 0, '', '', 1763775299, 'PPPOE', 'grandhilton_lisa', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 39, 9, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (854, 'Windy Indrawati', '105010308', 'windyindra@bytehome.id', '25-11-13', 5, 'Perum Cisadane Indah', '81334272598', 'Aktif', 0, '', '', 1763775584, 'PPPOE', 'cisadane_windy', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 35, 6, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (855, 'Margiana', '105020395', 'margianapro@bytehome.id', '25-11-13', 5, 'Simpang 5 Mayangan ', '82330534096', 'Aktif', 0, '', '', 1763775736, 'PPPOE', 'mayangan_margiana', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 64, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (856, 'Putri Ajeng', '105010309', 'putriajeng@bytehome.id', '25-11-13', 5, 'Sumurmati ', '87743269407', 'Aktif', 0, '', '', 1763775959, 'PPPOE', 'sumurmati_putrii', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 278, 5, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (857, 'Joko Andrias', '105040008', 'jokoandrias@bytehome.id', '25-11-15', 5, 'Perum AL Fatah 2 No A5 Dringu ', '82336109172', 'Aktif', 0, '', '', 1763776462, 'PPPOE', 'dringu_andrias', 0, 121, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 8, 295, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (858, 'Miswati', '105020396', 'miswatipro@bytehome.id', '25-11-17', 5, 'Jl Ahmad Yani ', '81252794892', 'Aktif', 0, '', '', 1763776930, 'PPPOE', 'ahmadyani_miswati', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 312, 4, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (859, 'Denny Pasha', '105010310', 'dennypasha@bytehome.id', '25-11-17', 5, 'Rusunawa Semeru ', '89668037351', 'Aktif', 0, '', '', 1763777065, 'PPPOE', 'rusunawa_denny', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 20, 7, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (860, 'Hosnafia', '105030101', 'hosnafiapro@bytehome.id', '25-11-17', 5, 'Patokan Bantaran ', '82229974177', 'Aktif', 0, '', '', 1763777178, 'PPPOE', 'patokan_hosnafia', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 308, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (861, 'Lia Putri', '105010311', 'liaputri@bytehome.id', '25-11-17', 5, 'Jl Raya Bromo ', '85755598241', 'Aktif', 0, '', '', 1763777539, 'PPPOE', 'jlrayabromo_lia', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 3, 7, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (862, 'Ali Hurrozim', '105020397', 'hurrozim@bytehome.id', '25-11-19', 5, 'Jl Sultan Agung', '82142881383', 'Aktif', 0, '', '', 1763780768, 'PPPOE', 'sultanagung_ali', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 18, 15, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (863, 'Mas Miliati', '105010312', 'masmiliati@bytehome.id', '25-11-20', 5, 'Jl Soekarno hatta Gg delima', '85880037899', 'Aktif', 0, '', '', 1763780890, 'PPPOE', 'ggdelima_miliati', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 134, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (864, 'Muhammad Jakfar sodiq', '105010313', 'jakfarpro@bytehome.id', '25-11-20', 5, 'Jl Flamboyan ', '85185999071', 'Aktif', 0, '', '', 1763781784, 'PPPOE', 'jlflamboyan_jakfar', 5565, 5, 1, 'KTP', 17, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 3, 93, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (865, 'Rasid', '105020398', 'wahyukurni@bytehome.id', '25-11-21', 5, 'JL Sunan kalijaga perum blue safir, B6', '85336025243', 'Aktif', 0, '', '', 1763781965, 'PPPOE', 'sunankalijaga_kurni', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 305, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (866, 'Muhammad Rofi kurniawan', '105020399', 'rofikurniawan@bytehome.id', '25-10-28', 5, 'Jl Sunan Bonang ', '8977227011', 'Aktif', 0, '', '', 1763948922, 'PPPOE', 'jlsunanbonang_rofi', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 313, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (867, 'M Hairul Anam', '105020400', 'mhairulanam@bytehome.id', '25-10-30', 5, 'Jl Bogowonto ', '85943733940', 'Aktif', 0, '', '', 1763949100, 'PPPOE', 'bogowonto_hairul', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 314, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (868, 'Nurul Fadillah', '105020401', 'nurfad@bytehome.id', '25-10-30', 5, 'Jl Bogowonto ', '82229787232', 'Aktif', 0, '', '', 1763949304, 'PPPOE', 'bogowonto_nurfad', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 1, 125000, '', 0, '', 0, 4, 314, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (869, 'M Rifki', '105030102', 'mrifki@bytehome.id', '25-11-22', 5, 'Patokan Bantaran ', '89690785080', 'Aktif', 0, '', '', 1763958455, 'PPPOE', 'patokan_rifki', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 5, 269, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (870, 'Nur Hayati', '105030103', 'nurhayati@bytehome.id', '25-11-24', 5, 'Patokan Bantaran ', '83873508634', 'Aktif', 0, '', '', 1763958626, 'PPPOE', 'patokan_hayati', 5565, 7, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 5, 269, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (871, 'Endang Tri Winarsih', '105020402', 'endangtri@bytehome.id', '25-11-06', 5, 'Jrebengkulo (curahgrinting)', '85257629378', 'Aktif', 0, '', '', 1763960391, 'PPPOE', 'jrebengkulon_endang', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 314, 3, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (872, 'Dewi Nurifatun Nafisah', '105020403', 'nurifatun@bytehome.id', '2025-11-10', 5, 'Jl Pahlawan ', '85330217625', 'Aktif', 0, '', '', 1763960589, 'PPPOE', 'jlpahlawan_nurifatun', 0, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 315, 0, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (873, 'Albastomi Firmansyah', '105020404', 'albastomy@bytehome.id', '25-11-11', 5, 'Perum Hesny', '85854635037', 'Aktif', 0, '', '', 1763960778, 'PPPOE', 'perumhesny_albastomi', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 316, 1, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (874, 'Samsul Arfin', '105020405', 'arifinpro@bytehome.id', '25-11-15', 5, 'Jl Cangkring GG 7 ', '85185943653', 'Aktif', 0, '', '', 1763960923, 'PPPOE', 'cangkring_arifin', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Signature', 1, 0, 1, 0, 0, 165000, '', 0, '', 0, 4, 313, 2, 0, '', '', 0, 0, 0, '', 0, 0, '', '', '', 0, 5565, '', 0, 0);
INSERT INTO `customer` (`customer_id`, `name`, `no_services`, `email`, `register_date`, `due_date`, `address`, `no_wa`, `c_status`, `ppn`, `no_ktp`, `ktp`, `created`, `mode_user`, `user_mikrotik`, `mitra`, `coverage`, `auto_isolir`, `type_id`, `router`, `codeunique`, `phonecode`, `latitude`, `longitude`, `user_profile`, `action`, `type_payment`, `max_due_isolir`, `olt`, `connection`, `cust_amount`, `mac_address`, `level`, `cust_description`, `type_ip`, `id_odc`, `id_odp`, `no_port_odp`, `month_due_date`, `serial_number`, `pass_mikrotik`, `slot`, `port`, `onu_index`, `onu_type`, `vlan`, `send_bill`, `no_va`, `up_onu`, `down_onu`, `customer_mitra`, `createby`, `uuid`, `nomorcodeuniq`, `mediaconnection`) VALUES (875, 'Chika Dwi Ayuni', '105020406', 'chikadwi@bytehome.id', '25-11-18', 5, 'Jl Pattimura Mayangan ', '81246784925', 'Aktif', 0, '', '', 1763961182, 'PPPOE', 'mayangan_chika', 5565, 6, 1, 'KTP', 10, 0, 0, '', '', 'Essential', 1, 0, 1, 0, 0, 125000, '', 0, '', 0, 4, 317